
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   FRENMOV.PAS                   }
{                                                 }
{   The Star Commander file rename or move unit   }
{*************************************************}

unit FRenMov;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Dialogs;

function RenMovFile(var D: PDialog; First: Boolean): Boolean;

implementation

uses
  DOS, Drivers, Objects, Views,
  Base1, Base2, Constant, ExtFiles, FCopy, FDelete, FWPrep, LowLevel, Panel1, Panel2, XferLo;

{Determine if the destination file is on the same drive and, for files
  in image or archive files, in the same image or archive file as the
  source file, in which case rename is done rather than move
  Output: when True, rename is done, otherwise move}
function RenamingFile: Boolean;
var
  O             : Boolean;
  S,
  T             : string;
begin
  O := ((DestArchType = pmDOS) and (Act^.CopyMode = Inact^.CopyMode));
  if O then
  begin
    if Act^.CopyMode = pmExt then
    begin
      O := (Copy(Act^.CopyRealPath, 1, 2) = Copy(Inact^.CopyRealPath, 1, 2));
    end
    else
    begin
      S := UpperCase(TrueName(Act^.CopyRealPath));
      T := UpperCase(TrueName(Inact^.CopyRealPath));
      O := (Copy(S, 1, 2) = Copy(T, 1, 2));
      if O then
      begin
        if Copy(S, 1, 2) = '\\' then
        begin
          S := Copy(S, 3, MaxStrLen);
          T := Copy(T, 3, MaxStrLen);
          O := (Copy(S, 1, LeftPos(chDirSep, S)) = Copy(T, 1, LeftPos(chDirSep, T)));
        end;
      end;
      if O then
      begin
        if Act^.CopyMode = pmDOS then O := ((Act^.CopyAttr and Directory = 0) or Inact^.SameAsPanel) else
          if GetPanelModeAttrib(Act^.CopyMode, (paImage + paArchive)) then
            O := ((S = T) and (Act^.CopyImageName = Inact^.CopyImageName));
      end;
    end;
  end;
  RenamingFile := O;
end;

{Change the name of the image currently displayed in the panel, if the image
  file has been renamed
  Input : Panel: the panel to check}
procedure ChangeImageName(Panel: PPanel);
begin
  if (Panel^.Path = Act^.CopyRealPath) and (Panel^.ImageName = Act^.CopyImageName) then
    Panel^.ImageName := Inact^.CopyImageName;
end;

{Change the name of the file under the cursor in the panel, if it has been
  renamed; in the case of the active panel, always reflect file name changes
  on the screen
  Input : Panel: the panel to check}
procedure ChangeNameUnder(Panel: PPanel);
var
  I,
  J,
  K             : Integer;
  X             : PString;
begin
  if (Panel = Act) and (CopyFileMode <> cfWildcard) then
  begin
    X := Panel^.GetNamePtr(CopyFileNum);
    I := Length(Inact^.CopyName) - Length(X^);
    if I <> 0 then
    begin
      if (I > 0) and (Panel^.NameEnd + I > SizeOf(TNameBuffer)) then Dec(Panel^.Max);
      if CopyFileNum + 1 < Panel^.Max then
      begin
        J := Panel^.Dir[CopyFileNum].Name + Length(X^) + 1;
        Move(Panel^.Names[J], Panel^.Names[I + J], Panel^.NameEnd - J);
        for K := 0 to Panel^.Max - 1 do if Panel^.Dir[K].Name >= J then Inc(Panel^.Dir[K].Name, I);
      end;
      Inc(Panel^.NameEnd, I);
    end;
    Move(Inact^.CopyName, X^, Length(Inact^.CopyName) + 1);
  end;
  if Panel^.CopyName = Panel^.Under then Panel^.Under := Inact^.CopyName;
end;

{Rename or move the specified file during file rename or move
  Input : D: the dialog box that informs the user about the process
          First: when True, this is the first file being copied
  Output: when False, an error occured}
function RenMovFile(var D: PDialog; First: Boolean): Boolean;
var
  A,
  F,
  G,
  O,
  Q             : Boolean;
  P             : Byte;
  C             : Char;
  W             : Word;
  I             : Integer;
  L,
  X,
  Y             : Longint;
  S,
  T             : string;
  Z             : TZIPEntry;
begin
  G := False;
  Q := False;
  PrepareWrite(D, False);
  A := RenamingFile;
  if A then
  begin
    if Act^.CopyMode = pmDOS then
    begin
      if Act^.CopyAttr and Directory = 0 then
      begin
        S := 'Rename';
        if not Inact^.SameAsPanel then S := 'Move';
        TransferProgressWin(D, S, Act^.CopyFullName, Inact^.CopyFullName, drFile, False);
      end
      else
      begin
        if Inact^.SameAsPanel then TransferProgressWin(D, 'Rename', Act^.CopyFullName, Inact^.CopyFullName,
          drDirectory, False);
      end;
    end
    else
    begin
      TransferProgressWin(D, 'Rename', Act^.CopyFullName, Inact^.CopyFullName, drFile, False);
    end;
    O := True;
    S := Inact^.CopyName;
    if (Act^.CopyName = S) and (TrueName(Act^.CopyRealPath) = TrueName(Inact^.CopyRealPath)) then
    begin
      G := True;
    end
    else
    begin
      if not GetPanelModeAttrib(Act^.CopyMode, paASCII) and (Length(Inact^.CopyName) > CBMNameLen) then
        Inact^.CopyName[0] := Chr(CBMNameLen);
      case Act^.CopyMode of
        pmDOS:
        begin
          while not Q do
          begin
            SysErrorOccurred := False;
            Inact^.CopyAttr := Act^.CopyAttr;
            Inact^.MakeFullName;
            if (Act^.CopyAttr and Directory = 0) and FileExists(Inact^.CopyFullName, False) then
            begin
              if not DeleteFile(Inact, D, True, True, False, False) or AppendFile then Q := True;
              if AppendFile then A := False;
            end;
            if A and not Q then
            begin
              LongRename(Act^.CopyFullName, Inact^.CopyFullName);
              I := IOResult;
              if I = 0 then
              begin
                FileProcessed := True;
                G := True;
              end
              else
              begin
                if SysErrorOccurred then
                  ContProcess := False
                else
                begin
                  if Act^.CopyAttr and Directory > 0 then S := 'directory' else S := 'file';
                  ContProcess := ErrorWin(stEmpty, 'Can''t rename the ' + S, Act^.CopyFullName, CurHelpCtx, sbNone)
                end;
              end;
            end;
            Q := True;
          end;
        end;
        pmExt:
        begin
          FileProcessed := True;
          MouseOff;
          DiskChanged := True;
          OpenCBMChannel(saCommand, 'R0:' + Inact^.CopyName + '=' + Act^.CopyName, True);
          O := ReadCBMError(S, False, False, True);
          if O then G := True else O := ErrorWin(stError, S, stEmpty, CurHelpCtx, sbNone);
          ContProcess := ContProcess and O;
        end;
      else
        FileProcessed := True;
        S := Inact^.CopyName;
        case Act^.CopyMode of
          pmTape: C := ' ';
          pmFile: C := #0;
        else
          C := chShiftSpace;
        end;
        if not GetPanelModeAttrib(Act^.CopyMode, paASCII) then while Length(S) < CBMNameLen do S := S + C;
        Inact^.MakeFullName;
        if Act^.OpenImage(False, False, True, True, True) = 0 then
        begin
          if Act^.ImageReadOnly then
          begin
            ContProcess := ErrorWin(stEmpty, 'The following image file is marked read-only.', Act^.CopyImageName,
              CurHelpCtx, sbNone);
            O := False;
          end
          else
          begin
            F := False;
            while not F and Act^.ReadCBMEntry(Entry) do F := ((Entry.Attr > 0) and (Entry.Name = Inact^.CopyName));
            Act^.CloseImage(False);
            if F then
            begin
              if GetPanelModeAttrib(Inact^.CopyMode, paDupeFiles) then
              begin
                O := (SureConfirm(stEmpty, stTheFollowing + 'file already exists',
                  Inact^.CopyFullName, 'Do you still wish to rename the file?', stEmpty,
                  ' '+ColorChar+'R'+ColorChar+'ename ', stEmpty, stEmpty, stSkip,
                  stEmpty, nil, CurHelpCtx, ayNone, False, DummyByte) = cmOK);
              end
              else
              begin
                ContProcess := ErrorWin(stEmpty, 'The following file already exists', Inact^.CopyFullName,
                  CurHelpCtx, sbNone);
                O := False;
              end;
            end;
            if O then
            begin
              if Act^.OpenImage(True, False, True, True, True) = 0 then
              begin
                X := ArcPos;
                F := Act^.SeekToNextFile(L);
                if F then
                begin
                  case Act^.CopyMode of
                    pmDisk:
                    begin
                      for P := 0 to CBMNameLen - 1 do Act^.DirBuffer[Act^.EntryPos + P + 5] := Ord(S[P + 1]);
                      Act^.WriteDiskBlock(Act^.DirTrack, Act^.DirSector, @Act^.DirBuffer);
                    end;
                    pmTape:
                    begin
                      for P := 0 to CBMNameLen - 1 do Act^.DirBuffer[P + 16] := Ord(S[P + 1]);
                      Act^.WriteTapeBlock(Act^.DirPos, @Act^.DirBuffer);
                    end;
                    pmFile:
                    begin
                      ExtSeek(Act^.Image, 8);
                      ExtBlockWrite(Act^.Image, S[1], Length(S));
                    end;
                    pmLynx, pmArkive, pmTAR, pmFileZip:
                    begin
                      if Length(S) > CBMNameLen then S[0] := Chr(CBMNameLen);
                      if Act^.CopyMode = pmArkive then Inc(L, 2);
                      ExtSeek(Act^.Image, L);
                      case Act^.CopyMode of
                        pmTAR:
                        begin
                          ExtBlockRead(Act^.Image, TempBuffer, 512);
                          FillChar(TempBuffer, 100, 0);
                          P := Entry.Attr and faTypeMask;
                          if P <> 2 then S := S + stDot + ShortCBMExt[P];
                          Move(S[1], TempBuffer, Length(S));
                          ComputeTARCheck(True);
                          ExtSeek(Act^.Image, L);
                          ExtBlockWrite(Act^.Image, TempBuffer, 512);
                        end;
                      else
                        ExtBlockWrite(Act^.Image, S[1], Length(S));
                      end;
                    end;
                    pmLHA, pmZIP:
                    begin
                      O := (LongOpenFile(AddToPath(Act^.CopyPath, TempFileName, chDirSep),
                        WriteFile, fmWriteOnly) = 0);
                      if O then
                      begin
                        TempFileOpen := True;
                        ExtSeek(Act^.Image, 0);
                        case Act^.CopyMode of
                          pmLHA:
                          begin
                            CopyPart(Act^.Image, WriteFile, L, TBufferSize);
                            LHAEntry.Name := S;
                            MakeLHAEntry;
                            ExtBlockWrite(WriteFile, TempBuffer, TempBuffer[0]);
                            Inc(L, LHAHeaderLen);
                            ExtSeek(Act^.Image, L);
                            CopyPart(Act^.Image, WriteFile, ExtFileSize(Act^.Image) - L, TBufferSize);
                          end;
                          pmZIP:
                          begin
                            W := 0;
                            Y := 0;
                            while O and (W < Act^.CopyImageSize) do
                            begin
                              O := ReadZIPEntry(Act^.Image, Z, T);
                              if O then
                              begin
                                if W = Act^.DirPos then
                                begin
                                  Y := Length(T) - Length(S);
                                  T := S;
                                  Z.NameLen := Length(T);
                                end;
                                ExtBlockWrite(WriteFile, Z, SizeOf(TZIPEntry));
                                ExtBlockWrite(WriteFile, T[1], Z.NameLen);
                                CopyPart(Act^.Image, WriteFile, Z.ExtHeadSize + Z.PackSize, TBufferSize);
                              end;
                              Inc(W);
                            end;
                            if O then
                            begin
                              W := 0;
                              while O and (W < Act^.CopyImageSize) do
                              begin
                                O := ReadZIPCDirEntry(Act^.Image, ZIPEntry, T);
                                if O then
                                begin
                                  if W = Act^.DirPos then
                                  begin
                                    T := S;
                                    ZIPEntry.NameLen := Length(T);
                                  end;
                                  if W > Act^.DirPos then Dec(ZIPEntry.HeaderOffs, Y);
                                  ExtBlockWrite(WriteFile, ZIPEntry, SizeOf(TZIPCDirEntry));
                                  ExtBlockWrite(WriteFile, T[1], ZIPEntry.NameLen);
                                  CopyPart(Act^.Image, WriteFile, ZIPEntry.ExtHeadSize + ZIPEntry.CommentSize, TBufferSize);
                                end;
                                Inc(W);
                              end;
                              if O then
                              begin
                                Dec(ZIPDirEnd.DirSize, Y);
                                Dec(ZIPDirEnd.DirOffs, Y);
                                ExtBlockWrite(WriteFile, ZIPDirEnd, SizeOf(TZIPCDirEnd));
                              end;
                            end;
                          end;
                        end;
                        if KeepTime then ExtSetFTime(WriteFile, Act^.FileTime);
                        ExtClose(WriteFile);
                        O := O and (IOResult = 0);
                      end;
                    end;
                  end;
                  G := True;
                end;
                Act^.CloseImage(True);
              end;
            end;
          end;
          case Act^.CopyMode of
            pmLHA, pmZIP:
            begin
              if O then
              begin
                LongErase(Act^.ImageName);
                LongRename(WriteFile.LongName, AddToPath(Act^.CopyPath, Act^.ImageName, chDirSep));
              end
              else
              begin
                LongErase(WriteFile.LongName);
              end;
              I := IOResult;
            end;
            pmFile:
            begin
              if O and (MakeFileExt(Act^.ImageName, stEmpty) <> MakeFileExt(Inact^.CopyImageName, stEmpty)) then
              begin
                LongRename(Act^.ImageName, AddToPath(Act^.CopyPath, Inact^.CopyImageName, chDirSep));
                I := IOResult;
                if I = 0 then
                begin
                  ChangeImageName(Act);
                  ChangeImageName(Inact);
                end;
              end;
            end;
          end;
        end;
      end;
    end;
    if G then
    begin
      if CursorFollowsFilename and Inact^.SameAsPanel then
      begin
        ChangeNameUnder(Act);
        ChangeNameUnder(Inact);
      end
      else
      begin
        FindNextUndel(Act);
      end;
    end;
    if A then UnselectFile(Act, G);
  end;
  if not A then
  begin
    O := CopyFile(D, First, True, True);
    if O then
    begin
      AppendFile := False;
      if not RunningShell then O := DeleteFile(Act, D, True, False, False, True);
    end;
    if (CopyExtractFileImages <> xfNever) and (Act^.CopyMode = pmFile) then Act^.CopyMode := pmDOS;
  end;
  RenMovFile := O;
end;

end.
