
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    FROPEN.PAS                   }
{                                                 }
{     The Star Commander open input file unit     }
{*************************************************}

unit FROpen;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

function OpenRead: Integer;

implementation

uses
  App, DOS, Drivers, Views,
  Base1, Base2, Constant, DOSShell, ExtFiles, LowLevel, MiscFunc, Panel1, Panel2, XferLo;

{Determine if a drive is a CD/DVD-ROM
  Input : Drive: the drive letter
  Output: when True, the drive is a CD/DVD-ROM}
function IsCDDrive(Drive: Char): Boolean; assembler;
asm
    mov cl, Drive;
    sub cl, 'A';
    xor ch, ch;
    mov ax, $150B;
    int $2F;
    mov cx, ax;
    xor al, al;
    cmp bx, $ADAD;
    jne @1;
    or cx, cx;
    je @1;
    inc al;
@1:
end;

{Open the file for input
  Output: when not 0, an error occured}
function OpenRead: Integer;
var
  B,
  F             : Boolean;
  T,
  S             : Byte;
  H,
  W,
  Y             : Word;
  I             : Integer;
  X             : Longint;
  N             : string;
begin
  with Act^ do
  begin
    B := (CopyFileMode in [cfSelected, cfSingle]);
    SysErrorOccurred := False;
    TurboOn := False;
    FileOpen := False;
    _End := False;
    Block := 0;
    I := 0;
    RetryCount := RetryNum + 1;
    case CopyMode of
      pmDOS:
      begin
        if ContProcess and (I = 0) then
        begin
          N := AddToPath(CopyPath, CopyName, chDirSep);
          LongGetFAttr(N, FileAttr);
          I := LongOpenFile(N, ReadFile, fmReadOnly);
          FileTime := ReadTime;
          if I = 0 then
          begin
            FileOpen := True;
            CopySize := ExtFileSize(ReadFile) shl 1;
            if IsCDDrive(CopyRealPath[1]) then FileAttr := FileAttr and not ReadOnly;
            N := LowerCase(FileExt(CopyName));
            ShellBuffer^.CopyAttr := faProgram;
            for S := faDeleted to faRelative do if N = ShortCBMExt[S] then ShellBuffer^.CopyAttr := S;
            CopyRecordLen := 0;
          end
          else
          begin
            if not SysErrorOccurred then ContProcess := ErrorWin(stEmpty, 'Can''t open the file', CopyFullName,
              CurHelpCtx, sbNone);
          end;
        end
        else
        begin
          ContProcess := False;
        end;
      end;
      pmExt:
      begin
        I := 255;
        if CopyGEOSFormat and (CopyExtAttr > 0) then
        begin
          ContProcess := ErrorWin(stError, 'Can''t copy GEOS files from Commodore disks.',
            'Copy the disk into a disk image first instead.', CurHelpCtx, sbNone);
        end
        else
        begin
          CBMDevNum := CopyCBMDev;
          SendConfigData;
          CopyDiskType := DetectDiskType(ExtendedDisk, FirstCopyFile);
          CheckDiskType;
          ShellBuffer^.CopyAttr := CopyAttr;
          if (CopyTransferMode <> tmNormal) and ValidPos(Track, Sector) then
          begin
            OpenCBMChannel(saCommand, 'I0', True);
            OpenCBMChannel(saCommand, 'M-W' + #$18 + #$00 + #$02 + Chr(Track) + Chr(Sector), True);
            FileOpen := True;
            I := 0;
          end
          else
          begin
            N := CopyName + ',' + UpCase(ShortCBMExt[CopyAttr and faTypeMask][1]);
            OpenCBMChannel(saLoad, N, True);
            if ReadCBMError(N, False, False, True) then
            begin
              FileOpen := True;
              I := 0;
              case CopyTransferMode of
                tmNormal:
                begin
                  Status := 0;
                  asm
                    mov al, saLoad;
                    call Talk;
                  end;
                end;
                tmTurbo, tmWarp:
                begin
                  OpenCBMChannel(saCommand, 'M-R' + #$18 + #$00 + #$02, True);
                  Status := 0;
                  asm
                    mov al, saCommand;
                    call Talk;
                    call Receive;
                    mov T, al;
                    call Receive;
                    mov S, al;
                    call Receive;
                    call Untalk;
                  end;
                  Track := T;
                  Sector := S;
                  FillChar(TrackMap, TrackMapSize + 1, 0);
                end;
              end;
            end
            else
            begin
              ContProcess := ErrorWin(stError, N, stEmpty, CurHelpCtx, sbSkip);
            end;
          end;
        end;
      end;
    else
      I := 255;
      if OpenImage(False, False, True, True, True) = 0 then
      begin
        FileOpen := True;
        CopyDiskType := GetDiskType(ExtFileSize(Image));
        CheckDiskType;
        ExtGetFTime(Image, FileTime);
        F := SeekToNextFile(X);
        if F and (Entry.Attr and faTypeMask = faFrozen) and (CopyMode = pmTape) and (Other^.CopyMode <> pmTape) then
          Entry.Attr := (Entry.Attr and not faTypeMask) or faProgram;
        if (Entry.Attr and faTypeMask = faFrozen) and (CopyMode = pmTape) and (Other^.CopyMode <> pmTape) then
          Entry.Attr := (Entry.Attr and not faTypeMask) or faProgram;
        ShellBuffer^.CopyAttr := Entry.Attr;
        CopyRecordLen := Entry.RecordLen;
        if F then
        begin
          I := 0;
          case CopyMode of
            pmDisk:
            begin
              Track := DirBuffer[EntryPos + 3];
              Sector := DirBuffer[EntryPos + 4];
              W := BytesToLongint(DirBuffer[EntryPos + 30], DirBuffer[EntryPos + 31], 0, 0);
              if Entry.Attr and faTypeMask = faRelative then
              begin
                if CopyDiskType and dtTypeMask = dt1581 then Dec(W);
                Y := W div (SideSecSize + 1);
                if W mod (SideSecSize + 1) > 0 then Inc(Y);
                Dec(W, Y);
              end;
              CopySize := Longint(W) * (254 shl 1);
            end;
            pmTape:
            begin
              StartLo := DirBuffer[2];
              StartHi := DirBuffer[3];
              X := ImagePos;
              ReadCBMEntry(Entry);
              CopySize := (ImagePos - X + 2) shl 1;
              ExtSeek(Image, X);
            end;
            pmFile:
            begin
              CopySize := (ExtFileSize(Image) - 26) shl 1;
              ExtSeek(Image, 26);
            end;
            pmLynx, pmArkive, pmTAR:
            begin
              case CopyMode of
                pmLynx, pmArkive:
                begin
                  if Entry.Attr and faTypeMask = faRelative then
                  begin
                    Y := Entry.Size div ((SideSecSize + 1) * 254);
                    if Entry.Size mod ((SideSecSize + 1) * 254) > 0 then Inc(Y);
                    Y := Y * 254;
                    Dec(Entry.Size, Y);
                    if CopyMode = pmLynx then Inc(ImagePos, Y);
                  end;
                end;
                pmTAR: FileTime := Entry.Time;
              end;
              ExtSeek(Image, ImagePos);
              CopySize := Entry.Size shl 1;
              Inc(ImagePos, Entry.Size);
            end;
            pmLHA, pmZIP:
            begin
              N := AddToPath(GetPanelTempPath, ArcTempUncomp, chDirSep);
              if TempUncompOpen then
              begin
                ExecMode := exNormal;
                CloseImage(False);
                if FileExists(N, False) then
                begin
                  I := LongOpenFile(N, Image, fmReadOnly);
                  if I = 0 then
                  begin
                    ExtSeek(Image, ImagePos);
                    CopySize := Entry.Size shl 1;
                    FileTime := Entry.Time;
                    Inc(ImagePos, Entry.Size);
                  end;
                end
                else
                begin
                  ErrorWin(stEmpty, 'Can''t uncompress the archive', CopyImageName, CurHelpCtx, sbNone);
                end;
              end
              else
              begin
                TempDialog := InfoWin(stEmpty, 'Uncompressing the archive', CopyImageName, stEmpty, 2);
                ShellBuffer^.ExecMode := exOpenRead;
                case CopyMode of
                  pmLHA: PutCommand('lha p -m2 -n2 ' + ShortName(AddToPath(CopyPath, CopyImageName, chDirSep), True) +
                    ' > ' + N + chCR + chLF, False);
                  pmZIP: PutCommand('unzip -o -p ' + ShortName(AddToPath(CopyPath, CopyImageName, chDirSep), True) +
                    ' > ' + N + chCR + chLF, False);
                end;
                RunningShell := True;
                CommandOutput := coSilent;
                TempUncompOpen := True;
                AttachInfo := False;
                SingleCommand := True;
                ClearCommand := True;
                PopupMenu := False;
                EnterDOSShell;
                ContProcess := False;
                I := 254;
              end;
            end;
            pmFileZip:
            begin
              if Entry.Size = 0 then
              begin
                I := 0;
                _End := True;
              end
              else
              begin
                I := OpenZipFile(Image, ImagePos, 0, fmReadOnly);
                if I = 0 then I := SeekToFileZipBlock(Image, ImagePos mod FileZipBlocks);
              end;
            end;
          end;
        end
        else
        begin
          ContProcess := ErrorWin(stEmpty, 'Can''t open the file', CopyFullName, CurHelpCtx, sbNone);
        end;
      end;
    end;
    FirstBlock := True;
    Error := False;
    OpenRead := I;
    ShellBuffer^.CopyRecordLen := CopyRecordLen;
  end;
end;

end.
