
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   FWCLOSE.PAS                   }
{                                                 }
{    The Star Commander close output file unit    }
{*************************************************}

unit FWClose;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Panel1;

procedure CloseWrite(Panel: PPanel; CloseDisk: Boolean);

implementation

uses
  App, DOS, Drivers, Views,
  Base1, Base2, Constant, DOSShell, ExtFiles, LowLevel, Panel2, XferLo;

{Close the output file
  Input : Panel: the panel to close the file in
          CloseDisk: when True, the disk image is also closed, otherwise it
                     remains open}
procedure CloseWrite(Panel: PPanel; CloseDisk: Boolean);
var
  F,
  O,
  R             : Boolean;
  C,
  D,
  Q,
  S,
  T,
  U,
  V             : Byte;
  P             : Char;
  A,
  B,
  K,
  W,
  Y             : Word;
  I             : Integer;
  J,
  L,
  X             : Longint;
  E             : Longlongint;
  M,
  N             : string;
  Z1            : TZIPEntry;
  Z2            : TZIPCDirEnd;

{Fill in the side sector link table of side sectors in the same group, using
  all the links found in the last side sector of the group}
procedure FillSideSectorLinks;
var
  B,
  S,
  T             : Byte;
begin
  with Panel^ do
  begin
    SideListPos := SideListStart;
    B := SideSecPerGroup;
    while B > 0 do
    begin
      T := SideBuffer[SideListPos];
      S := SideBuffer[SideListPos + 1];
      if (T > 0) and ValidPos(T, S) then
      begin
        ReadDiskBlock(T, S, @DataBuffer, True);
        Move(SideBuffer[SideListStart], DataBuffer[SideListStart], SideSecPerGroup * 2);
        WriteDiskBlock(T, S, @DataBuffer);
      end;
      Inc(SideListPos, 2);
      Dec(B);
    end;
  end;
end;

procedure AddSideSectors;
begin
  with Panel^ do
  begin
    if CopySize > 0 then AddPadding(TempFile, 254);
    if CopyAttr and faTypeMask = faRelative then
    begin
      FillChar(DataBuffer, 254, 0);
      DataBuffer[1] := CopyRecordLen;
      while U > 0 do
      begin
        ExtBlockWrite(TempFile, DataBuffer, 254);
        Inc(DataBuffer[0]);
        Dec(U);
      end;
    end;
  end;
end;

procedure WriteSector(Buffer: PBuffer; T, S: Byte);
begin
  Move(Buffer^, TempBuffer, 256);
  GCRError := dsOK;
  asm
    mov si, Offset(TempBuffer);
    mov di, Offset(GCRBuffer);
    mov al, True;
    call GCREncodeSector;
    mov si, Offset(GCRBuffer);
    push word ptr CopyPriorityMode;
    call InterruptOff;
    call ParallelOutput;
    mov al, S;
    call TSend;
    mov al, T;
    call TSend;
    mov ax, 50;
    call Delay;
    mov di, 325;
@1: mov al, [si];
    call TSend;
    inc si;
    dec di;
    jne @1;
    mov ax, 50;
    call Delay;
    call ParallelInput;
    call InterruptOn;
  end;
end;

begin
  with Panel^ do
  begin
    O := True;
    Escape;
    ExecMode := exNormal;
    R := (CopyAttr and faTypeMask = faRelative);
    case CopyMode of
      pmDOS, pmLynx, pmArkive:
      begin
        if Error or Other^.Error then
        begin
          if AppendFile then
          begin
            ExtSeek(WriteFile, AppendOrigSize);
            ExtTruncate(WriteFile);
            ExtSetFTime(WriteFile, AppendOrigTime);
          end;
          ExtClose(WriteFile);
          if (CopyMode = pmDOS) and Error and not DiskFull then
          begin
            LongDiskFree(E, CopyRealPath[1]);
            DiskFull := (LonglongintToLongint(E) = 0);
          end;
          if not AppendFile then LongErase(WriteFile.LongName);
        end
        else
        begin
          if (CopyMode = pmDOS) and (Other^.CopyMode <> pmExt) and (KeepTime or (Other^.CopyMode = pmDOS)) then
            ExtSetFTime(WriteFile, Other^.FileTime);
          ExtClose(WriteFile);
          if (CopyMode = pmDOS) and (Other^.CopyMode = pmDOS) then LongSetFAttr(WriteFile.LongName, FileAttr or Archive);
        end;
        I := IOResult;
      end;
      pmExt:
      begin
        case CopyTransferMode of
          tmNormal: Unlisten;
          tmWarp:
          begin
            if not Error then
            begin
              DirBuffer[EntryPos + 2] := DirBuffer[EntryPos + 2] or faClosed;
              DirBuffer[EntryPos + 30] := Lo(Block);
              DirBuffer[EntryPos + 31] := Hi(Block);
              WriteSector(@BAM, DirTrack, 0);
              if CopyDiskType and dtTypeMask = dt1571 then WriteSector(@BAM2, DirTrack2, 0);
              WriteSector(@DirBuffer, DirTrack, DirSector);
            end;
          end;
        end;
        if TurboOn then TurboOff;
        CloseCBMChannel(saSave);
        if not ReadCBMError(N, False, False, True) then
        begin
          ContProcess := ErrorWin(stError, N, stEmpty, CurHelpCtx, sbSkip);
          Error := True;
        end;
      end;
      pmDisk:
      begin
        if not (Error or Other^.Error) then
        begin
          if (CopyExtAttr and xaGEOSVLIR > 0) or R then
          begin
            SideBuffer[0] := 0;
            if R then SideBuffer[1] := SidePos - 1 else SideBuffer[1] := MaxByte;
            WriteDiskBlock(SideTrack, SideSector, @SideBuffer);
          end;
          if R then
          begin
            F := (CopyDiskType and dtTypeMask = dt1581);
            SideNumber := 0;
            SideGroup := 0;
            SideTrack := DirBuffer[EntryPos + 21];
            SideSector := DirBuffer[EntryPos + 22];
            if F then
            begin
              U := SideTrack;
              V := SideSector;
              ReadDiskBlock(SideTrack, SideSector, @WorkBuffer, True);
              SideTrack := WorkBuffer[0];
              SideSector := WorkBuffer[1];
              SidePos := SuperSideListStart;
            end;
            while (SideTrack > 0) and ValidPos(SideTrack, SideSector) do
            begin
              if F and (SideNumber = 0) then
              begin
                WorkBuffer[SidePos] := SideTrack;
                WorkBuffer[SidePos + 1] := SideSector;
                Inc(SidePos, 2);
              end;
              ReadDiskBlock(SideTrack, SideSector, @SideBuffer, True);
              Inc(SideNumber);
              if SideNumber >= SideSecPerGroup then
              begin
                FillSideSectorLinks;
                SideNumber := 0;
                Inc(SideGroup);
              end;
              SideTrack := SideBuffer[0];
              SideSector := SideBuffer[1];
            end;
            if SideNumber > 0 then FillSideSectorLinks;
            if F then WriteDiskBlock(U, V, @WorkBuffer);
          end;
          DirBuffer[EntryPos + 2] := CopyAttr or faClosed;
          DirBuffer[EntryPos + 30] := Lo(Block);
          DirBuffer[EntryPos + 31] := Hi(Block);
          WriteDiskBlock(DirTrack, DirSector, @DirBuffer);
          WriteBAM;
        end;
        if CloseDisk then CloseImage(True);
      end;
      pmTape:
      begin
        DirBuffer[2] := StartLo;
        DirBuffer[3] := StartHi;
        X := BytesToLongint(StartLo, StartHi, 0, 0) + DestSize;
        DirBuffer[4] := X;
        DirBuffer[5] := X shr 8;
        DirBuffer[8] := ImagePos;
        DirBuffer[9] := ImagePos shr 8;
        DirBuffer[10] := ImagePos shr 16;
        DirBuffer[11] := ImagePos shr 24;
        ExtSeek(Image, LonglongintToLongint(CopyFree) shl 5);
        ExtBlockWrite(Image, DirBuffer, 32);
        ExtSeek(Image, 32);
        ExtBlockRead(Image, DirBuffer, 32);
        Inc(DirBuffer[4]);
        ExtSeek(Image, 32);
        ExtBlockWrite(Image, DirBuffer, 32);
        CloseImage(True);
      end;
      pmFile:
      begin
        if KeepTime and (Other^.CopyMode <> pmExt) then ExtSetFTime(WriteFile, Other^.FileTime);
        ExtClose(WriteFile);
      end;
      pmTAR:
      begin
        if not Error and not Other^.Error then
        begin
          AddPadding(Image, 512);
          FillChar(TempBuffer, 512, 0);
          if Other^.CopyMode = pmExt then X := LocalTime else X := Other^.FileTime;
          X := DOSToUnix(X);
          ExtBlockWrite(Image, TempBuffer, 512);
          N := CopyRealImagePath;
          if N <> '' then N := N + DirSep;
          N := N + CopyName;
          D := CopyAttr and faTypeMask;
          if D <> 2 then N := N + stDot + ShortCBMExt[D];
          Move(N[1], TempBuffer[0], Length(N));
(* ?ASM? *)
          asm
            mov ax, DefTARAttr;
            xor dx, dx;
            mov si, $0064;
            mov cx, 8;
            mov di, 7;
            call WriteNum;
            xor ax, ax;
            xor dx, dx;
            mov si, $006C;
            mov cx, 8;
            mov di, 7;
            call WriteNum;
            xor ax, ax;
            xor dx, dx;
            mov si, $0074;
            mov cx, 8;
            mov di, 7;
            call WriteNum;
            mov ax, word ptr DestSize[0];
            mov dx, word ptr DestSize[2];
            mov si, $007C;
            mov cx, 8;
            mov di, 12;
            call WriteNum;
            mov ax, word ptr X[0];
            mov dx, word ptr X[2];
            mov si, $0088;
            mov cx, 8;
            mov di, 12;
            call WriteNum;
            push True;
            call ComputeTARCheck;
          end;
          ExtSeek(Image, HeaderPos);
          ExtBlockWrite(Image, TempBuffer, 512);
        end
        else
        begin
          ExtSeek(Image, OrigSize);
          ExtTruncate(Image);
        end;
        CloseImage(True);
      end;
      pmLHA, pmZIP:
      begin
        if not TempInputOpen then
        begin
          if KeepTime and (Other^.CopyMode <> pmExt) then ExtSetFTime(WriteFile, Other^.FileTime);
          ExtClose(WriteFile);
        end;
        case CopyMode of
          pmLHA: while ReadCBMEntry(Entry) do;
          pmZIP:
          begin
            Z2 := ZIPDirEnd;
            J := ArcPos;
            L := HeaderPos;
          end;
        end;
        CloseImage(False);
        I := IOResult;
        if not Error and not Other^.Error then
        begin
          N := AddToPath(CopyPath, ArcTempInput, chDirSep);
          if TempInputOpen then
          begin
            I := LongOpenFile(N, Image, fmReadOnly);
            if I = 0 then
            begin
              TempInputOpen := False;
              LongErase(MakeTempName);
              I := IOResult;
              M := AddToPath(CopyPath, CopyImageName, chDirSep);
              case CopyMode of
                pmLHA:
                begin
                  if ImageExists then
                  begin
                    I := LongOpenFile(M, WriteFile, fmReadWrite);
                    ExtGetFTime(WriteFile, X);
                    ExtSeek(WriteFile, HeaderPos);
                  end
                  else
                  begin
                    I := LongOpenFile(M, WriteFile, fmWriteOnly);
                    X := 0;
                  end;
                end;
                pmZIP:
                begin
                  I := LongOpenFile(M, TempFile, fmReadOnly);
                  if I = 0 then
                  begin
                    ExtGetFTime(TempFile, X);
                  end
                  else
                  begin
                    L := 0;
                    FillChar(Z2, SizeOf(TZIPCDirEnd), 0);
                  end;
                  I := LongOpenFile(MakeTempName, WriteFile, fmWriteOnly);
                end;
              end;
              if I = 0 then
              begin
                InitArchive;
                ReadCBMEntry(Entry);
                M := CopyRealImagePath;
                if M <> '' then M := M + DirSep;
                M := M + CopyName;
                case CopyMode of
                  pmLHA:
                  begin
                    LHAEntry.Name := M;
                    if CopyAttr and faTypeMask <> faProgram then
                      LHAEntry.Name := LHAEntry.Name + #0 + UpCase(ShortCBMExt[CopyAttr and faTypeMask][1]);
                    MakeLHAEntry;
                    ExtBlockWrite(WriteFile, TempBuffer, TempBuffer[0] + 2);
                    ExtSeek(Image, LHAHeaderLen + 2);
                    CopyPart(Image, WriteFile, LHAEntry.PackSize, TBufferSize);
                    D := 0;
                    ExtBlockWrite(WriteFile, D, 1);
                  end;
                  pmZIP:
                  begin
                    ExtSeek(Image, 0);
                    if ReadZIPEntry(Image, Z1, N) then
                    begin
                      Z1.NameLen := Length(M);
                      ZIPEntry.NameLen := Length(M);
                      ZIPEntry.HeaderOffs := L;
                      Move(ZIPSign[1], Z2.Signature, Length(ZIPSign));
                      Inc(Z2.LocalFileNum);
                      Inc(Z2.FileNum);
                      Z2.DirOffs := L + SizeOf(TZIPEntry) + Length(M) + Z1.ExtHeadSize + Z1.PackSize;
                      Inc(Z2.DirSize, SizeOf(TZIPCDirEntry) + Length(M));
                      if L > 0 then CopyPart(TempFile, WriteFile, L, TBufferSize);
                      ExtBlockWrite(WriteFile, Z1, SizeOf(TZIPEntry));
                      ExtBlockWrite(WriteFile, M[1], Length(M));
                      CopyPart(Image, WriteFile, Z1.ExtHeadSize + Z1.PackSize, TBufferSize);
                      if L > 0 then CopyPart(TempFile, WriteFile, J - L, TBufferSize);
                      ExtBlockWrite(WriteFile, ZIPEntry, SizeOf(TZIPCDirEntry));
                      ExtBlockWrite(WriteFile, M[1], Length(M));
                      ExtBlockWrite(WriteFile, Z2, SizeOf(TZIPCDirEnd));
                    end
                    else
                    begin
                      I := 255;
                    end;
                  end;
                end;
                ExtGetFTime(Image, FileTime);
                if X > FileTime then FileTime := X;
                if KeepTime then ExtSetFTime(WriteFile, FileTime);
                I := IOResult;
                ExtClose(WriteFile);
              end;
              ExtClose(Image);
              if CopyMode = pmZIP then
              begin
                ExtClose(TempFile);
                if I = 0 then
                begin
                  LongErase(TempFile.LongName);
                  LongRename(WriteFile.LongName, TempFile.LongName);
                end;
              end;
              LongErase(Image.LongName);
            end
            else
            begin
              LongErase(MakeTempName);
              I := IOResult;
              ErrorWin(stEmpty, 'Can''t compress the archive', CopyImageName, CurHelpCtx, sbNone);
              TempDialog := nil;
            end;
          end
          else
          begin
            Close(ReadFile.Orig);
            ShellBuffer^.ExecMode := exCloseWrite;
            case CopyMode of
              pmLHA: PutCommand('lha a -m2 -n2 -o -t1 -w ' + ShortName(N, True) + stSpace + MakeTempName + ' > nul' +
                chCR + chLF, False);
              pmZIP: PutCommand('zip -oX ' + ShortName(N, True) + stSpace + MakeTempName + ' > nul' + chCR + chLF, False);
            end;
            Act^.FirstFile := ShellBuffer^.OrigFirstFile;
            Act^.CopyDirPos := ShellBuffer^.OrigCopyDirPos;
            RunningShell := True;
            CommandOutput := coSilent;
            TempInputOpen := True;
            AttachInfo := False;
            SingleCommand := True;
            ClearCommand := True;
            PopupMenu := False;
            EnterDOSShell;
            ContProcess := False;
          end;
        end;
      end;
      pmFileZip:
      begin
        FileTime := Other^.FileTime;
        CloseImage(True);
        A := ImagePos;
        if OpenImage(True, False, True, True, True) = 0 then
        begin
          ExtSeek(Image, 511);
          S := A div FileZipBlocks;
          if A mod FileZipBlocks > 0 then Inc(S);
          ExtBlockWrite(Image, S, 1);
          S := CopyImageSize + 1;
          ExtBlockWrite(Image, S, 1);
          ExtSeek(Image, OrigSize);
          S := Length(CopyName);
          Move(CopyName[1], TempBuffer, S);
          P := UpCase(ShortCBMExt[CopyAttr and faTypeMask][1]);
          B := ByteToBlock(DestSize);
(* ?ASM? *)
          asm
            mov al, S;
            xor ah, ah;
            mov di, ax;
            add di, Offset(TempBuffer);
            mov al, P;
            or al, $80;
            mov [di], al;
            inc di;
            mov ax, B;
            mov [di], ax;
            add di, 2;
            mov byte ptr [di], 1;
            inc di;
            mov byte ptr [di], 0;
            inc di;
            sub di, Offset(TempBuffer);
            mov ax, di;
            mov S, al;
          end;
          ExtBlockWrite(Image, TempBuffer, S);
          CloseImage(True);
          if FileSizeWarning and (A > DiskMaxFree(dt1541)) and not FileSizeWarned then
          begin
            FileSizeWarned := True;
            SureConfirm(stEmpty, 'You may not be able to extract', 'the following archive on a 1541 drive.',
              AddToPath(CopyPath, CopyImageName, chDirSep), stEmpty, stOK, stEmpty, stEmpty, stEmpty, stEmpty,
              nil, CurHelpCtx, ayNone, False, DummyByte);
          end;
        end;
      end;
    end;
    if (CopyMode in [pmLynx, pmArkive]) and not Error and not Other^.Error then
    begin
      FillChar(TempBuffer, 6144, 0);
      if ImageExists then
      begin
        W := HeaderPos;
        X := ImagePos;
        while ReadCBMEntry(Entry) do;
        ExtSeek(Image, 0);
        case CopyMode of
          pmLynx:
          begin
            ExtBlockRead(Image, TempBuffer, W);
            Y := HeaderPos - W;
          end;
          pmArkive:
          begin
            ExtBlockRead(Image, TempBuffer, HeaderPos);
            Y := HeaderPos;
          end;
        end;
      end
      else
      begin
        case CopyMode of
          pmLynx:
          begin
            HeaderPos := LynxHeaderLen;
            LynxCountPos := LynxHeaderLen;
            X := 254;
            Y := 0;
            ImagePos := 254;
            Move(@LynxHeader^, TempBuffer, LynxHeaderLen);
          end;
          pmArkive: Y := 1;
        end;
        CopyImageSize := 0;
      end;
      K := CopyImageSize + 1;
      ExtFileName := CopyName;
      D := CopyAttr;
      P := UpCase(ShortCBMExt[D and faTypeMask][1]);
      I := LongOpenFile(WriteFile.LongName, WriteFile, fmReadOnly);
      if I = 0 then
      begin
        CopySize := ExtFileSize(WriteFile);
        B := 0;
        C := 0;
        Q := 0;
        U := 0;
        V := 0;
        if CopySize > 0 then
        begin
          C := CopySize mod 254;
          if C = 0 then Dec(C) else Inc(C);
          B := ByteToBlock(CopySize);
          if CopyAttr and faTypeMask = faRelative then
          begin
            Q := CopyRecordLen;
            U := B div SideSecSize;
            V := B mod SideSecSize;
            if V = 0 then
            begin
              Dec(V);
            end
            else
            begin
              Inc(U);
              V := V shl 1 + (SideSecStart - 1);
            end;
            Inc(B, U);
          end;
        end;
        if FileSizeWarning and (Blocks + B > DiskMaxFree(dt1541)) then
        begin
          if not FileSizeWarned then
          begin
            FileSizeWarned := True;
            O := (SureConfirm(stEmpty, 'You may not be able to extract', 'the following archive on a 1541 drive.',
              AddToPath(CopyPath, CopyImageName, chDirSep), stDoYouStillWishToContinue, stYes, stEmpty, stEmpty, stEmpty, stNo,
              nil, CurHelpCtx, ayNone, False, DummyByte) = cmOK);
            ContProcess := O;
            if not O then
            begin
              CloseImage(False);
              ExtClose(WriteFile);
            end;
          end;
        end
        else
        begin
          O := True;
        end;
        if O then
        begin
          case CopyMode of
            pmLynx:
            begin
(* ?ASM? *)
              asm
                mov ax, K;
                xor dx, dx;
                mov si, LynxCountPos;
                mov cx, 10;
                xor di, di;
                call WriteNum;
                mov byte ptr TempBuffer[si], chReturn;
                inc si;
                mov W, si;
              end;
              if Y > 0 then ExtBlockRead(Image, TempBuffer[W], Y);
              Inc(W, Y);
              K := W;
              Inc(W, Length(CopyName) + Length(LeadingSpace(C, 0)) + Length(LeadingSpace(B, 0)) + 9);
              if CopyAttr and faTypeMask = faRelative then Inc(W, Length(LeadingSpace(Q, 0)) + 2);
(* ?ASM? *)
              asm
                mov ax, W;
                mov cl, 254;
                div cl;
                or ah, ah;
                je @1;
                inc al;
            @1: xor ah, ah;
                push ax;
                xor dx, dx;
                mov si, LynxBlockPos;
                mov cx, 10;
                xor di, di;
                call WriteNum;
                pop ax;
                push ax;
                mov cl, 254;
                mul cl;
                mov Y, ax;
                pop ax;
                cmp al, 10;
                jae @2;
                mov byte ptr TempBuffer[si], ' ';
            @2: mov si, K;
                mov di, Offset(ExtFileName);
                mov al, [di];
                mov cl, al;
                xor ch, ch;
                inc di;
            @3: mov al, [di];
                mov byte ptr TempBuffer[si], al;
                inc si;
                inc di;
                loop @3;
                mov byte ptr TempBuffer[si], chReturn;
                inc si;
                mov ax, B;
                xor dx, dx;
                mov cx, 10;
                xor di, di;
                call WriteNum;
                mov byte ptr TempBuffer[si], chReturn;
                inc si;
                mov al, P;
                mov byte ptr TempBuffer[si], al;
                inc si;
                mov byte ptr TempBuffer[si], chReturn;
                inc si;
                mov al, D;
                and al, faTypeMask;
                cmp al, faRelative;
                jne @4;
                mov al, Q;
                xor ah, ah;
                xor dx, dx;
                mov cx, 10;
                xor di, di;
                call WriteNum;
                mov byte ptr TempBuffer[si], chReturn;
                inc si;
            @4: mov al, C;
                xor ah, ah;
                xor dx, dx;
                mov cx, 10;
                xor di, di;
                call WriteNum;
                mov byte ptr TempBuffer[si], chReturn;
                inc si;
              end;
              HeaderPos := Y;
            end;
            pmArkive:
            begin
(* ?ASM? *)
              asm
                mov ax, K;
                mov byte ptr TempBuffer[0], al;
                mov ax, Y;
                mov si, ax;
                add ax, 29;
                mov W, ax;
                mov al, D;
                or al, $80;
                mov byte ptr TempBuffer[si], al;
                inc si;
                mov al, C;
                mov byte ptr TempBuffer[si], al;
                inc si;
                mov di, Offset(ExtFileName);
                mov al, [di];
                mov cl, al;
                xor ch, ch;
                inc di;
            @1: mov al, [di];
                mov byte ptr TempBuffer[si], al;
                inc si;
                inc di;
                loop @1;
                mov al, Q;
                mov byte ptr TempBuffer[si], al;
                inc si;
                xor al, al;
                mov cx, 6;
            @2: mov byte ptr TempBuffer[si], al;
                inc si;
                loop @2;
                mov al, U;
                mov byte ptr TempBuffer[si], al;
                inc si;
                mov al, V;
                mov byte ptr TempBuffer[si], al;
                inc si;
                mov ax, B;
                mov word ptr TempBuffer[si], ax;
                inc si;
              end;
              HeaderPos := ByteToBlock(W) * 254;
            end;
          end;
          I := LongOpenFile(AddToPath(CopyRealPath, ArcTempOutput, chDirSep), TempFile, fmWriteOnly);
          if I = 0 then
          begin
            TempOutputOpen := True;
            ExtBlockWrite(TempFile, TempBuffer, HeaderPos);
            if ImageExists then
            begin
              L := ExtFileSize(Image);
              if ImagePos > L then ImagePos := L;
              ExtSeek(Image, X);
              CopyPart(Image, TempFile, ImagePos - X, TBufferSize);
            end;
            if CopyMode = pmLynx then AddSideSectors;
            if CopySize > 0 then CopyPart(WriteFile, TempFile, CopySize, TBufferSize);
            if CopyMode = pmArkive then AddSideSectors;
            I := IOResult;
          end;
        end;
        ExtClose(WriteFile);
        if KeepTime and ImageExists then ExtSetFTime(TempFile, FileTime);
        ExtClose(TempFile);
      end;
      if O then
      begin
        if ImageExists then
        begin
          CloseImage(False);
          if I = 0 then LongErase(Image.LongName);
        end;
        if I = 0 then LongRename(TempFile.LongName, AddToPath(CopyRealPath, CopyImageName, chDirSep));
        I := IOResult;
      end;
      LongErase(WriteFile.LongName);
      I := IOResult;
    end;
    FirstCopyFile := False;
  end;
end;

end.
