
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    FWOPEN.PAS                   }
{                                                 }
{     The Star Commander open output file unit    }
{*************************************************}

unit FWOpen;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Base2, DOS, Panel1;

function OpenWrite(Panel: PPanel; Buffer: PBuffer; FirstCopy, Force, Empty: Boolean; EmptyTrack: Byte): Integer;

implementation

uses
  Dialogs, Drivers, Objects, Views,
  Base1, Constant, ExtFiles, LowLevel, Panel2, MiscFunc;

{Open the file for output
  Input : Panel: the panel to open the file in
          Buffer: buffer containing the first block of data read
          FirstCopy: when True, this is the first file being copied
          Force: when True, the file is opened even if another file with
                 the same name already exists
          Empty: when True, the source file is empty
          EmptyTrack: first track of the file, if empty
  Output: when not 0, an error occured}
function OpenWrite(Panel: PPanel; Buffer: PBuffer; FirstCopy, Force, Empty: Boolean; EmptyTrack: Byte): Integer;
var
  F,
  O,
  Q             : Boolean;
  M,
  J             : Byte;
  L             : Char;
  W,
  Y,
  Z             : Word;
  I             : Integer;
  X             : Longint;
  P             : PSmallBuf;
  N,
  S             : string;

{Display an error message if the directory of the destination file has become
  full}
procedure ImageFullError;
begin
  with Panel^ do
  begin
    ErrorWin(stEmpty, 'Too many files in the image file', AddToPath(CopyPath, CopyImageName, chDirSep), CurHelpCtx, sbNone);
    ContProcess := False;
    O := False;
    I := 253;
  end;
end;

{Convert the number of entries into string form}
procedure EntriesStr;
begin
  S := 'entr';
  if Y = 1 then S := S + 'y' else S := LeadingSpace(Y, 0) + stSpace + S + 'ies';
end;

{Check for relative files; display an error when trying to copy one to a file
  format that doesn't support it and ask about copying it as a program instead;
  if record length is zero, ask for a valid one
  Output: when False, there were errors and the user didn't accept the changes
          offerred}
function CheckRelFile: Boolean;
var
  L,
  O             : Boolean;
  J             : Integer;
  A             : PInputLine;
  R             : TRect;
  S             : string[1];
begin
  with Panel^ do
  begin
    O := True;
    if CopyAttr and faTypeMask = faRelative then
    begin
      case CopyMode of
        pmDisk, pmLynx, pmArkive:
        begin
          if CopyRecordLen = 0 then
          begin
            R.Assign(0, 0, 0, 1);
            A := New(PNumInput, Init(R, 3, 3, 'Record length:', drLeft));
            A^.SetValidator(New(PNumValid, Init(1, 255, stEmpty, 'record length', CurHelpCtx)));
            UserTitle := '0';
            O := (SureConfirm(stEmpty, 'Invalid or unknown record length.', 'Do you wish to enter a new value?', stEmpty,
              stEmpty, stOK, stEmpty, stEmpty, stEmpty, stEmpty, A, CurHelpCtx, ayNone, False, DummyByte) = cmOK);
            if O then
            begin
              Val(UserTitle, CopyRecordLen, J);
              ShellBuffer^.CopyRecordLen := CopyRecordLen;
            end
            else
            begin
              I := 252;
            end;
          end;
        end;
        pmDOS:
      else
        O := (SureConfirm(stEmpty, 'Can''t copy a relative file to', CopyFullName,
          'Do you wish to copy it as a program file instead?', stEmpty,
          stOK, stEmpty, stEmpty, stEmpty, stEmpty, nil, CurHelpCtx, ayNone, False, DummyByte) = cmOK);
        if O then
        begin
          CopyAttr := (CopyAttr and not faTypeMask) or faProgram;
          ShellBuffer^.CopyAttr := CopyAttr;
        end;
      end;
    end;
    CheckRelFile := O;
  end;
end;

begin
  with Panel^ do
  begin
    I := 255;
    if CopyMode = pmDiskZip then
    begin
      ErrorWin(stEmpty, 'Can''t write into a ' + MakeFullTypeStr(CopyMode) + stDot, CopyFullName, CurHelpCtx, sbNone);
      ContProcess := False;
      Exit;
    end;
    SysErrorOccurred := False;
    TurboOn := False;
    ImageExists := False;
    DestSize := 0;
    Block := 0;
    O := True;
    RetryCount := RetryNum + 1;
    CopyAttr := ShellBuffer^.CopyAttr;
    CopyExtAttr := Other^.CopyExtAttr;
    CopyRecordLen := ShellBuffer^.CopyRecordLen;
    if CheckRelFile then
    begin
      if (CopyMode = pmDisk) and (CopyExtAttr > 0) then
      begin
        CopyName[0] := Chr(CBMNameLen);
        Move(Buffer^[3], CopyName[1], Length(CopyName));
        CopyName := CloneName(CutChar(CopyName, chShiftSpace), Inact^.NamePattern, False, True);
        MakeFullName;
      end;
      N := CopyName;
      if CopyMode = pmTape then L := ' ' else L := chShiftSpace;
      if CopyMode in [pmDisk, pmTape, pmLynx, pmArkive, pmFileZip] then while Length(N) < CBMNameLen do N := N + L;
      repeat
        Q := True;
        case CopyMode of
          pmDisk, pmTape, pmLynx..pmFileZip:
          begin
            if CopyToDirTrack then DirAllocMode := daCheck;
            I := OpenImage(False, False, True, FirstCopyFile, True);
            case I of
              0:
              begin
                if ImageReadOnly then
                begin
                  CloseImage(False);
                  ContProcess := ErrorWin(stEmpty, 'The following image file is marked read-only.', CopyImageName,
                    CurHelpCtx, sbNone);
                end
                else
                begin
                  F := False;
                  if not Force then while not F and ReadCBMEntry(Entry) do F := ((Entry.Attr > 0) and (Entry.Name = CopyName));
                  if F then
                  begin
                    CloseImage(False);
                    CopyAttr := Entry.Attr;
                    I := 254;
                    O := False;
                  end
                  else
                  begin
                    if CopyToDirTrack then while ReadCBMEntry(Entry) do;
                    CloseImage(False);
                    if (CopyMode = pmDisk) and not IsBAMValid then
                    begin
                      ErrorWin(stEmpty, 'The following image file has an invalid BAM', CopyImageName, CurHelpCtx, sbNone);
                      ContProcess := False;
                      O := False;
                    end
                    else
                    begin
                      if not DirAllocOK then
                      begin
                        DirAllocOK := (SureConfirm(stEmpty, 'There are unallocated directory blocks in', CopyImageName,
                          'Do you wish to allocate them and continue?', stEmpty, stYes, stEmpty, stEmpty, stEmpty, stNo, nil,
                          CurHelpCtx, ayNone, False, DummyByte) = cmOK);
                      end;
                    end;
                    if DirAllocOK then
                    begin
                      if CopyToDirTrack then DirAllocMode := daAlloc;
                      if OpenImage(True, False, True, True, True) = 0 then
                      begin
                        ImageExists := True;
                        CopyName := N;
                        case CopyMode of
                          pmDisk:
                          begin
                            M := CopyDiskType and dtTypeMask;
                            if CopyGEOSFormat then SectorStep := ImageInts[M shl 1 + 1] else
                              if M = dt1581 then SectorStep := 1 else SectorStep := 3;
                            F := False;
                            while not F and ReadCBMEntry(Entry) do F := (Entry.Attr = 0);
                            if not F then
                            begin
                              if IsTrackFree(DirTrack) then
                              begin
                                Track := DirTrack;
                                Sector := DirSector;
                                F := NextCopyBlock;
                                WriteDiskBlock(DirTrack, 0, @BAM);
                                DirBuffer[0] := DirTrack;
                                DirBuffer[1] := Sector;
                                WriteDiskBlock(DirTrack, DirSector, @DirBuffer);
                                DirSector := Sector;
                                FillChar(DirBuffer, 256, 0);
                                DirBuffer[1] := MaxByte;
                                WriteDiskBlock(DirTrack, DirSector, @DirBuffer);
                                EntryPos := 0;
                                F := True;
                              end
                              else
                              begin
                                CloseImage(False);
                                ImageFullError;
                              end;
                            end;
                            if F then
                            begin
                              M := M shl 1;
                              SectorStep := ImageInts[M + Byte(CopyExtAttr > 0)];
                              if Empty then
                              begin
                                Track := EmptyTrack;
                                Sector := 0;
                              end
                              else
                              begin
                                F := FirstCopyBlock;
                              end;
                              if F then
                              begin
                                for J := 2 to 31 do DirBuffer[EntryPos + J] := 0;
                                DirBuffer[EntryPos + 3] := Track;
                                DirBuffer[EntryPos + 4] := Sector;
                                if CopyAttr and faTypeMask = faRelative then DirBuffer[EntryPos + 23] := CopyRecordLen;
                                for J := 0 to CBMNameLen - 1 do DirBuffer[EntryPos + J + 5] := Ord(CopyName[J + 1]);
                                WriteDiskBlock(DirTrack, DirSector, @DirBuffer);
                                I := 0;
                                SideNumber := MaxByte;
                                SideGroup := 0;
                                SideTrack := 0;
                                SideSector := MaxByte;
                              end
                              else
                              begin
                                CloseImage(False);
                                ContProcess := ErrorWin(stEmpty, 'The following image file is full',
                                  AddToPath(CopyPath, CopyImageName, chDirSep), CurHelpCtx, sbNone);
                                O := False;
                                I := 253;
                              end;
                            end;
                          end;
                          pmTape:
                          begin
                            W := 2;
                            while (W < CopyImageSize + 2) and ReadCBMEntry(Entry) do Inc(W);
                            if W = CopyImageSize + 2 then
                            begin
                              CloseImage(False);
                              if CopyImageSize = MaxTapeDirSize then
                              begin
                                ImageFullError;
                              end
                              else
                              begin
                                Y := 1;
                                case CopyFileMode of
                                  cfSelected:
                                  begin
                                    if Other^.SelNum > 0 then
                                    begin
                                      Y := 0;
                                      for Z := CopyFileNum to Other^.Max - 1 do
                                        if Other^.Dir[Z].Status and fsProcessMask = fsSelected then Inc(Y);
                                    end;
                                  end;
                                end;
                                Z := MaxTapeDirSize - CopyImageSize;
                                if Y > Z then Y := Z;
                                EntriesStr;
                                if Y = 1 then S := 'an ' + S;
                                O := (SureConfirm(stEmpty, 'Too many files in the image file',
                                  AddToPath(CopyPath, CopyImageName, chDirSep), 'Do you wish to add ' + S + '?',
                                  stEmpty, stYes, stEmpty, stEmpty, stEmpty, stNo, nil, CurHelpCtx, ayNone,
                                  False, DummyByte) = cmOK);
                                ContProcess := O;
                                if O then
                                begin
                                  O := ExpandTape(Inact, Y, False);
                                  if O then Q := False else ContProcess := ErrorWin(stEmpty, 'Can''t expand the image file',
                                    AddToPath(Panel^.CopyPath, Panel^.CopyImageName, chDirSep), hcHelp, sbNone);
                                end
                                else
                                begin
                                  I := 253;
                                end;
                              end;
                            end
                            else
                            begin
                              O := True;
                              if FileSizeWarning and (W >= MaxC64STapeEntries + 2) and not FileSizeWarned then
                              begin
                                FileSizeWarned := True;
                                Y := W - MaxC64STapeEntries - 1;
                                EntriesStr;
                                O := (SureConfirm(stEmpty, 'You may not be able to use the last ' + S + ' of',
                                  'the following archive under C64S.', AddToPath(CopyPath, CopyImageName, chDirSep),
                                  stDoYouStillWishToContinue, stYes, stEmpty, stEmpty, stEmpty, stNo, nil, CurHelpCtx,
                                  ayNone, False, DummyByte) = cmOK);
                                ContProcess := O;
                                if not O then
                                begin
                                  CloseImage(False);
                                  I := 253;
                                end;
                              end;
                              if O then
                              begin
                                LongintToLonglongint(CopyFree, W);
                                ImagePos := ExtFileSize(Image);
                                for J := 6 to 15 do DirBuffer[J] := 0;
                                if CopyAttr and faTypeMask = faFrozen then
                                begin
                                  DirBuffer[0] := 3;
                                  DirBuffer[1] := 0;
                                end
                                else
                                begin
                                  DirBuffer[0] := 1;
                                  DirBuffer[1] := CopyAttr or faClosed;
                                end;
                                for J := 0 to CBMNameLen - 1 do DirBuffer[J + 16] := Ord(CopyName[J + 1]);
                                I := 0;
                                ExtSeek(Image, ImagePos);
                              end;
                            end;
                          end;
                          pmFileZip: while ReadCBMEntry(Entry) do;
                        end;
                      end;
                    end;
                  end;
                end;
              end;
              2, 3:
              begin
                if (CopyMode in [pmDisk, pmTape]) or (I = dePathNotFound) then
                begin
                  O := False;
                  ContProcess := ErrorWin(stEmpty, 'Can''t open the ' + MakeFullTypeStr(CopyMode),
                    AddToPath(CopyPath, CopyImageName, chDirSep), CurHelpCtx, sbNone);
                end;
              end;
            end;
          end;
        end;
      until Q;
      DirAllocMode := daNone;
      if O then
      begin
        CopyName := N;
        case CopyMode of
          pmDOS, pmFile, pmLynx, pmArkive, pmLHA, pmZIP:
          begin
            I := 0;
            if not GetPanelModeAttrib(CopyMode, paExternalArch) or not TempInputOpen then
            begin
              I := IOResult;
              DiskFull := False;
              case CopyMode of
                pmDOS: S := AddToPath(CopyPath, CopyName, chDirSep);
                pmFile: S := AddToPath(CopyPath, CopyImageName, chDirSep);
              else
                S := MakeTempName;
              end;
              FailSysErrors := fsAll;
              I := LongOpenFile(S, WriteFile, fmReadOnly);
              if (CopyMode = pmDOS) and AppendFile then
              begin
                AppendOrigSize := ExtFileSize(WriteFile);
                ExtGetFTime(WriteFile, AppendOrigTime);
              end;
              FailSysErrors := fsNone;
              if I = 0 then
              begin
                F := IsDiskFile(WriteFile);
                ExtClose(WriteFile);
                if F and not AppendFile then
                begin
                  if CopyMode in [pmDOS, pmFile] then
                  begin
                    I := 254;
                  end
                  else
                  begin
                    LongErase(WriteFile.LongName);
                    I := IOResult;
                  end;
                end;
              end;
              if I <> 254 then
              begin
                SysErrorOccurred := False;
                if CopyMode = pmDOS then
                begin
                  J := fmWriteOnly;
                  if AppendFile then J := fmReadWrite;
                  I := LongOpenFile(S, WriteFile, J);
                  if AppendFile then ExtSeek(WriteFile, AppendOrigSize);
                end
                else
                begin
                  I := LongOpenFile(S, WriteFile, fmWriteOnly);
                end;
                if I = 0 then
                begin
                  if CopyMode = pmFile then
                  begin
                    FillChar(DirBuffer, 26, 0);
                    Move(PC64Sign[1], DirBuffer, Length(PC64Sign));
                    Move(CopyName[1], DirBuffer[8], Length(CopyName));
                    if CopyAttr and faTypeMask = faRelative then DirBuffer[25] := CopyRecordLen;
                    ExtBlockWrite2(WriteFile, DirBuffer, 26, W);
                    I := IOResult;
                  end
                  else
                  begin
                    if CopyMode <> pmDOS then TempFileOpen := True;
                  end;
                end
                else
                begin
                  if SysErrorOccurred then ContProcess := False else ContProcess := ErrorWin(stEmpty,
                    'Can''t create the file', S, CurHelpCtx, sbNone);
                end;
              end;
            end;
          end;
          pmExt:
          begin
            if (CopyExtAttr > 0) and not Force then
            begin
              O := (SureConfirm(stEmpty, 'Can''t copy a GEOS file to', CopyFullName,
                'Do you wish to copy it as a Convert archive instead?', stEmpty,
                stOK, stEmpty, stEmpty, stEmpty, stEmpty, nil, CurHelpCtx, ayNone, False, DummyByte) = cmOK);
            end;
            if O then
            begin
              CBMDevNum := CopyCBMDev;
              SendConfigData;
              if FirstCopy then CopyDiskType := DetectDiskType(ExtendedDisk, True);
              CheckDiskType;
              SectorStep := ImageInts[CopyDiskType and dtTypeMask + Byte(CopyExtAttr > 0)];
              LastTrack := CopyMaxTrack;
              S := CopyName + ',' + UpCase(ShortCBMExt[CopyAttr and faTypeMask][1]);
              OpenCBMChannel(saSave, S, True);
              if ReadCBMError(S, False, False, True) then
              begin
                I := 0;
                Status := 0;
                asm
                  mov al, saSave;
                  call Listen;
                end;
              end
              else
              begin
                if Copy(S, 1, 2) = '63' then I := 254 else ContProcess := ErrorWin(stError, S, stEmpty, CurHelpCtx, sbSkip);
              end;
            end;
          end;
          pmTAR:
          begin
            X := 0;
            if ImageExists then
            begin
              while ReadCBMEntry(Entry) do X := HeaderPos;
              I := IOResult;
            end
            else
            begin
              I := LongOpenFile(AddToPath(CopyRealPath, CopyImageName, chDirSep), Image, fmWriteOnly);
              if I = 0 then
              begin
                ExtClose(Image);
                I := OpenImage(True, False, True, True, True);
                if I = 255 then I := 0;
              end;
            end;
            if I = 0 then
            begin
              HeaderPos := X;
              ImagePos := HeaderPos + 512;
              ExtSeek(Image, HeaderPos);
              FillChar(TempBuffer, 512, 0);
              ExtBlockWrite(Image, TempBuffer, 512);
            end;
          end;
          pmFileZip:
          begin
            if not ImageExists then
            begin
              I := LongOpenFile(Image.LongName, Image, fmWriteOnly);
              if I = 0 then
              begin
                FillChar(TempBuffer, 513, 0);
                Move(@ZipDirLister^, TempBuffer, ZipHeaderLen);
                ExtBlockWrite(Image, TempBuffer, 513);
                ExtClose(Image);
                I := IOResult;
              end;
            end;
          end;
        end;
      end;
    end;
    FirstBlock := True;
    Error := (I <> 0);
    _End := Error;
    OpenWrite := I;
  end;
end;

end.
