
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    FWPREP.PAS                   }
{                                                 }
{    The Star Commander prepare file write unit   }
{*************************************************}

unit FWPrep;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Dialogs,
  Panel1;

function ManualFilename(var D: PDialog; AllAndSkip: Boolean): Word;
function PrepareWrite(var D: PDialog; Ask: Boolean): Boolean;

implementation

uses
  App, Drivers, Objects, Views,
  Base1, Base2, Constant, ExtFiles, LowLevel, Panel2, XferLo;

{Shrink the file name by stripping the path and keeping only the left part
  and the extension part (at most 3 characters to the right of the
  rightmost dot) of the file name so that it fits into 16 characters
  Input : Name: the file name to shrink
          DirSep: the character dividing directories
  Output: the shrinked file name}
function ShrinkName(const Name: string; DirSep: Char): string;
var
  P             : Byte;
  E,
  T             : string;

{Compute the length of a string, counting hexadecimal codes as one character
  Input : Str: the string whose length to compute
          Max: when 0, the special length of the string is returned; otherwise
               the number of those real characters is returned that make up
               the specified number of special characters
  Output: the length of the string}
function SpecLength(const Str: string; Max: Byte): Byte;
var
  B             : Boolean;
  L             : Byte;
  X             : Word;
  I             : Integer;
begin
  B := (Max > 0);
  L := 0;
  X := 1;
  while (X <= Length(Str)) and (not B or (L < Max)) do
  begin
    if (ConvInvalidChars <> ccNone) and (Str[X] = hxPercent) and (X <= Length(Str) - 2) then
    begin
      HexaEval(Copy(Str, X + 1, 2), I);
      if I = 0 then Inc(X, 2);
    end;
    Inc(X);
    Inc(L);
  end;
  if B then SpecLength := X - 1 else SpecLength := L;
end;

begin
  T := CutPath(Name, DirSep);
  E := '';
  if SpecLength(T, 0) > CBMNameLen then
  begin
    P := RightPos('.', T);
    if P = 0 then
    begin
      T[0] := Chr(SpecLength(T, CBMNameLen));
    end
    else
    begin
      E := Copy(T, P, MaxStrLen);
      T[0] := Chr(P - 1);
      if (SpecLength(T, 0) > 12) and (SpecLength(E, 0) > 4) then E[0] := Chr(SpecLength(E, 4));
      P := CBMNameLen - SpecLength(E, 0);
      if SpecLength(T, 0) > P then T[0] := Chr(SpecLength(T, P));
      T := T + E;
    end;
  end;
  ShrinkName := T;
end;

{Replace invalid characters in the file name with underscores or hexadecimal
  codes
  Input : Name: the file name to fix}
procedure DropInvalidChars(var Name: string);
var
  F,
  O             : Boolean;
  B             : Byte;
begin
  O := False;
  for B := Length(Name) downto 1 do
  begin
    F := False;
    case Name[B] of
      '.': if not LongFileNames then if KeepNonStandardExt and not O then O := True else F := True;
      #0..#31, '"', '*', '/', ':', '<', '>', '?', '\', '|': F := True;
      ' ', '+', ';', '[', ']': F := not LongFileNames;
    end;
    if F then Name[B] := '_';
  end;
end;

{Change the file extension of the DOS output file
  Input : Name: the file name to change
          ExtAttr: GEOS file attribute
          Attr: file attribute}
procedure ChangeExt(var Name: string; ExtAttr, Attr: Byte);
var
  B             : Boolean;
  S             : string[CBMNameLen];
begin
  B := (FileExt(Name) <> '');
  S := '';
  if (ExtAttr = 0) and (Attr = 2) then
  begin
    if not B and (PrgExt <> '') then S := PrgExt;
  end
  else
  begin
    if not KeepNonStandardExt or not B then
    begin
      if ExtAttr = 0 then
      begin
        case Attr of
          faDeleted..faRelative: S := ShortCBMExt[Attr];
          faFrozen: if Act^.CopyMode = pmTape then S := 'frz';
        end;
      end
      else
      begin
        S := 'cvt';
      end;
    end;
  end;
  if S <> '' then Name := Name + stDot + S;
end;

{Input destination file name
  Input : D: dialog box that informs the user about the process
          AllAndSkip: when True, 'All' and 'Skip' buttons are also displayed
  Output: when cmOK, the user confirms to execute the operation; when
          cmCancel, the user cancelled the operation, when cmSkip, the
          user cancelled the operation for this instance only}
function ManualFilename(var D: PDialog; AllAndSkip: Boolean): Word;
var
  U             : Boolean;
  C,
  H             : Word;
  J             : Integer;
  S,
  T             : string;
  I             : PInputLine;
  R             : TRect;
begin
  with Inact^ do
  begin
    U := GetPanelModeAttrib(CopyMode, paASCII);
    T := Other^.CopyName;
    if not GetPanelModeAttrib(Other^.CopyMode, paASCII) then T := MakeCBMName(T, Other^.CopyGEOSFormat);
    T := BoxTitle + ' "' + LimitNameLen(T, (MaxNameLen - 6 - Length(BoxTitle))) + '" to';
    MakeWinBounds(R, 66, 4);
    GetClock(True);
    GetMouse(True);
    if D <> nil then Dispose(D, Done);
    D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, True));
    R.Assign(5, 2, CBMStrLen(T), 1);
    D^.Insert(New(PCBMText, Init(R, T)));
    R.Assign(3, 4, 68, 1);
    D^.Insert(New(PSeparator, Init(R)));
    J := 28;
    if AllAndSkip then J := 19;
    R.Assign(J, 5, 6, 1);
    D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'O'+ColorChar+'K ]', cmOK)));
    J := 36;
    if AllAndSkip then
    begin
      R.Assign(27, 5, 7, 1);
      D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'A'+ColorChar+'ll ]', cmYes)));
      R.Assign(36, 5, 8, 1);
      D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'S'+ColorChar+'kip ]', cmNo)));
      J := 46;
    end;
    R.Assign(J, 5, 10, 1);
    D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'C'+ColorChar+'ancel ]', cmCancel)));
    R.Assign(5, 3, 64, 1);
    I := New(PInputLine, Init(R, 64, MaxFileNameLen, stEmpty, drNone));
    if U then T := CopyName else T := ConvertCBMName(CopyName, CopyGEOSFormat, True, hxPercent);
    I^.SetData(T);
    D^.Insert(I);
    H := CurHelpCtx;
    case ExecMode of
      exCloseWrite:
      begin
        S := ShellBuffer^.ViewFileName;
        C := cmOK;
      end;
    else
      C := Application^.ExecView(D, True, True);
      S := '';
    end;
    case C of
      cmOK, cmYes:
      begin
        I^.GetData(S);
        ShellBuffer^.ViewFileName := S;
        if U then CopyName := S else CopyName := ReconvertCBMName(S, CopyGEOSFormat, True, hxPercent);
        MakeFullName;
      end;
    end;
    AppHelpCtx := H;
    CurHelpCtx := H;
    KeyBar^.Update;
    Dispose(D, Done);
    D := nil;
    SetMouse;
    SetClock;
  end;
  ManualFilename := C;
end;

{Prepare writing into a file: when copying between CBM and DOS panels,
  perform and confirm file name conversion
  Input : D: the dialog box that informs the user about the process
          Ask: when True, file name conversion has to be confirmed by the
               user
  Output: when False, the user cancelled the file name conversion}
function PrepareWrite(var D: PDialog; Ask: Boolean): Boolean;
var
  B,
  F,
  O,
  U,
  V             : Boolean;
  A,
  Q             : Byte;
  C             : Word;
  M,
  W,
  Z             : Integer;
  J             : PStaticText;
  E,
  N,
  P,
  S,
  T             : string;
begin
  Z := 0;
  with Act^ do
  begin
    P := LowerCase(FileExt(CopyName));
    if (CopyMode = pmDOS) and ((CopyExtractFileImages = xfAlways) or
      ((CopyExtractFileImages = xfCBMDest) and GetPanelModeAttrib(Other^.CopyMode, (paImage + paArchive)))) then
    begin
      A := MaxByte;
      for Q := faDeleted to faRelative do if P[1] = ShortCBMExt[Q][1] then A := Q;
      if (A <> MaxByte) and (P[2] in ['0'..'9']) and (P[3] in ['0'..'9']) then
      begin
        CopyImageName := CopyName;
        CopyMode := pmFile;
        CopyName := '';
        Z := OpenImage(False, False, True, True, False);
        if Z = 0 then
        begin
          ReadCBMEntry(Entry);
          CopyName := Entry.Name;
          CopyAttr := Entry.Attr;
          CopyDirPos := 0;
          MakeFullName;
        end;
        CloseImage(False);
        if Z = 255 then
        begin
          CopyName := CopyImageName;
          CopyMode := pmDOS;
        end;
      end;
    end;
  end;
  with Inact^ do
  begin
    if CopyMode = pmDOS then
    begin
      case CopyIntoFileImages of
        ifAlways: CopyMode := pmFile;
        ifCBMSrc: if GetPanelModeAttrib(Other^.CopyMode, (paImage + paArchive)) then CopyMode := pmFile;
      end;
    end;
    FailSysErrors := fsAll;
    O := True;
    B := False;
    A := Other^.CopyAttr and faTypeMask;
    Q := Other^.CopyExtAttr;
    V := GetPanelModeAttrib(Other^.CopyMode, paASCII);
    if CopyMode = pmFile then Ask := False;
    U := GetPanelModeAttrib(CopyMode, paASCII);
    if U then
    begin
      if V then
      begin
        T := Other^.CopyName;
        if CopyMode = pmDOS then
        begin
          if Other^.CopyMode <> pmDOS then
          begin
            DropInvalidChars(T);
            ChangeExt(T, Q, A);
            B := True;
          end;
          CopyName := CloneDOSName(T, NamePattern);
        end
        else
        begin
          if Other^.CopyMode = pmDOS then B := True;
          CopyName := CloneName(T, NamePattern, False, False);
        end;
      end
      else
      begin
        N := Other^.CopyName;
        T := MakeCBMName(N, Other^.CopyGEOSFormat);
        S := ConvertCBMName(N, Other^.CopyGEOSFormat, True, hxPercent);
        O := ((A in [faDeleted..faRelative]) or ((A = faFrozen) and (Other^.CopyMode = pmTape)));
        if O then
        begin
          DropInvalidChars(S);
          if CopyMode = pmDOS then
          begin
            while (Length(S) > 0) and (S[1] = '_') do S := Copy(S, 2, MaxStrLen);
            M := RightPos('.', S);
            if M > 0 then while (M < Length(S)) and (S[M + 1] = '_') do S := Copy(S, 1, M) + Copy(S, M + 2, MaxStrLen);
            S := CutChar(S, '_');
            M := RightPos('.', S);
            if M > 0 then
            begin
              while (M > 1) and (S[M - 1] = '_') do
              begin
                S := Copy(S, 1, M - 2) + Copy(S, M, MaxStrLen);
                Dec(M);
              end;
            end;
            if S = '' then S := '_';
            CopyName := S;
            ChangeExt(CopyName, Q, A);
            CopyName := CloneDOSName(CopyName, NamePattern);
          end
          else
          begin
            CopyName := CloneName(S, NamePattern, True, True);
          end;
        end;
        B := True;
      end;
      S := CopyName;
    end
    else
    begin
      if V then
      begin
        F := True;
        T := Other^.CopyName;
        if not KeepUpperCase then T := LowerCase(T);
        A := MaxByte;
        S := ReconvertCBMName(T, CopyGEOSFormat, False, hxPercent);
        for M := 1 to Length(S) do if S[M] = chShiftSpace then S[M] := ' ';
        M := RightPos('.', S);
        N := '';
        if M > 1 then
        begin
          S[0] := Chr(M - 1);
          if RightPos('.', T) > 0 then
          begin
            M := Length(T);
            while (M >= 1) and (T[M] <> '.') do
            begin
              N := T[M] + N;
              Dec(M);
            end;
          end;
        end;
        P := N;
        if P = '' then
        begin
          if A = MaxByte then A := 2;
          F := False;
        end
        else
        begin
          if A = MaxByte then
          begin
            if LowerCase(P) = LowerCase(PrgExt) then N := #0;
            for Q := faDeleted to faRelative do if LowerCase(P) = ShortCBMExt[Q] then A := Q;
          end;
          if A = MaxByte then
          begin
            if KeepNonStandardExt and (N <> #0) then
            begin
              F := False;
              N := ReconvertCBMName(N, CopyGEOSFormat, False, hxPercent);
              for M := 1 to Length(N) do if N[M] = chShiftSpace then N[M] := ' ';
              S := S + stDot + N;
            end;
            A := 2;
          end;
          if F then
          begin
            M := RightPos('.', T);
            if M > 0 then T[0] := Chr(M - 1);
          end;
        end;
        CopyName := CloneName(S, NamePattern, True, True);
        B := True;
      end
      else
      begin
        N := Other^.CopyName;
        T := MakeCBMName(N, Other^.CopyGEOSFormat);
        CopyName := CloneName(N, NamePattern, True, True);
        O := ((A in [faDeleted..faRelative]) or ((A = faFrozen) and (Other^.CopyMode = pmTape)));
      end;
      S := MakeCBMName(CopyName, CopyGEOSFormat);
    end;
    if O then
    begin
      case CopyMode of
        pmDOS:
        begin
          CheckPath;
          if TrueName(CopyRealPath) = TrueName(Other^.CopyRealPath) then SameAsPanel := True;
        end;
        pmExt, pmDisk, pmTape, pmLynx..pmFileZip, pmGCRDisk..pmSixZip: MakeName;
        pmFile:
        begin
          CheckPath;
          B := False;
          Q := 0;
          S := LowerCase(MakePC64Name(CopyName));
          if IsDeviceName(S) then if Length(S) >= 8 then S[Length(S)] := '_' else S := S + '_';
          S := S + stDot + ShortCBMExt[A][1];
          while not B do
          begin
            CopyImageName := S + LeadingZero(Q, 2);
            MakeFullName;
            T := AddToPath(CopyPath, CopyImageName, chDirSep);
            if FileExists(T, False) then
            begin
              Inc(Q);
              if Q = 100 then
              begin
                Q := 0;
                B := True;
              end;
            end
            else
            begin
              B := True;
            end;
          end;
        end;
      end;
    end;
    if O then
    begin
      if Ask and B and ConvertConfirm and not AllConvert then
      begin
        C := ManualFilename(D, not (((CopyFileMode = cfSelected) and (Other^.SelNum = 0)) or (CopyFileMode = cfSingle)));
        case C of
          cmYes: AllConvert := True;
          cmCancel:
          begin
            O := False;
            ContProcess := False;
          end;
          cmNo: O := False;
        end;
      end
      else
      begin
        O := not Escape;
        ContProcess := O;
      end;
    end;
    FirstFile := False;
    PrepareWrite := O;
    FailSysErrors := fsNone;
  end;
end;

end.
