
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    FWRITE.PAS                   }
{                                                 }
{    The Star Commander write output file unit    }
{*************************************************}

unit FWrite;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Base2;

procedure WritePart(Buffer: PBuffer; Len: Word; FileEnd: Boolean);

implementation

uses
  Views,
  Base1, Constant, ExtFiles, LowLevel, Panel1, Panel2, XferLo;

{Allocates a new side sector for the relative file
  Output: when True, a new side sector for successfully allocated}
function AllocSideSector: Boolean;
var
  S,
  T             : Byte;
begin
  with Inact^ do
  begin
    T := Track;
    S := Sector;
    AllocSideSector := NextCopyBlock;
    SideTrack := Track;
    SideSector := Sector;
    Track := T;
    Sector := S;
    Inc(Block);
  end;
end;

{Finishes the current side sector, writes it onto disk and initializes the
  next side sector
  Output: when True, a new side sector was successfully allocated}
function NextSideSector: Boolean;
var
  F             : Boolean;
  B,
  S,
  T,
  U,
  V             : Byte;
begin
  with Inact^ do
  begin
    T := SideTrack;
    S := SideSector;
    F := AllocSideSector;
    if F then
    begin
      SideBuffer[0] := SideTrack;
      SideBuffer[1] := SideSector;
    end;
    SidePos := SideSecStart;
    if T > 0 then WriteDiskBlock(T, S, @SideBuffer);
    Inc(SideNumber);
    if SideNumber >= SideSecPerGroup then
    begin
      SideNumber := 0;
      Inc(SideGroup);
    end;
    B := SideSecStart;
    if SideNumber = 0 then
    begin
      B := 0;
      SideListPos := SideListStart;
    end;
    FillChar(SideBuffer[B], 256 - B, 0);
    SideBuffer[2] := SideNumber;
    SideBuffer[3] := CopyRecordLen;
    SideBuffer[SideListPos] := SideTrack;
    SideBuffer[SideListPos + 1] := SideSector;
    Inc(SideListPos, 2);
    NextSideSector := F;
  end;
end;

{Write a buffer of data into the output file
  Input : Buffer: buffer to contain the data read
          Len: length of the data read
          FileEnd: when True, the input file has ended}
procedure WritePart(Buffer: PBuffer; Len: Word; FileEnd: Boolean);
var
  F,
  G,
  L,
  O,
  R,
  V             : Boolean;
  M,
  P,
  Q,
  T,
  S             : Byte;
  B,
  C             : Word;
  I             : Integer;
  X,
  Z             : Longint;
  N             : string;
begin
  with Inact^ do
  begin
    InOutRes := 0;
    I := 0;
    if ExecMode = exNormal then
    begin
      L := CancelTransfer(CopyMode = pmExt);
      if L then
      begin
        Error := True;
        ContProcess := False;
      end
      else
      begin
        case CopyMode of
          pmDOS, pmLynx, pmArkive, pmLHA, pmZIP:
          begin
            if (not GetPanelModeAttrib(CopyMode, paExternalArch) or not TempInputOpen) and (Len > 0) then
            begin
              ExtBlockWrite2(WriteFile, Buffer^, Len, B);
              Error := ((IOResult <> 0) or (B < Len));
              DiskFull := IsDiskFile(WriteFile) and (B = 0);
              Len := B;
            end;
          end;
          pmExt:
          begin
            X := 0;
            Z := 0;
            case CopyTransferMode of
              tmNormal:
              begin
                L := CancelTransfer(True);
                Status := 0;
                while (Status = 0) and not L and (Z < Len) do
                begin
                  DisplayProgress;
                  Z := X;
                  if X + 254 < Len then X := X + 254 else X := Len;
                  asm
                    mov bx, word ptr Z;
                    les di, Buffer;
                @2: cmp Status, 0;
                    jne @1;
                    cmp bx, word ptr X;
                    jae @1;
                    mov al, es:[di][bx];
                    push bx;
                    call Send;
                    pop bx;
                    inc bx;
                    jmp @2;
                @1: mov word ptr Z, bx;
                  end;
                  L := CancelTransfer(True);
                  Inc(CopiedBlock);
                end;
                Error := (L or (Status > 0));
                if Error then ReadCBMError(N, False, False, True);
              end;
              tmTurbo:
              begin
                if FirstBlock then
                begin
                  asm
                    mov ax, 50;
                    call Delay;
                  end;
                  TurboOn := (SendDriveProg(deTurboFileSave, True) and ExecDriveProg(deTurboFileSave, stEmpty));
                  Error := not TurboOn;
                end
                else
                begin
                  Error := False;
                end;
                if not Error then
                begin
                  L := CancelTransfer(True);
                  while (Status = 0) and not L and (Z < Len) do
                  begin
                    DisplayProgress;
                    Z := X;
                    if X + 254 < Len then X := X + 254 else X := Len;
                    asm
                      mov bx, word ptr Z;
                      les di, Buffer;
                      push word ptr CopyPriorityMode;
                      call InterruptOff;
                      call ParallelOutput;
                  @2: cmp Status, 0;
                      jne @1;
                      cmp bx, word ptr X;
                      jae @1;
                      mov al, es:[di][bx];
                      push bx;
                      call TSend;
                      pop bx;
                      inc bx;
                      jmp @2;
                  @1: mov word ptr Z, bx;
                      mov ax, 50;
                      call Delay;
                      call ParallelInput;
                      call InterruptOn;
                    end;
                    L := CancelTransfer(True);
                    Inc(CopiedBlock);
                  end;
                  Error := (L or (Status > 0));
                end;
              end;
              tmWarp:
              begin
                if FirstBlock then
                begin
                  CopyStep := DriveInts[DriveIntIndex + 1];
                  TurboOff;
                  if SendDriveProg(deWarpFileSave, True) and ExecDriveProg(deWarpFileSave, stEmpty) then
                  begin
                    TurboOn := True;
                    Error := False;
                    FillChar(BAM, 256, 0);
                    FillChar(BAM2, 256, 0);
                    CopyTransferMode := tmTurbo;
                    S := 0;
                    case CopyDiskType and dtTypeMask of
                      dt1541, dt1541Ext: ReadDirBlock(@BAM);
                      dt1571:
                      begin
                        ReadDirBlock(@BAM);
                        ReadDirBlock(@BAM2);
                      end;
                    end;
                    asm
                      push word ptr CopyPriorityMode;
                      call InterruptOff;
                      call ParallelInput;
                      call TReceive;
                      mov S, al;
                      call TReceive;
                      mov T, al;
                      call InterruptOn;
                    end;
                    ReadDirBlock(@DirBuffer);
                    CopyTransferMode := tmWarp;
                    DirSector := S;
                    EntryPos := T and $E0;
                    AllocBlock(DirTrack, DirSector, True);
                    if Len = 0 then
                    begin
                      Buffer^[0] := Ord(chReturn);
                      Inc(Len);
                    end;
                    if FirstCopyBlock then
                    begin
                      DirBuffer[EntryPos + 3] := Track;
                      DirBuffer[EntryPos + 4] := Sector;
                    end
                    else
                    begin
                      ContProcess := ErrorWin(stError, ReadErrorStr(72, 0, 0), stEmpty, CurHelpCtx, sbSkip);
                      Error := True;
                    end;
                  end;
                end;
                F := False;
                V := FirstBlock;
                O := True;
                X := 0;
                while not Error and not L and (X < Len) do
                begin
                  if V or F then
                  begin
                    V := False;
                    Error := not (SendDriveProg(deWarpDiskSave, True) and ExecDriveProg(deWarpDiskSave, stEmpty));
                  end
                  else
                  begin
                    Error := False;
                  end;
                  if not Error then
                  begin
                    if O then
                    begin
                      TrackMap[TrackMapSize] := 0;
                      FillChar(TrackMap, SectorNum(Track), 1);
                      M := 0;
                      repeat
                        if X + 254 < Len then Z := 254 else Z := Len - X;
                        if Z < 254 then FillFormatPattern(@DataBuffer);
                        Move(Buffer^[X], DataBuffer[2], Z);
                        T := Track;
                        S := Sector;
                        if (X + 254 < Len) or not FileEnd then
                        begin
                          F := NextCopyBlock;
                        end
                        else
                        begin
                          F := True;
                          Track := 0;
                          Sector := Z + 1;
                        end;
                        DataBuffer[0] := Track;
                        DataBuffer[1] := Sector;
                        Move(DataBuffer, TempBuffer, 256);
                        B := S * 325;
                        GCRError := dsOK;
(* ?ASM? *)
                        asm
                          mov si, Offset(TempBuffer);
                          mov di, Offset(GCRBuffer);
                          add di, B;
                          mov al, True;
                          call GCREncodeSector;
                        end;
                        O := False;
                        TrackMap[S] := 0;
                        Inc(TrackMap[TrackMapSize]);
                        Inc(M);
                        Inc(X, Z);
                      until (T <> Track) or (X >= Len);
                      P := Track;
                      Q := Sector;
                      Track := T;
                      Sector := 0;
                      while TrackMap[Sector] > 0 do Inc(Sector);
                      TrackMap[Sector] := 1;
                      Dec(TrackMap[TrackMapSize]);
                    end;
                    if F then
                    begin
                      F := False;
                      while (M > 0) and not F and not L and not Error do
                      begin
                        L := CancelTransfer(True);
                        if not L then
                        begin
                          S := Sector;
                          B := S * 325;
                          asm
                            push word ptr CopyPriorityMode;
                            call InterruptOff;
                            call ParallelOutput;
                            mov al, S;
                            call TSend;
                            mov al, T;
                            call TSend;
                            mov ax, 50;
                            call Delay;
                            mov si, Offset(GCRBuffer);
                            add si, B;
                            mov di, 325;
                        @1: mov al, [si];
                            call TSend;
                            inc si;
                            dec di;
                            jne @1;
                            mov ax, 50;
                            call Delay;
                            call ParallelInput;
                            call TWait;
                            call InterruptOn;
                          end;
                          if Status = 0 then
                          begin
                            NextSector(True);
                            Dec(M);
                            Inc(Block);
                            Inc(CopiedBlock);
                            DisplayProgress;
                          end
                          else
                          begin
                            TurboOff;
                            CloseCBMChannel(saSave);
                            ReadCBMError(N, False, False, True);
                            Error := (DiskErrorWin(stError, N, stEmpty, CurHelpCtx, False, False, False) <> cmOK);
                            F := True;
                          end;
                        end;
                      end;
                      if not F then
                      begin
                        O := True;
                        Track := P;
                        Sector := Q;
                      end;
                    end
                    else
                    begin
                      ContProcess := ErrorWin(stError, ReadErrorStr(72, 0, 0), stEmpty, CurHelpCtx, sbSkip);
                      Error := True;
                    end;
                  end;
                end;
                Error := Error or L;
              end;
            end;
          end;
          pmDisk:
          begin
            if Len > 0 then
            begin
              X := 0;
              F := True;
              R := (CopyAttr and faTypeMask = faRelative);
              L := (CopyDiskType and dtTypeMask = dt1581);
              if FirstBlock then
              begin
                if R then
                begin
                  F := NextSideSector;
                  P := SideTrack;
                  Q := SideSector;
                  if F and L then
                  begin
                    T := SideTrack;
                    S := SideSector;
                    F := AllocSideSector;
                    FillChar(DataBuffer, 256, 0);
                    DataBuffer[0] := T;
                    DataBuffer[1] := S;
                    DataBuffer[2] := CopyRecordLen;
                    WriteDiskBlock(SideTrack, SideSector, @DataBuffer);
                    P := SideTrack;
                    Q := SideSector;
                    SideTrack := T;
                    SideSector := S;
                  end;
                  if F then
                  begin
                    DirBuffer[EntryPos + 21] := P;
                    DirBuffer[EntryPos + 22] := Q;
                  end;
                  DirBuffer[EntryPos + 23] := CopyRecordLen;
                end;
                if CopyExtAttr > 0 then
                begin
                  X := 2 * 254;
                  Inc(Block);
                  DataBuffer[0] := 0;
                  DataBuffer[1] := MaxByte;
                  Move(Buffer^[254], DataBuffer[2], 254);
                  WriteDiskBlock(Track, Sector, @DataBuffer);
                  I := IOResult;
                  if I = 0 then
                  begin
                    Buffer^[19] := Track;
                    Buffer^[20] := Sector;
                    F := NextCopyBlock;
                    if F then
                    begin
                      SideTrack := Track;
                      SideSector := Sector;
                      Buffer^[1] := Track;
                      Buffer^[2] := Sector;
                      Move(CopyName[1], Buffer^[3], CBMNameLen);
                      Move(Buffer^[1], DirBuffer[EntryPos + 3], 27);
                      CopyAttr := Buffer^[0];
                      if CopyExtAttr and xaGEOSVLIR > 0 then
                      begin
                        Inc(X, 254);
                        F := NextCopyBlock;
                        if F then
                        begin
                          Inc(Block);
                          Move(Buffer^[2 * 254], SideBuffer[2], 254);
                          SideBuffer[0] := 0;
                          SideBuffer[1] := MaxByte;
                          SidePos := 0;
                          CopyPartBlock := 0;
                        end;
                      end;
                    end;
                    Inc(CopiedSize, X);
                  end;
                end;
              end;
              G := (CopyExtAttr and xaGEOSVLIR > 0);
              while F and (X < Len) and (I = 0) do
              begin
                if G and (CopyPartBlock = 0) then
                begin
                  repeat
                    Inc(SidePos, 2);
                  until (SidePos = 0) or (SideBuffer[SidePos] > 0);
                  if SidePos > 0 then
                  begin
                    CopyPartBlock := SideBuffer[SidePos];
                    CopyPartByte := SideBuffer[SidePos + 1];
                    SideBuffer[SidePos] := Track;
                    SideBuffer[SidePos + 1] := Sector;
                  end;
                end;
                if G and (CopyPartBlock = 1) then
                begin
                  Z := CopyPartByte - 1;
                  if CopyPartByte < 2 then Z := 0;
                end
                else
                begin
                  if X + 254 < Len then Z := 254 else Z := Len - X;
                end;
                if Z < 254 then FillFormatPattern(@DataBuffer);
                Move(Buffer^[X], DataBuffer[2], Z);
                T := Track;
                S := Sector;
                if (X + 254 < Len) or not FileEnd then
                begin
                  F := NextCopyBlock;
                end
                else
                begin
                  F := True;
                  Track := 0;
                  Sector := Z + 1;
                end;
                if G and (CopyPartBlock = 1) then
                begin
                  DataBuffer[0] := 0;
                  DataBuffer[1] := CopyPartByte;
                end
                else
                begin
                  DataBuffer[0] := Track;
                  DataBuffer[1] := Sector;
                end;
                WriteDiskBlock(T, S, @DataBuffer);
                I := IOResult;
                if I = 0 then
                begin
                  Inc(Block);
                  if G then
                  begin
                    Inc(X, 254);
                    Dec(CopyPartBlock);
                  end
                  else
                  begin
                    Inc(X, Z);
                  end;
                  if R then
                  begin
                    if (SidePos = 0) and (X < Len) then F := F and NextSideSector;
                    SideBuffer[SidePos] := T;
                    SideBuffer[SidePos + 1] := S;
                    Inc(SidePos, 2);
                  end;
                  Inc(CopiedSize, 254);
                  DisplayProgress;
                end;
              end;
              if not F then
              begin
                ContProcess := ErrorWin(stEmpty, 'The following image file is full',
                  AddToPath(CopyPath, CopyImageName, chDirSep), CurHelpCtx, sbNone);
                Error := True;
                I := 253;
              end;
            end;
            Error := Error or (I <> 0);
          end;
          pmTape:
          begin
            if FirstBlock then
            begin
              if Len = 0 then
              begin
                StartLo := 0;
                StartHi := 0;
              end
              else
              begin
                StartLo := Buffer^[0];
                StartHi := Buffer^[1];
                Buffer := @Buffer^[2];
                Dec(Len, 2);
              end;
            end;
            ExtBlockWrite(Image, Buffer^, Len);
            Error := (IOResult <> 0);
          end;
          pmFile:
          begin
            ExtBlockWrite(WriteFile, Buffer^, Len);
            Error := (IOResult <> 0);
          end;
          pmTAR:
          begin
            ExtBlockWrite(Image, Buffer^, Len);
            Error := (IOResult <> 0);
          end;
          pmFileZip:
          begin
            B := 0;
            while (B < Len) and not Error do
            begin
              if FileSizeWarning and (ImagePos >= DiskMaxFree(CopyDiskType) * 254) then
              begin
                if not FileSizeWarned then
                begin
                  FileSizeWarned := True;
                  O := (SureConfirm(stEmpty, 'You may not be able to extract', 'the following archive on a 1541 drive.',
                    AddToPath(CopyPath, CopyImageName, chDirSep), stDoYouStillWishToContinue,
                    stYes, stEmpty, stEmpty, stEmpty, stNo, nil, CurHelpCtx, ayNone, False, DummyByte) = cmOK);
                end;
              end
              else
              begin
                O := True;
              end;
              if O then Error := (OpenZipFile(Image, ImagePos, 0, fmReadWrite) <> 0) else Error := True;
              if Error then
              begin
                Len := B;
              end
              else
              begin
                ExtSeek(Image, ArcSize + 3);
                P := ImagePos mod FileZipBlocks;
                while (B < Len) and (P < FileZipBlocks) do
                begin
                  if (B + 254 < Len) or not FileEnd then
                  begin
                    T := 1;
                    S := 0;
                  end
                  else
                  begin
                    T := 0;
                    S := Len mod 254;
                    if S = 0 then S := 254 else FillChar(Buffer^[Len], S, 0);
                    Inc(S);
                  end;
                  WriteZipCodeBlock(Image, @Buffer^[B], True, T, S);
                  Inc(B, 254);
                  Inc(ImagePos);
                  Inc(P);
                end;
                ExtSeek(Image, 2);
                ExtBlockWrite(Image, P, 1);
              end;
            end;
          end;
        end;
      end;
    end;
    FirstBlock := False;
    if CopyMode in [pmDOS, pmTape, pmFile, pmLynx..pmFileZip] then
    begin
      Inc(DestSize, Len);
      if Other^.CopyMode = pmDisk then
      begin
        P := Len mod 254;
        if P > 0 then Inc(Len, 254 - P);
      end;
      Inc(CopiedSize, Len);
    end;
    DisplayProgress;
  end;
end;

end.
