
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                     HELP.PAS                    }
{                                                 }
{           The Star Commander Help unit          }
{*************************************************}

unit Help;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Dialogs, Drivers, Objects, Views,
  Base2;

type
{Online help display}
  TOnlineHelp   = object(TView)
    Delta,
    Limit       : TPoint;
    procedure Draw; virtual;
  end;
  POnlineHelp   = ^TOnlineHelp;
{Online help dialog box}
  THelpWin      = object(TDialog)
    LoSeparator,
    HiSeparator : PSeparator;
    constructor Init(Bounds: TRect);
    procedure InitHelp(L: Word);
    procedure HandleEvent(var Event: TEvent); virtual;
  end;
  PHelpWin      = ^THelpWin;

procedure MakeHelpLine;
function ReadHelpEntry(N: Byte; var L: Longint): Integer;
function SearchHelpStr(const S: string; Len: Word): Word;
function CountLines(Len: Word): Byte;
procedure _Help;

var
  HelpWin       : PHelpWin;
  OnlineHelp    : POnlineHelp;

implementation

uses
  App, Menus,
  Base1, Constant, ExtFiles, LowLevel;

{Read the specified entry from the online help file
  Input : N: the number of the entry to be read
          L: long integer to contain the length of the entry data
  Output: when not 0, an error occured}
function ReadHelpEntry(N: Byte; var L: Longint): Integer;
var
  O             : Boolean;
  I,
  Y             : Integer;

{Check if an entry in the online help file is valid
  Input : F: start offset of the data to be decoded
          G: start offset of the data to be checked
          L: end offset of the data}
function IsEntryOK(F, G, L: Longint): Boolean;
var
  X,
  S             : Byte;
  I             : Longint;
begin
  X := 0;
  S := 0;
  for I := F to L - 1 do TempBuffer[I] := TempBuffer[I];
  for I := G to L - 3 do
  begin
    X := X xor TempBuffer[I];
    S := S - TempBuffer[I];
  end;
  IsEntryOK := ((X = TempBuffer[L - 2]) and (S = TempBuffer[L - 1]));
end;

begin
  HelpOK := True;
  O := ClockVis;
  ClockOff;
  I := LongOpenFile(AddToPath(HomePath, HelpFileName, chDirSep), HelpFile, fmReadOnly);
  if I = 0 then
  begin
    ExtBlockRead(HelpFile, TempBuffer, HelpHeaderLen);
    for Y := 0 to Length(HelpSign) - 1 do if TempBuffer[Y] <> Ord(HelpSign[Y + 1]) then HelpOK := False;
    if HelpOK then
    begin
      HelpOK := IsEntryOK(HelpTableStart, 0, HelpHeaderLen);
      if HelpOK then
      begin
        N := N * 3 + HelpTableStart;
        L := BytesToLongint(TempBuffer[N], TempBuffer[N + 1], TempBuffer[N + 2], 0);
        ExtSeek(HelpFile, L);
        L := BytesToLongint(TempBuffer[N + 3], TempBuffer[N + 4], TempBuffer[N + 5], 0) - L;
        ExtBlockRead(HelpFile, TempBuffer, L);
        HelpOK := IsEntryOK(0, 0, L);
        Dec(L, 2);
      end;
    end;
    ExtClose(HelpFile);
  end;
  ReadHelpEntry := I;
  if O then ClockOn else ClockOff;
end;

{Move a line up in the display}
procedure HUp;
begin
  if HelpNum = 0 then
  begin
    if HelpCur > 1 then Dec(HelpCur);
    if OnlineHelp^.Delta.Y > HelpCur - 1 then Dec(OnlineHelp^.Delta.Y);
  end
  else
  begin
    if OnlineHelp^.Delta.Y > 0 then Dec(OnlineHelp^.Delta.Y);
  end;
  OnlineHelp^.DrawView;
end;

{Move a line down in the display}
procedure HDown;
begin
  if HelpNum = 0 then
  begin
    if HelpCur < HelpMax - 1 then Inc(HelpCur);
    if OnlineHelp^.Delta.Y < HelpCur - WinSize + 10 then Inc(OnlineHelp^.Delta.Y);
  end
  else
  begin
    if OnlineHelp^.Delta.Y < HelpMax - WinSize + 9 then Inc(OnlineHelp^.Delta.Y);
  end;
  OnlineHelp^.DrawView;
end;

{Move a page up in the display}
procedure HPgUp;
begin
  if HelpNum = 0 then
  begin
    if OnlineHelp^.Delta.Y = 0 then
    begin
      HelpCur := 1;
    end
    else
    begin
      if HelpCur < WinSize - 10 then
      begin
        OnlineHelp^.Delta.Y := 0;
      end
      else
      begin
        if OnlineHelp^.Delta.Y > WinSize - 11 then Dec(OnlineHelp^.Delta.Y, WinSize - 11) else OnlineHelp^.Delta.Y := 0;
      end;
    end;
  end
  else
  begin
    if OnlineHelp^.Delta.Y > WinSize - 11 then Dec(OnlineHelp^.Delta.Y, WinSize - 11) else OnlineHelp^.Delta.Y := 0;
  end;
  OnlineHelp^.DrawView;
end;

{Move a page down in the display}
procedure HPgDn;
begin
  if HelpNum = 0 then
  begin
    if OnlineHelp^.Delta.Y > HelpMax - WinSize + 8 then
    begin
      HelpCur := HelpMax - 1;
    end
    else
    begin
      if HelpCur > HelpMax - WinSize + 10 then
      begin
        if HelpMax > WinSize - 10 then OnlineHelp^.Delta.Y := HelpMax - WinSize + 9 else OnlineHelp^.Delta.Y := 0;
      end
      else
      begin
        if OnlineHelp^.Delta.Y < HelpMax - (WinSize shl 1) + 20 then Inc(OnlineHelp^.Delta.Y, WinSize - 11) else
          OnlineHelp^.Delta.Y := HelpMax - WinSize + 9;
      end;
    end;
  end
  else
  begin
    if HelpMax < WinSize - 9 then
    begin
      OnlineHelp^.Delta.Y := 0;
    end
    else
    begin
      if OnlineHelp^.Delta.Y < HelpMax - (WinSize shl 1) + 20 then Inc(OnlineHelp^.Delta.Y, WinSize - 11) else
        OnlineHelp^.Delta.Y := HelpMax - WinSize + 9;
    end;
  end;
  OnlineHelp^.DrawView;
end;

{Move to the first line in the display}
procedure HHome;
begin
  OnlineHelp^.Delta.Y := 0;
  HelpCur := 1;
  OnlineHelp^.DrawView;
end;

{Move to the last line in the display}
procedure HEnd;
begin
  if HelpMax > WinSize - 9 then OnlineHelp^.Delta.Y := HelpMax - WinSize + 9 else OnlineHelp^.Delta.Y := 0;
  HelpCur := HelpMax - 1;
  OnlineHelp^.DrawView;
end;

{Initialize the online help dialog box
  Input : Bounds: bounds of the online help dialog box}
constructor THelpWin.Init(Bounds: TRect);
begin
  TDialog.Init(Bounds, 'Help', fxNormal, fyNormal, False);
  Options := Options and ofSelectable;
  Palette := wpHelp;
end;

{Count the number of lines, up to an offset into the online help page
  Input : L: the end offset of the page area
  Output: the number of lines}
function CountLines(Len: Word): Byte;
var
  B             : Byte;
  W             : Word;
begin
  B := 0;
  for W := 0 to Len - 1 do if TempBuffer[W] = hfEOL then Inc(B);
  CountLines := B;
end;

{Compute the number of lines in the online help file data
  Input : L: length of useful online help data in the buffer}
procedure THelpWin.InitHelp(L: Word);
begin
  HelpMax := CountLines(L);
end;

{Handle events in the online help dialog box
  Input : Event: event record to be handled}
procedure THelpWin.HandleEvent(var Event: TEvent);
var
  O             : Boolean;
  X,
  Y,
  V             : Integer;
  P             : TPoint;
begin
  if Event.What and evKeyboard > 0 then
  begin
    O := True;
    case Event.KeyCode of
      kbUp: HUp;
      kbDown: HDown;
      kbPgUp: HPgUp;
      kbPgDn: HPgDn;
      kbHome: HHome;
      kbEnd: HEnd;
      kbCtrlPgUp: HHome;
      kbCtrlPgDn: HEnd;
    else
      O := False;
    end;
    if O then ClearEvent(Event);
  end;
  if Event.What and evMouse > 0 then
  begin
    MakeLocal(Event.Where, P);
    X := P.X;
    Y := P.Y;
    if (Event.Buttons > 0) and (X > 3) and (X < 68) and (Y > 0) and (Y < WinSize - 3) then
    begin
      if HelpNum = 0 then
      begin
        if Event.What and evMouseAuto > 0 then
        begin
          if Y < 4 then HUp;
          if Y > WinSize - 7 then HDown;
        end;
        if (Y > 3) and (Y < WinSize - 6) and (OnlineHelp^.Delta.Y + Y - 3 < HelpMax) then
        begin
          HelpCur := OnlineHelp^.Delta.Y + Y - 3;
          OnlineHelp^.DrawView;
          if Event.Double then
          begin
            repeat
            until not MouseEvent(Event, evMouseMove);
            MakeLocal(Event.Where, P);
            if (P.Y = Y) and (P.X > 3) and (P.X < 68) then
            begin
              Event.What := evCommand;
              Event.Command := cmOK;
            end;
          end;
        end;
      end
      else
      begin
        if (Y > 3) and (Y < WinCenter shr 1 + 4) then HUp;
        if (Y < WinSize - 6) and (Y > WinSize - WinCenter shr 1 - 7) then HDown;
      end;
    end;
  end;
  TDialog.HandleEvent(Event);
  ClearEvent(Event);
end;

(* ?ASM? *)
{Convert a line of online help into screen dump
  Input : DS:SI: offset of the beginning of the current line}
procedure MakeHelpLine; assembler;
asm
    mov di, Offset(HelpBuffer[2]);
    push ds;
    pop es;
    mov ah, HelpAttr;
    xor dl, dl;
    mov cx, 62;
    cmp HelpNum, 0;
    jne @3;
    cmp al, HelpCur;
    jne @3;
    inc dl;
    mov ah, byte ptr HelpColors[2];
@3: jcxz @1;
    lodsb;
    cmp al, hfEOL;
    je @9;
    cmp al, hfNormal;
    jb @2;
    cmp al, hfUnderline;
    ja @2;
    or dl, dl;
    jne @3;
    sub al, hfNormal;
    mov bl, al;
    xor bh, bh;
    mov ah, byte ptr HelpColors[bx];
    jmp @3;
@2: cmp al, hfMultiply;
    jne @4;
    lodsb;
    push cx;
    mov cl, al;
    xor ch, ch;
    mov bx, cx;
    lodsb;
@5: stosw;
    loop @5;
    pop cx;
    sub cx, bx;
    jmp @3;
@4: cmp al, hfSpaces;
    jne @6;
    lodsb;
    push cx;
    mov cl, al;
    xor ch, ch;
    mov bx, cx;
    push ax;
    mov al, ' ';
@7: stosw;
    loop @7;
    pop ax;
    pop cx;
    sub cx, bx;
    jmp @3;
@6: cmp al, hfAnchor;
    je @3;
    stosw;
    loop @3;
@1: mov al, [si];
    cmp al, hfEOL;
    je @10;
    cmp al, hfUnderline;
    ja @9;
    lodsb;
    jmp @1;
@10:lodsb;
@9: or dl, dl;
    je @8;
    mov al, ' ';
    rep stosw;
@8:
end;

{Draw the online help display}
procedure TOnlineHelp.Draw;
var
  C             : Byte;
  I,
  Y             : Integer;
begin
  for C := 0 to 3 do HelpColors[C] := GetColor(C + 1);
  HelpAttr := GetColor(1);
  if HelpCur < Delta.Y + 1 then HelpCur := Delta.Y + 1;
  if HelpCur > Delta.Y + WinSize - 10 then HelpCur := Delta.Y + WinSize - 10;
  MoveChar(HelpBuffer, ' ', HelpAttr, 64);
(* ?ASM? *)
  asm
    mov si, Offset(TempBuffer);
    xor ax, ax;
    call MakeHelpLine;
  end;
  WriteBuf(0, 0, 64, 1, HelpBuffer);
  MoveChar(HelpBuffer, ' ', HelpAttr, 64);
  WriteBuf(0, 1, 64, 1, HelpBuffer);
  Y := Delta.Y;
(* ?ASM? *)
  asm
    push es;
    mov di, Offset(TempBuffer);
    mov bx, Y;
    or bx, bx;
    jns @3;
    xor bx, bx;
@3: inc bx;
    push ds;
    pop es;
    mov al, hfEOL;
@2: mov cx, MaxWord;
    repnz scasb;
    jnz @1;
    dec bx;
    jne @2;
@1: mov HelpPos, di;
    pop es;
  end;
  for I := 0 to WinSize - 11 do
  begin
    MoveChar(HelpBuffer, ' ', HelpAttr, 64);
    if Y < HelpMax - 1 then
    begin
(* ?ASM? *)
      asm
        mov si, HelpPos;
        mov ax, Y;
        inc ax;
        call MakeHelpLine;
        mov HelpPos, si;
      end;
    end;
    WriteBuf(0, I + 2, 64, 1, HelpBuffer);
    Inc(Y);
  end;
end;

{Search for an anchor string in the online help page text
  Input : S: the uppercase string to search for
          Len: the offset to search up to
  Output: the offset where the string was found; zero, if not found}
function SearchHelpStr(const S: string; Len: Word): Word;
var
  F             : Boolean;
  W,
  X,
  Y             : Word;
begin
  W := 0;
  F := False;
  while not F and (W < Len) do
  begin
    case TempBuffer[W] of
      hfMultiply: Inc(W, 2);
      hfSpaces: Inc(W);
      hfAnchor:
      begin
        X := W + 1;
        Y := 1;
        F := True;
        while F and (X < Len) and (Y <= Length(S)) do
        begin
          F := (UpCase(Chr(TempBuffer[X])) = S[Y]);
          Inc(X);
          Inc(Y);
        end;
        F := F and (Y > Length(S)) and (TempBuffer[X] = hfNormal);
      end;
    end;
    if not F then Inc(W);
  end;
  if not F then W := 0;
  SearchHelpStr := W;
end;

{'Help' item in the 'Files' menu: pop up the online help}
procedure _Help;
var
  B,
  F,
  O,
  X             : Boolean;
  H,
  Y             : Byte;
  C,
  W             : Word;
  L             : Longint;
  I1,
  I2,
  I3,
  I4            : PButton;
  P             : PDialog;
  U,
  V             : PView;
  Z             : PString;
  D             : TPalette;
  T             : string[40];
  S             : string;
  Q             : TPoint;
  R             : TRect;
begin
  HelpInUse := True;
  W := CurHelpCtx;
  CurHelpCtx := hcOnlyQuit;
  AppHelpCtx := hcOnlyQuit;
  LastShiftState := MaxByte;
  T := BoxTitle;
  BoxTitle := 'Help';
  HelpCur := 0;
  P := PriorityMenu;
  PriorityMenu := nil;
  F := True;
  B := True;
  O := False;
  V := PGroup(Application^.TopView)^.Current;
  Q := V^.Origin;
  S := '';
  X := True;
  I3 := nil;
  I4 := nil;
  case V^.ViewType of
    vtInputLine: Z := PInputLine(V)^.Title;
    vtCluster: Z := PString(PCluster(V)^.Strings.At(PCluster(V)^.Sel));
    vtHistory: Z := @PHistory(V)^.CurItem^.Title;
  else
    X := False;
  end;
  if ((Z = nil) or (Z^ = '')) and (V^.ViewType = vtCluster) and (V^.Prev <> nil) and (V^.Prev^.ViewType = vtCluster) then
  begin
    Z := PString(PCluster(V^.Prev)^.Strings.At(PCluster(V)^.Sel));
  end;
  if Z <> nil then S := UpperCase(Z^);
  MakeWinBounds(R, 64, WinSize - 6);
  HelpWin := New(PHelpWin, Init(R));
  HelpWin^.SetState(sfVisible, False);
  R.Assign(3, 3, 66, 1);
  HelpWin^.HiSeparator := New(PSeparator, Init(R));
  R.Assign(3, WinSize - 6, 66, 1);
  HelpWin^.LoSeparator := New(PSeparator, Init(R));
  HelpWin^.SetState(sfSelected, True);
  HelpWin^.SetState(sfFocused, True);
  HelpWin^.Show;
  repeat
    Y := 0;
    if ReadHelpEntry(HelpNum, L) = 0 then
    begin
      if HelpOK then
      begin
        HelpWin^.InitHelp(L);
        if O then
        begin
          Dispose(I1, Done);
          Dispose(I2, Done);
          if H <> 0 then
          begin
            Dispose(I3, Done);
            Dispose(I4, Done);
            I3 := nil;
            I4 := nil;
          end;
        end;
        if HelpNum = 0 then
        begin
          R.Assign(26, WinSize - 5, 8, 1);
          I1 := New(PButton, Init(R, '[ '+ColorChar+'H'+ColorChar+'elp ]', cmOK));
          HelpWin^.Insert(I1);
          R.Assign(37, WinSize - 5, 10, 1);
          I2 := New(PButton, Init(R, '[ '+ColorChar+'C'+ColorChar+'ancel ]', cmCancel));
          HelpWin^.Insert(I2);
          I1^.Select;
          if HelpCur > WinSize - 10 then Y := HelpCur - WinSize + 10;
        end
        else
        begin
          if O or B then
          begin
            R.Assign(12, WinSize - 5, 8, 1);
            I1 := New(PButton, Init(R, '[ '+ColorChar+'N'+ColorChar+'ext ]', cmYes));
            HelpWin^.Insert(I1);
            R.Assign(23, WinSize - 5, 12, 1);
            I2 := New(PButton, Init(R, '[ '+ColorChar+'P'+ColorChar+'revious ]', cmNo));
            HelpWin^.Insert(I2);
            R.Assign(38, WinSize - 5, 9, 1);
            I3 := New(PButton, Init(R, '[ '+ColorChar+'I'+ColorChar+'ndex ]', cmExtra));
            HelpWin^.Insert(I3);
            R.Assign(50, WinSize - 5, 10, 1);
            I4 := New(PButton, Init(R, '[ '+ColorChar+'C'+ColorChar+'ancel ]', cmCancel));
            HelpWin^.Insert(I4);
          end;
          if F then I1^.Select else I2^.Select;
        end;
        if X then
        begin
          C := 0;
          if S <> '' then C := SearchHelpStr(S, L);
          if C = 0 then
          begin
            U := V;
            repeat
              if (V^.ViewType = vtItemFrame) and (V^.Origin.X <= Q.X) and (V^.Origin.X + V^.Size.X >= Q.X)
                and (V^.Origin.Y <= Q.Y) and (V^.Origin.Y + V^.Size.Y >= Q.Y) then
              begin
                S := UpperCase(PItemFrame(V)^.Text^);
                C := SearchHelpStr(S, L);
              end;
              V := V^.Next;
            until (C <> 0) or (V = U);
          end;
          if C > 0 then Y := CountLines(C) - 1;
        end;
        if Y > HelpMax - WinSize + 9 then if HelpMax > WinSize - 10 then
          Y := HelpMax - WinSize + 9 else Y := 0;
        HelpWin^.Insert(HelpWin^.HiSeparator);
        HelpWin^.Insert(HelpWin^.LoSeparator);
        if B then
        begin
          HelpWin^.GetExtent(R);
          R.Grow(-4, -2);
          Dec(R.B.Y, 2);
          OnlineHelp := New(POnlineHelp, Init(R));
          OnlineHelp^.Options := 0;
        end;
        OnlineHelp^.Delta.Y := Y;
        if B then
        begin
          HelpWin^.Insert(OnlineHelp);
          HelpWin^.HiSeparator^.MakeFirst;
        end;
        HelpWin^.DrawView;
        H := HelpNum;
        B := False;
        C := Application^.ExecView(HelpWin, True, False);
        if HelpNum = 0 then
        begin
          if C = cmOK then HelpNum := HelpCur;
          F := True;
        end
        else
        begin
          case C of
            cmYes:
            begin
              Inc(HelpNum);
              if HelpNum > HelpEntryNum then HelpNum := 1;
              F := True;
            end;
            cmNo:
            begin
              Dec(HelpNum);
              if HelpNum = 0 then HelpNum := HelpEntryNum;
              F := False;
            end;
            cmExtra:
            begin
              HelpCur := HelpNum;
              HelpNum := 0;
            end;
          end;
        end;
        O := (((H = 0) and (HelpNum <> 0)) or ((H <> 0) and (HelpNum = 0)));
      end
      else
      begin
        HelpWin^.SetState(sfVisible, False);
        ErrorWin(stEmpty, 'The help file is corrupted.', stEmpty, hcOnlyQuit, sbNone);
        C := cmCancel;
      end;
    end
    else
    begin
      C := cmCancel;
    end;
    X := False;
  until C = cmCancel;
  if not B then
  begin
    Dispose(OnlineHelp, Done);
    Dispose(I1, Done);
    Dispose(I2, Done);
    if I3 <> nil then Dispose(I3, Done);
    if I4 <> nil then Dispose(I4, Done);
  end;
  Dispose(HelpWin^.HiSeparator, Done);
  Dispose(HelpWin^.LoSeparator, Done);
  Dispose(HelpWin, Done);
  BoxTitle := T;
  CurHelpCtx := W;
  AppHelpCtx := W;
  LastShiftState := MaxByte;
  LastHalfSec := 2;
  HelpInUse := False;
  PriorityMenu := P;
end;

end.
