
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                     INFO.PAS                    }
{                                                 }
{        The Star Commander File info unit        }
{*************************************************}

unit Info;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

const
  MaxGEOSDescLen= 50;

procedure FileInfo;

implementation

uses
  App, Dialogs, DOS, Drivers, Objects, Views,
  Base1, Base2, Constant, ExtFiles, LowLevel, Panel1, Panel2;

{'File info' in the 'Files' menu: get brief info about the file under the
  cursor bar}
procedure FileInfo;
var
  O,
  Q,
  X,
  Z             : Boolean;
  B,
  H,
  K,
  M             : Byte;
  L             : Char;
  C             : Word;
  S,
  Y,
  V,
  W             : Integer;
  G,
  J,
  Dummy         : Longint;
  D             : PDialog;
  A,
  A2,
  E,
  F,
  N,
  P,
  S1,
  S2,
  T,
  U             : string;
  G2            : Longlongint;
  R             : TRect;
  I1            : array [0..20] of string[24];
  I2            : array [0..2] of string[MaxGEOSDescLen];

{Compute the size of the current file}
procedure DiskFileSize;
begin
  S1 := SepStr(J);
  if (J = 0) or (J > Act^.CopyDiskSize) then S2 := '' else S2 := SepStr(J * 254 - 253) + ' - ' + SepStr(J * 254);
end;

{Determine if the buffer contains a valid GEOS info block
  Output: when True, the buffer contains a valid GEOS info block}
function GEOSInfoBlock: Boolean;
begin
  GEOSInfoBlock := ((DataBuffer[0] = $00) and (DataBuffer[1] = $FF)
    and (DataBuffer[2] = $03) and (DataBuffer[3] = $15));
end;

{Get a zero-terminated string from the GEOS info block
  Input : Offs: starting offset of the string
          MaxLen: maximum length of the string
  Output: the fetched string}
function GetInfoStr(Offs, MaxLen: Byte): string;
var
  B,
  C,
  D             : Byte;
  S             : string;
begin
  C := 0;
  D := DataBuffer[Offs];
  while (C < MaxLen) and (D in [$0D, $20..$7F]) do
  begin
    Inc(C);
    Inc(Offs);
    S[C] := Chr(D);
    D := DataBuffer[Offs];
  end;
  S[0] := Chr(C);
  GetInfoStr := S;
end;

{Get a number from the GEOS date stamp
  Input : Offs: the offset of the number in the directory entry
          Zeros: number of digits to fill up string to
  Output: resulting string}
function GetDateNum(Offs, Zeros: Byte): string;
begin
  GetDateNum := LeadingZero(Act^.DirBuffer[Act^.EntryPos + Offs], Zeros);
end;

begin
  ChangeHelpCtx(hcFileInfo);
  BoxTitle := 'File info';
  A := '';
  N := '';
  S1 := '';
  S2 := '';
  Q := True;
  O := False;
  Z := False;
  H := 0;
  ClockOff;
  if Act^.Mode = pmDOS then
  begin
    if (Act^.Max > 0) and (Act^.Dir[Act^.Cur].Attr and Directory = 0) then
    begin
      F := Act^.GetNamePtr(Act^.Cur)^;
      E := LowerCase(FileExt(F));
      J := LonglongintToLongint(Act^.Dir[Act^.Cur].Size);
      S1 := SepStr(ByteToBlock(J));
      S2 := SepStr(J);
      B := 0;
      while not O and (B < faTypeMask) do
      begin
        Inc(B);
        if (B in [faSequential, faUser]) and (E = ShortCBMExt[B]) then O := True;
      end;
      if not O then B := faProgram;
      T := LongCBMExt[B];
      if IsDiskExt(E) then
      begin
        T := 'Disk image';
        S1 := '';
        B := 8;
      end;
      if E = DOSExt[pmTape] then
      begin
        T := 'Tape image';
        S1 := '';
        B := 9;
      end;
      if (E[1] in ['p', 'r', 's', 'u']) and (E[2] in ['0'..'9']) and (E[3] in ['0'..'9']) then
      begin
        Z := True;
        T := 'PC64 file image';
        S1 := '';
        B := 10;
      end;
      O := True;
      if (B in [2, 8..10]) and (LongOpenFile(AddToPath(Act^.Path, F, chDirSep), ReadFile, fmReadOnly) = 0) then
      begin
        O := False;
        if IsDiskExt(E) then
        begin
          Act^.CopyDiskType := GetDiskType(ExtFileSize(ReadFile));
          if Act^.CopyDiskType <> dtInvalid then
          begin
            Act^.CheckDiskType;
            K := NameOffset(Act^.CopyDiskType, Act^.ExtBAMMode);
            case Act^.CopyDiskType and dtTypeMask of
              dt1541, dt1541Ext: S1 := '41';
              dt1571: S1 := '71';
              dt1581: S1 := '81';
            end;
            S1 := '15' + S1 + ' drive, ' + LeadingZero(Act^.CopyMaxTrack - 1, 2);
            T := T + ' (' + S1 + ' tracks';
            if Act^.CopyDiskType and dtErrorInfo > 0 then T := T + ', error info';
            Q := False;
            ExtSeek(ReadFile, Act^.DiskPos(Act^.MainDirTrack, 0) shl 8);
            ExtBlockRead(ReadFile, DataBuffer, 256);
            Act^.CheckGEOSFormat(@DataBuffer);
            if Act^.CopyGEOSFormat then T := T + ', GEOS format';
            T := T + ')';
            if IOResult = 0 then
            begin
              for S := 0 to CBMNameLen - 1 do N := N + Chr(DataBuffer[S + K]);
              N := N + ',';
              for S := 0 to CBMBAMIDLen - 1 do N := N + Chr(DataBuffer[S + K + DiskIDRelPos]);
              N := '"' + MakeCBMName(N, Act^.CopyGEOSFormat) + '"';
              O := True;
            end;
            S1 := '';
          end;
        end;
        if (E = DOSExt[pmTape]) and (ExtFileSize(ReadFile) > 95) then
        begin
          Q := False;
          ExtBlockRead(ReadFile, TempBuffer, 64);
          if IOResult = 0 then
          begin
            J := BytesToLongint(TempBuffer[34], TempBuffer[35], 0, 0);
            T := T + ' (' + LeadingSpace(J, 0) + ' entr';
            if J = 1 then T := T + 'y)' else T := T + 'ies)';
            for S := 1 to 24 do N := N + Chr(TempBuffer[S + 39]);
            N := '"' + MakeCBMName(CutChar(N, ' '), False) + '"';
            S1 := '';
            O := True;
          end;
        end;
        if Z and (ExtFileSize(ReadFile) > 26) then
        begin
          ExtBlockRead(ReadFile, TempBuffer, 28);
          for S := 1 to 4 do if E[1] = ShortCBMExt[S][1] then T := T + ' (' + LowerCase(LongCBMExt[S]) + ')';
          for S := 0 to 7 do N := N + Chr(TempBuffer[S]);
          if N = PC64Sign then
          begin
            Q := False;
            N := '';
            S1 := '';
            O := True;
          end;
        end;
        if not O then
        begin
          O := True;
          T := 'Program';
          ExtBlockRead(ReadFile, TempBuffer, 2);
          if IOResult = 0 then
          begin
            J := TempBuffer[1] shl 8 + TempBuffer[0];
            A := SepStr(J) + '; $' + HexaStr(J, 4);
          end;
        end;
        ExtClose(ReadFile);
      end;
    end;
  end
  else
  begin
    if Act^.Max > 0 then
    begin
      B := Act^.Dir[Act^.Cur].Attr and faTypeMask;
      H := Act^.Dir[Act^.Cur].ExtAttr and dtTypeMask;
      if GetPanelModeAttrib(Act^.Mode, paDirectories) then
      begin
        F := Act^.GetNamePtr(Act^.Cur)^;
        if B = faPartition then T := 'Directory' else T := LongCBMExt[B];
      end
      else
      begin
        F := MakeCBMName(Act^.GetNamePtr(Act^.Cur)^, Act^.CopyGEOSFormat);
        if (Act^.Mode = pmTape) and (B = faFrozen) then T := 'Frozen' else T := LongCBMExt[B];
      end;
      J := LonglongintToLongint(Act^.Dir[Act^.Cur].Size);
      if Act^.Mode = pmExt then
      begin
        O := True;
        DiskFileSize;
      end
      else
      begin
        if Act^.Cur > 0 then
        begin
          O := True;
          case Act^.Mode of
            pmDisk, pmFileZip: DiskFileSize;
            pmTape, pmFile, pmLynx..pmZIP:
            begin
              if not (GetPanelModeAttrib(Act^.Mode, paDirectories) and (B = faPartition)) then
              begin
                S1 := SepStr(ByteToBlock(J));
                S2 := SepStr(J);
              end;
            end;
          end;
          G2 := Act^.CopyFree;
          if not GetPanelModeAttrib(Act^.Mode, paCompressed) then
          begin
            Z := (Act^.Dir[Act^.Cur].Attr and (faTypeMask + faClosed) = (faProgram + faClosed));
            if (Z or (H > 0)) and (Act^.OpenImage(False, False, True, True, True) = 0) then
            begin
              X := False;
              Act^.GetFileData(Act^.Cur);
              X := Act^.SeekToNextFile(Dummy);
              if X then
              begin
                case Act^.Mode of
                  pmDisk:
                  begin
                    J := MaxWord;
                    if Z then
                    begin
                      Act^.ReadDiskBlock(Act^.Track, Act^.Sector, @DataBuffer, True);
                      J := BytesToLongint(DataBuffer[2], DataBuffer[3], 0, 0);
                    end;
                    if (InOutRes = 0) and (H > 0) then
                    begin
                      C := Act^.DirBuffer[Act^.EntryPos + 28];
                      MakeAMPM(C, E, True);
                      E := UpperCase(E) + 'M';
                      FillChar(U[1], 9, ' ');
                      U := GetDateNum(26, 0) + '/' + GetDateNum(27, 0) + '/' + GetDateNum(25, 2);
                      U[0] := #9;
                      E := U + LeadingSpace(C, 2) + ':' + GetDateNum(29, 2) + stSpace + E;
                      Act^.ReadDiskBlock(Act^.SideTrack, Act^.SideSector, @DataBuffer, True);
                      if (IOResult = 0) and GEOSInfoBlock then
                      begin
                        Z := (ScreenWidth > ScreenHeight shl 1);
                        M := 5;
                        X := True;
                        Y := -1;
                        while M < 68 do
                        begin
                          if X then
                          begin
                            Inc(Y);
                            FillChar(I1[Y][1], 24, ' ');
                            I1[Y][0] := #24;
                          end;
                          K := 1;
                          G := BytesToLongint(DataBuffer[M + 2], DataBuffer[M + 1], DataBuffer[M], 0);
                          for B := 0 to 23 do
                          begin
                            if G and $800000 > 0 then
                            begin
                              if Z then
                              begin
                                if X then L := VertBlockChars[1] else if I1[Y][K] = ' ' then L := VertBlockChars[2] else
                                  L := VertBlockChars[3];
                              end
                              else
                              begin
                                L := VertBlockChars[3];
                              end;
                              I1[Y][K] := L;
                            end;
                            G := G shl 1;
                            Inc(K);
                          end;
                          X := X xor Z;
                          Inc(M, 3);
                        end;
                        for V := 0 to 2 do I2[V] := '';
                        A := GetInfoStr(160, 96);
                        if A <> '' then
                        begin
                          K := 0;
                          V := -1;
                          X := True;
                          while (V < 3) and (A <> '') do
                          begin
                            if X then
                            begin
                              X := False;
                              Inc(V);
                              if V = 0 then Inc(Y);
                            end;
                            M := LeftPos(' ', A);
                            K := LeftPos(chCR, A);
                            if (M = 0) or ((K > 0) and (M > K)) then M := K;
                            if M = 0 then M := Length(A) + 1;
                            K := M - 1;
                            if K > MaxGEOSDescLen then K := MaxGEOSDescLen;
                            if Length(I2[V]) + K + Byte(I2[V] <> '') <= MaxGEOSDescLen then
                            begin
                              if I2[V] <> '' then I2[V] := I2[V] + ' ';
                              I2[V] := I2[V] + Copy(A, 1, K);
                              while (M <= Length(A)) and (A[M] in [' ', chCR]) do Inc(M);
                              A := Copy(A, M, MaxStrLen);
                            end
                            else
                            begin
                              X := True;
                            end;
                          end;
                          A := '';
                        end;
                      end
                      else
                      begin
                        H := 0;
                        E := '';
                      end;
                    end;
                  end;
                  pmTape: J := BytesToLongint(Act^.DirBuffer[2], Act^.DirBuffer[3], 0, 0);
                  pmFile: J := BytesToLongint(Act^.DirBuffer[26], Act^.DirBuffer[27], 0, 0);
                  pmLynx, pmArkive, pmTAR:
                  begin
                    ExtSeek(Act^.Image, Act^.ImagePos);
                    ExtBlockRead(Act^.Image, J, 2);
                  end;
                end;
                if (IOResult = 0) and (J <> MaxWord) then A := SepStr(J) + '; $' + HexaStr(J, 4);
              end;
              Act^.CloseImage(False);
            end;
          end;
          Act^.CopyFree := G2;
        end;
      end;
    end;
  end;
  ClockOn;
  if O then
  begin
    Y := 4;
    F := 'File    "' + LimitNameLen(F, (MaxNameLen - 12)) + '"';
    T := 'Type    ' + T;
    if Q then T := T + ' file';
    if N <> '' then
    begin
      N := 'Label   ' + N;
      Inc(Y);
    end;
    if N <> '' then Y := 5;
    if S1 <> '' then
    begin
      P := 'Size    ' + S1 + ' block';
      if S1 <> '1' then P := P + 's';
      if S2 <> '' then P := P + ';';
      S1 := P;
      Inc(Y);
      if S2 <> '' then
      begin
        P := S2 + ' byte';
        if S2 <> '1' then P := P + 's';
        S2 := P;
        Inc(Y);
      end;
    end;
    if A <> '' then
    begin
      A := 'Start   ' + A;
      Inc(Y);
      O := (Lo(J) = 1);
      if O then
      begin
        case Hi(J) of
          $04: A2 := 'PET/CBM/VIC20';
          $08: A2 := 'C64';
          $10: A2 := 'VIC20/Plus4/C16';
          $12: A2 := 'VIC20';
          $1C, $40: A2 := 'C128';
          $20: A2 := 'Plus4/C16';
        else
          O := False;
        end;
      end;
      if O then A2 := A2 + ' BASIC' else A2 := 'assembly';
      T := T + ' (' + A2 + ')';
    end;
    W := 13;
    if W < CBMStrLen(F) then W := CBMStrLen(F);
    if W < Length(T) then W := Length(T);
    if W < CBMStrLen(N) then W := CBMStrLen(N);
    if W < Length(S1) then W := Length(S1);
    if W < Length(S2) + 8 then W := Length(S2) + 8;
    if W < Length(A) then W := Length(A);
    V := 5;
    if H > 0 then
    begin
      if W < 26 then W := 26;
      Inc(W, 26);
      Inc(V, 26);
      if Z then Y := 14 else Y := 24;
      B := Y;
      M := 0;
      while (M < 3) and (I2[M] <> '') do
      begin
        if W < Length(I2[M]) then W := Length(I2[M]);
        if M = 0 then Inc(Y);
        Inc(M);
        Inc(Y);
      end;
    end;
    MakeWinBounds(R, W + 2, Y);
    D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, False));
    S := 2;
    if H > 0 then
    begin
      if Z then M := 11 else M := 21;
      for K := 0 to M - 1 do
      begin
        R.Assign(5, K + 3, 24, 1);
        D^.Insert(New(PStaticText, Init(R, I1[K])));
      end;
      Inc(S);
    end;
    R.Assign(V, S, CBMStrLen(F), 1);
    D^.Insert(New(PCBMText, Init(R, F)));
    Inc(S);
    R.Assign(V, S, Length(T), 1);
    D^.Insert(New(PStaticText, Init(R, T)));
    Inc(S);
    if N <> '' then
    begin
      R.Assign(V, S, CBMStrLen(N), 1);
      D^.Insert(New(PCBMText, Init(R, N)));
      Inc(S);
    end;
    if S1 <> '' then
    begin
      R.Assign(V, S, Length(S1), 1);
      D^.Insert(New(PStaticText, Init(R, S1)));
      Inc(S);
      if S2 <> '' then
      begin
        R.Assign(V + 8, S, Length(S2), 1);
        D^.Insert(New(PStaticText, Init(R, S2)));
        Inc(S);
      end;
    end;
    if A <> '' then
    begin
      R.Assign(V, S, Length(A), 1);
      D^.Insert(New(PStaticText, Init(R, A)));
      Inc(S);
    end;
    if H > 0 then
    begin
      Inc(S);
      N := 'Type    ' + LongGEOSExt[H];
      R.Assign(V, S, Length(N), 1);
      D^.Insert(New(PStaticText, Init(R, N)));
      Inc(S);
      N := GetInfoStr(77, 20);
      if N <> '' then
      begin
        N := 'Class   ' + N;
        R.Assign(V, S, Length(N), 1);
        D^.Insert(New(PStaticText, Init(R, N)));
        Inc(S);
      end;
      N := '';
      case DataBuffer[70] of
        0: N := 'Sequential';
        1: N := 'VLIR';
      end;
      if N <> '' then
      begin
        N := 'Struct  ' + N;
        R.Assign(V, S, Length(N), 1);
        D^.Insert(New(PStaticText, Init(R, N)));
        Inc(S);
      end;
      N := 'Date    ' + E;
      R.Assign(V, S, Length(N), 1);
      D^.Insert(New(PStaticText, Init(R, N)));
      Inc(S);
      N := GetInfoStr(97, 20);
      if N <> '' then
      begin
        N := 'Author  ' + N;
        R.Assign(V, S, Length(N), 1);
        D^.Insert(New(PStaticText, Init(R, N)));
        Inc(S);
      end;
      if I2[0] <> '' then
      begin
        Inc(B);
        M := 0;
        while (M < 3) and (I2[M] <> '') do
        begin
          R.Assign(5, B, D^.Size.X - 10, 1);
          D^.Insert(New(PStaticText, Init(R, I2[M])));
          Inc(M);
          Inc(S);
          Inc(B);
        end;
      end;
    end;
    R.Assign((W + 7) shr 1, Y + 1, 4, 1);
    D^.Insert(New(PButton, Init(R, stOK, cmOK)));
    C := Application^.ExecView(D, True, True);
    Dispose(D, Done);
  end;
  RestoreHelpCtx;
end;

end.
