
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   LOWLEVEL.PAS                  }
{                                                 }
{        The Star Commander low level unit        }
{*************************************************}

unit LowLevel;

{$A+,B-,D+,E-,F+,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

(* !!! DO NOT CHANGE THE CONSTANTS BELOW !!!
   They have been duplicated from the (modified) Turbo Vision units
   and are for your information only! *)
(* APP.PAS *)
const
{Application palettes}
  apBlackWhite  = 0;
  apColor       = 1;
  apLaptop      = 2;
  apMonochrome  = 3;
  apAuto        = 255;
(* DIALOGS.PAS *)
const
{Maximum length of strings}
  MaxStrLen     = 254;
(* DRIVERS.PAS *)
const
{Maximum value for a word}
  MaxWord       = $FFFF;
{Maximum value for a byte}
  MaxByte       = $FF;
{Maximum size of the screen}
  MaxScrWidth   = 132;
  MaxScrHeight  = 60;
{System error automatic failures}
  fsNone        = 0;
  fsAll         = 1;
  fsDiskChange  = 2;
{Command output modes}
  coNormal      = 0;
  coSilent      = 1;
  coStandardCmd = 2;
{Screen modes}
  smBW40        = $0000;
  smCO40        = $0001;
  smBW80        = $0002;
  smCO80        = $0003;
  smMono        = $0007;
  smLastNonVESA = $0013;
  smModeMask    = $01FF;
  smEGALines    = $8000;
{PC character constants}
  chBackspace   = #$08;
  chTab         = #$09;
  chLF          = #$0A;
  chPageFeed    = #$0C;
  chCR          = #$0D;
  chEOF         = #$1A;
  chEsc         = #$1B;
{Character to switch between colors in double-colored strings}
  ColorChar     = #2;
type
{Screen buffer}
  TScreenBuffer = array [0..(MaxScrWidth * MaxScrHeight * 2) - 1] of Byte;
  PScreenBuffer = ^TScreenBuffer;
{VESA information buffer}
  TVESAInfo     = array [$0000..$01FF] of Byte;
  PVESAInfo     = ^TVESAInfo;
(* VIEWS.PAS *)
const
{Length of palette}
  PaletteLen    = 40;
{Undefined attribute}
  ErrorAttr     = $07;
(* !!! DO NOT CHANGE THE CONSTANTS ABOVE !!! *)

const
{Version number}
  VersionNum    = $0053;
{Program title string}
  TitleStr      = 'The Star Commander';
{Version string}
  VersionStr    = ', Version 0.83 (2010-01-11)';
{Copyright string}
  CopyrightStr  = 'Copyright (C) 1994-2010 by Joe Forster/STA';
{File name of main program}
  MainPrgFileName= 'scmain.exe';
{Maximum number of parallel ports}
  MaxLPTPorts   = 5;
{Maximum number of entries in the history}
  HistoryMax    = 16;
{Maximum length of the command line}
  CmdLineLen    = 120;
{Length of setup data}
  SetupLen      = 1500;
{Maximum coordinates in the Commander sample screen window}
  SampleScreenMaxX= 57;
  SampleScreenMaxY= 25;
{DOS error codes}
  deOK          = 0;
  deFileNotFound= 2;
  dePathNotFound= 3;
  deAccessDenied= 5;
  deOutOfMemory = 8;
  deInvalidMBA  = 9;
  deInvalidEnv  = 10;
  deInvalidFormat= 11;
  deNoLongNames = $7100;
{Help file commands}
  hfEOL         = 0;
  hfNormal      = 1;
  hfBright      = 2;
  hfReverse     = 3;
  hfUnderline   = 4;
  hfMultiply    = 5;
  hfSpaces      = 6;
  hfAnchor      = 8;
{PETSCII character constants}
  chReturn      = #$0D;
  chLocaseUpcase= #$0E;
  chReverseOn   = #$12;
  chShiftReturn = #$8D;
  chUpcaseGraphics= #$8E;
  chReverseOff  = #$92;
  chShiftSpace  = #$A0;
{Maximum length of Commodore file names and disk names}
  CBMNameLen    = 16;
{Offset the online help entry offset table}
  HelpTableStart= 36;
{Length of online help file header}
  HelpHeaderLen = 320;
{Size of the command buffer for a DOS shell}
  CmdBufferLen  = 2048;
{Size of the list buffer to collect the name of selected files into}
  ListBufferLen = 256 * (CBMNameLen + 1);
{Prefix for suppressing output in DOS commands}
  SuppressOutputPrefix= '@';
{White space characters}
  WhiteSpace    = [' ', #9];
{OpenCBM handles}
  ohInvalid     = -1;

type
{Procedure without parameters}
  TProc         = procedure;
{Record for a selected file}
  TSelFile      = record
    Status      : Byte;
    Name        : Word;
  end;
{Command buffer for a DOS shell}
  TCmdBuffer    = array [0..CmdBufferLen - 1] of Char;
  PCmdBuffer    = ^TCmdBuffer;
{Buffer for selected file names}
  TListBuffer   = array [0..ListBufferLen - 1] of Byte;
  PListBuffer   = ^TListBuffer;
{Parallel port addresses}
  TLPTAddresses = array [0..MaxLPTPorts - 1] of Word;
{Shell buffer for a DOS shell}
  TShellBuffer  = object
    Version     : Byte;
    First,
    ConfigOK,
    QuitProgram,
    Single,
    TitlePrinted,
    VESASupport,
    DisableLPTPorts,
    DisableXMSUsage,
    DisableEMSUsage,
    DisableWinClipboard,
    PathPrompt,
    PopupMenu,
    Archiving,
    Compressing,
    FirstFile,
    OrigFirstFile,
    WrapMode,
    HexaMode,
    ShowLoadAddr,
    ShowSymbols,
    BackupFiles,
    ReplaceMode,
    SearchInHex,
    MoveFiles,
    EditSpecFile,
    EditNewFile,
    TempUncompOpen,
    TempInputOpen,
    TempOutputOpen,
    TempFileOpen,
    TransferInited,
    SourceOK,
    AllConvert  : Boolean;
    CommandOutput,
    DefScreenCol,
    BatchMode,
    OrigBackCursorY,
    BackCursorY,
    BackAttr,
    WarningStatus,
    EditStatus,
    CopyFileMode,
    ViewPanelMode,
    DestArchType,
    CopyAttr,
    CopyRecordLen,
    DiskDirSize,
    UserLineFeed,
    LeftListNum,
    RightListNum,
    LeftSelNum,
    RightSelNum,
    LeftCBMDev,
    RightCBMDev,
    CmdPos,
    CmdFirstPos,
    HistoryNum,
    ExecMode,
    DiskCopySettings,
    AllDelete,
    AllDeleteReadonly,
    AllDeleteDir,
    AllOverwrite,
    AllOverwriteReadonly,
    CharSetMode : Byte;
    ViewDirPos,
    CopyDirPos,
    OrigCopyDirPos,
    CopyFileNum,
    FixLineLen,
    LeftListEnd,
    RightListEnd,
    TapeDirSize,
    CmdLen      : Word;
    LeftNewCur,
    RightNewCur,
    ExecError,
    MouseX,
    MouseY,
    MouseMaxX,
    MouseMaxY   : Integer;
    BatchOffset,
    MemFree     : Longint;
    CmdBuffer   : PCmdBuffer;
    ScreenBuffer: PScreenBuffer;
    DiskTitle   : string[22];
    TapeTitle   : string[24];
    DOSPattern,
    CBMPattern,
    SearchText,
    SearchHex,
    ReplaceText,
    ReplaceHex  : string[64];
    BatchName,
    BatchCommand,
    LeftImageName,
    RightImageName,
    LeftOrigImage,
    RightOrigImage,
    LeftTop,
    RightTop,
    LeftUnder,
    RightUnder,
    ViewFileName,
    LeftOrigPath,
    RightOrigPath,
    LeftImagePath,
    RightImagePath,
    LeftOrigImagePath,
    RightOrigImagePath,
    ViewImagePath,
    CurPath,
    DefPath,
    ComPath,
    LastName,
    DestName    : string;
    CmdLineText : string[CmdLineLen];
    Config      : array [0..SetupLen - 1] of Byte;
    LPTAddresses: TLPTAddresses;
    LPTModes    : array [0..MaxLPTPorts - 1] of Byte;
    History     : array [0..HistoryMax - 1] of string[CmdLineLen];
    LeftList,
    RightList   : array [0..254] of TSelFile;
    LeftListNames,
    RightListNames: TListBuffer;
  end;
  PShellBuffer  = ^TShellBuffer;

implementation

end.
