
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   MAINFN1.PAS                   }
{                                                 }
{       The Star Commander functions unit #1      }
{*************************************************}

unit MainFn1;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

procedure ViewFile(Z: Byte);
procedure EditFile(Z: Byte);
procedure MakeDir(Z: Byte);
procedure QuitProgram;
procedure MakeImage(Z: Byte; Disk: Boolean);

implementation

uses
  App, Dialogs, DOS, Drivers, Objects, Views,
  Base1, Base2, Constant, DOSShell, ExtFiles, FWOpen, FWClose, FWPrep, LowLevel, MiscFunc, Panel1, Panel2, Reinit, Script;

{Replace the prefix of hexadecimal codes in a string
  Input : Str: the string to replace prefixes in
          Src: source prefix
          Dest: destination prefix}
procedure ReplaceHexaCode(var Str: string; Src, Dest: Char);
var
  B             : Byte;
  I             : Integer;
begin
  if Length(Str) >= 3 then
  begin
    B := 1;
    while B <= Length(Str) - 2 do
    begin
      if Str[B] = Src then
      begin
        HexaEval(Copy(Str, B + 1, 2), I);
        if I = 0 then Str[B] := Dest;
      end;
      Inc(B);
    end;
  end;
end;

{View or edit the specified file using the internal viewer/editor or an
  external one
  Input : Edit: when True, the file is to be edited, otherwise viewed
          S: the type of program to be executed (viewer or editor)}
procedure ViewEdit(Edit: Boolean; const S: string);
var
  B,
  F,
  O             : Boolean;
  A             : Byte;
  C             : Word;
  I             : Integer;
  Z             : PHistoryItem;
  P             : PPanel;
  L             : string;
begin
  if ShellBuffer^.ViewFileName = '' then
  begin
    Internal := True;
    SysErrorOccurred := False;
    if Edit then ExtFileName := EditorExtFileName else ExtFileName := ViewerExtFileName;
    DestArchType := pmDOS;
    Act^.CopyMode := Act^.Mode;
    Act^.MakeListFile := False;
    Inact^.MakeListFile := False;
    ShellBuffer^.EditNewFile := False;
    ShellBuffer^.ViewDirPos := 0;
    O := True;
    B := (CopyFileMode and cfRetryView > 0);
    if B then
    begin
      SourceName := LastName;
      CopyFileMode := CopyFileMode and not cfRetryView;
    end;
    if CopyFileMode = cfReadKey then CopyFileMode := ShiftCode;
    if (not Act^.Vis or (Act^.Mode = pmInfo) or ((Act^.QuickView <> qvNone) and Act^.Changing)) and
      (CopyFileMode in [cfSelected, cfSingle]) then Inc(CopyFileMode);
    case CopyFileMode of
      cfSelected, cfSingle:
      begin
        if Act^.Mode = pmDOS then
        begin
          if (Act^.Max > 0) and (Act^.Dir[Act^.Cur].Attr and Directory = 0) then
          begin
            SourceName := Act^.GetNamePtr(Act^.Cur)^;
            LastName := SourceName;
          end
          else
          begin
            O := False;
          end;
        end
        else
        begin
          A := Act^.Dir[Act^.Cur].Attr and faTypeMask;
          if ((Act^.Mode = pmExt) or (Act^.Cur > 0)) and ((A in [faDeleted..faRelative]) or
            ((A = faFrozen) and (Act^.Mode = pmTape))) then
          begin
            LastName := ConvertCBMName(Act^.GetNamePtr(Act^.Cur)^, Act^.GEOSFormat, False, hxPercent);
            SourceName := Act^.ImageName;
          end
          else
          begin
            O := False;
          end;
        end;
        if O then
        begin
          ShellBuffer^.ViewPanelMode := Act^.Mode;
          ShellBuffer^.ViewImagePath := Act^.RealImagePath;
          ShellBuffer^.ViewFileName := Act^.Under;
          ShellBuffer^.ViewDirPos := Act^.Dir[Act^.Cur].DirPos;
        end;
      end;
      cfWildcard, cfSingleWild:
      begin
        SourceName := LastName;
        P := Inact;
        Inact := Act;
        if B then Inact^.Prepare(SourceName, True, False, False) else O := Act^.GetFileName(stEmpty, BoxTitle + ' the file',
          stEmpty, nil, nil, False, True, False, True, False, False, eeNone, aaNone);
        Inact := P;
        if O then
        begin
          ShellBuffer^.ViewPanelMode := Act^.CopyMode;
          LastName := SourceName;
          if Act^.CopyMode = pmDOS then
          begin
            ShellBuffer^.EditNewFile := ((CurHelpCtx = hcEditFile) and ((GetPath(LastName, chDirSep) = '')) and
              not FileExists(LastName, False));
          end
          else
          begin
            ShellBuffer^.ViewImagePath := Act^.RealImagePath;
            ShellBuffer^.ViewFileName := Act^.CopyName;
            SourceName := AddToPath(Act^.CopyPath, Act^.CopyImageName, chDirSep);
          end;
        end;
      end;
      cfAutomatic:
      begin
        Act^.Prepare(SourceName, True, False, False);
        if Act^.CopyMode = pmDOS then
        begin
          SourceName := AddToPath(Act^.CopyPath, Act^.CopyName, chDirSep);
        end
        else
        begin
          Act^.CopyName := CloneName(Act^.CopyName, stAllFilesUnix, True, False);
          SourceName := ConvertCBMName(Act^.CopyImagePath, Act^.CopyGEOSFormat, False, hxDollar);
          if SourceName <> '' then SourceName := SourceName + chDirSep;
          SourceName := MakeTypeStr(Act^.CopyMode) + ':' + AddToPath(Act^.CopyPath, Act^.CopyImageName, chDirSep) +
            chDirSep + SourceName + ConvertCBMName(Act^.CopyName, Act^.CopyGEOSFormat, False, hxDollar);
        end;
        ShellBuffer^.ViewPanelMode := pmDOS;
        ShellBuffer^.ViewImagePath := '';
        ShellBuffer^.ViewFileName := SourceName;
      end;
    end;
    if O then
    begin
      if CopyFileMode = cfSingleWild then CopyFileMode := cfSingle;
      if ((Act^.CopyMode = pmExt) or GetPanelModeAttrib(Act^.CopyMode, paCompressed)) and (CopyFileMode <> cfAutomatic) then
      begin
        O := False;
        GoSound := True;
      end
      else
      begin
        O := False;
        Act^.Prepare(SourceName, True, False, False);
        if IOResult = 0 then
        begin
          if Act^.Mode = pmDOS then
          begin
            if CopyFileMode <> cfSingle then
            begin
              I := ReadUserFile(ExtFileName, False, False, CurHelpCtx);
              if I = 0 then
              begin
                ClockOn;
                if ConstructMenu(I, Z, False, False) then
                begin
                  L := S + 's';
                  L[1] := UpCase(L[1]);
                  ForceUserTitle(L);
                  DisplayUserMenu(L, I, 20, 0, mtExtension, Z, nil, False, False);
                  Internal := False;
                  if HistoryItem >= 0 then
                  begin
                    C := CopiedSize;
                    if not ParseExt(L, False) then
                    begin
                      CopiedSize := C;
                      PutCommands(False, True, False, False, True);
                      O := True;
                      if (CommandOutput <> coNormal) then
                      begin
                        if (LeftPos(':', DestName) = 0) and (LeftPos(chDirSep, DestName) = 0) then
                          DestName := AddToPath(HomePath, DestName, chDirSep);
                        DestName := LongName(DestName, True);
                        O := FileExists(DestName, False);
                        Internal := not O;
                      end;
                    end;
                  end;
                end;
              end;
            end;
          end;
          if Internal then
          begin
            if Edit then DestName := EditorPrgFileName else DestName := ViewerPrgFileName;
            DestName := AddToPath(HomePath, DestName, chDirSep);
            CommandOutput := coStandardCmd;
            AttachInfo := True;
            O := FileExists(DestName, False);
            if O then PutCommand(DestName + stSpace + SourceName + chCR + chLF, False);
          end;
        end
        else
        begin
          O := False;
        end;
        if O then
        begin
          SingleCommand := False;
          ClearCommand := False;
          PopupMenu := False;
          if (CommandOutput = coStandardCmd) and not Internal then
            TempDialog := InfoWin(stEmpty, 'Loading the ' + S, DestName, stEmpty, 2);
          RunningShell := True;
          EnterDOSShell;
        end
        else
        begin
          if Internal and not SysErrorOccurred then ErrorWin(stEmpty, 'Can''t ' + Copy(S, 1, 4) + ' the file',
            Act^.CopyName, CurHelpCtx, sbNone);
          CommandOutput := coNormal;
        end;
      end;
    end;
    ClockOn;
  end
  else
  begin
    RunningShell := False;
  end;
  if not O then ShellBuffer^.ViewFileName := '';
  RestoreHelpCtx;
  NextBatchCommand;
end;

{'View' item in the 'Files' menu: view the specified file using the internal
  viewer or an external one
  Input : Z: file selection mode (file under the cursor bar, enter file name
             into dialog box, file name already given)}
procedure ViewFile(Z: Byte);
begin
  ChangeHelpCtx(hcViewFile);
  BoxTitle := 'View';
  CopyFileMode := Z;
  ShellBuffer^.EditStatus := Z;
  ViewEdit(False, 'viewer');
end;

{'Edit' item in the 'Files' menu: edit the specified file using an external
  editor
  Input : Z: file selection mode (file under the cursor bar, enter file name
             into dialog box, file name already given)}
procedure EditFile(Z: Byte);
begin
  ChangeHelpCtx(hcEditFile);
  BoxTitle := 'Edit';
  CopyFileMode := Z;
  ShellBuffer^.EditStatus := Z;
  ViewEdit(True, 'editor');
end;

{'Make directory' item in the 'Files' menu: create a directory
  Input : Z: file selection mode (enter file name into dialog box, file name
             already given)}
procedure MakeDir(Z: Byte);
var
  O             : Boolean;
  F,
  L,
  S,
  T             : Byte;
  I             : Integer;
  D             : PDialog;
  P             : string;

{Convert all full lowercase components of a path name to full uppercase so
  that as few LFN entries are created as possible
  Input : DirName: the path name to convert}
procedure DropLongDirName(var DirName: string);
var
  S             : string;
begin
  S := GetPath(DirName, chDirSep);
  DirName := CutPath(DirName, chDirSep);
  DropLongName(DirName);
  if DirName = '' then
  begin
    if (Length(S) >= 2) and (S[1] in ['a'..'z']) and (S[2] = ':') then S[1] := UpCase(S[1]);
    DirName := S;
  end
  else
  begin
    DropLongDirName(S);
    DirName := AddToPath(S, DirName, chDirSep);
  end;
end;

{Create a DOS directory structure, traversing back in components if path not
  found
  Input : DirName: the directory to create
  Output: error code}
function MakeDOSDirStruct(DirName: string): Integer;
var
  Q             : Byte;
  I,
  J             : Integer;
begin
  I := 0;
  if DirName <> '' then
  begin
    Q := 0;
    repeat
      LongMkDir(DirName);
      I := IOResult;
      if I = dePathNotFound then J := MakeDOSDirStruct(GetPath(DirName, chDirSep));
      Inc(Q);
    until (I = 0) or (Q > 1);
  end;
  MakeDOSDirStruct := I;
end;

begin
  ChangeHelpCtx(hcMakeDir);
  BoxTitle := 'Make directory';
  CopyFileMode := Z;
  if CopyFileMode = cfAutomatic then Act^.Prepare(SourceName, False, True, False);
  case Act^.CopyMode of
    pmDOS, pmInfo:
    begin
      case CopyFileMode of
        cfWildcard:
        begin
          SourceName := '';
          O := Act^.GetFileName(stEmpty, 'Create the directory', stEmpty, nil, nil, False,
            True, False, True, False, False, eeNone, aaNone);
          SourceName := RemoveQuotes(SourceName);
        end;
        cfAutomatic: O := True;
      end;
      if O and (SourceName <> '') then
      begin
        ClockOff;
        DropLongDirName(SourceName);
        D := InfoWin(stEmpty, 'Creating the directory', SourceName, stEmpty, 2);
        SysErrorOccurred := False;
        I := MakeDOSDirStruct(SourceName);
        if I = 0 then
        begin
          Act^.Working := True;
          if Inact^.Mode = pmInfo then Inact^.DrawPanel;
          if (CopyFileMode = cfWildcard) and (Act^.Mode <> pmInfo) and not ((Act^.QuickView <> qvNone) and Act^.Changing) and
            CursorFollowsFilename then
          begin
            SourceName := LongFExpand(SourceName);
            S := Length(Act^.Path);
            if Act^.Path = Copy(SourceName, 1, S) then
            begin
              if S = 3 then Dec(S);
              P := Copy(SourceName, S + 2, MaxStrLen);
              while GetPath(P, chDirSep) <> '' do P := GetPath(P, chDirSep);
              Act^.Under := P;
            end;
          end;
        end
        else
        begin
          if not SysErrorOccurred then ErrorWin(stEmpty, 'Can''t create the directory', SourceName, hcMakeDir, sbNone);
          ClockOn;
        end;
        Dispose(D, Done);
        RereadPanels;
      end;
    end;
    pmDisk:
    begin
      if CopyFileMode = cfAutomatic then
      begin
        Act^.CopyName := Act^.NamePattern;
        Act^.MakeFullName;
        P := BatchParamStr(3, True);
        DiskDirSize := EvalAny(P, I);
      end;
      if DiskDirSize < MinDiskDirSize then DiskDirSize := MinDiskDirSize;
      if (Act^.CopyDiskType and dtTypeMask = dt1581) and (Act^.LastTrack - Act^.FirstTrack > 3) then
      begin
        case CopyFileMode of
          cfWildcard:
          begin
            SourceName := '';
            DestName := '';
            O := Act^.GetFileName(stEmpty, 'Create the directory', '[ '+ColorChar+'M'+ColorChar+'ake ]', nil, nil,
              True, True, True, True, False, False, eeDiskImageDir, aaNone);
            P := ReconvertCBMName(SourceName, False, True, hxPercent);
            Act^.CopyName := P;
          end;
          cfAutomatic: O := True;
        end;
        if O then
        begin
          D := InfoWin(stEmpty, 'Creating the directory', SourceName, stEmpty, 2);
          if Act^.IsBAMValid then
          begin
            Act^.Working := True;
            L := 0;
            T := Act^.FirstTrack;
            while (T < Act^.LastTrack) and (L < DiskDirSize) do
            begin
              if Act^.IsTrackEmpty(T) and (T <> Act^.DirTrack) then
              begin
                if L = 0 then F := T;
                Inc(L);
              end
              else
              begin
                L := 0;
              end;
              Inc(T);
            end;
            if L < DiskDirSize then
            begin
              ErrorWin(stEmpty, 'Not enough contiguous free space in', Act^.CopyImageName, CurHelpCtx, sbNone);
            end
            else
            begin
              Act^.MakeFullName;
              I := OpenWrite(Act, nil, False, False, True, F);
              if I = 254 then ErrorWin(stEmpty, 'The following file already exists.', Act^.CopyFullName, CurHelpCtx, sbNone);
              if I = 0 then
              begin
                if CursorFollowsFilename then Act^.Under := P;
                for T := F to F + L - 1 do
                begin
                  for S := 0 to Act^.SectorNum(T) - 1 do
                  begin
                    Act^.AllocBlock(T, S, True);
                    Inc(Act^.Block);
                  end;
                end;
                Act^.CopyAttr := (faPartition + faClosed);
                CloseWrite(Act, False);
                Act^.FirstTrack := F;
                Act^.DirTrack := F;
                Act^.LastTrack := F + L;
                Act^.MakeBAM;
                InitBAM(Act, False, True, T, S, F);
                Act^.SetBAMLabel(ReconvertCBMName(DestName, False, True, hxPercent));
                Act^.WriteBAM;
                FillChar(DataBuffer, 256, 0);
                DataBuffer[1] := MaxByte;
                Act^.WriteDiskBlock(Act^.DirTrack, F, @DataBuffer);
                Act^.CloseImage(True);
              end;
            end;
          end
          else
          begin
            ErrorWin(stEmpty, 'The following image file has an invalid BAM', Act^.CopyImageName, CurHelpCtx, sbNone);
          end;
          Dispose(D, Done);
          RereadPanels;
        end;
      end;
    end;
  end;
  RestoreHelpCtx;
  NextBatchCommand;
end;

{'Quit' item in the 'Files' menu: quit the main program}
procedure QuitProgram;
var
  O             : Boolean;
  C             : Word;
  D             : PDialog;
  R             : TRect;
  E             : TEvent;
begin
  ChangeHelpCtx(hcQuitProgram);
  if QuitConfirm then
  begin
    MakeWinBounds(R, 41, 2);
    D := New(PDialog, Init(R, TitleStr, fxNormal, fyNormal, False));
    R.Assign(5, 2, 40, 1);
    D^.Insert(New(PStaticText, Init(R, 'Do you want to quit ' + TitleStr + '?')));
    R.Assign(26, 3, 4, 1);
    D^.Insert(New(PButton, Init(R, stNo, cmNo)));
    R.Assign(20, 3, 5, 1);
    D^.Insert(New(PButton, Init(R, stYes, cmYes)));
    C := Application^.ExecView(D, True, True);
    Dispose(D, Done);
    O := (C = cmYes);
  end
  else
  begin
    O := True;
  end;
  if O then
  begin
    AutomaticSaveSetup;
    CommandOutput := coNormal;
    ShellBuffer^.QuitProgram := True;
    E.What := evCommand;
    E.Command := cmQuit;
    Application^.PutEvent(E);
  end;
  RestoreHelpCtx;
end;

{'Make disk image' and 'Make tape image' items in the 'Commands' menu:
  create image files
  Input : Z: file selection mode (enter file name into dialog box, file name
             already given)
          Disk: when True, a disk image is to be created, otherwise a tape
                image}
procedure MakeImage(Z: Byte; Disk: Boolean);
var
  G,
  O             : Boolean;
  B,
  C,
  M             : Byte;
  W             : Word;
  I             : Integer;
  D             : PDialog;
  A             : PSItem;
  S,
  T,
  X             : string;
begin
  W := hcMakeImage;
  if Disk then W := hcMakeImage2;
  ChangeHelpCtx(W);
  CopyFileMode := Z;
  if (CopyFileMode = cfAutomatic) or (Act^.OK and (Act^.Mode in [pmDOS, pmInfo])) then
  begin
    M := Act^.Mode;
    if Disk then T := 'disk' else T := 'tape';
    BoxTitle := 'Make ' + T + ' image';
    case CopyFileMode of
      cfSelected:
      begin
        SourceName := '';
        if Disk then DestName := DiskTitle else DestName := TapeTitle;
        A := nil;
        if Disk then
        begin
          A := NewSItem('Attach error info block',
            NewSItem('Create GEOS disk', nil));
        end;
        CopyFileMode := cfWildcard;
        B := eeNone;
        C := aaNone;
        if Disk then C := aaDiskImage else B := eeMakeTape;
        GetCheckData := 0;
        O := Act^.GetFileName(stEmpty, 'Make the file', '[ '+ColorChar+'M'+ColorChar+'ake ]',
          A, nil, True, True, True, True, False, False, B, C);
        if Disk then
        begin
          if GetCheckData and 1 > 0 then Act^.CopyDiskType := Act^.CopyDiskType or dtErrorInfo;
          G := (GetCheckData and 2 > 0);
        end;
        if Act^.Mode = pmInfo then Act^.CopyPath := CurPath;
      end;
      cfAutomatic:
      begin
        Act^.Prepare(SourceName, True, False, False);
        if Disk then
        begin
          C := GetEnumValue(BatchParamStr(3, True), bvDiskTypeValues, I);
          if I <> 0 then BatchFatalError('Invalid value', True);
          if GetBoolean(BatchParamStr(4, True)) then C := C or dtErrorInfo;
          Act^.CopyDiskType := C;
          G := GetBoolean(BatchParamStr(5, True));
        end
        else
        begin
          TapeDirSize := EvalAny(BatchParamStr(3, True), I);
          if TapeDirSize = 0 then TapeDirSize := DefTapeDirSize;
          if TapeDirSize > MaxTapeDirSize then TapeDirSize := MaxTapeDirSize;
        end;
      end;
    end;
    if O then
    begin
      if Disk then
      begin
        Act^.CopyMode := pmDisk;
        X := GetDiskExt(Act^.CopyDiskType);
      end
      else
      begin
        Act^.CopyMode := pmTape;
        X := DOSExt[pmTape];
      end;
      Act^.CorrectName;
      T := MakeFileExt(Act^.CopyName, X);
      Act^.CopyName := T;
      Act^.ImageName := T;
      Act^.CopyImageName := T;
      S := AddToPath(Act^.CopyPath, Act^.CopyName, chDirSep);
      Act^.CopyFullName := AddToPath(Act^.CopyPath, Act^.CopyName, chDirSep);
      if Disk and G then Act^._Label := DestName else
        Act^._Label := ReconvertCBMName(DestName, False, True, hxPercent);
      if Disk then
      begin
        DiskTitle := DestName;
        Act^.ExtBAMMode := ImageExtBAMMode;
        Act^.NewMode := pmDisk;
        Act^.DirTrack := 0;
        Act^.CheckDiskType;
        Act^.RealImagePath := '';
        Act^.MakeBAM;
        Act^.SetBAMLabel(Act^._Label);
      end
      else
      begin
        TapeTitle := DestName;
        Act^.CopyImageSize := TapeDirSize;
        Act^.NewMode := pmTape;
        FillChar(Act^.TapeName[1], 32, 0);
        Act^.TapeName := 'C64 tape image file';
        Act^.TapeName[0] := #32;
      end;
      Act^.Working := True;
      if Inact^.Mode = pmInfo then Inact^.DrawPanel;
      D := InfoWin(stEmpty, 'Creating the file', Act^.CopyFullName, stEmpty, 2);
      O := False;
      if FileExists(S, False) then
      begin
        Act^.ShutImageMode;
        Act^.ImageName := '';
        ErrorWin(stEmpty, 'The following image file exists', Act^.CopyFullName, hcMakeImage, sbNone);
      end
      else
      begin
        SysErrorOccurred := False;
        if Disk and (Act^.DiskType and dtTypeMask = dt1541Ext) and G and (Act^.ExtBAMMode <> xbSpeedDOS) then
        begin
          ErrorWin(stEmpty, 'Can''t create GEOS-compatible extended 1541', 'disk images with a non-Speed DOS BAM.',
            hcMakeImage, sbNone);
        end
        else
        begin
          if FormatFile(False, G) then
          begin
            O := True;
            if (M <> pmInfo) and (UpperCase(Act^.Path) = UpperCase(Act^.CopyRealPath)) then Act^.ShutImageMode
              else Act^.NewMode := M;
          end
          else
          begin
            Act^.ShutImageMode;
            Act^.ImageName := '';
            if not SysErrorOccurred then ErrorWin(stEmpty, 'Can''t create the image file', Act^.CopyFullName,
              hcMakeImage, sbNone);
            ClockOn;
          end;
        end;
      end;
      Dispose(D, Done);
      if O then RereadPanels;
    end;
  end;
  RestoreHelpCtx;
  NextBatchCommand;
end;

end.
