
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   MAINFN2.PAS                   }
{                                                 }
{       The Star Commander functions unit #2      }
{*************************************************}

unit MainFn2;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Panel1;

procedure ChangeDrive(Panel: PPanel);
procedure VolumeLabel;
procedure History;
procedure EGALines;
procedure VideoMode;

implementation

uses
  App, Dialogs, Drivers, Objects, Views,
  Base1, Base2, Constant, DOSShell, ExtFiles, LowLevel, MiscFunc, Panel2;

{'Drive' item in the 'Left' and 'Right' menus: change the drive of a panel
  Input : Panel: the panel whose drive to change}
procedure ChangeDrive(Panel: PPanel);
var
  O             : Boolean;
  A,
  E,
  N,
  W,
  X,
  Y,
  Z             : Byte;
  L             : Char;
  C             : Word;
  I             : Integer;
  D             : PDialog;
  P,
  S,
  T             : string;
  R             : TRect;
  B             : array [1..30] of PButton;
  V             : array ['A'..'Z'] of Boolean;

{Read the contents of the new drive into the panel}
procedure ReadPanel;
begin
  Panel^.QuickView := qvNone;
  Panel^.ImageName := '';
  Panel^.RealImagePath := '';
  Panel^.Reread;
  Panel^.Vis := True;
  if Panel^.Other^.Mode = pmInfo then Panel^.Other^.DrawPanel;
  SetVisibility(True, True, True);
end;

begin
  ChangeHelpCtx(hcChangeDrive);
  BoxTitle := 'Change drive';
  ClockOff;
  SysErrorOccurred := False;
  if Panel = Left then T := 'left' else T := 'right';
  N := 4;
  S := '';
  FailSysErrors := fsAll;
  for L := 'A' to 'Z' do
  begin
    V[L] := DriveValid(L);
    if V[L] then
    begin
      S := S + L;
      Inc(N);
    end;
  end;
  FailSysErrors := fsNone;
  X := 4;
  W := 3;
  P := stSpace;
  if N > 7 then
  begin
    X := 3;
    if N > 9 then
    begin
      X := 2;
      W := 1;
      P := '';
      if N > 14 then X := 1;
    end
  end;
  Z := N * X + 2 + W - X;
  if Z < 16 + Length(T) then Z := 16 + Length(T);
  A := Z shr 1 + 4 - (N * X) shr 1;
  if (Z and 1 > 0) and (N * X and 1 = 0) then Inc(A);
  MakeWinBounds(R, Z, 2);
  FixWinBoundsToPanel(R, Panel);
  D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, False));
  Y := Z shr 1 - 3 - Length(T) shr 1;
  if (Z and 1 > 0) and (Length(T) and 1 = 0) then Inc(Y);
  R.Assign(Y, 2, 14 + Length(T), 1);
  D^.Insert(New(PColorText, Init(R, 'Choose '+ColorChar + T + ColorChar+' drive: ')));
  S := S + '8901';
  for E := 1 to Length(S) do
  begin
    L := S[E];
    if not (L in ['A'..'Z']) or V[L] then
    begin
      R.Assign(A, 3, W, 1);
      B[E] := New(PButton, Init(R, P + ColorChar + L + ColorChar + P, cmYes));
      D^.Insert(B[E]);
      Inc(A, X);
    end;
  end;
  if (Panel^.Mode = pmExt) or Panel^.OK then L := Panel^.Path[1] else L := Panel^.Other^.Path[1];
  if (LeftPos(L, S) = 0) then
  begin
     case L of
       'A', 'B': L := Chr((Ord('A') + Ord('B')) - Ord(L));
       'C': if (LeftPos('A', S) = 0) and (LeftPos('B', S) > 0) then L := 'B' else L := 'A';
       '8', '9', '0', '1':
     else
       L := 'C';
     end;
  end;
  E := LeftPos(L, S);
  B[1]^.MakeFirst;
  B[E]^.Select;
  ClockOn;
  C := Application^.ExecView(D, True, True);
  S := PButton(D^.Current)^.Title^;
  L := S[3];
  if L = ColorChar then L := S[2];
  Dispose(D, Done);
  if C <> cmCancel then
  begin
    S := L + ':';
    ClockOff;
    InOutRes := 0;
    O := False;
    if DriveOK(S) then
    begin
      ChDrive(CurPath[1]);
      L := S[1];
      case L of
        '0'..'9':
        begin
          if Panel^.Other^.Mode = pmExt then
          begin
            ErrorWin(stEmpty, 'You''re allowed to have only one panel', 'showing the contents of an external drive.',
              hcChangeDrive, sbNone);
          end
          else
          begin
            if CheckLPTPorts(True) then
            begin
              Panel^.OK := False;
              if Panel^.Other^.Mode = pmInfo then Panel^.Other^.DrawPanel;
              N := Ord(L) - Ord('0');
              if N < 2 then Inc(N, 10);
              if (Panel^.Mode <> pmExt) or (N <> Panel^.CBMDev) then
              begin
                Panel^.Changing := True;
                Panel^.DrawPanel;
              end;
              CurPath := Panel^.Other^.Path;
              if CurPath <> Panel^.Path then LongChDir(CurPath);
              Panel^.CBMDev := N;
              Panel^.NewMode := pmExt;
              Panel^.Path := L + ':';
              ReadPanel;
              O := True;
            end;
          end;
        end;
        'A'..'Z':
        begin
          Panel^.NewMode := pmDOS;
          Panel^.Path := LongGetDir(Ord(S[1]) - Ord('@'));
          ReadPanel;
          O := True;
        end;
      end;
    end;
    if (Panel = Act) or (Panel^.Other^.Mode = pmExt) then LongChDir(Panel^.Path);
    ClockOn;
  end;
  RestoreHelpCtx;
end;

{'Volume label' item in the 'Commands' menu: change the label of a disk or
  an image file}
procedure VolumeLabel;
var
  P             : Byte;
  M             : Integer;
  D             : PDialog;
  L,
  N             : string;
begin
  ChangeHelpCtx(hcVolumeLabel);
  BoxTitle := 'Volume label';
  if Act^.OK and (Act^.Mode in [pmExt, pmDisk, pmTape]) then
  begin
    if Act^.Mode = pmTape then M := 24 else M := 22;
    N := Act^._Label;
    DestName := ConvertCBMName(N, Act^.GEOSFormat, False, hxPercent);
    if Act^.GetFileName(stEmpty, 'Change volume label "' + MakeCBMName(N, Act^.GEOSFormat) + '" to', stEmpty, nil, nil, True,
      False, True, False, False, False, eeNone, aaNone) and (DestName <> N) then
    begin
      ClockOff;
      L := ReconvertCBMName(DestName, Act^.GEOSFormat, True, hxPercent);
      if Act^.Mode = pmExt then
      begin
        MouseOff;
        D := InfoWin(stEmpty, 'Changing volume label of', 'disk in drive ' + LeadingSpace(Act^.CBMDev, 1) + ':', stEmpty, 2);
        if SendDriveProg(deBase, True) and SendDriveProg(deLabel, False) then
          ExecDriveProg(deLabel, '0:' + CorrectBAMLabel(L, Act^.CopyDiskType, Act^.ExtBAMMode));
        if not ReadCBMError(N, False, False, True) then ErrorWin(stError, N, stEmpty, hcVolumeLabel, sbNone);
        Dispose(D, Done);
        MouseOn;
      end
      else
      begin
        D := InfoWin(stEmpty, 'Changing volume label of', Act^.ImageName, stEmpty, 2);
        if Act^.OpenImage(True, False, True, True, True) = 0 then
        begin
          if Act^.ImageReadOnly then
          begin
            ErrorWin(stEmpty, 'The following image file is marked read-only.', Act^.ImageName, hcVolumeLabel, sbNone);
          end
          else
          begin
            if Act^.Mode = pmDisk then
            begin
              Act^.SetBAMLabel(L);
              Act^.WriteBAM;
            end
            else
            begin
              Act^.WriteTapeBlock(1, @Act^.DirBuffer);
              while Length(L) < 24 do L := L + stSpace;
              for P := 1 to 24 do Act^.DirBuffer[P + 7] := Ord(L[P]);
              Act^.WriteTapeBlock(1, @Act^.DirBuffer);
            end;
          end;
          Act^.CloseImage(True);
        end;
        Dispose(D, Done);
      end;
      RereadPanels;
    end;
  end;
  RestoreHelpCtx;
end;

{'History' item in the 'Commands' menu: pop up the list of recent DOS
  commands}
procedure History;
var
  C             : Word;
  I,
  Y             : Integer;
  D             : PDialog;
  A,
  B,
  P             : PHistoryItem;
  M             : PHistory;
  L             : string;
  R             : TRect;
begin
  ChangeHelpCtx(hcHistory);
  BoxTitle := 'History';
  Y := ShellBuffer^.HistoryNum;
  P := nil;
  for I := 0 to Y do
  begin
    if I < Y then L := ShellBuffer^.History[I] else L := '';
    if Length(L) > 60 then L[0] := #60;
    P := NewHistoryItem(stEmpty, L, I + 1, False, P);
    if I = 0 then A := P;
  end;
  R.Assign(4, 2, 36, Y + 3);
  M := New(PHistory, Init(R, A, CurHistory, False));
  MakeWinBounds(R, M^.Size.X, Y + 1);
  D := New(PDialog, Init(R, 'History', fxNormal, fyNormal, False));
  D^.Insert(M);
  D^.Palette := wpHistory;
  C := Application^.ExecView(D, True, True);
  Dispose(D, Done);
  if HistoryItem >= 0 then
  begin
    if HistoryItem <= Y then
    begin
      if M^.CtrlEnter then
      begin
        CurHistory := HistoryItem - 1;
        CommandLine^.CopyHistory;
      end
      else
      begin
        PutCommand(ShellBuffer^.History[HistoryItem - 1], True);
        SingleCommand := True;
        ClearCommand := True;
        PopupMenu := False;
        EnterDOSShell;
      end;
    end
    else
    begin
      CommandLine^.Data^ := '';
      CommandLine^.DrawView;
    end;
  end;
  RestoreHelpCtx;
end;

{Set the screen mode and fix the background, the panels and other objects
  accordingly}
procedure SetScreenMode;
var
  I,
  J,
  K,
  X,
  Y             : Word;
  P             : PScreenBuffer;
begin
  Left^.Hide;
  Right^.Hide;
  ClockOff;
  LastHalfSec := 2;
  X := ScreenWidth;
  Y := ScreenHeight;
  CharSetMode := csIBMLower;
  Application^.SetScreenMode(ScreenMode);
  if (ScreenWidth <> X) or (ScreenHeight <> X) then
  begin
    if (ScreenWidth <> X) or (ScreenHeight < Y) then
    begin
      P := New(PScreenBuffer);
      Move(BackBuffer, P^, X * Y shl 1);
      I := 0;
      if ScreenHeight < Y then I := (Y - ScreenHeight) * X shl 1;
      J := 0;
      K := ScreenHeight;
      while K > 0 do
      begin
        Move(P^[I], BackBuffer[J], ScreenWidth shl 1);
        if ScreenWidth > X then
          FillWord(BackBuffer[J + X shl 1], ScreenWidth - X, Ord(' ') + (BackAttr shl 8));
        Inc(I, X shl 1);
        Inc(J, ScreenWidth shl 1);
        Dec(K);
      end;
      Dispose(P);
    end;
    if ScreenHeight < Y then
    begin
      if BackCursorY > Y - ScreenHeight then Dec(BackCursorY, Y - ScreenHeight) else BackCursorY := 0;
    end
    else
    begin
      FillWord(BackBuffer[(Y - 2) * ScreenWidth shl 1], (ScreenHeight - (Y - 2)) * ScreenWidth, Ord(' ') + (BackAttr shl 8));
    end;
  end;
  ClockOn;
  ChangePanels;
end;

{'EGA lines' item in the 'Commands' menu: toggle 25/43 line (EGA) or 25/50
  line (VGA) screen mode}
procedure EGALines;
begin
  if HiResScreen then
  begin
    ScreenMode := ScreenMode xor smEGALines;
    SetScreenMode;
  end;
end;

{'Video mode' item in the 'Commands' menu: change to another video mode,
  including VESA text modes}
procedure VideoMode;
const
  ColorModes    : array [False..True] of string[5] = ('mono', 'color');
var
  F,
  O,
  D,
  Q             : Boolean;
  B,
  C,
  L             : Byte;
  M,
  U,
  V,
  X,
  Y,
  Z             : Word;
  I             : Integer;
  W             : PWord;
  A,
  P             : PHistoryItem;
  S             : string;
  N             : array [0..15] of Word;
begin
  ChangeHelpCtx(hcVideoMode);
  BoxTitle := 'Video mode';
  F := False;
  if VESASupport then
  begin
    FillChar(TempBuffer, 512, 0);
    asm
      mov ax, $4F00;
      push ds;
      pop es;
      mov di, Offset(TempBuffer);
      call VideoInt;
      cmp ax, $004F;
      jne @1;
      cmp word ptr TempBuffer[0], 'EV';
      jne @1;
      cmp word ptr TempBuffer[2], 'AS';
      jne @1;
      inc F;
      les di, dword ptr TempBuffer[$000E];
      mov word ptr W[0], di;
      mov word ptr W[2], es;
  @1:
    end;
  end;
  O := True;
  P := nil;
  B := 0;
  C := 0;
  U := 0;
  Z := (ScreenMode and smModeMask);
  while O and (B < 15) do
  begin
    M := 0;
    Q := False;
    case B of
      0:
      begin
        V := smCO80;
        M := $008F;
        X := 80;
        Y := 25;
      end;
      1:
      begin
        V := smMono;
        M := $0087;
        X := 80;
        Y := 25;
      end;
    else
      V := W^;
      Q := True;
    end;
    if (Z > U) and (Z < V) then
    begin
      V := Z;
      Q := False;
    end;
    D := True;
    if M = 0 then
    begin
      D := False;
      asm
        mov ax, $4F01;
        mov cx, V;
        push ds;
        pop es;
        mov di, Offset(GCRBuffer);
        call VideoInt;
        cmp ax, $004F;
        jne @1;
        mov D, True;
        mov ax, word ptr GCRBuffer[$0000];
        mov M, ax;
        mov ax, word ptr GCRBuffer[$0012];
        mov X, ax;
        mov ax, word ptr GCRBuffer[$0014];
        mov Y, ax;
    @1:
      end;
    end;
    L := 0;
    while D and (L < B) do
    begin
      D := (N[L] <> V);
      Inc(L);
    end;
    if D and (M and $0013 = 3) then
    begin
      if V = Z then C := B;
      S := 'x' + LeadingSpace(Y, 0);
      S := 'Mode $' + HexaStr(V, 4) + LeadingSpace(X, 8 - Length(S)) + S + ' ' + ColorModes[(M and $0008 > 0)];
      P := NewHistoryItem(HexaStr(B + 1, 1), S, B, True, P);
      if B = 0 then A := P;
      N[B] := V;
      Inc(B);
    end;
    if F then
    begin
      if Q then Inc(W);
      O := (W^ <> MaxWord);
    end
    else
    begin
      O := (B < 2);
    end;
    U := V;
  end;
  if DisplayUserMenu('Select video mode', B, 0, C, mtNone, A, @S, True, True) = cmOK then
  begin
    V := HexaEval(Copy(S, 7, 4), I);
    if (I = 0) and (V <> (ScreenMode and smModeMask)) then
    begin
      ScreenMode := V;
      SetScreenMode;
    end;
  end;
  RestoreHelpCtx;
end;

end.
