
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   MISCFUNC.PAS                  }
{                                                 }
{ The Star Commander miscellaneous functions unit }
{*************************************************}

unit MiscFunc;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Objects, Views,
  Base2, Constant, LowLevel, Panel1;

const
{How to ask destination archive type}
  aaNone        = 0;
  aaDiskImage   = 1;
  aaArchive     = 2;
  aaDiskCopy    = 3;
{Extra entries in the file name input dialog box}
  eeNone        = 0;
  eeMakeTape    = 1;
  eeDiskImageDir= 2;
{Command set for enabling/disabling functions that do not work when both
  panels are off}
  PanelCmdSet   : TCommandSet   = [cmFileAttrib, cmFileInfo,
    cmVolumeLabel, cmDiskEdit, cmCopyDisk, cmSelectFile, cmUnselectFile,
    cmInvertSel, cmSwapPanels];
{Command set for enabling/disabling functions that do not work when the
  active panels is an Info panel}
  InfoCmdSet    : TCommandSet   = [cmFileAttrib, cmFileInfo,
    cmVolumeLabel, cmDiskEdit, cmCopyDisk, cmSelectFile, cmUnselectFile,
    cmInvertSel];
{Command set for enabling/disabling functions that do not work when a
  panel is off or is an Info panel}
  LeftPanelSet  : TCommandSet   = [cmLeftFilter, cmLeftStatus];
  RightPanelSet : TCommandSet   = [cmRightFilter, cmRightStatus];

var
  AltPressed,
  BothBAMsOK    : Boolean;
  CmdLineText   : string[CmdLineLen];

function GetPanelTempPath: string;
procedure InitBAM(Panel: PPanel; GEOS, NewBorder: Boolean; var T, S, First: Byte);
function FormatFile(Backup, GEOS: Boolean): Boolean;
function ExpandTape(Panel: PPanel; Num: Integer; Backup: Boolean): Boolean;
procedure InitDiskChange;
procedure DoneDiskChange;
function FormatDisk(Panel: PPanel; Multiple, GetName, Ask: Boolean): Byte;
procedure UnselectProcessed;
function DriveNumber(Panel: PPanel; Full: Boolean): string;
function CanDeleteFile(Panel: PPanel): Boolean;
procedure ValidateDisk(Alloc: Boolean);
function SaveConfig(Dest: Byte): Boolean;
procedure SaveSetup;
procedure FixWinBoundsToPanel(var R: TRect; Panel: PPanel);
procedure ReadPanel(Panel: PPanel; Start: Boolean);
procedure SetVisibility(Save, DrawBack, Reread: Boolean);
procedure SetCurrentPath(Panel: PPanel);
procedure SelectPanel(Panel: PPanel; Change: Boolean);
procedure ComputeWinSize;
procedure SetPanelBounds;
procedure ChangePanels;
procedure SetMenu;
function AutomaticSaveSetup: Boolean;

implementation

uses
  App, DOS, Dialogs, Drivers, Menus,
  Base1, Config, CpDisk, Disked, ExtFiles, FDelete, Panel2;

{Determine the path in which temporary files may be created
  Output: the path}
function GetPanelTempPath: string;
begin
  if Inact^.CopyMode = pmExt then GetPanelTempPath := GetTempPath else GetPanelTempPath := Inact^.CopyPath;
end;

{Initialize the BAM by making it empty and allocating the system sectors
  Input : Panel: the panel whose BAM is to be initialized
          GEOS: when True, modify the BAM to make it compatible with GEOS
          NewBorder: when True, a new GEOS border sector is allocated;
                     otherwise the already existing one is used
          T, S: variables to contain the track and sector number of GEOS
                border sector
          First: variable to contain the sector number of the first directory
                 block}
procedure InitBAM(Panel: PPanel; GEOS, NewBorder: Boolean; var T, S, First: Byte);
var
  B,
  D             : Byte;
begin
  Panel^.ClearBAM(False);
  B := Panel^.DirTrack;
  First := FirstDirSec(Panel^.CopyDiskType);
  T := Panel^.DirTrack + 1;
  S := ImageInts[(Panel^.CopyDiskType and dtTypeMask) shl 1 + 1];
  for D := 0 to FirstDirSec(Panel^.CopyDiskType) do Panel^.AllocBlock(B, D, True);
  if Panel^.CopyDiskType and dtTypeMask = dt1581 then
  begin
    T := Panel^.DirTrack;
    S := Panel^.SectorNum(Panel^.DirTrack) shr 1 - 1;
  end;
  if GEOS then
  begin
    if not NewBorder then
    begin
      T := Panel^.BAM[GEOSBorderPos];
      S := Panel^.BAM[GEOSBorderPos + 1];
    end;
    Panel^.AllocBlock(T, S, True);
    Panel^.BAM[GEOSBorderPos] := T;
    Panel^.BAM[GEOSBorderPos + 1] := S;
    Move(GEOSSign[1], Panel^.BAM[GEOSSignPos], Length(GEOSSign));
  end;
end;

{Format (re-fill with empty data) the current disk or tape image or create a
  new one
  Input : Backup: when True, a backup file is created
          GEOS: when True, a GEOS disk image is formatted
  Output: O: when False, an error occured}
function FormatFile(Backup, GEOS: Boolean): Boolean;
var
  F,
  O             : Boolean;
  B,
  S,
  T             : Byte;
  W             : Word;
  I             : Integer;
  L             : Longint;
  P             : PBuffer;
begin
  ClockOff;
  O := True;
  if Backup then O := Act^.CopyBackupFile(False);
  if O then
  begin
    F := (Act^.RealImagePath <> '');
    B := fmWriteOnly;
    if F then B := fmReadWrite;
    O := (LongOpenFile(AddToPath(Act^.CopyPath, Act^.CopyImageName, chDirSep), Act^.Image, B) = 0);
    if O then
    begin
      P := New(PBuffer);
      case Act^.NewMode of
        pmDisk:
        begin
          W := 0;
          while W < TBufferSize do
          begin
            FillFormatPattern(@P^[W]);
            Inc(W, 256);
          end;
          L := Act^.DiskPos(Act^.FirstTrack, 0) shl 8;
          if F then ExtSeek(Act^.Image, L);
          L := Act^.DiskPos(Act^.LastTrack, 0) shl 8 - L;
          while (L > 0) and not Escape and (InOutRes = 0) do
          begin
            if L > TBufferSize then W := TBufferSize else W := L;
            Dec(L, W);
            ExtBlockWrite(Act^.Image, P^, W);
          end;
          if L = 0 then
          begin
            if Act^.CopyDiskType and dtErrorInfo > 0 then
            begin
              FillChar(TempBuffer, Act^.CopyDiskSize, dsOK);
              ExtBlockWrite(Act^.Image, TempBuffer, Act^.CopyDiskSize);
            end;
            InitBAM(Act, GEOS, True, T, S, B);
            Act^.WriteBAM;
            FillChar(DataBuffer, 256, 0);
            DataBuffer[1] := MaxByte;
            Act^.WriteDiskBlock(Act^.DirTrack, B, @DataBuffer);
            if GEOS then Act^.WriteDiskBlock(T, S, @DataBuffer);
          end;
        end;
        pmTape:
        begin
          while Length(Act^._Label) < 24 do Act^._Label := Act^._Label + stSpace;
          FillChar(DataBuffer, 256, 0);
          for B := 0 to 31 do DataBuffer[B] := Ord(Act^.TapeName[B + 1]);
          DataBuffer[33] := 1;
          DataBuffer[34] := Lo(Act^.CopyImageSize);
          DataBuffer[35] := Hi(Act^.CopyImageSize);
          for B := 40 to 63 do DataBuffer[B] := Ord(Act^._Label[B - 39]);
          ExtBlockWrite(Act^.Image, DataBuffer, 64);
          W := Act^.CopyImageSize shl 5;
          FillChar(P^, W, 0);
          ExtBlockWrite(Act^.Image, P^, W);
          ExtTruncate(Act^.Image);
        end;
      end;
      Dispose(P);
      if Backup and KeepTime then ExtSetFTime(Act^.Image, Act^.FileTime);
      ExtClose(Act^.Image);
      O := (IOResult = 0);
    end;
    if Backup then Act^.MakeBackupFile(O);
  end;
  FormatFile := O;
end;

{Expand or shrink a tape image
  Input : Panel: the panel that contains the tape image
          Num: when positive, number of entries to expand tape image with;
               when negative, number of entries to cut off tape image
          Backup: when True, a backup file is created from the original tape
                  image
  Output: when True, the tape image was successfully processed}
function ExpandTape(Panel: PPanel; Num: Integer; Backup: Boolean): Boolean;
var
  O             : Boolean;
  X,
  Y             : Word;
  L             : Longint;
  P,
  Q             : PSmallBuf;
begin
  O := False;
  if LongOpenFile(AddToPath(Panel^.CopyPath, Panel^.CopyImageName, chDirSep), TempFile, fmReadOnly) = 0 then
  begin
    ExtGetFTime(TempFile, ReadTime);
    if not Panel^.ImageReadOnly and (LongOpenFile(Panel^.MakeTempName, WriteFile, fmWriteOnly) = 0) then
    begin
      TempFileOpen := True;
      P := New(PSmallBuf);
      L := (Num shl 5);
      Y := Panel^.CopyImageSize;
      X := (Y + 2) shl 5;
      ExtBlockRead(TempFile, P^, X);
      Q := P;
(* ?ASM? *)
      asm
        les di, P;
        mov ax, Num;
        add word ptr es:[di][34], ax;
        add di, 64;
        mov ax, word ptr L[0];
        mov dx, word ptr L[2];
        mov cx, Y;
    @2: cmp byte ptr es:[di], 0;
        je @1;
        add word ptr es:[di][8], ax;
        adc word ptr es:[di][10], dx;
    @1: add di, 32;
        loop @2;
      end;
      if Num > 0 then FillChar(P^[X], L, 0);
      Y := X;
      Inc(X, L);
      ExtBlockWrite(WriteFile, P^, X);
      Dispose(P);
      CopyPart(TempFile, WriteFile, ExtFileSize(TempFile) - Y, TBufferSize);
      if KeepTime then ExtSetFTime(WriteFile, ReadTime);
      ExtClose(WriteFile);
      O := (IOResult = 0);
    end;
    ExtClose(TempFile);
    if O then
    begin
      if Backup and MakeBackup then LongRename(TempFile.LongName, AddToPath(Panel^.CopyPath,
        MakeFileExt(Panel^.CopyImageName, 'bak'), chDirSep)) else LongErase(TempFile.LongName);
      LongRename(WriteFile.LongName, AddToPath(Panel^.CopyPath, Panel^.CopyImageName, chDirSep));
      InOutRes := 0;
    end;
  end;
  ExpandTape := O;
end;

{Initialize the disk change detection for the external drive}
procedure InitDiskChange;
var
  P             : PPanel;

{Check if a panel is in external mode, with a 1541 or 1571 drive attached
  Input : Panel: the panel to check}
procedure CheckPanel(Panel: PPanel);
begin
  if (Panel^.CopyMode = pmExt) and (Panel^.DiskType in [dt1541, dt1541Ext, dt1571]) then P := Panel;
end;

begin
  if DetectDiskChange then
  begin
    P := nil;
    CheckPanel(Left);
    CheckPanel(Right);
    if (P <> nil) and CheckDevice then
    begin
      CBMDevNum := P^.CBMDev;
      if SendDriveProg(deTurboDiskChange, True) and ExecDriveProg(deTurboDiskChange, stEmpty) then
      begin
        DiskChangeCmd := cmOK;
        ShutDownAsync;
      end;
      SetTimeout(False);
    end;
  end;
end;

{Shut down the disk change detection}
procedure DoneDiskChange;
begin
  if DiskChangeCmd <> cmNone then
  begin
    TurboOff;
    asm
      call ClkHi;
    end;
    DiskChangeCmd := cmNone;
  end;
end;

{Format the current disk in the Commodore drive
  Input : Panel: the panel in which the disk is formatted
          Multiple: when True, multiple disks are formatted
          GetName: when True, the disk label and ID is input
          Ask: when True, a security confirmation is asked
  Output: when 0, the format was finished successfully; when 1, an error
          occured; when 2, the format was cancelled}
function FormatDisk(Panel: PPanel; Multiple, GetName, Ask: Boolean): Byte;
var
  O,
  G,
  H,
  S             : Boolean;
  B,
  C,
  E,
  J,
  M,
  X             : Byte;
  D             : PDialog;
  A             : PSItem;
  F,
  L             : string;
begin
  B := 2;
  O := False;
  H := False;
  E := 0;
  J := 0;
  M := 1;
  case ExtDiskType of
    dt1541: E := Byte(Act^.CopyDiskType and dtTypeMask = dt1541Ext);
    dt1571: E := Byte(Act^.CopyDiskType and dtTypeMask = dt1541);
  end;
  repeat
    ErrorDown := 0;
    A := nil;
    if ExtDiskType in [dt1541, dt1571] then
    begin
      A := NewSItem('Verify disk and allocate bad sectors', nil);
      J := 1;
    end;
    if Multiple then
    begin
      A := NewSItem('Format multiple disks', A);
      J := J shl 1;
    end;
    case ExtDiskType of
      dt1541:
      begin
        A := NewSItem('Extended 1541 disks', A);
        M := 2;
        J := J shl 1;
      end;
      dt1571:
      begin
        A := NewSItem('Single-sided disks', A);
        M := 2;
        J := J shl 1;
      end;
    end;
    if VerifyWrite and GetName then E := E or J;
    GetCheckData := E;
    G := True;
    S := False;
    if GetName then
    begin
      E := 0;
      DestName := ConvertCBMName(DestName, False, False, hxPercent);
      G := Panel^.GetFileName(stEmpty, 'Format disk with the label', stEmpty, A, nil, True, False, True, False, False, False,
        eeNone, aaNone);
      if G then
      begin
        E := GetCheckData;
        DestName := ReconvertCBMName(DestName, False, True, hxPercent);
      end;
    end;
    if G and (not Ask or (E and 2 > 0) or (Confirm(stEmpty, 'Do you wish to format',
      'disk in drive ' + LeadingSpace(CBMDevNum, 1) + ':', ' '+ColorChar+'F'+ColorChar+'ormat ', stEmpty, stEmpty,
      nil, CurHelpCtx, True, DummyByte) = cmOK)) then
    begin
      O := True;
      if (CopyCmdExecMode = cxNormal) and (E and 1 > 0) then
      begin
        case ExtDriveType of
          dt1541:
          begin
            ErrorWin(stError, 'Can''t format extended disks', 'in normal command exec mode.', CurHelpCtx, sbNone);
            O := False;
          end;
          dt1571: S := True;
        end;
      end;
      if E and J > 0 then
      begin
        if CopyCmdExecMode = cxNormal then
        begin
          ErrorWin(stError, 'Can''t verify disks during format', 'in normal command exec mode.', CurHelpCtx, sbNone);
          O := False;
        end;
        if O and (E and 1 > 0) and (ExtDriveType = dt1541) then
        begin
          ErrorWin(stError, 'Can''t verify disks during format', 'for extended 1541 disks.', CurHelpCtx, sbNone);
          O := False;
        end;
      end;
      if O then
      begin
        ClockOff;
        MouseOff;
        Panel^.CopyMode := pmExt;
        Panel^.CopyDiskType := DetectDiskType(E and 1 > 0, False);
        Panel^.CheckDiskType;
        D := InfoWin(stEmpty, 'Formatting the disk', 'in drive ' + LeadingSpace(CBMDevNum, 1) + ':', stEmpty, 2);
        L := Copy(CorrectBAMLabel(DestName, Panel^.CopyDiskType, Panel^.ExtBAMMode), 1, 19);
        for C := 1 to Length(L) do if L[C] in ['*', '=', '?'] then L[C] := ' ';
        if CheckDevice then
        begin
          if B <> 0 then B := 1;
          if S then
          begin
            X := ExternalDrive;
            ExternalDrive := xd157xEmu;
            InitTransfer(False);
            SendConfigData;
            Panel^.CopyDiskType := dt1541;
            Panel^.CheckDiskType;
          end;
          if CopyCmdExecMode = cxNormal then
          begin
            OpenCBMChannel(saCommand, 'N0:' + L, True);
            O := ReadCBMError(F, True, False, True);
          end
          else
          begin
            if not S then SendConfigData;
            C := deTurboDiskFormat;
            if (E and J > 0) and (Panel^.CopyDiskType and dtTypeMask = dt1541) then C := deTurboDiskFormatVerify;
            if SendDriveProg(C, True) then ExecDriveProg(C, Chr(Panel^.CopyMaxTrack) +
              Chr(Byte(OrigPattern)) + Chr(Byte(FormatBumpsHead)) +
              Chr(FirstHeaderPadding(Panel^.CopyDiskType, Panel^.ExtBAMMode)) + Chr(HeaderPadding) + '0:' + L);
            asm
              push word ptr CopyPriorityMode;
              call InterruptOff;
              call ParallelInput;
              call TReceive;
              push ax;
              call InterruptOn;
              call ParallelOutput;
              pop ax;
            end;
            ShutDownAsync;
            O := ReadCBMError(F, True, False, True);
            if O and (Panel^.CopyDiskType and dtTypeMask = dt1541Ext) then
            begin
              ReadExtBlock(Panel^.DirTrack, 0, @Panel^.BAM);
              InitBAM(Panel, False, True, C, C, C);
              WriteExtBlock(Panel^.DirTrack, 0, @Panel^.BAM);
            end;
          end;
          if S then
          begin
            ExternalDrive := X;
            InitTransfer(False);
            SendConfigData;
          end;
        end
        else
        begin
          O := ReadCBMError(F, True, False, True);
        end;
        if O then B := 0 else ErrorWin(stError, F, stEmpty, CurHelpCtx, sbNone);
        Dispose(D, Done);
        MouseOn;
        ClockOn;
        H := True;
      end;
    end;
  until E and M = 0;
  ErrorDown := 0;
  FormatDisk := B;
end;

{Unselect all source files that have been processed}
procedure UnselectProcessed;
var
  B             : Byte;
  I             : Integer;
begin
  if Act^.Max > 0 then
  begin
    for I := 0 to Act^.Max - 1 do
    begin
      B := Act^.Dir[I].Status;
      if B and fsProcessMask = fsProcessed then Act^.Dir[I].Status := B and fsStatusMask;
    end;
  end;
end;

{Create a drive designator string for the external Commodore drive
  Input : Panel: the panel holding the drive
          Full: when true, the designator is appended with some text
  Output: the drive designator string}
function DriveNumber(Panel: PPanel; Full: Boolean): string;
var
  S             : string[20];
begin
  S := LeadingSpace(Panel^.CBMDev, 1);
  S := S[Length(S)] + ':';
  if Full then S := 'the disk in drive ' + S;
  DriveNumber := S;
end;

{Check if the current file being deleted is a GEOS file
  Input :
  Output: when True, the file is not a GEOS file}
function CanDeleteFile(Panel: PPanel): Boolean;
begin
  CanDeleteFile := True;
  if (Panel^.CopyMode = pmExt) and Panel^.CopyGEOSFormat and (Panel^.CopyExtAttr > 0) then
  begin
    ContProcess := ErrorWin(stError, 'Can''t delete GEOS files on Commodore disks.', Panel^.CopyFullName, CurHelpCtx, sbNone);
    CanDeleteFile := False;
  end;
end;

{Validate the current disk in the Commodore drive
  Input : Alloc: when True, the disk is validated; otherwise, files are
                 scratched on it}
procedure ValidateDisk(Alloc: Boolean);
var
  B,
  O,
  Q             : Boolean;
  E,
  N,
  S,
  T             : Byte;
  C,
  G,
  H             : Word;
  L             : PLocBuffer;

{Put a disk location into the buffer
  Input : Track, Sector: the disk location}
procedure PutLoc(Track, Sector: Byte);
begin
  if LastLoc < MaxLocations - 1 then
  begin
    L^[LastLoc].Track := Track;
    L^[LastLoc].Sector := Sector;
    Inc(LastLoc);
  end
  else
  begin
    LastLoc := MaxLocations + 1;
  end;
end;

begin
  DiskCopySelection := False;
  FillChar(TrackMap, TrackMapSize, 1);
  FillChar(GCRBuffer, TempBufferSize, 0);
  TrackMap[TrackMapSize] := 0;
  MouseOff;
  O := False;
  ContProcess := True;
  Act^.FCOPYBlock := False;
  if Act^.OpenImage(False, False, True, True, True) = 0 then
  begin
    L := New(PLocBuffer);
    InfoBuffer := New(PinfoBuffer);
    LastLoc := 0;
    if Alloc then
    begin
      PutLoc(Act^.DirTrack, 0);
      PutLoc(Act^.DirTrack, Act^.DirSector);
    end;
    Act^.FirstFile := True;
    CopyFileNum := 0;
    while Act^.FindNextFile(True, False, True) and (LastLoc <= MaxLocations) and ContProcess do
    begin
      if Act^.CopyAttr > 0 then
      begin
        Q := CanDeleteFile(Act);
        if Q and not Alloc then Q := (ConfirmDelete(Act, stFile) and ((Act^.CopyAttr and faWriteProt = 0) or
          ConfirmDeleteReadonly(Act, stFile)));
        if Q then
        begin
          if Act^.CopyAttr and faClosed > 0 then
          begin
            PutLoc(Act^.Track, Act^.Sector);
            if Act^.SideTrack <> 0 then PutLoc(Act^.SideTrack, Act^.SideSector);
          end;
          if not Alloc or (Act^.CopyAttr and faClosed = 0) then
          begin
            O := True;
            H := Act^.DirSector shl 8;
            if TrackMap[Act^.DirSector] <> 0 then
            begin
              Move(Act^.DirBuffer, TempBuffer[H], 256);
              Inc(TrackMap[TrackMapSize]);
            end;
            TempBuffer[H + Act^.EntryPos + 2] := 0;
            TrackMap[Act^.DirSector] := 0;
          end;
        end;
        if not Alloc and Q then
        begin
          FindNextUndel(Act);
          UnselectFile(Act, True);
        end
        else
        begin
          Inc(CopyFileNum);
        end;
      end;
    end;
    Act^.CloseImage(False);
    Q := False;
    if O or (LastLoc > 0) then
    begin
      if LastLoc <= MaxLocations then
      begin
        if Alloc then Act^.ClearBAM(False);
        if SendDriveProg(deWarpDiskValidate, True) and ExecDriveProg(deWarpDiskValidate, stEmpty) then
        begin
          N := 0;
          Act^.Track := Act^.DirTrack;
          B := False;
          FillChar(InfoBuffer^, Act^.MaxTrack, 0);
          Q := Escape;
          while not Q and (LastLoc > 0) do
          begin
            C := 0;
            G := 0;
            while (Status = 0) and (C < LastLoc) do
            begin
              T := L^[C].Track;
              S := L^[C].Sector;
              Inc(C);
              if T = Act^.Track then
              begin
                if N <> Act^.Track then
                begin
                  N := Act^.Track;
                  if InfoBuffer^[Act^.Track] = 0 then
                  begin
                    E := Act^.SectorNum(N);
                    H := Act^.DiskPos(N, 0) shl 1;
                    InfoBuffer^[N] := 1;
                    asm
                      push bp;
                      call ParallelOutput;
                      mov al, N;
                      call TSend;
                      mov ax, 50;
                      call Delay;
                      mov al, E;
                      xor ah, ah;
                      mov si, ax;
                      mov di, Offset(GCRBuffer);
                      add di, H;
                      call ParallelInput;
                  @1: call TReceive;
                      cmp Status, 0;
                      jne @2;
                      xor ah, ah;
                      mov bp, ax;
                      shl bp, 1;
                      call TReceive;
                      mov ds:[di][bp], al;
                      inc bp;
                      call TReceive;
                      mov ds:[di][bp], al;
                      dec si;
                      jne @1;
                  @2: pop bp;
                    end;
                  end;
                end;
                if Status = 0 then
                begin
                  while (T = Act^.Track) do
                  begin
                    Act^.AllocBlock(T, S, Alloc);
                    H := Act^.DiskPos(T, S) shl 1;
                    T := GCRBuffer[H];
                    S := GCRBuffer[H + 1];
                  end;
                end;
              end;
              L^[G].Track := T;
              L^[G].Sector := S;
              if (T > 0) and Act^.ValidPos(T, S) then Inc(G);
            end;
            LastLoc := G;
            repeat
              if B then Inc(Act^.Track) else Dec(Act^.Track);
            until (Act^.Track <> Act^.DirTrack) and (Act^.Track <> Act^.DirTrack2);
            if Act^.Track = 0 then
            begin
              Inc(Act^.Track);
              B := True;
            end;
            if Act^.Track = Act^.MaxTrack then
            begin
              Dec(Act^.Track);
              B := False;
            end;
            Q := Escape or (Status > 0);
          end;
          if not Q then TurboOff;
        end;
        if not Q then
        begin
          Act^.Track := Act^.DirTrack;
          Inact^.CopyMode := pmExt;
          Move(Act^.BAM, TempBuffer, 256);
          TrackMap[0] := 0;
          Inc(TrackMap[TrackMapSize]);
          ConvertTrack(Act^.Track, ttNormal, GetTrackType(Inact), Act^.SectorNum(Act^.Track), False);
          OpenDiskWrite(True);
          WriteTrack(False);
          LastLoc := 0;
        end;
        CloseDiskWrite(True);
        Status := 0;
      end
      else
      begin
        ErrorWin(stEmpty, 'There are too many files on', DriveNumber(Act, True), CurHelpCtx, sbNone);
        LastLoc := 0;
      end;
    end;
    Dispose(InfoBuffer);
    Dispose(L);
  end;
  MouseOn;
end;

{Copy panel variables into common ones ands save the setup
  Input : Dest: the destination to save the configuration into
  Output: when False, an error occured}
function SaveConfig(Dest: Byte): Boolean;
begin
  LeftSel := Left^.Sel;
  LeftMode := Left^.Mode;
  LeftOrigMode := Left^.OrigMode;
  LeftQuickView := Left^.QuickView;
  LeftVis := Left^.Vis;
  LeftOrigVis := LeftOrigVis;
  LeftModeMenu := Left^.ModeMenu;
  LeftColumnMode := Left^.ColumnMode;
  LeftDOSNameColWidth := Left^.DOSNameColWidth;
  LeftCBMNameColWidth := Left^.CBMNameColWidth;
  LeftMiniStatus := Left^.MiniStatus;
  LeftSortMenu := Left^.SortMenu;
  LeftSortMode := Left^.SortMode;
  LeftHiddenFiles := Left^.HiddenFiles;
  LeftFileFilter := Left^.FileFilter;
  LeftPath := Left^.Path;
  RightMode := Right^.Mode;
  RightOrigMode := Right^.OrigMode;
  RightQuickView := Right^.QuickView;
  RightVis := Right^.Vis;
  RightOrigVis := RightOrigVis;
  RightModeMenu := Right^.ModeMenu;
  RightColumnMode := Right^.ColumnMode;
  RightDOSNameColWidth := Right^.DOSNameColWidth;
  RightCBMNameColWidth := Right^.CBMNameColWidth;
  RightMiniStatus := Right^.MiniStatus;
  RightSortMenu := Right^.SortMenu;
  RightSortMode := Right^.SortMode;
  RightHiddenFiles := Right^.HiddenFiles;
  RightFileFilter := Right^.FileFilter;
  RightPath := Right^.Path;
  SaveConfig := Config.SaveConfig(Dest);
end;

{'Save setup' item in the 'Options' menu: save the current setup}
procedure SaveSetup;
begin
  ChangeHelpCtx(hcSaveSetup);
  BoxTitle := 'Save setup';
  if (Confirm(stEmpty, 'Do you wish to save', 'the current setup?', stSave, stEmpty, stEmpty,
    nil, hcSaveSetup, True, DummyByte) = cmOK) and not SaveConfig(sdFile) then
    ErrorWin(stEmpty, 'There was an error while', 'saving the setup file.', hcSaveSetup, sbNone);
  RestoreHelpCtx;
end;

{Fix bounds of a dialog box to place it on top of the center of a panel
  Input : R: rectangle to contain the computed bounds
          Panel: the panel to place to dialog box on top of}
procedure FixWinBoundsToPanel(var R: TRect; Panel: PPanel);
var
  X             : Integer;
begin
  X := Panel^.Size.X - R.B.X;
  if X < 0 then X := 0;
  X := X shr 1;
  if Panel^.Origin.X + X + R.B.X > ScreenWidth then X := ScreenWidth - (Panel^.Origin.X + R.B.X);
  R.A.X := Panel^.Origin.X + X;
end;

{Initialize the panel and if it's an external panel and there's a problem with
  the parallel ports then switch the panel to DOS mode
  Input : Start: when True, the main program was just started, otherwise
                 returned from a DOS shell}
procedure ReadPanel(Panel: PPanel; Start: Boolean);
var
  O             : Boolean;
begin
  O := True;
  Panel^.Mode := Panel^.NewMode;
  if Panel^.Mode = pmExt then O := CheckLPTPorts(True);
  if not O then
  begin
    Panel^.NewMode := pmDOS;
    Panel^.Path := Panel^.Other^.Path;
  end;
  if Start then Panel^.Reread else Panel^.Read;
end;

{Update the visibility of one panel
  Input : Panel: the panel to process
          OrigVis: original visibility of the panel
          Reread: when True, if the panel is switched from invisible to
                  visible, it is reread}
procedure PanelVis(Panel: PPanel; OrigVis, Reread: Boolean);
begin
  if Panel^.Vis and not Panel^.Other^.Vis then SelectPanel(Panel, True);
  Panel^.SetState(sfVisible, Panel^.Vis and (BatchMode = bmNone));
  if not OrigVis and Panel^.Vis and not Panel^.Success then Panel^.MustRead := True;
  if Panel^.Vis and Panel^.MustRead and Reread then ReadPanel(Panel, Panel^.MustReread);
end;

{Update the visibility of both panels
  Input : Save: when True, the new settings are saved into the setup file
          DrawBack: when True, the background is redrawn
          Reread: when True, a panel switched from invisible to visible is
                  reread}
procedure SetVisibility(Save, DrawBack, Reread: Boolean);
var
  X             : Word;
  R             : TRect;
begin
  if BatchMode <> bmNone then
  begin
    Left^.Vis := False;
    Right^.Vis := False;
    Save := False;
  end;
  X := PanWinSize + Byte(ShowMenu);
  if (Left^.Vis or Right^.Vis) and (BackCursorY < X) then BackCursorY := X;
  R.Assign(0, BackCursorY, ScreenWidth, BackCursorY + 1);
  CommandLine^.ChangeBounds(R);
  PanelVis(Left, LeftOrigVis, Reread);
  PanelVis(Right, RightOrigVis, Reread);
  if DrawBack then Background^.DrawView;
  SetMenu;
  if Save then AutomaticSaveSetup;
end;

{Set the current path to that of the specified panel
  Input : Panel: the panel}
procedure SetCurrentPath(Panel: PPanel);
begin
  if (Panel^.Mode <> pmExt) and (Panel^.Mode <> pmInfo) and (Panel^.QuickView = qvNone) then
  begin
    ClockOff;
    LoadingDirs := True;
    LongChDir(Panel^.Path);
    LoadingDirs := False;
    CurPath := Panel^.Path;
    CommandLine^.DrawView;
    ClockOn;
  end;
end;

{Activate the specified panel and change current path, if necessary
  Input : Panel: the panel to be activated
          Change: when True, current path is changed to the path of the
                  selected panel}
procedure SelectPanel(Panel: PPanel; Change: Boolean);
var
  B             : Boolean;
  S             : string;
begin
  if not Panel^.Sel then
  begin
    SysErrorOccurred := False;
    Act := Panel;
    Inact := Panel^.Other;
    Inact^.Sel := False;
    Act^.Sel := True;
    Act^.PutInFrontOf(Inact);
    Inact^.DrawPanel;
    if Act^.Mode = pmInfo then MenuBar^.DisableCommands(InfoCmdSet) else MenuBar^.EnableCommands(InfoCmdSet);
    if Change then SetCurrentPath(Panel);
  end;
end;

{Compute the height and width of the panel windows}
procedure ComputeWinSize;
var
  X             : Word;
  R             : TRect;
begin
  Application^.GetExtent(R);
  WinSize := R.B.Y - R.A.Y - 2;
  WinCenter := (WinSize - 6) shr 1;
  PanWinSize := OrigPanWinSize;
  FullScreen := (PanWinSize + Byte(ShowMenu) >= OrigScreenHeight - 2);
  if FullScreen then PanWinSize := WinSize - Byte(ShowMenu) else
    PanWinSize := ((PanWinSize + Byte(ShowMenu)) * Word(ScreenHeight)) div OrigScreenHeight - Byte(ShowMenu);
  if PanWinSize + Byte(ShowMenu) < 7 then PanWinSize := 7 - Byte(ShowMenu);
  X := WinSize - Byte(ShowMenu) - 1 + Byte(FullScreen);
  if PanWinSize + Byte(ShowMenu) > X then PanWinSize := X;
  if OrigScreenWidth = 0 then
  begin
    OrigScreenWidth := 2;
    OrigLeftPanWidth := 1;
  end;
  OrigLeftPanWidth := (OrigLeftPanWidth * Word(ScreenWidth)) div OrigScreenWidth;
  if OrigLeftPanWidth < MinPanelWidth then OrigLeftPanWidth := MinPanelWidth;
  OrigScreenWidth := ScreenWidth;
  SetMenu;
end;

{Fix the width of the Name column so that it's neither too wide or thin
  Input : Panel: the panel in which the Name column is to be fixed
          SizeX: the width of the panel}
procedure FixNameColWidth(Panel: PPanel; SizeX: Integer);
var
  X             : Integer;
begin
  if Panel^.DOSNameColWidth < MinDOSNameColWidth then Panel^.DOSNameColWidth := MinDOSNameColWidth;
  if Panel^.CBMNameColWidth < MinCBMNameColWidth then Panel^.CBMNameColWidth := MinCBMNameColWidth;
  Panel^.CopyDOSNameColWidth := Panel^.DOSNameColWidth;
  Panel^.CopyCBMNameColWidth := Panel^.CBMNameColWidth;
  X := SizeX - 2;
  if Panel^.CopyDOSNameColWidth > X then Panel^.CopyDOSNameColWidth := X;
  X := SizeX - 12;
  if (Panel^.ColumnMode shr 2) and cmModeMask = cmBrief then Inc(X, 8);
  if Panel^.CopyCBMNameColWidth > X then Panel^.CopyCBMNameColWidth := X;
end;

{Set the height and width of panels}
procedure SetPanelBounds;
var
  R             : TRect;
  X             : Integer;
begin
  X := OrigLeftPanWidth;
  R.Assign(0, Byte(ShowMenu), X, PanWinSize + Byte(ShowMenu));
  FixNameColWidth(Left, X);
  Left^.SetBounds(R);
  Inc(R.A.X, X);
  R.B.X := ScreenWidth;
  FixNameColWidth(Right, ScreenWidth - X);
  Right^.SetBounds(R);
end;

{Re-initialize both panels after changing their parameters}
procedure ChangePanels;
var
  B             : Byte;
  X,
  Y             : Word;
  R             : TRect;

procedure ProcessPanel(Panel: PPanel);
begin
  Panel^.Working := True;
  if Panel^.Max <= Panel^.PanLen then Panel^.DeltaY := 0;
  Panel^.SetPanelSize;
  Panel^.SetModeMenu;
  Panel^.SetSortOrder;
  Panel^.Working := False;
end;

begin
  MouseOff;
  ComputeWinSize;
  if ShowMenu and (BackCursorY = 0) then BackCursorY := 1;
  R.Assign(0, 0, ScreenWidth, ScreenHeight);
  X := PanWinSize + Byte(ShowMenu);
  if (Left^.Vis or Right^.Vis) and (BackCursorY < X) then BackCursorY := X;
  X := WinSize + 1 - Byte(ShowKeyBar);
  Background^.DrawView;
  if ShowMenu then MenuBar^.Show else MenuBar^.Hide;
  MenuBar^.DrawView;
  B := 6;
  if MilitaryTime then Dec(B);
  R.Assign(ScreenWidth - B, 0, ScreenWidth, 1);
  Clock^.SetBounds(R);
  LastHalfSec := 2;
  Clock^.DrawView;
  if BackCursorY > X then BackCursorY := X;
  R.Assign(0, BackCursorY, ScreenWidth, BackCursorY + 1);
  CommandLine^.ChangeBounds(R);
  Application^.GetExtent(R);
  R.A.Y := R.B.Y - 1;
  KeyBar^.SetBounds(R);
  if ShowKeyBar then KeyBar^.Show else KeyBar^.Hide;
  KeyBar^.DrawView;
  LastWhere := MouseWhere;
  ProcessPanel(Left);
  ProcessPanel(Right);
  SetPanelBounds;
  Left^.SearchName;
  Right^.SearchName;
  SetVisibility(False, True, True);
  MouseOn;
end;

{Mark the specified menu item depending on if the switch assigned to it is
  on or off
  Input : P: the menu item to be marked
          B: when True, the menu item is marked, otherwise unmarked}
procedure MarkMenu(P: PMenuItem; B: Boolean);
begin
  P^.Name^[1] := CheckChr[B];
end;

{Update the menu bar after toggling a switch}
procedure SetMenu;
begin
  if HiResScreen then MenuBar^.EnableCommands([cmEGALines]) else
    MenuBar^.DisableCommands([cmEGALines]);
  if Left^.Vis and (Left^.Mode <> pmInfo) then MenuBar^.EnableCommands(LeftPanelSet) else
    MenuBar^.DisableCommands(LeftPanelSet);
  if Right^.Vis and (Right^.Mode <> pmInfo) then MenuBar^.EnableCommands(RightPanelSet) else
    MenuBar^.DisableCommands(RightPanelSet);
  if Left^.Vis or Right^.Vis then
  begin
    MenuBar^.EnableCommands(PanelCmdSet);
    if Act^.Mode = pmInfo then MenuBar^.DisableCommands(InfoCmdSet) else MenuBar^.EnableCommands(InfoCmdSet);
  end
  else
  begin
    MenuBar^.DisableCommands(PanelCmdSet);
  end;
  MarkMenu(MAutoMenus, AutoMenus);
  MarkMenu(MPathPrompt, PathPrompt);
  MarkMenu(MKeyBar, ShowKeyBar);
  MarkMenu(MFullScreen, FullScreen);
  MarkMenu(MClock, ShowClock);
end;

{Automatically save the current settings into the setup file, if 'Auto
  save setup' is turned on
  Output: when False, an error occured}
function AutomaticSaveSetup: Boolean;
begin
  AutomaticSaveSetup := not AutoSaveSetup or SaveConfig(sdFile);
end;

end.
