
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Standard Objects Unit                           }
{                                                       }
{       Copyright (c) 1992 Borland International        }
{                                                       }
{*******************************************************}

unit Objects;

{$A+,B-,D+,E-,F+,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

const

{ Maximum TCollection size }

  MaxCollectionSize = 65520 div SizeOf(Pointer);

{ VMT header size }

  vmtHeaderSize = 8;

type

{ string pointers }

  PString = ^string;

{ TObject base object }

  PObject = ^TObject;
  TObject = object
    constructor Init;
    procedure Free;
    destructor Done; virtual;
  end;

{ TCollection types }

  PItemList = ^TItemList;
  TItemList = array[0..MaxCollectionSize - 1] of Pointer;

{ TStringCollection object }

  PStringCollection = ^TStringCollection;
  TStringCollection = object(TObject)
    Items: PItemList;
    Count: Integer;
    Limit: Integer;
    constructor Init(ALimit: Integer);
    destructor Done; virtual;
    function At(Index: Integer): Pointer;
    function IndexOf(Item: Pointer): Integer; virtual;
    procedure Insert(Item: Pointer); virtual;
  end;

{ TPoint object }

  TPoint = object
    X, Y: Integer;
  end;

{ Rectangle object }

  TRect = object
    A, B: TPoint;
    procedure Assign(XA, YA, XB, YB: Integer);
    procedure Copy(R: TRect);
    procedure Move(ADX, ADY: Integer);
    procedure Grow(ADX, ADY: Integer);
    procedure Intersect(R: TRect);
    procedure Union(R: TRect);
    function Contains(P: TPoint): Boolean;
    function Equals(R: TRect): Boolean;
    function Empty: Boolean;
  end;

{ Dynamic string handling routines }

function NewStr(const S: string): PString;
procedure DisposeStr(P: PString);

{ Longint routines }

function LongMul(X, Y: Integer): Longint;
inline($5A/$58/$F7/$EA);

function LongDiv(X: Longint; Y: Integer): Integer;
inline($59/$58/$5A/$F7/$F9);

implementation

uses
  Memory;

{ TObject }

constructor TObject.Init;
type
  Image = record
    Link: Word;
    Data: record end;
  end;
begin
  FillChar(Image(Self).Data, SizeOf(Self) - SizeOf(TObject), 0);
end;

{ Shorthand procedure for a done/dispose }

procedure TObject.Free;
begin
  Dispose(PObject(@Self), Done);
end;

destructor TObject.Done;
begin
end;

{ TStringCollection }

constructor TStringCollection.Init(ALimit: Integer);
begin
  TObject.Init;
  Count := 0;
  Limit := ALimit;
  GetMem(Items, ALimit * SizeOf(Pointer));
end;

destructor TStringCollection.Done;
var
  I: Integer;
begin
  for I := 0 to Count - 1 do DisposeStr(At(I));
  FreeMem(Items, Limit * SizeOf(Pointer));
end;

function TStringCollection.At(Index: Integer): Pointer; assembler;
asm
        LES     DI,Self
        MOV     BX,Index
        OR      BX,BX
        JL      @@1
        CMP     BX,ES:[DI].TStringCollection.Count
        JGE     @@1
        LES     DI,ES:[DI].TStringCollection.Items
        SHL     BX,1
        SHL     BX,1
        MOV     AX,ES:[DI+BX]
        MOV     DX,ES:[DI+BX+2]
        JMP     @@2
@@1:    XOR     AX,AX
        MOV     DX,AX
@@2:
end;

procedure TStringCollection.Insert(Item: Pointer); assembler;
asm
        LES     DI,Self
        MOV     BX,ES:[DI].TStringCollection.Count
        OR      BX,BX
        JL      @@2
        MOV     CX,ES:[DI].TStringCollection.Count
        CMP     BX,CX
        JG      @@2
        CMP     CX,ES:[DI].TStringCollection.Limit
        JGE     @@2
        INC     ES:[DI].TStringCollection.Count
        STD
        LES     DI,ES:[DI].TStringCollection.Items
        SHL     CX,1
        ADD     DI,CX
        ADD     DI,CX
        INC     DI
        INC     DI
        SHL     BX,1
        SUB     CX,BX
        JE      @@1
        LEA     SI,[DI-4]
        PUSH    DS
        PUSH    ES
        POP     DS
        REP     MOVSW
        POP     DS
@@1:    MOV     AX,WORD PTR [Item+2]
        STOSW
        MOV     AX,WORD PTR [Item]
        STOSW
        CLD
@@2:
end;

function TStringCollection.IndexOf(Item: Pointer): Integer; assembler;
asm
        MOV     AX,Item.Word[0]
        MOV     DX,Item.Word[2]
        LES     DI,Self
        MOV     CX,ES:[DI].TStringCollection.Count
        JCXZ    @@3
        LES     DI,ES:[DI].TStringCollection.Items
        MOV     BX,DI
        SHL     CX,1
        CLD
@@1:    REPNE   SCASW
        JCXZ    @@3
        TEST    CX,1
        JE      @@1
        XCHG    AX,DX
        SCASW
        XCHG    AX,DX
        LOOPNE  @@1
        JNE     @@3
        MOV     AX,DI
        SUB     AX,BX
        SHR     AX,1
        SHR     AX,1
        DEC     AX
        JMP     @@2
@@3:    MOV     AX,-1
@@2:
end;

{ TRect }

procedure CheckEmpty; near; assembler;
asm
        MOV     AX,ES:[DI].TRect.A.X
        CMP     AX,ES:[DI].TRect.B.X
        JGE     @@1
        MOV     AX,ES:[DI].TRect.A.Y
        CMP     AX,ES:[DI].TRect.B.Y
        JL      @@2
@@1:    CLD
        XOR     AX,AX
        STOSW
        STOSW
        STOSW
        STOSW
@@2:
end;

procedure TRect.Assign(XA, YA, XB, YB: Integer); assembler;
asm
        LES     DI,Self
        CLD
        MOV     AX,XA
        STOSW
        MOV     AX,YA
        STOSW
        MOV     AX,XB
        STOSW
        MOV     AX,YB
        STOSW
end;

procedure TRect.Copy(R: TRect); assembler;
asm
        PUSH    DS
        LDS     SI,R
        LES     DI,Self
        CLD
        MOVSW
        MOVSW
        MOVSW
        MOVSW
        POP     DS
end;

procedure TRect.Move(ADX, ADY: Integer); assembler;
asm
        LES     DI,Self
        MOV     AX,ADX
        ADD     ES:[DI].TRect.A.X,AX
        ADD     ES:[DI].TRect.B.X,AX
        MOV     AX,ADY
        ADD     ES:[DI].TRect.A.Y,AX
        ADD     ES:[DI].TRect.B.Y,AX
end;

procedure TRect.Grow(ADX, ADY: Integer); assembler;
asm
        LES     DI,Self
        MOV     AX,ADX
        SUB     ES:[DI].TRect.A.X,AX
        ADD     ES:[DI].TRect.B.X,AX
        MOV     AX,ADY
        SUB     ES:[DI].TRect.A.Y,AX
        ADD     ES:[DI].TRect.B.Y,AX
        CALL    CheckEmpty
end;

procedure TRect.Intersect(R: TRect); assembler;
asm
        PUSH    DS
        LDS     SI,R
        LES     DI,Self
        CLD
        LODSW
        SCASW
        JLE     @@1
        DEC     DI
        DEC     DI
        STOSW
@@1:    LODSW
        SCASW
        JLE     @@2
        DEC     DI
        DEC     DI
        STOSW
@@2:    LODSW
        SCASW
        JGE     @@3
        DEC     DI
        DEC     DI
        STOSW
@@3:    LODSW
        SCASW
        JGE     @@4
        DEC     DI
        DEC     DI
        STOSW
@@4:    POP     DS
        SUB     DI,8
        CALL    CheckEmpty
end;

procedure TRect.Union(R: TRect); assembler;
asm
        PUSH    DS
        LDS     SI,R
        LES     DI,Self
        CLD
        LODSW
        SCASW
        JGE     @@1
        DEC     DI
        DEC     DI
        STOSW
@@1:    LODSW
        SCASW
        JGE     @@2
        DEC     DI
        DEC     DI
        STOSW
@@2:    LODSW
        SCASW
        JLE     @@3
        DEC     DI
        DEC     DI
        STOSW
@@3:    LODSW
        SCASW
        JLE     @@4
        DEC     DI
        DEC     DI
        STOSW
@@4:    POP     DS
end;

function TRect.Contains(P: TPoint): Boolean; assembler;
asm
        LES     DI,Self
        MOV     AL,0
        MOV     DX,P.X
        CMP     DX,ES:[DI].TRect.A.X
        JL      @@1
        CMP     DX,ES:[DI].TRect.B.X
        JGE     @@1
        MOV     DX,P.Y
        CMP     DX,ES:[DI].TRect.A.Y
        JL      @@1
        CMP     DX,ES:[DI].TRect.B.Y
        JGE     @@1
        INC     AX
@@1:
end;

function TRect.Equals(R: TRect): Boolean; assembler;
asm
        PUSH    DS
        LDS     SI,R
        LES     DI,Self
        MOV     CX,4
        CLD
        REP     CMPSW
        MOV     AL,0
        JNE     @@1
        INC     AX
@@1:    POP     DS
end;

function TRect.Empty: Boolean; assembler;
asm
        LES     DI,Self
        MOV     AL,1
        MOV     DX,ES:[DI].TRect.A.X
        CMP     DX,ES:[DI].TRect.B.X
        JGE     @@1
        MOV     DX,ES:[DI].TRect.A.Y
        CMP     DX,ES:[DI].TRect.B.Y
        JGE     @@1
        DEC     AX
@@1:
end;

{ Dynamic string handling routines }

function NewStr(const S: string): PString;
var
  P: PString;
begin
  if S = '' then P := nil else
  begin
    GetMem(P, Length(S) + 1);
    P^ := S;
  end;
  NewStr := P;
end;

procedure DisposeStr(P: PString);
begin
  if P <> nil then FreeMem(P, Length(P^) + 1);
end;

end.
