
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   OPENCBM.PAS                   }
{                                                 }
{    The Star Commander OpenCBM interface unit    }
{*************************************************}

unit OpenCBM;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Constant, LowLevel;

const
{VDD handles}
  vhInvalid     = -1;
{VDD init status codes}
  viOK          = 0;
  viDLLNotFound = 1;
  viDispFuncNotFound= 2;
  viInitFuncNotFound= 3;
  viNoMemory    = 4;
{OpenCBM default port number}
  opDefault     = 0;
{OpenCBM serial bus lines}
  sbDataOpenCBM = $01;
  sbClkOpenCBM  = $02;
  sbAtnOpenCBM  = $04;
  sbResetOpenCBM= $08;
{OpenCBM function codes}
  ocDriverOpen  = 0;
  ocDriverClose = 1;
  ocListen      = 2;
  ocTalk        = 3;
  ocOpen        = 4;
  ocClose       = 5;
  ocRawRead     = 6;
  ocRawWrite    = 7;
  ocUnlisten    = 8;
  ocUntalk      = 9;
  ocGetEOI      = 10;
  ocClearEOI    = 11;
  ocReset       = 12;
  ocPPRead      = 13;
  ocPPWrite     = 14;
  ocIECPoll     = 15;
  ocIECGet      = 16;
  ocIECSet      = 17;
  ocIECRelease  = 18;
  ocIECWait     = 19;
  ocUpload      = 20;
  ocDeviceStatus= 21;
  ocExecCommand = 22;
  ocIdentify    = 23;
  ocGetDriverName= 24;
  ocVDDInstallIOHook= 25;
  ocVDDUninstallIOHook= 26;
  ocVDDuSleep   = 27;
  ocIECSetRelease= 28;
  ocIdentifyXP1541= 29;

const
  OpenCBMDriverHandle: Integer = ohInvalid;

function OpenCBMVDDInit: Integer;
procedure OpenCBMVDDUninit;
function OpenCBMDriverOpen: Integer;
procedure OpenCBMDriverClose;
procedure OpenCBMuSleep;
procedure OpenCBMReset;
procedure OpenCBMIECPoll;
procedure OpenCBMIECSet;
procedure OpenCBMIECRelease;
procedure OpenCBMIECSetRelease;
procedure OpenCBMRawRead;
procedure OpenCBMRawWrite;
procedure OpenCBMPPRead;
procedure OpenCBMPPWrite;
procedure OpenCBMGetEOI;
procedure OpenCBMClearEOI;
procedure OpenCBMListen;
procedure OpenCBMTalk;
procedure OpenCBMUnlisten;
procedure OpenCBMUntalk;
procedure OpenCBMOpen;
procedure OpenCBMClose;
procedure OpenCBMDeviceStatus;

implementation

const
  VDDInitialized: Boolean = False;
  VDDHandle     : Integer = vhInvalid;
  DLLName       : string[15] = 'OpencbmVDD.dll'#0;
  InitFunc      : string[16] = 'VDDRegisterInit'#0;
  DispFunc      : string[12] = 'VDDDispatch'#0;

function OpenCBMVDDInit: Integer;
var
  I             : Integer;
begin
  I := 0;
  if not VDDInitialized then
  begin
    asm
      push ds;
      pop es;
      mov si, Offset(DLLName[1]);
      mov di, Offset(InitFunc[1]);
      mov bx, Offset(DispFunc[1]);
      db $C4; db $C4; db $58; db $00; {RegisterModule}
      mov bx, 0;
      jnc @1;
      mov bx, ax;
      mov ax, vhInvalid;
  @1: mov VDDHandle, ax;
      mov I, bx;
    end;
    VDDInitialized := (I = 0);
  end;
  OpenCBMVDDInit := I;
end;

procedure OpenCBMVDDUninit;
begin
  if VDDInitialized then
  begin
    asm
      mov ax, VDDHandle;
      db $C4; db $C4; db $58; db $01; {UnregisterModule}
    end;
    VDDInitialized := False;
  end;
  VDDHandle := vhInvalid;
end;

procedure OpenCBMDispatchCall; assembler;
asm
    push bx;
    mov ax, VDDHandle;
    cmp ax, vhInvalid;
    je @1;
    mov bx, OpenCBMDriverHandle;
    cmp bx, ohInvalid;
    je @1;
    db $C4; db $C4; db $58; db $02; {DispatchCall}
    jmp @2;
@1: mov ax, -1;
@2: pop bx;
end;

function OpenCBMDriverOpen: Integer; assembler;
asm
    push bx;
    xor ax, ax;
    cmp OpenCBMDriverHandle, ohInvalid;
    jne @2;
    mov ax, VDDHandle;
    cmp ax, vhInvalid;
    je @1;
    mov dl, ocDriverOpen;
    mov dh, opDefault;
    db $C4; db $C4; db $58; db $02; {DispatchCall}
    test ax, ax;
    jne @2;
    mov OpenCBMDriverHandle, bx;
    jmp @2;
@1: mov ax, -1;
@2: pop bx;
end;

procedure OpenCBMDriverClose; assembler;
asm
    mov dl, ocDriverClose;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMuSleep; assembler;
asm
    mov dl, ocVDDuSleep;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMReset; assembler;
asm
    mov dl, ocReset;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMIECPoll; assembler;
asm
    mov dl, ocIECPoll;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMIECSet; assembler;
asm
    mov dl, ocIECSet;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMIECRelease; assembler;
asm
    mov dl, ocIECRelease;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMIECSetRelease; assembler;
asm
    mov dl, ocIECSetRelease;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMRawRead; assembler;
asm
    mov dl, ocRawRead;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMRawWrite; assembler;
asm
    mov dl, ocRawWrite;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMPPRead; assembler;
asm
    mov dl, ocPPRead;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMPPWrite; assembler;
asm
    mov cl, al;
    mov dl, ocPPWrite;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMGetEOI; assembler;
asm
    mov dl, ocGetEOI;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMClearEOI; assembler;
asm
    mov dl, ocClearEOI;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMListen; assembler;
asm
    and cl, $0F;
    mov dl, ocListen;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMTalk; assembler;
asm
    and cl, $0F;
    mov dl, ocTalk;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMUnlisten; assembler;
asm
    mov dl, ocUnlisten;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMUntalk; assembler;
asm
    mov dl, ocUntalk;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMOpen; assembler;
asm
    and cl, $0F;
    mov al, es:[si];
    xor ah, ah;
    mov di, ax;
    inc si;
    mov dl, ocOpen;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMClose; assembler;
asm
    and cl, $0F;
    mov dl, ocClose;
    call OpenCBMDispatchCall;
end;

procedure OpenCBMDeviceStatus; assembler;
asm
    mov dl, ocDeviceStatus;
    xor al, al;
    mov es:[si], al;
    inc si;
    push cx;
    push si;
    call OpenCBMDispatchCall;
    pop si;
    pop cx;
    push ax;
    mov bx, si;
@2: mov al, es:[si];
    test al, al;
    je @1;
    inc si;
    loop @2;
@1: mov ax, si;
    sub ax, bx;
    dec bx;
    mov es:[bx], al;
    pop ax;
end;

end.
