
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    PANEL1.PAS                   }
{                                                 }
{         The Star Commander panel unit #1        }
{*************************************************}

unit Panel1;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Dialogs, Drivers, Validate,
  Constant, Panel2;

type
  TExecExt      = record
    Ext         : TFileExtStr;
    OpSys       : Byte;
  end;
const
{Maximum number of executable types}
  ExecExtMax    = 5;
{Executable extensions}
  ExecExts      : array [0..ExecExtMax - 1] of TExecExt =
                  ((Ext: 'bat'; OpSys: osDOS),
                   (Ext: 'btm'; OpSys: os4DOS),
                   (Ext: 'cmd'; OpSys: osWindowsNT),
                   (Ext: 'com'; OpSys: osDOS),
                   (Ext: 'exe'; OpSys: osDOS));

type
{Panel}
  PPanel        = ^TPanel;
  TPanel        = object(TOldPanel)
    Other       : PPanel;
    procedure Prepare(const Name: string; DestImage, DestFile, SeeOther: Boolean);
    procedure GetFileData(Pos: Integer);
    function FindNextFile(ContRead, EmptyError, ReturnDel: Boolean): Boolean;
    function SeekToNextFile(var HeadPos: Longint): Boolean;
    function GetFileName(Title: string; const Text, Button: string; Check, Radio: PSItem; DestLabel,
      AskSrc, AskDest, PrepareDest, DestFile, IncSubdirs: Boolean; Extra, AskDestArch: Byte): Boolean;
    function SetSelectStatus(Pos: Integer; SelMode: Byte): Boolean;
    procedure Selection(Selector, All: Boolean);
    function CopyBackupFile(B: Boolean): Boolean;
    procedure SetSortOrder;
    function ReadDir(Errors, Force: Boolean): Integer;
    function LongNamesChanged: Boolean;
    procedure ReselectFiles(FixNames: Boolean);
    procedure Scan;
    procedure Rescan;
    procedure Read;
    procedure Reread;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Draw; virtual;
  end;
{File name input line}
  TNameInputLine= object(TInputLine)
    procedure InsertStr(S: string; Space, Merge: Boolean);
    function InsertName(Y: Integer; Long: Boolean): Boolean;
    procedure InsertPath(P: PPanel; Long: Boolean);
    procedure HandleEvent(var Event: TEvent); virtual;
  end;
  PNameInputLine= ^TNameInputLine;
{Command line}
  TCommandLine  = object(TNameInputLine)
    procedure CopyHistory;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Draw; virtual;
  end;
  PCommandLine  = ^TCommandLine;
{Disk image type selector radio buttons}
  TDiskImageButtons= object(TFuncButtons)
    NameInput   : PInputLine;
    procedure Press(Item: Integer; Keyboard: Boolean); virtual;
  end;
  PDiskImageButtons= ^TDiskImageButtons;
{Archive type selector radio buttons}
  TArchButtons  = object(TRadioButtons)
    NameInput   : PInputLine;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Press(Item: Integer; Keyboard: Boolean); virtual;
  end;
  PArchButtons  = ^TArchButtons;
{Archive name recognizer}
  TArchValid    = object(TValidator)
    TypeInput   : PRadioButtons;
    function IsValidInput(var S: string; SuppressFill: Boolean): Boolean; virtual;
  end;
  PArchValid    = ^TArchValid;
{Disk type selector radio buttons}
  TDiskButtons  = object(TRadioButtons)
    NameInput   : PInputLine;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Press(Item: Integer; Keyboard: Boolean); virtual;
  end;
  PDiskButtons  = ^TDiskButtons;
{Disk type name recognizer}
  TDiskValid    = object(TValidator)
    TypeInput   : PRadioButtons;
    function IsValidInput(var S: string; SuppressFill: Boolean): Boolean; virtual;
  end;
  PDiskValid    = ^TDiskValid;

var
  ContDirProcess,
  TurboOn,
  DefIncSubdirs,
  IncludeSubdirs,
  TempUncompOpen,
  TempInputOpen,
  TempOutputOpen,
  TempFileOpen  : Boolean;
  Left,
  Right,
  Act,
  Inact,
  TempPanel     : PPanel;
  CommandLine   : PCommandLine;

function CheckEvents: Boolean;
procedure RereadPanels;
function MakeCmdLine(const Pattern: string; Image, Convert, ForceShort: Boolean): string;
procedure PutCommand(const Command: string; ToHist: Boolean);
procedure PutCommands(Menu, AddPath, Image, Convert, ForceShort: Boolean);
procedure SelectFile(Select, All: Boolean);
procedure InvertSelection(CheckShift: Boolean);
procedure SaveSelection;
procedure RestoreSelection;
procedure LaunchEmu;
procedure PEnter(Panel: PPanel; QView, Rread, OnlyDirs: Boolean);
procedure FindNextUndel(Panel: PPanel);
procedure UnselectFile(Panel: PPanel; O: Boolean);

implementation

uses
  App, DOS, Objects, Views,
  Base1, Base2, Clipbrd, Config, DOSShell, ExtFiles, FWPrep, MiscFunc, LowLevel, XferLo;

{Check events and abort operation if there were any
  Output: when False, an event occurred}
function CheckEvents: Boolean;
var
  E             : TEvent;
  O             : Boolean;
begin
  Application^.GetEvent(E);
  O := ((E.What <> evMouseDown) and (E.What <> evKeyDown));
  if E.What <> evNothing then if O and (E.What <> evMouseAuto) then Application^.HandleEvent(E) else Application^.PutEvent(E);
  CheckEvents := O;
end;

{Indent the two parts of the DOS file name for displaying it as a directory
  entry in a panel
  Input : Name: the original file name
          Mark: special mark to put into file name, between name and
                extension; when #0, no mark is needed
          Width: the width to indent the name into
  Output: the indented file name}
function ConvertDOSName(const Name: string; Mark: Char; Width: Byte): string;
var
  P,
  X,
  Y,
  Z             : Byte;
  E,
  N             : string;
begin
  Y := 3;
  Z := 0;
  if Mark <> #0 then Inc(Z);
  case Width of
    0..3:
    begin
      Y := 0;
      Mark := #0;
      Z := 0;
    end;
    4..6: Y := Width - 3 - Z;
  end;
  X := Width - Y - Z;
  FillChar(N[1], Width, ' ');
  FillChar(E[1], Y, ' ');
  P := RightPos('.', Name);
  if (P <= 1) or (P = Length(Name)) then P := Length(Name) + 1;
  if P <= X + 1 then N := Copy(Name, 1, P - 1) else N := Copy(Name, 1, X - 1) + ArrowChars[2];
  if Length(Name) - P <= Y then E := Copy(Name, P + 1, Y) else E := Copy(Name, P + 1, Y - 1) + ArrowChars[2];
  N[0] := Chr(X);
  E[0] := Chr(Y);
  if Mark <> #0 then
  begin
    N[X + 1] := Mark;
    Inc(N[0]);
  end;
  ConvertDOSName := N + E;
end;

{Re-read the contens of both panels, if needed}
procedure RereadPanels;
begin
  if (Left = Act) or (Left^.Mode <> pmExt) then Left^.Read;
  if (Right = Act) or (Right^.Mode <> pmExt) then Right^.Read;
  ClockOn;
end;

{Extract the name and the attributes of the current file of a panel
  Input : Panel: the panel}
procedure ExtractCur(Panel: PPanel);
begin
  with Panel^ do
  begin
    CopyAttr := Dir[Cur].Attr;
    CopyName := ShortName(GetNamePtr(Cur)^, False);
  end;
end;

{Determine if an extension belongs to an executable file
  Input : Ext: the extension
  Output: when True, the extension is that of an executable file}
function IsExecExt(const Ext: string): Boolean;
var
  F             : Boolean;
  B             : Byte;
  S             : string;
begin
  B := 0;
  S := LowerCase(Ext);
  repeat
    F := (ExecExts[B].Ext = S) and ((ExecExts[B].OpSys = osDOS) or (OperatingSystem and ExecExts[B].OpSys <> 0));
    Inc(B);
  until (B >= ExecExtMax) or F;
  IsExecExt := F;
end;

{Determine whether some characters are present in a string
  Input : Chars: the characters to search for
          Str: the string to search inside
  Output: when True, one of the characters are present in the string}
function CharsInString(const Chars, Str: string): Boolean;
var
  F             : Boolean;
  B             : Byte;
begin
  F := False;
  B := 1;
  while not F and (B <= Length(Chars)) do
  begin
    F := (LeftPos(Chars[B], Str) > 0);
    Inc(B);
  end;
  CharsInString := F;
end;

{Determine whether there are invalid characters in a file name and if there
  are then enclose the file name intro quotation marks
  Input : Name: the file name}
procedure CheckInvalidChars(var Name: string);
begin
  if (Name <> '') and CharsInString(InvFileNameChars, Name) then
  begin
    if Name[1] <> '"' then Name := '"' + Name;
    if Name[Length(Name)] <> '"' then Name := Name + '"';
  end;
end;

{Create a command line, substituting special symbols
  Input : Pattern: string containing the original line
          Image: when True, additional symbols are recognized
          Convert: when True, PETSCII file names are converted to ASCII
          ForceShort: when True, symbols are always replaced with the short
                      name of files
  Output: string with special symbols substituted}
function MakeCmdLine(const Pattern: string; Image, Convert, ForceShort: Boolean): string;
var
  B,
  F,
  G             : Boolean;
  C,
  D             : Char;
  I,
  X             : Integer;
  P             : PPanel;
  E,
  N,
  O,
  S,
  T             : string;

{Insert a Commodore file name into the command line string, using hexadecimal
  codes for non-printable characters
  Input : Invert: when True, lowercase PETSCII characters are converted
                  to uppercase ASCII and vice versa, otherwise the case
                  is kept
          Convert: when True, PETSCII file names are converted to ASCII}
procedure InsertCBMName(Invert, Convert: Boolean);
var
  C             : Char;
  I             : Integer;
  B             : PBlock;
begin
  if Invert then B := @PETtoASCUpper else B := @PETtoASCLower;
  if P = Act then
  begin
    for I := 1 to Length(N) do
    begin
      C := N[I];
      if not Convert then
      begin
        case C of
          '_': C := ' ';
        end;
      end;
      if (C in ['!'..'#', '%'..';', '=', '?'..'Z', '[', ']']) or (not Invert and (C in [#$C1..#$DA])) then
      begin
        if not P^.GEOSFormat then
        begin
          if Convert then C := Chr(B^[Ord(C)]) else
            if Invert then C := InvertCase(C);
        end;
        S := S + C;
      end
      else
      begin
        S := S + HexaPrefix + HexaStr(Ord(C), 2);
      end;
    end;
  end;
end;

{Fetch the current file name from the panel}
procedure FetchName;
begin
  N := P^.GetNamePtr(P^.Cur)^;
end;

procedure MakePath;
begin
  F := True;
  T := Copy(AddToPath(P^.Path, stEmpty, chDirSep), 3, MaxStrLen);
  if G then CheckInvalidChars(T) else T := ShortName(T, True);
end;

begin
  I := 1;
  S := '';
  ExtractCur(Act);
  ExtractCur(Inact);
  while (I <= Length(Pattern)) do
  begin
    D := Pattern[I];
    Inc(I);
    if D in ['!', '%'] then
    begin
      if D = '!' then P := Act else P := Inact;
      B := ((I <= Length(Pattern)) and (Pattern[I] = '~'));
      if B then Inc(I);
      G := (B xor PreferLongNames) and not ForceShort;
      if I <= Length(Pattern) then C := Pattern[I] else C := #0;
      Inc(I);
      F := False;
      case C of
        ':':
        begin
          F := True;
          S := S + Copy(P^.Path, 1, 2);
        end;
        '\':
        begin
          MakePath;
          S := S + AddToPath(T, stEmpty, chDirSep);
        end;
        '/':
        begin
          if Image then
          begin
            F := True;
            N := P^.RealImagePath;
            if N <> '' then N := N + '/';
            InsertCBMName(False, Convert);
          end
          else
          begin
            MakePath;
            S := S + T;
          end;
        end;
        '#':
        begin
          if Image then
          begin
            F := True;
            S := S + LeadingSpace(P^.Cur - 1, 0);
          end;
        end;
        '^':
        begin
          if Image then
          begin
            F := True;
            FetchName;
            InsertCBMName(True, Convert);
          end;
        end;
        '@':
        begin
          if not Image then
          begin
            F := True;
            if P = Act then T := ActSelListFileName else T := InactSelListFileName;
            T := AddToPath(ListPath, T, chDirSep);
            S := S + T;
            if not P^.MakeListFile then
            begin
              P^.MakeListFile := True;
              GetClock(False);
              LongErase(T);
              X := IOResult;
              if P^.Vis and (LongOpenFile(T, WriteFile, fmWriteOnly) = 0) then
              begin
                if P^.SelNum = 0 then
                begin
                  T := P^.CopyName;
                  if not G then T := ShortName(T, False);
                  T := T + chCR + chLF;
                  ExtBlockWrite(WriteFile, T[1], Length(T));
                end
                else
                begin
                  for X := 0 to P^.Max - 1 do
                  begin
                    if P^.Dir[X].Status and fsProcessMask = fsSelected then
                    begin
                      T := P^.GetNamePtr(X)^;
                      if not G then T := ShortName(T, False);
                      T := T + chCR + chLF;
                      ExtBlockWrite(WriteFile, T[1], Length(T));
                    end;
                  end;
                end;
                ExtClose(WriteFile);
              end
              else
              begin
                Beep;
              end;
              SetClock;
            end;
          end;
        end;
      end;
      if not F then
      begin
        if C = D then
        begin
          if B then
          begin
            C := #0;
            Dec(I);
          end
          else
          begin
            S := S + C;
          end;
        end;
        if C <> D then
        begin
          if P = Act then O := SourceName else O := AddToPath(Inact^.Path, Inact^.CopyName, chDirSep);
          if not G then O := ShortName(O, True);
          LongFSplit(O, T, N, E);
          N := AddToPath(T, N, chDirSep);
          if (I <= Length(Pattern)) and (C = '.') and (Pattern[I] = D) then
          begin
            Inc(I);
            N := N + E;
            CheckInvalidChars(N);
            S := S + N;
          end
          else
          begin
            if C = '`' then
            begin
              E := Copy(E, 2, MaxStrLen);
              CheckInvalidChars(E);
              S := S + E;
            end
            else
            begin
              if Image then
              begin
                FetchName;
                InsertCBMName(False, Convert);
              end
              else
              begin
                CheckInvalidChars(N);
                S := S + N;
              end;
              if C <> #0 then S := S + C;
            end;
          end;
        end;
      end;
    end
    else
    begin
      S := S + D;
    end;
  end;
  MakeCmdLine := S;
end;

{Put a single command into the command buffer for a DOS shell
  Input : Command: DOS command to be put into the buffer
          ToHist: when True, the command is put into the history, as well}
procedure PutCommand(const Command: string; ToHist: Boolean);
var
  B             : Boolean;
  I,
  J             : Byte;
begin
  ShellBuffer^.CmdLen := Length(Command);
  if Length(Command) > 0 then
  begin
    Move(Command[1], ShellBuffer^.CmdBuffer^, Length(Command));
    if ToHist then
    begin
      I := ShellBuffer^.HistoryNum;
      B := (I = 0);
      if B then
      begin
        Inc(I);
      end
      else
      begin
        J := 0;
        while (J < I) and (ShellBuffer^.History[J] <> Command) do Inc(J);
        if J < I then
        begin
          if J < I - 1 then
          begin
            Move(ShellBuffer^.History[J + 1], ShellBuffer^.History[J], (I - J - 1) * (CmdLineLen + 1));
            B := True;
          end;
        end
        else
        begin
          if I < HistoryMax then Inc(I) else Move(ShellBuffer^.History[1], ShellBuffer^.History[0],
            (HistoryMax - 1) * (CmdLineLen + 1));
          B := True;
        end;
      end;
      if B then
      begin
        ShellBuffer^.History[I - 1] := Command;
        ShellBuffer^.HistoryNum := I;
      end;
    end;
  end;
end;

{Put a series of commands into the command buffer for a DOS shell
  Input : Menu: when True, a menu file is being parsed
          AddPath: when True and no path is specified in the command then
                   the executable is searched for in the current directory,
                   then the Commander home directory, then the PATH
          Image: when True, additional symbols are recognized
          Convert: when True, PETSCII file names are converted to ASCII
          ForceShort: when True, symbols are always replaced with the short
                      name of files}
procedure PutCommands(Menu, AddPath, Image, Convert, ForceShort: Boolean);
var
  B,
  F,
  O             : Boolean;
  I             : Integer;
  E,
  L,
  N,
  P,
  T             : string;
begin
  L := '';
  ShellBuffer^.CmdLen := 0;
  F := True;
  B := False;
  repeat
    if Menu then B := ParseMenu(L, False) else B := ParseExt(L, False);
    if F or not B then
    begin
      if F then
      begin
        if not Menu then
        begin
          B := NonEmptyLine(L);
          if B then
          begin
            if (L <> '') and (L[1] <> SuppressOutputPrefix) and (FileExt(CutPath(L, chDirSep)) <> '') and
              ((CopiedSize >= CopySize) or not (Chr(GCRBuffer[CopiedSize]) in WhiteSpace)) then
            begin
              LongFSplit(L, P, N, E);
              N := N + E;
              if (P = '') and AddPath then
              begin
                T := stCurrentDir + chPathSep + HomePath + chPathSep + GetEnv('PATH');
                F := False;
                while not F and (T <> '') do
                begin
                  I := LeftPos(chPathSep, T);
                  if I = 0 then I := Length(T) + 1;
                  P := Copy(T, 1, I - 1);
                  T := Copy(T, I + 1, MaxStrLen);
                  LongFindFirst(AddToPath(P, N, chDirSep), (Archive + ReadOnly + SysFile + Hidden), Act^.CopyEntry);
                  LongFindClose(Act^.CopyEntry);
                  F := (DOSError = 0);
                end;
                if not F then P := '';
                L := AddToPath(P, L, chDirSep);
              end;
              CheckInvalidChars(L);
              DestName := AddToPath(P, N, chDirSep);
              L := L + ' !.!';
              CommandOutput := coStandardCmd;
              AttachInfo := True;
            end;
          end;
        end;
        B := False;
        F := False;
      end;
      L := MakeCmdLine(L, Image, Convert, ForceShort);
      if L <> '' then
      begin
        L := L + chCR + chLF;
        if ShellBuffer^.CmdLen + Length(L) < CmdBufferLen then
        begin
          Move(L[1], ShellBuffer^.CmdBuffer^[ShellBuffer^.CmdLen], Length(L));
          Inc(ShellBuffer^.CmdLen, Length(L));
        end
        else
        begin
          B := True;
        end;
      end;
    end;
  until B or (CopiedSize >= CopySize);
end;

{'Select' item in the 'Files' menu: select/unselect files using a wildcard
  pattern
  Input : Select: when True, file are selected, otherwise unselected}
procedure SelectFile(Select, All: Boolean);
begin
  ChangeHelpCtx(hcSelectFile);
  Act^.Selection(Select, All);
  RestoreHelpCtx;
end;

{'Invert selection' in the 'Files' menu: invert the selection of the
  files
  Input : CheckShift: when True, the state of the Shift key is pressed and,
                      if so, directories are included in the inversion, too}
procedure InvertSelection(CheckShift: Boolean);
var
  O             : Boolean;
  I,
  M             : Integer;
begin
  O := CheckShift and IsShiftPressed;
  if Act^.Mode = pmDOS then
  begin
    if Length(Act^.Path) = 3 then M := 0 else M := 1;
    for I := M to Act^.Max - 1 do if O or (Act^.Dir[I].Attr and Directory = 0) then Act^.SetSelectStatus(I, smInvertSel);
  end
  else
  begin
    if Act^.Mode = pmExt then M := 0 else M := 1;
    for I := M to Act^.Max - 1 do if ((Act^.Dir[I].Attr and faTypeMask in [faDeleted..faRelative]) or
      ((Act^.Dir[I].Attr and faTypeMask = faFrozen) and (Act^.Mode = pmTape))) then Act^.SetSelectStatus(I, smInvertSel);
  end;
  Act^.DrawPanel;
end;

{Save the selection of all selected files before a group file operation}
procedure SaveSelection;
var
  B             : Byte;
  I             : Integer;
begin
  if Act^.Max > 0 then
  begin
    for I := 0 to Act^.Max - 1 do
    begin
      B := Act^.Dir[I].Status;
      if B and fsProcessMask = fsSelected then Act^.Dir[I].Status := (B and fsProcessMask) or fsWasSelected else
        Act^.Dir[I].Status := (B and fsProcessMask);
    end;
  end;
end;

{'Restore selection' in the 'Files' menu: restore the selection of the
  previously selected files}
procedure RestoreSelection;
var
  B             : Byte;
  I             : Integer;
begin
  if Act^.Max > 0 then
  begin
    for I := 0 to Act^.Max - 1 do
    begin
      B := Act^.Dir[I].Status;
      if B and fsStatusMask = fsWasSelected then Act^.Dir[I].Status := (B and fsStatusMask) or fsSelected else
        Act^.Dir[I].Status := B and fsStatusMask;
    end;
    Act^.DrawPanel;
  end;
end;

{Launch an emulator or other external program when Enter was pressed or a
  double-click was made on a file inside an image or archive file}
procedure LaunchEmu;
var
  F             : Boolean;
  I             : Integer;
  C             : Longint;
  A             : PHistoryItem;
  S,
  L             : string;
begin
  ChangeHelpCtx(hcLaunchEmu);
  if not (Act^.Mode in [pmDOS, pmExt]) then
  begin
    if ReadUserFile(ImageMenuFileName, False, False, hcHelp) = 0 then
    begin
      S := Act^.ImageName;
      ClockOn;
      if FindPattern(S, True, F) then
      begin
        if ConstructMenu(I, A, True, True) then
        begin
          L := 'Launch Menu';
          ForceUserTitle(L);
          DisplayUserMenu(L, I, 0, 0, mtMenu, A, nil, False, True);
          if HistoryItem >= 0 then
          begin
            C := CopiedSize;
            if not ParseMenu(L, False) then
            begin
              CopiedSize := C;
              SourceName := Act^.ImageName;
              PutCommands(False, False, True, not GetPanelModeAttrib(Act^.Mode, paASCII), True);
              SingleCommand := False;
              ClearCommand := True;
              PopupMenu := False;
              EnterDOSShell;
            end;
          end;
        end;
      end;
    end;
  end;
  RestoreHelpCtx;
end;

{Enter the directory or image file under the cursor bar, or execute the
  file or the commands associated with it
  Input : Panel: the panel to enter the directory or file in
          QView: when True, the inactive panel is being set to display
                     the current image or archive file in the active panel
          Rread: when True, the panel is reread in Quick view mode
          OnlyDirs: when True, only directories are entered}
procedure PEnter(Panel: PPanel; QView, Rread, OnlyDirs: Boolean);
var
  F             : Boolean;
  B             : Byte;
  I             : Integer;
  C             : Longint;
  A             : PHistoryItem;
  P             : PPanel;
  S,
  L             : string;
begin
  with Panel^ do
  begin
    if Max > 0 then
    begin
      if Mode = pmDOS then
      begin
        if Dir[Cur].Attr and Directory > 0 then
        begin
          if QView then
          begin
            Other^.QuickView := qvDirCount;
            Other^.Read;
          end
          else
          begin
            if GetNamePtr(Cur)^ = stParentDir then
            begin
              SplitPath(Path, S);
              LongChDir(Path);
              SelNum := 0;
              ListNum := 0;
              Working := True;
              Top := '';
              Under := S;
              Read;
            end
            else
            begin
              S := Path;
              Path := AddToPath(Path, GetNamePtr(Cur)^, chDirSep);
              LongChDir(Path);
              if IOResult = 0 then Reread else Path := S;
            end;
          end;
        end
        else
        begin
          B := 0;
          ChangeHelpCtx(hcExtEdit);
          if not OnlyDirs and not QView then
          begin
            SourceName := GetNamePtr(Cur)^;
            I := ReadUserFile(ExtensionFileName, False, False, hcHelp);
            if I = 0 then
            begin
              ClockOn;
              if ConstructMenu(I, A, False, False) then
              begin
                L := 'Associations';
                ForceUserTitle(L);
                DisplayUserMenu(L, I, 20, 0, mtExtension, A, nil, False, False);
                if HistoryItem >= 0 then
                begin
                  C := CopiedSize;
                  if not ParseExt(L, False) then
                  begin
                    CopiedSize := C;
                    Inc(B);
                    PutCommands(False, False, False, False, False);
                    SingleCommand := False;
                    ClearCommand := True;
                    PopupMenu := False;
                    EnterDOSShell;
                  end;
                end;
              end;
            end;
          end;
          RestoreHelpCtx;
          if B = 0 then
          begin
            B := pmDOS;
            S := GetNamePtr(Cur)^;
            if not OnlyDirs and not QView and IsExecExt(FileExt(S)) then
            begin
              PutCommand(S, True);
              SingleCommand := True;
              ClearCommand := True;
              PopupMenu := False;
              EnterDOSShell;
            end
            else
            begin
              B := DetermineTypeName(S);
            end;
            if B = pmDOS then
            begin
              if QView then
              begin
                Other^.ShutQuickView;
                Other^.DrawView;
              end;
            end
            else
            begin
              if QView then
              begin
                P := Inact;
                Other^.Path := Path;
              end
              else
              begin
                P := Act;
              end;
              if (P^.NewMode <> B) or QView or (P^.ImageName <> S) or Rread then
              begin
                if P^.QuickView <> qvNone then P^.QuickView := qvNormal;
                P^.NewMode := B;
                P^.ImageName := S;
                P^.RealImagePath := '';
                P^.Reread;
              end
              else
              begin
                P^.Changing := False;
              end;
              P^.DrawPanel;
            end;
          end;
        end;
      end
      else
      begin
        if not QView then
        begin
          if (Cur = 0) and (Mode <> pmExt) then
          begin
            if RealImagePath = '' then
            begin
              ShutImageMode;
              SelNum := 0;
              Read;
            end
            else
            begin
              SelNum := 0;
              Working := True;
              Top := '';
              Under := CutPath(RealImagePath, DirSep);
              RealImagePath := GetPath(RealImagePath, DirSep);
              Read;
            end;
          end
          else
          begin
            if (Dir[Cur].Attr and faTypeMask = faPartition) and (GetPanelModeAttrib(Mode, paDirectories) or
              ((Mode in [pmExt, pmDisk]) and (DiskType and dtTypeMask = dt1581) and
              (Dir[Cur].ExtAttr and xaDirectory > 0))) then
            begin
              S := GetNamePtr(Cur)^;
              F := True;
              if Mode = pmExt then
              begin
                OpenCBMChannel(saCommand, '/0:' + S, True);
                F := ReadCBMError(L, True, False, True);
                B := Dir[Cur].Track;
                DirTrack := B;
                FirstTrack := DirTrack;
                LastTrack := FirstTrack + (LonglongintToLongint(Dir[Cur].Size) div SectorNum(B));
              end;
              if F then RealImagePath := AddToPath(RealImagePath, S, DirSep);
              Reread;
            end
            else
            begin
              if not OnlyDirs then LaunchEmu;
            end;
          end;
        end;
      end;
      if not QView and (Other^.QuickView <> qvNone) and (Mode = pmDOS) then PEnter(Panel, True, False, False);
    end
    else
    begin
      if QView then Other^.ShutQuickView;
    end;
  end;
end;

{Mark the current file as deleted and find the next file that is not yet
  deleted during group file delete; also, when not deleting in a disk or
  disk image, decrease by one the directory position of all entries that
  are physically after the current file in the container
  Input : Panel: the panel to search in}
procedure FindNextUndel(Panel: PPanel);
var
  I             : Integer;
  P             : Word;
begin
  if (CopyFileMode in [cfSelected, cfSingle]) and (Panel = Act) and (CopyFileNum < Panel^.Max) then
  begin
    Panel^.Dir[CopyFileNum].Status := fsDeleted;
    P := Panel^.Dir[CopyFileNum].DirPos;
    if Panel^.NewCur = CopyFileNum then
    begin
      repeat
        Inc(Panel^.NewCur);
      until (Panel^.NewCur = Panel^.Max) or (CopyFileMode = cfWildcard) or (Panel^.Dir[Panel^.NewCur].Status <> fsDeleted);
      if Panel^.NewCur = Panel^.Max then
      begin
        repeat
          Dec(Panel^.NewCur);
        until (Panel^.NewCur = 0) or (CopyFileMode = cfWildcard) or (Panel^.Dir[Panel^.NewCur].Status <> fsDeleted);
      end;
    end;
    if not (Panel^.CopyMode in [pmExt, pmDisk]) then
    begin
      for I := 0 to Panel^.Max - 1 do if Panel^.Dir[I].DirPos > P then Dec(Panel^.Dir[I].DirPos);
      Dec(Panel^.CopyDirPos);
    end;
  end;
end;

{Unselect the currently processed file or directory in the panel
  Input : Panel: the panel holding the processed file or directory
          O: when True, the file or directory was successfully processed}
procedure UnselectFile(Panel: PPanel; O: Boolean);
var
  B             : Byte;
begin
  if (Panel = Act) and (CopyFileMode = cfSelected) and (Panel^.SelNum > 0) and (CopyFileNum < Panel^.Max) then
  begin
    if O then
    begin
      B := Panel^.Dir[CopyFileNum].Status;
      if B and fsProcessMask = fsSelected then Panel^.Dir[CopyFileNum].Status := (B and fsStatusMask) or fsProcessed;
      Panel^.DrawView;
    end
    else
    begin
      Inc(CopyFileNum);
    end;
  end;
end;

{Prepare paths, file names and cloning patterns for file copy
  Input : Name: original file name
          DestImage: when True, the last two parts of the path are the name of an
                 image file and the destination file inside
          DestFile: when True, the last part of the path is a file name and not
                    a directory name
          SeeOther: when False, the copy mode of the panel is derived from its
                    own current mode; otherwise from that of the opposite panel}
procedure TPanel.Prepare(const Name: string; DestImage, DestFile, SeeOther: Boolean);
var
  Q             : Boolean;
  A,
  C             : Byte;
  E,
  N,
  P,
  S             : string;
  X             : PPanel;

procedure CorrectImagePath;
var
  T             : string;

procedure CheckImage;
begin
  CorrectImageName(True);
  if OpenImage(False, True, True, True, False) = 0 then CloseImage(False);
end;

begin
  if not (CopyMode in [pmDOS, pmExt, pmFile]) then
  begin
    T := CopyRealImagePath;
    CopyRealImagePath := '';
    CorrectImageName(True);
    CopyFullName := AddToPath(CopyPath, CopyImageName, chDirSep);
    if Compressing then
    begin
      CorrectImageName(True);
    end
    else
    begin
      MakeDirSep;
      if (Length(CopyPath) > 1) and (CopyPath[Length(CopyPath) - 1] <> ':') and
        (CopyPath[Length(CopyPath)] = chDirSep) then Dec(CopyPath[0]);
      Q := FileExists(CopyPath, True);
      if Q then
      begin
        CopyRealImagePath := T;
      end
      else
      begin
        while not Q do
        begin
          CheckImage;
          if (CopyMode = pmDisk) or GetPanelModeAttrib(CopyMode, paDirectories) then
          begin
            T := CopyImageProtoName;
            if CopyMode = pmDisk then T := ReconvertCBMName(T, CopyGEOSFormat, True, hxPercent);
            CopyRealImagePath := AddToPath(T, CopyRealImagePath, DirSep);
            if (CopyRealImagePath <> '') and (CopyRealImagePath[Length(CopyRealImagePath)] = DirSep) then
              Dec(CopyRealImagePath[0]);
          end
          else
          begin
            NamePattern := ReconvertCBMName(OrigNamePattern, CopyGEOSFormat, False, hxPercent);
          end;
          CopyName := CloneName(CopyName, NamePattern, True, True);
          CopyImageProtoName := CutPath(CopyPath, chDirSep);
          CopyPath := GetPath(CopyPath, chDirSep);
          if (Length(CopyPath) > 3) and (CopyPath[Length(CopyPath)] = chDirSep) then Dec(CopyPath[0]);
          Q := FileExists(CopyPath, True) or ((Length(CopyPath) = 2) and (CopyPath[2] = ':'))
            or ((Length(CopyPath) = 3) and (CopyPath[2] = ':') and (CopyPath[3] = chDirSep));
        end;
        T := CopyRealImagePath;
      end;
      CopyRealPath := CopyPath;
      CheckImage;
      if CopyRealImagePath <> T then NamePattern := CutPath(T, DirSep);
      CopyImagePath := CopyRealImagePath;
    end;
  end;
end;

begin
  ClockOff;
  S := Name;
  SameAsPanel := (((@Self = Act) or (DestArchType = pmDOS)) and ((Mode = pmDOS) or
    (S <> (stCurrentDir + chDirSep))) and (S <> (stParentDir + chDirSep)) and (LeftPos(':', S) = 0)
    and (LeftPos(chDirSep, S) = 0));
  FirstFile := True;
  FirstCopyFile := True;
  OnlyPath := False;
  CopyRealImagePath := '';
  if DestImage or DestFile then
  begin
    C := LeftPos(':', S);
    P := '';
    if C > 0 then P := UpperCase(Copy(S, 1, C - 1));
    if SeeOther and SameAsPanel then
    begin
      if CopyFileMode = cfAutomatic then CopyMode := Other^.CopyMode else CopyMode := Other^.Mode;
      CopyCBMDev := Other^.CopyCBMDev;
    end
    else
    begin
      if not SameAsPanel and (@Self = Inact) then
      begin
        if DestArchType = pmFile then
        begin
          CopyMode := pmFile;
        end
        else
        begin
          CopyMode := pmDOS;
          CopyImageProtoName := '';
        end;
      end
      else
      begin
        if (LeftPos(':', S) > 0) or (LeftPos(chDirSep, S) > 0) then CopyMode := pmDOS else CopyMode := Mode;
      end;
    end;
    A := DetermineTypePrefix(S);
    if A = pmExt then
    begin
      CopyCBMDev := Ord(S[1]) - Ord('0');
      if CopyCBMDev < 2 then Inc(CopyCBMDev, 10);
      CopyPath := Copy(GetPath(S, chDirSep), 1, 2);
      NamePattern := ReconvertCBMName(CutPath(S, chDirSep), False, False, hxPercent);
      if NamePattern = '' then NamePattern := stAllFilesUnix;
    end;
    if A <> pmDOS then CopyMode := A;
    if CopyMode in [pmDisk, pmTape, pmFile, pmLynx..pmFileZip, pmGCRDisk..pmSixZip] then S := Copy(S, C + 1, MaxStrLen);
    if CopyMode = pmDOS then
    begin
      if SeeOther and SameAsPanel and (CopyFileMode = cfAutomatic) then
      begin
        CopyPath := Other^.CopyPath;
        NamePattern := S;
      end
      else
      begin
        if DestFile then
        begin
          if S[Length(S)] in [':', chDirSep] then OnlyPath := True else S := S + chDirSep;
          S := S + stAllFilesDOS;
        end
        else
        begin
          if (S = stCurrentDir) or (S = stParentDir) then S := S + chDirSep;
          if S[Length(S)] = chDirSep then S := S + stAllFilesDOS;
        end;
        LongFSplit(S, P, N, E);
        NamePattern := N + E;
        A := 1;
        if (Length(P) >= 2) and (P[2] = ':') and (UpCase(P[1]) in ['A'..'Z']) then
        begin
          P[1] := UpCase(P[1]);
          A := 3;
        end;
        if (Length(P) > A) and (P[Length(P)] = chDirSep) then Dec(P[0]);
        CopyPath := P;
        MakeRealPath;
      end;
    end
    else
    begin
      if SameAsPanel then
      begin
        X := @Self;
        if SeeOther then X := Other;
        if CopyFileMode = cfAutomatic then
        begin
          SameAsPanel := False;
          CopyPath := X^.CopyPath;
          CopyImageProtoName := X^.CopyImageName;
          CopyRealImagePath := X^.CopyRealImagePath;
          if not GetPanelModeAttrib(CopyMode, paASCII) then S := ReconvertCBMName(S, X^.CopyGEOSFormat, False, hxPercent);
        end
        else
        begin
          CopyPath := X^.Path;
          CopyImageProtoName := X^.ImageName;
          CopyRealImagePath := X^.RealImagePath;
          if not GetPanelModeAttrib(CopyMode, paASCII) then S := ReconvertCBMName(S, X^.GEOSFormat, False, hxPercent);
        end;
        NamePattern := S;
      end
      else
      begin
        case CopyMode of
          pmDisk, pmTape, pmLynx..pmFileZip, pmGCRDisk..pmSixZip:
          begin
            if DestImage then
            begin
              if S[Length(S)] = chDirSep then
              begin
                OnlyPath := True;
                Dec(S[0]);
                SplitPath(S, N);
                NamePattern := stAllFilesUnix;
              end
              else
              begin
                SplitPath(S, N);
                if not GetPanelModeAttrib(CopyMode, paASCII) then N := ReconvertCBMName(N, False, False, hxPercent);
                NamePattern := N;
                SplitPath(S, N);
              end;
              CopyPath := S;
              CopyImageProtoName := N;
            end
            else
            begin
              if S[Length(S)] = chDirSep then
              begin
                OnlyPath := True;
                Dec(S[0]);
                SplitPath(S, N);
              end
              else
              begin
                SplitPath(S, N);
              end;
              CopyPath := S;
              CopyImageProtoName := N;
              OrigNamePattern := N;
              NamePattern := stAllFilesUnix;
            end;
          end;
          pmFile:
          begin
            CopyMode := pmDOS;
            CopyPath := S;
            NamePattern := stAllFilesUnix;
            if (@Self = Act) then CopyExtractFileImages := xfAlways else CopyIntoFileImages := ifAlways;
          end;
        end;
      end;
    end;
    Wildcard := ((LeftPos('*', NamePattern) > 0) or (LeftPos('?', NamePattern) > 0));
    CorrectImagePath;
  end
  else
  begin
    CopyMode := Mode;
    CopyPath := '';
    CopyImageProtoName := ImageName;
    CopyRealImagePath := RealImagePath;
    NamePattern := '';
    CorrectImageName(True);
    MakeRealPath;
  end;
  CopyName := NamePattern;
{!!!  CopyImageProtoName := RemoveQuotes(CopyImageProtoName);}
  CopyPath := RemoveQuotes(CopyPath);
{!!!  if CopyMode = pmDOS then CopyName := RemoveQuotes(CopyName);}
end;

{Get the file name and directory position of a file
  Input : the position of the file in the panel}
procedure TPanel.GetFileData(Pos: Integer);
begin
  CopyName := GetNamePtr(Pos)^;
  CopyDirPos := Dir[Pos].DirPos;
end;

{Find the next file that matches the selection pattern
  Input : ContRead: when True, entries are returned continuously, without
                    opening and closing the source between them
          EmptyError: when True, an error message is displayed if the
                      directory is empty
          ReturnDel: when True, deleted entries are also returned
  Output: when True, a matching file was found}
function TPanel.FindNextFile(ContRead, EmptyError, ReturnDel: Boolean): Boolean;
var
  B,
  F,
  O,
  Q             : Boolean;
  A             : Word;
  S             : string[20];
  T             : string;

{Extract the entry of the next file to be processed}
procedure ExtractEntry;
begin
  if O then
  begin
    CopyAttr := Dir[CopyFileNum].Attr;
    CopyExtAttr := Dir[CopyFileNum].ExtAttr;
    CopySize := LonglongintToLongint(Dir[CopyFileNum].Size);
    CopyName := GetNamePtr(CopyFileNum)^;
    if GetPanelModeAttrib(CopyMode, paASCII) then
    begin
      CopyFullName := CopyName;
    end
    else
    begin
      if CopyMode in [pmDisk, pmExt] then
      begin
        Track := Dir[CopyFileNum].Track;
        Sector := Dir[CopyFileNum].Sector;
        SideTrack := Dir[CopyFileNum].SideTrack;
        SideSector := Dir[CopyFileNum].SideSector;
        CopyRecordLen := Dir[CopyFileNum].RecordLen;
      end;
      CopyFullName := MakeCBMName(CopyName, CopyGEOSFormat);
      A := Dir[CopyFileNum].Name;
    end;
    CopyDirPos := Dir[CopyFileNum].DirPos;
  end;
end;

begin
  ShellBuffer^.OrigFirstFile := FirstFile;
  ShellBuffer^.OrigCopyDirPos := CopyDirPos;
  B := SysErrorOccurred;
  SysErrorOccurred := False;
  O := True;
  S := 'Can''t find the file';
  if Wildcard then S := S + 's';
  Track := 0;
  Sector := 0;
  Q := (CopyFileMode in [cfSelected, cfSingle]);
  if ((CopyFileMode = cfSelected) and (SelNum = 0)) or (CopyFileMode = cfSingle) then
  begin
    CopyFileNum := Cur;
    O := FirstFile;
    ExtractEntry;
  end
  else
  begin
    if CopyFileMode = cfSelected then
    begin
      while (CopyFileNum < Max) and (Dir[CopyFileNum].Status and fsProcessMask <> fsSelected) do Inc(CopyFileNum);
      O := (CopyFileNum < Max);
      ExtractEntry;
    end;
  end;
  if O and (ContRead or not Q) then
  begin
    if CopyMode = pmDOS then
    begin
      if FirstFile then
      begin
        A := Archive + ReadOnly + SysFile + Hidden;
        if DirNameGiven or IncludeSubdirs then Inc(A, Directory);
        if DirNameGiven then T := NamePattern else T := stAllFilesDOS;
        LongFindFirst(AddToPath(CopyPath, T, chDirSep), A, CopyEntry);
        while (DOSError = 0) and ((CopyEntry.LongName = stCurrentDir) or (CopyEntry.LongName = stParentDir)) do
          LongFindNext(CopyEntry);
        while (DOSError = 0) and (CopyEntry.Orig.Attr and Directory = 0) and not ListCompareDOSEntry(NamePattern,
          CopyEntry.LongName, LongFileNames, False) do LongFindNext(CopyEntry);
        if DOSError <> 0 then
        begin
          O := False;
          if not IncludeSubdirs then ErrorWin(stEmpty, S, AddToPath(CopyPath, NamePattern, chDirSep), CurHelpCtx, sbNone);
        end;
      end
      else
      begin
        LongFindNext(CopyEntry);
        while (DOSError = 0) and (CopyEntry.Orig.Attr and Directory = 0) and not ListCompareDOSEntry(NamePattern,
          CopyEntry.LongName, LongFileNames, False) do LongFindNext(CopyEntry);
        if DOSError <> 0 then O := False;
      end;
      if not O then LongFindClose(CopyEntry);
      CopyName := CopyEntry.LongName;
      CopyFullName := AddToPath(CopyPath, CopyName, chDirSep);
      LongGetFAttr(CopyFullName, A);
      CopyAttr := A;
      CopySize := LonglongintToLongint(CopyEntry.LongSize);
    end
    else
    begin
      if ContRead or (OpenImage(False, False, True, True, True) = 0) then
      begin
        F := True;
        if not ContRead and not FirstFile then while CopyDirPos <> DirPos do F := ReadCBMEntry(Entry);
        if F then
        begin
          F := False;
          while not F and ReadCBMEntry(Entry) do
          begin
            if ReturnDel or (Entry.Attr <> 0) then
            begin
              if Q then F := (DirPos = CopyDirPos) else
                F := ListCompareCBMEntry(NamePattern, Entry.Name, Entry.Attr, False);
            end;
          end;
        end;
        if SameAsPanel then
        begin
          CopyFullName := '';
        end
        else
        begin
          if CopyMode = pmExt then CopyFullName := CopyPath else if GetPanelModeAttrib(CopyMode, (paImage + paArchive)) then
            CopyFullName := MakeTypeStr(CopyMode) + ':' + AddToPath(CopyPath, CopyImageName, chDirSep) + chDirSep;
        end;
        if F then
        begin
          CopyName := Entry.Name;
          if GetPanelModeAttrib(CopyMode, paASCII) then CopyFullName := CopyFullName + CopyName else
            CopyFullName := CopyFullName + MakeCBMName(CopyName, CopyGEOSFormat);
          CopyAttr := Entry.Attr;
          CopyExtAttr := Entry.ExtAttr;
          CopyDirPos := DirPos;
        end
        else
        begin
          if FirstFile and EmptyError then ErrorWin(stEmpty, S, CopyFullName + MakeCBMName(NamePattern, CopyGEOSFormat),
            CurHelpCtx, sbNone);
          O := False;
        end;
        if not ContRead then CloseImage(False);
      end
      else
      begin
        if (CopyMode <> pmExt) and not SysErrorOccurred then ContProcess := ErrorWin(stEmpty, 'Can''t open the ' +
          MakeFullTypeStr(CopyMode), AddToPath(CopyPath, CopyImageName, chDirSep), CurHelpCtx, sbNone);
        O := False;
      end;
      if not ContRead and (CopyMode = pmExt) then
      begin
        O := ReadCBMError(S, False, False, True);
        if not O then ContProcess := ErrorWin(stError, S, stEmpty, CurHelpCtx, sbSkip);
        if not F then O := False;
      end;
    end;
  end;
  FirstFile := False;
  SysErrorOccurred := B;
  FindNextFile := O;
end;

{Move the directory pointer to the next file to be processed
  Input : HeadPos: the long integer to hold the header position of the file
          before the file being searched for
  Output: when True, the file has been found}
function TPanel.SeekToNextFile(var HeadPos: Longint): Boolean;
var
  B,
  O             : Boolean;

procedure ReadNextEntry;
begin
  HeadPos := HeaderPos;
  B := ReadCBMEntry(Entry);
  O := B and (Entry.Attr > 0) and (Entry.Name = CopyName);
end;

begin
  ReadNextEntry;
  while B and (((@Self = Act) and (DirPos < CopyDirPos))) or ((@Self <> Act) and not O) do ReadNextEntry;
  SeekToNextFile := O;
end;

{Multi-purpose file name input routine
  Input : Title: title for the dialog box
          Text: text to be displayed in the first line of the box
          Button: the title of the function button displayed at the
                  bottom of the box
          Check: when not nil, a list of checkbox items displayed between
                 the input lines and the buttons
          Radio: when not nil, a list of radio button items displayed
                 between the input lines and the buttons
          DestLabel: when True, an empty destination file name is actually a
                     disk or tape label, therefore an empty value is accepted
          AskSrc: when True, the source file name is input
          AskDest: when True, the destination file name is input
          PrepareDest: when True, the destination file name is taken apart
                       into its components
          DestFile: when True, the destination file name is always assumed
                    to be a file name, otherwise it also may be a path or
                    an image or archive file
          IncSubDirs: when True, a check box is present to toggle the
                      processing of subdirectories
          Extra: the type of the extra entry; 0, if none is displayed
          AskDestArch: controls whether to ask the destination archive
                       format
  Output: when False, the user cancelled the file name input}
function TPanel.GetFileName(Title: string; const Text, Button: string; Check, Radio: PSItem; DestLabel,
  AskSrc, AskDest, PrepareDest, DestFile, IncSubdirs: Boolean; Extra, AskDestArch: Byte): Boolean;
var
  F             : Boolean;
  C,
  E,
  K             : Word;
  I,
  U,
  W,
  X,
  Y,
  Z             : Integer;
  D             : PDialog;
  I1,
  I2            : PNameInputLine;
  I3            : PNumInput;
  I4            : PCheckBoxes;
  I5,
  I6            : PRadioButtons;
  V1            : PNumValid;
  V2            : PValidator;
  A,
  B,
  P             : PSItem;
  S             : string;
  R             : TRect;
begin
  InOutRes := 0;
  P := nil;
  if Title = '' then Title := BoxTitle;
  case AskDestArch of
    aaDiskImage:
    begin
      Radio := NewSItem('1541, 35 tracks',
        NewSItem('1571, 70 tracks',
        NewSItem('1581, 80 tracks',
        NewSItem('1541 extended, 40 tracks',
        nil))));
      GetRadioData := Byte(ExtendedDisk) * dt1541Ext;
    end;
    aaArchive:
    begin
      Check := NewSItem('Delete files afterwards', nil);
      GetCheckData := Byte(MoveFiles);
      Radio := NewSItem('No compression (file copy)',
        NewSItem('Lynx',
        NewSItem('Filepacked ZipCode',
        NewSItem('LHA',
        NewSItem('Arkive',
        NewSItem('TAR',
        NewSItem('ZIP',
        nil)))))));
      GetRadioData := ShellBuffer^.DestArchType;
    end;
    aaDiskCopy:
    begin
      Radio := NewSItem('Full disk copy',
        NewSItem('BAM disk copy',
        NewSItem('Safe BAM disk copy',
        NewSItem('Manual selection', nil))));
      P := NewSItem('No format conversion',
        NewSItem('Commodore disk',
        NewSItem('Disk image',
        NewSItem('GCR-coded disk image',
        NewSItem('Diskpacked ZipCode',
        NewSItem('Sixpacked ZipCode',
        nil))))));
      K := ShellBuffer^.DestArchType;
    end;
  end;
  if IncSubDirs then
  begin
    Check := NewSItem('Include subdirectories', Check);
    GetCheckData := GetCheckData shl 1 or Byte(DefIncSubdirs);
  end;
  F := False;
  X := 0;
  U := 0;
  if AskSrc then Y := 2 else Y := 0;
  if AskDest then Inc(Y, 2);
  if Extra <> eeNone then Inc(Y, 2);
  if (Check <> nil) or (P <> nil) then
  begin
    W := Y;
    X := 1;
    A := Check;
    B := P;
    while (A <> nil) or (B <> nil) do
    begin
      if A <> nil then A := A^.Next;
      if B <> nil then B := B^.Next;
      Inc(X);
    end;
    Inc(Y, X);
  end;
  if Radio <> nil then
  begin
    Z := Y;
    U := 1;
    A := Radio;
    while A <> nil do
    begin
      A := A^.Next;
      Inc(U);
    end;
    Inc(Y, U);
  end;
  if Button <> '' then Inc(Y, 2);
  MakeWinBounds(R, 66, Y);
  GetClock(True);
  GetMouse(True);
  D := New(PDialog, Init(R, Title, fxNormal, fyNormal, True));
  if AskSrc then
  begin
    Y := 5;
    R.Assign(5, 2, 64, 1);
    D^.Insert(New(PCBMText, Init(R, Text)));
    R.Assign(5, 3, 64, 1);
    I1 := New(PNameInputLine, Init(R, 64, MaxFileNameLen, stEmpty, drNone));
    I1^.SetData(SourceName);
    D^.Insert(I1);
    if AskDest then
    begin
      if DestLabel then
      begin
        R.Assign(5, 4, 14, 1);
        D^.Insert(New(PStaticText, Init(R, 'with the label')));
      end
      else
      begin
        R.Assign(5, 4, 2, 1);
        D^.Insert(New(PStaticText, Init(R, 'to')));
      end;
    end;
  end
  else
  begin
    Y := 3;
    R.Assign(5, 2, 64, 1);
    D^.Insert(New(PCBMText, Init(R, Text)));
  end;
  if AskDest then
  begin
    R.Assign(5, Y, 64, 1);
    I2 := New(PNameInputLine, Init(R, 64, MaxFileNameLen, stEmpty, drNone));
    I2^.SetData(DestName);
    D^.Insert(I2);
  end;
  if Extra <> eeNone then
  begin
    case Extra of
      eeMakeTape:
      begin
        C := 1;
        E := MaxTapeDirSize;
        S := 'entries';
      end;
      eeDiskImageDir:
      begin
        C := MinDiskDirSize;
        if ImagePath = '' then E := MaxTrack shr 1 else E := LastTrack - FirstTrack - 1;
        S := 'tracks';
      end;
    end;
    S := 'number of ' + S;
    V1 := New(PNumValid, Init(C, E, stEmpty, S, CurHelpCtx));
    S := S + ':';
    S[1] := UpCase(S[1]);
    R.Assign(5, Y + 1, 64, 2);
    I3 := New(PNumInput, Init(R, 64, 3, S, drUp));
    I3^.SetValidator(V1);
    case Extra of
      eeMakeTape: C := TapeDirSize;
      eeDiskImageDir: C := DiskDirSize;
    end;
    S := LeadingSpace(C, 0);
    I3^.SetData(S);
    D^.Insert(I3);
    Inc(Y, 2);
  end;
  if Check <> nil then
  begin
    C := 0;
    if P <> nil then
    begin
      A := Check;
      while A <> nil do
      begin
        if C < CStrLen(A^.Value^) then C := CStrLen(A^.Value^);
        A := A^.Next;
      end;
    end;
    Inc(C, 5);
    R.Assign(3, W + 2, 68, 1);
    D^.Insert(New(PSeparator, Init(R)));
    R.Assign(5, W + 3, 69 - C, X - 1);
    I4 := New(PCheckBoxes, Init(R, Check));
    I4^.SetData(GetCheckData);
    D^.Insert(I4);
  end;
  if Radio <> nil then
  begin
    R.Assign(3, Z + 2, 68, 1);
    D^.Insert(New(PSeparator, Init(R)));
    R.Assign(5, Z + 3, 64, U - 1);
    case AskDestArch of
      aaDiskImage: I5 := New(PDiskImageButtons, Init(R, Radio, cmDisk1541, cmDisk1541Ext));
      aaArchive: I5 := New(PArchButtons, Init(R, Radio));
      aaDiskCopy: I5 := New(PFuncButtons, Init(R, Radio, cmDiskCopyMode, cmDiskCopyMode));
    else
      I5 := New(PRadioButtons, Init(R, Radio));
    end;
    I5^.SetData(GetRadioData);
    D^.Insert(I5);
  end;
  if P <> nil then
  begin
    R.Assign(C + 9, W + 3, 60 - C, X - 1);
    if AskDestArch = aaDiskCopy then I6 := New(PDiskButtons, Init(R, P));
    I6^.SetData(K);
    D^.Insert(I6);
  end;
  case AskDestArch of
    aaDiskImage: PDiskImageButtons(I5)^.NameInput := I1;
    aaArchive:
    begin
      V2 := New(PArchValid, Init);
      PArchValid(V2)^.TypeInput := I5;
      I2^.SetValidator(V2);
      PArchButtons(I5)^.NameInput := I2;
    end;
    aaDiskCopy:
    begin
      V2 := New(PDiskValid, Init);
      PDiskValid(V2)^.TypeInput := I6;
      I2^.SetValidator(V2);
      PDiskButtons(I6)^.NameInput := I2;
      PDiskValid(V2)^.IsValidInput(DestName, False);
    end;
  end;
  if Button <> '' then
  begin
    R.Assign(3, Y + U + X + 1, 68, 1);
    D^.Insert(New(PSeparator, Init(R)));
    R.Assign(33 + CStrLen(Button) shr 1, Y + U + X + 2, 10, 1);
    D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'C'+ColorChar+'ancel ]', cmCancel)));
    R.Assign(31 - CStrLen(Button) shr 1, Y + U + X + 2, CStrLen(Button), 1);
    D^.Insert(New(PButton, Init(R, Button, cmOK)));
  end;
  if AskSrc then
  begin
    I1^.MakeFirst;
    I1^.Select;
  end
  else
  begin
    if AskDest then
    begin
      I2^.MakeFirst;
      I2^.Select;
    end;
  end;
  case ExecMode of
    exOpenRead, exCloseWrite: C := cmOK;
  else
    C := Application^.ExecView(D, True, True);
  end;
  if C = cmOK then
  begin
    if AskSrc then I1^.GetData(SourceName);
    if AskDest then I2^.GetData(DestName);
    if (not AskSrc or (SourceName <> '')) and (not AskDest or DestLabel or (DestName <> '')) then
    begin
      if Check <> nil then
      begin
        I4^.GetData(GetCheckData);
        if IncSubDirs then
        begin
          DefIncSubdirs := (GetCheckData and 1 > 0);
          GetCheckData := GetCheckData shr 1;
        end;
        if AskDestArch = aaArchive then MoveFiles := (GetCheckData and 1 > 0);
      end;
      if Radio <> nil then
      begin
        I5^.GetData(GetRadioData);
        case AskDestArch of
          aaDiskImage: CopyDiskType := GetRadioData;
          aaArchive: DestArchType := GetRadioData;
        end;
      end;
      F := True;
      Prepare(SourceName, (CopyFileMode = cfWildcard), False, False);
      if (CopyMode in [pmDisk, pmTape, pmLynx, pmFileZip]) and (CopyImageName = '') then F := False;
      if AskDest and PrepareDest and not DestLabel then Other^.Prepare(DestName, DestFile, not DestFile, not DestFile);
      if GetPanelModeAttrib(Act^.CopyMode, paExternalArch) and (ExecMode = exNormal) then ShellBuffer^.SourceOK := False;
      if Extra <> eeNone then
      begin
        I3^.GetData(S);
        Val(S, C, Y);
        case Extra of
          eeMakeTape: TapeDirSize := C;
          eeDiskImageDir: DiskDirSize := C;
        end;
      end;
    end;
  end;
  Dispose(D, Done);
  GetFileName := (F and (IOResult = 0));
  SetMouse;
  SetClock;
end;

{Set the selection status of a directory entry
  Input : Pos: the position of the directory entry
          SelMode: when 0, the entry is selected; when 1, the entry is
                   unselected; when 2, the selection status is inverted
  Output: when True, the selection status was changed successfully}
function TPanel.SetSelectStatus(Pos: Integer; SelMode: Byte): Boolean;
var
  O             : Boolean;
  A,
  B             : Byte;
  P             : PByte;
begin
  O := False;
  if Max > 0 then
  begin
    A := Dir[Pos].Attr;
    if Mode = pmDOS then
    begin
      O := ((Length(Path) = 3) or (Pos > 0))
    end
    else
    begin
      if (Mode = pmExt) or GetPanelModeAttrib(Mode, (paImage + paArchive)) then
      begin
        A := A and faTypeMask;
        O := (((Mode = pmExt) or (Pos > 0)) and ((A in [faDeleted..faRelative]) or ((A = faFrozen) and (Mode = pmTape))));
      end;
    end;
    if O then
    begin
      A := Dir[Pos].Status;
      B := A and fsProcessMask;
      A := A and fsStatusMask;
      if (SelMode = smSelect) or ((SelMode = smInvertSel) and (B = 0)) then A := A or fsSelected;
      Dir[Pos].Status := A;
    end;
  end;
  SetSelectStatus := O;
end;

{Select and unselect files using a wildcard pattern
  Input : Selector: when True, files are selected, otherwise unselected
          All: when True, all files are selected or unselected}
procedure TPanel.Selection(Selector, All: Boolean);
var
  F,
  O             : Boolean;
  B             : Byte;
  C             : Word;
  J,
  M,
  X             : Integer;
  D             : PDialog;
  I             : PInputLine;
  T,
  U             : string[20];
  S             : string;
  R             : TRect;
begin
  ChangeHelpCtx(hcSelectFile);
  D := nil;
  F := False;
  O := False;
  B := GetShiftState;
  if B and (kbRightShift + kbLeftShift) > 0 then O := True;
  if All or (B and kbCtrlShift > 0) then
  begin
    C := cmYes;
  end
  else
  begin
    if Mode = pmDOS then S := DOSPattern else S := CBMPattern;
    if Selector then T := 'Select' else T := 'Unselect';
    U := '';
    if (Mode = pmDOS) and (O or not Selector) then U := ' and directories';
    X := Length(T) + Length(U) + 10;
    if X < 32 then X := 32;
    MakeWinBounds(R, X + 2, 2);
    D := New(PDialog, Init(R, T, fxNormal, fyNormal, False));
    X := Length(T) + Length(U) + 10;
    if X < 32 then X := 32;
    R.Assign(5, 2, X, 2);
    I := New(PNameInputLine, Init(R, 32, MaxStrLen, T + ' the files' + U, drUp));
    I^.SetData(S);
    D^.Insert(I);
    C := Application^.ExecView(D, True, True);
  end;
  if (C = cmOK) or (C = cmYes) then
  begin
    if C = cmYes then
    begin
      if Mode = pmDOS then S := stAllFilesDOS else S := stAllFilesUnix;
    end
    else
    begin
      I^.GetData(S);
      if Mode = pmDOS then DOSPattern := S else CBMPattern := S;
    end;
    if Selector then B := smSelect else B := smUnselect;
    if Mode = pmDOS then
    begin
      S := UpperCase(S);
      if Length(Path) = 3 then M := 0 else M := 1;
      for J := M to Max - 1 do
      begin
        if (O or (Dir[J].Attr and Directory = 0) or not Selector) and
          ListCompareDOSEntry(S, GetNamePtr(J)^, LongFileNames, False) then
        begin
          F := True;
          SetSelectStatus(J, B);
        end;
      end;
    end
    else
    begin
      if GEOSFormat then S := UpperCase(S) else S := ReconvertCBMName(S, False, True, hxPercent);
      if Mode = pmExt then M := 0 else M := 1;
      for J := M to Max - 1 do
      begin
        if (Dir[J].Attr and faTypeMask in [faDeleted..faRelative]) and
          ListCompareCBMEntry(S, GetNamePtr(J)^, Dir[J].Attr, False) then
        begin
          F := True;
          SetSelectStatus(J, B);
        end;
      end;
    end;
    DrawPanel;
  end;
  if D <> nil then
  begin
    Dispose(D, Done);
    if not F and (C = cmOK) then
    begin
      MakeSound := False;
      if Mode = pmDOS then S := DOSPattern else S := CBMPattern;
      ErrorWin(T, 'Could not find a match', '"' + S + '"', hcSelectFile, sbNone);
    end;
  end;
  RestoreHelpCtx;
end;

{Create a backup of the image file
  Input : B: when True, original file data is copied into the backup file
  Output: when False, an error occured}
function TPanel.CopyBackupFile(B: Boolean): Boolean;
var
  O             : Boolean;
  A             : Word;
  I             : Integer;
  S             : string;
begin
  O := True;
  if not BackupDone and MakeBackup and (CopyMode in [pmDisk, pmTape]) then
  begin
    BackupDone := True;
    BackupName := MakeFileExt(CopyImageName, 'bak');
    S := AddToPath(CopyPath, BackupName, chDirSep);
    LongGetFAttr(S, A);
    I := IOResult;
    if A and (ReadOnly + Directory) > 0 then
    begin
      O := False;
    end
    else
    begin
      I := LongOpenFile(AddToPath(CopyPath, CopyImageName, chDirSep), TempFile, fmReadOnly);
      if I = 0 then
      begin
        ExtGetFTime(TempFile, ReadTime);
        if not ImageReadOnly and (LongOpenFile(MakeTempName, WriteFile, fmWriteOnly) = 0) then
        begin
          TempFileOpen := True;
          if B then CopyPart(TempFile, WriteFile, ExtFileSize(TempFile), TBufferSize);
          if KeepTime then ExtSetFTime(WriteFile, ReadTime);
          ExtClose(WriteFile);
          O := (IOResult = 0);
          if FileExists(S, False) then LongErase(S);
          I := IOResult;
        end;
        ExtClose(TempFile);
        if O then
        begin
          LongRename(TempFile.LongName, AddToPath(CopyPath, BackupName, chDirSep));
          LongRename(WriteFile.LongName, AddToPath(CopyPath, CopyImageName, chDirSep));
        end;
      end;
    end;
    if not O then ContProcess := ErrorWin(stEmpty, 'Can''t make the backup file',
      AddToPath(CopyPath, BackupName, chDirSep), hcHelp, sbNone);
  end;
  CopyBackupFile := O;
end;

{Mark the menu items assigned to the current sort order}
procedure TPanel.SetSortOrder;
var
  I,
  J             : Byte;
  C             : Char;
  T             : TCommandSet;
begin
  J := GetSortMode;
  for I := 0 to 4 do SortMenu[I]^.Name^[1] := CheckChr[I = J];
  SortMenu[5]^.Name^[1] := CheckChr[(J <> psUnsorted) and GetReverseMode];
  if @Self = Left then T := [cmLeftReverse] else T := [cmRightReverse];
  if J = psUnsorted then MenuBar^.DisableCommands(T) else MenuBar^.EnableCommands(T);
end;

{Read the directory of the panel
  Input : Errors: when True, errors are displayed
          Force: when True, reading the panel directory is forced
  Output: when not 0, an error occured}
function TPanel.ReadDir(Errors, Force: Boolean): Integer;
var
  F,
  G,
  O             : Boolean;
  A,
  M             : Byte;
  C             : Char;
  U,
  V,
  X,
  Z             : Word;
  I,
  W,
  Y             : Integer;
  L             : Longint;
  S,
  T             : string;
  E             : TDirEntry;
  H             : ExtFreeSpaceRec;
  Entry         : ExtSearchRec;

{Fetch the volume label of the DOS disk, omitting LFN entries (volume label
  plus hidden plus system flags all set)
  Input : Path: the path pointing onto the DOS disk}
procedure GetVolumeLabel(var Path: string);
begin
  F := False;
  FindFirst(Copy(Path, 1, 3) + stAllFilesDOS, VolumeId, Entry.Orig);
  while (DOSError = 0) and not F do
  begin
    if (Entry.Orig.Attr and VolumeId > 0) and (Entry.Orig.Attr and (SysFile + Hidden) = 0) then
    begin
      CopyLabel := CutChar(ConvertDOSName(Entry.Orig.Name, #0, 11), ' ');
      F := True;
    end
    else
    begin
      FindNext(Entry.Orig);
    end;
  end;
end;

procedure InsertEntry;
begin
  W := InsName(E.Name);
  if W >= 0 then
  begin
    Dir[Z].Name := W;
    Dir[Z].ExtAttr := E.ExtAttr;
    Dir[Z].Attr := E.Attr;
    Dir[Z].Status := fsNormal;
    Dir[Z].DirPos := DirPos;
    LongintToLonglongint(Dir[Z].Size, E.Size);
    Dir[Z].Time := E.Time;
    Dir[Z].RecordLen := E.RecordLen;
    Inc(Z);
  end;
end;

{Create a false parent directory entry if none was read}
procedure MakeUpDir;
begin
  with Dir[0] do
  begin
    Name := InsName(stParentDir);
    Attr := Directory;
    LongintToLonglongint(Size, 0);
    Time := 0;
    Status := fsNormal;
  end;
  Inc(Z);
end;

{Determine if the file is a PC archive file
  Output: when True, the file is a PC archive file}
function IsPCArchive: Boolean;
begin
  IsPCArchive := (DetermineTypeName(Entry.LongName) in [pmLHA, pmTAR, pmZIP]) or
    ((T = 'ace') or (T = 'arc') or (T = 'arj') or (T = 'pak') or (T = 'rar') or (T = 'zoo') or
    ((T[1] in ['a', 'c', 'r']) and (T[2] in ['0'..'9']) and (T[3] in ['0'..'9'])));
end;

{Determine if the file is a Commodore image file
  Output: when True, the file is a Commodore image file}
function IsCBMImage: Boolean;
begin
  IsCBMImage := (DetermineTypeName(Entry.LongName) in [pmDisk, pmGCRDisk, pmTape, pmFile]);
end;

{Determine if the file is a Commodore archive file
  Output: when True, the file is a Commodore archive file}
function IsCBMArchive: Boolean;
begin
  IsCBMArchive := (DetermineTypeName(Entry.LongName) in [pmLynx, pmArkive, pmLHA, pmDiskZip, pmFileZip, pmSixZip]);
end;

{Count the number of files and directories, total disk space allocated by
  the files without and with taking cluster size into account plus the cluster
  size itself
  Output : when False, an event occurred and the counting should be aborted}
function CountDir: Boolean;
var
  O             : Boolean;
  W             : Word;
  L             : Longlongint;
  E             : ExtSearchRec;

{Get the first file entry from the current directory; has to be a procedure
  external to "CountDir" so that stack usage is minimized upon each recursion}
procedure GetFirstFile;
begin
  LongFindFirst(AddToPath(CopyImagePath, stAllFilesDOS, chDirSep), (Archive + ReadOnly + SysFile + Hidden + Directory), E);
end;

{Enter the current subdirectory; has to be a procedure external to "CountDir"
  so that stack usage is minimized upon each recursion}
procedure EnterDir;
begin
  CopyImagePath := AddToPath(CopyImagePath, E.LongName, chDirSep);
end;

{Leave the current subdirectory; has to be a procedure external to "CountDir"
  so that stack usage is minimized upon each recursion}
procedure LeaveDir;
begin
  CopyImagePath := GetPath(CopyImagePath, chDirSep);
end;

begin
  O := CheckEvents;
  if O then GetFirstFile;
  while O and (DOSError = 0) do
  begin
    if E.Orig.Attr and Directory = 0 then
    begin
      Inc(FilesCount);
      W := DivLonglongintByWord(L, E.LongSize, ClusterSize);
      if W > 0 then IncLonglongint(L, 1);
      MulLonglongintByLongint(L, L, ClusterSize);
      AddLonglongint(FilesSize, FilesSize, E.LongSize);
      AddLonglongint(FilesSizeReal, FilesSizeReal, L);
    end
    else
    begin
      if (E.LongName <> stCurrentDir) and (E.LongName <> stParentDir) then
      begin
        Inc(DirsCount);
        EnterDir;
        O := CountDir;
        LeaveDir;
      end;
    end;
    O := O and CheckEvents;
    if O then LongFindNext(E);
  end;
  LongFindClose(E);
  CountDir := O;
end;

begin
  if BatchMode = bmNone then AllErrorSkip := ayNone;
  ClockOff;
  CopyLabel := '';
  TapeName := '';
  BackupDone := False;
  Error := False;
  Success := False;
  CopyPath := '';
  CopyRealImagePath := RealImagePath;
  CopyImagePath := '';
  CopyRealPath := Path;
  CopyImageName := ImageName;
  CopyCBMDev := CBMDev;
  I := IOResult;
  I := 0;
  F := False;
  CopyMode := Mode;
  if CopyMode <> NewMode then
  begin
    M := Mode;
    CopyMode := NewMode;
    F := True;
  end;
  T := MakeFullTypeStr(CopyMode);
  DirFull := False;
  SysErrorOccurred := False;
  Z := 0;
  if QuickView = qvDirCount then
  begin
    if (Other^.Max > 0) and (Other^.Mode = pmDOS) and (Other^.Dir[Other^.Cur].Attr and Directory > 0) then
    begin
      S := Other^.GetNamePtr(Other^.Cur)^;
      if S = stParentDir then S := Other^.Path else S := AddToPath(Other^.Path, S, chDirSep);
      if (ImagePath <> S) or Force then
      begin
        ImagePath := S;
        CopyImagePath := ImagePath;
        QuickView := qvDirCount;
        ClusterSize := Other^.ClusterSize;
        OK := True;
        Loading := True;
        DrawView;
        FilesCount := 0;
        DirsCount := 0;
        LongintToLonglongint(FilesSize, 0);
        LongintToLonglongint(FilesSizeReal, 0);
        OK := CountDir;
      end;
      CopyImagePath := ImagePath;
    end
    else
    begin
      ShutQuickView;
    end;
  end
  else
  begin
    case CopyMode of
      pmDOS:
      begin
        LongDiskSpace(H, Path[1]);
        L := H.BytePerSec * H.SecPerClus;
        ClusterSize := L;
        LongintToLonglongint(_DiskFree, H.FreeClus);
        LongintToLonglongint(_DiskSize, H.TotalClus);
        I := 0;
        if MiniStatus and 3 = msFull then
        begin
          I := 253;
          LongDiskFree(CopyFree, Path[1]);
          if LonglongintToLongint(CopyFree) >= 0 then
          begin
            GetVolumeLabel(Path);
            I := 0;
          end;
        end;
        if I = 0 then
        begin
          G := False;
          repeat
            LongFindFirst(AddToPath(Path, stAllFilesDOS, chDirSep),
              (Archive + ReadOnly + SysFile + Hidden + Directory), Entry);
            if SysErrorOccurred then
            begin
              I := 252;
            end
            else
            begin
              if DOSError = dePathNotFound then
              begin
                if Length(Path) > 3 then Path := GetPath(Path, chDirSep) else Path := Other^.Path;
                ListNum := 0;
                SelNum := 0;
                LongFindClose(Entry);
              end
              else
              begin
                G := True;
              end;
            end;
          until G or (I <> 0);
          if I = 0 then
          begin
            NameEnd := 0;
            while (Z < MaxFiles) and (NameEnd < SizeOf(TNameBuffer)) and (DOSError = 0) do
            begin
              if (Entry.LongName <> stCurrentDir) and (not Archiving or ((Entry.LongName[1] <> '~') or
                ((Entry.LongName <> ArcTempUncomp) and (Entry.LongName <> ArcTempInput) and
                (Entry.LongName <> ArcTempOutput) and (Entry.LongName <> TempFileName)))) then
              begin
                if (Length(Path) > 3) and (Z = 0) and (Entry.LongName <> stParentDir) then MakeUpDir;
                T := LowerCase(FileExt(Entry.LongName));
                O := ((Length(Path) > 3) or (Entry.LongName <> stParentDir)) and (HiddenFiles or (Entry.Orig.Attr and
                  (Hidden + SysFile) = 0));
                if O and (Entry.Orig.Attr and Directory = 0) and (FileFilter <> pfAll) then
                begin
                  O := ((FileFilter and pfPCProgs > 0) and IsExecExt(T))
                    or ((FileFilter and pfPCArchives > 0) and IsPCArchive)
                    or ((FileFilter and pfCBMImages > 0) and IsCBMImage)
                    or ((FileFilter and pfCBMArchives > 0) and IsCBMArchive);
                end;
                if O then
                begin
                  Y := InsName(Entry.LongName);
                  if Y >= 0 then
                  begin
                    Dir[Z].Name := Y;
                    Dir[Z].Attr := Entry.Orig.Attr;
                    Dir[Z].Time := Entry.Orig.Time;
                    if Entry.Orig.Attr and Directory > 0 then LongintToLonglongint(Dir[Z].Size, 0) else
                      Dir[Z].Size := Entry.LongSize;
                    Dir[Z].Status := fsNormal;
                    Inc(Z);
                  end;
                end;
              end;
              LongFindNext(Entry);
            end;
            if DOSError = 0 then
            begin
              LongFindNext(Entry);
              DirFull := (DOSError = 0);
            end;
            LongFindClose(Entry);
            if (Length(Path) > 3) and (Z = 0) then MakeUpDir;
            OK := True;
          end;
        end;
      end;
      pmExt:
      begin
        MouseOff;
        I := OpenImage(False, False, True, True, True);
        if I = 0 then
        begin
          LongintToLonglongint(_DiskSize, CopyDiskSize);
          DiskType := CopyDiskType;
          GEOSFormat := CopyGEOSFormat;
          MaxTrack := CopyMaxTrack;
          NameEnd := 0;
          Status := Status and not ssEOF;
          while (Status and not ssEOF = 0) and (Z < DirLength) and (NameEnd < SizeOf(TNameBuffer)) and ReadCBMEntry(E) do
            if E.Attr > 0 then InsertEntry;
          CloseImage(False);
        end;
        O := True;
        if Status > 0 then
        begin
          O := ReadCBMError(S, True, True, True);
          if not O then ErrorWin(stError, S, stEmpty, hcHelp, sbSkip);
        end;
        OK := (O and (I = 0));
        I := 0;
      end;
      pmInfo:
      begin
        if Other^.Mode = pmDOS then
        begin
          ClusterSize := Other^.ClusterSize;
          if ClusterSize = MaxWord then
          begin
            LongintToLonglongint(_DiskSize, 0);
            LongintToLonglongint(_DiskFree, 0);
            CopyLabel := '';
          end
          else
          begin
            MulLonglongintByLongint(_DiskFree, Other^._DiskFree, Other^.ClusterSize);
            MulLonglongintByLongint(_DiskSize, Other^._DiskSize, Other^.ClusterSize);
            GetVolumeLabel(Other^.Path);
          end;
        end
        else
        begin
          case Other^.Mode of
            pmExt, pmDisk:
            begin
              ClusterSize := 254;
              MulLonglongintByLongint(_DiskSize, Other^._DiskSize, 254);
              MulLonglongintByLongint(_DiskFree, Other^.CopyFree, 254);
            end;
            pmTape:
            begin
              ClusterSize := 1;
              LongintToLonglongint(_DiskSize, 0);
              for Y := 1 to Other^.Max - 1 do AddLonglongint(_DiskSize, _DiskSize, Other^.Dir[Y].Size);
              LongintToLonglongint(_DiskFree, Other^.ImageSize + 2 - LonglongintToLongint(Other^._Free));
            end;
            pmFile:
            begin
              ClusterSize := 1;
              _DiskSize := Other^.Dir[1].Size;
              LongintToLonglongint(_DiskFree, 0);
            end;
            pmLynx..pmFileZip:
            begin
              ClusterSize := 1;
              LongintToLonglongint(_DiskSize, 0);
              if Other^.Mode = pmFileZip then
                for Y := 1 to Other^.Max - 1 do IncLonglongint(_DiskSize, LonglongintToLongint(Other^.Dir[Y].Size) * 254) else
                for Y := 1 to Other^.Max - 1 do AddLonglongint(_DiskSize, _DiskSize, Other^.Dir[Y].Size);
              LongintToLonglongint(_DiskFree, 0);
            end;
          end;
          CopyLabel := Other^._Label;
        end;
        OK := True;
      end;
    else
      I := OpenImage(False, False, True, True, True);
      if I = 0 then
      begin
        ImageSize := CopyImageSize;
        LongintToLonglongint(_DiskSize, CopyDiskSize);
        DiskType := CopyDiskType;
        GEOSFormat := CopyGEOSFormat;
        MaxTrack := CopyMaxTrack;
        case CopyMode of
          pmTape, pmLynx..pmFileZip: DirLength := MaxFiles - 1;
          pmFile: DirLength := 1;
        end;
        Z := 1;
        NameEnd := 0;
        Dir[0].Name := InsName(stParentDir);
        LongintToLonglongint(Dir[0].Size, 0);
        Dir[0].ExtAttr := xaDirectory;
        Dir[0].Attr := (faPartition + faClosed);
        Dir[0].Status := fsNormal;
        while (Z <= DirLength) and (NameEnd < SizeOf(TNameBuffer)) and ReadCBMEntry(E) do
        begin
          case CopyMode of
            pmTape: if Z > 1 then LongintToLonglongint(Dir[Z - 1].Size, ImagePos - LonglongintToLongint(Dir[Z - 1].Size) + 2);
            pmTAR..pmZIP:
            begin
              A := E.Attr;
              if Z > 0 then
              begin
                Y := 0;
                while (A > 0) and (Y < Z) do if GetNamePtr(Y)^ = E.Name then A := 0 else Inc(Y);
                E.Attr := A;
              end;
              if A > 0 then Inc(ImageSize);
            end;
          end;
          case CopyMode of
            pmLynx, pmArkive, pmTAR:
            begin
              if StartInfo and (E.Size >= 2) then
              begin
                ExtSeek(Image, ImagePos);
                ExtBlockRead(Image, E.Start, 2);
              end;
            end;
          end;
          if E.Attr > 0 then InsertEntry;
        end;
        if (CopyMode = pmTape) and (Z > 1) then
          LongintToLonglongint(Dir[Z - 1].Size, ImagePos - LonglongintToLongint(Dir[Z - 1].Size) + 2);
        DirFull := (Z >= MaxFiles);
        if Error then
        begin
          if QuickView <> qvNone then
          begin
            I := 252;
          end
          else
          begin
            Error := False;
            if Errors then ErrorWin(stError, stTheFollowing + T + ' is broken.', ImageName, CurHelpCtx, sbNone);
          end;
        end;
        CloseImage(False);
        OK := True;
      end
      else
      begin
        if F then CopyMode := M;
        if I = 255 then ExtClose(Image);
        if QuickView = qvNone then
        begin
          case I of
            2, 3: ;
            255: if Errors then ErrorWin(stError, stTheFollowing + T + stIsInvalid + stDot, ImageName, hcHelp, sbNone);
          else
            if Errors then ErrorWin(stError, 'Can''t open the ' + T, ImageName, hcHelp, sbNone);
          end;
        end;
        OK := False;
      end;
    end;
  end;
  if I = 0 then
  begin
    if (@Self = Act) and not (CopyMode in [pmExt, pmInfo]) then
    begin
      CurPath := Path;
      CommandLine^.DrawView;
    end;
  end
  else
  begin
    if F then CopyMode := M;
  end;
  ImagePath := CopyImagePath;
  MustRead := False;
  MustReread := False;
  NewMode := CopyMode;
  Mode := CopyMode;
  if not OK then Z := 0;
  Max := Z;
  Changing := False;
  if (QuickView <> qvNone) and (I <> 0) then ShutQuickView;
  _Free := CopyFree;
  if Mode = pmFile then _Label := '' else _Label := CopyLabel;
  Success := (I = 0);
  LongNamesList := LongNames;
  SetPanelSize;
  ReadDir := I;
end;

{Determine if the status of long file names has been changed and update panel
  data, if needed
  Output: when True, long file names have been switched on or off since the
          last read of panel data}
function TPanel.LongNamesChanged: Boolean;
var
  L,
  O             : Boolean;
  S             : string;

{Update a file or path name
  Input : Name: the file or path name to update
          PathName: if True, the name is that of a path}
procedure UpdateName(var Name: string; PathName: Boolean);
begin
  if PathName then S := AddToPath(Name, stEmpty, chDirSep) else S := AddToPath(Path, Name, chDirSep);
  if L then Name := LongName(S, PathName) else Name := ShortName(S, PathName);
end;

begin
  O := (LongNamesList <> LongNames);
  if O then
  begin
    L := LongNames;
    LongNames := True;
    UpdateName(Path, True);
    if Mode = pmDOS then UpdateName(Under, False);
    if not (Mode in [pmDOS, pmExt]) then UpdateName(ImageName, False);
    LongNames := L;
  end;
  LongNamesChanged := O and (Mode = pmDOS);
end;

{Reselect the files, that were selected before, after having re-read the
  directory
  Input : FixNames: when True, long file names have been switched on or
                    off, therefore conversion has to take place}
procedure TPanel.ReselectFiles(FixNames: Boolean);
var
  L             : Boolean;
  I,
  Y             : Integer;
  P             : PString;
  S             : string;
begin
  if ListNum > 0 then
  begin
    L := LongNames;
    LongNames := True;
    for I := 0 to Max - 1 do
    begin
      P := GetNamePtr(I);
      if FixNames then
      begin
        S := AddToPath(Path, P^, chDirSep);
        if Dir[I].Attr and Directory > 0 then S := AddToPath(S, stEmpty, chDirSep);
        if L then S := ShortName(S, False) else S := LongName(S, False);
        P := @S;
      end;
      Y := 0;
      while not (UpperCase(P^) = UpperCase(GetListPtr(Y)^)) and (Y < ListNum) do Inc(Y);
      if Y < ListNum then Dir[I].Status := List[Y].Status;
    end;
    LongNames := L;
  end;
end;

{Read the directory of the panel, change back to DOS mode on any error
  and re-select files that were previously selected}
procedure TPanel.Scan;
var
  O             : Boolean;
  M             : Byte;
  I             : Integer;
begin
  ErrorDown := 0;
  M := NewMode;
  Loading := True;
  Changing := True;
  DrawView;
  O := LongNamesChanged;
  if QuickView = qvEmpty then ShutQuickView else I := ReadDir(False, False);
  if QuickView <> qvNone then I := 0;
  if I = 0 then
  begin
    ReselectFiles(O);
    SortDirectory;
    SearchName;
  end
  else
  begin
    if GetPanelModeAttrib(M, (paImage + paArchive)) then
    begin
      ShutImageMode;
      Scan;
      SortDirectory;
    end;
  end;
  SetSortOrder;
  SetModeMenu;
  Loading := False;
  MouseOn;
  ClockOn;
end;

{Re-read the directory of the panel and change back to DOS mode on any
  error}
procedure TPanel.Rescan;
var
  M             : Byte;
  I             : Integer;
begin
  LongNamesChanged;
  begin
    ErrorDown := 0;
    M := NewMode;
    Loading := True;
    Changing := True;
    DrawView;
    if QuickView = qvEmpty then ShutQuickView else I := ReadDir(True, True);
    if QuickView <> qvNone then I := 0;
    if Mode <> pmInfo then
    begin
      if I = 0 then
      begin
        SelNum := 0;
        ListNum := 0;
        Cur := 0;
        DeltaY := 0;
      end
      else
      begin
        if GetPanelModeAttrib(M, (paImage + paArchive)) then
        begin
          ShutImageMode;
          Scan;
        end;
      end;
    end;
    SetSortOrder;
    SetModeMenu;
    SortDirectory;
    Loading := False;
    MouseOn;
    ClockOn;
  end;
end;

{Read the directory of the panel, if visible}
procedure TPanel.Read;
begin
  if (QuickView in [qvNone, qvDirCount]) or (Mode = pmDOS) or (ImageName <> '') then
  begin
    MustRead := True;
    MustReread := False;
    if Vis then
    begin
      Scan;
      DrawPanel;
      if Other^.Mode = pmInfo then Other^.Reread
        else if (@Self = Act) and (Other^.QuickView <> qvNone) then PEnter(Act, True, False, False);
      OutOfMem;
    end
    else
    begin
      Changing := True;
      Mode := NewMode;
      if (@Self = Act) and not (Mode in [pmExt, pmInfo]) then
      begin
        CurPath := Path;
        CommandLine^.DrawView;
      end;
      ClockOn;
    end;
  end;
end;

{Re-read the directory of the panel, if visible}
procedure TPanel.Reread;
var
  O             : Boolean;
begin
  if (QuickView in [qvNone, qvDirCount]) or (Mode = pmDOS) or (ImageName <> '') then
  begin
    MustRead := True;
    MustReread := True;
    if Vis then
    begin
      Rescan;
      DrawPanel;
      if Other^.Mode = pmInfo then Other^.Reread
        else if (@Self = Act) and (Other^.QuickView <> qvNone) then PEnter(Act, True, False, False);
      OutOfMem;
    end
    else
    begin
      Changing := True;
      Mode := NewMode;
      if (@Self = Act) and not (Mode in [pmExt, pmInfo]) then
      begin
        CurPath := Path;
        CommandLine^.DrawView;
      end;
      ClockOn;
    end;
  end;
end;

function GetShiftFlag: Boolean;
var
  B             : Boolean;
begin
  B := IsShiftPressed;
  if PreferLongNames then B := not B;
  GetShiftFlag := B;
end;

{Get the file name under the cursor
  Input : Y: offset of the file in the panel
          Long: when True, a long file name is fetched
  Output: the file name}
function GetCurName(Y: Integer; Long: Boolean): string;
var
  T             : string[3];
  S             : string;
begin
  S := Act^.GetNamePtr(Y)^;
  if Act^.Mode = pmDOS then
  begin
    S := Act^.GetNamePtr(Y)^;
    if Act^.Dir[Y].Attr and Directory > 0 then S := AddToPath(S, stEmpty, chDirSep);
    if Long then
    begin
      S := LongName(S, True);
      CheckInvalidChars(S);
    end
    else
    begin
      S := ShortName(S, True);
    end;
  end
  else
  begin
    if Y = 0 then S := '' else
      if not GetPanelModeAttrib(Act^.Mode, paASCII) then
      S := ConvertCBMName(S, Act^.GEOSFormat, False, hxDollar);
  end;
  GetCurName := S;
end;

{Handle panel events}
procedure TPanel.HandleEvent(var Event: TEvent);
var
  OutLimit      : Boolean;
  OldCur        : Integer;

{Draws the active panel and, when in quick view mode, enters the current
  image or archive file in the inactive panel, too}
procedure DrawPanels;
begin
  DrawPanel;
  if Other^.QuickView <> qvNone then PEnter(Act, True, False, False);
end;

{Enter the parent directory}
procedure PCtrlPgUp;
var
  O             : Boolean;
begin
  O := False;
  if OK then
  begin
    if Mode = pmDOS then
    begin
      O := (Length(Path) > 3);
    end
    else
    begin
      if Mode <> pmExt then
      begin
        O := True;
      end;
    end;
  end;
  if O then
  begin
    DeltaY := 0;
    Cur := 0;
    PEnter(Act, False, False, False);
  end;
end;

{Select directory entries between the previous and current position of the
  cursor if Shift was being held while the cursor moved}
procedure MakeShiftSel;
var
  F             : Boolean;
  B             : Byte;
  I             : Integer;
begin
  if ShiftPressed then
  begin
    if not ShiftHeld then ShiftSel := (Dir[OldCur].Status and fsProcessMask <> fsSelected);
    ShiftHeld := True;
    F := (Cur >= OldCur);
    B := Byte(not ShiftSel);
    I := OldCur;
    while (I <> Cur) do
    begin
      SetSelectStatus(I, B);
      if F then Inc(I) else Dec(I);
    end;
    if OutLimit then SetSelectStatus(I, B);
  end;
end;

{Move an entry up in the panel}
procedure PUp;
begin
  if OK then
  begin
    OutLimit := (Cur = 0);
    if not OutLimit then
    begin
      if Cur = DeltaY then Dec(DeltaY);
      Dec(Cur);
    end;
    MakeShiftSel;
    DrawPanels;
  end;
end;

{Move an entry down in the panel}
procedure PDown;
begin
  if OK then
  begin
    OutLimit := (Cur >= Max - 1);
    if not OutLimit then
    begin
      if Cur = DeltaY + PanLen - 1 then Inc(DeltaY);
      Inc(Cur);
    end;
    MakeShiftSel;
    DrawPanels;
  end;
end;

{Move an entry left in the panel}
procedure PLeft;
begin
  if OK then
  begin
    if ColumnNum = 1 then
    begin
      if AlternativeHotkeys and (CommandLine^.Data^ = '') then PCtrlPgUp;
    end
    else
    begin
      OutLimit := False;
      if Cur > PanSize then
      begin
        Dec(Cur, PanSize);
        if DeltaY > Cur then if DeltaY > PanSize then Dec(DeltaY, PanSize) else OutLimit := True;
      end
      else
      begin
        OutLimit := True;
      end;
      if OutLimit then
      begin
        Cur := 0;
        DeltaY := 0;
      end;
      MakeShiftSel;
    end;
    DrawPanels;
  end;
end;

{Move an entry right in the panel}
procedure PRight;
begin
  if OK then
  begin
    if ColumnNum = 1 then
    begin
      if AlternativeHotkeys and (CommandLine^.Data^ = '') then PEnter(Act, False, False, True);
    end
    else
    begin
      OutLimit := False;
      if Cur + PanSize + 1 < Max then
      begin
        Inc(Cur, PanSize);
        if DeltaY + PanLen - 1 < Cur then if DeltaY + PanLen + PanSize < Max then Inc(DeltaY, PanSize) else OutLimit := True;
      end
      else
      begin
        OutLimit := True;
      end;
      if OutLimit then
      begin
        Cur := Max - 1;
        if Max > PanLen then DeltaY := Max - PanLen else DeltaY := 0;
      end;
      MakeShiftSel;
    end;
    DrawPanels;
  end;
end;

{Move a page up in the panel}
procedure PPgUp;
begin
  if OK then
  begin
    OutLimit := (DeltaY = 0);
    if OutLimit then
    begin
      Cur := 0;
    end
    else
    begin
      if Cur < PanLen then
      begin
        DeltaY := 0;
      end
      else
      begin
        if DeltaY > PanLen - 1 then Dec(DeltaY, PanLen - 1) else DeltaY := 0;
      end;
    end;
    if Cur > DeltaY + PanLen - 1 then Cur := DeltaY + PanLen - 1;
    MakeShiftSel;
    DrawPanels;
  end;
end;

{Move a page down in the panel}
procedure PPgDn;
begin
  if OK then
  begin
    OutLimit := (DeltaY > Max - PanLen - 1);
    if OutLimit then
    begin
      Cur := Max - 1;
    end
    else
    begin
      if Cur > Max - PanLen then
      begin
        if Max > PanLen then DeltaY := Max - PanLen else DeltaY := 0;
      end
      else
      begin
        if DeltaY < Max - (PanLen shl 1) + 1 then Inc(DeltaY, PanLen - 1) else
          DeltaY := Max - PanLen;
      end;
    end;
    if Cur < DeltaY then Cur := DeltaY;
    MakeShiftSel;
    DrawPanels;
  end;
end;

{Move to the first entry in the panel}
procedure PHome;
begin
  if OK then
  begin
    DeltaY := 0;
    Cur := 0;
    OutLimit := True;
    MakeShiftSel;
    DrawPanels;
  end;
end;

{Move to the last entry in the panel}
procedure PEnd;
begin
  if OK then
  begin
    if Max > PanLen then DeltaY := Max - PanLen else DeltaY := 0;
    Cur := Max - 1;
    OutLimit := True;
    MakeShiftSel;
    DrawPanels;
  end;
end;

{Enter the root directory}
procedure PCtrlBkSlash;
var
  O,
  Q             : Boolean;
  P             : PPanel;
begin
  O := False;
  Q := False;
  P := @Self;
  while not Q do
  begin
    case P^.Mode of
      pmDOS: if QuickView = qvNone then O := True else Q := True;
      pmInfo: P := P^.Other;
      pmExt: Q := True;
    else
      Q := True;
      P^.ShutImageMode;
      P^.Read;
    end;
    if O then
    begin
      Q := True;
      P^.Path[0] := #3;
      ClockOff;
      LongChDir(P^.Path);
      P^.Reread;
    end;
  end;
end;

{Invert the selection of the file under the cursor bar}
procedure PIns;
begin
  SetSelectStatus(Cur, smInvertSel);
  if InsMovesDown then PDown else DrawPanels;
end;

{Insert the file name under the cursor into the clipboard}
procedure PCtrlIns;
var
  X             : Word;
  Y             : Integer;
  S             : string;
begin
  if CommandLine^.Data^ = '' then
  begin
    if SelNum = 0 then
    begin
      S := GetCurName(Cur, GetShiftFlag);
      PutClipboard(@S[1], Length(S));
    end
    else
    begin
      X := 0;
      for Y := 0 to Max - 1 do
      begin
        if Dir[Y].Status and fsProcessMask = fsSelected then
        begin
          S := GetCurName(Y, GetShiftFlag);
          if X + Length(S) + 2 <= (SizeOf(TBuffer) * 2) then
          begin
            Move(S[1], TempBuffer[X], Length(S));
            Inc(X, Length(S));
            S := chCR + chLF;
            Move(S[1], TempBuffer[X], Length(S));
            Inc(X, Length(S));
          end;
        end;
      end;
      if X > 0 then PutClipboard(@TempBuffer, X);
    end;
    ClearEvent(Event);
  end;
end;

{Get the offset of the file under the cursor bar starting from the file
  currently visible as the first entry in the panel
  Input : X, Y: the position of the mouse cursor into the panel
          Z: the integer to contain to offset of the file under the cursor
  Output: when True, file data is under the cursor; otherwise a column
          separator}
function GetRect(X, Y: Integer; var Z: Integer): Boolean;
var
  O             : Boolean;
begin
  Z := Y - 2;
  O := True;
  if GetColumnMode = cmBrief then
  begin
    O := (X mod ColumnWidth <> 0);
    Inc(Z, PanSize * (X div ColumnWidth));
  end;
  GetRect := O;
end;

{Move to the file selected by the user with a mouse click
  Input : X, Y: the position of the mouse cursor into the panel}
procedure GotoMouse(X, Y: Integer);
var
  Z             : Integer;
begin
  if GetRect(X, Y, Z) then
  begin
    if DeltaY + Z < Max then Cur := DeltaY + Z else Cur := Max - 1;
    DrawPanels;
  end;
end;

{Select the file selected by the user with a mouse click
  Input : X, Y: the position of the mouse cursor into the panel}
procedure SelectMouse(X, Y: Integer);
var
  O             : Boolean;
  Z             : Integer;
begin
  if GetRect(X, Y, Z) then
  begin
    if DeltaY + Z < Max then Cur := DeltaY + Z else Cur := Max - 1;
    case Mode of
      pmDOS: O := ((Length(Path) = 3) or (DeltaY + Z > 0));
      pmExt: O := True;
    else
      O := (Cur > 0);
    end;
    if O then
    begin
      if not MouseRightHeld then MouseSel := (Dir[Cur].Status and fsProcessMask <> fsSelected);
      if MouseSel then Dir[Cur].Status := (Dir[Cur].Status and fsStatusMask) or fsSelected else
        Dir[Cur].Status := (Dir[Cur].Status and fsStatusMask);
      MouseRightHeld := True;
    end;
    DrawPanels;
  end;
end;

{Execute the file or the commands associated with the file selected by the
  user with a double-click
  Input : X, Y: the position of the mouse cursor into the panel}
procedure EnterMouse(X, Y: Integer);
var
  Z             : Integer;
begin
  if GetRect(X, Y, Z) and (DeltaY + Z < Max) then
  begin
    Cur := DeltaY + Z;
    DrawPanels;
    PEnter(Act, False, False, False);
  end;
end;

{Change the width and/or height of the panels
  Input : ToX, ToY: new width and height of the left panel}
procedure ResizePanelsTo(ToX, ToY: Integer);
var
  O             : Boolean;
begin
  O := False;
  if ToX < MinPanelWidth then ToX := MinPanelWidth;
  if ToX > ScreenWidth - MinPanelWidth then ToX := ScreenWidth - MinPanelWidth;
  if ToX <> OrigLeftPanWidth then
  begin
    O := True;
    OrigLeftPanWidth := ToX;
  end;
  if ToY < 2 then ToY := 2;
  if ToY > WinSize - Byte(ShowMenu) then ToY := WinSize - Byte(ShowMenu);
  if ToY <> PanWinSize then
  begin
    O := True;
    PanWinSize := ToY;
    OrigScreenHeight := ScreenHeight;
    OrigPanWinSize := ToY;
    if ToY < WinSize - Byte(ShowMenu) then OrigHalfPanWinSize := ToY;
  end;
  if O then ChangePanels;
end;

{Change the width and/or height of the panels
  Input : GrowX: when 1, the panel height is increased; when -1, decreased;
                 when 0, left as is
          GrowY: when 1, the panel width is increased; when -1, decreased;
                 when 0, left as is}
procedure ResizePanels(GrowX, GrowY: Integer);
begin
  ResizePanelsTo(OrigLeftPanWidth + GrowX, PanWinSize + GrowY);
end;

{Change the height of the mini status in a panel
  Input : Grow: when True, the status height is increased, otherwise decreased}
procedure ChangeMiniStatusHeight(Grow: Boolean);
var
  B,
  C             : Byte;
begin
  if (Mode <> pmInfo) and (QuickView in [qvNone, qvNormal]) then
  begin
    if Mode = pmDOS then B := MiniStatus and 3 else B := (MiniStatus shr 2) and 3;
    C := B;
    if Grow then Inc(C) else Dec(C);
    if C in [msOff..msFull] then
    begin
      if Mode = pmDOS then MiniStatus := (MiniStatus and $FC) or C else
        MiniStatus := (MiniStatus and $F3) or (C shl 2);
      if (Mode = pmDOS) and (C = msFull) and (B <> msFull) then Act^.Read;
      ChangePanels;
      if Other^.Mode = pmInfo then
      begin
        DrawPanel;
        Other^.Loading := False;
        Other^.DrawPanel;
      end;
      AutomaticSaveSetup;
    end;
  end;
end;

{Change the width of the Name column in a panel
  Input : Grow: when 1, the panel height is increased; when -1, decreased}
procedure ChangeNameColWidth(Width: Integer; Grow: Boolean);
var
  B,
  C,
  M,
  N             : Byte;
  P             : PByte;
begin
  if (Mode <> pmInfo) and (QuickView in [qvNone, qvNormal]) then
  begin
    if Mode = pmDOS then
    begin
      B := CopyDOSNameColWidth;
      P := @DOSNameColWidth;
      M := MinDOSNameColWidth;
      N := Size.X - 2;
    end
    else
    begin
      B := CopyCBMNameColWidth;
      P := @CBMNameColWidth;
      M := MinCBMNameColWidth;
      if GetColumnMode = cmBrief then
      begin
        N := Size.X - 2;
      end
      else
      begin
        N := Size.X - 10;
        if StartInfo then Inc(N, 8);
      end;
    end;
    C := B;
    if Grow then Inc(B, Width) else if Width >= 0 then B := Width;
    if B < M then B := M;
    if B > N then B := N;
    if B <> C then
    begin
      P^ := B;
      ChangePanels;
    end;
  end;
end;

var
  B             : Boolean;
  W,
  X,
  Y,
  Z             : Integer;
  V             : PFileValid;
  S             : string[10];
  P             : TPoint;
  R             : TRect;

procedure EnterUnderMouse;
begin
  if GetRect(P.X, P.Y, Z) and (DeltaY + Z < Max) then
  begin
    repeat
      MakeLocal(Event.Where, P);
      GetRect(P.X, P.Y, W);
      if W = Z then SetDefMouseCursorChar(CheckedChar) else
        SetDefMouseCursorChar(EmptyMouseCursorChar);
    until not MouseEvent(Event, evMouseMove);
    if MouseInView(Event.Where) and GetRect(P.X, P.Y, W) and (W = Z) then
      EnterMouse(X, Y);
  end;
  ClearEvent(Event);
end;

begin
  if Sel and ((Event.What and evMouse = 0) or (MouseInView(Event.Where))) then
  begin
    if (Event.What and evKeyboard > 0) and (Lo(Event.KeyCode) = Lo(kbCtrlBkSlash)) then PCtrlBkSlash;
    if Vis then
    begin
      if Event.What and evKeyboard > 0 then
      begin
        B := (GetShiftState and (kbLeftShift + kbRightShift) > 0);
        OldCur := Cur;
        OutLimit := False;
        case Event.KeyCode of
          kbEnter: PEnter(Act, False, False, False);
          kbGrayPlus: Selection(True, False);
          kbGrayMinus: Selection(False, False);
          kbGrayMul, kbCtrlGMul: InvertSelection(True);
          kbCtrlGPlus: Selection(True, True);
          kbCtrlGMinus: Selection(False, True);
          kbUp: PUp;
          kbDown: PDown;
          kbLeft: PLeft;
          kbRight: PRight;
          kbPgUp: PPgUp;
          kbPgDn: PPgDn;
          kbHome: PHome;
          kbEnd: PEnd;
          kbCtrlHome: PCtrlBkSlash;
          kbCtrlPgUp: PCtrlPgUp;
          kbCtrlPgDn: PEnter(Act, False, False, True);
          kbIns: PIns;
          kbCtrlIns: PCtrlIns;
          kbAltUp: if B then ChangeMiniStatusHeight(True) else ResizePanels(0, -1);
          kbAltDown: if B then ChangeMiniStatusHeight(False) else ResizePanels(0, 1);
          kbAltLeft: if B then ChangeNameColWidth(-1, True) else ResizePanels(-1, 0);
          kbAltRight: if B then ChangeNameColWidth(1, True) else ResizePanels(1, 0);
        else
          B := True;
          if AlternativeHotkeys and (CommandLine^.Data^ = '') then
          begin
            B := False;
            case Event.KeyCode of
              kbBack: PCtrlPgUp;
            else
              case Event.CharCode of
                ' ': PIns;
                '+': Selection(True, False);
                '-': Selection(False, False);
                '*': InvertSelection(False);
              else
                B := True;
              end;
            end;
          end;
          if B and (GetAltChar(Event.KeyCode) > ' ') and (MouseButtons = 0) then
          begin
            X := ScreenWidth shr 1 - 8;
            Y := X + 4;
            R.Assign(Origin.X, PanWinSize + Byte(ShowMenu) - 1, Y, 3);
            FixWinBoundsToPanel(R, @Self);
            FSDialog := New(PDialog, Init(R, stEmpty, fxSmall, fySmall, False));
            FSDialog^.Options := ofSelectable;
            FSDialog^.SetState(sfVisible + sfActive + sfShadow, False);
            R.Assign(2, 1, X, 1);
            V := New(PFileValid, Init);
            V^.Panel := @Self;
            FileSearch := New(PFileSearch, Init(R, X - 8, X, 'Search:', drLeft));
            FileSearch^.Panel := @Self;
            FileSearch^.SetValidator(V);
            FSDialog^.Insert(FileSearch);
            Application^.Insert(FSDialog);
            Event.KeyCode := Ord(LoCase(GetAltChar(Event.KeyCode)));
            SearchInUse := True;
            S := '';
            FileSearch^.SetData(S);
            FSDialog^.SetState(sfActive, True);
            FSDialog^.SetState(sfVisible, True);
            FSDialog^.SetState(sfFocused, True);
            FileSearch^.HandleEvent(Event);
          end;
        end;
      end;
      if (Event.What and evMouse > 0) and (Event.What and evMouseUp = 0) and (Event.Buttons > 0) and
        ((Event.What and evMouseDown = 0) or (Event.Where.Y > 0)) and MouseInView(Event.Where) then
      begin
        MakeLocal(Event.Where, P);
        if (P.X = 0) or (P.X = Size.X - 1) then
        begin
          if ((P.X = Size.X - 1) and (@Self = Left)) or ((P.X = 0) and (@Self = Right)) then
          begin
            X := Event.Where.X;
            SetDefMouseCursorChar(DoubleArrowChars[1]);
            Z := OrigLeftPanWidth;
            repeat
              ResizePanelsTo(Z - X + Event.Where.X, PanWinSize);
            until not MouseEvent(Event, evMouseMove);
            ClearEvent(Event);
          end;
        end
        else if P.Y = Size.Y - 1 then
        begin
          Y := Event.Where.Y;
          SetDefMouseCursorChar(DoubleArrowChars[2]);
          Z := PanWinSize;
          repeat
            ResizePanelsTo(OrigLeftPanWidth, Z - Y + Event.Where.Y);
          until not MouseEvent(Event, evMouseMove);
          ClearEvent(Event);
        end
        else
        repeat
          MakeLocal(Event.Where, P);
          X := P.X;
          Y := P.Y;
          if (X > 0) and (X < Size.X - 1) and (Mode <> pmInfo) and (QuickView in [qvNone, qvNormal]) then
          begin
            if (Y > 1) and (Y < PanSize + 2) then
            begin
              SetDefMouseCursorChar(EmptyMouseCursorChar);
              if MouseButtons and mbRightButton > 0 then SelectMouse(X, Y);
              if MouseButtons and mbMiddleButton > 0 then EnterUnderMouse;
              if Event.Buttons and mbLeftButton > 0 then
              begin
                if Event.Double then EnterUnderMouse else
                  GotoMouse(X, Y);
              end;
              if Mode = pmDOS then W := DOSNameColWidth else W := CBMNameColWidth;
              if (GetColumnMode = cmBrief) or (Mode <> pmDOS) then B := (X mod ColumnWidth = 0) else
                B := (X mod ColumnWidth = W + 1);
              if B then
              begin
                if GetColumnMode = cmBrief then
                begin
                  Z := X div (W + 1);
                end
                else
                begin
                  Z := X div (ColumnWidth + 1) + 1;
                  if Mode <> pmDOS then W := ColumnWidth - CBMNameColWidth;
                end;
                SetDefMouseCursorChar(DoubleArrowChars[1]);
                repeat
                  MakeLocal(Event.Where, P);
                  if GetColumnMode = cmBrief then
                  begin
                    ChangeNameColWidth((P.X - Z + (Z shr 1)) div Z, False);
                  end
                  else if Mode = pmDOS then
                  begin
                    ChangeNameColWidth((P.X - (Z - 1) * (ColumnWidth - W) - 1) div Z, False);
                    if Mode = pmDOS then W := DOSNameColWidth else W := CBMNameColWidth;
                  end
                  else
                  begin
                    ChangeNameColWidth(P.X div Z - W, False);
                    if Mode <> pmDOS then W := ColumnWidth - CBMNameColWidth;
                  end;
                until not MouseEvent(Event, evMouseMove);
                ClearEvent(Event);
              end;
            end
            else if Y <= 1 then
            begin
              SetDefMouseCursorChar(ArrowChars[4]);
              if Cur = DeltaY then
              begin
                PUp;
              end
              else
              begin
                GotoMouse(1, 0);
              end;
              if MouseButtons and mbRightButton > 0 then SelectMouse(1, 0);
            end
            else
            begin
              SetDefMouseCursorChar(ArrowChars[3]);
              if Cur = DeltaY + PanLen - 1 then
              begin
                PDown;
              end
              else
              begin
                GotoMouse(Size.X, PanSize - 1);
              end;
              if MouseButtons and mbRightButton > 0 then SelectMouse(Size.X, PanSize - 1);
            end;
          end
          else
          begin
            SetDefMouseCursorChar(EmptyMouseCursorChar);
            DrawView;
          end;
        until (Event.What = evNothing) or not MouseEvent(Event, evMouseMove + evMouseAuto);
        DefMouseCursorChar := EmptyMouseCursorChar;
      end;
      TView.HandleEvent(Event);
    end
    else
    begin
      if (Event.What and evKeyboard > 0) and (GetAltChar(Event.KeyCode) > ' ') then ClearEvent(Event);
    end;
  end;
end;

{Draw the panel}
procedure TPanel.Draw;
var
  M             : Boolean;
  A,
  E,
  F,
  H,
  K,
  L,
  Z             : Byte;
  C,
  V,
  W,
  X             : Word;
  I,
  J,
  Y             : Integer;
  G,
  Q,
  R,
  S             : Longlongint;
  N,
  P,
  T,
  U             : string;
  D             : DateTime;
  B             : TDrawBuffer;

{Write the buffer onto the screen
   Input : Y: the line to put the buffer into}
procedure WriteBuffer(Y: Integer);
begin
  WriteBuf(0, Y, Size.X, 1, B);
end;

{Get a color attribute for the file
  Input : L: number of current entry
  Output: the color attribute}
function GetAttr(L: Integer): Byte;
begin
  if L < Max then
  begin
    if Dir[L].Status >= FileSelectMode then
    begin
      if (L = Cur) and Sel then GetAttr := GetColor(4) else GetAttr := GetColor(3);
    end
    else
    begin
      if (L = Cur) and Sel then GetAttr := GetColor(2) else GetAttr := E;
    end;
  end
  else
  begin
    GetAttr := E;
  end;
end;

{Get the special mark of hidden/system files and those of selected files
  Input : Index: the index of the file
          Force: when True, a space character is returned when no mark is
                 needed
  Output: the special mark character; when #0, no mark is needed}
function GetSpecialMark(Index: Integer; Force: Boolean): Char;
var
  C             : Char;
begin
  C := #0;
  if Force then C := ' ';
  if Dir[Index].Attr and (Hidden + SysFile) = 0 then
  begin
    if (Dir[Index].Status >= FileSelectMode) and Laptop then C := SelectionChars[2];
  end
  else
  begin
    C := SelectionChars[1];
    if (Dir[Index].Status >= FileSelectMode) and Laptop then C := SelectionChars[3];
  end;
  GetSpecialMark := C;
end;

{Put the special mark of hidden/system files and those of selected files
  into the file name
  Input : Name: the string containing the file name
          Mark: special mark; when #0, no mark is needed
          Pos: position to put the mark to}
procedure PutSpecialMark(var Name: string; Mark: Char; Pos: Byte);
var
  B             : Byte;
begin
  if Mark <> #0 then
  begin
    B := Length(Name);
    if B < Pos then
    begin
      FillChar(Name[B + 1], Pos - B, ' ');
      Name[0] := Chr(Pos);
    end;
    Name[Pos] := Mark;
  end;
end;

{Get the name of the file and place the selection marker, if needed
  Input : L: number of current entry
          Len: when not zero, the file name is cut off at the indicated
               length
  Output: the file name}
function GetName(L: Integer; Len: Byte): string;
var
  I             : Integer;
  N             : string;
begin
  if L < Max then
  begin
    if Mode = pmDOS then
    begin
      N := ConvertDOSName(GetNamePtr(L)^, GetSpecialMark(L, True), CopyDOSNameColWidth);
    end
    else
    begin
      Dec(Len, 2);
      if (Mode <> pmExt) and (L = 0) then
      begin
        N := stParentDir;
      end
      else
      begin
        if GetPanelModeAttrib(Mode, paASCII) then
        begin
          N := GetNamePtr(L)^;
          if Length(N) > Len then
          begin
            N[0] := Chr(Len);
            N[Len] := ArrowChars[2];
          end;
          N := '"' + N + '"';
        end
        else
        begin
          N := GetNamePtr(L)^;
          I := LeftPos(chShiftSpace, N);
          if I > 0 then N[I] := '"';
          if Length(N) <= Len then N := MakeCBMName(N, GEOSFormat) else
            N := MakeCBMName(Copy(N, 1, Len - 1), GEOSFormat) + ArrowChars[2];
          if I = 0 then
          begin
            Inc(N[0]);
            N[Length(N)] := '"';
          end;
          N := '"' + N;
        end;
        if (Dir[L].Status >= FileSelectMode) and Laptop and (GetColumnMode = cmBrief) then
        begin
          while Length(N) < CopyCBMNameColWidth do
          begin
            Inc(N[0]);
            N[Length(N)] := ' ';
          end;
          N[CopyCBMNameColWidth] := SelectionChars[3];
        end;
      end;
    end;
  end
  else
  begin
    N := '';
  end;
  GetName := N;
end;

{Create a line of entry data
  Input : Pos: starting position
          Wide: when True, file names are displayed without the name and
                extension being split into two
          Status: when True, this line is for the mini status, therefore,
                  the name column must be kept wide enough}
procedure CreateLine(Pos: Byte; Wide, Status: Boolean);
const
  Gigabytes     : Longlongint = (LoLongint: 1000000000; HiLongint: 0);
var
  C             : Integer;
  X             : Longint;
  L             : Longlongint;
  P             : PString;
  N             : TFileExtStr;
begin
  if (Y >= 0) and (Y < Max) then
  begin
    if Mode = pmDOS then
    begin
      if Dir[Y].Attr and Directory = 0 then
      begin
        L := Dir[Y].Size;
        if DOSSizeBlocks then ByteToBlockLonglongint(L, L);
        if CompLonglongint(L, Gigabytes) < 0 then
        begin
          T := LeadingSpaceLonglongint(L, 9);
        end
        else
        begin
          DivLonglongintByWord(L, L, 1000);
          T := LeadingSpaceLonglongint(L, 8) + 'K';
        end;
      end
      else
      begin
        if GetNamePtr(Y)^ = stParentDir then T := FullArrowChars[2] + 'UP--DIR' + FullArrowChars[1] else
          T := FullArrowChars[2] + 'SUB-DIR' + FullArrowChars[1];
      end;
      C := CopyDOSNameColWidth;
      if Status then
      begin
        if C > Size.X - 28 then C := Size.X - 28;
        if C < DefDOSNameColWidth then C := DefDOSNameColWidth;
      end;
      MoveStr(B[Pos + C + 2], T, Z);
      if Status or Wide then
      begin
        P := GetNamePtr(Y);
        if Length(P^) > C then T := Copy(P^, 1, C - 1) + ArrowChars[2] else T := P^;
      end
      else
      begin
        T := GetName(Y, C);
      end;
      if Wide then PutSpecialMark(T, GetSpecialMark(Y, False), C);
      MoveStr(B[Pos + 1], T, Z);
      X := Dir[Y].Time;
      if X <> 0 then
      begin
        UnpackTime(X, D);
        T := CreateDate(D.Year, D.Month, D.Day, 2, False);
        MoveStr(B[Pos + C + 12], T, Z);
        T := '';
        if not MilitaryTime then
        begin
          if D.Hour < 12 then T := 'a' else T := 'p';
          D.Hour := D.Hour mod 12;
          if D.Hour = 0 then D.Hour := 12;
        end;
        T := LeadingSpace(D.Hour, 2) + TimeSep + LeadingZero(D.Min, 2) + T;
        if MilitaryTime then T := stSpace + T;
        MoveStr(B[Pos + C + 21], T, Z);
      end;
    end
    else
    begin
      L := Dir[Y].Size;
      C := CopyCBMNameColWidth;
      if Mode in [pmTape, pmFile, pmLynx..pmZIP] then ByteToBlockLonglongint(L, L);
      MoveStr(B[Pos + 1], LeadingSpaceLonglongint(L, 6), Z);
      if Status then
      begin
        if C > Size.X - 16 then C := Size.X - 16;
        if C < DefCBMNameColWidth then C := DefCBMNameColWidth;
      end;
      MoveCBMStr(@B[Pos + 8], GetName(Y, C), Z, False);
      A := Dir[Y].Attr;
      if A and faClosed > 0 then T := stSpace else T := stAsterisk;
      H := Dir[Y].ExtAttr and xaTypeMask;
      if H = 0 then
      begin
        N := ShortCBMExt[A and faTypeMask];
        if A and faTypeMask = faPartition then
        begin
          if (Y = 0) and (Mode <> pmExt) and (ImagePath = '') then
          begin
            N := 'DOS';
          end
          else
          begin
            case Mode of
              pmExt, pmDisk: if DiskType and dtTypeMask = dt1581 then if Dir[Y].ExtAttr and xaDirectory = 0
                then N := 'cbm' else N := 'DIR';
              pmTape: N := 'frz';
              pmTAR..pmZIP: N := 'DIR';
            end;
          end;
        end;
      end
      else
      begin
        N := ShortGEOSExt[H];
      end;
      T := T + N;
      if A and faWriteProt > 0 then T := T + '<';
      if (Dir[Y].Status >= FileSelectMode) and Laptop then T[1] := SelectionChars[3];
      MoveStr(B[Pos + C + 9], T, Z);
      if StartInfo then if (Mode = pmExt) or ((Mode = pmDisk) and (Y > 0)) then
        MoveStr(B[Pos + C + 15], LeadingZero(Dir[Y].Track, 2) + ';' + LeadingZero(Dir[Y].Sector, 2), Z) else
        if not GetPanelModeAttrib(Mode, paCompressed) and (LonglongintToLongint(Dir[Y].Size) >= 2) then
        MoveStr(B[Pos + C + 15], HexaPrefix + HexaStr(Dir[Y].Start, 4), Z);
    end;
  end;
end;

{Print a line of centered data into an Info panel
  Input : X, Y: the position of the line to put the data into
          Centered: when True, the text is centered into the panel
          Color: when True, tildes in the data toggle the color
          CBM: when True, the text is displayed as if it were a Commodore
               file name}
procedure PrintLine(X, Y: Integer; Centered, Color, CBM: Boolean);
begin
  if Centered then
  begin
    X := Size.X - 2 - CStrLen(T);
    if X < 0 then X := 0;
    X := (X shr 1) + 1;
  end;
  MoveChar(B, ' ', E, Size.X);
  if CBM then MoveCBMStr(@B[X], T, C, Color) else
    if Color then MoveCStr(B[X], T, C) else
    MoveStr(B[X], T, C);
  B[0] := V;
  B[Size.X - 1] := V;
  WriteBuffer(Y);
end;

{Write a total file size into the panel
  Input : B: the total size in blocks
          C: the total size in bytes
          U: prefix string
          V: suffix string
          Y: the row to put the total size into}
procedure WriteSize(var B, C: Longlongint; const U, V: string; Y: Integer);
var
  S             : string[20];
begin
  if DOSSizeBlocks then
  begin
    T := ColorChar + SepStrLonglongint(C) + ColorChar+' ';
    S := 'block';
    if LonglongintToLongint(C) <> 1 then S := S + 's';
    T := T + S;
  end
  else
  begin
    T := ColorChar + SepStrLonglongint(B) + ColorChar+' bytes';
  end;
  if Other^.Mode = pmDOS then T := U + T + V else
    T := U + T + LimitNameLen(V, Size.X - (CBMStrLen(U) + Length(T)));
  PrintLine(0, Y, True, True, True);
end;

{Put a separator line into the panel
  Input : Y: the row to put the separator line into}
procedure WriteSeparator(Y: Integer);
begin
  MoveChar(B, FrameChars[2], E, Size.X);
  B[0] := Ord(DoubleFrameChars[9]) + E shl 8;
  B[Size.X - 1] := Ord(DoubleFrameChars[12]) + E shl 8;
  WriteBuffer(Y);
end;

{Add vertical separator lines into the draw buffer}
procedure AddVertSeparator;
var
  I,
  J             : Integer;

procedure AddStandardVertSeparator;
begin
  J := 0;
  while J < I do
  begin
    B[J] := X;
    Inc(J, ColumnWidth);
  end;
end;

begin
  I := Size.X;
  if Mode = pmDOS then
  begin
    if K = cmBrief then
    begin
      AddStandardVertSeparator;
    end
    else
    begin
      J := 0;
      while J < Size.X do
      begin
        B[J] := X;
        B[J + CopyDOSNameColWidth + 1] := X;
        B[J + CopyDOSNameColWidth + 11] := X;
        B[J + CopyDOSNameColWidth + 20] := X;
        Inc(J, ColumnWidth);
      end;
    end;
  end
  else
  begin
    if K = cmBrief then Dec(I, 2);
    AddStandardVertSeparator;
  end;
end;

begin
  E := GetColor(1);
  K := GetColumnMode;
  V := Ord(DoubleFrameChars[5]) + E shl 8;
  W := Ord(FrameChars[5]) + E shl 8;
  C := GetColor($0301);
  MoveChar(B, DoubleFrameChars[2], E, Size.X);
  X := Ord(DoubleFrameChars[3]) + E shl 8;
  if Mode = pmInfo then
  begin
    OK := OK and Other^.OK;
    Loading := Loading or Other^.Loading or Other^.Working;
    Changing := Changing or Other^.Changing;
  end;
  if OK and not Changing and (Mode <> pmInfo) and (QuickView in [qvNone, qvNormal]) then
    AddVertSeparator;
  if (not Loading and not Changing) or (QuickView <> qvNone) then
  begin
    if (@Self = Right) and not ShowMenu and ShowClock then I := 30 else I := 36;
    if Sel then A := GetColor(2) else A := E;
    T := '';
    if QuickView in [qvDirCount, qvEmpty] then
    begin
      P := 'View';
    end
    else
    begin
      P := MakeTypeStr(Mode);
      case Mode of
        pmDOS:
        begin
          if OK then P := Path else P := Copy(Path, 1, 2);
          if FileFilter <> pfAll then
          begin
            if FileFilter and pfPCProgs > 0 then P := P + #7'Progs';
            if FileFilter and pfPCArchives > 0 then P := P + #7'PCArchs';
            if FileFilter and pfCBMImages > 0 then P := P + #7'Images';
            if FileFilter and pfCBMArchives > 0 then P := P + #7'CBMArchs';
          end;
        end;
        pmExt:
        begin
          P := LeadingSpace(CBMDev, 0);
          P := P[Length(P)] + ':';
          if OK then T := LeadingSpace(MaxTrack - 1, 0);
        end;
        pmDisk, pmGCRDisk..pmSixZip:
        begin
          N := ImageName;
          if Mode in [pmDiskZip, pmSixZip] then N[1] := '1';
          P := P + ':' + N;
          T := LeadingSpace(LastTrack - FirstTrack, 0);
          if DiskType and dtErrorInfo > 0 then T := T + '+error';
        end;
        pmInfo: P := 'Info';
        pmTape, pmFile, pmLynx..pmFileZip:
        begin
          N := ImageName;
          case Mode of
            pmTape: T := LeadingSpace(ImageSize, 0);
            pmFileZip: N[1] := 'x';
          end;
          P := P + ':' + N;
        end;
      end;
      if not (Mode in [pmDOS, pmInfo]) and (RealImagePath <> '') then
      begin
        P := P + chDirSep;
        if GetPanelModeAttrib(Mode, paASCII) then P := P + RealImagePath else P := P + MakeCBMName(RealImagePath, GEOSFormat);
      end;
      PanelTitle := P;
      if T <> '' then P := P + ' (' + T + ')';
    end;
    I := Size.X - 4;
    J := I - Clock^.Size.X;
    M := ((@Self = Right) and not ShowMenu and ShowClock and (CBMStrLen(P) + 2 + (Clock^.Size.X + 1 shr 1) > J));
    if M then I := J;
    P := LimitNameLen(P, I);
    P := stSpace + P + stSpace;
    if M then Dec(I, CBMStrLen(P) - 3) else I := (Size.X - CBMStrLen(P)) shr 1;
    MoveCBMStr(@B[I], P, A, False);
  end;
  B[0] := Ord(DoubleFrameChars[1]) + E shl 8;
  B[Size.X - 1] := Ord(DoubleFrameChars[4]) + E shl 8;
  WriteBuffer(0);
  MoveChar(B, ' ', E, Size.X);
  B[0] := V;
  B[Size.X - 1] := V;
  if Loading then Max := 0;
  if QuickView in [qvDirCount, qvEmpty] then
  begin
    I := 1;
    if QuickView <> qvEmpty then
    begin
      MoveChar(B, ' ', E, Size.X);
      B[0] := V;
      B[Size.X - 1] := V;
      WriteBuffer(1);
      T := 'Directory "'+ColorChar + LimitNameLen(CutPath(ImagePath, chDirSep), Size.X - 16) + ColorChar+'"';
      PrintLine(2, 2, False, True, False);
      I := 3;
      if OK then
      begin
        MoveChar(B, ' ', E, Size.X);
        B[0] := V;
        B[Size.X - 1] := V;
        WriteBuffer(3);
        if Loading then
        begin
          T := 'Counting...';
          PrintLine(0, 4, True, True, False);
          I := 5;
        end
        else
        begin
          T := 'Contains:';
          PrintLine(2, 4, False, True, False);
          MoveChar(B, ' ', E, Size.X);
          B[0] := V;
          B[Size.X - 1] := V;
          WriteBuffer(5);
          T := 'Subdirectories    '+ColorChar + SepStr(DirsCount) + ColorChar;
          PrintLine(2, 6, False, True, False);
          T := 'Files             '+ColorChar + SepStr(FilesCount) + ColorChar;
          PrintLine(2, 7, False, True, False);
          T := 'Files size        '+ColorChar + SepStrLonglongint(FilesSize) + ColorChar;
          PrintLine(2, 8, False, True, False);
          T := 'Real files size   '+ColorChar + SepStrLonglongint(FilesSizeReal) + ColorChar;
          PrintLine(2, 9, False, True, False);
          T := 'Cluster size      '+ColorChar + SepStr(ClusterSize) + ColorChar;
          PrintLine(2, 10, False, True, False);
          I := 11;
        end;
      end;
    end;
    MoveChar(B, ' ', E, Size.X);
    B[0] := V;
    B[Size.X - 1] := V;
    while I <= Size.Y - 4 do
    begin
      WriteBuffer(I);
      Inc(I);
    end;
    WriteSeparator(Size.Y - 3);
    T := LimitNameLen(CutPath(ImagePath, chDirSep), Size.X - 2);
    PrintLine(1, Size.Y - 2, False, False, False);
  end
  else if Mode = pmInfo then
  begin
    T := TitleStr + Copy(VersionStr, 1, 14);
    PrintLine(0, 1, True, False, False);
    WriteSeparator(2);
    T := ColorChar + SepStr(MemSize) + ColorChar+' bytes memory';
    PrintLine(0, 3, True, True, False);
    T := ColorChar + SepStr(MemFree) + ColorChar+' bytes free';
    PrintLine(0, 4, True, True, False);
    if OK and not Changing then
    begin
      F := Other^.Mode;
      MoveChar(B, ' ', E, Size.X);
      if F = pmDOS then
      begin
        if _Label = '' then T := 'Volume has no label' else
          T := 'Volume label: "'+ColorChar + _Label + ColorChar+'"';
        Y := CStrLen(T);
      end
      else
      begin
        T := 'Label: "'+ColorChar + MakeCBMName(_Label, Other^.GEOSFormat) + ColorChar+'"';
        Y := CBMStrLen(T);
      end;
      Y := Size.X - 2 - Y;
      if Y < 0 then Y := 0;
      Y := (Y shr 1) + 1;
      if F = pmDOS then MoveCStr(B[Y], T, C) else MoveCBMStr(@B[Y], T, C, True);
      B[0] := V;
      B[Size.X - 1] := V;
      WriteBuffer(5);
      M := False;
      case F of
        pmDOS: U := ' on drive '+ColorChar + Other^.Path[1] + ':'+ColorChar;
        pmExt: U := ' on drive '+ColorChar + LeadingZero(Other^.CBMDev, 1) + ':'+ColorChar;
      else
        M := True;
        U := ' in ' + Other^.PanelTitle;
      end;
      ByteToBlockLonglongint(Q, _DiskSize);
      WriteSize(_DiskSize, Q, stEmpty, ' total' + U, 6);
      if F = pmTape then
      begin
        T := ColorChar + SepStrLonglongint(_DiskFree) + ColorChar+' entr';
        if Other^.ImageSize = 1 then T := T + 'y' else T := T + 'ies';
        T := T + ' out of '+ColorChar + SepStr(Other^.ImageSize) + ColorChar+' free' + U;
        PrintLine(0, 7, True, True, False);
      end
      else
      begin
        ByteToBlockLonglongint(Q, _DiskFree);
        WriteSize(_DiskFree, Q, stEmpty, ' free' + U, 7);
      end;
      LongintToLonglongint(R, 0);
      LongintToLonglongint(S, 0);
      Y := 0;
      for I := 0 to Other^.Max - 1 do
      begin
        if ((F = pmDOS) and (Other^.Dir[I].Attr and Directory = 0)) or (F = pmExt) or
          ((GetPanelModeAttrib(F, (paImage + paArchive))) and (I > 0)) then
        begin
          Q := Other^.Dir[I].Size;
          G := Q;
          if F in [pmDisk, pmExt, pmFileZip] then
          begin
            MulLonglongintByLongint(G, G, 254);
          end
          else
          begin
            J := DivLonglongintByWord(Q, Q, 254);
            if J > 0 then IncLonglongint(Q, 1);
            J := DivLonglongintByWord(G, G, ClusterSize);
            if J > 0 then IncLonglongint(G, 1);
            MulLonglongintByLongint(G, G, ClusterSize);
          end;
          AddLonglongint(R, R, Q);
          AddLonglongint(S, S, G);
          Inc(Y);
        end;
      end;
      T := ColorChar + SepStr(Y) + ColorChar+' file';
      if Y <> 1 then T := T + 's';
      T := T + ' use';
      if Y = 1 then T := T + 's';
      if F = pmExt then U := ' on' else U := ' in';
      WriteSize(S, R, T + stSpace, U, 8);
      if F = pmExt then T := LeadingZero(Other^.CBMDev, 1) + ':' else T := LimitNameLen(Other^.PanelTitle, Size.X - 2);
      PrintLine(0, 9, True, False, M);
    end
    else
    begin
      MoveChar(B, ' ', E, Size.X);
      B[0] := V;
      B[Size.X - 1] := V;
      for I := 5 to 9 do WriteBuffer(I);
    end;
    WriteSeparator(10);
    MoveChar(B, ' ', E, Size.X);
    B[0] := V;
    B[Size.X - 1] := V;
    for I := 11 to Size.Y - 2 do WriteBuffer(I);
  end
  else
  begin
    if OK and not Changing then
    begin
      Z := GetColor(5);
      MoveChar(B, ' ', Z, Size.X);
      if Mode = pmDOS then
      begin
        I := CopyDOSNameColWidth shr 1 - 2;
        if I < 0 then I := 0;
        Inc(I);
        if K = cmBrief then
        begin
          J := 0;
          while J < Size.X do
          begin
            MoveStr(B[J + I], 'Name', Z);
            B[J] := W;
            Inc(J, ColumnWidth);
          end;
        end
        else
        begin
          T := '   Size     Date    Time  ';
          if DOSSizeBlocks then T := Copy(T, 1, CopyDOSNameColWidth + 4) +
            'Blocks' + Copy(T, CopyDOSNameColWidth + 11, MaxStrLen);
          J := 0;
          while J < Size.X do
          begin
            B[J] := W;
            MoveStr(B[J + I], 'Name', Z);
            MoveStr(B[J + CopyDOSNameColWidth + 2], T, Z);
            B[J + CopyDOSNameColWidth + 1] := W;
            B[J + CopyDOSNameColWidth + 11] := W;
            B[J + CopyDOSNameColWidth + 20] := W;
            Inc(J, ColumnWidth);
          end;
        end;
      end
      else
      begin
        I := CopyCBMNameColWidth shr 1 - 2;
        if I < 0 then I := 0;
        Inc(I);
        if K = cmBrief then
        begin
          J := 0;
          while J < Size.X - 2 do
          begin
            MoveStr(B[J + I], 'Name', Z);
            B[J] := W;
            Inc(J, ColumnWidth);
          end;
        end
        else
        begin
          T := 'Type';
          if StartInfo then T := T + ' Start';
          J := 0;
          while J < Size.X do
          begin
            MoveStr(B[J + 1], 'Length', Z);
            MoveStr(B[J + I + 7], 'Name', Z);
            MoveStr(B[J + CopyCBMNameColWidth + 10], T, Z);
            B[J] := W;
            Inc(J, ColumnWidth);
          end;
        end;
      end;
      B[0] := V;
      B[Size.X - 1] := V;
      WriteBuffer(1);
      if (Cur <> -1) and (Cur < DeltaY) then Cur := DeltaY;
      if Cur > DeltaY + PanLen - 1 then Cur := DeltaY + PanLen - 1;
      if not Working then
      begin
        Top := GetNamePtr(DeltaY)^;
        Under := GetNamePtr(Cur)^;
        NewCur := Cur;
      end;
      for I := 0 to PanSize - 1 do
      begin
        Y := DeltaY + I;
        MoveChar(B, ' ', E, Size.X);
        if K = cmBrief then
        begin
          if Mode = pmDOS then
          begin
            J := 0;
            while J < Size.X do
            begin
              Z := GetAttr(Y);
              MoveChar(B[J], ' ', Z, ColumnWidth);
              B[J] := W;
              MoveStr(B[J + 1], GetName(Y, CopyDOSNameColWidth), Z);
              Inc(Y, PanSize);
              Inc(J, ColumnWidth);
            end;
          end
          else
          begin
            J := 0;
            while J < Size.X - 2 do
            begin
              Z := GetAttr(Y);
              MoveChar(B[J], ' ', Z, ColumnWidth + 1);
              B[J] := W;
              MoveCBMStr(@B[J + 1], GetName(Y, CopyCBMNameColWidth), Z, False);
              Inc(Y, PanSize);
              Inc(J, ColumnWidth);
            end;
          end;
        end
        else
        begin
          J := 0;
          while J < Size.X do
          begin
            Z := GetAttr(Y);
            X := Ord(FrameChars[5]) + Z shl 8;
            MoveChar(B[J], ' ', Z, ColumnWidth);
            CreateLine(J, (K = cmWide), False);
            B[J] := W;
            if Mode = pmDOS then
            begin
              B[J + CopyDOSNameColWidth + 1] := X;
              B[J + CopyDOSNameColWidth + 11] := X;
              B[J + CopyDOSNameColWidth + 20] := X;
            end;
            Inc(Y, PanSize);
            Inc(J, ColumnWidth);
          end;
        end;
        B[0] := V;
        B[Size.X - 1] := V;
        WriteBuffer(I + 2);
      end;
      if GetMiniStatus <> msOff then
      begin
        MoveChar(B, FrameChars[2], E, Size.X);
        X := Ord(FrameChars[15]) + E shl 8;
        AddVertSeparator;
        B[0] := Ord(DoubleFrameChars[9]) + E shl 8;
        B[Size.X - 1] := Ord(DoubleFrameChars[12]) + E shl 8;
        WriteBuffer(PanSize + 2);
      end;
      LongintToLonglongint(S, 0);
      J := 0;
      SelNum := 0;
      ListNum := 0;
      ListEnd := 0;
      for I := 0 to Max - 1 do
      begin
        Z := Dir[I].Status;
        if Z <> fsNormal then
        begin
          if ListNum < MaxSelNum then
          begin
            Y := InsListName(GetNamePtr(I)^);
            if Y >= 0 then
            begin
              List[ListNum].Name := Y;
              List[ListNum].Status := Dir[I].Status;
            end;
            Inc(ListNum);
          end;
          if Z >= FileSelectMode then
          begin
            if (Mode <> pmDOS) or (Dir[I].Attr and Directory = 0) then Inc(J);
            if ((Mode in [pmTape, pmFile, pmLynx..pmZIP]) or ((Mode = pmDOS) and DOSSizeBlocks)) then
            begin
              ByteToBlockLonglongint(Q, Dir[I].Size);
              AddLonglongint(S, S, Q);
            end
            else
            begin
              AddLonglongint(S, S, Dir[I].Size);
            end;
            Inc(SelNum);
          end;
        end;
      end;
      if Loading then
      begin
        MoveChar(B, ' ', E, Size.X);
        B[0] := V;
        B[Size.X - 1] := V;
        WriteBuffer(PanSize + 3);
        if GetMiniStatus = msFull then WriteBuffer(PanSize + 4);
      end
      else
      begin
        MoveChar(B, ' ', E, Size.X);
        if GetMiniStatus = msFull then
        begin
          if _Label = '' then
          begin
            P := 'No label';
          end
          else
          begin
            if Mode = pmDOS then P := _Label else P := MakeCBMName(_Label, GEOSFormat);
            P := '"'+ColorChar + P + ColorChar+'"';
          end;
          if Mode = pmDOS then X := CStrLen(P) else X := CBMStrLen(P);
          LongintToLonglongint(R, 0);
          T := '';
          if Mode = pmDOS then
          begin
            if DOSSizeBlocks then
            begin
              ByteToBlockLonglongint(R, _Free);
              T := ' blocks';
            end
            else
            begin
              R := _Free;
              T := ' bytes';
            end;
          end
          else
          begin
            if Mode = pmTape then
            begin
              if LonglongintToLongint(_Free) > 0 then LongintToLonglongint(R, ImageSize + 2 - LonglongintToLongint(_Free));
            end
            else
            begin
              R := _Free;
            end;
            U := ColorChar + U + ColorChar+' free';
          end;
          U := SepStrLonglongint(R);
          if CStrLen(U) + X + CStrLen(T) + 7 > Size.X - 2 then
          begin
            DivLonglongintByWord(Q, R, 1000);
            U := SepStrLonglongint(Q) + 'K';
          end;
          U := ', '+ColorChar + U + ColorChar + T + ' free';
          Y := Size.X - 2 - (X + CStrLen(U));
          if Y < 0 then Y := 0;
          I := Y shr 1 + 1;
          MoveCStr(B[I], U, C);
          if Mode = pmDOS then MoveCStr(B[I], P, C) else MoveCBMStr(@B[I], P, C, True);
          MoveCStr(B[I + X], U, C);
          B[0] := V;
          B[Size.X - 1] := V;
          WriteBuffer(PanSize + 3);
          MoveChar(B, ' ', E, Size.X);
        end;
        if J = 0 then
        begin
          Z := E;
          Y := Cur;
          MoveChar(B, ' ', Z, Size.X);
          CreateLine(0, False, True);
        end
        else
        begin
          if (Mode = pmDOS) and not DOSSizeBlocks then
          begin
            U := ColorChar + SepStrLonglongint(S);
            T := ' byte';
            if LonglongintToLongint(S) <> 1 then T := T + 's';
            T := T + ' in ' + SepStr(J) + ' selected file';
            if J > 1 then T := T + 's';
            if CStrLen(U) + Length(T) > Size.X - 2 then
            begin
              DivLonglongintByWord(Q, S, 1000);
              U := ColorChar + SepStrLonglongint(Q) + 'K';
            end;
            U := U + T;
          end
          else
          begin
            U := ColorChar + SepStrLonglongint(S) + ' block';
            if LonglongintToLongint(S) <> 1 then U := U + 's';
            U := U + ' in ' + SepStr(J) + ' selected file';
            if J > 1 then U := U + 's';
          end;
          I := Size.X - 2 - CStrLen(U);
          if I < 0 then I := 0;
          MoveCStr(B[I shr 1 + 1], U, C);
        end;
        B[0] := V;
        B[Size.X - 1] := V;
        if GetMiniStatus = msFull then WriteBuffer(PanSize + 4) else
          WriteBuffer(PanSize + 3);
      end;
    end
    else
    begin
      if GetMiniStatus <> msOff then
      begin
        for I := 1 to PanSize + 4 do
        begin
          if I = PanSize + 2 then
          begin
            WriteSeparator(I);
          end
          else
          begin
            MoveChar(B, ' ', E, Size.X);
            B[0] := V;
            B[Size.X - 1] := V;
            WriteBuffer(I);
          end;
        end;
      end
      else
      begin
        for I := 1 to PanSize + 1 do WriteBuffer(I);
      end;
    end;
  end;
  MoveChar(B, DoubleFrameChars[2], E, Size.X);
  X := Ord(DoubleFrameChars[15]) + E shl 8;
  if (GetMiniStatus = msOff) and OK and not Changing and (QuickView = qvNone) then
    AddVertSeparator;
  B[0] := Ord(DoubleFrameChars[13]) + E shl 8;
  B[Size.X - 1] := Ord(DoubleFrameChars[16]) + E shl 8;
  WriteBuffer(PanWinSize - 1);
end;

{Insert a string into the file name input line
  Input:  S: the file name to insert
          Space: when True and the input line is the command line then a
                 trailing space is inserted after the file name
          Merge: when True, the file name is merged with the path in front
                 of it, removing the trailing quotation mark of the path and
                 the leading quotation mark of the file name}
procedure TNameInputLine.InsertStr(S: string; Space, Merge: Boolean);
var
  O             : Boolean;
  W             : Word;
begin
  O := (@Self = CommandLine);
  if O then CheckInvalidChars(S);
  W := 0;
  if First then DeleteAll;
  if Merge and (CurPos >= 2) and (Data^[CurPos - 1] = chDirSep) and (Data^[CurPos] = '"') then
  begin
    if S[1] = '"' then S := Copy(S, 2, MaxStrLen);
    if S[Length(S)] <> '"' then S := S + '"';
    W := 1;
  end;
  if Space and O then S := S + stSpace;
  if Length(Data^) + Length(S) - W <= MaxLen then
  begin
    if W > 0 then Delete(Data^, CurPos - W + 1, W);
    Insert(S, Data^, CurPos + 1);
    Inc(CurPos, Length(S) - W);
    DrawView;
  end;
end;

{Insert a file name into the file name input line
  Input : Y: offset of the file in the panel
          Long: when True, a long file name is inserted
  Output: when True, a file name has been inserted}
function TNameInputLine.InsertName(Y: Integer; Long: Boolean): Boolean;
var
  S             : string;
begin
  S := GetCurName(Y, Long);
  if Length(Data^) + Length(S) > MaxLen then S := '';
  if S <> '' then InsertStr(S, True, True);
  InsertName := (S <> '');
end;

{Insert the path of a panel into the file name input line
  Input : P: the panel
          Long: when True, a long path name is inserted}
procedure TNameInputLine.InsertPath(P: PPanel; Long: Boolean);
var
  S             : string[CmdLineLen];
begin
  if P^.Mode <> pmExt then
  begin
    S := AddToPath(P^.Path, stEmpty, chDirSep);
    if Long then S := LongName(S, True) else S := ShortName(S, True);
    InsertStr(AddToPath(S, stEmpty, chDirSep), False, False);
  end;
end;

{Handle file name input line events}
procedure TNameInputLine.HandleEvent(var Event: TEvent);
var
  B             : Boolean;

{Complete the file name from a fragment
  Input : Long: when True, a long file name is created}
procedure CompleteName(Long: Boolean);
var
  C,
  D,
  E,
  H,
  J,
  O,
  Q             : Boolean;
  F,
  G             : Byte;
  W             : Word;
  X,
  Y,
  Z             : Integer;
  A,
  P,
  R             : PHistoryItem;
  S,
  T,
  U,
  V             : string;

{Fetch the next file entry from the panel directory}
procedure NextFile;
var
  F             : Boolean;
begin
  F := False;
  DOSError := 0;
  while not F and (CopyFileNum < Act^.Max) do
  begin
    Act^.CopyEntry.LongName := Act^.GetNamePtr(CopyFileNum)^;
    Act^.CopyEntry.Orig.Attr := Act^.Dir[CopyFileNum].Attr;
    if Act^.Mode = pmDOS then F := CompareDOSEntry(S, Act^.CopyEntry.LongName, True, False) else
      F := CompareCBMEntry(S, Act^.CopyEntry.LongName, Act^.CopyEntry.Orig.Attr, True);
    Inc(CopyFileNum);
  end;
  if not F then DOSError := 18;
end;

begin
  H := (CurHelpCtx > 100);
  if H then ChangeHelpCtx(hcHelp);
  F := 0;
  Q := False;
  for Y := 1 to CurPos - 1 do Q := Q xor (Data^[Y] = '"');
  if Q or not (Data^[CurPos] in WhiteSpace) or ((CurPos < Length(Data^)) and not (Data^[CurPos + 1] in WhiteSpace)) then
  begin
    Y := CurPos;
    O := Q;
    while (Y < Length(Data^)) and (O or not (Data^[Y + 1] in WhiteSpace)) do
    begin
      O := O xor (Data^[Y + 1] = '"');
      Inc(Y);
    end;
    X := CurPos;
    O := Q;
    while (X > 1) and (O or not (Data^[X - 1] in WhiteSpace)) do
    begin
      O := O xor (Data^[X - 1] = '"');
      Dec(X);
    end;
    O := False;
    S := Copy(Data^, X, Y - X + 1);
    repeat
      G := LeftPos('"', S);
      if G > 0 then S := Copy(S, 1, G - 1) + Copy(S, G + 1, MaxStrLen);
    until G = 0;
    D := False;
    if (@Self = CommandLine) then
    begin
      Z := X;
      while (Z > 1) and (Data^[Z - 1] in WhiteSpace) do Dec(Z);
      D := (Z <= 1);
    end;
    if (S = stCurrentDir) or (S = stParentDir) or (LongFileNames and (S = stWinRootDir)) then
      S := AddToPath(S, stEmpty, chDirSep);
    T := GetPath(S, chDirSep);
    S := CutPath(S, chDirSep);
    if not LongFileNames and (LeftPos('.', S) = 0) then S := S + stAllFilesDOS else S := S + stAllFilesUnix;
    E := True;
    if D and (T = '') then
    begin
      E := False;
      T := stCurrentDir + chPathSep + GetEnv('PATH');
    end;
    C := (T = '');
    J := (C and not GetPanelModeAttrib(Act^.Mode, paASCII));
    F := 0;
    Q := False;
    A := nil;
    while not Q do
    begin
      if E then
      begin
        U := T;
      end
      else
      begin
        G := LeftPos(chPathSep, T);
        if G = 0 then G := Length(T) + 1;
        U := Copy(T, 1, G - 1);
        T := Copy(T, G + 1, MaxStrLen);
      end;
      if C then
      begin
        CopyFileNum := 0;
        if not (Act^.Mode in [pmDOS, pmExt]) then CopyFileNum := 1;
        NextFile;
      end
      else
      begin
        LongFindFirst(AddToPath(U, S, chDirSep), (Archive + ReadOnly + SysFile + Hidden + Directory), Act^.CopyEntry);
      end;
      while (DOSError = 0) and not Q do
      begin
        V := Act^.CopyEntry.LongName;
        if not Long then V := ShortName(V, False);
        if (V[1] <> '.') or ((Length(V) > 1) and (V[2] <> '.')) then
        begin
          O := (Act^.CopyEntry.Orig.Attr and Directory > 0);
          if not D or (IsExecExt(FileExt(V)) and not O) then
          begin
            if O then V := AddToPath(V, stEmpty, chDirSep);
            O := True;
            if D then
            begin
              G := RightPos('.', V);
              if G > 0 then V[0] := Chr(G - 1);
              if F > 0 then
              begin
                R := P;
                while O and (R <> nil) do
                begin
                  O := (V <> R^.Title);
                  R := R^.Next;
                end;
              end;
            end;
            if O then
            begin
              Inc(F);
              if J then V := MakeCBMName(V, Act^.GEOSFormat);
              A := NewHistoryItem(stEmpty, V, F, False, A);
              if F = 1 then P := A;
              Q := (F >= HistoryMax);
            end;
          end;
        end;
        if not Q then if C then NextFile else LongFindNext(Act^.CopyEntry);
      end;
      if not C then LongFindClose(Act^.CopyEntry);
      Q := Q or E or (T = '');
    end;
    V := 'Files';
    if D then V := 'Commands';
    if (F > 0) and (DisplayUserMenu(V, F, 0, 0, mtNone, P, @V, False, False) = cmOK) then
    begin
      if not C or (Act^.Mode = pmDOS) then
      begin
        if E then V := AddToPath(T, V, chDirSep);
        O := (V[Length(V)] = chDirSep);
        if Long then V := LongName(V, E) else V := ShortName(V, E);
        if O then V := AddToPath(V, stEmpty, chDirSep);
      end;
      if J then V := ConvertCBMName(Copy(V, 3, MaxStrLen), Act^.GEOSFormat, False, hxPercent);
      if X > 0 then Dec(X);
      if Length(Data^) + X - Y + Length(V) < CmdLineLen then
      begin
        CurPos := X;
        Delete(Data^, X + 1, Y - X);
        InsertStr(V, False, False);
      end
      else
      begin
        F := 0;
      end;
    end;
  end;
  GoSound := (F = 0);
  if H then RestoreHelpCtx;
end;

procedure CheckValid;
begin
  if Validator <> nil then Validator^.IsValidInput(Data^, False);
end;

begin
  if (Event.What and evKeyboard > 0) and not Quote then
  begin
    B := GetShiftFlag;
    case Event.KeyCode of
      kbCtrlJ, kbCtrlEnter: if Act^.Vis and (Act^.Max > 0) and
        InsertName(Act^.Cur, B) then
      begin
        CheckValid;
        ClearEvent(Event);
      end;
      kbCtrlBra:
      begin
        InsertPath(Left, B);
        CheckValid;
        ClearEvent(Event);
      end;
      kbCtrlKet:
      begin
        InsertPath(Right, B);
        CheckValid;
        ClearEvent(Event);
      end;
      kbCtrlTab:
      begin
        CompleteName(B);
        CheckValid;
        ClearEvent(Event);
      end;
    end;
  end;
  TInputLine.HandleEvent(Event);
end;

{Insert a history string into the command line}
procedure TCommandLine.CopyHistory;
begin
  if CurHistory < ShellBuffer^.HistoryNum then Data^ := ShellBuffer^.History[CurHistory] else Data^ := '';
  CurPos := Length(Data^);
  First := False;
  DrawView;
end;

{Handle command line events}
procedure TCommandLine.HandleEvent(var Event: TEvent);
var
  O,
  P,
  Q             : Boolean;
  B             : Byte;
  X             : Integer;
  S             : string;
begin
  Q := True;
  P := (not Act^.Vis);
  if Event.What and evKeyboard > 0 then
  begin
    begin
      case Event.KeyCode of
        kbEsc: if Data^ <> '' then Event.KeyCode := kbCtrlY;
        kbUp: if P then Event.KeyCode := kbCtrlE;
        kbDown: if P then Event.KeyCode := kbCtrlX;
        kbTab: Q := False;
        kbLeft, kbRight: Q := (P or ((Act^.GetColumnMode <> cmBrief) and (Data^ <> '')));
      end;
      case Event.KeyCode of
        kbHome, kbEnd: Q := P;
        kbGrayMul: Q := (P or (Data^ <> ''));
        kbGrayPlus, kbGrayMinus: Q := P;
        kbEnter:
        begin
          if (Data^ <> '') or P then
          begin
            O := False;
            X := 1;
            while not O and (X <= Length(Data^)) do
            begin
              O := (Data^[X] <> ' ');
              Inc(X);
            end;
            if O then
            begin
              PutCommand(Data^, True);
              SingleCommand := True;
              ClearCommand := True;
              PopupMenu := False;
              EnterDOSShell;
            end
            else
            begin
              Data^ := '';
              DrawView;
            end;
            ClearEvent(Event);
          end;
        end;
        kbCtrlJ, kbCtrlEnter:
        begin
          if (Length(Data^) > 0) and not IsSeparator(Data^[CurPos]) and (Data^[CurPos] <> '"') then
          begin
            B := CurHistory;
            if B > 0 then
            begin
              O := False;
              while (B > 0) and not O do
              begin
                O := (Copy(ShellBuffer^.History[B - 1], 1, Length(Data^)) = Data^);
                if not O then Dec(B);
              end;
              if O then
              begin
                CurHistory := B - 1;
                CopyHistory;
              end;
            end;
            ClearEvent(Event);
          end;
        end;
        kbCtrlI:
        begin
          if not P and (Act^.Mode = pmDOS) then
          begin
            B := MaxLen - Length(Data^);
            P := (GetShiftState and (kbRightShift + kbLeftShift) > 0);
            if Act^.SelNum = 0 then
            begin
              if Act^.GetNamePtr(Act^.Cur)^ <> stParentDir then InsertName(Act^.Cur, P);
            end
            else
            begin
              X := 0;
              O := True;
              SaveSelection;
              while (X < Act^.Max) and O do
              begin
                if Act^.Dir[X].Status and fsProcessMask = fsSelected then
                begin
                  O := InsertName(X, P);
                  if O then Act^.SetSelectStatus(X, smInvertSel);
                end;
                Inc(X);
              end;
              DrawView;
              Act^.DrawView;
            end;
          end;
          ClearEvent(Event);
        end;
        kbCtrlE:
        begin
          if CurHistory > 0 then Dec(CurHistory);
          CopyHistory;
          ClearEvent(Event);
        end;
        kbCtrlX:
        begin
          if CurHistory < ShellBuffer^.HistoryNum then Inc(CurHistory);
          CopyHistory;
          ClearEvent(Event);
        end;
      end;
      case Event.KeyCode of
        kbEnter, kbUp, kbDown:
      else
        if Q and not (AlternativeHotkeys and (Event.What and evKeyboard > 0)
          and ((Event.KeyCode = kbCtrlHome) or (Event.CharCode in [' ', '+', '-', '*']))
          and (Data^ = '')) then
          TNameInputLine.HandleEvent(Event);
      end;
    end;
  end;
  if (Event.What and evMouse > 0) and MouseInView(Event.Where) then TNameInputLine.HandleEvent(Event);
end;

{Draw the command line}
procedure TCommandLine.Draw;
var
  A,
  C             : Byte;
  Z             : Integer;
  P             : PPanel;
  S             : string;
  B             : TDrawBuffer;

function GetMark(Mark: Integer): Integer;
begin
  Dec(Mark, FirstPos);
  if Mark < 0 then Mark := 0;
  if Mark > Len then Mark := Len;
  GetMark := Mark;
end;

begin
  A := BackAttr;
  MoveChar(B, ' ', A, Size.X);
  S := CurPath;
  if PathPrompt then S := LimitNameLen(S, Size.X shr 1) else S := S[1];
  P := Act;
  if Act^.Mode = pmExt then P := Inact;
  if not (P^.OK or P^.MustRead or LoadingDirs) then S := Copy(S, 1, 3) + '?';
  S := S + '>';
  FirstDataChar := Length(S);
  if CurPos > Length(Data^) then CurPos := Length(Data^);
  if CurPos < FirstPos then FirstPos := CurPos;
  if CurPos > FirstPos + Size.X - 1 - FirstDataChar then FirstPos := CurPos + FirstDataChar - Size.X + 1;
  SetCursor(CurPos - FirstPos + FirstDataChar, 0);
  MoveStr(B, S + Copy(Data^, FirstPos + 1, Size.X), A);
  if SelStart < SelEnd then
  begin
    C := $07;
    if BrightBackground then C := $0F;
    Z := GetMark(SelStart);
    A := ((A and C) shl 4) or ((A shr 4) and C);
    MoveColor(B[Length(S) + Z], A, GetMark(SelEnd) - Z);
  end;
  WriteBuf(0, 0, Size.X, 1, B);
end;

{Press the current disk image type selector radio button and change the
  destination file name accordingly in the associated input line
  Input : Item: number of button to press
          Keyboard: when True, the press action came from the keyboard}
procedure TDiskImageButtons.Press(Item: Integer; Keyboard: Boolean);
var
  I,
  J,
  K             : Integer;
  L             : Longint;
  S,
  P,
  N,
  E             : string;

procedure CreateFullName;
begin
  S := P + N + E;
end;

begin
  L := Value;
  TRadioButtons.Press(Item, Keyboard);
  if Value <> L then
  begin
    NameInput^.GetData(S);
    LongFSplit(S, P, N, E);
    I := 0;
    E := stDot + GetDiskExt(Value);
    if N = '' then E := '';
    CreateFullName;
    J := Length(S) - NameInput^.MaxLen;
    if J > 0 then
    begin
      Dec(N[0], J);
      Dec(I, J);
      CreateFullName;
    end;
    NameInput^.SetData(S);
    Inc(I, NameInput^.CurPos);
    if J > 0 then
    begin
      K := Length(P) + Length(N);
      if (I < K) and (I > K - J) then I := K;
    end;
    if I > Length(S) then I := Length(S);
    NameInput^.CurPos := I;
    NameInput^.DrawView;
  end;
end;

{Handle archive type selector radio button events
  Input : Event: event record to be handled}
procedure TArchButtons.HandleEvent(var Event: TEvent);
begin
  if (Event.What = evCommand) and (Event.Command in [cmNoFileComp..cmZIP]) then
  begin
    Press(Event.Command - cmNoFileComp, False);
    DrawView;
  end;
  TRadioButtons.HandleEvent(Event);
end;

{Press the current archive type selector radio button and change the
  destination file name accordingly in the associated input line
  Input : Item: number of button to press
          Keyboard: when True, the press action came from the keyboard}
procedure TArchButtons.Press(Item: Integer; Keyboard: Boolean);
var
  B,
  O             : Byte;
  I,
  J,
  K             : Integer;
  L             : Longint;
  S,
  F,
  G,
  P,
  N,
  E             : string;

procedure CreateFullName;
begin
  S := G + P + N + E;
end;

procedure MakeType(Mode: Byte);
begin
  G := MakeTypeStr(Mode) + ':';
  E := stDot + DOSExt[Mode];
end;

begin
  L := Value;
  TRadioButtons.Press(Item, Keyboard);
  if Value <> L then
  begin
    NameInput^.GetData(S);
    B := LeftPos(':', S);
    F := UpperCase(Copy(S, 1, B));
    O := DetermineTypePrefix(S);
    if O <> pmDOS then S := Copy(S, B + 1, MaxStrLen) else F := '';
    LongFSplit(S, P, N, E);
    if not (O in [pmDOS, pmLynx..pmFileZip]) then LongFSplit(P, P, N, E);
    I := 0;
    if (Length(N) > 2) and (LoCase(N[1]) in ['a'..'x']) and (N[2] = '!') then
    begin
      N := Copy(N, 3, MaxStrLen);
      Dec(I, 2);
    end;
    G := '';
    case Value of
      1: MakeType(pmLynx);
      2:
      begin
        MakeType(pmFileZip);
        if N <> '' then
        begin
          N := 'x!' + N;
          Inc(I, 2);
        end;
        E := '';
      end;
      3: MakeType(pmLHA);
      4: MakeType(pmArkive);
      5: MakeType(pmTAR);
      6: MakeType(pmZIP);
    end;
    if N = '' then E := '';
    CreateFullName;
    J := Length(S) - NameInput^.MaxLen;
    if J > 0 then
    begin
      Dec(N[0], J);
      Dec(I, J);
      CreateFullName;
    end;
    NameInput^.SetData(S);
    Inc(I, NameInput^.CurPos);
    if J > 0 then
    begin
      K := Length(F) + Length(P) + Length(N);
      if (I < K) and (I > K - J) then I := K;
    end;
    if I < Length(F) then I := Length(G) else Inc(I, Length(G) - Length(F));
    if I > Length(S) then I := Length(S);
    NameInput^.CurPos := I;
    NameInput^.DrawView;
  end;
end;

{Recognizes if the name of a known archive format is at the beginning of
  the input line and sets the associated radio buttons to the appropriate
  value
  Input : S: file name in the input line
          SuppressFill: unused, only needed for the parameter syntax
  Output: when True, the file name is valid}
function TArchValid.IsValidInput(var S: string; SuppressFill: Boolean): Boolean;
var
  W             : Word;
begin
  W := DetermineTypePrefix(S);
  case W of
    pmLynx: W := 1;
    pmFileZip: W := 2;
    pmLHA: W := 3;
    pmArkive: W := 4;
    pmTAR: W := 5;
    pmZIP: W := 6;
  else
    W := 0;
  end;
  TypeInput^.SetData(W);
  TypeInput^.DrawView;
  IsValidInput := True;
end;

{Handle disk type selector radio button events
  Input : Event: event record to be handled}
procedure TDiskButtons.HandleEvent(var Event: TEvent);
begin
  if (Event.What = evCommand) and (Event.Command in [cmNoDiskConv..cmSixZip]) then
  begin
    Press(Event.Command - cmNoDiskConv, False);
    DrawView;
  end;
  TRadioButtons.HandleEvent(Event);
end;

{Press the current disk type selector radio button and change the
  destination file name accordingly in the associated input line
  Input : Item: number of button to press
          Keyboard: when True, the press action came from the keyboard}
procedure TDiskButtons.Press(Item: Integer; Keyboard: Boolean);
var
  B,
  O             : Byte;
  I,
  J,
  K             : Integer;
  L             : Longint;
  S,
  F,
  G,
  P,
  N,
  E             : string;

procedure CreateFullName;
begin
  S := G + P + N + E;
end;

procedure MakeType(Mode: Byte);
begin
  G := MakeTypeStr(Mode) + ':';
  E := stDot + DOSExt[Mode];
end;

begin
  L := Value;
  TRadioButtons.Press(Item, Keyboard);
  if Value <> L then
  begin
    NameInput^.GetData(S);
    B := LeftPos(':', S);
    F := UpperCase(Copy(S, 1, B));
    O := DetermineTypePrefix(S);
    if O <> pmDOS then S := Copy(S, B + 1, MaxStrLen) else F := '';
    LongFSplit(S, P, N, E);
    if not (O in [pmDOS, pmExt, pmDisk, pmGCRDisk..pmSixZip]) then LongFSplit(P, P, N, E);
    I := 0;
    if (Length(N) > 2) and ((N[1]) in ['0'..'9']) and (N[2] = '!') then
    begin
      N := Copy(N, 3, MaxStrLen);
      Dec(I, 2);
      if (N <> '') and (N[1] = '!') then
      begin
        N := Copy(N, 2, MaxStrLen);
        Dec(I);
      end;
    end;
    G := '';
    case Value of
      1: P := DriveNumber(Inact, False);
      2:
      begin
        MakeType(pmDisk);
        E := stDot + GetDiskExt(Act^.CopyDiskType);
      end;
      3: MakeType(pmGCRDisk);
      4:
      begin
        MakeType(pmDiskZip);
        if N <> '' then
        begin
          N := '1!' + N;
          Inc(I, 2);
        end;
        E := '';
      end;
      5:
      begin
        MakeType(pmSixZip);
        if N <> '' then
        begin
          N := '1!!' + N;
          Inc(I, 3);
        end;
        E := '';
      end;
    end;
    if N = '' then E := '';
    CreateFullName;
    J := Length(S) - NameInput^.MaxLen;
    if J > 0 then
    begin
      Dec(N[0], J);
      Dec(I, J);
      CreateFullName;
    end;
    NameInput^.SetData(S);
    Inc(I, NameInput^.CurPos);
    if J > 0 then
    begin
      K := Length(F) + Length(P) + Length(N);
      if (I < K) and (I > K - J) then I := K;
    end;
    if I < Length(F) then I := Length(G) else Inc(I, Length(G) - Length(F));
    if I > Length(S) then I := Length(S);
    NameInput^.CurPos := I;
    NameInput^.DrawView;
  end;
end;

{Recognizes if the name of a known disk format is at the beginning of
  the input line and sets the associated radio buttons to the appropriate
  value
  Input : S: file name in the input line
          SuppressFill: unused, only needed for the parameter syntax
  Output: when True, the file name is valid}
function TDiskValid.IsValidInput(var S: string; SuppressFill: Boolean): Boolean;
var
  W             : Word;
begin
  W := DetermineTypePrefix(S);
  case W of
    pmExt: W := 1;
    pmDisk: W := 2;
    pmGCRDisk: W := 3;
    pmDiskZip: W := 4;
    pmSixZip: W := 5;
  else
    W := 0;
  end;
  TypeInput^.SetData(W);
  TypeInput^.DrawView;
  IsValidInput := True;
end;

end.
