
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   PRINTHLP.PAS                  }
{                                                 }
{         The Star Commander Help Printer         }
{*************************************************}

program The_Star_Commander_Help_Printer;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 0, 655360}

uses
  LowLevel;

const
{Length of online help buffer}
  BufferMax     = 30720;

var
  LineFeed,
  PageFeed,
  FileEnd       : Boolean;
  Data,
  ReadData,
  WriteData     : Byte;
  Count,
  HeaderPos,
  ReadCount,
  WriteCount,
  BufferSize    : Word;
  ReadSize,
  ReadPos,
  NextItemPos   : Longint;
  WriteName     : string;
  ReadFile,
  WriteFile     : file;
  HeaderBuffer  : array [0..HelpHeaderLen - 1] of Byte;
  ReadBuffer,
  WriteBuffer   : array [0..BufferMax - 1] of Byte;

{Read a character from the input file}
procedure ReadChar;
begin
  if ReadCount = BufferSize then
  begin
    if EOF(ReadFile) then
    begin
      FileEnd := True;
      ReadCount := 0;
    end
    else
    begin
      if ReadSize > BufferMax then BufferSize := BufferMax else BufferSize := ReadSize;
      ReadSize := ReadSize - BufferSize;
      BlockRead(ReadFile, ReadBuffer, BufferSize);
      ReadCount := 0;
    end;
  end;
  WriteData := ReadBuffer[ReadCount];
  ReadData := WriteData;
  Inc(ReadCount);
  Inc(ReadPos);
end;

{Write a byte into the output file
  Input : B: byte to be output}
procedure WriteByte(B: Byte);
begin
  WriteBuffer[WriteCount] := B;
  Inc(WriteCount);
  if WriteCount = BufferMax then
  begin
    BlockWrite(WriteFile, WriteBuffer, WriteCount);
    WriteCount := 0;
  end;
end;

{Write a character into the output file and handle special characters
  Input : B: byte to be output}
procedure WriteChar(B: Byte);
var
  I             : Byte;
begin
  if LineFeed and not (B in [Ord(chLF), Ord(chPageFeed), Ord(chCR)]) then
  begin
    LineFeed := False;
    for I := 1 to 9 do WriteByte(Ord(' '));
  end;
  WriteByte(B);
  if B = Ord(chLF) then
  begin
    if PageFeed then
    begin
      WriteByte(Ord(chCR));
      WriteByte(Ord(chLF));
      PageFeed := False;
    end;
    LineFeed := True;
  end;
end;

{Convert a string to uppercase
  Input : S: the original string
  Output: the string in uppercase}
function UpperCase(const S: string): string;
var
  I             : Integer;
  T             : string;
begin
  T[0] := Chr(Length(S));
  for I := 1 to Length(S) do T[I] := UpCase(S[I]);
  UpperCase := T;
end;

begin
  WriteLn('The Star Commander Help Printer 0.83 by Joe Forster/STA');
  WriteLn;
  if ParamCount < 1 then
  begin
    WriteLn('This program prints the contents of the online help of The Star Commander into');
    WriteLn('a text file. Use the file name ''PRN'' to send the output to your printer.');
    WriteLn;
    WriteLn('Usage: PRINTHLP <output-file>');
  end
  else
  begin
    WriteName := UpperCase(ParamStr(1));
    if WriteName = 'SC.HLP' then
    begin
      WriteLn('Cannot print the online help onto itself');
    end
    else
    begin
      Assign(ReadFile, 'SC.HLP');
      Reset(ReadFile, 1);
      if IOResult = 0 then
      begin
        Assign(WriteFile, WriteName);
        Rewrite(WriteFile, 1);
        if IOResult = 0 then
        begin
          BlockRead(ReadFile, HeaderBuffer, HelpHeaderLen);
          for Count := 0 to HelpHeaderLen - 1 do HeaderBuffer[Count] := HeaderBuffer[Count];
          WriteLn(chCR, 'Printing the online help, please wait...');
          ReadSize := FileSize(ReadFile) - HelpHeaderLen;
          ReadPos := HelpHeaderLen;
          HeaderPos := HelpTableStart + 3;
          BufferSize := 0;
          ReadCount := 0;
          LineFeed := True;
          PageFeed := True;
          FileEnd := False;
          WriteByte(Ord(chCR));
          WriteByte(Ord(chLF));
          ReadChar;
          while not FileEnd do
          begin
            NextItemPos := HeaderBuffer[HeaderPos + 2];
            NextItemPos := NextItemPos shl 8 + HeaderBuffer[HeaderPos + 1];
            NextItemPos := NextItemPos shl 8 + HeaderBuffer[HeaderPos];
            Dec(NextItemPos, 2);
            Inc(HeaderPos, 3);
            while not FileEnd and (ReadPos <> NextItemPos) do
            begin
              case ReadData of
                hfEOL:
                begin
                  WriteChar(Ord(chCR));
                  WriteChar(Ord(chLF));
                  ReadChar;
                end;
                hfNormal..hfUnderline, hfAnchor: ReadChar;
                hfMultiply:
                begin
                  ReadChar;
                  Data := ReadData;
                  ReadChar;
                  for Count := 1 to Data do WriteChar(WriteData);
                  ReadChar;
                end;
                hfSpaces:
                begin
                  ReadChar;
                  Data := ReadData;
                  for Count := 1 to Data do WriteChar(Ord(' '));
                  ReadChar;
                end;
                7:
                begin
                  ReadData := Ord('*');
                  WriteData := ReadData;
                end;
              else
                WriteChar(WriteData);
                ReadChar;
              end;
            end;
            ReadChar;
            ReadChar;
            ReadChar;
            WriteChar(Ord(chCR));
            WriteChar(Ord(chLF));
            if not FileEnd then
            begin
              WriteChar(Ord(chPageFeed));
              WriteChar(Ord(chCR));
              WriteChar(Ord(chLF));
              PageFeed := True;
            end;
          end;
          if WriteCount > 0 then BlockWrite(WriteFile, WriteBuffer, WriteCount);
          Close(WriteFile);
        end
        else
        begin
          WriteLn('Cannot create ', WriteName);
        end;
        Close(ReadFile);
      end
      else
      begin
        WriteLn('SC.HLP not found');
      end;
    end;
  end;
end.
