
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    REINIT.PAS                   }
{                                                 }
{     The Star Commander reinitialization unit    }
{*************************************************}

unit Reinit;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Constant;

procedure InitInternals(ForceCollectLPTPorts: Boolean);
procedure Reinitialize(Start: Boolean);

implementation

uses
  App, Dialogs, Drivers, Menus, Objects, Views,
  Base1, Base2, Clipbrd, Config, Disked, ExtFiles, LowLevel, MainFn1, MiscFunc, Panel1, Panel2, Script, XferLo;

{Determine DOS/CBM mode of the panel on basis of the first character of the
  path
  Input : Panel: the panel whose DOS/CBM mode to determine}
procedure DetermineMode(Panel: PPanel);
var
  B             : ^Byte;
  S             : PString;
begin
  if Panel^.Mode = pmInfo then
  begin
    B := @Panel^.OrigMode;
    S := @Panel^.OrigPath;
  end
  else
  begin
    B := @Panel^.Mode;
    S := @Panel^.Path;
  end;
  if S^[1] >= 'A' then
  begin
    B^ := pmDOS;
  end
  else
  begin
    B^ := pmExt;
    Panel^.CBMDev := Ord(Panel^.Path[1]) - Ord('0');
    if Panel^.CBMDev < 2 then Inc(Panel^.CBMDev, 10);
  end;
  if Panel^.Mode <> pmInfo then Panel^.OrigMode := Panel^.Mode;
end;

{Initialize internal settings
  Input : ForceCollectLPTPorts: force collecting information on parallel ports
                                rather than copying from shell buffer}
procedure InitInternals(ForceCollectLPTPorts: Boolean);
begin
  EnableWinNTPortAccess;
  if ForceCollectLPTPorts or ShellBuffer^.First then
  begin
    CollectLPTPorts(True);
  end
  else
  begin
    Move(ShellBuffer^.LPTAddresses, LPTAddresses, SizeOf(LPTAddresses));
    Move(ShellBuffer^.LPTModes, LPTModes, SizeOf(LPTModes));
  end;
  InitTransfer(False);
  InitLPTPorts;
  ResetLPTPort;
  InitLongNames;
  InitSelectMode;
  DisableWinNTPortAccess;
end;

{Reinitialize the application at start or after finishing a DOS shell
  Input : Start: when True, the main program was just started, otherwise
                 returned from a DOS shell}
procedure Reinitialize(Start: Boolean);
var
  B             : Byte;
  X,
  Y             : Integer;
  P             : PPanel;
  E             : TEvent;
  R             : TRect;
begin
  Randomize;
  with ShellBuffer^ do
  begin
    if OrigScreenHeight = 0 then
    begin
      OrigScreenHeight := ScreenHeight;
      OrigPanWinSize := ScreenHeight - 2 - Byte(ShowMenu);
      OrigHalfPanWinSize := ((OrigPanWinSize + 3) * 3 div 5);
    end;
  end;
  if ShellBuffer^.First and (BatchMode = bmScript) then StartBatchCommand(True);
  CharSetMode := csIBMLower;
  HelpNum := 0;
  GoSound := False;
  MakeSound := True;
  LastLoc := 0;
  CurLoc := 0;
  EditClipLen := 0;
  AutoRead := True;
  StoreLoc := False;
  HexaMode := True;
  HelpInUse := False;
  SearchInUse := False;
  HelpCtxSet := False;
  ShiftHeld := False;
  MouseRightHeld := False;
  CommandOutput := coNormal;
  LoadingDirs := True;
  DiskChangeCmd := cmNone;
  CopyExtDisk := ExtendedDisk;
  TempDialog := nil;
  TurboOffed := False;
  InitCountry;
  CharSetMode := ShellBuffer^.CharSetMode;
  Application^.InitScreen;
  if not Resident then ShellBuffer^.MemFree := MemAvail;
  ShellBuffer^.QuitProgram := True;
  Archiving := ShellBuffer^.Archiving;
  Compressing := ShellBuffer^.Compressing;
  MoveFiles := ShellBuffer^.MoveFiles;
  AllDelete := ShellBuffer^.AllDelete;
  AllDeleteReadonly := ShellBuffer^.AllDeleteReadonly;
  AllDeleteDir := ShellBuffer^.AllDeleteDir;
  AllOverwrite := ShellBuffer^.AllOverwrite;
  AllOverwriteReadonly := ShellBuffer^.AllOverwriteReadonly;
  AllConvert := ShellBuffer^.AllConvert;
  WarningStatus := ShellBuffer^.WarningStatus;
  ShellBuffer^.EditSpecFile := False;
  CBMPattern := ShellBuffer^.CBMPattern;
  DOSPattern := ShellBuffer^.DOSPattern;
  InitSelectMode;
  R.Assign(0, 0, ScreenWidth, ScreenHeight);
  Application^.ChangeBounds(R);
  B := 6;
  if MilitaryTime then Dec(B);
  R.Assign(ScreenWidth - B, 0, ScreenWidth, 1);
  Clock := New(PClock, Init(R));
  Application^.Insert(Clock);
  Application^.SetCharSet(CharStartMode, True, False);
  Application^.Buffer := ScreenBuffer;
  ComputeWinSize;
  InitSaver;
  if BatchMode and bmNoInit = 0 then InitInternals(False);
  InitClipboard;
  SetMenu;
  if ShowMenu and (BatchMode = bmNone) then MenuBar^.Show else MenuBar^.Hide;
  MenuBar^.DrawView;
  Application^.GetExtent(R);
  R.A.Y := R.B.Y - 1;
  KeyBar^.SetBounds(R);
  if ShowKeyBar and (BatchMode = bmNone) then KeyBar^.Show else KeyBar^.Hide;
  FailSysErrors := fsAll;
  CurPath := LongGetDir(0);
  FailSysErrors := fsNone;
  DestName := CurPath;
  if LeftSel then B := LeftMode else B := RightMode;
  if not (B in [pmExt, pmInfo]) then if LeftSel then CurPath := LeftPath else CurPath := RightPath;
  R.Assign(0, BackCursorY, ScreenWidth, BackCursorY + 1);
  CommandLine := New(PCommandLine, Init(R, CmdLineLen - 1, CmdLineLen - 1, stEmpty, drLeftClose));
  CommandLine^.HideCursor;
  CommandLine^.SetState(sfAlwaysIns, False);
  CommandLine^.SetData(ShellBuffer^.CmdLineText);
  CommandLine^.CanQuote := False;
  if ShellBuffer^.CmdLineText = '' then
  begin
    ShellBuffer^.CmdFirstPos := 0;
    ShellBuffer^.CmdPos := 0;
  end;
  CommandLine^.CurPos := ShellBuffer^.CmdPos;
  CommandLine^.FirstPos := ShellBuffer^.CmdFirstPos;
  CurHistory := ShellBuffer^.HistoryNum;
  asm
    int $12;
    mov cx, $0400;
    mul cx;
    mov word ptr MemSize[0], ax;
    mov word ptr MemSize[2], dx;
  end;
  MemFree := ShellBuffer^.MemFree;
  if ShellBuffer^.First then
  begin
    with ShellBuffer^ do
    begin
      LeftOrigMode := LeftMode;
      LeftOrigPath := LeftPath;
      RightOrigMode := RightMode;
      RightOrigPath := RightPath;
      DefPath := LongGetDir(0);
    end;
  end;
  R.Assign(0, 0, 0, 0);
  Left := New(PPanel, Init(R));
  Right := New(PPanel, Init(R));
  Left^.Loading := True;
  Left^.Other := Right;
  Left^.CBMDev := ShellBuffer^.LeftCBMDev;
  Left^.Path := LeftPath;
  Left^.OrigPath := ShellBuffer^.LeftOrigPath;
  Left^.RealImagePath := ShellBuffer^.LeftImagePath;
  Left^.OrigImagePath := ShellBuffer^.LeftOrigImagePath;
  Left^.ImageName := ShellBuffer^.LeftImageName;
  Left^.OrigImageName := ShellBuffer^.LeftOrigImage;
  Left^.NewCur := ShellBuffer^.LeftNewCur;
  Left^.Top := ShellBuffer^.LeftTop;
  Left^.Under := ShellBuffer^.LeftUnder;
  Left^.ModeMenu := LeftModeMenu;
  Left^.ColumnMode := LeftColumnMode;
  Left^.DOSNameColWidth := LeftDOSNameColWidth;
  Left^.CBMNameColWidth := LeftCBMNameColWidth;
  Left^.MiniStatus := LeftMiniStatus;
  Left^.SortMenu := LeftSortMenu;
  Left^.SortMode := LeftSortMode;
  Left^.QuickView := LeftQuickView;
  Left^.HiddenFiles := LeftHiddenFiles;
  Left^.FileFilter := LeftFileFilter;
  Left^.SelNum := ShellBuffer^.LeftSelNum;
  Left^.ListNum := ShellBuffer^.LeftListNum;
  Left^.ListEnd := ShellBuffer^.LeftListEnd;
  Move(ShellBuffer^.LeftList, Left^.List, ShellBuffer^.LeftListNum * SizeOf(TSelFile));
  Move(ShellBuffer^.LeftListNames, Left^.ListNames, ShellBuffer^.LeftListEnd);
  Left^.SetModeMenu;
  Left^.SetSortOrder;
  Right^.Loading := True;
  Right^.Other := Left;
  Right^.CBMDev := ShellBuffer^.RightCBMDev;
  Right^.Path := RightPath;
  Right^.OrigPath := ShellBuffer^.RightOrigPath;
  Right^.RealImagePath := ShellBuffer^.RightImagePath;
  Right^.OrigImagePath := ShellBuffer^.RightOrigImagePath;
  Right^.ImageName := ShellBuffer^.RightImageName;
  Right^.OrigImageName := ShellBuffer^.RightOrigImage;
  Right^.NewCur := ShellBuffer^.RightNewCur;
  Right^.Top := ShellBuffer^.RightTop;
  Right^.Under := ShellBuffer^.RightUnder;
  Right^.ModeMenu := RightModeMenu;
  Right^.ColumnMode := RightColumnMode;
  Right^.DOSNameColWidth := RightDOSNameColWidth;
  Right^.CBMNameColWidth := RightCBMNameColWidth;
  Right^.MiniStatus := RightMiniStatus;
  Right^.SortMenu := RightSortMenu;
  Right^.SortMode := RightSortMode;
  Right^.QuickView := RightQuickView;
  Right^.HiddenFiles := RightHiddenFiles;
  Right^.FileFilter := RightFileFilter;
  Right^.SelNum := ShellBuffer^.RightSelNum;
  Right^.ListNum := ShellBuffer^.RightListNum;
  Right^.ListEnd := ShellBuffer^.RightListEnd;
  Move(ShellBuffer^.RightList, Right^.List, ShellBuffer^.RightListNum * SizeOf(TSelFile));
  Move(ShellBuffer^.RightListNames, Right^.ListNames, ShellBuffer^.RightListEnd);
  Right^.SetModeMenu;
  Right^.SetSortOrder;
  if Left^.Path = '' then Left^.Path := ShellBuffer^.DefPath;
  if Right^.Path = '' then Right^.Path := ShellBuffer^.DefPath;
  Left^.Mode := LeftMode;
  Left^.OrigMode := LeftOrigMode;
  Right^.Mode := RightMode;
  Right^.OrigMode := RightOrigMode;
  if ShellBuffer^.First then
  begin
    ShellBuffer^.First := False;
    DetermineMode(Left);
    DetermineMode(Right);
  end;
  Left^.NewMode := Left^.Mode;
  Right^.NewMode := Right^.Mode;
  if LeftSel then SelectPanel(Left, False) else SelectPanel(Right, False);
  if (Act^.Mode <> pmExt) and (UpperCase(Act^.Path) <> UpperCase(DestName)) then
  begin
    Act^.NewMode := pmDOS;
    Act^.SelNum := 0;
    Act^.Under := '';
    Act^.Path := DestName;
  end;
  TempUncompOpen := ShellBuffer^.TempUncompOpen;
  TempInputOpen := ShellBuffer^.TempInputOpen;
  TempOutputOpen := ShellBuffer^.TempOutputOpen;
  TempFileOpen := ShellBuffer^.TempFileOpen;
  TransferInited := ShellBuffer^.TransferInited;
  Left^.Vis := LeftVis;
  Right^.Vis := RightVis;
  Left^.Changing := (Left^.QuickView <> qvNone);
  Right^.Changing := (Right^.QuickView <> qvNone);
  SetVisibility(False, False, False);
  Left^.SetPanelSize;
  Right^.SetPanelSize;
  SetPanelBounds;
  Inact^.Changing := True;
  Application^.Insert(Left);
  Application^.Insert(Right);
  Clock^.MakeFirst;
  if Act^.Mode in [pmExt, pmInfo] then CurPath := Inact^.Path else CurPath := Act^.Path;
  if BatchMode <> bmNone then CommandLine^.Hide;
  Application^.Insert(CommandLine);
  if (ShellBuffer^.CommandOutput <> coNormal) and Resident then Move(ShellBuffer^.ScreenBuffer^, BackBuffer,
    ScreenHeight * ScreenWidth shl 1);
  Background^.DrawView;
  CommandLine^.MakeFirst;
  MenuBar^.MakeFirst;
  KeyBar^.MakeFirst;
  FailSysErrors := fsAll;
  LongChDir(CurPath);
  FailSysErrors := fsNone;
  LastName := ShellBuffer^.LastName;
  DestName := ShellBuffer^.DestName;
  if ShellBuffer^.EditNewFile then
  begin
    ShellBuffer^.EditNewFile := False;
    if FileExists(LastName, False) and CursorFollowsFilename then Act^.Under := LastName;
  end;
  P := Act;
  if Act^.QuickView <> qvNone then P := Inact;
  P^.Changing := True;
  ReadPanel(P, Start);
  ReadPanel(P^.Other, Start);
  ClockOn;
  WentToCorner := False;
  LastWhere := MouseWhere;
  PrintConfigError;
  if ShellBuffer^.CommandOutput <> coNormal then
  begin
    case ShellBuffer^.ExecError of
      deOutOfMemory: ErrorWin(stError, 'Not enough memory to load', ShellBuffer^.DestName, hcNoContext, sbNone);
      deInvalidMBA..deInvalidFormat: ErrorWin(stError, 'Can''t run commands for some reason.', 'Try rebooting.',
        hcNoContext, sbNone);
    end;
  end;
  LoadingDirs := False;
  CommandLine^.ShowCursor;
  CommandLine^.DrawView;
  CommandLine^.SelEnd := 0;
  LastHalfSec := 2;
  Clock^.DrawView;
  PopupMenu := ShellBuffer^.PopupMenu;
  TapeDirSize := ShellBuffer^.TapeDirSize;
  DiskDirSize := ShellBuffer^.DiskDirSize;
  DiskTitle := ShellBuffer^.DiskTitle;
  TapeTitle := ShellBuffer^.TapeTitle;
  if AutoMenus and PopupMenu then
  begin
    E.What := evCommand;
    E.Command := cmUserMenu;
    Application^.PutEvent(E);
  end;
  ExecMode := ShellBuffer^.ExecMode;
  case ExecMode of
    exOpenRead, exCloseWrite:
    begin
      ShellBuffer^.SourceOK := True;
      if ExecMode = exOpenRead then ShellBuffer^.TempUncompOpen := True;
      E.What := evCommand;
      if Compressing then E.Command := cmDCompress else E.Command := cmDCopyFile;
      Application^.PutEvent(E);
    end;
  end;
  ShellBuffer^.ExecMode := exNormal;
  B := ShellBuffer^.EditStatus;
  if B and cfRetryView > 0 then
  begin
    LastName := ShellBuffer^.ViewFileName;
    ShellBuffer^.ViewFileName := '';
    B := B and not cfRetryView;
    ShellBuffer^.EditStatus := B;
    ViewFile(B);
  end
  else
  begin
    ShellBuffer^.ViewFileName := '';
  end;
  if BatchMode <> bmNone then StartBatchCommand(False);
  Act^.FirstFile := ShellBuffer^.FirstFile;
  Act^.CopyDirPos := ShellBuffer^.CopyDirPos;
  CopyFileNum := ShellBuffer^.CopyFileNum;
end;

end.
