
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                     SC.PAS                      }
{                                                 }
{            The Star Commander loader            }
{*************************************************}

program The_Star_Commander_Loader;

{$A+,B-,D+,E-,F+,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 2048, 0, 655360}

uses
  DOS, Memory,
  LowLevel;

const
  VESASupport   : Boolean = True;
  CtrlBreakHit  : Boolean = False;
  SaveCtrlBreak : Boolean = False;
  SysErrActive  : Boolean = False;

type
  PString       = ^string;
  PVESAInfo     = ^TVESAInfo;
  TVESAInfo     = array [$0000..$01FF] of Byte;

var
  First,
  GoResident,
  Output,
  Quit,
  BatchMode     : Boolean;
  FirstPos,
  ScreenMode    : Byte;
  Index,
  BufferSeg,
  BufferOfs     : Word;
  ComName,
  Prompt,
  Command       : string;
  ShellBuffer   : TShellBuffer;
  CommandBuffer : TCmdBuffer;

procedure InitSysError; far; external;
procedure DoneSysError; far; external;
{$L SYSINT2.OBJ}

procedure InitShell; far; external;
procedure DoneShell; far; external;
{$L SHLINT2.OBJ}

procedure VideoInt; assembler;
asm
    push bp;
    push es;
    int $10;
    pop es;
    pop bp;
end;

function DOSVersion: Word; assembler;
asm
    mov ah, $30;
    int $21;
    xchg ah, al;
end;

function UpperCase(const S: string): string;
var
  I             : Integer;
  T             : string;
begin
  T[0] := Chr(Length(S));
  for I := 1 to Length(S) do T[I] := UpCase(S[I]);
  UpperCase := T;
end;

procedure PrintStr(const S: String); assembler;
asm
    push ds;
    lds si, S;
    cld;
    lodsb;
    xor ah, ah;
    xchg ax, cx;
    mov ah, $40;
    mov bx, 1;
    mov dx, si;
    int $21;
    pop ds;
end;

procedure SwitchPrompt; far;
begin
  PrintStr('Press ENTER to return' + chCR + chLF + 'to ' + TitleStr + chCR + chLF);
  asm
    push bp;
    mov ax, $1130;
    xor bh, bh;
    call VideoInt;
    mov ah, 2;
    xor bh, bh;
    mov dh, dl;
    inc dh;
    xor dl, dl;
    call VideoInt;
    pop bp;
@1: mov ax, $0700;
    int $21;
    cmp al, chCR;
    jne @1;
  end;
end;

function GetVideoMode: Word; assembler;
asm
    mov ah, $0F;
    call VideoInt;
    xor ah, ah;
    cmp VESASupport, False;
    je @1;
    cmp al, smLastNonVESA;
    jbe @1;
    push ax;
    mov ax, $4F03;
    call VideoInt;
    cmp ax, $004F;
    pop ax;
    jne @1;
    and bx, $07FF;
    mov ax, bx;
@1:
end;

procedure SetVideoMode(Mode: Word); assembler;
asm
    mov ax, Mode;
    cmp VESASupport, False;
    je @1;
    or ah, ah;
    je @1;
    mov bx, ax;
    and bx, $07FF;
    mov ax, $4F02;
    call VideoInt;
    jmp @2;
@1: xor ah, ah;
    call VideoInt;
@2:
end;

function IsTextVideoMode(Mode: Word): Boolean;
var
  O             : Boolean;
  P             : PVESAInfo;
begin
  O := False;
  case Mode and smModeMask of
    smBW80, smCO80, smMono: O := True;
  else
    if VESASupport and (Mode >= smLastNonVESA) then
    begin
      P := New(PVESAInfo);
      asm
        mov ax, $4F01;
        mov cx, Mode;
        les di, P;
        call VideoInt;
        cmp ax, $004F;
        jne @1;
        mov al, byte ptr es:[di];
        and al, $13;
        cmp al, $03;
        jne @1;
        inc O;
    @1:
      end;
      Dispose(P);
    end;
  end;
  IsTextVideoMode := O;
end;

procedure TextScreen(Prompt: TProc);
var
  V             : Word;
begin
  V := GetVideoMode;
  if not IsTextVideoMode(V) then
  begin
    if V < smBW80 then Inc(V, (smBW80 - smBW40)) else V := smCO80;
    if Assigned(Prompt) then Prompt;
    SetVideoMode(V);
    PrintStr(chCR + chLF);
  end;
end;

procedure ExecLFN; assembler;
asm
    mov ah, $71;
    stc;
    int $21;
    jc @1;
    cmp ax, deNoLongNames;
    stc;
    je @1;
    clc;
@1:
end;

function GetLongName(const Name: string): string;
var
  S             : string;
begin
  asm
    push ds;
    push ss;
    pop es;
    lds si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    lea di, S;
    inc di;
    mov al, $60;
    mov cx, 2;
    call ExecLFN;
    mov bl, 0;
    jc @1;
    xor al, al;
    mov bx, di;
    mov cx, MaxStrLen + 1;
    cld;
    repne scasb;
    sub bx, di;
    neg bx;
    dec bx;
@1: mov byte ptr S[0], bl;
    pop ds;
  end;
  if (S = '') or ((S = UpperCase(S)) and (S = UpperCase(Name))) then S := Name;
  GetLongName := S;
end;

procedure InitCommand;
begin
  DoneSysError;
  SwapVectors;
  InitShell;
end;

procedure DoneCommand;
begin
  DoneShell;
  SwapVectors;
  InitSysError;
end;

procedure ExecCommand;
var
  F             : Boolean;
  I             : Word;
  Params        : string;
begin
  InitCommand;
  GoResident := False;
  if ShellBuffer.CommandOutput = coStandardCmd then
  begin
    I := 1;
    F := False;
    Params := '';
    while (I <= Length(Command)) and (F or (Command[I] <> ' ')) do
    begin
      F := (Command[I] = '"');
      Inc(I);
    end;
    if I <= Length(Command) then
    begin
      Params := Copy(Command, I + 1, MaxStrLen);
      Command[0] := Chr(I - 1);
    end;
    Exec(Command, Params);
  end
  else
  begin
    Exec(GetEnv('COMSPEC'), '/c ' + Command);
  end;
  DoneCommand;
end;

procedure PrintTitle;
begin
  if not ShellBuffer.TitlePrinted then
  begin
    ShellBuffer.TitlePrinted := True;
    PrintStr(TitleStr + VersionStr + chCR + chLF + CopyrightStr + chCR + chLF + chCR + chLF);
  end;
end;

begin
  if Test8086 = 0 then
  begin
    PrintTitle;
    PrintStr('This program requires an 80286 CPU or above' + chCR + chLF);
  end
  else
  begin
    InitSysError;
    InitMemory;
    InitDOSMem;
    ShellBuffer.DefScreenCol := apAuto;
    if ParamCount > 0 then
    begin
      BatchMode := False;
      Command := PString(Ptr(PrefixSeg, $0080))^;
      while (Command <> '') and (Command[Length(Command)] in WhiteSpace) do Dec(Command[0]);
      repeat
        while (Command <> '') and (Command[1] in WhiteSpace) do Command := Copy(Command, 2, MaxStrLen);
        if (Command <> '') and (Command[1] in ['-', '/']) then
        begin
          Index := 2;
          while (Index <= Length(Command)) and not (Command[Index] in WhiteSpace) do Inc(Index);
          ComName := Copy(Command, 1, Index - 1);
          Prompt := UpperCase(Copy(ComName, 2, 255));
          if Prompt = 'CMD' then
          begin
            BatchMode := True;
          end
          else
          begin
            Command := Copy(Command, Index + 1, MaxStrLen);
            if Prompt = 'NOVESA' then VESASupport := False else
              if Prompt = 'NOLPT' then ShellBuffer.DisableLPTPorts := True else
              if Prompt = 'NOXMS' then ShellBuffer.DisableXMSUsage := True else
              if Prompt = 'NOEMS' then ShellBuffer.DisableEMSUsage := True else
              if Prompt = 'NOWINCLIP' then ShellBuffer.DisableWinClipboard := True else
              if Prompt = 'COLOR' then ShellBuffer.DefScreenCol := apColor else
              if Prompt = 'BW' then ShellBuffer.DefScreenCol := apBlackWhite else
              if Prompt = 'LAPTOP' then ShellBuffer.DefScreenCol := apLaptop else
            begin
              TextScreen(nil);
              PrintTitle;
              if Prompt <> '?' then PrintStr('Invalid option: "' + ComName + '"' + chCR + chLF + chCR + chLF);
              PrintStr('Usage:   SC [-|/<options...>]' + chCR + chLF + chCR + chLF +
                'Options: ?          - help screen' + chCR + chLF +
                '         nolpt      - disable parallel port access' + chCR + chLF);
              PrintStr('         novesa     - disable VESA BIOS support' + chCR + chLF +
                '         noxms      - disable XMS usage' + chCR + chLF +
                '         noems      - disable EMS usage' + chCR + chLF +
                '         nowinclip  - disable Windows clipboard' + chCR + chLF);
              PrintStr('         color      - force color palette' + chCR + chLF +
                '         bw         - force black & white palette' + chCR + chLF +
                '         laptop     - force laptop palette' + chCR + chLF +
                '         cmd ...    - execute command or script' + chCR + chLF);
              DoneSysError;
              DoneMemory;
              Exit;
            end;
          end;
        end;
      until (Command = '') or not (Command[1] in ['-', '/']) or BatchMode;
    end;
    TextScreen(nil);
    if not BatchMode then PrintTitle;
    if DOSVersion < $0314 then
    begin
      PrintStr('This program requires DOS version 3.20 or later' + chCR + chLF);
    end
    else
    begin
      FSplit(FExpand(ParamStr(0)), Prompt, ComName, ComName);
      ComName := Prompt + MainPrgFileName;
      ShellBuffer.VESASupport := VESASupport;
      with ShellBuffer do
      begin
        First := True;
        ConfigOK := False;
        QuitProgram := True;
        ScreenBuffer := nil;
        Version := VersionNum;
        CmdBuffer := @CommandBuffer;
      end;
      if (Command <> '') and not BatchMode then
      begin
        DoneDOSMem;
        ExecCommand;
        PrintStr(chCR + chLF);
        InitDOSMem;
        Command := '';
      end;
      Quit := False;
      while not Quit do
      begin
        ShellBuffer.MemFree := MemAvail;
        if ShellBuffer.ScreenBuffer <> nil then Inc(ShellBuffer.MemFree, SizeOf(ShellBuffer.ScreenBuffer^));
        if ShellBuffer.ScreenBuffer = nil then ShellBuffer.ScreenBuffer := New(PScreenBuffer);
        if MemAvail < 417000 then
        begin
          PrintStr('There is not enough memory to load: ' + ComName + chCR + chLF);
          Quit := True;
        end
        else
        begin
          DoneDOSMem;
          InitCommand;
          ShellBuffer.QuitProgram := True;
          GoResident := True;
          Exec(ComName, Command);
          DoneCommand;
          InitDOSMem;
          if DOSError in [2, 3] then
          begin
            PrintStr('Can''t find the file: ' + ComName + chCR + chLF +
              'Press ENTER to try again or ESC to abort' + chCR + chLF);
            asm
              mov Quit, False;
          @2: mov ax, $0700;
              int $21;
              cmp al, chCR;
              je @1;
              cmp al, chEsc;
              jne @2;
              inc Quit;
          @1:
            end;
          end
          else
          begin
            Quit := ((DOSError <> 0) or ShellBuffer.QuitProgram);
            if not Quit then
            begin
              VESASupport := ShellBuffer.VESASupport;
              if ShellBuffer.CommandOutput = coNormal then
              begin
                Dispose(ShellBuffer.ScreenBuffer);
                ShellBuffer.ScreenBuffer := nil;
              end;
              Prompt := ShellBuffer.CurPath;
              if not ShellBuffer.PathPrompt then Prompt := Prompt[1];
              First := True;
              Index := 0;
              DoneDOSMem;
              while (Index < ShellBuffer.CmdLen) do
              begin
                Command := '';
                while (Index < ShellBuffer.CmdLen) and (ShellBuffer.CmdBuffer^[Index] <> chCR) do
                begin
                  Inc(Command[0]);
                  Command[Length(Command)] := ShellBuffer.CmdBuffer^[Index];
                  Inc(Index);
                end;
                Inc(Index, 2);
                if Command <> '' then
                begin
                  Output := ((ShellBuffer.CommandOutput = coNormal) and (ShellBuffer.Single or
                    (Command[1] <> SuppressOutputPrefix)));
                  if not ShellBuffer.Single and (Command[1] = SuppressOutputPrefix) then
                    Command := Copy(Command, 2, MaxStrLen);
                  if Output then
                  begin
                    if Prompt = '' then GetDir(0, Prompt);
                    if ShellBuffer.PathPrompt then Prompt := GetLongName(Prompt) else Prompt := Prompt[1];
                    if First then First := False else PrintStr(chCR + chLF);
                    if ShellBuffer.Single then FirstPos := ShellBuffer.CmdFirstPos + 1 else FirstPos := 1;
                    PrintStr(Prompt + '>' + Copy(Command, FirstPos, 78 - Length(Prompt)) + chCR + chLF);
                  end;
                  Prompt := '';
                end;
                ExecCommand;
                Command := '';
              end;
              InitDOSMem;
              TextScreen(SwitchPrompt);
              if ShellBuffer.CommandOutput <> coNormal then
              begin
                asm
                  push bp;
                  mov ax, $1130;
                  xor bh, bh;
                  call VideoInt;
                  mov ah, 2;
                  xor bh, bh;
                  mov dh, dl;
                  inc dh;
                  xor dl, dl;
                  call VideoInt;
                  pop bp;
                end;
              end;
            end;
          end;
        end;
      end;
    end;
  end;
  DoneSysError;
  DoneMemory;
end.
