
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    SCEDIT.PAS                   }
{                                                 }
{            The Star Commander Editor            }
{*************************************************}

program The_Star_Commander_Editor;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 0, 655360}

uses
  App, DOS, Dialogs, Drivers, Memory, Menus, Objects, Validate, Views,
  Base1, Base2, Clipbrd, Common, Config, Constant, ExtFiles, Help, LowLevel;

const
{Commands}
  cmESave       = 102;
  cmEMark       = 103;
  cmEHexaMode   = 104;
  cmECopy       = 105;
  cmEMove       = 106;
  cmESearch     = 107;
  cmEDelete     = 108;
  cmETabMode    = 109;
  cmEMiniHelp   = 111;
  cmESaveAs     = 112;
  cmEUnmark     = 113;
  cmELoadAddr   = 114;
  cmESetLineLen = 115;
  cmESetUserEOL = 116;
  cmEContSearch = 117;
  cmEConvert    = 118;
  cmEShowSymbol = 119;
  cmESaveQuit   = 120;
  cmEChangeCase = 132;
  cmEViewMode   = 133;
  cmESelectFile = 134;
  cmEInsert     = 135;
  cmEEOLMode    = 136;
  cmEReplace    = 137;
  cmEGoto       = 138;
  cmEBackup     = 139;
  cmEAppend     = 140;
  cmELoadFile   = 141;
  cmERawView    = 142;
{Help contexts}
  hcEQuit       = 124;
  hcESearch     = 125;
  hcESelectFile = 126;
{Mini help modes}
  mhNone        = 0;
  mhExtension   = 1;
  mhMenu        = 2;
{Case conversion modes}
  ccUpperCase   = 0;
  ccLowerCase   = 1;
  ccInvertCase  = 2;
  ccCapitalize  = 3;
{Replace modes}
  rmInsert      = 0;
  rmOverwrite   = 1;
{The height of the mini help at the bottom of the editor screen}
  HelpHeight    = 10;
{Size of safety buffer to retain from the heap}
  SafetyHeapSize= 6144;
{Size of safety buffer to retain from the upper heap}
  UpperHeapSize = 1024;
{Characters representing whether the file has been changed or not}
  ChangeChars   : array [False..True] of Char = (' ', '*');
{Characters representing whether the next characters is quoted or not}
  QuoteChars    : array [False..True] of Char = (' ', '"');
{Characters representing whether insert or overwrite mode is active}
  InsertChars   : array [False..True] of Char = (' ', '^');
{PETSCII to screen code converter table scheme}
  PETtoSCR      : array [0..7] of Byte = ($80, $00, $C0, $E0, $40, $C0, $80, $E0);
{Screen code to PETSCII converter table scheme}
  SCRtoPET      : array [0..7] of Byte = ($40, $00, $80, $40, $80, $80, $C0, $C0);

type
  TCmdrEditor   = object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure SetCharSet(Mode: Byte; On, Force: Boolean); virtual;
    procedure InitKeyBar; virtual;
    procedure Idle; virtual;
    procedure GetEvent(var Event: TEvent); virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
  end;
  TScreen       = object(TView)
    constructor Init(Bounds: TRect);
    procedure SetCursorShape;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Draw; virtual;
  end;
  PScreen       = ^TScreen;
  TMiniHelp     = object(TView)
    function GetPalette: PPalette; virtual;
    procedure Draw; virtual;
  end;
  PMiniHelp     = ^TMiniHelp;
  TNameInputLine= object(TInputLine)
    procedure InsertStr(S: string);
    function InsertName(S: string; Long, Path: Boolean): Boolean;
    procedure HandleEvent(var Event: TEvent); virtual;
  end;
  PNameInputLine= ^TNameInputLine;
  TSafetyHeap   = array [0..SafetyHeapSize - 1] of Byte;
  PSafetyHeap   = ^TSafetyHeap;

var
  QuoteMode,
  SearchMode,
  ReplaceMode,
  MustSaveFile,
  CurRealMove,
  ReadingFile,
  FirstSelect,
  FileOpen,
  FileEnd,
  FileOK,
  ImageOn,
  TabMode,
  ShowLoadAddr,
  ShowSymbols,
  BackupFiles,
  DirMode,
  SkippingTab,
  InsideWord,
  SearchInHex,
  SelInRow,
  StrFound,
  EOLFound,
  ShiftedMove,
  EnableMiniHelp: Boolean;
  PanelNewMode,
  DefMiniHelpMode,
  MiniHelpMode,
  FirstTrack,
  FirstSector,
  EOLMode,
  OrigViewMode,
  TabCount,
  NormAttr,
  SelAttr,
  ArrowAttr,
  DrawAttr,
  ECharSetMode  : Byte;
  EOLChar,
  EOLChar2      : Char;
  LoadAddr,
  ConvTable,
  DrawCount,
  Line,
  Column,
  ScrLine,
  LastScrLine,
  CurScrCol,
  CurScrLine,
  CurColumn,
  CurLine,
  CurRealCol,
  WrapLen,
  ScrWidth,
  FixLineLen,
  SearchSize,
  SelStartCol,
  SelEndCol     : Word;
  ScrSize,
  PanelMax,
  PanelCur,
  PanLen,
  DeltaY        : Integer;
  LineNum,
  TapeDirOffs,
  ReadOffset,
  OrigCurPos,
  CursorPos,
  DOSHeapSize,
  BufferSize,
  ReadSize,
  FreeSize,
  LineStart,
  LineEnd,
  SearchStart,
  SearchEnd,
  SelectLStart,
  SelectLEnd,
  SelectStart,
  SelectEnd,
  SelectSize,
  WinStart,
  WinEnd,
  NewWinStart   : Longint;
  HexaStatus,
  TabStatus,
  MiniHelpStatus,
  LoadAddrStatus,
  ContSearchStatus,
  SymbolStatus  : PStatusItem;
  Title         : PTitle;
  Screen        : PScreen;
  DOSHeap,
  EditBuffer    : Pointer;
  MiniHelp      : PMiniHelp;
  SafetyHeap    : PSafetyHeap;
  SearchStr,
  SearchText,
  SearchHex,
  ReplaceStr,
  ReplaceText,
  ReplaceHex,
  NextSameChar,
  ImageExt,
  InsertName,
  AppendName    : string;
  CmdrEditor    : TCmdrEditor;
  CopyEntry     : ExtSearchRec;
  Entry         : TDirEntry;
  DrawBuf       : TDrawBuffer;
  Locations     : PLocBuffer;
  InsertModes   : array [False..True] of Boolean;
  ReplaceModes  : array [False..True] of Byte;
  LineOffsets   : array [0..MaxScrHeight - 1] of Longint;

procedure CloseImage(Write: Boolean);
begin
  if KeepTime and Write then ExtSetFTime(Image, FileTime);
  ExtClose(Image);
end;

procedure CloseFile;
begin
  if FileOpen then
  begin
    FileOpen := False;
    case PanelMode of
      pmDOS: ExtClose(ReadFile);
      pmDisk..pmFile, pmLynx..pmTAR: CloseImage(False);
    end;
  end;
end;

procedure MakeTitle;
var
  B             : Byte;
  P,
  S             : string;
begin
  Title^.Name[0] := Chr(ScreenWidth - 43);
  Title^.Text^[0] := #43;
  FillChar(Title^.Name[1], ScreenWidth - 43, ' ');
  P := BoxTitle + ': ';
  if DirMode then S := ImageDir else S := FullName;
  P := P + LimitNameLen(S, ScreenWidth - 46 - Length(P));
  Move(P[1], Title^.Name[1], Length(P));
  if DirMode or ReadingFile or (EditBuffer = nil) then
  begin
    FillChar(Title^.Text^[1], 43, ' ');
  end
  else
  begin
    FillChar(Title^.Text^[26], 12, ' ');
    FreeSize := BufferSize - ReadSize;
    P := SepStr(FreeSize) + ' Free';
    B := Length(P);
    Move(P[1], Title^.Text^[38 - B], Length(P));
  end;
  Title^.DrawView;
end;

function ReadWholeFile(Start, Size: Longint): Boolean;
var
  C             : Word;
  I             : Integer;
  L             : Longint;
  P             : Pointer;
  F             : PExtFile;
begin
  P := EditBuffer;
  FarInc(P, Start);
  L := Size;
  case PanelMode of
    pmDOS, pmTape, pmFile, pmLynx..pmTAR:
    begin
      if PanelMode = pmDOS then F := @ReadFile else F := @Image;
      ExtSeek(F^, ReadOffset);
      while L > 0 do
      begin
        if L > TSmallBufSize then C := TSmallBufSize else C := L;
        Dec(L, C);
        ExtBlockRead(F^, P^, C);
        FarInc(P, C);
      end;
      if PanelMode = pmTape then Move(LoadAddr, EditBuffer^, 2);
    end;
    pmDisk:
    begin
      CurLoc := 0;
      Track := Locations^[CurLoc].Track;
      Sector:= Locations^[CurLoc].Sector;
      while (L > 0) and (Track > 0) do
      begin
        ReadDiskBlock(Track, Sector, @DataBuffer);
        if L > 254 then C := 254 else C := L;
        Dec(L, C);
        Move(DataBuffer[2], P^, C);
        FarInc(P, C);
        Track := DataBuffer[0];
        Sector := DataBuffer[1];
      end;
    end;
  end;
  I := IOResult;
  if I <> 0 then ErrorWin(stEmpty, 'The file ' + FullName, 'is corrupted.', CurHelpCtx, sbNone);
  ReadWholeFile := (I = 0);
end;

procedure LoadOffsets;
begin
  NewWinStart := WinStart;
end;

procedure SaveOffsets;
begin
  WinStart := NewWinStart;
end;

procedure UnpackPtr; assembler;
asm
    mov ax, bx;
    shl ax, 12;
    add ax, word ptr EditBuffer[2];
    mov es, ax;
end;

procedure PackPtr; assembler;
asm
    mov bx, es;
    sub bx, word ptr EditBuffer[2];
    shr bx, 12;
end;

procedure IncPtr; assembler;
asm
    inc di;
    jne @1;
    push ax;
    mov ax, es;
    add ax, $1000;
    mov es, ax;
    pop ax;
    inc bx;
@1: retn;
end;

procedure DecPtr; assembler;
asm
    or di, di;
    jne @1;
    push ax;
    mov ax, es;
    sub ax, $1000;
    mov es, ax;
    pop ax;
    dec bx;
@1: dec di;
    retn;
end;

function IsEOL: Boolean; assembler;
asm
    mov di, word ptr CursorPos[0];
    mov bx, word ptr CursorPos[2];
    call UnpackPtr;
    xor al, al;
    mov ah, EOLChar;
    cmp ah, es:[di];
    jne @1;
    cmp EOLMode, elFixLen;
    je @1;
    cmp EOLMode, elCRLF;
    jne @2;
    call IncPtr;
    cmp di, word ptr ReadSize[0];
    jne @3;
    cmp bx, word ptr ReadSize[2];
    je @1;
@3: cmp byte ptr es:[di], chLF;
    jne @1;
@2: inc al;
@1:
end;

procedure MakeLine; assembler;
asm
    mov si, Offset(DrawBuf);
    call UnpackPtr;
    xor cx, cx;
    mov SelStartCol, cx;
    mov SelEndCol, cx;
    mov ax, WrapLen;
    mov DrawCount, ax;
    mov dl, EOLChar;
    mov dh, EOLMode;
    push bp;
    xor bp, bp;
@2: cmp di, word ptr CursorPos[0];
    jne @25;
    cmp bx, word ptr CursorPos[2];
    jne @25;
    push ScrLine;
    pop CurScrLine;
    cmp cx, Column;
    jb @25;
    mov CurScrCol, bp;
@25:cmp di, word ptr ReadSize[0];
    jne @10;
    cmp bx, word ptr ReadSize[2];
    jne @10;
@24:call IncPtr;
    mov al, True;
    cmp FileEnd, False;
    jne @11;
    push ScrLine;
    pop LastScrLine;
    cmp ShowSymbols, False;
    je @11;
    cmp ViewMode, vmScreen;
    je @11;
    mov al, tsEndOfFile;
    mov ah, NormAttr;
    mov [si], ax;
    jmp @11;
@10:mov al, es:[di];
    cmp bx, word ptr SelectStart[2];
    jb @20;
    jne @22;
    cmp di, word ptr SelectStart[0];
    jb @20;
    jne @22;
    mov SelStartCol, cx;
    add SelStartCol, bp;
@22:cmp bx, word ptr SelectEnd[2];
    ja @20;
    jne @23;
    cmp di, word ptr SelectEnd[0];
    ja @20;
    jne @23;
    mov SelEndCol, cx;
    add SelEndCol, bp;
    jmp @20;
@23:mov ah, SelAttr;
    mov SelInRow, True;
    jmp @21;
@20:mov ah, NormAttr;
@21:call IncPtr;
    cmp al, dl;
    jne @3;
    cmp dh, elFixLen;
    je @3;
    cmp dh, elCRLF;
    jne @31;
    cmp di, word ptr ReadSize[0];
    jne @26;
    cmp bx, word ptr ReadSize[2];
    je @3;
@26:cmp byte ptr es:[di], chLF;
    jne @3;
    jmp @4;
@3: cmp al, ' ';
    jne @28;
    cmp ShowSymbols, False;
    je @28;
    mov al, tsSpace;
    jmp @15;
@28:cmp al, chTab;
    jne @16;
    cmp ViewMode, vmScreen;
    je @16;
    cmp TabMode, False;
    je @33;
    push ax;
    push dx;
    mov ax, bp;
    add ax, cx;
    xor dx, dx;
    div TabSize;
    mov ax, dx;
    sub ax, TabSize;
    neg ax;
    mov TabCount, al;
    pop dx;
    pop ax;
    mov al, ' ';
    cmp ShowSymbols, False;
    je @14;
    cmp ViewMode, vmScreen;
    je @14;
    mov al, tsTab;
    jmp @14;
@33:cmp ViewMode, vmASCII;
    je @15;
    cmp ShowSymbols, False;
    jne @15;
@16:cmp ViewMode, vmASCII;
    je @15;
    push di;
    push bx;
    push cx;
    cmp ViewMode, vmScreen;
    jne @18;
    mov bl, al;
    and al, $7F;
    cmp CharSetMode, csIBMUpper;
    jbe @17;
    cmp bl, $80;
    jb @17;
    jmp @19;
@18:cmp ViewMode, vmPETSCII;
    jne @17;
    cmp CharSetMode, csIBMUpper;
    jbe @17;
    mov cl, al;
    and cl, $7F;
    cmp cl, $20;
    jae @17;
@19:ror ah, 4;
@17:mov bx, ConvTable;
    xlat;
    pop cx;
    pop bx;
    pop di;
@15:mov TabCount, 1;
@14:cmp cx, Column;
    jae @7;
    inc cx;
    jmp @8;
@7: cmp bp, ScrWidth;
    jae @5;
    mov [si], ax;
    add si, 2;
@5: inc bp;
@8: dec DrawCount;
    je @13;
    cmp ShowSymbols, False;
    je @27;
    cmp ViewMode, vmScreen;
    je @27;
    mov al, ' ';
@27:dec TabCount;
    jne @14;
    jmp @2;
@13:cmp di, word ptr ReadSize[0];
    jne @12;
    cmp bx, word ptr ReadSize[2];
    je @24;
@12:mov al, es:[di];
    cmp al, dl;
    jne @1;
    cmp dh, elFixLen;
    je @1;
    cmp dh, elCRLF;
    jne @4;
    call IncPtr;
    cmp di, word ptr ReadSize[0];
    jne @29;
    cmp bx, word ptr ReadSize[2];
    je @30;
@29:cmp byte ptr es:[di], chLF;
    je @4;
@30:call DecPtr;
    jmp @1;
@4: call IncPtr;
@31:cmp ShowSymbols, False;
    je @32;
    cmp bp, ScrWidth;
    ja @1;
    mov al, tsEndOfLine;
    mov [si], ax;
    jmp @1;
@32:mov al, ' ';
    or bp, bp;
    jne @1;
    mov [si], ax;
@1: mov al, False;
@11:mov bx, bp;
    pop bp;
    or FileEnd, al;
    mov ah, ArrowAttr;
    cmp bx, ScrWidth;
    jbe @6;
    mov al, byte ptr ArrowChars[2];
    mov bx, ScrWidth;
    dec bx;
    shl bx, 1;
    mov word ptr DrawBuf[bx], ax;
@6: cmp Column, 0;
    je @9;
    mov al, byte ptr ArrowChars[1];
    mov word ptr DrawBuf[0], ax;
@9: call PackPtr;
end;

procedure SimulateDraw;
var
  L             : Longint;
begin
  FileEnd := False;
  L := NewWinStart;
  LastScrLine := ScrSize - 1;
  for ScrLine := 0 to ScrSize - 1 do
  begin
    if L <= ReadSize then
    begin
      LineOffsets[ScrLine] := L;
      asm
        mov di, word ptr L[0];
        mov bx, word ptr L[2];
        call MakeLine;
        mov word ptr L[0], di;
        mov word ptr L[2], bx;
      end;
    end
    else
    begin
      LineOffsets[ScrLine] := ReadSize;
    end;
  end;
  if L > ReadSize then L := ReadSize;
  WinEnd := L;
  LineOffsets[Screen^.Size.Y] := L;
end;

procedure SeekOffset(Offset: Longint);
begin
  if Offset >= ReadSize then
  begin
    CurScrLine := LastScrLine;
  end
  else
  begin
    CurScrLine := 0;
    while (CurScrLine < ScrSize) and (Offset >= LineOffsets[CurScrLine + 1]) do Inc(CurScrLine);
  end;
end;

function FindEOL(Fore, Save, SkipEOL, SkipWrap: Boolean): Boolean; forward;

procedure SeekWin(Check, Find: Boolean);
var
  F,
  O             : Boolean;
  B             : Byte;
  L             : Longint;
begin
  if Check then
  begin
    if HexaMode then
    begin
      if ReadSize > ScrSize shl 4 then
      begin
        L := ReadSize - ScrSize shl 4 + $00000010;
        if NewWinStart > L then NewWinStart := L;
      end;
    end
    else
    begin
      O := False;
      if NewWinStart = ReadSize then O := True else
        for B := 1 to ScrSize - 1 do O := O or FindEOL(True, False, True, True);
      if O then
      begin
        NewWinStart := ReadSize;
        FindEOL(False, False, False, True);
        for B := 1 to ScrSize - 1 do FindEOL(False, False, True, True);
        SimulateDraw;
        SeekOffset(CursorPos);
      end
      else
      begin
        NewWinStart := WinStart;
      end;
    end;
  end;
  if HexaMode then
  begin
    NewWinStart := NewWinStart and $FFFFFFF0;
  end
  else
  begin
    if Find then FindEOL(False, True, True, True);
    L := NewWinStart;
    NewWinStart := LineOffsets[CurScrLine];
    if (EOLMode = elCRLF) and (CursorPos > 0) then
    begin
      Dec(CursorPos);
      if not IsEOL then Inc(CursorPos);
    end;
    asm
      mov di, word ptr NewWinStart[0];
      mov bx, word ptr NewWinStart[2];
      mov dl, TabMode;
      call UnpackPtr;
      xor cx, cx;
  @5: cmp di, word ptr CursorPos[0];
      jne @1;
      mov bx, word ptr CursorPos[2];
      je @2;
  @1: mov al, es:[di];
      cmp al, chTab;
      jne @3;
      cmp dl, False;
      je @3;
      cmp ViewMode, vmASCII;
      jne @3;
      push dx;
      xchg ax, cx;
      xor dx, dx;
      div TabSize;
      mul TabSize;
      xchg ax, cx;
      add cx, TabSize;
      pop dx;
      jmp @4;
  @3: inc cx;
  @4: call IncPtr;
      jmp @5;
  @2: mov CurColumn, cx;
    end;
    if CurColumn < Column + 1 then if CurColumn > 0 then Column := CurColumn - 1 else Column := 0;
    if CurColumn > Column + ScreenWidth - 2 then Column := CurColumn - ScreenWidth + 2;
    NewWinStart := L;
  end;
  SaveOffsets;
end;

function FindEOL(Fore, Save, SkipEOL, SkipWrap: Boolean): Boolean;
var
  B             : Boolean;
begin
  asm
    mov B, False;
    mov di, word ptr NewWinStart[0];
    mov bx, word ptr NewWinStart[2];
    call UnpackPtr;
    mov cx, WrapLen;
    xor dx, dx;
    mov EOLFound, dl;
    mov SkippingTab, False;
    mov TabCount, 1;
    cmp Fore, False;
    je @1;
    mov ah, EOLChar;
@2: cmp di, word ptr ReadSize[0];
    jne @20;
    cmp bx, word ptr ReadSize[2];
    je @10;
@20:mov al, es:[di];
    call IncPtr;
    cmp al, ah;
    jne @32;
    cmp EOLMode, elFixLen;
    jne @6;
@32:cmp al, chTab;
    jne @16;
    cmp TabMode, False;
    je @16;
    cmp ViewMode, vmScreen;
    je @16;
    push ax;
    push dx;
    mov ax, dx;
    xor dx, dx;
    div TabSize;
    mov ax, dx;
    sub ax, TabSize;
    neg ax;
    mov TabCount, al;
    pop dx;
    pop ax;
    jmp @7;
@16:mov TabCount, 1;
@7: inc dx;
    dec cx;
    je @15;
    dec TabCount;
    jne @7;
    jmp @2;
@15:cmp di, word ptr ReadSize[0];
    jne @21;
    cmp bx, word ptr ReadSize[2];
    je @10;
@21:mov al, es:[di];
    cmp al, ah;
    jne @3;
    cmp EOLMode, elFixLen;
    je @3;
    cmp EOLMode, elCRLF;
    jne @14;
    call IncPtr;
    cmp di, word ptr ReadSize[0];
    jne @29;
    cmp bx, word ptr ReadSize[2];
    je @30;
@29:cmp byte ptr es:[di], chLF;
    je @14;
@30:call DecPtr;
    jmp @3;
@14:call IncPtr;
    inc EOLFound;
    jmp @3;
@6: inc EOLFound;
    cmp EOLMode, elCRLF;
    jne @3;
    dec EOLFound;
    cmp di, word ptr ReadSize[0];
    jne @31;
    cmp bx, word ptr ReadSize[2];
    je @16;
@31:cmp byte ptr es:[di], chLF;
    jne @16;
    call IncPtr;
    inc EOLFound;
    jmp @3;
@1: mov ah, EOLChar2;
    or di, di;
    jne @22;
    push ax;
    mov ax, es;
    cmp ax, word ptr EditBuffer[2];
    pop ax;
    je @12;
@22:push bx;
    mov bx, MaxWord;
    call @26;
    pop bx;
    cmp al, ah;
    jne @4;
    cmp EOLMode, elFixLen;
    je @4;
    cmp EOLMode, elCRLF;
    jne @11;
    cmp di, 2;
    jae @23;
    push ax;
    mov ax, es;
    cmp ax, word ptr EditBuffer[2];
    pop ax;
    je @4;
@23:push bx;
    mov bx, -2;
    call @26;
    pop bx;
    cmp al, chCR;
    jne @4;
    call DecPtr;
@11:call DecPtr;
    inc EOLFound;
    cmp SkipEOL, False;
    je @13;
@4: or di, di;
    jne @24;
    push ax;
    mov ax, es;
    cmp ax, word ptr EditBuffer[2];
    pop ax;
    je @12;
@24:call DecPtr;
    mov al, es:[di];
    cmp al, ah;
    jne @33;
    cmp EOLMode, elFixLen;
    jne @8;
@33:cmp al, chTab;
    jne @9;
    cmp TabMode, False;
    je @9;
    cmp ViewMode, vmScreen;
    je @9;
    push dx;
    xchg ax, cx;
    xor dx, dx;
    div TabSize;
    mul TabSize;
    xchg ax, cx;
    pop dx;
    je @18;
@28:mov TabCount, 8;
    mov SkippingTab, True;
@9: inc dx;
    dec TabCount;
    dec cx;
    je @18;
    cmp TabCount, 0;
    jne @4;
    inc TabCount;
    cmp SkippingTab, False;
    je @4;
    mov SkippingTab, False;
    push dx;
    xchg ax, cx;
    xor dx, dx;
    div TabSize;
    mul TabSize;
    xchg ax, cx;
    pop dx;
    jmp @4;
@18:cmp TabCount, 1;
    jb @19;
    call IncPtr;
@19:cmp SkipWrap, False;
    je @13;
    jmp @3;
@8: call IncPtr;
    inc EOLFound;
    cmp EOLMode, elCRLF;
    jne @3;
    dec EOLFound;
    call DecPtr;
    or di, di;
    jne @25;
    push ax;
    mov ax, es;
    cmp ax, word ptr EditBuffer[2];
    pop ax;
    je @12;
@25:push bx;
    mov bx, MaxWord;
    call @26;
    pop bx;
    cmp al, chCR;
    jne @9;
    call IncPtr;
    inc EOLFound;
    jmp @3;
@10:
@12:
@5: inc B;
@3: call PackPtr;
    mov word ptr NewWinStart[0], di;
    mov word ptr NewWinStart[2], bx;
    jmp @13;
@26:cmp di, 16;
    jb @27;
    mov al, es:[di][bx];
    retn;
@27:push es;
    push ax;
    mov ax, es;
    dec ax;
    mov es, ax;
    pop ax;
    mov al, es:[di][bx][16];
    pop es;
    retn;
@13:
  end;
  if Save then
  begin
    SaveOffsets;
    SimulateDraw;
    SeekWin(True, False);
  end;
  FindEOL := B;
end;

function IsTextSeparator(Ch: Char): Boolean;
begin
  IsTextSeparator := (Ch in [#0..'/', ':'..'@', '['..'_', '{'..#127]);
end;

procedure FindNextSep(SkipSep: Boolean); assembler;
asm
    mov si, word ptr LineEnd[0];
    mov cx, word ptr LineEnd[2];
@6: cmp di, si;
    jne @3;
    cmp bx, cx;
    je @1;
@3: mov al, es:[di];
    cmp al, EOLChar;
    jne @4;
    cmp EOLMode, elFixLen;
    je @4;
    cmp EOLMode, elCRLF;
    jne @1;
    call IncPtr;
    cmp di, cx;
    jne @2;
    cmp bx, si;
    je @8;
@2: cmp byte ptr es:[di], chLF;
@8: pushf;
    call DecPtr;
    popf;
    jne @7;
    jmp @1;
@4: push di;
    push cx;
    push ax;
    call IsTextSeparator;
    pop cx;
    pop di;
    mov dl, False;
    or al, al;
    je @5;
    inc dl;
@5: cmp dl, SkipSep;
    jne @1;
@7: call IncPtr;
    jmp @6;
@1:
end;

procedure FindPrevSep(SkipSep: Boolean); assembler;
asm
    mov si, word ptr LineStart[0];
    mov cx, word ptr LineStart[2];
@6: or di, di;
    jne @3;
    or bx, bx;
    je @1;
@3: cmp di, si;
    jne @8;
    cmp bx, cx;
    je @1;
@8: call DecPtr;
    mov al, es:[di];
    call IncPtr;
    cmp al, EOLChar2;
    jne @4;
    cmp EOLMode, elFixLen;
    je @4;
    cmp EOLMode, elCRLF;
    jne @1;
    call DecPtr;
    or di, di;
    jne @2;
    or bx, bx;
    je @1;
@2: call DecPtr;
    cmp byte ptr es:[di], chCR;
    pushf;
    call IncPtr;
    call IncPtr;
    popf;
    jne @7;
    jmp @1;
@4: push di;
    push cx;
    push ax;
    call IsTextSeparator;
    pop cx;
    pop di;
    mov dl, False;
    or al, al;
    je @5;
    inc dl;
@5: cmp dl, SkipSep;
    jne @1;
@7: call DecPtr;
    jmp @6;
@1:
end;

procedure FindSeparator(Fore: Boolean); assembler;
asm
    mov bx, CurScrLine;
    shl bx, 2;
    mov ax, word ptr LineOffsets[bx][0];
    mov dx, word ptr LineOffsets[bx][2];
    mov word ptr LineStart[0], ax;
    mov word ptr LineStart[2], dx;
    mov ax, word ptr LineOffsets[bx][4];
    mov dx, word ptr LineOffsets[bx][6];
    cmp dx, word ptr ReadSize[2];
    ja @3;
    jne @4;
    cmp ax, word ptr ReadSize[0];
    jae @3;
@4: sub ax, 1;
    sbb dx, 0;
@3: mov word ptr LineEnd[0], ax;
    mov word ptr LineEnd[2], dx;
    mov di, word ptr CursorPos[0];
    mov bx, word ptr CursorPos[2];
    call UnpackPtr;
    cmp Fore, False;
    je @1;
    mov al, False;
    push ax;
    call FindNextSep;
    mov al, True;
    push ax;
    call FindNextSep;
    jmp @2;
@1: mov al, True;
    push ax;
    call FindPrevSep;
    mov al, False;
    push ax;
    call FindPrevSep;
@2: mov word ptr CursorPos[0], di;
    mov word ptr CursorPos[2], bx;
end;

procedure GotoSameCol; assembler;
asm
    mov cx, CurColumn;
    or cx, cx;
    je @1;
    xor si, si;
    mov di, word ptr CursorPos[0];
    mov bx, word ptr CursorPos[2];
    call UnpackPtr;
    mov ah, EOLChar;
    mov dl, TabMode;
@4: cmp di, word ptr ReadSize[0];
    jne @5;
    cmp bx, word ptr ReadSize[2];
    je @3;
@5: mov al, es:[di];
    cmp al, chTab;
    jne @6;
    cmp dl, False;
    je @6;
    cmp ViewMode, vmASCII;
    jne @6;
    push ax;
    push dx;
    mov ax, si;
    xor dx, dx;
    div TabSize;
    mul TabSize;
    add ax, TabSize;
    xchg ax, si;
    sub ax, si;
    neg ax;
    sub cx, ax;
    pop dx;
    pop ax;
    jc @3;
    pushf;
    call IncPtr;
    popf;
    jne @4;
    jmp @3;
@6: cmp al, ah;
    jne @2;
    cmp EOLMode, elFixLen;
    je @2;
    cmp EOLMode, elCRLF;
    jne @3;
    call IncPtr;
    cmp di, word ptr ReadSize[0];
    jne @7;
    cmp bx, word ptr ReadSize[2];
    jne @7;
    call DecPtr;
    jmp @2;
@7: cmp byte ptr es:[di], chLF;
    pushf;
    call DecPtr;
    popf;
    je @3;
@2: inc si;
    call IncPtr;
    loop @4;
@3: mov word ptr CursorPos[0], di;
    mov word ptr CursorPos[2], bx;
@1:
end;

function ScrollToLine(Line: Longint): Longint; assembler;
asm
    xor di, di;
    xor bx, bx;
    mov ax, word ptr Line[0];
    or ax, word ptr Line[2];
    je @9;
    call UnpackPtr;
    xor cx, cx;
    xor si, si;
    xor dx, dx;
    mov ah, EOLChar;
@5: cmp bx, word ptr ReadSize[2];
    jne @1;
    cmp di, word ptr ReadSize[0];
    je @2;
@1: mov al, es:[di];
    cmp al, ah;
    jne @3;
    cmp EOLMode, elFixLen;
    je @3;
    cmp EOLMode, elCRLF;
    jne @7;
    call IncPtr;
    cmp bx, word ptr ReadSize[2];
    jne @6;
    cmp di, word ptr ReadSize[0];
    je @2;
@6: cmp byte ptr es:[di], chLF;
    je @7;
    call DecPtr;
    jmp @3;
@7: call IncPtr;
@4: xor dx, dx;
    inc cx;
    jne @8;
    inc si;
@8: cmp cx, word ptr Line[0];
    jne @5;
    cmp si, word ptr Line[2];
    jne @5;
    jmp @2;
@3: cmp dx, WrapLen;
    jae @4;
    inc dx;
    call IncPtr;
    jmp @5;
@2: call PackPtr;
@9: mov ax, di;
    mov dx, bx;
end;

function CountLines(EndOffs: Longint): Longint; assembler;
asm
    xor di, di;
    xor bx, bx;
    call UnpackPtr;
    xor cx, cx;
    xor si, si;
    xor dx, dx;
    mov ah, EOLChar;
@5: cmp bx, word ptr EndOffs[2];
    jne @1;
    cmp di, word ptr EndOffs[0];
    je @2;
@1: mov al, es:[di];
    cmp al, ah;
    jne @3;
    cmp EOLMode, elFixLen;
    je @3;
    cmp EOLMode, elCRLF;
    jne @7;
    call IncPtr;
    cmp bx, word ptr EndOffs[2];
    jne @6;
    cmp di, word ptr EndOffs[0];
    je @2;
@6: cmp byte ptr es:[di], chLF;
    je @7;
    call DecPtr;
    jmp @3;
@7: call IncPtr;
@4: xor dx, dx;
    inc cx;
    jne @5;
    inc si;
    jmp @5;
@3: inc dx;
    cmp dx, WrapLen;
    jae @4;
    call IncPtr;
    jmp @5;
@2: mov ax, cx;
    mov dx, si;
end;

procedure ScrollToCursor;
begin
  if (CursorPos < WinStart) or (CursorPos >= WinEnd) then WinStart := CursorPos;
end;

procedure MoveToOffset(Offset: Longint);
var
  L             : Longint;
begin
  L := NewWinStart;
  NewWinStart := CursorPos;
  FindEOL(False, False, False, True);
  NewWinStart := L;
  if not EOLFound then
  begin
    Column := 0;
    NewWinStart := Offset;
  end;
  FindEOL(False, False, False, True);
  SaveOffsets;
  SimulateDraw;
end;

procedure SetEOLMode(Mode: Byte; Find: Boolean);
var
  C             : Word;
  M             : PHistory;
  A,
  P             : PHistoryItem;
  R             : TRect;
begin
  if Mode = MaxByte then
  begin
    ChangeHelpCtx(hcOnlyQuit);
    P := NewHistoryItem('F1', 'CR/LF', elCRLF + 1, True, nil);
    A := P;
    P := NewHistoryItem('F2', 'CR', elCR + 1, True, P);
    P := NewHistoryItem('F3', 'LF', elLF + 1, True, P);
    P := NewHistoryItem('F4', 'User: $' + HexaStr(Ord(EOLChars[3]), 2), elUser + 1, True, P);
    P := NewHistoryItem('F5', 'Fixed length: ' + LeadingSpace(FixLineLen, 0), elFixLen + 1, True, P);
    P := NewHistoryItem('F6', '--- Next ---', elNext + 1, True, P);
    R.Assign(4, 2, 15, 8);
    M := New(PHistory, Init(R, A, EOLMode, True));
    MakeWinBounds(R, 23, 6);
    PriorityMenu := New(PDialog, Init(R, 'Select line feed', fxNormal, fyNormal, False));
    PriorityMenu^.Insert(M);
    PriorityMenu^.Palette := wpHistory;
    C := Application^.ExecView(PriorityMenu, True, True);
    Dispose(PriorityMenu, Done);
    PriorityMenu := nil;
    Dec(HistoryItem);
    RestoreHelpCtx;
  end
  else
  begin
    HistoryItem := Mode;
    C := cmOK;
  end;
  if C = cmOK then
  begin
    if HistoryItem = elNext then EOLMode := (EOLMode + 1) and 3 else EOLMode := HistoryItem;
    EOLChar := EOLChars[EOLMode];
    if EOLMode = elCRLF then EOLChar2 := chLF else EOLChar2 := EOLChar;
    if EOLMode = elFixLen then
    begin
      WrapLen := FixLineLen;
      TabMode := False;
    end
    else
    begin
      WrapLen := MaxWrapLen;
    end;
    if Find and not HexaMode then FindEOL(False, True, False, False);
    CurLine := CountLines(CursorPos);
    LineNum := CountLines(ReadSize);
    LoadOffsets;
    if CursorPos >= WinEnd then NewWinStart := CursorPos;
    MoveToOffset(CursorPos);
    SeekOffset(CursorPos);
    SeekWin(True, False);
    Screen^.DrawView;
    KeyBar^.DrawView;
  end;
end;

(* ?ASM? *)
procedure CreateConvTable(Ofs: Word); assembler;
asm
    mov si, Ofs;
    mov di, Offset(TempBuffer);
    mov ConvTable, di;
    push ds;
    pop es;
    xor ah, ah;
    mov cx, 8;
    cld;
@2: lodsb;
    mov bl, al;
    push cx;
    mov cx, 32;
@1: mov al, ah;
    add al, bl;
    stosb;
    inc ah;
    loop @1;
    pop cx;
    loop @2;
end;

(* ?ASM? *)
procedure CorrectConvTable(Ofs: Word); assembler;
asm
    mov si, Ofs;
    mov di, Offset(TempBuffer);
    mov ConvTable, di;
    push di;
    push ds;
    pop es;
    mov cx, 256;
    cld;
    rep movsb;
    pop di;
    xor al, al;
    mov cx, 32;
@1: stosb;
    inc al;
    loop @1;
end;

procedure SetViewMode(Mode: Byte; Convert: Boolean);
var
  B             : Byte;
  C             : Word;
  M             : PHistory;
  A,
  P             : PHistoryItem;
  S             : string;
  R             : TRect;
begin
  if Mode = MaxByte then
  begin
    ChangeHelpCtx(hcOnlyQuit);
    P := NewHistoryItem('F1', 'ASCII', vmASCII + 1, True, nil);
    A := P;
    P := NewHistoryItem('F2', 'PETSCII', vmPETSCII + 1, True, P);
    P := NewHistoryItem('F3', 'Screen code', vmScreen + 1, True, P);
    if not Convert then P := NewHistoryItem('F8', '--- Next ---', vmNext + 1, True, P);
    S := '';
    if Convert then S := ' target';
    B := 5;
    if not Convert then Inc(B);
    R.Assign(4, 2, 13 + Length(S), B);
    M := New(PHistory, Init(R, A, ViewMode, True));
    MakeWinBounds(R, 20 + Length(S), B - 2);
    PriorityMenu := New(PDialog, Init(R, 'Select' + S + ' view mode', fxNormal, fyNormal, False));
    PriorityMenu^.Insert(M);
    PriorityMenu^.Palette := wpHistory;
    C := Application^.ExecView(PriorityMenu, True, True);
    Dispose(PriorityMenu, Done);
    PriorityMenu := nil;
    Dec(HistoryItem);
    RestoreHelpCtx;
  end
  else
  begin
    HistoryItem := Mode;
    C := cmOK;
  end;
  if C = cmOK then
  begin
    B := ViewMode;
    if HistoryItem = vmNext then ViewMode := (ViewMode + 1) mod 3 else ViewMode := HistoryItem;
    CharStartMode := ECharSetMode;
    if ViewMode = vmASCII then CharStartMode := CharSetMode and csLowerUpper;
    if Convert and (B <> ViewMode) then
    begin
      case B + ViewMode shl 2 of
        vmASCII + vmPETSCII shl 2: CorrectConvTable(Ofs(ASCtoPET));
        vmASCII + vmScreen shl 2: CorrectConvTable(Ofs(ASCtoSCR));
        vmPETSCII + vmASCII shl 2: if CharStartMode and csLowerUpper = 0 then CorrectConvTable(Ofs(PETtoASCLower))
          else CorrectConvTable(Ofs(PETtoASCUpper));
        vmPETSCII + vmScreen shl 2: CreateConvTable(Ofs(PETtoSCR));
        vmScreen + vmASCII shl 2: if CharStartMode and csLowerUpper = 0 then ConvTable := Ofs(SCRtoASCLower)
          else ConvTable := Ofs(SCRtoASCUpper);
        vmScreen + vmPETSCII shl 2: CreateConvTable(Ofs(SCRtoPET));
      end;
      asm
        xor di, di;
        xor bx, bx;
        call UnpackPtr;
        mov cx, ConvTable;
    @3: cmp di, word ptr ReadSize[0];
        jne @1;
        cmp bx, word ptr ReadSize[2];
        je @2;
    @1: mov al, es:[di];
        xchg bx, cx;
        xlat;
        xchg bx, cx;
        mov es:[di], al;
        call IncPtr;
        jmp @3;
    @2:
      end;
      BufferChanged := True;
      MakeTitle;
    end;
    Application^.SetCharSet(CharStartMode, True, False);
    MakeTitle;
    Screen^.DrawView;
    KeyBar^.DrawView;
  end;
end;

procedure SetMiniHelpMode(Mode: Byte);
var
  B,
  M             : Byte;
  R             : TRect;
begin
  M := MiniHelpMode;
  MiniHelpMode := Mode;
  if MiniHelpMode = mhNone then
  begin
    ScrSize := WinSize;
  end
  else
  begin
    MiniHelp^.Show;
    ScrSize := WinSize - HelpHeight;
  end;
  if (M = mhNone) and (MiniHelpMode <> mhNone) and (CurScrLine >= ScrSize) then
  begin
    for B := 0 to CurScrLine - ScrSize do
    begin
      LoadOffsets;
      FindEOL(True, True, True, True);
    end;
    LoadOffsets;
    SeekWin(False, False);
  end
  else
  begin
    SeekWin(True, False);
  end;
  R.Assign(0, 1, ScreenWidth, ScrSize + 1);
  Screen^.ChangeBounds(R);
  if MiniHelpMode = mhNone then MiniHelp^.Hide;
  MiniHelp^.DrawView;
end;

procedure FileType(Enable: Boolean);
var
  M             : Byte;
  L             : Longint;
  E,
  N,
  P             : string;
begin
  LongFSplit(LongFExpand(FullName), P, N, E);
  N := LowerCase(N + E);
  M := mhNone;
  MenuBar^.DisableCommands([cmEMiniHelp]);
  if Resident and ShellBuffer^.EditSpecFile and (P = HomePath) then
  begin
    if (N = ExtensionFileName) or (N = ViewerExtFileName) or (N = EditorExtFileName) then M := mhExtension else
      if N = UserMenuFileName then M := mhMenu;
  end;
  DefMiniHelpMode := M;
  if M <> mhNone then MenuBar^.EnableCommands([cmEMiniHelp]);
  SetMiniHelpMode(M);
  if ImageOn then
  begin
    E := LowerCase(Copy(ImageExt, 2, 3));
    if (IsDiskExt(E)) and (GetDiskType(ReadSize) <> dtInvalid) then PanelNewMode := pmDisk else
      if (E = 't64') and (ReadSize > 95) then PanelNewMode := pmTape else if (E = 'lnx') and (ReadSize >= 254)
      then PanelNewMode := pmLynx else if (E = 'ark') and (ReadSize >= 254) then PanelNewMode := pmArkive else
      if (E = 'tar') and (ReadSize >= 512) then PanelNewMode := pmTAR else
      if (E[1] in ['p', 'r', 's', 'u']) and (E[2] in ['0'..'9']) and (E[3] in ['0'..'9']) and (ReadSize > 25) then
      PanelNewMode := pmFile;
  end;
end;

procedure SetReplaceMode;
begin
  if ReplaceMode then ContSearchStatus^.Text^ := 'Replac' else ContSearchStatus^.Text^ := 'Search';
end;

procedure SetLoadAddressMode;
begin
  if ShowLoadAddr then LoadAddrStatus^.Text^ := 'AdrOff' else LoadAddrStatus^.Text^ := 'AdrOn ';
end;

procedure SetSymbolMode;
begin
  if ShowSymbols then SymbolStatus^.Text^ := 'SymOff' else SymbolStatus^.Text^ := 'SymOn ';
end;

procedure InitEditor;
begin
  BufferChanged := False;
  QuoteMode := False;
  SearchMode := False;
  AllOverwrite := ayNone;
  MustSaveFile := False;
  InsertModes[False] := True;
  InsertModes[True] := False;
  ReplaceModes[False] := rmInsert;
  ReplaceModes[True] := rmOverwrite;
  EditMarking := False;
  EditMarked := False;
  TextMode := False;
  EditChar := 0;
  WrapLen := MaxWrapLen;
  Line := 0;
  CurLine := 0;
  CurColumn := 0;
  CurRealCol := 0;
  CursorPos := 0;
  SetReplaceMode;
  SetSymbolMode;
  SetLoadAddressMode;
end;

procedure MoveSelMarks(Change: Longint);

procedure MoveMark(var Mark: Longint);
var
  L             : Longint;
begin
  if Mark >= CursorPos then
  begin
    if Mark < CursorPos - Change then
    begin
      Mark := CursorPos;
    end
    else
    begin
      L := Mark - CursorPos;
      if L > Change then L := Change;
      Inc(Mark, L);
    end;
  end;
end;

begin
  MoveMark(SelectLStart);
  MoveMark(SelectLEnd);
end;

function GetFileName(const Title, Text: string; var Result: string): Boolean;
var
  C             : Word;
  D             : PDialog;
  I             : PNameInputLine;
  T             : string;
  R             : TRect;
begin
  T := Title;
  if T = '' then T := BoxTitle;
  MakeWinBounds(R, 66, 2);
  GetMouse(True);
  D := New(PDialog, Init(R, T, fxNormal, fyNormal, False));
  R.Assign(5, 2, 64, 2);
  I := New(PNameInputLine, Init(R, 64, MaxFileNameLen, Text, drUp));
  I^.SetData(Result);
  D^.Insert(I);
  C := Application^.ExecView(D, True, True);
  if C = cmOK then
  begin
    I^.GetData(Result);
    MakeTitle;
  end;
  Dispose(D, Done);
  GetFileName := ((C = cmOK) and (Result <> ''));
  SetMouse;
end;

procedure SelectMin; assembler;
asm
    cmp al, False;
    jne @1;
    not bp;
@1: inc bp;
    or bp, bp;
    je @2;
    cmp bx, bp;
    jbe @2;
    mov bx, bp;
@2:
end;

procedure NextSeg; assembler;
asm
    push bp;
    xor bp, bp;
    cmp al, False;
    je @3;
    not bp;
@3: cmp bx, bp;
    pop bp;
    jne @1;
    mov bx, $1000;
    cmp al, False;
    je @2;
    neg bx;
@2: add bp, bx;
@1:
end;

procedure CopyPart; assembler;
asm
    mov bx, MaxWord;
    or dx, dx;
    jne @1;
    or cx, cx;
    stc;
    je @2;
    mov bx, cx;
@1: mov bp, si;
    call SelectMin;
    mov bp, di;
    call SelectMin;
    push cx;
    mov cx, bx;
    cmp cx, 2;
    jb @3;
    cmp al, False;
    je @4;
    dec si;
    dec di;
@4: shr cx, 1;
    pushf;
    je @5;
    rep movsw;
@5: cmp al, False;
    je @6;
    inc si;
    inc di;
@6: popf;
    jnc @7;
@3: movsb;
@7: pop cx;
    sub cx, bx;
    sbb dx, 0;
    mov bx, si;
    mov bp, ds;
    call NextSeg;
    mov ds, bp;
    mov bx, di;
    mov bp, es;
    call NextSeg;
    mov es, bp;
    clc;
@2:
end;

procedure BlockCopy(Src, _End, Dest: Longint); assembler;
asm
    push ds;
    push bp;
    mov cx, word ptr _End[0];
    mov dx, word ptr _End[2];
    mov di, word ptr Src[0];
    mov bx, word ptr Src[2];
    sub cx, di;
    sbb dx, bx;
    mov ax, cx;
    or ax, dx;
    je @1;
    mov si, word ptr Dest[0];
    mov ax, word ptr Dest[2];
    cmp bx, ax;
    ja @2;
    jne @3;
    cmp di, si;
    je @1;
    ja @2;
@3: mov di, word ptr _End[0];
    mov bx, word ptr _End[2];
    mov bp, ax;
    add si, cx;
    adc bp, dx;
    call UnpackPtr;
    xchg si, di;
    push es;
    mov bx, bp;
    call UnpackPtr;
    pop ds;
    call DecPtr;
    or si, si;
    jne @6;
    mov bx, ds;
    sub bx, $1000;
    mov ds, bx;
@6: dec si;
    mov al, True;
@4: std;
    call CopyPart;
    jnc @4;
    jmp @1;
@2: mov bp, ax;
    call UnpackPtr;
    xchg si, di;
    push es;
    mov bx, bp;
    call UnpackPtr;
    pop ds;
    mov al, False;
@5: cld;
    call CopyPart;
    jnc @5;
@1: pop bp;
    pop ds;
end;

procedure OpenFile(Insert: Boolean);
var
  B,
  F             : Boolean;
  W             : Word;
  I,
  X,
  Y,
  Z             : Integer;
  L             : Longint;
  D             : PDialog;
  E,
  S,
  T             : string;
begin
  if not Insert or (PanelMode = pmDOS) then
  begin
    SysErrorOccurred := False;
    if (PanelMode = pmDisk) and (OpenImage(False) = 0) then CloseImage(False);
    if Insert then
    begin
      B := GetFileName(stEmpty, 'Insert from the file', InsertName);
      InsertName := CloneDOSName(FullName, InsertName);
    end
    else
    begin
      B := True;
    end;
    I := 255;
    if B then
    begin
      MakeFullName;
      if Insert then
      begin
        S := LongName(InsertName, True);
        T := 'Insert';
      end
      else
      begin
        S := FullName;
        T := 'Read';
      end;
      D := InfoWin(stEmpty, T + 'ing the file', S, stEmpty, 2);
      PanelNewMode := PanelMode;
      I := IOResult;
      case PanelMode of
        pmDOS:
        begin
          if Insert then
          begin
            I := LongOpenFile(InsertName, ReadFile, fmReadOnly);
            if I = 0 then L := ExtFileSize(ReadFile);
          end
          else
          begin
            LongGetFAttr(FullName, FileAttr);
            I := LongOpenFile(FullName, ReadFile, fmReadOnly);
            if I = 2 then
            begin
              T := GetPath(FullName, chDirSep);
              E := CutPath(FullName, chDirSep);
              S := CorrectDOSName(E, False);
              if UpperCase(E) <> UpperCase(S) then
              begin
                S := AddToPath(T, S, chDirSep);
                I := LongOpenFile(S, ReadFile, fmReadOnly);
                if I = 0 then
                begin
                  ImageName := S;
                  FullName := ImageName;
                end;
              end;
            end;
            FileTime := ReadTime;
            BufferSize := DOSHeapSize;
            FileOpen := (I = 0);
            if FileOpen then
            begin
              ReadOffset := 0;
              ReadSize := ExtFileSize(ReadFile);
              FileType(EnableMiniHelp);
              if ImageOn and (PanelNewMode <> pmDOS) then
              begin
                PanelMode := PanelNewMode;
                if OpenImage(False) = 0 then
                begin
                  ImageOn := False;
                  while not ImageOn and (ReadCBMEntry(Entry)) do ImageOn := (Entry.Attr > 0);
                  ExtClose(Image);
                end;
                if not ImageOn then PanelNewMode := pmDOS;
                PanelMode := pmDOS;
              end;
            end;
          end;
        end;
        pmDisk, pmTape, pmLynx..pmTAR:
        begin
          I := OpenImage(False);
          FileOpen := (I = 0);
          if FileOpen then
          begin
            F := False;
            while not F and not Escape and ReadCBMEntry(Entry) do
              F := ((ReadDirPos < MaxWord) and (DirPos = ReadDirPos)) or ((Entry.Attr > 0) and (Entry.Name = ReadName));
            F := F and (Entry.Attr > 0) and (Entry.Name = ReadName);
            if F then F := (Entry.ExtAttr and xaGEOSVLIR = 0);
            if F then
            begin
              if not Insert then FileAttr := Entry.Attr;
              case PanelMode of
                pmDisk:
                begin
                  ReadSize := 0;
                  LastLoc := 0;
                  FirstTrack := Track;
                  FirstSector := Sector;
                  while (Track > 0) and (Track < MaxTrack) and (Sector < SectorNum(Track)) and
                    (LastLoc < MaxLocations) do
                  begin
                    Locations^[LastLoc].Track := Track;
                    Locations^[LastLoc].Sector := Sector;
                    Inc(LastLoc);
                    ReadDiskBlock(Track, Sector, @DataBuffer);
                    Track := DataBuffer[0];
                    Sector := DataBuffer[1];
                    if Track > 0 then Inc(ReadSize, 254);
                  end;
                  BufferSize := ReadSize + 254;
                  if Track = 0 then
                  begin
                    if Sector = 0 then Inc(Sector);
                    Inc(ReadSize, Sector - 1);
                  end
                  else
                  begin
                    ErrorWin(stEmpty, 'The file ' + S, 'is corrupted.', CurHelpCtx, sbNone);
                  end;
                end;
                pmTape:
                begin
                  LoadAddr := Entry.Start;
                  ReadOffset := ImagePos - 2;
                  TapeDirOffs := DirPos shl 5;
                  ReadCBMEntry(Entry);
                  ReadSize := ImagePos - ReadOffset;
                  BufferSize := ReadSize;
                end;
                pmLynx..pmTAR:
                begin
                  ReadOffset := ImagePos;
                  ReadSize := Entry.Size;
                  BufferSize := ReadSize;
                end;
              end;
            end
            else
            begin
              I := 255;
            end;
          end;
        end;
        pmFile:
        begin
          I := OpenImage(False);
          FileOpen := (I = 0);
          if FileOpen then
          begin
            if not Insert then FileAttr := (faDeleted + faClosed);
            ReadOffset := 26;
            ReadSize := ExtFileSize(Image) - 26;
          end;
          BufferSize := ReadSize;
        end;
      end;
      if not Insert then
      begin
        EOLMode := elCRLF;
        TabMode := True;
        Column := 0;
        SelectStart := 0;
        SelectEnd := 0;
        EditBuffer := DOSHeap;
      end;
      case I of
        0:
        begin
          if Insert then
          begin
            if FreeSize < L then
            begin
              CloseFile;
              ErrorWin(stEmpty, 'There is not enough room to insert the file', S, hcOnlyQuit, sbNone);
              ReadingFile := False;
            end
            else
            begin
              BlockCopy(CursorPos, ReadSize, CursorPos + L);
              ReadWholeFile(CursorPos, L);
              CloseFile;
              ReadingFile := False;
              BufferChanged := True;
              Inc(ReadSize, L);
              MoveSelMarks(L);
              LineNum := CountLines(ReadSize);
              SeekWin(True, False);
              MakeTitle;
              Screen^.DrawView;
            end;
          end
          else
          begin
            if DOSHeapSize < ReadSize then
            begin
              S := 'The file ' + FullName;
              T := 'is too large for '+ BoxTitle + stDot;
              if Resident and Standard and (ShellBuffer^.BatchMode = bmNone) then
              begin
                if SureConfirm(stEmpty, S, T, stEmpty, stEmpty, ' '+ColorChar+'V'+ColorChar+'iew ',
                  stEmpty, stEmpty, stEmpty, stEmpty, nil, hcOnlyQuit, ayNone, True, DummyByte) = cmOK then
                  ShellBuffer^.EditStatus := ShellBuffer^.EditStatus or cfRetryView;
              end
              else
              begin
                MakeSound := False;
                ErrorWin(stEmpty, S, T, hcOnlyQuit, sbNone);
              end;
              I := 254;
            end
            else
            begin
              WinStart := 0;
              FileOK := ReadWholeFile(0, ReadSize);
              CloseFile;
              ReadingFile := False;
              if FileOK then
              begin
                InitEditor;
                W := ReadSize;
                if W > CheckDataLen then W := CheckDataLen;
(* ?ASM? *)
                asm
                  xor di, di;
                  mov X, di;
                  mov Y, di;
                  mov Z, di;
                  mov es, word ptr EditBuffer[2];
                  mov cx, MaxWord;
                  cmp word ptr BufferSize[2], 0;
                  jne @10;
                  mov cx, word ptr BufferSize[0];
              @10:xor ah, ah;
                  cld;
              @5: cmp di, W;
                  jae @2;
                  mov al, es:[di];
                  inc di;
                  or al, al;
                  jne @1;
                  mov TabMode, False;
                  jmp @4;
              @1: cmp al, chLF;
                  jne @3;
                  inc Z;
                  jmp @4;
              @3: cmp al, chCR;
                  jne @4;
                  cmp di, W;
                  jae @9;
                  mov al, es:[di];
                  cmp al, chLF;
                  je @6;
              @9: inc Y;
                  jmp @4;
              @6: inc X;
                  inc di;
              @4: loop @5;
              @2: mov al, elCRLF;
                  mov bx, X;
                  cmp bx, Y;
                  jae @7;
                  mov bx, Y;
                  mov al, elCR;
              @7: cmp bx, Z;
                  jae @8;
                  mov al, elLF;
              @8: mov EOLMode, al;
                end;
              end;
            end;
          end;
        end;
        2, 3, 255:
        begin
          if (PanelMode = pmDOS) and not Insert then
          begin
            if (Resident and ShellBuffer^.EditSpecFile) or (SureConfirm(stEmpty, 'Can''t open the file', FullName,
              stEmpty, stEmpty, ' '+ColorChar+'N'+ColorChar+'ew file ', stEmpty, stEmpty, stEmpty, stEmpty, nil, hcOnlyQuit,
              ayNone, False, DummyByte) = cmOK) then
            begin
              FileOK := True;
              ImageOn := False;
              FileType(EnableMiniHelp);
              ReadingFile := False;
              FileAttr := Archive;
              ReadSize := 0;
              I := 0;
              B := True;
            end;
          end
          else
          begin
            if not SysErrorOccurred then
            begin
              MakeSound := False;
              if Entry.ExtAttr and xaGEOSVLIR = 0 then ErrorWin(stEmpty, 'Can''t open the file', FullName,
                hcOnlyQuit, sbNone) else ErrorWin(stEmpty, S, 'is a GEOS VLIR file.', hcOnlyQuit, sbNone);
            end;
          end;
        end;
      end;
      if not Insert then
      begin
        if PanelMode = pmDOS then
        begin
          MenuBar^.EnableCommands([cmESaveAs, cmEInsert, cmEAppend]);
        end
        else
        begin
          MenuBar^.DisableCommands([cmESaveAs, cmEInsert, cmEAppend]);
        end;
        if I = 0 then
        begin
          SetEOLMode(EOLMode, False);
          if (PanelMode <> pmDOS) and (ViewMode = vmASCII) then SetViewMode(vmPETSCII, False);
        end;
      end;
      Dispose(D, Done);
      ErrorDown := 0;
    end;
  end;
end;

procedure SaveFile(SaveAs, Append: Boolean);
var
  B,
  O             : Boolean;
  M             : Byte;
  C,
  X             : Word;
  I             : Integer;
  L             : Longint;
  P             : Pointer;
  D             : PDialog;
  F             : PExtFile;
  E,
  N,
  S,
  T,
  U             : string;
begin
  M := PanelMode;
  if not SaveAs or (M = pmDOS) then
  begin
    B := False;
    if Append then
    begin
      if SelectEnd > SelectStart then
      begin
        B := GetFileName(stEmpty, 'Append block to the file', AppendName);
        AppendName := AddToPath(GetPath(AppendName, chDirSep),
          CloneDOSName(FullName, CutPath(AppendName, chDirSep)), chDirSep);
        M := pmDOS;
      end;
    end
    else
    begin
      B := True;
      if SaveAs then
      begin
        S := FullName;
        B := GetFileName(stEmpty, 'Save file as', S);
        FullName := CloneDOSName(FullName, S);
        if B then ImageName := FullName;
        LongFSplit(ImageName, S, T, ImageExt);
        PanelNewMode := pmDOS;
        ImageOn := True;
        LongGetFAttr(FullName, FileAttr);
        if IOResult > 0 then FileAttr := Archive;
        FileType(EnableMiniHelp);
        SeekWin(True, False);
        MakeTitle;
        Screen^.DrawView;
      end;
    end;
    if B then
    begin
      if Append then S := AppendName else S := FullName;
      D := InfoWin(stEmpty, 'Saving the file', S, stEmpty, 2);
      I := 0;
      if M = pmDOS then
      begin
        U := '';
        if (FileAttr and SysFile > 0) then U := 'system' else if (FileAttr and Hidden > 0) then U := 'hidden' else
          if (FileAttr and ReadOnly > 0) then U := 'read-only';
        O := True;
        B := (U <> '');
        if B then
        begin
          if Append then T := 'append' else T := 'overwrite';
          O := (SureConfirm(stEmpty, S, 'is a ' + U + ' file.', 'Do you still wish to ' + T + ' it?', stEmpty,
            stYes, stEmpty, stEmpty, stEmpty, stNo, nil, CurHelpCtx, ayNone, False, DummyByte) = cmOK);
        end;
      end
      else
      begin
        if ImageReadOnly then
        begin
          ErrorWin(stEmpty, 'The following image file is marked read-only.', ImageName, CurHelpCtx, sbNone);
          O := False;
        end
        else
        begin
          B := False;
          O := ((FileAttr and faWriteProt = 0) or (SureConfirm(stEmpty, S, 'is write protected.',
            'Do you still wish to overwrite it?', stEmpty, stYes, stEmpty, stEmpty, stEmpty, stNo,
            nil, CurHelpCtx, ayNone, False, DummyByte) = cmOK));
        end;
      end;
      if O then
      begin
        P := EditBuffer;
        case M of
          pmDOS, pmTape, pmFile, pmLynx..pmTAR:
          begin
            if Append then
            begin
              T := AppendName;
              FarInc(P, SelectStart);
            end
            else
            begin
              T := FullName;
            end;
            if B then LongSetFAttr(T, FileAttr and not (ReadOnly + Hidden + SysFile));
            I := IOResult;
            if M = pmDOS then
            begin
              if Append then
              begin
                L := SelectSize;
                I := LongOpenFile(T, ReadFile, fmReadWrite);
                if I = 0 then
                begin
                  F := @ReadFile;
                end
                else
                begin
                  I := LongOpenFile(T, WriteFile, fmWriteOnly);
                  F := @WriteFile;
                end;
              end
              else
              begin
                I := 0;
                if BackupFiles then
                begin
                  LongFSplit(T, U, N, E);
                  U := U + N + '.bak';
                  if FileExists(U, False) then LongErase(U);
                  LongRename(T, U);
                  I := IOResult;
                  if I > 0 then
                  begin
                    I := 255;
                    if SureConfirm(stEmpty, 'There was an error backing up the file', S, 'Do you still wish to save?',
                      stEmpty, stYes, stEmpty, stEmpty, stEmpty, stNo, nil, CurHelpCtx, ayNone, False, DummyByte) = cmOK then
                      I := 0;
                  end;
                end;
                if I = 0 then
                begin
                  L := ReadSize;
                  I := LongOpenFile(T, WriteFile, fmWriteOnly);
                  F := @WriteFile;
                end;
              end;
            end
            else
            begin
              asm
                mov di, word ptr ReadSize[0];
                mov bx, word ptr ReadSize[2];
                mov cx, word ptr BufferSize[0];
                mov dx, word ptr BufferSize[2];
                sub cx, di;
                sbb dx, ax;
                mov ax, cx;
                or ax, dx;
                je @1;
                call UnpackPtr;
                xor al, al;
            @3: mov es:[di], al;
                call IncPtr;
                or cx, cx;
                jne @2;
                or dx, dx;
                je @1;
                dec dx;
            @2: dec cx;
                jmp @3;
            @1:
              end;
              I := LongOpenFile(ImageName, ReadFile, fmReadWrite);
              L := BufferSize;
              F := @ReadFile;
            end;
            if I = 0 then
            begin
              if M = pmTape then
              begin
                LoadAddr := 0;
                if BufferSize > 0 then LoadAddr := PBuffer(EditBuffer)^[0];
                if BufferSize > 1 then LoadAddr := LoadAddr + (PBuffer(EditBuffer)^[1] shl 8);
                ExtSeek(F^, TapeDirOffs + 2);
                ExtBlockWrite(F^, LoadAddr, 2);
                C := LoadAddr + BufferSize - 2;
                ExtBlockWrite(F^, C, 2);
                ExtSeek(F^, ReadOffset + 2);
                Dec(L, 2);
                FarInc(P, 2);
              end
              else
              begin
                if M <> pmDOS then ExtSeek(F^, ReadOffset);
              end;
              if Append then ExtSeek(F^, ExtFileSize(F^));
              while L > 0 do
              begin
                if L > TSmallBufSize then C := TSmallBufSize else C := L;
                Dec(L, C);
                ExtBlockWrite(F^, P^, C);
                FarInc(P, C);
              end;
            end;
            if KeepTime and (M <> pmDOS) then ExtSetFTime(F^, FileTime);
            if M = pmDOS then ExtTruncate(F^);
            ExtClose(F^);
            if B then LongSetFAttr(F^.LongName, FileAttr);
          end;
          pmDisk:
          begin
            I := OpenImage(True);
            if I = 0 then
            begin
              X := 0;
              L := ReadSize;
              while X < LastLoc do
              begin
                Track := Locations^[X].Track;
                Sector := Locations^[X].Sector;
                Inc(X);
                if X < LastLoc then
                begin
                  DataBuffer[0] := Locations^[X].Track;
                  DataBuffer[1] := Locations^[X].Sector;
                  if L > 254 then C := 254 else C := L;
                end
                else
                begin
                  DataBuffer[0] := 0;
                  if L = 0 then L := 1;
                  if L > 254 then C := 254 else C := L;
                  DataBuffer[1] := C + 1;
                  FillChar(DataBuffer[2], 254, 0);
                end;
                if L > 0 then Move(P^, DataBuffer[2], C) else FillChar(DataBuffer[2], 254, 0);
                FarInc(P, C);
                if L > C then Dec(L, C) else L := 0;
                WriteDiskBlock(Track, Sector, @DataBuffer);
              end;
              CloseImage(True);
            end;
          end;
        end;
        if I = 0 then
        begin
          BufferChanged := False;
          Screen^.DrawView;
        end
        else
        begin
          if I <> 255 then ErrorWin(stEmpty, 'There was an error writing the file', S, CurHelpCtx, sbNone);
        end;
      end;
      Dispose(D, Done);
      ErrorDown := 0;
    end;
  end;
end;

function GetTextOrHex(const Title, TextLabel, HexLabel, Text2Label, Hex2Label: string; var DefText, DefHex, Result,
  DefText2, DefHex2, Result2: string; var InHex: Boolean; Help: Word): Boolean;
var
  B,
  F,
  O             : Boolean;
  C,
  H             : Word;
  Y             : Integer;
  D             : PDialog;
  I1,
  I3            : PTextInput;
  I2,
  I4            : PCodeInput;
  S,
  T             : string;
  R             : TRect;
begin
  H := CurHelpCtx;
  O := HelpCtxSet;
  HelpCtxSet := True;
  CurHelpCtx := Help;
  AppHelpCtx := Help;
  LastShiftState := MaxByte;
  T := Title;
  if T = '' then T := BoxTitle;
  B := (Text2Label <> '');
  if B then Y := 8 else Y := 4;
  MakeWinBounds(R, 66, Y);
  GetMouse(True);
  D := New(PDialog, Init(R, T, fxNormal, fyNormal, True));
  R.Assign(5, 2, 64, 2);
  I1 := New(PTextInput, Init(R, 64, MaxByte, TextLabel, drUp));
  I1^.SetData(DefText);
  D^.Insert(I1);
  R.Assign(5, 4, CBMStrLen(HexLabel), 1);
  D^.Insert(New(PStaticText, Init(R, HexLabel)));
  R.Assign(5, 5, 64, 1);
  I2 := New(PCodeInput, Init(R, 64, MaxByte));
  I2^.SetData(DefHex);
  D^.Insert(I2);
  I1^.ConvertEOL := False;
  I1^.CodeInput := I2;
  I2^.TextInput := I1;
  I4 := nil;
  if B then
  begin
    R.Assign(5, 6, 64, 2);
    I3 := New(PTextInput, Init(R, 64, MaxByte, Text2Label, drUp));
    I3^.SetData(DefText2);
    D^.Insert(I3);
    R.Assign(5, 8, CBMStrLen(Hex2Label), 1);
    D^.Insert(New(PStaticText, Init(R, Hex2Label)));
    R.Assign(5, 9, 64, 1);
    I4 := New(PCodeInput, Init(R, 64, MaxByte));
    I4^.SetData(DefHex2);
    D^.Insert(I4);
    I3^.ConvertEOL := False;
    I3^.CodeInput := I4;
    I4^.TextInput := I3;
  end;
  I1^.Select;
  if InHex then I2^.Select;
  C := Application^.ExecView(D, True, True);
  F := (C = cmOK);
  SetMouse;
  if F then
  begin
    InHex := I2^.GetState(sfSelected) or (B and (I4^.GetState(sfSelected)));
    I1^.GetData(DefText);
    I2^.GetData(DefHex);
    if B then
    begin
      I3^.GetData(DefText2);
      I4^.GetData(DefHex2);
    end;
    if InHex then
    begin
      Result := HexToText(DefHex, True);
      if B then Result2 := HexToText(DefHex2, True);
    end
    else
    begin
      Result := DefText;
      if B then Result2 := DefText2;
    end;
    if Result = '' then F := False;
  end;
  Dispose(D, Done);
  GetTextOrHex := F;
  CurHelpCtx := H;
  AppHelpCtx := H;
  HelpCtxSet := O;
  LastShiftState := MaxByte;
end;

function ConfirmQuit(Ask: Boolean): Boolean;
var
  O             : Boolean;
  C             : Word;
begin
  O := not BufferChanged;
  C := cmCancel;
  if not O then
  begin
    C := cmOK;
    if Ask then C := SureConfirm(stEmpty, 'You''ve made changes since the last save.',
      stEmpty, stEmpty, stEmpty, stSave, ' '+ColorChar+'D'+ColorChar+'on''t save ', stEmpty, stEmpty,
      ' '+ColorChar+'C'+ColorChar+'ontinue editing ', nil, CurHelpCtx, ayNone, True, DummyByte);
    O := (C <> cmCancel);
  end;
  if C = cmOK then SaveFile(False, False);
  ConfirmQuit := O;
end;

procedure SelectFile;
var
  O             : Boolean;
  A             : Byte;
  Z             : Word;
  I,
  W,
  Y             : Integer;
  S,
  T             : string;

procedure InsertEntry;
begin
  W := InsName(Entry.Name);
  if W >= 0 then
  begin
    PanelDir^[Z].Name := W;
    PanelDir^[Z].ExtAttr := Entry.ExtAttr;
    PanelDir^[Z].Attr := Entry.Attr;
    PanelDir^[Z].Time := Entry.Time;
    LongintToLonglongint(PanelDir^[Z].Size, Entry.Size);
    PanelDir^[Z].DirPos := Entry.DirPos;
    PanelDir^[Z].Status := fsNormal;
    Inc(Z);
  end;
end;

begin
  AllErrorSkip := ayNone;
  if PanelNewMode <> pmDOS then
  begin
    if not BufferChanged or ConfirmQuit(True) then
    begin
      BufferChanged := False;
      MakeTitle;
      OrigViewMode := ViewMode;
      if DOSHeapSize <= SizeOf(TDirBuffer) + SizeOf(TNameBuffer) + 16 then
      begin
        ErrorWin(stEmpty, 'Not enough memory to load directory of', ImageName, CurHelpCtx, sbNone);
      end
      else
      begin
        EditBuffer := nil;
        ChangeHelpCtx(hcESelectFile);
        PanelMode := PanelNewMode;
        Z := 0;
        PanelMax := 0;
        NameEnd := 0;
        ReadingFile := True;
        QuoteMode := False;
        TextMode := False;
        MakeFullName;
        PanelDir := DOSHeap;
        PanelNames := Ptr(Seg(DOSHeap^) + (SizeOf(TDirBuffer) shr 4) + 1, Ofs(DOSHeap^));
        T := MakeTypeStr(PanelMode);
        case PanelMode of
          pmDisk..pmFile: T := LowerCase(T) + ' image';
          pmLynx..pmFileZip: T := T + ' archive';
        end;
        Screen^.DrawView;
        DirMode := True;
        I := OpenImage(False);
        if I = 0 then
        begin
          MakeTitle;
          DeltaY := 0;
          Screen^.DrawView;
          if (PanelMode in [pmDisk, pmTAR]) and (ImagePath <> '') then
          begin
            PanelDir^[0].Name := InsName(stParentDir);
            PanelDir^[0].ExtAttr := xaDirectory;
            PanelDir^[0].Attr := (faPartition + faClosed);
            LongintToLonglongint(PanelDir^[0].Size, 0);
            Inc(Z);
          end;
          while (ReadCBMEntry(Entry)) and (Z < MaxFiles) do
          begin
            case PanelMode of
              pmTape: if Z > 0 then
                LongintToLonglongint(PanelDir^[Z - 1].Size, ImagePos - LonglongintToLongint(PanelDir^[Z - 1].Size) + 2);
              pmTAR:
              begin
                A := Entry.Attr;
                if Z > 0 then
                begin
                  Y := 0;
                  while (A > 0) and (Y < Z) do if GetNamePtr(Y)^ = Entry.Name then A := 0 else Inc(Y);
                  Entry.Attr := A;
                end;
              end;
            end;
            if PanelMode in [pmLynx, pmArkive, pmTAR] then
            begin
              if StartInfo and (Entry.Size >= 2) then
              begin
                ExtSeek(Image, ImagePos);
                ExtBlockRead(Image, Entry.Start, 2);
              end;
            end;
            if Entry.Attr > 0 then InsertEntry;
          end;
          if (PanelMode = pmTape) and (Z > 0)
            then LongintToLonglongint(PanelDir^[Z - 1].Size, ImagePos - LonglongintToLongint(PanelDir^[Z - 1].Size) + 2);
          CloseImage(False);
          PanelCur := 0;
          if ReadDirPos = MaxWord then while (PanelCur < Z) and (GetNamePtr(PanelCur)^ <> ReadName) do Inc(PanelCur) else
            while (PanelCur < Z) and (PanelDir^[PanelCur].DirPos <> ReadDirPos) do Inc(PanelCur);
          if GetNamePtr(PanelCur)^ <> ReadName then PanelCur := Z;
          if PanelCur < Z then
          begin
            if PanelCur < DeltaY then DeltaY := PanelCur;
            if PanelCur > DeltaY + PanLen - 1 then DeltaY := PanelCur - PanLen + 1;
            if DeltaY + PanLen > Z then
            begin
              if Z > PanLen - 1 then DeltaY := Z - PanLen else DeltaY := 0;
            end;
          end
          else
          begin
            PanelCur := 0;
            DeltaY := 0;
          end;
          ViewMode := vmPETSCII;
          CharStartMode := ECharSetMode;
          Application^.SetCharSet(CharStartMode, True, False);
          MakeTitle;
          Screen^.DrawView;
          if Z = 0 then
          begin
            MakeSound := False;
            ErrorWin(stEmpty, 'There are no files in', ImageName, CurHelpCtx, sbNone);
          end;
        end
        else
        begin
          PanelDir := nil;
          PanelNames := nil;
          if I = 255 then ErrorWin(stEmpty, stTheFollowing + T + stIsInvalid + stDot, ImageName, CurHelpCtx, sbNone);
        end;
        if Z = 0 then
        begin
          RestoreHelpCtx;
          ViewMode := OrigViewMode;
          PanelMode := pmDOS;
          ImageOn := False;
          MenuBar^.DisableCommands([cmESelectFile]);
          PanelDir := nil;
          PanelNames := nil;
          ReadingFile := True;
          MakeFullName;
          DirMode := False;
          OpenFile(False);
          MakeTitle;
        end;
        PanelMax := Z;
        Screen^.DrawView;
      end;
    end;
  end;
end;

procedure SetHexaMode(On, Find: Boolean);
begin
  HexaMode := On;
  Screen^.HideCursor;
  if On then
  begin
    WinStart := CursorPos and $FFFFFFF0;
    if WinStart + ScrSize shl 4 > ReadSize then if ReadSize >= ScrSize shl 4 then
      WinStart := (ReadSize + 16) and $FFFFFFF0 - ScrSize shl 4 else WinStart := 0;
    HexaStatus^.Text^ := 'Text  ';
    Column := 0;
    EditChar := 0;
    Screen^.NormalCursor;
  end
  else
  begin
    CurRealMove := True;
    NewWinStart := CursorPos;
    if Find then FindEOL(False, True, False, False);
    CurLine := CountLines(CursorPos);
    LineNum := CountLines(ReadSize);
    SimulateDraw;
    SeekOffset(CursorPos);
    SeekWin(True, False);
    HexaStatus^.Text^ := 'Hex   ';
  end;
  Screen^.SetCursorShape;
  Screen^.ShowCursor;
  KeyBar^.DrawView;
end;

procedure _Goto;
var
  O             : Boolean;
  C             : Word;
  I             : Integer;
  L             : Longint;
  D             : PDialog;
  I1            : PInputLine;
  S             : string;
  R             : TRect;
begin
  ChangeHelpCtx(hcHelp);
  if HexaMode then
  begin
    S := 'offset';
    if ShowLoadAddr then S := 'address';
    S := 'Goto ' + S + ': $';
  end
  else
  begin
    S := 'Goto line: ';
  end;
  MakeWinBounds(R, Length(S) + 10, 1);
  GetMouse(True);
  D := New(PDialog, Init(R, 'Goto', fxNormal, fyNormal, False));
  R.Assign(5, 2, Length(S) + 8, 1);
  if HexaMode then I1 := New(PHexInput, Init(R, 8, 8, S, drLeftClose)) else
    I1 := New(PNumInput, Init(R, 8, 8, S, drLeftClose));
  D^.Insert(I1);
  C := Application^.ExecView(D, True, True);
  O := (C = cmOK);
  SetMouse;
  if O then
  begin
    I1^.GetData(S);
    if HexaMode then L := HexaEval(S, I) else Val(S, L, I);
  end;
  Dispose(D, Done);
  if O then
  begin
    if L < 0 then L := MaxLongInt;
    if HexaMode then
    begin
      if ShowLoadAddr then
      begin
        Dec(L, LoadAddr);
        if L < 0 then L := 0;
      end;
      LoadOffsets;
      if ShowLoadAddr and (ReadSize >= SizeOf(Word)) then Dec(L, PWord(EditBuffer)^ - SizeOf(Word));
      if L >= 0 then
      begin
        NewWinStart := L and $FFFFFFF0;
        if L > ReadSize then
        begin
          L := ReadSize;
          if ReadSize >= ScrSize shl 4 then NewWinStart := (ReadSize + 16) and $FFFFFFF0 - ScrSize shl 4;
        end;
        CursorPos := L;
        SaveOffsets;
      end;
    end
    else
    begin
      if L > 0 then
      begin
        L := ScrollToLine(L - 1);
        if L > ReadSize then L := ReadSize;
        if (L < WinStart) or (L >= WinEnd) then NewWinStart := L;
        CursorPos := L;
        SaveOffsets;
        CurScrLine := 0;
        CurRealMove := True;
        SimulateDraw;
        SeekWin(True, False);
        FindEOL(False, True, False, False);
        CurLine := CountLines(CursorPos);
      end;
    end;
    Screen^.DrawView;
  end;
  RestoreHelpCtx;
end;

procedure SetUserEOL(Data: Boolean);
var
  F,
  O             : Boolean;
  C             : Word;
  I             : Integer;
  L             : Longint;
  D             : PDialog;
  I1            : PHexInput;
  V             : PNumValid;
  S             : string[20];
  R             : TRect;
begin
  ChangeHelpCtx(hcHelp);
  if Data then I := 22 else I := 23;
  MakeWinBounds(R, I, 1);
  GetMouse(True);
  if Data then S := 'Feed' else S := 'Length';
  D := New(PDialog, Init(R, 'User Line ' + S, fxNormal, fyNormal, False));
  if Data then S := 'feed: $' else S := 'length: ';
  S := 'Enter line ' + S;
  R.Assign(5, 2, Length(S) + 3, 1);
  I1 := New(PHexInput, Init(R, 2, 2, S, drLeftClose));
  if Data then S := HexaStr(Ord(EOLChars[3]), 2) else S := LeadingSpace(FixLineLen, 0);
  I1^.SetData(S);
  D^.Insert(I1);
  if not Data then
  begin
    V := New(PNumValid, Init(2, ScreenWidth, stEmpty, 'line length', CurHelpCtx));
    I1^.SetValidator(V);
  end;
  ErrorDown := 5;
  C := Application^.ExecView(D, True, True);
  ErrorDown := 0;
  F := (C = cmOK);
  SetMouse;
  if F then
  begin
    I1^.GetData(S);
    if Data then L := HexaEval(S, I) else Val(S, L, I);
  end;
  Dispose(D, Done);
  if F then
  begin
    if Data then
    begin
      EOLChars[3] := Chr(L);
      SetEOLMode(elUser, True);
    end
    else
    begin
      FixLineLen := L;
      SetEOLMode(elFixLen, True);
    end;
  end;
  RestoreHelpCtx;
end;

function ReadSearchByte: Byte; assembler;
asm
    cmp di, word ptr ReadSize[0];
    jne @1;
    push bx;
    call PackPtr;
    cmp bx, word ptr ReadSize[2];
    pop bx;
    mov ah, 2;
    je @2;
@1: mov al, es:[di];
    cmp SearchInHex, False;
    jne @3;
    push ax;
    call UpCaseFunc;
@3: xor ah, ah;
@2: or ah, ah;
end;

procedure Search(Cont, Replace: Boolean);
var
  F,
  O,
  M,
  Q             : Boolean;
  C             : Byte;
  L,
  X,
  Y,
  Z             : Longint;
  D             : PDialog;
  A             : PRadioButtons;
  S,
  T,
  U             : string;
  R             : TRect;
begin
  ChangeHelpCtx(hcESearch);
  F := False;
  O := True;
  if SearchInHex then
  begin
    SearchText := HexToText(SearchHex, False);
    ReplaceText := HexToText(ReplaceHex, False);
  end
  else
  begin
    SearchHex := TextToHex(SearchText, False, True);
    ReplaceHex := TextToHex(ReplaceText, False, True);
  end;
  if not Cont or (SearchStr = '') then
  begin
    Cont := False;
    S := '';
    T := '';
    if Replace then
    begin
      S := 'and replace it with the string';
      T := 'or the byte sequence';
    end;
    SearchInHex := HexaMode;
    O := GetTextOrHex(stEmpty, 'Search for the string', 'or the byte sequence', S, T,
      SearchText, SearchHex, SearchStr, ReplaceText, ReplaceHex, ReplaceStr, SearchInHex, CurHelpCtx);
  end
  else
  begin
    if SearchInHex then
    begin
      SearchStr := HexToText(SearchHex, True);
      ReplaceStr := HexToText(ReplaceHex, True);
    end
    else
    begin
      SearchStr := SearchText;
      ReplaceStr := ReplaceText;
    end;
  end;
  if O then
  begin
    if not Cont then
    begin
      ReplaceMode := Replace;
      AllOverwrite := ayNone;
      SetReplaceMode;
    end;
    if SearchInHex then
    begin
      S := SearchHex;
      if S <> '' then Dec(S[0]);
      T := 'byte sequence';
    end
    else
    begin
      S := SearchText;
      T := 'string';
      SetupCaseConversion;
      case ViewMode of
        vmASCII: SearchStr := UpperCase(SearchStr);
        vmPETSCII: for C := 1 to Length(SearchStr) do SearchStr[C] := CBMUpCase(Chr(ASCtoPET[Ord(SearchStr[C])]));
        vmScreen: for C := 1 to Length(SearchStr) do SearchStr[C] := SCRUpCase(Chr(ASCtoSCR[Ord(SearchStr[C])]));
      end;
    end;
    S := '"' + S + '"';
    Q := False;
    SearchMode := True;
    SearchStart := 0;
    SearchEnd := 0;
    X := SelectLStart;
    Y := SelectLEnd;
    M := EditMarking;
    D := InfoWin(stEmpty, 'Searching for the ' + T, S, stEmpty, 2);
    Z := CursorPos;
    GetCheckData := ReplaceModes[HexaMode];
    while not Q do
    begin
      LoadOffsets;
(* ?ASM? *)
      asm
        push bp;
        mov si, Offset(SearchStr);
        mov di, Offset(NextSameChar);
        lodsb;
        mov cl, al;
        xor ch, ch;
        mov bp, 1;
        xor bx, bx;
        mov [di], ch;
    @4: mov al, ds:[si][bp];
        cmp al, [si][bx];
        jne @1;
        inc bp;
        inc bx;
        mov ds:[di][bp], bl;
        jmp @2;
    @1: or bx, bx;
        jne @3;
        inc bp;
        mov ds:[di][bp], ch;
        jmp @2;
    @3: mov bl, [di][bx];
    @2: loop @4;
        pop bp;
      end;
      SearchStart := CursorPos;
      if Cont and (SearchStart < ReadSize) then Inc(SearchStart);
      StrFound := False;
      repeat
        asm
          mov di, word ptr SearchStart[0];
          mov bx, word ptr SearchStart[2];
          call UnpackPtr;
          xor bx, bx;
          mov si, Offset(SearchStr);
          mov cl, [si];
          inc si;
      @3: call ReadSearchByte;
          jne @1;
          cmp al, [si][bx];
          jne @2;
          push bx;
          call IncPtr;
          pop bx;
          inc bx;
          cmp bl, cl;
          jb @3;
          push bx;
          call PackPtr;
          mov dx, bx;
          pop bx;
          sub di, cx;
          sbb dx, 0;
          mov StrFound, True;
          jmp @1;
      @2: or bx, bx;
          jne @4;
          push bx;
          call IncPtr;
          pop bx;
          jmp @3;
      @4: mov bl, byte ptr NextSameChar[bx];
          jmp @3;
      @1: mov word ptr SearchStart[0], di;
          mov word ptr SearchStart[2], dx;
          mov C, ah;
        end;
      until StrFound or (C <> 0);
      if StrFound then
      begin
        F := True;
        SearchEnd := SearchStart + Length(SearchStr);
        CursorPos := SearchStart;
        if (AllOverwrite = ayNone) then
        begin
          Z := CursorPos;
          CurLine := CountLines(CursorPos);
          EditChar := 0;
          ScrollToCursor;
          LoadOffsets;
          if HexaMode then
          begin
            if (NewWinStart + ScrSize shl 4 > ReadSize) and (ReadSize > ScrSize shl 4) then
              NewWinStart := (ReadSize + 16) and $FFFFFFF0 - ScrSize shl 4;
            SaveOffsets;
          end
          else
          begin
            if not ReplaceMode and (SearchEnd <= WinEnd) then
            begin
              SeekOffset(SearchEnd);
              SeekWin(True, False);
            end
            else
            begin
              if ReplaceMode then NewWinStart := SearchStart;
              MoveToOffset(SearchStart);
              SeekOffset(SearchEnd);
              SeekWin(True, False);
            end;
            CurRealMove := True;
          end;
          SelectLStart := SearchStart;
          SelectLEnd := SearchEnd;
          SelectStart := SelectLStart;
          SelectEnd := SelectLEnd;
          EditMarking := False;
          if not HexaMode then
          begin
            NewWinStart := LineOffsets[CurScrLine];
            asm
              mov di, word ptr NewWinStart[0];
              mov bx, word ptr NewWinStart[2];
              call MakeLine;
            end;
            if SelEndCol > ScreenWidth then Inc(SelEndCol);
            if SelStartCol > 0 then Dec(SelStartCol);
            if Column + ScreenWidth < SelEndCol then Column := SelEndCol - ScreenWidth;
            if Column > SelStartCol then Column := SelStartCol;
          end;
          if not ReplaceMode then
          begin
            SelectLStart := X;
            SelectLEnd := Y;
            SelectStart := 0;
            SelectEnd := 0;
            EditMarking := False;
          end;
          Screen^.DrawView;
        end;
        if ReplaceMode then
        begin
          if SearchInHex then
          begin
            U := ReplaceHex;
            if U <> '' then Dec(U[0]);
          end
          else
          begin
            U := ReplaceText;
          end;
          if (AllOverwrite <> ayNone) then
          begin
            if Escape then C := cmCancel else C := cmOK;
          end
          else
          begin
            ErrorDown := 0;
            R.Assign(0, 0, 0, 2);
            A := New(PRadioButtons, Init(R,
              NewSItem(ColorChar+'I'+ColorChar+'nsert',
              NewSItem(ColorChar+'O'+ColorChar+'verwrite',
            nil))));
            C := SureConfirm(stEmpty, 'Replace', S, 'with', '"' + U + '"?', ' '+ColorChar+'R'+ColorChar+'eplace ',
              stEmpty, stEmpty, stSkip, stEmpty, A, CurHelpCtx, ayAllYes, False, AllOverwrite);
            ReplaceModes[HexaMode] := GetCheckData;
          end;
          case C of
            cmOK:
            begin
              if GetCheckData = rmInsert then
              begin
                L := Length(ReplaceStr) - Length(SearchStr);
                if L <> 0 then BufferChanged := True;
              end
              else
              begin
                L := CursorPos + Length(ReplaceStr) - ReadSize;
                if L < 0 then L := 0;
              end;
              if (GetCheckData = rmOverwrite) or (L < 0) or (FreeSize >= L) then
              begin
                if GetCheckData = rmInsert then BlockCopy(SearchEnd, ReadSize, SearchEnd + L);
                asm
                  mov di, word ptr SearchStart[0];
                  mov bx, word ptr SearchStart[2];
                  call UnpackPtr;
                  mov si, Offset(ReplaceStr);
                  cld;
                  lodsb;
                  or al, al;
                  je @2;
                  mov cl, al;
                  xor ch, ch;
              @1: lodsb;
                  cmp es:[di], al;
                  je @3;
                  mov BufferChanged, True;
                  mov es:[di], al;
              @3: call IncPtr;
                  loop @1;
              @2:
                end;
                Inc(ReadSize, L);
                if GetCheckData = rmInsert then
                begin
                  Inc(SearchEnd, L);
                  SelectLStart := X;
                  SelectLEnd := Y;
                  MoveSelMarks(L);
                  X := SelectLStart;
                  Y := SelectLEnd;
                  Inc(CursorPos, Length(ReplaceStr));
                end
                else
                begin
                  Inc(CursorPos);
                end;
                if not HexaMode and (AllOverwrite = ayNone) then
                begin
                  CurLine := CountLines(CursorPos);
                  LineNum := CountLines(ReadSize);
                  CurRealMove := True;
                  ScrollToCursor;
                  SeekWin(True, False);
                end;
                MakeTitle;
                if AllOverwrite = ayNone then Screen^.DrawView;
              end
              else
              begin
                Q := True;
              end;
            end;
            cmSkip: Inc(CursorPos);
            cmCancel: Q := True;
          end;
        end
        else
        begin
          Q := True;
        end;
      end
      else
      begin
        if AllOverwrite = ayNone then Screen^.DrawView;
        if C = 2 then
        begin
          if not F then
          begin
            MakeSound := False;
            ErrorWin(stEmpty, 'Could not find the ' + T, S, CurHelpCtx, sbNone);
          end;
          Q := True;
        end;
      end;
      ErrorDown := 0;
    end;
    SearchMode := False;
    SelectLStart := X;
    SelectLEnd := Y;
    SelectStart := 0;
    SelectEnd := 0;
    SelectSize := 0;
    EditMarking := M;
    CursorPos := Z;
    Screen^.DrawView;
    Dispose(D, Done);
    CurLine := CountLines(CursorPos);
    LineNum := CountLines(ReadSize);
    CurRealMove := True;
    ScrollToCursor;
    SeekWin(True, False);
    MakeTitle;
    Screen^.DrawView;
  end;
  RestoreHelpCtx;
end;

procedure SetTabMode(On, Find: Boolean);
begin
  TabMode := On;
  if On then TabStatus^.Text^ := 'TabOff' else TabStatus^.Text^ := 'TabOn ';
  if not HexaMode and Find then FindEOL(False, True, False, False);
  CurRealMove := True;
  Screen^.DrawView;
  KeyBar^.DrawView;
end;

procedure ToggleMiniHelp;
begin
  if MiniHelpMode = mhNone then SetMiniHelpMode(DefMiniHelpMode) else SetMiniHelpMode(mhNone);
end;

procedure ToggleLoadAddress;
begin
  ShowLoadAddr := not ShowLoadAddr;
  SetLoadAddressMode;
  MakeTitle;
  Screen^.DrawView;
  KeyBar^.DrawView;
end;

procedure ToggleSymbols;
begin
  ShowSymbols := not ShowSymbols;
  SetSymbolMode;
  Screen^.DrawView;
  KeyBar^.DrawView;
end;

procedure ToggleBackup;
var
  D             : PDialog;
  S             : string[10];
  E             : TEvent;
begin
  BackupFiles := not BackupFiles;
  S := '';
  if not BackupFiles then S := 'not ';
  D := InfoWin(stEmpty, 'Backup files will ' + S + 'be created', stEmpty, stEmpty, 1);
  repeat
    Application^.GetEvent(E);
  until (E.What and (evKeyboard or evMouseDown or evCommand) > 0);
  Application^.PutEvent(E);
  Dispose(D, Done);
  KeyBar^.DrawView;
end;

procedure LoadFile(Raw: Boolean);
begin
  RestoreHelpCtx;
  if (PanelDir^[PanelCur].Attr and faTypeMask = faPartition) and ((PanelMode = pmTAR) or
    ((PanelMode = pmDisk) and (DiskType and dtTypeMask = dt1581) and (PanelDir^[PanelCur].ExtAttr and xaGEOSVLIR > 0))) then
  begin
    if (ImagePath <> '') and (PanelCur = 0) then
    begin
      ReadName := CutPath(ImagePath, DirSep);
      ImagePath := GetPath(ImagePath, DirSep);
      ReadDirPos := MaxWord;
    end
    else
    begin
      ImagePath := AddToPath(ImagePath, ReadName, DirSep);
      ReadName := '';
    end;
    SelectFile;
  end
  else
  begin
    AllErrorSkip := ayNone;
    if Raw then PanelMode := pmDOS;
    if FirstSelect then
    begin
      FirstSelect := False;
      if (OrigViewMode = vmASCII) and ((PanelMode <> pmDisk) or not GEOSFormat) then OrigViewMode := vmPETSCII;
    end;
    ViewMode := OrigViewMode;
    MakeFullName;
    DirMode := False;
    ReadingFile := True;
    Screen^.HideCursor;
    Screen^.DrawView;
    FileOK := False;
    OpenFile(False);
    if FileOK then
    begin
      WinStart := 0;
      CharStartMode := ECharSetMode;
      if ViewMode = vmASCII then CharStartMode := CharSetMode and csLowerUpper;
      Application^.SetCharSet(CharStartMode, True, False);
      MakeTitle;
      Screen^.SetCursorShape;
      Screen^.ShowCursor;
    end
    else
    begin
      SelectFile;
    end;
  end;
end;

constructor TScreen.Init(Bounds: TRect);
begin
  TView.Init(Bounds);
  SetState(sfAlwaysIns, False);
  Options := Options or ofSelectable;
  EventMask := EventMask or evBroadcast;
  SetCursorShape;
end;

procedure NoteCurPos;
begin
  OrigCurPos := CursorPos;
  ShiftedMove := (GetShiftState and (kbLeftShift + kbRightShift) > 0);
end;

procedure CheckCurPos;
begin
  if ShiftedMove and (CursorPos <> OrigCurPos) then
  begin
    if OrigCurPos = SelectLStart then
    begin
      SelectLStart := CursorPos;
    end
    else
    begin
      if OrigCurPos <> SelectLEnd then SelectLStart := OrigCurPos;
      SelectLEnd := CursorPos;
    end;
    EditMarking := False;
    EditMarked := True;
  end;
end;

procedure ELeft(CheckShift, Display: Boolean);
var
  O             : Boolean;
begin
  if not DirMode then
  begin
    LoadOffsets;
    if CheckShift then NoteCurPos;
    if HexaMode then
    begin
      if TextMode or (EditChar = 0) then
      begin
        if CursorPos > 0 then
        begin
          Dec(CursorPos);
          if (CursorPos < NewWinStart) then if NewWinStart > 16 then Dec(NewWinStart, 16) else NewWinStart := 0;
          if TextMode then EditChar := 0 else EditChar := 1;
        end;
      end
      else
      begin
        Dec(EditChar);
      end;
      SaveOffsets;
    end
    else
    begin
      if CursorPos > 0 then
      begin
        O := (CursorPos = LineOffsets[CurScrLine]);
        Dec(CursorPos);
        if O then
        begin
          if CurLine > 0 then Dec(CurLine);
          if CurScrLine = 0 then
          begin
            FindEOL(False, True, True, True);
            SimulateDraw;
          end
          else
          begin
            Dec(CurScrLine);
          end;
        end;
        CurRealMove := True;
        SeekWin(False, False);
      end;
    end;
    if CheckShift then CheckCurPos;
    if Display then Screen^.DrawView;
  end;
end;

procedure ERight(CheckShift, Display: Boolean);
var
  O             : Boolean;
begin
  if not DirMode then
  begin
    LoadOffsets;
    if CheckShift then NoteCurPos;
    if HexaMode then
    begin
      if not TextMode and (EditChar = 0) then
      begin
        if CursorPos < ReadSize then Inc(EditChar);
      end
      else
      begin
        if CursorPos < ReadSize then
        begin
          Inc(CursorPos);
          if (CursorPos >= NewWinStart + ScrSize shl 4) and (NewWinStart + ScrSize shl 4 <= ReadSize) then
            Inc(NewWinStart, 16);
          EditChar := 0;
        end;
      end;
      SaveOffsets;
    end
    else
    begin
      if CursorPos < ReadSize then
      begin
        O := IsEOL;
        if O and (EOLMode = elCRLF) then Inc(CursorPos, 2) else Inc(CursorPos);
        if O or ((CursorPos < ReadSize) and (CursorPos >= LineOffsets[CurScrLine + 1])) then
        begin
          Inc(CurLine);
          if CurScrLine = ScrSize - 1 then
          begin
            FindEOL(True, True, True, True);
            SimulateDraw;
          end
          else
          begin
            Inc(CurScrLine);
          end;
        end;
        CurRealMove := True;
        SeekWin(False, False);
      end;
    end;
    if CheckShift then CheckCurPos;
    if Display then Screen^.DrawView;
  end;
end;

procedure ECtrlLeft;
begin
  if not DirMode then
  begin
    LoadOffsets;
    NoteCurPos;
    if HexaMode then
    begin
      if not TextMode then ELeft(False, False);
      ELeft(False, True);
    end
    else
    begin
      FindSeparator(False);
      CurRealMove := True;
      SeekWin(False, False);
    end;
    CheckCurPos;
    Screen^.DrawView;
  end;
end;

procedure ECtrlRight;
begin
  if not DirMode then
  begin
    LoadOffsets;
    NoteCurPos;
    if HexaMode then
    begin
      if not TextMode then ERight(False, False);
      ERight(False, True);
    end
    else
    begin
      FindSeparator(True);
      CurRealMove := True;
      SeekWin(False, False);
    end;
    CheckCurPos;
    Screen^.DrawView;
  end;
end;

procedure EUp;
begin
  if DirMode then
  begin
    if PanelCur > 0 then
    begin
      if PanelCur = DeltaY then Dec(DeltaY);
      Dec(PanelCur);
    end;
  end
  else
  begin
    LoadOffsets;
    NoteCurPos;
    if HexaMode then
    begin
      if CursorPos >= 16 then
      begin
        Dec(CursorPos, 16);
        if CursorPos < NewWinStart then if NewWinStart >= 16 then Dec(NewWinStart, 16) else NewWinStart := 0;
        SaveOffsets;
      end;
    end
    else
    begin
      if CurLine > 0 then
      begin
        if CurScrLine = 0 then
        begin
          LoadOffsets;
          Inc(CurScrLine);
          FindEOL(False, True, True, True);
          SimulateDraw;
        end;
        if CurScrLine > 0 then Dec(CurScrLine);
        CursorPos := LineOffsets[CurScrLine];
        CurColumn := CurRealCol;
        GotoSameCol;
        Dec(CurLine);
        LoadOffsets;
        SeekWin(False, False);
      end;
    end;
    CheckCurPos;
  end;
  Screen^.DrawView;
end;

procedure EDown;
begin
  if DirMode then
  begin
    if PanelCur < PanelMax - 1 then
    begin
      if PanelCur = DeltaY + PanLen - 1 then Inc(DeltaY);
      Inc(PanelCur);
    end;
  end
  else
  begin
    LoadOffsets;
    NoteCurPos;
    if HexaMode then
    begin
      if CursorPos < ReadSize and $FFFFFFF0 then Inc(CursorPos, 16);
      if CursorPos >= ReadSize then
      begin
        CursorPos := ReadSize;
        EditChar := 0;
      end;
      if CursorPos >= NewWinStart + ScrSize shl 4 then Inc(NewWinStart, 16);
      SaveOffsets;
    end
    else
    begin
      if CurLine < LineNum then
      begin
        if CurScrLine = ScrSize - 1 then
        begin
          LoadOffsets;
          Dec(CurScrLine);
          FindEOL(True, True, True, True);
          SimulateDraw;
        end;
        if CurScrLine < ScrSize - 1 then Inc(CurScrLine);
        CursorPos := LineOffsets[CurScrLine];
        CurColumn := CurRealCol;
        GotoSameCol;
        Inc(CurLine);
        LoadOffsets;
        SeekWin(False, False);
      end;
    end;
    CheckCurPos;
  end;
  Screen^.DrawView;
end;

procedure EPgUp;
var
  B             : Byte;
begin
  if DirMode then
  begin
    if DeltaY = 0 then
    begin
      PanelCur := 0;
    end
    else
    begin
      if PanelCur < PanLen then
      begin
        DeltaY := 0;
      end
      else
      begin
        if DeltaY > PanLen - 1 then Dec(DeltaY, PanLen - 1) else DeltaY := 0;
      end;
    end;
  end
  else
  begin
    LoadOffsets;
    NoteCurPos;
    if HexaMode then
    begin
      if CursorPos < NewWinStart + 16 then if NewWinStart > ScrSize shl 4 - 16 then Dec(NewWinStart, ScrSize shl 4 - 16) else
        NewWinStart := 0;
      if CursorPos >= 16 then
      begin
        CursorPos := NewWinStart;
        EditChar := 0;
      end;
      SaveOffsets;
    end
    else
    begin
      if CurLine > 0 then
      begin
        if CurScrLine = 0 then
        begin
          LoadOffsets;
          for B := 1 to ScrSize - 1 do FindEOL(False, False, True, True);
          CursorPos := NewWinStart;
          if CurLine > ScrSize - 1 then Dec(CurLine, ScrSize - 1) else CurLine := 0;
        end
        else
        begin
          CursorPos := LineOffsets[0];
          Dec(CurLine, CurScrLine);
          LoadOffsets;
        end;
        SimulateDraw;
        CurScrLine := 0;
        CurRealMove := True;
        SeekWin(False, False);
      end;
    end;
    CheckCurPos;
  end;
  Screen^.DrawView;
end;

procedure EPgDn;
var
  B             : Byte;
  L             : Longint;
begin
  if DirMode then
  begin
    if DeltaY > PanelMax - PanLen - 1 then
    begin
      PanelCur := PanelMax - 1;
    end
    else
    begin
      if PanelCur > PanelMax - PanLen then
      begin
        if PanelMax > PanLen then DeltaY := PanelMax - PanLen else DeltaY := 0;
      end
      else
      begin
        if DeltaY < PanelMax - (PanLen shl 1) + 1 then Inc(DeltaY, PanLen - 1) else
          DeltaY := PanelMax - PanLen;
      end;
    end;
  end
  else
  begin
    LoadOffsets;
    NoteCurPos;
    if HexaMode then
    begin
      if CursorPos >= NewWinStart + ScrSize shl 4 - 16 then if NewWinStart + ScrSize shl 5 - 16 <= (ReadSize and $FFFFFFF0)
        then Inc(NewWinStart, ScrSize shl 4 - 16) else NewWinStart := (ReadSize + 16 - ScrSize shl 4) and $FFFFFFF0;
      if CursorPos < ReadSize and $FFFFFFF0 then
      begin
        CursorPos := NewWinStart + ScrSize shl 4 - 16;
        if CursorPos >= ReadSize then CursorPos := ReadSize and $FFFFFFF0;
        EditChar := 0;
      end;
      SaveOffsets;
    end
    else
    begin
      if CurLine < LineNum then
      begin
        if CurScrLine < ScrSize - 1 then
        begin
          CursorPos := LineOffsets[LastScrLine];
          if LineNum > ScrSize - 1 then Inc(CurLine, LastScrLine - CurScrLine) else CurLine := LineNum;
          LoadOffsets;
        end
        else
        begin
          NewWinStart := CursorPos;
          if CurColumn > 0 then FindEOL(False, False, True, True);
          SaveOffsets;
          L := NewWinStart;
          for B := 1 to ScrSize - 1 do
          begin
            FindEOL(True, False, True, True);
            if EOLFound or (NewWinStart < ReadSize) then L := NewWinStart;
          end;
          CursorPos := L;
          if CurLine < LineNum - ScrSize + 1 then
          begin
            Inc(CurLine, ScrSize - 1);
          end
          else
          begin
            CurLine := LineNum;
            CurScrLine := 0;
          end;
          LoadOffsets;
        end;
        SimulateDraw;
        CurScrLine := ScrSize - 1;
        CurRealMove := True;
        SeekWin(True, False);
      end;
    end;
    CheckCurPos;
  end;
  Screen^.DrawView;
end;

procedure EHome;
begin
  if DirMode then
  begin
    DeltaY := 0;
    PanelCur := 0;
  end
  else
  begin
    LoadOffsets;
    NoteCurPos;
    if HexaMode then
    begin
      CursorPos := CursorPos and $FFFFFFF0;
      EditChar := 0;
      SaveOffsets;
    end
    else
    begin
      CursorPos := LineOffsets[CurScrLine];
      CurRealMove := True;
      LoadOffsets;
      SeekWin(False, False);
    end;
    CheckCurPos;
  end;
  Screen^.DrawView;
end;

procedure EEnd;
var
  B             : Byte;
begin
  if DirMode then
  begin
    if PanelMax > PanLen then DeltaY := PanelMax - PanLen else DeltaY := 0;
    PanelCur := PanelMax - 1;
  end
  else
  begin
    LoadOffsets;
    NoteCurPos;
    if HexaMode then
    begin
      CursorPos := CursorPos and $FFFFFFF0 + 15;
      EditChar := 0;
      if CursorPos > ReadSize then
      begin
        CursorPos := ReadSize;
        EditChar := 0;
      end;
      SaveOffsets;
    end
    else
    begin
      NewWinStart := LineOffsets[CurScrLine];
      FindEOL(True, False, True, True);
      if EOLFound then if EOLMode = elCRLF then Dec(NewWinStart, 2) else Dec(NewWinStart) else
        if NewWinStart < ReadSize then Dec(NewWinStart);
      CursorPos := NewWinStart;
      CurRealMove := True;
      LoadOffsets;
      SeekWin(False, False);
    end;
    CheckCurPos;
  end;
  Screen^.DrawView;
end;

procedure ECtrlHome;
begin
  if DirMode then
  begin
    DeltaY := 0;
    PanelCur := 0;
  end
  else
  begin
    LoadOffsets;
    NoteCurPos;
    NewWinStart := 0;
    CursorPos := 0;
    CurLine := 0;
    CurScrLine := 0;
    CurRealMove := True;
    EditChar := 0;
    SaveOffsets;
    SimulateDraw;
    if not HexaMode then SeekWin(True, False);
    CheckCurPos;
  end;
  Screen^.DrawView;
end;

procedure ECtrlEnd;
var
  B             : Byte;
begin
  if DirMode then
  begin
    if PanelMax > PanLen then DeltaY := PanelMax - PanLen else DeltaY := 0;
    PanelCur := PanelMax - 1;
  end
  else
  begin
    LoadOffsets;
    NoteCurPos;
    if HexaMode then
    begin
      if ReadSize >= ScrSize shl 4 then NewWinStart := (ReadSize + 16) and $FFFFFFF0 - ScrSize shl 4;
    end
    else
    begin
      NewWinStart := ReadSize;
    end;
    CursorPos := ReadSize;
    CurLine := LineNum;
    CurScrLine := LastScrLine;
    CurRealMove := True;
    EditChar := 0;
    SaveOffsets;
    SimulateDraw;
    if not HexaMode then SeekWin(True, False);
    CheckCurPos;
  end;
  Screen^.DrawView;
end;

procedure EIns(On: Boolean);
begin
  if not DirMode then
  begin
    InsertModes[HexaMode] := On;
    Screen^.SetCursorShape;
  end;
end;

procedure EDel;
var
  B             : Boolean;
  L             : Longint;
begin
  if not DirMode then
  begin
    if CursorPos < ReadSize then
    begin
      L := 1;
      B := IsEOL and not HexaMode;
      if B and (EOLMode = elCRLF) then Inc(L);
      BlockCopy(CursorPos + L, ReadSize, CursorPos);
      Dec(ReadSize, L);
      MoveSelMarks(-L);
      if B then Dec(LineNum);
      BufferChanged := True;
      SeekWin(True, False);
      MakeTitle;
      Screen^.DrawView;
    end;
  end;
end;

procedure DeleteBackwards;
begin
  if CursorPos > 0 then
  begin
    if HexaMode then ELeft(False, False);
    ELeft(False, False);
    EDel;
  end;
end;

procedure EBack;
begin
  if not DirMode and HexaMode then
  begin
    if CursorPos = ReadSize then
    begin
      if ReadSize > 0 then
      begin
        if (ReadSize >= ScrSize shl 4) and (WinStart + ScrSize shl 4 >= ReadSize) then
          WinStart := (ReadSize + 15) and $FFFFFFF0 - ScrSize shl 4;
        Dec(ReadSize);
        ELeft(False, False);
        EditChar := 0;
        BufferChanged := True;
        MakeTitle;
        Screen^.DrawView;
      end;
    end
    else
    begin
      if InsertModes[HexaMode] then DeleteBackwards else ELeft(False, True);
    end;
  end
  else
  begin
    DeleteBackwards;
  end;
end;

procedure EDelWord(Fore: Boolean);
var
  L,
  M             : Longint;
begin
  if not DirMode and not HexaMode then
  begin
    M := CursorPos;
    FindSeparator(Fore);
    L := M - CursorPos;
    if L <> 0 then
    begin
      if L > 0 then
      begin
        BlockCopy(CursorPos + L, ReadSize, CursorPos);
      end
      else
      begin
        BlockCopy(CursorPos, ReadSize, CursorPos + L);
        CursorPos := M;
      end;
      Dec(ReadSize, Abs(L));
      MoveSelMarks(-Abs(L));
      if EolMode = elFixLen then
      begin
        CurLine := CountLines(CursorPos);
        LineNum := CountLines(ReadSize);
      end;
      BufferChanged := True;
      CurRealMove := True;
      SeekWin(True, False);
      MakeTitle;
      Screen^.DrawView;
    end;
  end;
end;

procedure ECtrlK;
var
  L             : Longint;
begin
  if not DirMode and not HexaMode and (CursorPos < ReadSize) and not IsEOL then
  begin
    NewWinStart := CursorPos;
    FindEOL(True, False, False, False);
    if EOLFound then if EOLMode = elCRLF then Dec(NewWinStart, 2) else Dec(NewWinStart) else
      Dec(LineNum);
    BlockCopy(NewWinStart, ReadSize, CursorPos);
    L := NewWinStart - CursorPos;
    Dec(ReadSize, L);
    MoveSelMarks(-L);
    BufferChanged := True;
    CurRealMove := True;
    LoadOffsets;
    SeekWin(True, False);
    MakeTitle;
    Screen^.DrawView;
  end;
end;

procedure ECtrlY;
var
  L,
  M             : Longint;
begin
  if not DirMode and not HexaMode then
  begin
    M := LineOffsets[CurScrLine];
    L := LineOffsets[CurScrLine + 1];
    CursorPos := M;
    if (M <> L) and (L <= ReadSize) then
    begin
      NewWinStart := M;
      BlockCopy(L, ReadSize, NewWinStart);
      Dec(L, NewWinStart);
      Dec(ReadSize, L);
      MoveSelMarks(-L);
      Dec(LineNum);
      BufferChanged := True;
      CurRealMove := True;
      LoadOffsets;
      SeekWin(True, False);
      MakeTitle;
      Screen^.DrawView;
    end;
  end;
end;

procedure EWrite(W: Word);
var
  F,
  O             : Boolean;
  B,
  N             : Byte;
  C             : Char;
  L             : Longint;

procedure MakeRoom;
begin
  if not O and (FreeSize >= L) then
  begin
    BlockCopy(CursorPos, ReadSize, CursorPos + L);
    Inc(ReadSize, L);
    if SelectLStart > CursorPos then Inc(SelectLStart, L);
    if SelectLEnd > CursorPos then Inc(SelectLEnd, L);
    O := True;
  end;
end;

begin
  if not DirMode then
  begin
    C := Chr(W);
    N := MaxByte;
    if not HexaMode or TextMode then
    begin
      case W of
        kbDel, kbBack, kbCtrlBack: W := 0;
        kbEnter, kbCtrlI, kbCtrlM:
      else
        case C of
          #0: if (Hi(W) <> $03) or (not HexaMode and not QuoteMode) then W := 0;
          #1..' ': if not HexaMode and not QuoteMode and (C in [#1..' ']) and (Hi(W) in [$07, $0C, $10..$32]) then W := 0;
        end;
      end;
      if W > 0 then
      begin
        B := Ord(C);
        if C >= ' ' then
        begin
          case ViewMode of
            vmPETSCII:
            begin
              if (B = Ord(' ')) and (ShiftCode = skShift) then
              begin
                B := 160;
              end
              else
              begin
                B := ASCtoPET[Ord(C)];
                if (B = Ord(' ')) and (C <> ' ') then B := 0;
              end;
            end;
            vmScreen:
            begin
              B := ASCtoSCR[Ord(C)];
              if (B = Ord(' ')) and (C <> ' ') then B := 0;
            end;
          end;
        end;
        case W of
          kbCtrl2, kbCtrl6, kbCtrlMinus: B := Ord(C);
        end;
      end;
    end
    else
    begin
      B := Ord(C);
    end;
    if (W > 0) and ((B <> MaxByte) or (C = Chr(MaxByte))) then
    begin
      if HexaMode then
      begin
        if W = kbTab then
        begin
          TextMode := not TextMode;
          Screen^.DrawView;
        end
        else
        begin
          if (CursorPos < ReadSize) or (FreeSize > 0) then
          begin
            if TextMode then
            begin
              N := 0;
            end
            else
            begin
              N := LeftPos(UpCase(C), HexaNum) - 1;
              if (CursorPos = ReadSize) or (InsertModes[HexaMode]) and (EditChar = 0) then
              begin
                B := 0;
              end
              else
              begin
                asm
                  mov di, word ptr CursorPos[0];
                  mov bx, word ptr CursorPos[2];
                  call UnpackPtr;
                  mov al, es:[di];
                  mov B, al;
                end;
              end;
              if N < 16 then if EditChar = 0 then B := N shl 4 + B and $0F else B := B and $F0 + N and $0F;
            end;
            if N < 16 then
            begin
              O := True;
              if CursorPos = ReadSize then
              begin
                Inc(ReadSize);
              end
              else
              begin
                if (InsertModes[HexaMode]) and (EditChar = 0) then
                begin
                  O := False;
                  L := 1;
                  MakeRoom;
                end;
              end;
              if O then
              begin
                asm
                  mov di, word ptr CursorPos[0];
                  mov bx, word ptr CursorPos[2];
                  call UnpackPtr;
                  mov al, B;
                  mov es:[di], al;
                end;
                BufferChanged := True;
                ERight(False, True);
              end
              else
              begin
                GoSound := True;
              end;
            end;
          end
          else
          begin
            GoSound := True;
          end;
        end;
      end
      else
      begin
        if (B > 0) or (C = #0) then
        begin
          F := False;
          O := not (InsertModes[HexaMode] or (CursorPos = ReadSize) or IsEOL);
          L := 1;
          if (B = Ord(chCR)) and not QuoteMode and ((ViewMode <> vmScreen) or (W <> kbM)) and (EOLMode <> elFixLen) then
          begin
            O := False;
            F := True;
            B := Ord(EOLChar);
            if EOLMode = elCRLF then Inc(L);
          end;
          MakeRoom;
          if O then
          begin
            asm
              mov di, word ptr CursorPos[0];
              mov bx, word ptr CursorPos[2];
              call UnpackPtr;
              mov al, B;
              mov es:[di], al;
              cmp F, False;
              je @1;
              cmp EOLMode, elCRLF;
              jne @1;
              call IncPtr;
              mov byte ptr es:[di], chLF;
          @1:
            end;
            if F then
            begin
              Inc(LineNum);
            end
            else
            begin
              L := CursorPos;
              if QuoteMode and (EOLMode = elCRLF) then
              begin
                if (B = Ord(chLF)) and (CursorPos > 0) then Dec(CursorPos);
                if IsEOL then
                begin
                  L := CursorPos;
                  Inc(LineNum);
                end;
              end;
              CursorPos := L;
            end;
            SimulateDraw;
            ERight(False, True);
            BufferChanged := True;
          end
          else
          begin
            GoSound := True;
          end;
        end;
      end;
      QuoteMode := False;
      MakeTitle;
      Screen^.DrawView;
    end;
  end;
end;

procedure EMark(Display: Boolean);
var
  L             : Longint;
begin
  if not EditMarking then SelectLStart := CursorPos;
  SelectLEnd := CursorPos;
  if EditMarking and (SelectLStart = SelectLEnd) then
  begin
    L := NewWinStart;
    NewWinStart := LineOffsets[CurScrLine];
    SelectLStart := NewWinStart;
    FindEol(True, False, False, False);
    SelectLEnd := NewWinStart;
    NewWinStart := L;
  end;
  EditMarking := not EditMarking;
  EditMarked := True;
  if Display then Screen^.DrawView;
end;

procedure EUnmark;
begin
  EditMarking := False;
  EditMarked := False;
  SelectLStart := 0;
  SelectLEnd := 0;
  SelectStart := 0;
  SelectEnd := 0;
  SelectSize := 0;
  Screen^.DrawView;
end;

function ECopy(Display: Boolean): Boolean;
var
  O             : Boolean;
begin
  O := False;
  if SelectSize > 0 then
  begin
    O := True;
    if FreeSize >= SelectSize then
    begin
      if (CursorPos >= SelectStart) and (CursorPos < SelectEnd) then CursorPos := SelectEnd;
      BlockCopy(CursorPos, ReadSize, CursorPos + SelectSize);
      if CursorPos <= SelectStart then
      begin
        Inc(SelectStart, SelectSize);
        Inc(SelectEnd, SelectSize);
      end;
      BlockCopy(SelectStart, SelectEnd, CursorPos);
      Inc(ReadSize, SelectSize);
      if Display then
      begin
        SelectLStart := SelectStart;
        SelectLEnd := SelectEnd;
        CurLine := CountLines(CursorPos);
        LineNum := CountLines(ReadSize);
        EditMarking := False;
        CurRealMove := True;
        BufferChanged := True;
        if (CursorPos < WinStart) or (CursorPos >= WinEnd) then if HexaMode then WinStart := CursorPos and $FFFFFFF0 else
          WinStart := CursorPos;
        LoadOffsets;
        SimulateDraw;
        ScrollToCursor;
        SeekWin(True, False);
        MakeTitle;
        Screen^.DrawView;
      end;
    end
    else
    begin
      GoSound := True;
      O := False;
    end;
  end;
  ECopy := O;
end;

procedure EDelete(Unmark: Boolean);
begin
  if SelectSize = 0 then
  begin
    ECtrlY;
    EUnmark;
  end
  else
  begin
    BlockCopy(SelectEnd, ReadSize, SelectStart);
    Dec(ReadSize, SelectSize);
    if CursorPos >= SelectStart then if CursorPos < SelectEnd then CursorPos := SelectStart else Dec(CursorPos, SelectSize);
    if WinStart >= SelectStart then
    begin
      if WinStart < SelectEnd then
      begin
        WinStart := SelectStart;
      end
      else
      begin
        Dec(WinStart, SelectSize);
        WinStart := WinStart and $FFFFFFF0;
      end;
    end;
    CurLine := CountLines(CursorPos);
    LineNum := CountLines(ReadSize);
    CurRealMove := True;
    BufferChanged := True;
    if Unmark then
    begin
      EUnmark;
      ScrollToCursor;
      LoadOffsets;
      SeekWin(True, False);
      MakeTitle;
      Screen^.DrawView;
    end;
  end;
end;

procedure EMove;
begin
  if ECopy(False) then
  begin
    EDelete(False);
    SelectLStart := CursorPos;
    SelectLEnd := CursorPos + SelectSize;
    EditMarking := False;
    LoadOffsets;
    SimulateDraw;
    ScrollToCursor;
    SeekWin(True, False);
    MakeTitle;
    Screen^.DrawView;
  end;
end;

(* ?ASM? *)
function Capitalize(Ch: Char): Char; far; assembler;
asm
    push bx;
    mov al, &Ch;
    cmp InsideWord, False;
    je @1;
    push ax;
    call LoCaseFunc;
    jmp @2;
@1: push ax;
    call UpCaseFunc;
@2: mov ah, al;
    xor bl, bl;
    mov bh, ViewMode;
    cmp bh, vmASCII;
    jne @3;
    cmp ah, '0';
    jb @5;
    cmp ah, '9';
    jbe @6;
    cmp ah, 'A';
    jb @5;
    cmp ah, 'Z';
    jbe @6;
    cmp ah, 'a';
    jb @5;
    cmp ah, 'z';
    jbe @6;
    cmp ah, $80;
    jae @6;
    jmp @5;
@3: cmp bh, vmPETSCII;
    jne @4;
    cmp ah, $30;
    jb @5;
    cmp ah, $39;
    jbe @6;
    cmp ah, $41;
    jb @5;
    cmp ah, $5A;
    jbe @6;
    cmp ah, $60;
    jb @5;
    cmp ah, $9F;
    jbe @6;
    cmp ah, $A1;
    jae @6;
    jmp @5;
@4: cmp bh, vmScreen;
    jne @5;
    and ah, $7F;
    cmp ah, $01;
    jb @5;
    cmp ah, $1A;
    jbe @6;
    cmp ah, $30;
    jb @5;
    cmp ah, $39;
    ja @5;
    cmp ah, $40;
    jb @5;
@6: inc bl;
@5: mov InsideWord, bl;
    pop bx;
end;

procedure ChangeCase;
var
  C             : Word;
  A,
  P             : PHistoryItem;
  M             : PHistory;
  D             : PDialog;
  X             : PCharCaseFunc;
  R             : TRect;
begin
  if SelectSize > 0 then
  begin
    ChangeHelpCtx(hcOnlyQuit);
    P := NewHistoryItem('U', 'Uppercase', ccUpperCase, True, nil);
    A := P;
    P := NewHistoryItem('L', 'Lowercase', ccLowerCase, True, P);
    P := NewHistoryItem('I', 'Invert case', ccInvertCase, True, P);
    P := NewHistoryItem('C', 'Capitalize', ccCapitalize, True, P);
    R.Assign(4, 2, 17, 6);
    M := New(PHistory, Init(R, A, 0, True));
    MakeWinBounds(R, 17, 4);
    PriorityMenu := New(PDialog, Init(R, 'Change case', fxNormal, fyNormal, False));
    PriorityMenu^.Insert(M);
    PriorityMenu^.Palette := wpHistory;
    C := Application^.ExecView(PriorityMenu, True, True);
    Dispose(PriorityMenu, Done);
    PriorityMenu := nil;
    RestoreHelpCtx;
    if C = cmOK then
    begin
      EditMarking := False;
      SetupCaseConversion;
      InsideWord := False;
      case HistoryItem of
        ccUpperCase: X := UpCaseFunc;
        ccLowerCase: X := LoCaseFunc;
        ccInvertCase: X := InvCaseFunc;
        ccCapitalize: X := @Capitalize;
      end;
      asm
        mov di, word ptr SelectStart[0];
        mov bx, word ptr SelectStart[2];
        call UnpackPtr;
    @1: mov al, byte ptr es:[di];
        push ax;
        call X;
        cmp byte ptr es:[di], al;
        je @2;
        mov BufferChanged, True;
    @2: mov byte ptr es:[di], al;
        call IncPtr;
        cmp di, word ptr SelectEnd[0];
        jne @1;
        cmp bx, word ptr SelectEnd[2];
        jne @1;
      end;
      MakeTitle;
      Screen^.DrawView;
    end;
  end;
end;

procedure EQuit(Ask: Boolean);
var
  E             : TEvent;
begin
  ChangeHelpCtx(hcEQuit);
  if ConfirmQuit(Ask) then
  begin
    E.What := evCommand;
    E.Command := cmQuit;
    Application^.PutEvent(E);
  end;
  RestoreHelpCtx;
end;

procedure TScreen.SetCursorShape;
begin
  if InsertModes[HexaMode] = HexaMode then BlockCursor else NormalCursor;
  DrawView;
end;

function TScreen.GetPalette: PPalette;
const
  P: string[Length(CViewEdit)] = CViewEdit;
begin
  GetPalette := @P;
end;

procedure TScreen.HandleEvent(var Event: TEvent);
var
  O             : Boolean;
  B             : Byte;
  W             : Word;
  L,
  M             : Longint;
  P             : TPoint;
  X             : Pointer;
begin
  if Event.What and evKeyboard > 0 then
  begin
    if QuoteMode then
    begin
      EWrite(Event.KeyCode);
      ClearEvent(Event);
    end
    else
    begin
      O := False;
      if HexaMode and TextMode and (Lo(Event.KeyCode) > 0) then
      begin
        case Event.KeyCode of
          kbDel, kbBack, kbCtrlBack:
        else
          O := True;
        end;
      end;
      if not O then
      begin
        case Event.KeyCode of
          kbLeft, kbCtrlS: ELeft(True, True);
          kbRight, kbCtrlD: ERight(True, True);
          kbCtrlLeft, kbCtrlA: ECtrlLeft;
          kbCtrlRight, kbCtrlF: ECtrlRight;
          kbUp, kbCtrlE: EUp;
          kbDown, kbCtrlX: EDown;
          kbPgUp, kbCtrlR: EPgUp;
          kbPgDn, kbCtrlC: EPgDn;
          kbHome: EHome;
          kbEnd: EEnd;
          kbCtrlHome, kbCtrlPgUp: ECtrlHome;
          kbCtrlEnd, kbCtrlPgDn: ECtrlEnd;
          kbIns, kbCtrlV: EIns(not InsertModes[HexaMode]);
          kbDel, kbCtrlG: EDel;
          kbBack, kbCtrlH: EBack;
          kbCtrlBack, kbCtrlW: EDelWord(False);
          kbCtrlDel:
          begin
            if SelectSize = 0 then EDelWord(True) else EDelete(True);
          end;
          kbCtrlT: EDelWord(True);
          kbCtrlK: ECtrlK;
          kbCtrlY: ECtrlY;
          kbCtrlQ:
          begin
            QuoteMode := True;
            DrawView;
          end;
          kbCtrlIns, kbShiftDel:
          begin
            if SelectSize > 0 then
            begin
              asm
                mov di, word ptr SelectStart[0];
                mov bx, word ptr SelectStart[2];
                call UnpackPtr;
                mov word ptr X[0], di;
                mov word ptr X[2], es;
              end;
              PutClipboard(X, SelectSize);
              EditMarked := True;
              if Event.KeyCode = kbShiftDel then EDelete(True);
            end;
          end;
          kbShiftIns:
          begin
            L := GetClipboardSize;
            if (L > 0) and (L <= FreeSize) then
            begin
              BlockCopy(CursorPos, ReadSize, CursorPos + L);
              asm
                mov di, word ptr CursorPos[0];
                mov bx, word ptr CursorPos[2];
                call UnpackPtr;
                mov word ptr X[0], di;
                mov word ptr X[2], es;
              end;
              GetClipboard(X, L);
              M := L;
              DegranulateClipboard(X, L);
              if M <> L then BlockCopy(CursorPos + M, ReadSize + M, CursorPos + L);
              Inc(ReadSize, L);
              SelectLStart := CursorPos;
              Inc(CursorPos, L);
              SelectLEnd := CursorPos;
              SelectStart := SelectLStart;
              SelectEnd := SelectLEnd;
              EditMarked := True;
              BufferChanged := True;
              CurRealMove := True;
              SimulateDraw;
              ScrollToCursor;
              NewWinStart := WinStart;
              FindEOL(False, True, False, False);
              SimulateDraw;
              SeekWin(True, False);
              CurLine := CountLines(CursorPos);
              LineNum := CountLines(ReadSize);
              MakeTitle;
              DrawView;
            end;
          end;
        else
          O := ((Event.KeyCode = kbCtrlI) or (Event.KeyCode = kbCtrlM) or
            (Event.KeyCode < kbCtrlA) or (Event.KeyCode > kbCtrlKet));
        end;
      end;
      if O then
      begin
        EWrite(Event.KeyCode);
        ClearEvent(Event);
      end;
    end;
  end;
  if Event.What and evMouse > 0 then
  begin
    if State and sfFocused = 0 then
    begin
      ClearEvent(Event);
    end
    else
    begin
      if DirMode and Event.Double and (Event.Buttons = mbLeftButton) then
      begin
        MakeLocal(Event.Where, P);
        if (P.Y >= 2) and (P.Y <= WinSize - 2) then LoadFile(False);
      end
      else
      begin
        repeat
          MakeLocal(Event.Where, P);
          if DirMode then
          begin
            if P.Y < 2 then EUp else if P.Y > WinSize - 2 then EDown else
            begin
              PanelCur := DeltaY + P.Y - 2;
              if PanelCur >= PanelMax - 1 then PanelCur := PanelMax - 1;
              DrawView;
            end;
          end
          else
          begin
            if not (P.Y in [0..ScrSize - 1]) then
            begin
              LoadOffsets;
              if HexaMode then
              begin
                if P.Y < 0 then
                begin
                  if NewWinStart >= 16 then Dec(NewWinStart, 16) else NewWinStart := 0;
                end
                else
                begin
                  if NewWinStart <= ReadSize and $FFFFFFF0 - ScrSize shl 4 then Inc(NewWinStart, 16) else
                    NewWinStart := ReadSize and $FFFFFFF0 - ScrSize shl 4 + 16;
                end;
              end
              else
              begin
                FindEOL((P.Y > 0), False, True, False);
                SimulateDraw;
              end;
              if P.Y > 0 then Dec(P.Y) else Inc(P.Y);
              SaveOffsets;
            end;
            LoadOffsets;
            if HexaMode then
            begin
              for B := 1 to Abs(P.Y) do Inc(NewWinStart, 16);
              case P.X of
                0..10:
                begin
                  TextMode := False;
                  CursorPos := NewWinStart;
                  EditChar := 0;
                end;
                11..60:
                begin
                  TextMode := False;
                  Dec(P.X, 11);
                  for B := 0 to 15 do
                  begin
                    if P.X in [HexIndent[B]..HexIndent[B + 1] - 1] then
                    begin
                      CursorPos := NewWinStart + B;
                      EditChar := P.X - HexIndent[B];
                      if EditChar > 1 then EditChar := 1;
                    end;
                  end;
                end;
                61..63:
                begin
                  TextMode := False;
                  CursorPos := NewWinStart + 15;
                  EditChar := 1;
                end;
                64..MaxByte:
                begin
                  TextMode := True;
                  Dec(P.X, 64);
                  CursorPos := NewWinStart + P.X;
                end;
              end;
              if CursorPos >= ReadSize then
              begin
                CursorPos := ReadSize;
                EditChar := 0;
              end;
            end
            else
            begin
              if P.Y > ScrSize - 1 then P.Y := ScrSize - 1;
              for B := 1 to Abs(P.Y) do FindEOL((P.Y > 0), False, False, False);
              CursorPos := NewWinStart;
              CurScrLine := P.Y;
              CurColumn := Column + P.X;
              CurRealCol := CurColumn;
              GotoSameCol;
              CurLine := CountLines(CursorPos);
            end;
            if MouseButtons and mbRightButton = 0 then
            begin
              MouseRightHeld := False;
            end
            else
            begin
              if not MouseRightHeld then
              begin
                MouseRightHeld := True;
                EMark(False);
              end;
            end;
            if not HexaMode then
            begin
              LoadOffsets;
              SeekWin(True, False);
            end;
            DrawView;
          end;
        until not MouseEvent(Event, evMouseMove + evMouseAuto);
      end;
    end;
  end;
  if Event.What and evCommand > 0 then
  begin
    case Event.Command of
      cmEMark: EMark(True);
      cmEUnmark: EUnmark;
      cmECopy: ECopy(True);
      cmEMove: EMove;
      cmEDelete: EDelete(True);
    end;
  end;
  TView.HandleEvent(Event);
end;

procedure TScreen.Draw;
var
  O             : Boolean;
  A,
  H,
  C,
  D,
  Z             : Byte;
  V,
  W             : Word;
  I,
  J,
  Y             : Integer;
  L,
  S             : Longint;
  T             : string;

function GetName(L: Integer): string;
var
  I             : Byte;
  P             : PString;
  N             : string;
begin
  if L < PanelMax then
  begin
    FillChar(N[1], 20, ' ');
    if (L = 0) and (ImagePath <> '') then
    begin
      N := stParentDir;
    end
    else
    begin
      if PanelMode = pmTAR then
      begin
        P := GetNamePtr(L);
        if Length(P^) <= CBMNameLen then N := P^ else N := Copy(P^, 1, CBMNameLen - 1) + ArrowChars[2];
        N := '"' + N;
        I := Length(N) + 1;
      end
      else
      begin
        N := '"' + MakeCBMName(GetNamePtr(L)^, GEOSFormat);
        I := LeftPos(chShiftSpace, N);
        if I = 0 then I := Length(N) + 1;
      end;
      N[I] := '"';
    end;
    N[0] := #20;
  end
  else
  begin
    N := '';
  end;
  GetName := N;
end;

procedure CreateName;
var
  N             : TFileExtStr;
begin
  if Y < PanelMax then
  begin
    S := LonglongintToLongint(PanelDir^[Y].Size);
    if PanelMode in [pmTape, pmFile, pmLynx..pmTAR] then S := ByteToBlock(S);
    MoveStr(DrawBuf[W - 17 - Byte(StartInfo) shl 1], LeadingSpace(S, 6), Z);
    MoveCBMStr(@DrawBuf[W - 9 - Byte(StartInfo) * 3], GetName(Y), Z, False);
    A := PanelDir^[Y].Attr;
    if A and faClosed > 0 then T := stSpace else T := stAsterisk;
    H := PanelDir^[Y].ExtAttr and xaTypeMask;
    if H = 0 then
    begin
      N := ShortCBMExt[A and faTypeMask];
      if A and faTypeMask = faPartition then
      begin
        case PanelMode of
          pmDisk: if DiskType and dtTypeMask = dt1581 then if PanelDir^[Y].ExtAttr and xaDirectory = 0 then
            N := 'cbm' else N := 'DIR';
          pmTape: N := 'frz';
          pmTAR, pmLHA: N := 'DIR';
        end;
      end;
    end
    else
    begin
      N := ShortGEOSExt[H];
    end;
    T := T + N;
    if A and faWriteProt > 0 then T := T + '<';
    MoveStr(DrawBuf[W + 11 - Byte(StartInfo) shl 2], T, Z);
    if StartInfo then if PanelMode = pmDisk then MoveStr(DrawBuf[W + 13], LeadingZero(PanelDir^[Y].Track, 2) + ';' +
      LeadingZero(PanelDir^[Y].Sector, 2), Z) else if not (PanelMode in [pmLHA, pmFileZip])
      and (LonglongintToLongint(PanelDir^[Y].Size) >= 2) then
      MoveStr(DrawBuf[W + 13], HexaPrefix + HexaStr(PanelDir^[Y].Start, 4), Z);
  end;
end;

begin
  NormAttr := GetColor(1);
  SelAttr := GetColor(2);
  ArrowAttr := GetColor(6);
  CurScrCol := MaxByte;
  if DirMode then
  begin
    W := Size.X shr 1;
    if PanelMax > 0 then
    begin
      ReadName := GetNamePtr(PanelCur)^;
      ReadDirPos := PanelDir^[PanelCur].DirPos;
    end;
    if PanelCur < DeltaY then PanelCur := DeltaY;
    if PanelCur > DeltaY + PanLen - 1 then PanelCur := DeltaY + PanLen - 1;
    V := Ord(DoubleFrameChars[5]) + NormAttr shl 8;
    MoveChar(DrawBuf, DoubleFrameChars[2], NormAttr, Size.X);
    DrawBuf[0] := Ord(DoubleFrameChars[1]) + NormAttr shl 8;
    DrawBuf[Size.X - 1] := Ord(DoubleFrameChars[4]) + NormAttr shl 8;
    WriteBuf(0, 0, Size.X, 1, DrawBuf);
    MoveChar(DrawBuf, ' ', ArrowAttr, Size.X);
    if StartInfo then MoveStr(DrawBuf[W - 20], '  Length      Name         Type  Start  ', ArrowAttr) else
      MoveStr(DrawBuf[W - 20], '    Length       Name          Type     ', ArrowAttr);
    DrawBuf[0] := V;
    DrawBuf[Size.X - 1] := V;
    WriteBuf(0, 1, Size.X, 1, DrawBuf);
    for I := 0 to Size.Y - 4 do
    begin
      Y := DeltaY + I;
      if (Y = PanelCur) and (Y < PanelMax) then Z := SelAttr else Z := NormAttr;
      MoveChar(DrawBuf, ' ', Z, Size.X);
      if Y < PanelMax then CreateName;
      DrawBuf[0] := V;
      DrawBuf[Size.X - 1] := V;
      WriteBuf(0, I + 2, Size.X, 1, DrawBuf);
    end;
    MoveChar(DrawBuf, DoubleFrameChars[2], NormAttr, Size.X);
    DrawBuf[0] := Ord(DoubleFrameChars[13]) + NormAttr shl 8;
    DrawBuf[Size.X - 1] := Ord(DoubleFrameChars[16]) + NormAttr shl 8;
    WriteBuf(0, Size.Y - 1, Size.X, 1, DrawBuf);
    SetCursor(Size.X, Size.Y);
  end
  else
  begin
    if (EditBuffer = nil) or ReadingFile then
    begin
      MoveChar(DrawBuf, ' ', NormAttr, Size.X);
      WriteLine(0, 0, Size.X, Size.Y, DrawBuf);
    end
    else
    begin
      if EditMarking then SelectLEnd := CursorPos;
      if EditMarked or SearchMode then
      begin
        if SelectLStart <= SelectLEnd then
        begin
          SelectStart := SelectLStart;
          SelectEnd := SelectLEnd;
        end
        else
        begin
          SelectStart := SelectLEnd;
          SelectEnd := SelectLStart;
        end;
        SelectSize := SelectEnd - SelectStart;
      end;
      SelInRow := False;
      L := WinStart;
      FileEnd := False;
      ConvTable := 0;
      case CharSetMode + (ViewMode shl 2) of
        csIBMLower + vmPETSCII shl 2: ConvTable := Ofs(PETtoASCLower);
        csIBMUpper + vmPETSCII shl 2: ConvTable := Ofs(PETtoASCUpper);
        csCBMLower + vmPETSCII shl 2: ConvTable := Ofs(PETtoExtLower);
        csCBMUpper + vmPETSCII shl 2: ConvTable := Ofs(PETtoExtUpper);
        csIBMLower + vmScreen shl 2: ConvTable := Ofs(SCRtoASCLower);
        csIBMUpper + vmScreen shl 2: ConvTable := Ofs(SCRtoASCUpper);
        csCBMLower + vmScreen shl 2: ConvTable := Ofs(SCRtoExtLower);
        csCBMUpper + vmScreen shl 2: ConvTable := Ofs(SCRtoExtUpper);
      end;
      O := True;
      LastScrLine := ScrSize - 1;
      V := PWord(EditBuffer)^ - 2;
      for ScrLine := 0 to Size.Y - 1 do
      begin
        MoveChar(DrawBuf, ' ', NormAttr, Size.X);
        if L <= ReadSize then
        begin
          LineOffsets[ScrLine] := L;
          if HexaMode then
          begin
            if ShowLoadAddr then MoveStr(DrawBuf, HexaStr(L + V, 8), NormAttr) else
              MoveStr(DrawBuf, HexaStr(L, 8), NormAttr);
            for J := 0 to 15 do
            begin
              if L < ReadSize then
              begin
                O := ((L >= SelectStart) and (L < SelectEnd));
                SelInRow := SelInRow or O;
                if O then DrawAttr := SelAttr else DrawAttr := NormAttr;
                Z := (DrawAttr and $0F) shl 4 or (DrawAttr shr 4);
                asm
                  mov di, word ptr L[0];
                  mov bx, word ptr L[2];
                  call UnpackPtr;
                  mov al, es:[di];
                  mov C, al;
                end;
                T := HexaNum[C shr 4 + 1] + HexaNum[C and $0F + 1];
                if O and (L <> SelectEnd - 1) and (J < 15) then T := T + '  ';
                MoveStr(DrawBuf[HexIndent[J] + 11], T, DrawAttr);
                case CharSetMode + (ViewMode shl 2) of
                  csIBMLower + vmASCII shl 2:
                  begin
                    D := C;
                    A := DrawAttr;
                  end;
                  csIBMUpper + vmASCII shl 2:
                  begin
                    D := C;
                    A := DrawAttr;
                  end;
                  csIBMLower + vmPETSCII shl 2:
                  begin
                    D := PETtoASCLower[C];
                    A := DrawAttr;
                  end;
                  csIBMUpper + vmPETSCII shl 2:
                  begin
                    D := PETtoASCUpper[C];
                    A := DrawAttr;
                  end;
                  csCBMLower + vmPETSCII shl 2:
                  begin
                    D := PETtoExtLower[C];
                    if C and $7F < $20 then A := Z else A := DrawAttr;
                  end;
                  csCBMUpper + vmPETSCII shl 2:
                  begin
                    D := PETtoExtUpper[C];
                    if C and $7F < $20 then A := Z else A := DrawAttr;
                  end;
                  csIBMLower + vmScreen shl 2:
                  begin
                    D := SCRtoASCLower[C and $7F];
                    A := DrawAttr;
                  end;
                  csIBMUpper + vmScreen shl 2:
                  begin
                    D := SCRtoASCUpper[C and $7F];
                    A := DrawAttr;
                  end;
                  csCBMLower + vmScreen shl 2:
                  begin
                    D := SCRtoExtLower[C and $7F];
                    if C >= $80 then A := Z else A := DrawAttr;
                  end;
                  csCBMUpper + vmScreen shl 2:
                  begin
                    D := SCRtoExtUpper[C and $7F];
                    if C >= $80 then A := Z else A := DrawAttr;
                  end;
                end;
                MoveChar(DrawBuf[J + 63], Chr(D), A, 1);
              end
              else
              begin
                FileEnd := True;
              end;
              if L = CursorPos then if TextMode then SetCursor(J + 63, ScrLine) else
                SetCursor(HexIndent[J] + 11 + EditChar, ScrLine);
              Inc(L);
            end;
            if L >= ReadSize then FileEnd := True;
          end
          else
          begin
            asm
              mov di, word ptr L[0];
              mov bx, word ptr L[2];
              call MakeLine;
              mov word ptr L[0], di;
              mov word ptr L[2], bx;
            end;
          end;
        end
        else
        begin
          LineOffsets[ScrLine] := ReadSize;
        end;
        WriteBuf(0, ScrLine, Size.X, 1, DrawBuf);
        if CurScrCol < MaxByte then
        begin
          CurColumn := CurScrCol + Column;
          SetCursor(CurScrCol, CurScrLine);
          CurScrCol := MaxByte;
          O := False;
          if CurRealMove then
          begin
            CurRealMove := False;
            CurRealCol := CurColumn;
          end;
        end;
      end;
      if L > ReadSize then L := ReadSize;
      WinEnd := L;
      LineOffsets[Screen^.Size.Y] := L;
      if O and not HexaMode then SetCursor(Size.X, Size.Y);
      Title^.Text^[1] := InsertChars[InsertModes[HexaMode]];
      Title^.Text^[2] := ChangeChars[BufferChanged];
      Title^.Text^[3] := QuoteChars[QuoteMode];
      FillChar(Title^.Text^[4], 21, ' ');
      if HexaMode then
      begin
        if ShowLoadAddr then
        begin
          if (ReadSize >= 2) and (CursorPos >= 2) then
          begin
            T := 'Address $' + HexaStr(CursorPos + V, 8);
          end
          else
          begin
            T := 'Load address';
          end;
        end
        else
        begin
          T := 'Offset $' + HexaStr(CursorPos, 8);
        end;
        Move(T[1], Title^.Text^[5], Length(T));
      end
      else
      begin
        T := 'Line ' + LeadingSpace(CurLine + 1, 0);
        Move(T[1], Title^.Text^[5], Length(T));
        T := 'Col ' + LeadingSpace(CurColumn + 1, 0);
        Move(T[1], Title^.Text^[16], Length(T));
        FillChar(Title^.Text^[40], 3, ' ');
      end;
      if CursorPos < ReadSize then
      begin
        asm
          mov di, word ptr CursorPos[0];
          mov bx, word ptr CursorPos[2];
          call UnpackPtr;
          mov al, es:[di];
          mov C, al;
        end;
        if IsEOL and not HexaMode then T := 'EOL' else T := LeadingSpace(C, 3);
      end
      else
      begin
        T := 'EOF';
      end;
      Move(T[1], Title^.Text^[40], Length(T));
    end;
  end;
  Title^.DrawView;
end;

function TMiniHelp.GetPalette: PPalette;
const
  P: string[Length(CHelp)] = CHelp;
begin
  GetPalette := @P;
end;

procedure TMiniHelp.Draw;
var
  A             : Byte;
  I,
  J             : Integer;
  S,
  T             : string;
  B             : TDrawBuffer;

begin
  A := GetColor(1);
  MoveChar(B, ' ', A, Size.X);
  MoveChar(B, DoubleFrameChars[2], A, Size.X);
  B[0] := Ord(DoubleFrameChars[1]) + A shl 8;
  B[Size.X - 1] := Ord(DoubleFrameChars[4]) + A shl 8;
  case MiniHelpMode of
    mhExtension: S := 'extension';
    mhMenu: S := 'user menu';
  end;
  T := 'File format of ' + S + ' files:';
  S := stSpace + S + ' file help ';
  S[2] := UpCase(S[2]);
  MoveStr(B[(Size.X - Length(S)) shr 1], S, A);
  WriteBuf(0, 0, Size.X, 1, B);
  J := ScreenWidth shr 1 - 1;
  if J <= 40 then Inc(J, 4);
  for I := 0 to Size.Y - 3 do
  begin
    MoveChar(B, ' ', A, Size.X);
    case I of
      0:
      begin
        MoveStr(B[2], T, A);
        MoveStr(B[J], FrameChars[5]+' !:   %:   Drive letter', A);
      end;
      1: MoveStr(B[J], FrameChars[5]+' !\   %\   Path with backslash', A);
      2:
      begin
        if MiniHelpMode = mhMenu then MoveStr(B[2], '''TITLE Title     Title (in first line)', A);
        MoveStr(B[J], FrameChars[5]+' !/   %/   Path without backslash', A);
      end;
      3:
      begin
        case MiniHelpMode of
          mhExtension: MoveStr(B[2], '''TITLE Title     Title (in first line)', A);
          mhMenu: MoveStr(B[2], ''' comment        Comment line', A);
        end;
        MoveStr(B[J], FrameChars[5]+' !.!  %.%  Filename with extension', A);
      end;
      4:
      begin
        case MiniHelpMode of
          mhExtension: MoveStr(B[2], ''' comment        Comment line', A);
          mhMenu: MoveStr(B[2], 'M: Menu label    Appears in the menu', A);
        end;
        MoveStr(B[J], FrameChars[5]+' !    %    Filename w/o extension', A);
      end;
      5:
      begin
        case MiniHelpMode of
          mhExtension: MoveStr(B[2], 'txt:', A);
          mhMenu: MoveChar(B[2], #30, A, 1);
        end;
        MoveStr(B[7], 'edit !.!    Any DOS command', A);
        MoveStr(B[J], FrameChars[5]+' !`   %`   Extension without dot', A);
      end;
      6:
      begin
        case MiniHelpMode of
          mhExtension: MoveChar(B[3], #30, A, 1);
          mhMenu: MoveChar(B[2], FrameChars[5], A, 1);
        end;
        MoveStr(B[7], 'cls         Any additional commands', A);
        MoveStr(B[J], FrameChars[5]+' !@   %@   File list', A);
      end;
      7:
      begin
        MoveChar(B[3], FrameChars[2], A, 15);
        case MiniHelpMode of
          mhExtension:
          begin
            MoveChar(B[3], FrameChars[13], A, 1);
            MoveStr(B[19], 'File extension', A);
          end;
          mhMenu:
          begin
            MoveChar(B[2], FrameChars[13], A, 1);
            MoveStr(B[19], 'Hotkey', A);
          end;
        end;
        MoveStr(B[J], FrameChars[5]+' !!   %%   The characters ''!'', ''%''', A);
      end;
    end;
    B[0] := Ord(DoubleFrameChars[5]) + A shl 8;
    B[Size.X - 1] := Ord(DoubleFrameChars[5]) + A shl 8;
    WriteBuf(0, I + 1, Size.X, 1, B);
  end;
  MoveChar(B, DoubleFrameChars[2], A, Size.X);
  B[0] := Ord(DoubleFrameChars[13]) + A shl 8;
  B[Size.X - 1] := Ord(DoubleFrameChars[16]) + A shl 8;
  WriteBuf(0, Size.Y - 1, Size.X, 1, B);
end;

procedure TNameInputLine.InsertStr(S: string);
begin
  if Length(Data^) + Length(S) <= MaxLen then
  begin
    Insert(S, Data^, CurPos + 1);
    Inc(CurPos, Length(S));
    DrawView;
  end;
end;

function TNameInputLine.InsertName(S: string; Long, Path: Boolean): Boolean;
begin
  if Long then S := LongName(S, Path) else S := ShortName(S, Path);
  InsertStr(S);
end;

{Handle file name input line events}
procedure TNameInputLine.HandleEvent(var Event: TEvent);
var
  B             : Boolean;

{Complete the file name from a fragment}
procedure CompleteName;
var
  E,
  G,
  H,
  O,
  Q             : Boolean;
  B,
  F             : Byte;
  W             : Word;
  X,
  Y,
  Z             : Integer;
  A,
  P,
  R             : PHistoryItem;
  S,
  T,
  U,
  V             : string;
begin
  H := (CurHelpCtx > 100);
  if H then ChangeHelpCtx(hcHelp);
  F := 0;
  Q := False;
  G := (GetShiftState and (kbRightShift + kbLeftShift) > 0);
  for Y := 1 to CurPos - 1 do Q := Q xor (Data^[Y] = '"');
  if Q or not (Data^[CurPos] in WhiteSpace) or ((CurPos < Length(Data^)) and not (Data^[CurPos + 1] in WhiteSpace)) then
  begin
    Y := CurPos;
    O := Q;
    while (Y < Length(Data^)) and (O or not (Data^[Y + 1] in WhiteSpace)) do
    begin
      O := O xor (Data^[Y + 1] = '"');
      Inc(Y);
    end;
    X := CurPos;
    O := Q;
    while (X > 1) and (O or not (Data^[X - 1] in WhiteSpace)) do
    begin
      O := O xor (Data^[X - 1] = '"');
      Dec(X);
    end;
    O := False;
    S := Copy(Data^, X, Y - X + 1);
    repeat
      B := LeftPos('"', S);
      if B > 0 then S := Copy(S, 1, B - 1) + Copy(S, B + 1, MaxStrLen);
    until B = 0;
    if S <> '' then
    begin
      if (S = stCurrentDir) or (S = stParentDir) or (LongFileNames and (S = stWinRootDir)) then
        S := AddToPath(S, stEmpty, chDirSep);
      T := GetPath(S, chDirSep);
      S := CutPath(S, chDirSep);
      if not LongFileNames and (LeftPos('.', S) = 0) then S := S + stAllFilesDOS else S := S + stAllFilesUnix;
      E := True;
      if (T = '') and (PanelMode <> pmDOS) then T := stCurrentDir;
      F := 0;
      Q := False;
      A := nil;
      while not Q do
      begin
        if E then
        begin
          U := T;
        end
        else
        begin
          B := LeftPos(chPathSep, T);
          if B = 0 then B := Length(T) + 1;
          U := Copy(T, 1, B - 1);
          T := Copy(T, B + 1, MaxStrLen);
        end;
        LongFindFirst(AddToPath(U, S, chDirSep), (Archive + ReadOnly + SysFile + Hidden + Directory), CopyEntry);
        while (DOSError = 0) and not Q do
        begin
          V := CopyEntry.LongName;
          if (V[1] <> '.') or ((Length(V) > 1) and (V[2] <> '.')) then
          begin
            if CopyEntry.Orig.Attr and Directory > 0 then V := AddToPath(V, stEmpty, chDirSep);
            Inc(F);
            A := NewHistoryItem(stEmpty, V, F, False, A);
            if F = 1 then P := A;
            Q := (F >= HistoryMax);
          end;
          if not Q then LongFindNext(CopyEntry);
        end;
        LongFindClose(CopyEntry);
        Q := Q or E or (T = '');
      end;
      V := 'Files';
      if (F > 0) and (DisplayUserMenu(V, F, 0, 0, mtNone, P, @V, False, False) = cmOK) then
      begin
        if E then V := AddToPath(T, V, chDirSep);
        O := (V[Length(V)] = chDirSep);
        if G then V := LongName(V, E) else V := ShortName(V, E);
        if O then V := AddToPath(V, stEmpty, chDirSep);
        if X > 0 then Dec(X);
        if Length(Data^) + X - Y + Length(V) < CmdLineLen then
        begin
          CurPos := X;
          Delete(Data^, X + 1, Y - X);
          InsertStr(V);
        end
        else
        begin
          F := 0;
        end;
      end;
    end;
  end;
  GoSound := (F = 0);
  if H then RestoreHelpCtx;
end;

begin
  if (Event.What and evKeyboard > 0) and not Quote then
  begin
    B := (GetShiftState and (kbRightShift + kbLeftShift) > 0);
    case Event.KeyCode of
      kbCtrlJ, kbCtrlEnter: InsertName(CutPath(ImageName, chDirSep), B, False);
      kbCtrlBra, kbCtrlKet:
      begin
        InsertName(GetPath(ImageName, chDirSep), B, True);
        ClearEvent(Event);
      end;
      kbCtrlTab:
      begin
        CompleteName;
        ClearEvent(Event);
      end;
    end;
  end;
  TInputLine.HandleEvent(Event);
end;

procedure ToggleCharSet(B: Byte);
begin
  if CanChangeChars and (ViewMode <> vmASCII) then
  begin
    ECharSetMode := ECharSetMode xor B;
    CharStartMode := ECharSetMode;
    Application^.SetCharSet(CharStartMode, True, False);
    LastHalfSec := MaxByte;
    RedrawAllViews;
    MakeTitle;
    Screen^.DrawView;
  end;
end;

procedure ClockOffProc; far;
begin
end;

procedure ClockOnProc; far;
begin
end;

procedure GetClockProc(B: Boolean); far;
begin
end;

procedure SetClockProc; far;
begin
end;

constructor TCmdrEditor.Init;
var
  B             : Byte;
  D             : PDialog;
  P,
  N             : string;
  R             : TRect;
begin
  CanChangeChars := True;
  InitMouse;
  if Standard then
  begin
    MouseInit.X := ShellBuffer^.MouseX;
    MouseInit.Y := ShellBuffer^.MouseY;
    MouseInitMax.X := ShellBuffer^.MouseMaxX;
    MouseInitMax.Y := ShellBuffer^.MouseMaxY;
  end
  else
  begin
    MouseInit.X := -1;
  end;
  CommandOutput := coNormal;
  InitDOSMem;
  TApplication.Init;
  HelpNum := 0;
  GoSound := False;
  MakeSound := True;
  SysErrorFunc := SysErrorWin;
  EmergencyExitFunc := EmergencyExit;
  CtrlAltInsActive := True;
  Randomize;
  BoxTitle := 'Edit';
  CurHelpCtx := hcNormal;
  AppHelpCtx := CurHelpCtx;
  MenuInUse := False;
  HelpInUse := False;
  HelpCtxSet := False;
  MouseRightHeld := False;
  LoadingDirs := True;
  CopyExtDisk := ExtendedDisk;
  PanelCur := 0;
  FirstSelect := True;
  ImageOn := True;
  HexaMode := False;
  ShowSymbols := False;
  BackupFiles := False;
  DirMode := False;
  FixLineLen := ScreenWidth;
  ScrWidth := ScreenWidth;
  ReadingFile := True;
  PanelDir := nil;
  EditBuffer := nil;
  InsertName := '';
  AppendName := '';
  EnableMiniHelp := True;
  DefMiniHelpMode := mhNone;
  MiniHelpMode := mhNone;
  InitSaver;
  if MemoryCfgOK then
  begin
    HexaMode := ShellBuffer^.HexaMode;
    ShowLoadAddr := ShellBuffer^.ShowLoadAddr;
    ShowSymbols := ShellBuffer^.ShowSymbols;
    FixLineLen := ShellBuffer^.FixLineLen;
    EOLChars[3] := Chr(ShellBuffer^.UserLineFeed);
    BackupFiles := ShellBuffer^.BackupFiles;
  end;
  ClockOn := ClockOnProc;
  ClockOff := ClockOffProc;
  GetClock := GetClockProc;
  SetClock := SetClockProc;
  InitScreen;
  InitCountry;
  InitLongNames;
  InitClipboard;
  Buffer := ScreenBuffer;
  R.Assign(0, 0, ScreenWidth, ScreenHeight);
  ChangeBounds(R);
  WinSize := R.B.Y - R.A.Y - 2;
  WinCenter := (WinSize - 6) shr 1;
  ScrSize := WinSize;
  PanLen := ScrSize - 3;
  Background^.DrawView;
  ImageName := LongParamStr(MaxByte);
  ImagePath := '';
  ReadName := '';
  ReadDirPos := MaxWord;
  if not Standard then Prepare;
  LongFSplit(ImageName, P, N, ImageExt);
  if Resident and Standard then
  begin
    ImagePath := ShellBuffer^.ViewImagePath;
    ReadName := ShellBuffer^.ViewFileName;
    ReadDirPos := ShellBuffer^.ViewDirPos;
  end;
  MakeFullName;
  ErrorDown := 4;
  Locations := New(PLocBuffer);
  SafetyHeap := New(PSafetyHeap);
  DoneDOSMem;
  asm
    mov bx, MaxWord;
    mov ah, $48;
    int $21;
    push bx;
    mov ah, $48;
    int $21;
    xor dx, dx;
    mov word ptr DOSHeap[0], dx;
    mov word ptr DOSHeap[2], ax;
    pop ax;
    sub ax, 20;
    sub dx, 0;
    mov word ptr DOSHeapSize[0], ax;
    mov word ptr DOSHeapSize[2], dx;
  end;
  DOSHeapSize := DOSHeapSize shl 4 - UpperHeapSize;
  InitDOSMem;
  Dispose(SafetyHeap);
  InitEditor;
  Title := New(PTitle, Init);
  R.Assign(0, 1, ScreenWidth, ScrSize + 1);
  Screen := New(PScreen, Init(R));
  R.Assign(0, WinSize + 1 - HelpHeight, ScreenWidth, WinSize + 1);
  MiniHelp := New(PMiniHelp, Init(R));
  MiniHelp^.Hide;
  OpenFile(False);
  if FileOK then
  begin
    if PanelNewMode = pmDOS then MenuBar^.DisableCommands([cmESelectFile]) else
      MenuBar^.EnableCommands([cmESelectFile]);
    ErrorDown := 0;
    KeyBar^.Update;
    KeyBar^.Show;
    SetHexaMode(HexaMode, False);
    if (PanelMode = pmDOS) or ((PanelMode = pmDisk) and GEOSFormat) then SetViewMode(vmASCII, False) else
      SetViewMode(vmPETSCII, False);
    OrigViewMode := ViewMode;
    SetTabMode(TabMode, False);
    MakeTitle;
    Insert(Title);
    Insert(Screen);
    Insert(MiniHelp);
    WentToCorner := False;
    LastWhere := MouseWhere;
    Title^.MakeFirst;
    Screen^.MakeFirst;
    MiniHelp^.MakeFirst;
    KeyBar^.MakeFirst;
    LastHalfSec := 2;
    Screen^.DrawView;
    MiniHelp^.DrawView;
    Screen^.ShowCursor;
  end;
end;

destructor TCmdrEditor.Done;
begin
  TApplication.Done;
  asm
    mov ah, 3;
    xor bh, bh;
    call VideoInt;
    mov ah, 2;
    xor bh, bh;
    xor dl, dl;
    dec dh;
    call VideoInt;
  end;
end;

procedure TCmdrEditor.SetCharSet(Mode: Byte; On, Force: Boolean);
var
  B             : Byte;
  S             : string[16];
begin
  GetMouse(False);
  if On and (Mode >= csCBMLower) then
  begin
    if HiResScreen then
    begin
      if Force or (CharSetMode <= csIBMUpper) then
      begin
        asm
          push ds;
          push bp;
          mov ax, $0040;
          mov es, ax;
          mov dl, es:[$0085];
          cmp dl, 16;
          jne @4;
          mov bp, Offset(AltCharBuffer);
          mov ax, Seg(AltCharBuffer);
          jmp @5;
      @4: xor dh, dh;
          mov cx, dx;
          xor di, di;
      @1: mov ax, di;
          shl ax, 3;
          div dl;
          mov ss:[di][Offset(S)], al;
          inc di;
          loop @1;
          mov si, Offset(CharBuffer);
          push ds;
          pop es;
          mov ax, Seg(CharBuffer);
          mov ds, ax;
          xor ah, ah;
          mov al, dl;
          xor bh, bh;
          xor bp, bp;
          mov cx, $0100;
      @3: xor di, di;
      @2: mov bl, ss:[di][Offset(S)];
          mov dh, [si][bx];
          mov byte ptr es:GCRBuffer[di][bp], dh;
          inc di;
          cmp di, ax;
          jb @2;
          add si, 8;
          add bp, ax;
          loop @3;
          mov bp, Offset(GCRBuffer);
          mov ax, Seg(GCRBuffer);
      @5: mov es, ax;
          mov bh, dl;
          xor bl, bl;
          mov cx, $0100;
          xor dx, dx;
          mov ax, $1100;
          call VideoInt;
          pop bp;
          pop ds;
          cmp EightColFont, False;
          je @6;
          cli;
          mov dx, $03CC;
          in al, dx;
          and al, $F3;
          mov dx, $03C2;
          out dx, al;
          mov dx, $03C4;
          mov al, $01;
          out dx, al;
          inc dx;
          in al, dx;
          mov bh, al;
          or al, $01;
          out dx, al;
          mov dx, $03DA;
          in al, dx;
          mov dx, $03C0;
          mov al, $13;
          out dx, al;
          mov al, $00;
          out dx, al;
          mov al, $20;
          out dx, al;
          sti;
      @6:
        end;
        SetBlinkBright(True);
      end;
      CharSetMode := Mode;
    end
    else
    begin
      CharStartMode := CharStartMode and csLowerUpper;
    end;
  end
  else
  begin
    B := Ord(GetPalette^[PaletteLen - 1]);
    if CharSetMode > csIBMUpper then
    begin
      if EightColFont then
      begin
        SetVideoMode(ScreenMode);
      end
      else
      begin
        asm
          mov ax, $0040;
          mov es, ax;
          mov dl, es:[$0085];
          mov bh, 2;
          cmp dl, 14;
          je @1;
          mov bh, 3;
          cmp dl, 8;
          je @1;
          mov bh, 6;
          cmp dl, 16;
          jne @2;
      @1: push bp;
          push dx;
          push bx;
          mov ax, $1130;
          int $10;
          pop bx;
          cmp bh, 6;
          jne @3;
          push ds;
          push es;
          pop ds;
          pop es;
          push es;
          mov si, bp;
          mov di, Offset(GCRBuffer);
          mov cx, $1000;
          cld;
          rep movsw;
          pop ds;
      @4: push ds;
          pop es;
          mov bp, Offset(GCRBuffer);
      @3: pop dx;
          mov bh, dl;
          xor bl, bl;
          mov cx, $0100;
          xor dx, dx;
          mov ax, $1100;
          call VideoInt;
          pop bp;
      @2:
        end;
      end;
    end;
    SetBlinkBright(B > 0);
    if On then CharSetMode := Mode;
  end;
  SetMouse;
  FrameChars := DefFrameChars;
  MenuFrameChars := DefMenuFrameChars;
  if (CharSetMode >= csCBMLower) or (CodePage = CodePageUS) then
  begin
    DoubleFrameChars := DefDoubleFrameChars;
    CheckedChar := DefCheckedChar;
    DotChar := DefDotChar;
  end
  else
  begin
    DoubleFrameChars := AltDefDoubleFrameChars;
    CheckedChar := AltDefCheckedChar;
    DotChar := AltDefDotChar;
  end;
end;

procedure TCmdrEditor.InitKeyBar;
var
  P             : PStatusDef;
  R             : TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  TabStatus := NewStatusKey('      ', kbF9, cmETabMode,
    NewStatusKey('Quit', kbF10, cmCancel,
    nil));
  HexaStatus := NewStatusKey('      ', kbF4, cmEHexaMode,
    NewStatusKey('Copy', kbF5, cmECopy,
    NewStatusKey('Move', kbF6, cmEMove,
    NewStatusKey('Search', kbF7, cmESearch,
    NewStatusKey('Delete', kbF8, cmEDelete,
    TabStatus)))));
  SymbolStatus := NewStatusKey('      ', kbShiftF9, cmEShowSymbol,
    NewStatusKey('Q&Save', kbShiftF10, cmESaveQuit,
    nil));
  ContSearchStatus := NewStatusKey('      ', kbShiftF7, cmEContSearch,
    NewStatusKey('View', kbShiftF8, cmEViewMode,
    SymbolStatus));
  LoadAddrStatus := NewStatusKey('      ', kbShiftF4, cmELoadAddr,
    NewStatusKey('LnLen', kbShiftF5, cmESetLineLen,
    NewStatusKey('UserLF', kbShiftF6, cmESetUserEOL,
    ContSearchStatus)));
  MiniHelpStatus := NewStatusKey('FilHlp', kbShiftF1, cmEMiniHelp,
      NewStatusKey('SaveAs', kbShiftF2, cmESaveAs,
      NewStatusKey('Unmark', kbShiftF3, cmEUnmark,
      LoadAddrStatus)));
  KeyBar := New(PKeyBar, Init(R,
    NewStatusDef(hcNoContext, hcNoContext,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      nil)))))))))),
    NewStatusDef(hcNoContext + 1, hcESearch - 1,
      NewStatusKey('Help', kbF1, cmHelp,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcESearch, hcESearch,
      NewStatusKey('Help', kbF1, cmHelp,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcESelectFile, hcESelectFile,
      NewStatusKey('Help', kbF1, cmHelp,
      NewEmptyKey(
      NewEmptyKey(
      NewStatusKey('Edit', kbF4, cmELoadFile,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewStatusKey('Raw', kbF9, cmERawView,
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcOnlyQuit, hcOnlyQuit,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcNormal, hcNormal,
      NewStatusKey('Help', kbF1, cmHelp,
      NewStatusKey('Save', kbF2, cmESave,
      NewStatusKey('Mark', kbF3, cmEMark,
      HexaStatus))),
    NewStatusDef(hcShift, hcShift,
      MiniHelpStatus,
    NewStatusDef(hcAlt, hcAlt,
      NewEmptyKey(
      NewStatusKey('ChCase', kbAltF2, cmEChangeCase,
      NewStatusKey('Convrt', kbAltF3, cmEConvert,
      NewStatusKey('Select', kbAltF4, cmESelectFile,
      NewStatusKey('Insert', kbAltF5, cmEInsert,
      NewStatusKey('LnFeed', kbAltF6, cmEEOLMode,
      NewStatusKey('Replac', kbAltF7, cmEReplace,
      NewStatusKey('Goto', kbAltF8, cmEGoto,
      NewStatusKey('Backup', kbAltF9, cmEBackup,
      NewStatusKey('Append', kbAltF10, cmEAppend,
      nil)))))))))),
    nil))))))))));
  KeyBar^.Hide;
  LastShiftState := MaxByte;
end;

procedure TCmdrEditor.Idle;
var
  O             : Boolean;
  B             : Byte;
  I             : Integer;
  L             : Longint;
begin
  if SaverInUse then
  begin
    ScreenSaver^.Idle;
  end
  else
  begin
    if (SaverTicks > 0) and (GetTicks > SaverCount + SaverTicks) and
      ((MouseWhere.X < ScreenWidth - 2) or (MouseWhere.Y < ScreenHeight - 1)) then SaverOn;
  end;
  if not SaverInUse then
  begin
    if GoSound then
    begin
      if ErrorSound then
      begin
        Beep;
        LastHalfSec := 2;
        TopView^.DrawView;
      end;
      GoSound := False;
    end;
  end;
  B := GetShiftState;
  if B <> LastShiftState then
  begin
    SaverCount := GetTicks;
    if SaverInUse then SaverOff;
    MouseRightHeld := False;
    if HelpCtxSet and not HelpInUse then
    begin
      ShiftHelpCtx := hcNoContext;
      AltHelpCtx := hcNoContext;
      if B = 0 then AppHelpCtx := CurHelpCtx else AppHelpCtx := hcNoContext;
    end
    else
    begin
      if HelpInUse then
      begin
        ShiftHelpCtx := hcNoContext;
        AltHelpCtx := hcNoContext;
      end
      else
      begin
        ShiftHelpCtx := hcShift;
        AltHelpCtx := hcAlt;
      end;
      if B = 0 then if HelpInUse then AppHelpCtx := hcOnlyQuit else AppHelpCtx := hcNormal;
      if B and (kbRightShift + kbLeftShift) > 0 then if HelpInUse then AppHelpCtx := hcNoContext else AppHelpCtx := hcShift;
      if B and kbCtrlShift > 0 then AppHelpCtx := hcNoContext;
      if B and kbAltShift > 0 then AppHelpCtx := hcAlt;
    end;
    if B and kbAltShift = 0 then
    begin
      if AltShiftPressed then
      begin
        AltShiftPressed := False;
        ToggleCharSet(csLowerUpper);
      end;
    end
    else
    begin
      if B and (kbRightShift + kbLeftShift) > 0 then
      begin
        AltShiftPressed := True;
      end
      else
      begin
        if AltShiftPressed then
        begin
          AltShiftPressed := False;
          ToggleCharSet(csLowerUpper);
        end;
      end;
    end;
    if (B and (kbRightShift + kbLeftShift) > 0) and (B and kbCtrlShift > 0) then
    begin
      if LastShiftState and (kbRightShift + kbLeftShift + kbCtrlShift) <> (kbRightShift + kbLeftShift + kbCtrlShift) then
        CtrlShiftPressed := True;
    end
    else
    begin
      if CtrlShiftPressed then
      begin
        CtrlShiftPressed := False;
        ToggleCharSet(csIBMCBM);
      end;
    end;
    LastShiftState := B;
  end;
  TApplication.Idle;
end;

procedure TCmdrEditor.GetEvent(var Event: TEvent);
var
  F,
  O             : Boolean;
  S             : string;
  E             : TEvent;
begin
  TApplication.GetEvent(Event);
  if CtrlAltInsHit then EmergencyExit;
  if GoSound or ((MouseButtons > 0) and (Event.What and evKeyboard > 0)) then ClearEvent(Event);
  if Event.What = evNothing then
  begin
    if WentToCorner and (MouseWhere.X >= ScreenWidth - 2) and (MouseWhere.Y = 0) and (GetTicks > SaverCount + QuarterTicks) and
      not SaverInUse and (GetShiftState = 0) then
    begin
      SaverOn;
      WentToCorner := False;
      LastWhere := Event.Where;
      ClearEvent(Event);
    end;
  end
  else
  begin
    CtrlShiftPressed := False;
    AltShiftPressed := False;
    SaverCount := GetTicks;
    if (Event.What and evMouseMove > 0) and (Event.Where.X >= ScreenWidth - 2) and (Event.Where.Y = 0) and
      ((LastWhere.X < ScreenWidth - 2) or (LastWhere.Y > 0)) then
    begin
      WentToCorner := True;
    end
    else
    begin
      if SaverInUse then ScreenSaver^.HandleEvent(Event);
      if Event.What and evMouse > 0 then LastWhere := Event.Where;
    end;
  end;
  if (Event.What and evCommand > 0) then
  begin
    if (Event.Command = cmHelp) and not HelpInUse then
    begin
      MouseRightHeld := False;
      HelpNum := hcKeyEdit1;
      Screen^.HideCursor;
      _Help;
      Screen^.ShowCursor;
      TopView^.SetState(sfFocused, True);
      ClearEvent(Event);
    end;
  end;
  if (Event.What and evMouseDown > 0) and (HelpCtxSet or HelpInUse) then
  begin
    F := TopView^.MouseInView(Event.Where);
    E.What := evKeyboard;
    E.KeyCode := kbNoKey;
    if Event.Buttons and mbMiddleButton > 0 then
    begin
      F := True;
      E.KeyCode := kbEnter;
    end
    else if (Event.Buttons and mbRightButton > 0) and not F then E.KeyCode := kbEsc else
      if (Event.Buttons and mbLeftButton > 0) and not F then E.KeyCode := kbEsc;
    if E.KeyCode <> kbNoKey then
    begin
      repeat
        O := F or not TopView^.MouseInView(Event.Where);
        if O then
        begin
          if E.KeyCode = kbEnter then SetDefMouseCursorChar(CheckedChar) else SetDefMouseCursorChar(CancelledChar);
        end
        else
        begin
          SetDefMouseCursorChar(EmptyMouseCursorChar);
        end;
      until not MouseEvent(Event, evMouseMove);
      SetDefMouseCursorChar(EmptyMouseCursorChar);
      if O then PutEvent(E);
    end;
  end;
end;

procedure TCmdrEditor.HandleEvent(var Event: TEvent);
begin
  if Event.What and evKeyboard > 0 then
  begin
    case Event.KeyCode of
      kbEnter: if DirMode then
      begin
        LoadFile(False);
        ClearEvent(Event);
      end;
      kbEsc:
      begin
        Event.What := evCommand;
        Event.Command := cmCancel;
      end;
    end;
  end;
  if Event.What and evMouse > 0 then if MouseButtons and mbRightButton = 0 then MouseRightHeld := False;
  if Event.What and evCommand > 0 then
  begin
    case Event.Command of
      cmCancel: EQuit(True);
      cmESave: SaveFile(False, False);
      cmEHexaMode: SetHexaMode(not HexaMode, True);
      cmESearch: Search(False, False);
      cmETabMode: SetTabMode(not TabMode, True);
      cmEMiniHelp: ToggleMiniHelp;
      cmESaveAs: SaveFile(True, False);
      cmELoadAddr: ToggleLoadAddress;
      cmESetLineLen: SetUserEOL(False);
      cmESetUserEOL: SetUserEOL(True);
      cmEContSearch: Search(True, ReplaceMode);
      cmEConvert: SetViewMode(MaxByte, True);
      cmEShowSymbol: ToggleSymbols;
      cmESaveQuit:
      begin
        BufferChanged := True;
        EQuit(False);
      end;
      cmEChangeCase: ChangeCase;
      cmEViewMode: SetViewMode(MaxByte, False);
      cmESelectFile: SelectFile;
      cmEInsert: OpenFile(True);
      cmEEOLMode: SetEOLMode(MaxByte, True);
      cmEReplace: Search(False, True);
      cmEGoto: _Goto;
      cmEBackup: ToggleBackup;
      cmEAppend: SaveFile(True, True);
      cmELoadFile: LoadFile(False);
      cmERawView: LoadFile(True);
    end;
  end;
  TApplication.HandleEvent(Event);
end;

procedure PrintTitle;
begin
  if not TitlePrinted then
  begin
    TitlePrinted := True;
    PrintStr(TitleStr + ' Editor' + VersionStr + chCR + chLF + CopyrightStr + chCR + chLF + chCR + chLF);
  end;
end;

begin
  MainProgram := False;
  if Test8086 = 0 then
  begin
    PrintTitle;
    PrintStr('This program requires an 80286 CPU or above' + chCR + chLF);
  end
  else
  begin
    PanelMode := pmDOS;
    FatalError := '';
    TextScreen(nil);
    CheckResident;
    SetStandardParams;
    if Resident and (ShellBuffer^.BatchMode <> bmNone) then Standard := False;
    if Resident and not Standard then Resident := False;
    if ParamCount = 0 then
    begin
      if not Standard then
      begin
        PrintTitle;
        PrintStr('Usage: SCEDIT <filename>' + chCR + chLF);
      end;
    end
    else
    begin
      if DOSVersion < $0314 then
      begin
        if not Standard then
        begin
          PrintTitle;
          PrintStr('This program requires DOS version 3.20 or later' + chCR + chLF);
        end;
      end
      else
      begin
        LoadConfig;
        if Resident then
        begin
          CharStartMode := ShellBuffer^.CharSetMode;
          CharSetMode := CharStartMode;
          ECharSetMode := CharStartMode;
        end;
        if Standard then
        begin
          ScreenCol := StdScreenCol;
          MouseReverse := StdMouseReverse;
        end;
        SearchInHex := False;
        SearchStr := '';
        PanelMode := pmDOS;
        if Resident then
        begin
          if Standard then
          begin
            PanelMode := ShellBuffer^.ViewPanelMode;
            if PanelMode = pmInfo then PanelMode := pmDOS;
          end;
          ReplaceMode := ShellBuffer^.ReplaceMode;
          SearchInHex := ShellBuffer^.SearchInHex;
          SearchText := ShellBuffer^.SearchText;
          SearchHex := ShellBuffer^.SearchHex;
          ReplaceText := ShellBuffer^.ReplaceText;
          ReplaceHex := ShellBuffer^.ReplaceHex;
          SearchStr := SearchText;
          DisableWinClipboard := ShellBuffer^.DisableWinClipboard;
        end;
        if MemAvail < 16000 then
        begin
          if not Standard then PrintStr('There is not enough memory to execute the Commander Editor' + chCR + chLF);
        end
        else
        begin
          CmdrEditor.Init;
          if FileOK then CmdrEditor.Run;
          if not Resident then Application^.SetCharSet(csIBMLower, False, False);
          CmdrEditor.Done;
          if Resident then
          begin
            ShellBuffer^.HexaMode := HexaMode;
            ShellBuffer^.ShowLoadAddr := ShowLoadAddr;
            ShellBuffer^.ShowSymbols := ShowSymbols;
            ShellBuffer^.FixLineLen := FixLineLen;
            ShellBuffer^.UserLineFeed := Ord(EOLChars[3]);
            ShellBuffer^.BackupFiles := BackupFiles;
            ShellBuffer^.ReplaceMode := ReplaceMode;
            ShellBuffer^.SearchInHex := SearchInHex;
            ShellBuffer^.SearchText := SearchText;
            ShellBuffer^.SearchHex := SearchHex;
            ShellBuffer^.ReplaceText := ReplaceText;
            ShellBuffer^.ReplaceHex := ReplaceHex;
            ShellBuffer^.CharSetMode := CharSetMode;
          end
          else
          begin
            DoneClipboard;
          end;
        end;
      end;
    end;
  end;
end.
