
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   SCMAIN.PAS                    }
{                                                 }
{          The Star Commander main unit           }
{*************************************************}

program The_Star_Commander;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 20480, 0, 655360}

uses
  App, Dialogs, DOS, Drivers, Memory, Menus, Objects, Overlay, OverXMS, Views,
  AppFunc, Base1, Base2, Clipbrd, Constant, DOSShell, ExtFiles, Help, LowLevel, MiscFunc,
  OpenCBM, Panel1, Panel2, Reinit, Script, Transfer, XferLo,
  UsrMnu, SmallFn, MainFn1, MainFn2, Config, Disked, Cpdisk, Info, Attrib;

{$O APPFUNC}
{$O BASE1}
{$O DOSSHELL}
{$O MISCFUNC}
{$O REINIT}
{$O SCRIPT}
{$O TRANSFER}
{$O XFERLO}
{$O FCOPY}
{$O FDELETE}
{$O FRENMOV}
{$O FROPEN}
{$O FRCLOSE}
{$O FREAD}
{$O FWPREP}
{$O FWOPEN}
{$O FWCLOSE}
{$O FWRITE}
{$O HELP}
{$O USRMNU}
{$O SMALLFN}
{$O MAINFN1}
{$O MAINFN2}
{$O CFGMENUS}
{$O CONFIG}
{$O COLORS}
{$O DISKED}
{$O CPDISK}
{$O INFO}
{$O ATTRIB}

type
{Main program}
  TCommander    = object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure SetCharSet(Mode: Byte; On, Force: Boolean); virtual;
    procedure InitMenuBar; virtual;
    procedure InitKeyBar; virtual;
    procedure Idle; virtual;
    procedure GetEvent(var Event: TEvent); virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

var
  CtrlShiftPressed,
  AltShiftPressed: Boolean;
  Commander     : TCommander;

{Turn the clock off}
procedure ClockOffProc; far;
begin
  if ClockVis and (Clock <> nil) then
  begin
    Clock^.Hide;
    CommandLine^.HideCursor;
  end;
end;

{Turn the clock on}
procedure ClockOnProc; far;
begin
  if not ClockVis and (Clock <> nil) and (BatchMode = bmNone) then
  begin
    Clock^.Show;
    CommandLine^.ShowCursor;
  end;
end;

{Save the current status of the clock and turn it on/off
  Input : B: when True, the clock is turned on; otherwise off}
procedure GetClockProc(B: Boolean); far;
begin
  ClockLast := ClockVis;
  if B then ClockOn else ClockOff;
end;

{Re-load the status of the clock}
procedure SetClockProc; far;
begin
  if ClockLast then ClockOn else ClockOff;
end;

{Change the character set to IBM or C64
  Input : Mode: character set to change to
          On: when True, store code of specified character set
          Force: when True, force changing to the specified character set}
procedure TCommander.SetCharSet(Mode: Byte; On, Force: Boolean);
begin
  AppFunc.SetCharSet(Mode, On, Force, GetPalette);
end;

{Reinitialize the main program at start or after finishing a DOS shell
  Input : Start: when True, the main program was just started, otherwise
                 returned from a DOS shell}
procedure Reinitialize(Start: Boolean);
begin
  ClockOn := ClockOnProc;
  ClockOff := ClockOffProc;
  GetClock := GetClockProc;
  SetClock := SetClockProc;
  Reinit.Reinitialize(Start);
end;

{Initialize the main program}
constructor TCommander.Init;
begin
  CanChangeChars := True;
  CommandOutput := ShellBuffer^.CommandOutput;
  OrigBackCursorY := ShellBuffer^.OrigBackCursorY;
  BackCursorY := ShellBuffer^.BackCursorY;
  BackAttr := ShellBuffer^.BackAttr;
  CharSetMode := ShellBuffer^.CharSetMode;
  Act := nil;
  SysErrorFunc := SysErrorWin;
  EmergencyExitFunc := EmergencyExit;
  CtrlAltInsActive := True;
  AppHelpCtx := hcNormal;
  CurHelpCtx := AppHelpCtx;
  LoadConfig;
  if ShellBuffer^.First then
  begin
    if DefScreenCol <> apAuto then ScreenCol := DefScreenCol;
    VESASupport := VESASupport and ShellBuffer^.VESASupport;
  end;
  InitMouse;
  if CommandOutput = coNormal then
  begin
    MouseInit.X := ShellBuffer^.MouseX;
    MouseInit.Y := ShellBuffer^.MouseY;
  end;
  MouseInitMax.X := ShellBuffer^.MouseMaxX;
  MouseInitMax.Y := ShellBuffer^.MouseMaxY;
  TApplication.Init;
  Reinitialize(not Resident);
end;

{Leave the main program}
destructor TCommander.Done;
begin
  TApplication.Done;
  if ShellBuffer^.QuitProgram then
  begin
    asm
      mov ah, 3;
      xor bh, bh;
      call VideoInt;
      mov ah, 2;
      xor bh, bh;
      xor dl, dl;
      dec dh;
      call VideoInt;
    end;
  end;
end;

{Initialize the menu bar}
procedure TCommander.InitMenuBar;
begin
  AppFunc.InitMenuBar;
end;

{Initialize the function key bar}
procedure TCommander.InitKeyBar;
begin
  AppFunc.InitKeyBar;
end;

{Perform background tasks: beep on errors, update the clock, run the screen
  saver, update the function key bar whenever a shift key is pressed or
  released, pop up the menu on Alt taps}
procedure TCommander.Idle;
var
  F,
  O             : Boolean;
  B             : Byte;
  I             : Integer;
  L             : Longint;
  E             : TEvent;
begin
  if SaverInUse then
  begin
    ScreenSaver^.Idle;
  end
  else
  begin
    if (SaverTicks > 0) and (GetTicks > SaverCount + SaverTicks) and
      ((MouseWhere.X < ScreenWidth - 2) or (MouseWhere.Y < ScreenHeight - 1)) then SaverOn;
    if TurboOffed and (GetTicks > TurboOffCount) then TurboOffDecouple;
  end;
  if not SaverInUse then
  begin
    if not SysError then
    begin
      Clock^.MakeFirst;
      Clock^.DrawView;
    end;
    if GoSound then
    begin
      if ErrorSound then
      begin
        if ClockVis then Clock^.Hide;
        Beep;
        if not SysError then
        begin
          ClockOn;
          LastHalfSec := 2;
        end;
      end;
      GoSound := False;
    end;
  end;
  B := GetShiftState;
  if B <> LastShiftState then
  begin
    SaverCount := GetTicks;
    if SaverInUse then SaverOff;
    ShiftHeld := False;
    MouseRightHeld := False;
    F := (CurHelpCtx = hcDiskEdit2);
    if HelpCtxSet and not HelpInUse and not F then
    begin
      ShiftHelpCtx := hcNoContext;
      AltHelpCtx := hcNoContext;
      if B = 0 then AppHelpCtx := CurHelpCtx else AppHelpCtx := hcNoContext;
    end
    else
    begin
      if HelpInUse then
      begin
        ShiftHelpCtx := hcNoContext;
        AltHelpCtx := hcNoContext;
      end
      else
      begin
        ShiftHelpCtx := hcShift;
        AltHelpCtx := hcAlt;
      end;
      O := (HelpInUse or MenuInUse);
      if B = 0 then if O then AppHelpCtx := hcOnlyQuit else if F then AppHelpCtx := hcDiskEdit2 else AppHelpCtx := hcNormal;
      if B and (kbRightShift + kbLeftShift) > 0 then if O then AppHelpCtx := hcNoContext else
        if F then AppHelpCtx := hcDiskedShift else AppHelpCtx := hcShift;
      if B and kbCtrlShift > 0 then if O or F then AppHelpCtx := hcNoContext else AppHelpCtx := hcControl;
      if B and kbAltShift > 0 then if O then AppHelpCtx := hcNoContext else
        if F then AppHelpCtx := hcDiskedAlt else AppHelpCtx := hcAlt;
    end;
    if B and kbAltShift = 0 then
    begin
      asm
        mov O, False;
        mov ah, ReadKeyFunc;
        inc ah;
        int $16;
        jne @1;
        inc O;
    @1:
      end;
      if AltPressed then
      begin
        AltPressed := False;
        if AltPopsMenu and O then
        begin
          E.What := evCommand;
          if MenuInUse then E.Command := cmCancel else E.Command := cmPanelMenu;
          PutEvent(E);
        end;
      end;
      if AltShiftPressed then
      begin
        AltShiftPressed := False;
        ToggleCharSet(csLowerUpper);
      end;
    end
    else
    begin
      AltPressed := ((B or LastShiftState) and (kbRightShift + kbLeftShift + kbCtrlShift) = 0);
      if B and (kbRightShift + kbLeftShift) > 0 then
      begin
        AltShiftPressed := True;
      end
      else
      begin
        if AltShiftPressed then
        begin
          AltShiftPressed := False;
          ToggleCharSet(csLowerUpper);
        end;
      end;
    end;
    if (B and (kbRightShift + kbLeftShift) > 0) and (B and kbCtrlShift > 0) then
    begin
      if LastShiftState and (kbRightShift + kbLeftShift + kbCtrlShift) <> (kbRightShift + kbLeftShift + kbCtrlShift) then
        CtrlShiftPressed := True;
    end
    else
    begin
      if CtrlShiftPressed then
      begin
        CtrlShiftPressed := False;
        ToggleCharSet(csIBMCBM);
      end;
    end;
    LastShiftState := B;
  end;
  TApplication.Idle;
end;

{Get events and handle special events: on putting the mouse cursor into upper
  right corner, start screen saver; on Ctrl-Alt-BackSpace, reset the external
  Commodore drives; on F1, pop up the online help; on pressing a mouse button
  outside the current dialog box, cancel or confirm the dialog box; also,
  display mouse icon over screen hot spots
  Input : Event: event record to fill}
procedure TCommander.GetEvent(var Event: TEvent);
var
  F,
  O             : Boolean;
  B             : Byte;
  P             : TPoint;
  E             : TEvent;

function PanelHotSpots(Panel: PPanel): Boolean;
var
  B             : Boolean;
  W,
  X             : Byte;
begin
  PanelHotSpots := False;
  if Panel^.Vis and Panel^.MouseInView(MouseWhere) then
  begin
    PanelHotSpots := True;
    Panel^.MakeLocal(MouseWhere, P);
    if (P.X = 0) or (P.X = Panel^.Size.X - 1) then
    begin
      if ((P.X = Panel^.Size.X - 1) and (Panel = Left)) or ((P.X = 0) and (Panel = Right)) then
      begin
        O := True;
        SetMouseCursorChar(DoubleArrowChars[1]);
      end;
    end
    else if P.Y = Panel^.Size.Y - 1 then
    begin
      O := True;
      SetMouseCursorChar(DoubleArrowChars[2]);
    end
    else
    begin
      if (Panel^.Mode <> pmInfo) and (Panel^.QuickView in [qvNone, qvNormal]) then
      begin
        if (P.Y < 2) and (P.Y >= 1 - Byte(ShowMenu)) then
        begin
          O := True;
          SetMouseCursorChar(ArrowChars[4]);
        end
        else if (P.Y >= Panel^.PanSize + 2) then
        begin
          O := True;
          SetMouseCursorChar(ArrowChars[3]);
        end
        else
        begin
          B := False;
          if Panel^.Mode = pmDOS then W := Panel^.DOSNameColWidth else W := Panel^.CBMNameColWidth;
          if (Panel^.GetColumnMode = cmBrief) or (Panel^.Mode <> pmDOS) then B := (P.X mod Panel^.ColumnWidth = 0) else
            B := (P.X mod Panel^.ColumnWidth = W + 1);
          if B then
          begin
            O := True;
            SetMouseCursorChar(DoubleArrowChars[1]);
          end;
        end;
      end;
    end;
  end
end;

begin
  TApplication.GetEvent(Event);
  O := False;
  if (Event.What and not evMouse = 0) and not (HelpCtxSet or HelpInUse or MenuInUse) and
    (DefMouseCursorChar = EmptyMouseCursorChar) then
  begin
    if MouseWhere.Y = 0 then
    begin
      if MouseWhere.X < 2 then
      begin
        O := True;
        SetMouseCursorChar(CenterBlockChar);
      end;
    end
    else if not PanelHotSpots(Left) then PanelHotSpots(Right);
  end;
  if not O then SetMouseCursorChar(DefMouseCursorChar);
  if CtrlAltInsHit then EmergencyExit;
  if (GoSound and ErrorSound) or ((MouseButtons > 0) and (Event.What and evKeyboard > 0)) then ClearEvent(Event);
  if Event.What = evNothing then
  begin
    if (DiskChangeCmd <> cmNone) and CheckDiskChange then
    begin
      SaverCount := GetTicks;
      Event.What := evCommand;
      Event.Command := DiskChangeCmd;
    end;
    if WentToCorner and (MouseWhere.X >= ScreenWidth - 2) and (MouseWhere.Y = 0) and (GetTicks > SaverCount + QuarterTicks) and
      not SaverInUse and (GetShiftState = 0) then
    begin
      SaverOn;
      WentToCorner := False;
      LastWhere := Event.Where;
      ClearEvent(Event);
    end;
  end
  else
  begin
    CtrlShiftPressed := False;
    AltShiftPressed := False;
    AltPressed := False;
    SaverCount := GetTicks;
    B := GetShiftState;
    ShiftPressed := (B and (kbLeftShift + kbRightShift) > 0);
    if not ShiftPressed then ShiftHeld := False;
    if (Event.What and evKeyboard > 0) and (Event.KeyCode = kbAltBack) and
      (GetShiftState = (kbCtrlShift + kbAltShift)) then ResetDrives;
    if (Event.What and evMouseMove > 0) and (Event.Where.X >= ScreenWidth - 2) and (Event.Where.Y = 0) and
      ((LastWhere.X < ScreenWidth - 2) or (LastWhere.Y > 0)) then
    begin
      WentToCorner := True;
    end
    else
    begin
      if SaverInUse then ScreenSaver^.HandleEvent(Event);
      if Event.What and evMouse > 0 then LastWhere := Event.Where;
    end;
  end;
  if (Event.What and evCommand > 0) then
  begin
    case Event.Command of
      cmHelp:
      begin
        if not HelpInUse then
        begin
          ShiftHeld := False;
          MouseRightHeld := False;
          HelpNum := AppHelpCtx;
          case HelpNum of
            hcMainConfig2: HelpNum := SetupHelpCtx;
            hcDriveConfig2: HelpNum := hcDriveConfig;
            hcMakeImage2: HelpNum := hcMakeImage;
            hcCopyDisk2: HelpNum := hcCopyDisk;
            hcDiskEdit2, hcDiskEdit3: HelpNum := hcDiskEdit;
            hcBlockEdit, hcMapEdit: HelpNum := hcKeyDiskEdit;
            hcCompress2: HelpNum := hcCompress;
            hcCfgPalette2: HelpNum := hcCfgPalette;
          end;
          if HelpNum >= hcHelp then HelpNum := hcNoContext;
          _Help;
          ClearEvent(Event);
        end;
      end;
      cmRecalibrate: Recalibrate;
    end;
  end;
  if (Event.What and evMouseDown > 0) and (HelpCtxSet or HelpInUse) then
  begin
    F := TopView^.MouseInView(Event.Where);
    E.What := evKeyboard;
    E.KeyCode := kbNoKey;
    if Event.Buttons and mbMiddleButton > 0 then
    begin
      F := True;
      E.KeyCode := kbEnter;
    end
    else if (Event.Buttons and mbRightButton > 0) and not F then E.KeyCode := kbEsc else
      if (Event.Buttons and mbLeftButton > 0) and not F then E.KeyCode := kbEsc;
    if E.KeyCode <> kbNoKey then
    begin
      repeat
        O := F or not TopView^.MouseInView(Event.Where);
        if O then
        begin
          if E.KeyCode = kbEnter then SetDefMouseCursorChar(CheckedChar) else SetDefMouseCursorChar(CancelledChar);
        end
        else
        begin
          SetDefMouseCursorChar(EmptyMouseCursorChar);
        end;
      until not MouseEvent(Event, evMouseMove);
      SetDefMouseCursorChar(EmptyMouseCursorChar);
      if O then PutEvent(E);
    end;
  end;
end;

{Handle main events: distribute events to special objects (speed-search
  dialog box, command line and active panel), then execute functions assigned
  to Ctrl-key combinations and function keys and select the menu bar or a
  panel when the user clicks on them
  Input : Event: event record to be handled}
procedure TCommander.HandleEvent(var Event: TEvent);
var
  B             : Boolean;
  X,
  Y,
  V,
  W             : Integer;

{Change the event to a command
  Input : Command: the command to change the event to}
procedure MakeCommand(Command: Word);
begin
  Event.What := evCommand;
  Event.Command := Command;
end;

procedure SetPanel(Panel: PPanel);
begin
  if Left^.Vis and Right^.Vis and not Panel^.Sel then
  begin
    SelectPanel(Panel, (Panel^.Mode <> pmInfo));
    Panel^.DrawPanel;
  end;
end;

begin
  if SearchInUse then
  begin
    Act^.FileSearch^.HandleEvent(Event);
    if not SearchInUse then Dispose(Act^.FSDialog, Done);
  end;
  if AlternativeHotkeys and (CommandLine^.Data^ = '') and (Event.What and evKeyboard > 0) then
  begin
    B := True;
    case Event.KeyCode of
      kbDel: Event.Command := cmDeleteFile;
      kbShiftDel: Event.Command := cmSDeleteFile;
      kbCtrlDel: Event.Command := cmCDeleteFile;
      kbCtrlLeft: SetPanel(Left);
      kbCtrlRight: SetPanel(Right);
    else
      B := False;
    end;
    if B then Event.What := evCommand;
  end;
  if not HelpCtxSet then CommandLine^.HandleEvent(Event);
  if Act <> nil then Act^.HandleEvent(Event);
  if Event.What and evKeyboard > 0 then
  begin
    case Event.KeyCode of
      kbTab: Tab;
      kbEsc: if EscTogglesPanels then MakeCommand(cmPanelsOnOff);
      kbCtrlB: MakeCommand(cmKeyBar);
      kbCtrlL: ToggleInfoOrQuick(Inact, True, True, False);
      kbCtrlM: MakeCommand(cmRestoreSel);
      kbCtrlN: ToggleLongNames;
      kbCtrlO: MakeCommand(cmPanelsOnOff);
      kbCtrlP: ToggleInact;
      kbCtrlQ: ToggleInfoOrQuick(Inact, False, True, False);
      kbCtrlR: RereadPanel(Act);
      kbCtrlU: MakeCommand(cmSwapPanels);
    end;
  end;
  if Event.What and evMouse > 0 then
  begin
    if MouseButtons and mbRightButton = 0 then MouseRightHeld := False;
    X := Event.Where.X;
    Y := Event.Where.Y;
    if (Event.What and evMouseDown > 0) and (Event.Buttons > 0) and (Y = 0) then
    begin
      if X < 2 then
      begin
        repeat
          B := (Event.Where.X < 2) and (Event.Where.Y = 0);
          if B then SetMouseCursorChar(CenterBlockChar) else
            SetMouseCursorChar(EmptyMouseCursorChar);
        until not MouseEvent(Event, evMouseMove);
        if B then PanelsOnOff else SetMouseCursorChar(EmptyMouseCursorChar);
      end
      else
      begin
        if not MenuBar^.Exposed then
        begin
          Event.Buttons := 0;
          MenuBar^.MakeFirst;
          MenuBar^.Show;
          Clock^.Show;
        end;
      end;
    end;
    if (Event.What and evMouseDown > 0) and (Y > 0) and
      (Left^.MouseInView(Event.Where) or Right^.MouseInView(Event.Where)) then
    begin
      if Left^.MouseInView(Event.Where) then
      begin
        if Left^.Vis then
        begin
          SelectPanel(Left, True);
          Left^.HandleEvent(Event);
        end;
      end
      else
      begin
        if Right^.Vis then
        begin
          SelectPanel(Right, True);
          Right^.HandleEvent(Event);
        end;
      end;
    end;
  end;
  if Event.What and evCommand > 0 then
  begin
    case Event.Command of
      cmUserMenu: UserMenu(cfSelected, 0);
      cmViewFile: ViewFile(cfSelected);
      cmEditFile: EditFile(cfSelected);
      cmCopyFile: CopyFiles(cfSelected, False, False);
      cmRenMovFile: CopyFiles(cfSelected, True, False);
      cmMakeDir: MakeDir(cfWildcard);
      cmDeleteFile: DeleteFiles(cfSelected);
      cmPanelMenu: PullMenu(False);
      cmQuitProgram: QuitProgram;
      cmMakeDisk: MakeImage(cfSelected, True);
      cmMakeTape: MakeImage(cfSelected, False);
      cmSViewFile: ViewFile(cfWildcard);
      cmSEditFile: EditFile(cfWildcard);
      cmSCopyFile: CopyFiles(cfWildcard, False, False);
      cmSRenMovFile: CopyFiles(cfWildcard, True, False);
      cmSDeleteFile: DeleteFiles(cfWildcard);
      cmSaveSetup: SaveSetup;
      cmLastMenu: PullMenu(True);
      cmDiskEdit: DiskEdit(cfSelected, False, False, True);
      cmVolumeLabel: VolumeLabel;
      cmCCopyFile: CopyFiles(cfSingle, False, False);
      cmCRenMovFile: CopyFiles(cfSingle, True, False);
      cmFileAttrib: FileAttrib(cfSelected);
      cmCDeleteFile: DeleteFiles(cfSingle);
      cmMainConfig: MainConfig;
      cmDriveConfig: DriveConfig;
      cmLeftChange: ChangeDrive(Left);
      cmRightChange: ChangeDrive(Right);
      cmIntViewFile: ViewFile(cfSingle);
      cmIntEditFile: EditFile(cfSingle);
      cmCopyDisk: CopyDisk(cfSelected);
      cmCompress: CopyFiles(cfSelected, False, True);
      cmHistory: History;
      cmEGALines: EGALines;
      cmVideoMode: VideoMode;
      cmSelectFile: SelectFile(True, False);
      cmUnselectFile: SelectFile(False, False);
      cmInvertSel: InvertSelection(True);
      cmRestoreSel: RestoreSelection;
      cmLeftBrief: SetColumn(Left, cmBrief);
      cmLeftFull: SetColumn(Left, cmFull);
      cmLeftLong: SetColumn(Left, cmWide);
      cmLeftInfo: ToggleInfoOrQuick(Left, True, False, True);
      cmLeftQView: ToggleInfoOrQuick(Left, False, False, True);
      cmLeftOnOff: TogglePanel(Left);
      cmLeftName: SortOrder(Left, psName);
      cmLeftExt: SortOrder(Left, psExt);
      cmLeftTime: SortOrder(Left, psTime);
      cmLeftSize: SortOrder(Left, psSize);
      cmLeftUnsort: SortOrder(Left, psUnsorted);
      cmLeftReverse: SortOrder(Left, psReverse);
      cmLeftReread: RereadPanel(Left);
      cmLeftColumn: SetColumn(Left, MaxByte);
      cmLeftSort: SortOrder(Left, MaxByte);
      cmLeftFilter: Filter(Left);
      cmLeftStatus: SetMiniStatus(Left, hcStatus);
      cmKViewFile: ViewFile(cfReadKey);
      cmKEditFile: EditFile(cfReadKey);
      cmKCopyFile: CopyFiles(cfReadKey, False, False);
      cmKRenMovFile: CopyFiles(cfReadKey, True, False);
      cmKDeleteFile: DeleteFiles(cfReadKey);
      cmFileInfo: FileInfo;
      cmLaunchEmu: LaunchEmu;
      cmRightBrief: SetColumn(Right, cmBrief);
      cmRightFull: SetColumn(Right, cmFull);
      cmRightLong: SetColumn(Right, cmWide);
      cmRightInfo: ToggleInfoOrQuick(Right, True, False, True);
      cmRightQView: ToggleInfoOrQuick(Right, False, False, True);
      cmRightOnOff: TogglePanel(Right);
      cmRightName: SortOrder(Right, psName);
      cmRightExt: SortOrder(Right, psExt);
      cmRightTime: SortOrder(Right, psTime);
      cmRightSize: SortOrder(Right, psSize);
      cmRightUnsort: SortOrder(Right, psUnsorted);
      cmRightReverse: SortOrder(Right, psReverse);
      cmRightReread: RereadPanel(Right);
      cmRightColumn: SetColumn(Right, MaxByte);
      cmRightSort: SortOrder(Right, MaxByte);
      cmRightFilter: Filter(Right);
      cmRightStatus: SetMiniStatus(Right, hcStatus);
      cmPanelsOnOff: PanelsOnOff;
      cmSwapPanels: SwapPanels;
      cmMenuEdit: MenuEdit;
      cmExtEdit: ExtEdit;
      cmViewerEdit: ViewerEdit;
      cmEditorEdit: EditorEdit;
      cmAutoMenus: ToggleAutoMenus;
      cmPathPrompt: TogglePathPrompt;
      cmKeyBar: ToggleKeyBar;
      cmFullScreen: ToggleFullScreen;
      cmMiniStatus: SetMiniStatus(nil, hcMiniStatus);
      cmClock: ToggleClock;
      cmDCopyFile: CopyFiles(ShellBuffer^.CopyFileMode, ShellBuffer^.MoveFiles, False);
      cmDCompress: CopyFiles(ShellBuffer^.CopyFileMode, ShellBuffer^.MoveFiles, True);
      cmAListFile: ListFile;
      cmAViewFile: ViewFile(cfAutomatic);
      cmAEditFile: EditFile(cfAutomatic);
      cmACopyFile: CopyFiles(cfAutomatic, False, False);
      cmAMoveFile: CopyFiles(cfAutomatic, True, False);
      cmAMakeDir: MakeDir(cfAutomatic);
      cmADeleteFile: DeleteFiles(cfAutomatic);
      cmAMakeDisk: MakeImage(cfAutomatic, True);
      cmAMakeTape: MakeImage(cfAutomatic, False);
      cmADiskEdit: DiskEdit(cfAutomatic, False, False, True);
      cmAFileAttrib: FileAttrib(cfAutomatic);
      cmACopyDisk: CopyDisk(cfAutomatic);
      cmAFormat: UserMenu(cfAutomatic, umFormat);
      cmAValidate: UserMenu(cfAutomatic, umValidate);
      cmAClean: UserMenu(cfAutomatic, umClean);
      cmASafeClean: UserMenu(cfAutomatic, umSafeClean);
      cmAProtect: UserMenu(cfAutomatic, umProtect);
      cmAUnprotect: UserMenu(cfAutomatic, umUnprotect);
      cmAMinimize: UserMenu(cfAutomatic, umMinimize);
      cmAUserCommand: UserMenu(cfAutomatic, umUserCommand);
    end;
  end;
  TApplication.HandleEvent(Event);
end;

{Halt the program with an error message
  Input : Str: the error message to print}
procedure Halt(const Str: string);
begin
  PrintStr(Str);
  if Resident then ShellBuffer^.QuitProgram := True;
end;

{Display program title string}
procedure PrintTitle;
begin
  if not ShellBuffer^.TitlePrinted then
  begin
    ShellBuffer^.TitlePrinted := True;
    PrintStr(TitleStr + VersionStr + chCR + chLF + CopyrightStr + chCR + chLF + chCR + chLF);
  end;
end;

{Check if the loader is present and initialize the shell buffer if it is not,
  print messages and fatal errors}
begin
  MainProgram := True;
  if Test8086 = 0 then
  begin
    PrintTitle;
    Halt('This program requires an 80286 CPU or above' + chCR + chLF);
  end
  else
  begin
    FatalError := '';
    BatchMode := bmNone;
    DefScreenCol := apAuto;
    CheckResident;
    if not Resident then
    begin
      ShellBuffer := New(PShellBuffer);
      with ShellBuffer^ do
      begin
        First := True;
        VESASupport := True;
        TitlePrinted := False;
        ConfigOK := False;
        ScreenBuffer := @TempBuffer;
        CmdBuffer := @GCRBuffer[TempBufferSize - CmdBufferLen];
      end;
    end;
    VESASupport := ShellBuffer^.VESASupport;
    if Resident then
    begin
      BatchName := ShellBuffer^.BatchName;
      BatchCommand := ShellBuffer^.BatchCommand;
      DisableLPTPorts := ShellBuffer^.DisableLPTPorts;
      DisableXMSUsage := ShellBuffer^.DisableXMSUsage;
      DisableEMSUsage := ShellBuffer^.DisableEMSUsage;
      DisableWinClipboard := ShellBuffer^.DisableWinClipboard;
      DefScreenCol := ShellBuffer^.DefScreenCol;
    end;
    if ParamCount > 0 then
    begin
      CurPath := PString(Ptr(PrefixSeg, $0080))^;
      while (CurPath <> '') and (CurPath[Length(CurPath)] in WhiteSpace) do Dec(CurPath[0]);
      repeat
        while (CurPath <> '') and (CurPath[1] in WhiteSpace) do CurPath := Copy(CurPath, 2, MaxStrLen);
        if (CurPath <> '') and (CurPath[1] in ['-', '/']) then
        begin
          NumOK := 2;
          while (NumOK <= Length(CurPath)) and not (CurPath[NumOK] in WhiteSpace) do Inc(NumOK);
          HomePath := Copy(CurPath, 1, NumOK - 1);
          ListPath := UpperCase(Copy(HomePath, 2, 255));
          CurPath := Copy(CurPath, NumOK + 1, MaxStrLen);
          if ListPath = 'CMD' then
          begin
            BatchCommand := CurPath;
          end
          else
          begin
            if ListPath = 'NOVESA' then VESASupport := False else
              if ListPath = 'NOLPT' then DisableLPTPorts := True else
              if ListPath = 'NOXMS' then DisableXMSUsage := True else
              if ListPath = 'NOEMS' then DisableEMSUsage := True else
              if ListPath = 'NOWINCLIP' then DisableWinClipboard := True else
              if ListPath = 'COLOR' then DefScreenCol := apColor else
              if ListPath = 'BW' then DefScreenCol := apBlackWhite else
              if ListPath = 'LAPTOP' then DefScreenCol := apLaptop else
            begin
              TextScreen(nil);
              PrintTitle;
              if ListPath <> '?' then PrintStr('Invalid option: "' + HomePath + '"' + chCR + chLF + chCR + chLF);
              PrintStr('Usage:   SCMAIN [-|/<options...>]' + chCR + chLF + chCR + chLF +
                'Options: ?          - help screen' + chCR + chLF +
                '         nolpt      - disable parallel port access' + chCR + chLF);
              PrintStr('         novesa     - disable VESA BIOS support' + chCR + chLF +
                '         noxms      - disable XMS usage' + chCR + chLF +
                '         noems      - disable EMS usage' + chCR + chLF +
                '         nowinclip  - disable Windows clipboard' + chCR + chLF);
              PrintStr('         color      - force color palette' + chCR + chLF +
                '         bw         - force black & white palette' + chCR + chLF +
                '         laptop     - force laptop palette' + chCR + chLF +
                '         cmd ...    - execute command or script' + chCR + chLF);
              Exit;
            end;
          end;
        end;
      until (CurPath = '') or not (CurPath[1] in ['-', '/']) or (BatchCommand <> '');
    end;
    ShellBuffer^.VESASupport := VESASupport;
    TextScreen(nil);
    SetHomePath;
    if BatchCommand <> '' then
    begin
      if BatchCommand[1] = ScriptPrefix then
      begin
        BatchMode := bmScript;
        BatchName := Copy(BatchCommand, 2, MaxStrLen);
        BatchCommand := '';
        BatchOffset := 0;
      end
      else
      begin
        BatchMode := bmSingle;
      end;
      ResetAutoReplies;
      SaveAutoReplies;
    end;
    if BatchMode = bmNone then
    begin
      if Resident then
      begin
        if not ShellBuffer^.First and (ShellBuffer^.CommandOutput = coNormal) then PrintStr(chCR + chLF);
      end
      else
      begin
        PrintTitle;
      end;
    end;
    if DOSVersion < $0314 then
    begin
      Halt('This program requires DOS version 3.20 or later' + chCR + chLF);
    end
    else
    begin
      if MemAvail < 157000 then
      begin
        Halt('There is not enough memory to execute the Commander' + chCR + chLF);
      end
      else
      begin
        NumOK := 1;
        DayLight := False;
        CurPath := GetEnv('TZ');
        if Length(CurPath) >= 4 then
        begin
          CurPath := Copy(CurPath, 4, MaxStrLen);
          while not (CurPath[Length(CurPath)] in ['+', '-', '0'..'9']) do
          begin
            Dec(CurPath[0]);
            DayLight := True;
          end;
          Val(CurPath, TimeZone, NumOK);
        end;
        if NumOK <> 0 then
        begin
          TimeZone := DefTimeZone;
          DayLight := True;
        end;
        CurPath := ParamStr(0);
        OvrInit(CurPath);
        if OvrResult <> ovrOK then OvrInit(Copy(CurPath, 1, Length(CurPath) - 3) + 'ovr');
        if OvrResult <> ovrOK then
        begin
          Halt('There was an error loading the Commander overlay' + chCR + chLF);
        end
        else
        begin
          OvrResult := ovrError;
          if not DisableXMSUsage then OvrInitXMS;
          if not DisableEMSUsage and (OvrResult <> ovrOK) then OvrInitEMS;
          ListPath := GetTempPath;
          MemoryCfgOK := ShellBuffer^.ConfigOK;
          if ShellBuffer^.First then
          begin
            with ShellBuffer^ do
            begin
              ConfigOK := False;
              CommandOutput := coNormal;
              PopupMenu := True;
              Archiving := False;
              Compressing := False;
              MoveFiles := False;
              WarningStatus := wmNone;
              EditStatus := 0;
              EditNewFile := False;
              ExecMode := exNormal;
              ExecError := 0;
              MouseX := -1;
              HistoryNum := 0;
              DiskDirSize := MinDiskDirSize;
              TapeDirSize := DefTapeDirSize;
              CmdPos := 0;
              CmdFirstPos := 0;
              CBMPattern := stAllFilesUnix;
              DOSPattern := stAllFilesDOS;
              LeftCBMDev := 8;
              LeftImageName := '';
              LeftOrigImage := '';
              LeftImagePath := '';
              LeftOrigImagePath := '';
              LeftNewCur := MaxInt;
              LeftTop := '';
              LeftUnder := '';
              LeftSelNum := 0;
              LeftListEnd := 0;
              RightCBMDev := 8;
              RightImageName := '';
              RightOrigImage := '';
              RightImagePath := '';
              RightOrigImagePath := '';
              RightNewCur := MaxInt;
              RightTop := '';
              RightUnder := '';
              RightSelNum := 0;
              RightListEnd := 0;
              LastName := '';
              DiskTitle := '';
              TapeTitle := DefTapeTitle;
              WrapMode := True;
              HexaMode := False;
              ShowLoadAddr := False;
              ShowSymbols := False;
              FixLineLen := 80;
              UserLineFeed := 0;
              BackupFiles := False;
              SearchInHex := False;
              SearchText := '';
              SearchHex := '';
              ReplaceText := '';
              ReplaceHex := '';
              CmdLineText := '';
              FirstFile := True;
              ViewFileName := '';
              DiskCopySettings := 8;
              CharSetMode := csIBMLower;
            end;
            ShellBuffer^.ComPath := HomePath;
          end;
          Commander.Init;
          Commander.Run;
          if not Resident or ShellBuffer^.QuitProgram then
          begin
            Application^.SetCharSet(csIBMLower, False, False);
            DoneClipboard;
          end;
          OpenCBMDriverClose;
          OpenCBMVDDUninit;
          if TurboOffed then
          begin
            while GetTicks <= TurboOffCount do;
            TurboOffDecouple;
          end;
          if BatchMode <> bmNone then BackCursorY := OrigBackCursorY;
          Commander.Done;
          Clock := nil;
        end;
      end;
    end;
  end;
end.
