
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    SCRIPT.PAS                   }
{                                                 }
{          The Star Commander script unit         }
{*************************************************}

unit Script;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  App, Drivers, Views,
  Base2, Constant, ExtFiles, LowLevel;

const
{Maximum width of fields}
  MaxWidth      = MaxByte;
{Batch variable types}
  vtBoolean     = 0;
  vtByte        = 1;
  vtByteEnum    = 2;
  vtWord        = 3;
  vtString      = 4;
  vtByteArray   = 5;
{Format flags}
  ffNone        = $00;
  ffUpperCase   = $01;
  ffQuoted      = $02;
  ffHexaConvert = $04;
  ffGEOS        = $08;
  ffSum         = $10;
  ffNoDir       = $00;
  ffRightDir    = $40;
  ffLeftDir     = $80;
  ffDirection   = $C0;
{Condition flags}
  cfNormal      = $00;
  cfFirstFile   = $01;
  cfLastFile    = $02;
  cfHeader      = $04;
  cfFooter      = $08;
  cfCondEnd     = $80;

type
{Batch command}
  TBatchCommand = record
    CmdName     : Word;
    CmdEvent    : Word;
    ParNum      : Byte;
  end;
{Batch variable}
  TBatchVar     = record
    VarName     : Word;
    VarType     : Byte;
    VarPtr      : Pointer;
    case Byte of
      vtBoolean: ();
      vtByte:
      (
        ByteMin,
        ByteMax,
        ByteBase: Byte;
      );
      vtByteEnum:
      (
        Values  : Word;
      );
      vtWord:
      (
        WordMin,
        WordMax : Word;
      );
      vtString:
      (
        StrMaxLen: Byte;
      );
      vtByteArray:
      (
        ElemMin,
        ElemMax : Byte;
        IndValues: Word;
      );
  end;
  PBatchVar     = ^TBatchVar;
{Format specifier record}
  TFormatSpec    = record
    Padding     : Byte;
    PaddingDir  : Byte;
    MaxWidth    : Byte;
    MaxWidthDir : Byte;
    Flags       : Byte;
    FieldType   : Char;
  end;
  PFormatSpec   = ^TFormatSpec;
{Condition specifier record}
  TCondSpec     = record
    CondType    : Byte;
  end;
  PCondSpec     = ^TCondSpec;

const
{Number of batch commands}
  BatchCommandNum= 25;
{Batch commands}
  bcList        : string[4] = 'list';
  bcView        : string[4] = 'view';
  bcEdit        : string[4] = 'edit';
  bcCopy        : string[4] = 'copy';
  bcMove        : string[4] = 'move';
  bcMakeDir     : string[7] = 'makedir';
  bcDelete      : string[6] = 'delete';
  bcMakeDisk    : string[8] = 'makedisk';
  bcMakeTape    : string[8] = 'maketape';
  bcDiskEdit    : string[8] = 'diskedit';
  bcAttrib      : string[6] = 'attrib';
  bcDiskCopy    : string[8] = 'diskcopy';
  bcFormat      : string[6] = 'format';
  bcValidate    : string[8] = 'validate';
  bcClean       : string[5] = 'clean';
  bcSafeClean   : string[9] = 'safeclean';
  bcProtect     : string[7] = 'protect';
  bcUnprotect   : string[9] = 'unprotect';
  bcMinimize    : string[8] = 'minimize';
  bcUserCmd     : string[7] = 'usercmd';
  bcSet         : string[3] = 'set';
  bcNoInit      : string[6] = 'noinit';
  bcInit        : string[4] = 'init';
  bcSetDrive    : string[8] = 'setdrive';
  bcExit        : string[4] = 'exit';
  BatchCommands: array [0..BatchCommandNum - 1] of TBatchCommand =
    ((CmdName: Ofs(bcList); CmdEvent: cmAListFile; ParNum: 2),
     (CmdName: Ofs(bcView); CmdEvent: cmAViewFile; ParNum: 1),
     (CmdName: Ofs(bcEdit); CmdEvent: cmAEditFile; ParNum: 1),
     (CmdName: Ofs(bcCopy); CmdEvent: cmACopyFile; ParNum: 2),
     (CmdName: Ofs(bcMove); CmdEvent: cmAMoveFile; ParNum: 2),
     (CmdName: Ofs(bcMakeDir); CmdEvent: cmAMakeDir; ParNum: 1),
     (CmdName: Ofs(bcDelete); CmdEvent: cmADeleteFile; ParNum: 1),
     (CmdName: Ofs(bcMakeDisk); CmdEvent: cmAMakeDisk; ParNum: 3),
     (CmdName: Ofs(bcMakeTape); CmdEvent: cmAMakeTape; ParNum: 3),
     (CmdName: Ofs(bcDiskEdit); CmdEvent: cmADiskEdit; ParNum: 1),
     (CmdName: Ofs(bcAttrib); CmdEvent: cmAFileAttrib; ParNum: 1),
     (CmdName: Ofs(bcDiskCopy); CmdEvent: cmACopyDisk; ParNum: 2),
     (CmdName: Ofs(bcFormat); CmdEvent: cmAFormat; ParNum: 2),
     (CmdName: Ofs(bcValidate); CmdEvent: cmAValidate; ParNum: 1),
     (CmdName: Ofs(bcClean); CmdEvent: cmAClean; ParNum: 1),
     (CmdName: Ofs(bcSafeClean); CmdEvent: cmASafeClean; ParNum: 1),
     (CmdName: Ofs(bcProtect); CmdEvent: cmAProtect; ParNum: 1),
     (CmdName: Ofs(bcUnprotect); CmdEvent: cmAUnprotect; ParNum: 1),
     (CmdName: Ofs(bcMinimize); CmdEvent: cmAMinimize; ParNum: 1),
     (CmdName: Ofs(bcUserCmd); CmdEvent: cmAUserCommand; ParNum: 1),
     (CmdName: Ofs(bcSet); CmdEvent: cmASet; ParNum: 2),
     (CmdName: Ofs(bcNoInit); CmdEvent: cmANoInit; ParNum: 0),
     (CmdName: Ofs(bcInit); CmdEvent: cmAInit; ParNum: 0),
     (CmdName: Ofs(bcSetDrive); CmdEvent: cmASetDrive; ParNum: 1),
     (CmdName: Ofs(bcExit); CmdEvent: cmAExit; ParNum: 0));
{Number of batch variables}
  BatchVarNum   = 80;
{Batch variables}
  bvScreenColor : string[11] = 'screencolor';
  bvScreenColorValues: string[19] = Chr(apBlackWhite)+'b&w,' + Chr(apColor)+'color,' + Chr(apLaptop)+'laptop';
  bvMenuBarVisible: string[14] = 'menubarvisible';
  bvErrorSound  : string[10] = 'errorsound';
  bvAutoSaveSetup: string[13] = 'autosavesetup';
  bvScreenBlank : string[11] = 'screenblank';
  bvAltHotkeys  : string[10] = 'althotkeys';
  bvInsMovesDown: string[12] = 'insmovesdown';
  bvEscTogglesPanels: string[16] = 'esctogglespanels';
  bvAltSelectsMenu: string[14] = 'altselectsmenu';
  bvCheckCGASnow: string[12] = 'checkcgasnow';
  bvVESASupport : string[11] = 'vesasupport';
  bvLeftHandedMouse: string[15] = 'lefthandedmouse';
  bvFastMouseReset: string[14] = 'fastmousereset';
  bvAutoMenus   : string[9] = 'automenus';
  bvPathPrompt  : string[10] = 'pathprompt';
  bvKeyBar      : string[6] = 'keybar';
  bvFullScreen  : string[10] = 'fullscreen';
  bvClock       : string[5] = 'clock';
  bvLongFileNames: string[13] = 'longfilenames';
  bvPreferLongNames: string[15] = 'preferlongnames';
  bvKeepLocaseChars: string[15] = 'keeplocasechars';
  bvDOSSizesInBlocks: string[16] = 'dossizesinblocks';
  bvConfConvFileName: string[16] = 'confconvfilename';
  bvConfDeleteFile: string[14] = 'confdeletefile';
  bvConfQuitProgram: string[15] = 'confquitprogram';
  bvConfAbortTransfer: string[17] = 'confaborttransfer';
  bvConfDiskEditor: string[14] = 'confdiskeditor';
  bvAutoUnselect: string[12] = 'autounselect';
  bvKeepNonStandardExt: string[18] = 'keepnonstandardext';
  bvCursorFollowsName: string[17] = 'cursorfollowsname';
  bvProgramExt  : string[10] = 'programext';
  bvIntoFileImages: string[14] = 'intofileimages';
  bvIntoFileImagesValues: string[22] = Chr(ifNever)+'never,' + Chr(ifAlways)+'always,' + Chr(ifCBMSrc)+'cbmsrc';
  bvExtractFileImages: string[17] = 'extractfileimages';
  bvExtractFileImagesValues: string[23] = Chr(xfNever)+'never,' + Chr(xfAlways)+'always,' + Chr(xfCBMDest)+'cbmdest';
  bvWarnTransfer: string[12] = 'warntransfer';
  bvWarnFileSizes: string[13] = 'warnfilesizes';
  bvQualityC64Charset: string[17] = 'qualityc64charset';
  bvBackupImages: string[12] = 'backupimages';
  bvGEOSSupport : string[11] = 'geossupport';
  bvDisplayStartInfo: string[16] = 'displaystartinfo';
  bvShowReadErrors: string[14] = 'showreaderrors';
  bvImageDOSType: string[12] = 'imagedostype';
  bvDOSTypeValues: string[25] = Chr(xbSpeedDOS)+'speed,' + Chr(xbDolphinDOS)+'dolphin,' + Chr(xbPrologicDOS)+'prologic';
  bvKeepDateStamps: string[14] = 'keepdatestamps';
  bvCopyOntoDirTrack: string[16] = 'copyontodirtrack';
  bvConvertChars: string[12] = 'convertchars';
  bvConvertCharsValues: string[23] = Chr(ccNone)+'none,' + Chr(ccInvalid)+'invalid,' + Chr(ccInvalidAndSpace)+'inv+spc';
  bvKeepUpcaseChars: string[15] = 'keepupcasechars';
  bvWipeDeletedFiles: string[16] = 'wipedeletedfiles';
  bvOrigFormatPattern: string[17] = 'origformatpattern';
  bvImageInterleave: string[15] = 'imageinterleave';
  bvImageInterleaveIndexes: string[47] = Chr(dt1541 shl 1)+'1541,' + Chr(dt1541 shl 1 + 1)+'1541geos,' +
     Chr(dt1571 shl 1)+'1571,' + Chr(dt1571 shl 1 + 1)+'1571geos,' +
     Chr(dt1581 shl 1)+'1581,' + Chr(dt1581 shl 1 + 1)+'1581geos';
  bvTransferMode: string[12] = 'transfermode';
  bvTransferModeValues: string[20] = Chr(tmNormal)+'normal,' + Chr(tmTurbo) + 'turbo,' + Chr(tmWarp)+'warp';
  bvSerialCable : string[11] = 'serialcable';
  bvSerialCableValues: string[36] = Chr(scNone)+'none,' + Chr(scNormal)+'x1541,' + Chr(scExtended)+'xe1541,' +
    Chr(scMultitask)+'xm1541,' + Chr(scActive)+'xa1541';
  bvParallelCable: string[13] = 'parallelcable';
  bvParallelCableValues: string[21] = Chr(pcNone)+'none,' + Chr(pcHybrid)+'xh15x1,' + Chr(pcParallel)+'xp15x1';
  bvAsyncTransfer: string[13] = 'asynctransfer';
  bvAsyncTransferValues: string[20] = Chr(atNever)+'never,' + Chr(atAlways)+'always,' + Chr(atAuto)+'auto';
  bvManualTimeouts: string[14] = 'manualtimeouts';
  bvDelayValue  : string[10] = 'delayvalue';
  bvSerialInterface: string[15] = 'serialinterface';
  bvParallelInterface: string[17] = 'parallelinterface';
  bvDetectPortModes: string[15] = 'detectportmodes';
  bvDetectPortModeValues: string[35] = Chr(dpNone)+'none,' + Chr(dpAll)+'all,' + Chr(dpUsed)+'used,' +
    Chr(dpSafeAll)+'safeall,' + Chr(dpSafeUsed)+'safeused';
  bvDriveType   : string[9] = 'drivetype';
  bvDriveTypeValues: string[34] = Chr(xd1541)+'1541,' + Chr(xd1571)+'1571,' + Chr(xd1581) + '1581,' +
    Chr(xd1570)+'1570,' + Chr(xd157xEmu)+'157x-1541';
  bvExt1541Disks: string[12] = 'ext1541disks';
  bvDriveDOSType: string[12] = 'drivedostype';
  bvDiskCopyMode: string[12] = 'diskcopymode';
  bvDiskCopyModeValues: string[27] = Chr(dcFull)+'full,' + Chr(dcBAM)+'bam,' + Chr(dcSafeBAM)+'safebam,' +
    Chr(dcManualSelect) + 'manual';
  bvInvalidGCRError: string[15] = 'invalidgcrerror';
  bvInvalidGCRErrorValues: string[13] = Chr(igNone)+'none,' + Chr(ig23READ)+'23,' + Chr(ig24READ)+'24';
  bvSmartRetryNum: string[13] = 'smartretrynum';
  bvDetectDiskChanges: string[17] = 'detectdiskchanges';
  bvEndlessRetry: string[12] = 'endlessretry';
  bvVerifyWrite : string[11] = 'verifywrite';
  bvCommandExecMode: string[15] = 'commandexecmode';
  bvHeadMovementSpeed: string[17] = 'headmovementspeed';
  bvFormatBumpsHead: string[15] = 'formatbumpshead';
  bvRetryNum    : string[8] = 'retrynum';
  bvRetryOnHalftracks: string[17] = 'retryonhalftracks';
  bvRetryBumpsHead: string[14] = 'retrybumpshead';
  bvDriveInterleave: string[15] = 'driveinterleave';
  bvDriveInterleaveIndexes: string[230] = Chr(0)+'files,' + Chr(1)+'geosfiles,' +
    Chr(2) + 'normalr,' + Chr(3) + 'normalw,' +
    Chr(4) + 'turbor,' + Chr(5) + 'turbow,' +
    Chr(6) + 'asyncturbor,' + Chr(7) + 'asyncturbow,' +
    Chr(8) + 'hybridturbor,' + Chr(9) + 'hybridturbow,' +
    Chr(10) + 'parallelturbor,' + Chr(11) + 'parallelturbow,' +
    Chr(12) + 'warpr,' + Chr(13) + 'warpw,' +
    Chr(14) + 'asyncwarpr,' + Chr(15) + 'asyncwarpw,' +
    Chr(16) + 'hybridwarpr,' + Chr(17) + 'hybridwarpw,' +
    Chr(18) + 'parallelwarpr,' + Chr(19) + 'parallelwarpw';
  bvLPT4        : string[4] = 'lpt4';
  bvLPT5        : string[4] = 'lpt5';
  bvAutoDelete  : string[10] = 'autodelete';
  bvAutoValues  : string[18] = Chr(ayNone)+'ask,' + Chr(ayAllYes)+'all,' + Chr(ayAllNo)+'skipall';
  bvAutoDeleteReadonly: string[18] = 'autodeletereadonly';
  bvAutoDeleteDir: string[13] = 'autodeletedir';
  bvAutoOver    : string[8] = 'autoover';
  bvAutoOverReadOnly: string[16] = 'autooverreadonly';
  bvDiskTypeValues: string[26] = Chr(dt1541)+'1541,' + Chr(dt1571)+'1571,' + Chr(dt1581)+'1581,' + Chr(dt1541Ext)+'1541ext';
  BatchVars: array [0..BatchVarNum - 1] of TBatchVar =
    ((VarName: Ofs(bvScreenColor); VarType: vtByteEnum; VarPtr: @ScreenCol;
       Values: Ofs(bvScreenColorValues)),
     (VarName: Ofs(bvMenuBarVisible); VarType: vtBoolean; VarPtr: @ShowMenu),
     (VarName: Ofs(bvErrorSound); VarType: vtBoolean; VarPtr: @ErrorSound),
     (VarName: Ofs(bvAutoSaveSetup); VarType: vtBoolean; VarPtr: @AutoSaveSetup),
     (VarName: Ofs(bvScreenBlank); VarType: vtByte; VarPtr: @SaverDelay;
       ByteMin: 0; ByteMax: MinPerHour; ByteBase: 0),
     (VarName: Ofs(bvAltHotkeys); VarType: vtBoolean; VarPtr: @AlternativeHotkeys),
     (VarName: Ofs(bvInsMovesDown); VarType: vtBoolean; VarPtr: @InsMovesDown),
     (VarName: Ofs(bvEscTogglesPanels); VarType: vtBoolean; VarPtr: @EscTogglesPanels),
     (VarName: Ofs(bvAltSelectsMenu); VarType: vtBoolean; VarPtr: @AltPopsMenu),
     (VarName: Ofs(bvCheckCGASnow); VarType: vtBoolean; VarPtr: @SnowCheck),
     (VarName: Ofs(bvVESASupport); VarType: vtBoolean; VarPtr: @VESASupport),
     (VarName: Ofs(bvLeftHandedMouse); VarType: vtBoolean; VarPtr: @MouseReverse),
     (VarName: Ofs(bvFastMouseReset); VarType: vtBoolean; VarPtr: @FastMouse),
     (VarName: Ofs(bvAutoMenus); VarType: vtBoolean; VarPtr: @AutoMenus),
     (VarName: Ofs(bvPathPrompt); VarType: vtBoolean; VarPtr: @PathPrompt),
     (VarName: Ofs(bvKeyBar); VarType: vtBoolean; VarPtr: @ShowKeyBar),
     (VarName: Ofs(bvFullScreen); VarType: vtBoolean; VarPtr: @FullScreen),
     (VarName: Ofs(bvClock); VarType: vtBoolean; VarPtr: @ShowClock),
     (VarName: Ofs(bvLongFileNames); VarType: vtBoolean; VarPtr: @LongNames),
     (VarName: Ofs(bvPreferLongNames); VarType: vtBoolean; VarPtr: @PreferLongNames),
     (VarName: Ofs(bvKeepLocaseChars); VarType: vtBoolean; VarPtr: @KeepLowerCase),
     (VarName: Ofs(bvDOSSizesInBlocks); VarType: vtBoolean; VarPtr: @DOSSizeBlocks),
     (VarName: Ofs(bvConfConvFileName); VarType: vtBoolean; VarPtr: @ConvertConfirm),
     (VarName: Ofs(bvConfDeleteFile); VarType: vtBoolean; VarPtr: @DeleteConfirm),
     (VarName: Ofs(bvConfQuitProgram); VarType: vtBoolean; VarPtr: @QuitConfirm),
     (VarName: Ofs(bvConfAbortTransfer); VarType: vtBoolean; VarPtr: @TransferConfirm),
     (VarName: Ofs(bvConfDiskEditor); VarType: vtBoolean; VarPtr: @DiskEditConfirm),
     (VarName: Ofs(bvAutoUnselect); VarType: vtBoolean; VarPtr: @AutoUnselect),
     (VarName: Ofs(bvKeepNonStandardExt); VarType: vtBoolean; VarPtr: @KeepNonStandardExt),
     (VarName: Ofs(bvCursorFollowsName); VarType: vtBoolean; VarPtr: @CursorFollowsFilename),
     (VarName: Ofs(bvProgramExt); VarType: vtString; VarPtr: @PrgExt; StrMaxLen: MaxPrgExtLen),
     (VarName: Ofs(bvIntoFileImages); VarType: vtByteEnum; VarPtr: @IntoFileImages;
       Values: Ofs(bvIntoFileImagesValues)),
     (VarName: Ofs(bvExtractFileImages); VarType: vtByteEnum; VarPtr: @IntoFileImages;
       Values: Ofs(bvExtractFileImagesValues)),
     (VarName: Ofs(bvWarnTransfer); VarType: vtBoolean; VarPtr: @TransferWarning),
     (VarName: Ofs(bvWarnFileSizes); VarType: vtBoolean; VarPtr: @FileSizeWarning),
     (VarName: Ofs(bvQualityC64Charset); VarType: vtBoolean; VarPtr: @EightColFont),
     (VarName: Ofs(bvBackupImages); VarType: vtBoolean; VarPtr: @MakeBackup),
     (VarName: Ofs(bvGEOSSupport); VarType: vtBoolean; VarPtr: @GEOSSupport),
     (VarName: Ofs(bvDisplayStartInfo); VarType: vtBoolean; VarPtr: @StartInfo),
     (VarName: Ofs(bvShowReadErrors); VarType: vtBoolean; VarPtr: @ShowReadErrors),
     (VarName: Ofs(bvImageDOSType); VarType: vtByteEnum; VarPtr: @ImageExtBAMMode;
       Values: Ofs(bvDOSTypeValues)),
     (VarName: Ofs(bvKeepDateStamps); VarType: vtBoolean; VarPtr: @KeepTime),
     (VarName: Ofs(bvCopyOntoDirTrack); VarType: vtBoolean; VarPtr: @CopyToDirTrack),
     (VarName: Ofs(bvConvertChars); VarType: vtByteEnum; VarPtr: @ConvInvalidChars;
       Values: Ofs(bvConvertCharsValues)),
     (VarName: Ofs(bvKeepUpcaseChars); VarType: vtBoolean; VarPtr: @KeepUppercase),
     (VarName: Ofs(bvWipeDeletedFiles); VarType: vtBoolean; VarPtr: @WipeFiles),
     (VarName: Ofs(bvOrigFormatPattern); VarType: vtBoolean; VarPtr: @OrigPattern),
     (VarName: Ofs(bvImageInterleave); VarType: vtByteArray; VarPtr: @ImageInts;
       ElemMin: 1; ElemMax: MaxImageInt; IndValues: Ofs(bvImageInterleaveIndexes)),
     (VarName: Ofs(bvTransferMode); VarType: vtByteEnum; VarPtr: @TransferMode;
       Values: Ofs(bvTransferModeValues)),
     (VarName: Ofs(bvSerialCable); VarType: vtByteEnum; VarPtr: @SerialCable;
       Values: Ofs(bvSerialCableValues)),
     (VarName: Ofs(bvParallelCable); VarType: vtByteEnum; VarPtr: @ParallelCable;
       Values: Ofs(bvParallelCableValues)),
     (VarName: Ofs(bvAsyncTransfer); VarType: vtByte; VarPtr: @AsyncTransfer;
       Values: Ofs(bvAsyncTransferValues)),
     (VarName: Ofs(bvManualTimeouts); VarType: vtBoolean; VarPtr: @ManualTimeouts),
     (VarName: Ofs(bvDelayValue); VarType: vtWord; VarPtr: @DelayValue; WordMin: 0; WordMax: MaxByte),
     (VarName: Ofs(bvSerialInterface); VarType: vtByte; VarPtr: @LPTNum;
       ByteMin: 1; ByteMax: MaxLPTPorts; ByteBase: 1),
     (VarName: Ofs(bvParallelInterface); VarType: vtByte; VarPtr: @ParLPTNum;
       ByteMin: 1; ByteMax: MaxLPTPorts; ByteBase: 1),
     (VarName: Ofs(bvDetectPortModes); VarType: vtByteEnum; VarPtr: @DetectPortModes;
       Values: Ofs(bvDetectPortModeValues)),
     (VarName: Ofs(bvDriveType); VarType: vtByteEnum; VarPtr: @ExternalDrive;
       Values: Ofs(bvDriveTypeValues)),
     (VarName: Ofs(bvExt1541Disks); VarType: vtBoolean; VarPtr: @ExtendedDiskMode),
     (VarName: Ofs(bvDriveDOSType); VarType: vtByteEnum; VarPtr: @DiskExtBAMMode;
       Values: Ofs(bvDOSTypeValues)),
     (VarName: Ofs(bvDiskCopyMode); VarType: vtByteEnum; VarPtr: @DiskCopyMode;
       Values: Ofs(bvDiskCopyModeValues)),
     (VarName: Ofs(bvInvalidGCRError); VarType: vtByteEnum; VarPtr: @InvalidGCRCodeMode;
       Values: Ofs(bvInvalidGCRErrorValues)),
     (VarName: Ofs(bvSmartRetryNum); VarType: vtByte; VarPtr: @SmartRetryNum;
       ByteMin: 0; ByteMax: MaxByte; ByteBase: 0),
     (VarName: Ofs(bvDetectDiskChanges); VarType: vtBoolean; VarPtr: @DetectDiskChange),
     (VarName: Ofs(bvEndlessRetry); VarType: vtBoolean; VarPtr: @EndlessRetry),
     (VarName: Ofs(bvVerifyWrite); VarType: vtBoolean; VarPtr: @VerifyWrite),
     (VarName: Ofs(bvCommandExecMode); VarType: vtByteEnum; VarPtr: @CmdExecMode;
       Values: Ofs(bvTransferModeValues)),
     (VarName: Ofs(bvHeadMovementSpeed); VarType: vtByte; VarPtr: @HeadSpeed;
       ByteMin: 0; ByteMax: MaxByte; ByteBase: 0),
     (VarName: Ofs(bvFormatBumpsHead); VarType: vtBoolean; VarPtr: @FormatBumpsHead),
     (VarName: Ofs(bvRetryNum); VarType: vtByte; VarPtr: @RetryNum;
       ByteMin: 0; ByteMax: MaxRetryNum; ByteBase: 0),
     (VarName: Ofs(bvRetryOnHalftracks); VarType: vtBoolean; VarPtr: @RetryHalftracks),
     (VarName: Ofs(bvRetryBumpsHead); VarType: vtBoolean; VarPtr: @RetryBumpsHead),
     (VarName: Ofs(bvDriveInterleave); VarType: vtByteArray; VarPtr: @DriveInts;
       ElemMin: 1; ElemMax: MaxDriveInt; IndValues: Ofs(bvDriveInterleaveIndexes)),
     (VarName: Ofs(bvLPT4); VarType: vtWord; VarPtr: @LPTAddresses[3]; WordMin: $0200; WordMax: $F800),
     (VarName: Ofs(bvLPT5); VarType: vtWord; VarPtr: @LPTAddresses[4]; WordMin: $0200; WordMax: $F800),
     (VarName: Ofs(bvAutoDelete); VarType: vtByteEnum; VarPtr: @AllDelete;
       Values: Ofs(bvAutoValues)),
     (VarName: Ofs(bvAutoDeleteReadonly); VarType: vtByteEnum; VarPtr: @AllDeleteReadonly;
       Values: Ofs(bvAutoValues)),
     (VarName: Ofs(bvAutoDeleteDir); VarType: vtByteEnum; VarPtr: @AllDeleteDir;
       Values: Ofs(bvAutoValues)),
     (VarName: Ofs(bvAutoOver); VarType: vtByteEnum; VarPtr: @AllOverwrite;
       Values: Ofs(bvAutoValues)),
     (VarName: Ofs(bvAutoOverReadonly); VarType: vtByteEnum; VarPtr: @AllOverwriteReadonly;
       Values: Ofs(bvAutoValues)));

var
  LoadAddrOK,
  FirstImage,
  FirstFile,
  LastFile      : Boolean;
  FormatSize,
  OutputSize,
  LoadAddr      : Word;
  ImageNum,
  FileNum,
  PrevImagePos,
  AllSize,
  LongSize,
  LongAllSize   : Longint;
  BatchName,
  BatchCommand  : string;
  FormatBuffer,
  OutputBuffer  : PSmallBuf;

procedure BatchFatalError(Error: string; ShowCommand: Boolean);
function GetBoolean(const Str: string): Boolean;
function GetEnumValue(const Value, List: string; var NumOK: Integer): Byte;
procedure StartBatchCommand(CheckNoInit: Boolean);
function BatchParamStr(Count: Byte; StripQuotes: Boolean): string;
procedure NextBatchCommand;
procedure ListFile;

implementation

uses
  DOS, Objects,
  Base1, Config, Panel1, Panel2, Reinit;

{Halt the program with a fatal error
  Input : Error: error message
          ShowCommand: when True, the current batch command is appended to
                       the error}
procedure BatchFatalError(Error: string; ShowCommand: Boolean);
begin
  if ShowCommand and (BatchCommand <> '') then Error := Error + ': "' + BatchCommand + '"';
  BatchMode := bmNone;
  ShellBuffer^.QuitProgram := True;
  Application^.Done;
  PrintStr(chCR + chLF + Error + chCR + chLF);
  Halt(0);
end;

{Convert a string into a boolean value
  Input : Str: the string
  Output: the corresponding boolean value}
function GetBoolean(const Str: string): Boolean;
begin
  if (Str = '1') or (Str = 'true') or (Str = 'yes') then GetBoolean := True
    else if (Str = '') or (Str = '0') or (Str = 'false') or (Str = 'no') then GetBoolean := False
    else BatchFatalError('Invalid value', True);
end;

{Extract parameter from batch command
  Input : Count: parameter count
          StripQuotes: when True, quotation marks are removed}
function BatchParamStr(Count: Byte; StripQuotes: Boolean): string;
var
  B             : Boolean;
  W,
  X             : Word;
  S             : string;

{Find the end of an area in the batch command
  Input : Spaces: when True, the end of white spaces is to be found;
                  otherwise normal text}
procedure ProcessString(Spaces: Boolean);
begin
  B := False;
  while (W <= Length(BatchCommand)) and (B or ((BatchCommand[W] in WhiteSpace) = Spaces)) do
  begin
    if BatchCommand[W] = '"' then B := not B;
    Inc(W);
  end;
end;

begin
  W := 1;
  Inc(Count);
  repeat
    ProcessString(True);
    X := W;
    if Count > 0 then
    begin
      Dec(Count);
      ProcessString(False);
    end;
  until Count = 0;
  S := Copy(BatchCommand, X, W - X);
  if StripQuotes then
  begin
    W := 1;
    while (W <= Length(S)) do if S[W] = '"' then Delete(S, W, 1) else Inc(W);
  end;
  BatchParamStr := S;
end;

{Find a value in a list of values
  Input : Value: the string value to find
          List: list of valid string values
          NumOK: variable to contain a non-zero value if the string value
                 was not found in the list
  Output: numerical value}
function GetEnumValue(const Value, List: string; var NumOK: Integer): Byte;
var
  F             : Boolean;
  B             : Byte;
  W             : Word;
  S             : string;
begin
  NumOK := 1;
  F := False;
  S := List;
  while not F and (S <> '') do
  begin
    B := Ord(S[1]);
    S := Copy(S, 2, MaxStrLen);
    W := LeftPos(',', S);
    if W = 0 then F := (Value = S) else F := (Value = Copy(S, 1, W - 1));
    if F then
    begin
      NumOK := 0;
    end
    else
    begin
      if W = 0 then S := '' else S := Copy(S, W + 1, MaxStrLen);
    end;
  end;
  GetEnumValue := B;
end;

{Set a batch variable}
procedure SetBatchVariable;
var
  O             : Boolean;
  B             : Byte;
  V,
  W             : Word;
  I             : Integer;
  P             : Pointer;
  Q             : PBatchVar;
  S,
  T,
  U             : string;
begin
  SourceName := LowerCase(SourceName);
  S := SourceName;
  T := '';
  U := '';
  W := LeftPos('[', S);
  if W > 0 then
  begin
    U := Copy(S, W + 1, MaxStrLen);
    if (U <> '') and (U[Length(U)] = ']') then Dec(U[0]) else U := '';
    S[0] := Chr(W - 1);
  end;
  W := 0;
  while (W < BatchVarNum) and (S <> PString(Ptr(DSeg, BatchVars[W].VarName))^) do Inc(W);
  if W >= BatchVarNum then T := 'Invalid variable';
  if T = '' then
  begin
    Q := @BatchVars[W];
    P := Q^.VarPtr;
    B := Q^.VarType;
    if B = vtByteArray then
    begin
      if U = '' then T := 'Missing index';
    end
    else
    begin
      if U <> '' then T := 'Redundant index';
    end;
    if T = '' then
    begin
      O := True;
      case B of
        vtBoolean: Boolean(P^) := GetBoolean(LowerCase(DestName));
        vtByte:
        begin
          B := EvalAny(DestName, I);
          if (I <> 0) or (B < Q^.ByteMin) or (B > Q^.ByteMax) then T := 'Invalid value' else
            Byte(P^) := B - Q^.ByteBase;
        end;
        vtByteEnum:
        begin
          B := GetEnumValue(LowerCase(DestName), PString(Ptr(DSeg, Q^.Values))^, I);
          if I <> 0 then T := 'Invalid value' else Byte(P^) := B;
        end;
        vtWord:
        begin
          V := EvalAny(DestName, I);
          if (I <> 0) or (V < Q^.WordMin) or (V > Q^.WordMax) then T := 'Invalid value' else
            Word(P^) := V;
        end;
        vtString:
        begin
          B := Q^.StrMaxLen;
          if Length(DestName) > B then DestName[0] := Chr(B);
          string(P^) := DestName;
        end;
        vtByteArray:
        begin
          B := EvalAny(DestName, I);
          if (I <> 0) or (B < Q^.ElemMin) or (B > Q^.ElemMax) then
          begin
            T := 'Invalid value';
          end
          else
          begin
            W := GetEnumValue(U, PString(Ptr(DSeg, Q^.IndValues))^, I);
            if I <> 0 then
            begin
              T := 'Unknown index';
            end
            else
            begin
              TBuffer(P^)[W] := B;
            end;
          end;
        end;
      end;
    end;
  end;
  if T <> '' then BatchFatalError(T, True);
end;


procedure ExitBatch;
var
  E             : TEvent;
begin
  ShellBuffer^.QuitProgram := True;
  E.What := evCommand;
  E.Command := cmQuit;
  Application^.PutEvent(E);
end;

{Process and execute batch command
  Input : CheckNoInit: when False, normal behavior; when True, only the
                       "noinit" command is checked, at the beginning of the
                       script}
procedure StartBatchCommand(CheckNoInit: Boolean);
var
  O,
  Q,
  X             : Boolean;
  V,
  W             : Word;
  S,
  T             : string;
  E             : TEvent;
begin
  if BatchMode <> bmNone then
  begin
    X := False;
    while not X do
    begin
      O := False;
      Q := False;
      T := '';
      case BatchMode and bmModeMask of
        bmSingle: O := True;
        bmScript:
        begin
          repeat
            if LongOpenFile(BatchName, ReadFile, fmReadOnly) = 0 then
            begin
              CopySize := ExtFileSize(ReadFile);
              Q := (BatchOffset = CopySize);
              if not Q then
              begin
                ExtSeek(ReadFile, BatchOffset);
                Dec(CopySize, BatchOffset);
                if CopySize > TempBufferSize then CopySize := TempBufferSize;
                ExtBlockRead(ReadFile, GCRBuffer, CopySize);
                ExtClose(ReadFile);
                O := (IOResult = 0);
                if O then
                begin
                  CopiedSize := 0;
                  BatchCommand := '';
                  while (CopiedSize < CopySize) and not EOLMark(Chr(GCRBuffer[CopiedSize])) do
                  begin
                    if (Length(BatchCommand) < MaxStrLen - 1) then BatchCommand := BatchCommand + Chr(GCRBuffer[CopiedSize]);
                    Inc(CopiedSize);
                  end;
                  while (CopiedSize < CopySize) and EOLMark(Chr(GCRBuffer[CopiedSize])) do Inc(CopiedSize);
                  Inc(BatchOffset, CopiedSize);
                  BatchCommand := AllTrim(BatchCommand);
                end;
              end;
            end
            else
            begin
              Q := True;
              X := True;
              BatchFatalError('Could not find the script file "' + BatchName + '"', False);
            end;
          until Q or (T <> '') or ((BatchCommand <> '') and (BatchCommand[1] <> BatchComment));
          X := Q;
          ShellBuffer^.FirstFile := True;
          Act^.FirstFile := True;
        end;
      end;
      if O then
      begin
        S := BatchCommand;
        BatchCommand := '';
        repeat
          V := 0;
          W := LeftPos(ScriptEnvVarPrefix, S);
          if (W > 0) and (Length(S) > W) and (S[W + 1] = ScriptEnvVarPrefix) then
          begin
            V := LeftPos(ScriptEnvVarPrefix, Copy(S, W + 2, MaxStrLen));
            if V > 0 then
            begin
              BatchCommand := BatchCommand + Copy(S, 1, W - 1) + GetEnv(Copy(S, W + 2, V - 1));
              S := Copy(S, W + V + 2, MaxStrLen);
            end;
          end;
        until V = 0;
        BatchCommand := BatchCommand + S;
        CopyFileMode := cfAutomatic;
        SourceName := BatchParamStr(1, True);
        DestName := BatchParamStr(2, True);
        S := LowerCase(BatchParamStr(0, True));
        W := 0;
        while (W < BatchCommandNum) and (S <> PString(Ptr(DSeg, BatchCommands[W].CmdName))^) do Inc(W);
        if W >= BatchCommandNum then T := 'Invalid command'
          else if BatchParamStr(BatchCommands[W].ParNum, False) = '' then T := 'Missing parameter';
      end;
      if not Q then
      begin
        if T = '' then
        begin
          W := BatchCommands[W].CmdEvent;
          if CheckNoInit then
          begin
            if W = cmANoInit then BatchMode := BatchMode or bmNoInit else BatchOffset := 0;
            X := True;
          end
          else
          begin
            case W of
              cmASet:
              begin
                SetBatchVariable;
                Q := (BatchMode and bmModeMask = bmSingle);
                X := Q;
              end;
              cmAInit: InitInternals(True);
              cmASetDrive:
              begin
                if DriveNum > 0 then
                begin
                  W := 0;
                  while (W < DriveNum) and (SourceName <> DriveConfigs[W].Name) do Inc(W);
                  if W < DriveNum then PutDrivePars(@DriveConfigs[W]) else T := 'Unknown drive';
                end;
              end;
              cmAExit:
              begin
                Q := True;
                X := True;
              end;
            else
              CopyIntoFileImages := ifNever;
              CopyExtractFileImages := xfNever;
              E.What := evCommand;
              E.Command := W;
              Application^.PutEvent(E);
              X := True;
            end;
          end;
        end;
        if T <> '' then
        begin
          BatchFatalError(T, True);
          X := True;
        end;
      end;
    end;
    if Q then ExitBatch;
  end;
end;

{Execute the next batch command}
procedure NextBatchCommand;
begin
  if not RunningShell then
  begin
    case BatchMode and bmModeMask of
      bmSingle: ExitBatch;
      bmScript: StartBatchCommand(False);
    end;
  end;
end;

{Read the load address from the image or archive file}
procedure GetLoadAddr;
begin
  LoadAddrOK := False;
  case Act^.CopyMode of
    pmDisk:
    begin
      Act^.ReadDiskBlock(Entry.Track, Entry.Sector, @DataBuffer, False);
      if (DataBuffer[0] > 0) or (DataBuffer[1] > 3) then
      begin
        LoadAddr := BytesToLongint(DataBuffer[2], DataBuffer[3], 0, 0);
        LoadAddrOK := True;
      end;
    end;
    pmLynx..pmTAR:
    begin
      if Entry.Size > 0 then
      begin
        ExtSeek(Act^.Image, PrevImagePos);
        ExtBlockRead(Act^.Image, LoadAddr, SizeOf(Word));
        LoadAddrOK := True;
      end;
    end;
  end;
end;

{Format the output, based on the specification
  Input : CondType: the type of the conditional block; when 0, the complete
                    format specification is processed, otherwise only
                    blocks inside conditional blocks of the specified type
          DispNormal: when True, the main part of the specification is
                      output; otherwise only conditional parts}
procedure FormatOutput(CondType: Byte; DispNormal: Boolean);
var
  F,
  G,
  O             : Boolean;
  B,
  D,
  X,
  Z             : Byte;
  C,
  E             : Char;
  I             : Word;
  S             : string;
  T             : PFormatSpec;
  U             : PCondSpec;

{Process an indicator character and output the character or a '1' if the
  character is not a space; otherwise, output an empty string or a '0'
  Input : Ch: the character to process}
procedure ProcessChar(Ch: Char);
begin
  if O then
  begin
    S[0] := #1;
    S[1] := Chr(Ord('0') + Byte(Ch <> ' '));
  end
  else
  begin
    S := Ch;
    if Ch = ' ' then S := '';
  end;
end;

{Take the width byte apart into direction and length
  Width: the width byte
  WidthDir: the width direction byte}
procedure ProcessWidth(Width, WidthDir: Byte);
begin
  F := (WidthDir and ffLeftDir = 0);
  G := (WidthDir and ffRightDir = 0);
  D := Width;
end;

{Convert a PETSCII string into ASCII form, taking several format flags into
  account
  Input : Name: the PETSCII string to convert
  Output: the converted string}
function ConvertCBMName(const Name: string): string;
var
  C             : Char;
  I             : Word;
  B             : PBlock;
  S             : string;

{Put a hexadecimal code into the output string, if an invalid PETSCII
  character was encountered}
procedure PutHexaCode;
begin
  S := S + '%' + HexaStr(Ord(C), 2);
end;

begin
  if Act^.CopyMode in [pmTAR, pmLHA] then
  begin
    ConvertCBMName := Name;
  end
  else
  begin
    S := '';
    if X and ffUpperCase > 0 then B := @PETtoASCUpper else B := @PETtoASCLower;
    for I := 1 to Length(Name) do
    begin
      C := Name[I];
      if Act^.CopyGEOSFormat and (X and ffGEOS > 0) then
      begin
        C := Chr(Ord(C) and $7F);
        if (X and ffHexaConvert = 0) or (C in [' '..#$7E]) then S := S + C else PutHexaCode;
      end
      else
      begin
        if (X and ffHexaConvert = 0) or (C in [' '..'!', '#'..'$', '&'..')', '+'..'.', '0'..':', '=', '@'..'Z', '[', ']'])
          or ((X and ffUpperCase = 0) and (C in [#$C1..#$DA])) then S := S + Chr(B^[Ord(C)]) else PutHexaCode;
      end;
    end;
    ConvertCBMName := S;
  end;
end;

{Put a string constant into the output buffer}
procedure PutString(Str: PString);
var
  I             : Word;
begin
  I := TSmallBufSize - OutputSize - 1;
  if B < I then I := B;
  if I > 0 then
  begin
    Move(Str^, OutputBuffer^[OutputSize], I);
    Inc(OutputSize, I);
  end;
end;

begin
  I := 0;
  Z := 0;
  if (CondType = 0) and DispNormal then Inc(Z);
  OutputSize := 0;
  while I < FormatSize do
  begin
    B := FormatBuffer^[I];
    Inc(I);
    case B of
      0:
      begin
        if Z > 0 then
        begin
          T := PFormatSpec(@FormatBuffer^[I]);
          S := '';
          C := UpCase(T^.FieldType);
          X := T^.Flags;
          O := (T^.FieldType = C);
          case C of
            'A':
            begin
              S := '';
              if O then
              begin
                if Act^.CopyMode = pmDisk then S := LeadingZero(Entry.Track, 2) + ';' + LeadingZero(Entry.Sector, 2);
              end
              else
              begin
                GetLoadAddr;
                if LoadAddrOK and (Act^.CopyMode in [pmDisk..pmFile, pmLynx..pmTAR]) then S := '$' + HexaStr(LoadAddr, 4);
              end;
            end;
            'B': if O then S := LeadingSpace(Act^.CopyLongFree, 0) else S := LeadingSpace(Act^.CopyShortFree, 0);
            'C':
            begin
              if Entry.Attr and faClosed = 0 then E := '*' else E := ' ';
              ProcessChar(E);
            end;
            'D': S := Copy(Act^.CopyPath, 1, 2);
            'E':
            begin
              if O then S := FileExt(Act^.CopyImageName) else S := FileExt(Inact^.CopyImageName);
              if S <> '' then S := '.' + S;
            end;
            'F': if X and ffSum > 0 then S := LeadingSpace(ImageNum, 0) else if O then S := FileName(Act^.CopyImageName) else
              S := FileName(Inact^.CopyImageName);
            'I': if O then S := ConvertCBMName(Act^.CopyID) else S := ConvertCBMName(Copy(Act^.CopyID, 1, 2));
            'L': if O then S := ConvertCBMName(Act^.CopyLabel) else S := ConvertCBMName(Act^.CopyShortLabel);
            'N': if X and ffSum > 0 then S := LeadingSpace(FileNum, 0) else S := ConvertCBMName(Entry.Name);
            'P', 'R':
            begin
              if O then S := Copy(Act^.CopyPath, 3, MaxStrLen) else S := Copy(Inact^.CopyPath, 3, MaxStrLen);
              if C = 'P' then
              begin
                S := AddToPath(S, stEmpty, chDirSep);
              end
              else
              begin
                if Length(S) > 1 then S := Copy(S, 2, Length(S) - 1);
              end;
            end;
            'S': if X and ffSum > 0 then if O then S := LeadingSpace(LongAllSize, 0) else S := LeadingSpace(AllSize, 0)
               else if O then S := LeadingSpace(LongSize, 0) else S := LeadingSpace(Entry.Size, 0);
            'T':
            begin
              if (X and ffGEOS > 0) and Act^.CopyGEOSFormat then S := ShortGEOSExt[Entry.ExtAttr and xaTypeMask] else
                S := ShortCBMExt[Entry.Attr and faTypeMask];
              if X and ffUpperCase > 0 then S := UpperCase(S);
            end;
            'W':
            begin
              if Entry.Attr and faWriteProt = 0 then E := ' ' else E := '<';
              ProcessChar(E);
            end;
          end;
          if X and ffQuoted > 0 then S := '"' + S + '"';
          ProcessWidth(T^.MaxWidth, T^.MaxWidthDir);
          if Length(S) > D then if F then if G then S[0] := Chr(D) else S := Copy(S, D, MaxStrLen)
            else S := Copy(S, Length(S) - D + 1, MaxStrLen);
          ProcessWidth(T^.Padding, T^.PaddingDir);
          while Length(S) < D do if F then S := ' ' + S else S := S + ' ';
          B := Length(S);
          PutString(PString(@S[1]));
        end;
        Inc(I, SizeOf(TFormatSpec));
      end;
      MaxByte:
      begin
        U := PCondSpec(@FormatBuffer^[I]);
        Inc(I, SizeOf(TCondSpec));
        O := True;
        D := U^.CondType;
        if CondType > 0 then
        begin
          if D = CondType then
          begin
            O := False;
            Inc(Z);
          end
          else
          begin
            if D = cfCondEnd then
            begin
              O := False;
              if Z > 0 then Dec(Z);
            end;
          end;
        end;
        if O or (CondType = 0) then
        begin
          O := False;
          case D of
            cfFirstFile: O := FirstFile;
            cfLastFile: O := LastFile;
            cfCondEnd: O := True;
          end;
          if O then
          begin
            if (CondType = 0) and not DispNormal then
            begin
              if D = cfCondEnd then
              begin
                Dec(Z);
              end
              else
              begin
                Inc(Z);
              end;
            end;
          end
          else
          begin
            D := 1;
            while not O and (I < FormatSize) do
            begin
              B := FormatBuffer^[I];
              Inc(I);
              case B of
                0: Inc(I, SizeOf(TFormatSpec));
                MaxByte:
                begin
                  if PCondSpec(@FormatBuffer^[I])^.CondType and cfCondEnd = 0 then Inc(D) else Dec(D);
                  O := (D = 0);
                  Inc(I, SizeOf(TCondSpec));
                end;
              else
                Inc(I, B);
              end;
            end;
          end;
        end;
      end;
    else
      if Z > 0 then PutString(PString(@FormatBuffer^[I]));
      Inc(I, B);
    end;
  end;
  ExtBlockWrite(TempFile, OutputBuffer^, OutputSize);
end;

{Compress the format specification, tokenizing field specifiers and conditional
  block entries and exits}
procedure TokenizeFormat;
var
  F,
  O,
  Q,
  W             : Boolean;
  C,
  D             : Byte;
  E,
  I,
  J             : Word;
  X             : Integer;
  S             : string;
  T             : TFormatSpec;
  U             : TCondSpec;

{Get a further byte from the format specification
  Input : Dist: distance from the current offset
  Output: the byte read}
function NextByte(Dist: Word): Byte;
var
  J             : Word;
begin
  NextByte := 0;
  J := I + Dist;
  if J < FormatSize then NextByte := OutputBuffer^[J];
end;

{Read a decimal number from the format specification}
function GetNumber: Byte;
var
  F,
  Q             : Boolean;
  B             : Byte;
  J,
  N             : Word;
begin
  N := 0;
  Q := False;
  F := False;
  repeat
    B := NextByte(E);
    case B of
      Ord(chCR), Ord(chLF): Inc(E);
      Ord('0')..Ord('9'):
      begin
        F := True;
        N := N * 10 + (B - Ord('0'));
        if N > MaxWidth then N := MaxWidth;
        Inc(E);
      end;
    else
      Q := True;
    end;
  until Q;
  if F then Dec(E);
  GetNumber := N;
end;

{Put a string constant into the format buffer}
procedure PutString;
var
  I             : Word;
begin
  I := TSmallBufSize - J - 1;
  if Length(S) > I then S[0] := Chr(I);
  if Length(S) > 0 then
  begin
    I := Length(S) + 1;
    Move(S, FormatBuffer^[J], I);
    Inc(J, I);
    S := '';
  end;
end;

{Put a conditional blocks entry or exit token into the format buffer
  Input : CondType: the type of the condition token}
procedure PutCondition(CondType: Byte);
begin
  PutString;
  U.CondType := CondType;
  FormatBuffer^[J] := MaxByte;
  Move(U, FormatBuffer^[J + 1], SizeOf(TCondSpec));
  Inc(J, (SizeOf(TCondSpec) + 1));
  Inc(I, 3);
  O := False;
end;

begin
  F := False;
  I := 0;
  J := 0;
  S := '';
  while I < FormatSize do
  begin
    C := OutputBuffer^[I];
    O := True;
    case Chr(C) of
      chCR, chLF:
      begin
        O := False;
        Inc(I);
      end;
      '%':
      begin
        case UpCase(Chr(NextByte(1))) of
          '%': Inc(I);
          '?':
          begin
            case UpCase(Chr(NextByte(2))) of
              '^': PutCondition(cfFirstFile);
              '$': PutCondition(cfLastFile);
              'H': PutCondition(cfHeader);
              'F': PutCondition(cfFooter);
              '!': PutCondition(cfCondEnd);
            end;
          end;
        else
          T.Padding := 0;
          T.PaddingDir := ffNoDir;
          T.MaxWidth := MaxWidth;
          T.MaxWidthDir := ffNoDir;
          T.Flags := ffNone;
          T.FieldType := ' ';
          E := 1;
          Q := False;
          W := False;
          repeat
            D := NextByte(E);
            case UpCase(Chr(D)) of
              '0'..'9': if W then T.MaxWidth := GetNumber else T.Padding := GetNumber;
              '-': if W then T.MaxWidthDir := T.MaxWidthDir or ffLeftDir else T.PaddingDir := T.PaddingDir or ffLeftDir;
              '+': if W then T.MaxWidthDir := T.MaxWidthDir or ffRightDir else T.PaddingDir := T.PaddingDir or ffRightDir;
              '*': T.Flags := T.Flags or ffSum;
              '/': W := not W;
              'G': T.Flags := T.Flags or ffGEOS;
              'H': T.Flags := T.Flags or ffHexaConvert;
              'Q': T.Flags := T.Flags or ffQuoted;
              'U': T.Flags := T.Flags or ffUpperCase;
              #0, 'A'..'F', 'I', 'L', 'N', 'P', 'R'..'T', 'W':
              begin
                T.FieldType := Chr(D);
                Q := True;
                O := False;
              end;
            end;
            Inc(E);
          until Q;
          if T.FieldType = #0 then O := True;
          if not O then
          begin
            PutString;
            if J < TSmallBufSize - (SizeOf(TFormatSpec) + 1) then
            begin
              FormatBuffer^[J] := 0;
              Move(T, FormatBuffer^[J + 1], SizeOf(TFormatSpec));
              Inc(J, (SizeOf(TFormatSpec) + 1));
            end;
            Inc(I, E);
          end;
        end;
      end;
      '\':
      begin
        Q := True;
        case UpCase(Chr(NextByte(1))) of
          '$':
          begin
            D := HexaEval(Chr(NextByte(2)) + Chr(NextByte(3)), X);
            if X = 0 then
            begin
              C := D;
              Inc(I, 2);
            end
            else
            begin
              Q := False;
            end;
          end;
          'B': C := Ord(chBackspace);
          'N': C := Ord(chLF);
          'R': C := Ord(chCR);
          'S': C := Ord(' ');
          'T': C := Ord(chTab);
          '\':
        else
          Q := False;
        end;
        if Q then Inc(I);
      end;
    end;
    if O then
    begin
      if Length(S) = MaxStrLen then PutString;
      S := S + Chr(C);
      Inc(I);
    end;
  end;
  PutString;
  FormatSize := J;
end;

{Convert the long file names to their short equivalents}
procedure MakeShortName;
var
  S,
  N,
  E             : string;
begin
  S := AddToPath(Act^.CopyPath, Act^.CopyImageName, chDirSep);
  LongFSplit(S, Inact^.CopyPath, N, E);
  Inact^.CopyImageName := N + E;
end;

{List the contents of an image file}
procedure ListImage;
var
  F             : Boolean;
  I             : Integer;
  NextEntry     : TDirEntry;
begin
  MakeShortName;
  if Act^.OpenImage(False, False, True, False, False) = 0 then
  begin
    if FirstImage then
    begin
      FirstImage := False;
      I := LongOpenFile(DestName, TempFile, fmReadWrite);
      if I = 0 then ExtSeek(TempFile, ExtFileSize(TempFile)) else
        I := LongOpenFile(DestName, TempFile, fmWriteOnly);
      if I <> 0 then BatchFatalError('Could not open the list file "' + DestName + '"', False);
    end;
    Inc(ImageNum);
    if ImageNum = 1 then FormatOutput(cfHeader, False);
    FirstFile := True;
    LastFile := not Act^.ReadCBMEntry(Entry);
    ContProcess := not LastFile;
    while ContProcess and (Act^.DirPos <= Act^.DirLength) do
    begin
      LoadAddr := 0;
      LoadAddrOK := False;
      PrevImagePos := Act^.ImagePos;
      LastFile := not Act^.ReadCBMEntry(NextEntry) or (Act^.DirPos > Act^.DirLength);
      if Entry.Attr > 0 then
      begin
        while not LastFile and (NextEntry.Attr = 0) do LastFile := not Act^.ReadCBMEntry(NextEntry);
        if Act^.CopyMode in [pmTape, pmFile, pmLynx..pmZIP] then
        begin
          LongSize := Entry.Size;
          Entry.Size := ByteToBlock(Entry.Size);
        end
        else
        begin
          LongSize := Entry.Size * 254;
        end;
        Inc(FileNum);
        Inc(AllSize, Entry.Size);
        Inc(LongAllSize, LongSize);
        F := CompareCBMEntry(Act^.NamePattern, Entry.Name, Entry.Attr, False);
        FormatOutput(cfNormal, F);
        if F then FirstFile := False;
      end;
      ContProcess := not LastFile;
      Entry := NextEntry;
    end;
    Act^.CloseImage(False);
  end;
end;

{List the contents of Commodore disks and image and archive files}
procedure ListFile;
begin
  if LongOpenFile(BatchParamStr(3, True), TempFile, fmReadOnly) = 0 then
  begin
    OutputBuffer := New(PSmallBuf);
    FormatBuffer := New(PSmallBuf);
    ExtBlockRead2(TempFile, OutputBuffer^, TSmallBufSize, FormatSize);
    ExtClose(TempFile);
    if IOResult = 0 then
    begin
      TokenizeFormat;
      Act^.Prepare(SourceName, True, False, False);
      FirstImage := True;
      ImageNum := 0;
      FileNum := 0;
      AllSize := 0;
      LongAllSize := 0;
      ListImage;
      if not FirstImage then FormatOutput(cfFooter, False);
    end;
    Dispose(FormatBuffer);
    Dispose(OutputBuffer);
  end;
  NextBatchCommand;
end;

end.
