
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   SCSETUP.PAS                   }
{                                                 }
{        The Star Commander Setup main unit       }
{*************************************************}

program The_Star_Commander_Setup;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 0, 655360}

uses
  App, Dialogs, DOS, Drivers, Memory, Menus, Objects, Views,
  Base1, Base2, CfgMenus, Clipbrd, Colors, Common, Config, Constant, ExtFiles, Help, LowLevel, OpenCBM;

const
{Help contexts}
  hcPalette2    = 126;

type
  TCmdrSetup    = object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure InitKeyBar; virtual;
    procedure Idle; virtual;
    procedure GetEvent(var Event: TEvent); virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

var
  CmdrSetup     : TCmdrSetup;

{Execute the procedure responsible for displaying a given menu
  Input : Event: event record to get command from and put new event into
  Output: when True, the command was recognized}
function ExecMenuProc(var Event: TEvent): Boolean; far;
begin
  ExecMenuProc := True;
  case Event.Command of
    cmCfgConfig: SetupMenu^.ExecProc(CfgConfig, False, False, cmCfgOther, cmCfgDrive, Event);
    cmCfgOther: SetupMenu^.ExecProc(CfgOther, False, False, cmCfgImage, cmCfgConfig, Event);
    cmCfgImage: SetupMenu^.ExecProc(CfgImage, False, False, cmCfgTransfer, cmCfgOther, Event);
    cmCfgTransfer: SetupMenu^.ExecProc(CfgTransfer, False, False, cmCfgDrive, cmCfgImage, Event);
    cmCfgDrive: SetupMenu^.ExecProc(CfgDrive, False, False, cmCfgConfig, cmCfgTransfer, Event);
    cmCfgPalette: SetupMenu^.ExecProc(CfgPalette, True, True, cmNone, cmNone, Event);
    cmCfgReset: SetupMenu^.ExecProc(CfgReset, True, True, cmNone, cmNone, Event);
    cmCfgCountry: SetupMenu^.ExecProc(CfgCountry, False, False, cmNone, cmNone, Event);
  else
    ExecMenuProc := False;
  end;
end;

{Display main config menu and execute its items}
procedure MainConfig;
var
  O             : Boolean;
  B             : Byte;
  A,
  P             : PSetupItem;
  R             : TRect;
begin
  ChangeHelpCtx(hcMainConfig2);
  P := NewSetupItem('F2', 'Configuration', cmCfgConfig, hcCfgConfig, nil);
  A := P;
  P := NewSetupItem('F3', 'Other options', cmCfgOther, hcCfgOther, P);
  P := NewSetupItem('F4', 'Image options', cmCfgImage, hcCfgImage, P);
  P := NewSetupItem('F5', 'Transfer options', cmCfgTransfer, hcCfgTransfer, P);
  P := NewSetupItem('F6', 'Drive options', cmCfgDrive, hcCfgDrive, P);
  P := NewSetupItem('F7', 'Set palettes', cmCfgPalette, hcCfgPalette, P);
  P := NewSetupItem('F8', 'Set default configuration', cmCfgReset, hcCfgReset, P);
  P := NewSetupItem('F9', 'Country info', cmCfgCountry, hcCfgCountry, P);
  P := NewSetupItem('F10', 'Exit', cmCancel, hcCfgQuit, P);
  R.Assign(4, 2, 0, 11);
  SetupMenu := New(PSetupMenu, Init(R, A, A, ExecMenuProc));
  MakeWinBounds(R, SetupMenu^.Size.X, 9);
  SetupDialog := New(PDialog, Init(R, 'Setup', fxNormal, fyNormal, False));
  SetupDialog^.Insert(SetupMenu);
  SetupDialog^.Palette := wpHistory;
  KeyBar^.MakeFirst;
  SaveConfig(sdNone);
  Move(GCRBuffer, GCRBuffer[TempBufferSize - SetupLen], SetupLen);
  TempDialog := nil;
  Application^.ExecView(SetupDialog, True, True);
  Dispose(SetupDialog, Done);
  RestoreHelpCtx;
  if SetupChanged and (SetupCmd = cmOK) then
  begin
    if Resident then SaveConfig(sdShellBuffer);
    if not SaveConfig(sdFile) then ErrorWin(stEmpty, 'There was an error while', 'saving the setup file',
      hcNoContext, sbNone);
  end;
end;

procedure ClockOffProc; far;
begin
  if ClockVis then Clock^.Hide;
end;

procedure ClockOnProc; far;
begin
  if not ClockVis then Clock^.Show;
end;

procedure GetClockProc(B: Boolean); far;
begin
  ClockLast := ClockVis;
  if B then ClockOn else ClockOff;
end;

procedure SetClockProc; far;
begin
  if ClockLast then ClockOn else ClockOff;
end;

constructor TCmdrSetup.Init;
var
  B             : Byte;
  X             : Integer;
  A,
  P             : PSetupItem;
  M             : PSetupMenu;
  R             : TRect;
  E             : TEvent;
begin
  SaveConfig(sdNone);
  Move(GCRBuffer, GCRBuffer[TempBufferSize - SetupLen], SetupLen);
  InitMouse;
  MouseInit.X := -1;
  CommandOutput := coNormal;
  TApplication.Init;
  HelpNum := 0;
  GoSound := False;
  MakeSound := True;
  SysErrorFunc := SysErrorWin;
  EmergencyExitFunc := EmergencyExit;
  CtrlAltInsActive := True;
  Randomize;
  AppHelpCtx := hcNormal;
  CurHelpCtx := hcNormal;
  SetupHelpCtx := hcNormal;
  MenuInUse := False;
  HelpInUse := False;
  HelpCtxSet := False;
  MouseRightHeld := False;
  LoadingDirs := True;
  CopyExtDisk := ExtendedDisk;
  InitSaver;
  ClockOn := ClockOnProc;
  ClockOff := ClockOffProc;
  GetClock := GetClockProc;
  SetClock := SetClockProc;
  EnableWinNTPortAccess;
  if Resident then
  begin
    Move(ShellBuffer^.LPTAddresses, LPTAddresses, SizeOf(LPTAddresses));
    Move(ShellBuffer^.LPTModes, LPTModes, SizeOf(LPTModes));
  end
  else
  begin
    CollectLPTPorts(True);
  end;
  InitScreen;
  InitCountry;
  InitLongNames;
  InitClipboard;
  SetCharSet(csIBMLower, True, False);
  FrameChars := DefFrameChars;
  MenuFrameChars := DefMenuFrameChars;
  if (CharSetMode >= csCBMLower) or (CodePage = CodePageUS) then
  begin
    DoubleFrameChars := DefDoubleFrameChars;
    CheckedChar := DefCheckedChar;
    DotChar := DefDotChar;
  end
  else
  begin
    DoubleFrameChars := AltDefDoubleFrameChars;
    CheckedChar := AltDefCheckedChar;
    DotChar := AltDefDotChar;
  end;
  Buffer := ScreenBuffer;
  R.Assign(0, 0, ScreenWidth, ScreenHeight);
  ChangeBounds(R);
  WinSize := R.B.Y - R.A.Y - 2;
  WinCenter := (WinSize - 6) shr 1;
  if ShowKeyBar then KeyBar^.Show else KeyBar^.Hide;
  GetExtent(R);
  B := 6;
  if MilitaryTime then Dec(B);
  R.A.X := R.B.X - B;
  R.B.Y := R.A.Y + 1;
  Clock := New(PClock, Init(R));
  Insert(Clock);
  Background^.DrawView;
  KeyBar^.MakeFirst;
  ClockOn;
  WentToCorner := False;
  LastWhere := MouseWhere;
  PrintConfigError;
  LastHalfSec := 2;
  Clock^.DrawView;
  MenuInUse := True;
  MainConfig;
  E.What := evCommand;
  E.Command := cmQuit;
  PutEvent(E);
end;

destructor TCmdrSetup.Done;
begin
  TApplication.Done;
  asm
    mov ah, 3;
    xor bh, bh;
    call VideoInt;
    mov ah, 2;
    xor bh, bh;
    xor dl, dl;
    dec dh;
    call VideoInt;
  end;
end;

procedure TCmdrSetup.InitKeyBar;
var
  R             : TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  KeyBar := New(PKeyBar, Init(R,
    NewStatusDef(hcNoContext, hcNoContext,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      nil)))))))))),
    NewStatusDef(hcMainConfig2, hcMainConfig2,
      NewStatusKey('Help', kbF1, cmHelp,
      NewStatusKey('Config', kbF2, cmCfgConfig,
      NewStatusKey('Other', kbF3, cmCfgOther,
      NewStatusKey('Image', kbF4, cmCfgImage,
      NewStatusKey('Xfer', kbF5, cmCfgTransfer,
      NewStatusKey('Drive', kbF6, cmCfgDrive,
      NewStatusKey('Colors', kbF7, cmCfgPalette,
      NewStatusKey('Reset', kbF8, cmCfgReset,
      NewStatusKey('Cntry', kbF9, cmCfgCountry,
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcNoContext + 1, hcCfgPalette2 - 1,
      NewStatusKey('Help', kbF1, cmHelp,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcCfgPalette2, hcCfgPalette2,
      NewStatusKey('Help', kbF1, cmHelp,
      NewStatusKey('Save', kbF2, cmSavePal,
      NewStatusKey('Load', kbF3, cmLoadPal,
      NewEmptyKey(
      NewStatusKey('B&W', kbF5, cmBlackWhite,
      NewStatusKey('Color', kbF6, cmColor,
      NewStatusKey('Laptop', kbF7, cmLaptop,
      NewStatusKey('Reset', kbF8, cmResetPal,
      NewEmptyKey(
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcOnlyQuit, hcOnlyQuit,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    nil)))))));
  LastShiftState := MaxByte;
end;

procedure TCmdrSetup.Idle;
var
  O             : Boolean;
  B             : Byte;
  I             : Integer;
  L             : Longint;
begin
  if SaverInUse then
  begin
    ScreenSaver^.Idle;
  end
  else
  begin
    if (SaverTicks > 0) and (GetTicks > SaverCount + SaverTicks) and
      ((MouseWhere.X < ScreenWidth - 2) or (MouseWhere.Y < ScreenHeight - 1)) then SaverOn;
  end;
  if not SaverInUse then
  begin
    Clock^.MakeFirst;
    Clock^.DrawView;
    if GoSound then
    begin
      if ErrorSound then
      begin
        if ClockVis then Clock^.Hide;
        Beep;
        if not SysError then
        begin
          ClockOn;
          LastHalfSec := 2;
        end;
        TopView^.DrawView;
      end;
      GoSound := False;
    end;
  end;
  B := GetShiftState;
  if B <> LastShiftState then
  begin
    SaverCount := GetTicks;
    if SaverInUse then SaverOff;
    MouseRightHeld := False;
    if HelpCtxSet and not HelpInUse then
    begin
      ShiftHelpCtx := hcNoContext;
      AltHelpCtx := hcNoContext;
      if B = 0 then AppHelpCtx := CurHelpCtx else AppHelpCtx := hcNoContext;
    end
    else
    begin
      if HelpInUse then
      begin
        ShiftHelpCtx := hcNoContext;
        AltHelpCtx := hcNoContext;
      end
      else
      begin
        ShiftHelpCtx := hcShift;
        AltHelpCtx := hcAlt;
      end;
      if B = 0 then if HelpInUse then AppHelpCtx := hcOnlyQuit else AppHelpCtx := hcNormal;
      if B and (kbRightShift + kbLeftShift + kbCtrlShift + kbAltShift) > 0 then AppHelpCtx := hcNoContext;
    end;
    LastShiftState := B;
  end;
  TApplication.Idle;
end;

procedure TCmdrSetup.GetEvent(var Event: TEvent);
var
  F,
  O             : Boolean;
  S             : string;
  E             : TEvent;
begin
  TApplication.GetEvent(Event);
  if CtrlAltInsHit then EmergencyExit;
  if GoSound or ((MouseButtons > 0) and (Event.What and evKeyboard > 0)) then ClearEvent(Event);
  if Event.What = evNothing then
  begin
    if WentToCorner and (MouseWhere.X >= ScreenWidth - 2) and (MouseWhere.Y = 0) and (GetTicks > SaverCount + QuarterTicks) and
      not SaverInUse and (GetShiftState = 0) then
    begin
      SaverOn;
      WentToCorner := False;
      LastWhere := Event.Where;
      ClearEvent(Event);
    end;
  end
  else
  begin
    SaverCount := GetTicks;
    if (Event.What and evMouseMove > 0) and (Event.Where.X >= ScreenWidth - 2) and (Event.Where.Y = 0) and
      ((LastWhere.X < ScreenWidth - 2) or (LastWhere.Y > 0)) then
    begin
      WentToCorner := True;
    end
    else
    begin
      if SaverInUse then ScreenSaver^.HandleEvent(Event);
      if Event.What and evMouse > 0 then LastWhere := Event.Where;
    end;
  end;
  if (Event.What and evCommand > 0) then
  begin
    case Event.Command of
      cmHelp:
      begin
        if not HelpInUse then
        begin
          MouseRightHeld := False;
          HelpNum := AppHelpCtx;
          case HelpNum of
            hcMainConfig2: HelpNum := SetupHelpCtx;
            hcCfgPalette2: HelpNum := hcCfgPalette;
          end;
          if HelpNum >= hcHelp then HelpNum := hcNoContext;
          _Help;
          ClearEvent(Event);
        end;
      end;
      cmRecalibrate: Recalibrate;
    end;
  end;
  if (Event.What and evMouseDown > 0) and (HelpCtxSet or HelpInUse) then
  begin
    F := TopView^.MouseInView(Event.Where);
    E.What := evKeyboard;
    E.KeyCode := kbNoKey;
    if Event.Buttons and mbMiddleButton > 0 then
    begin
      F := True;
      E.KeyCode := kbEnter;
    end
    else if (Event.Buttons and mbRightButton > 0) and not F then E.KeyCode := kbEsc else
      if (Event.Buttons and mbLeftButton > 0) and not F then E.KeyCode := kbEsc;
    if E.KeyCode <> kbNoKey then
    begin
      repeat
        O := F or not TopView^.MouseInView(Event.Where);
        if O then
        begin
          if E.KeyCode = kbEnter then SetDefMouseCursorChar(CheckedChar) else SetDefMouseCursorChar(CancelledChar);
        end
        else
        begin
          SetDefMouseCursorChar(EmptyMouseCursorChar);
        end;
      until not MouseEvent(Event, evMouseMove);
      SetDefMouseCursorChar(EmptyMouseCursorChar);
      if O then PutEvent(E);
    end;
  end;
end;

procedure TCmdrSetup.HandleEvent(var Event: TEvent);
begin
  TApplication.HandleEvent(Event);
end;

procedure PrintTitle;
begin
  if not TitlePrinted then
  begin
    TitlePrinted := True;
    PrintStr(TitleStr + ' Setup' + VersionStr + chCR + chLF + CopyrightStr + chCR + chLF + chCR + chLF);
  end;
end;

begin
  MainProgram := False;
  if Test8086 = 0 then
  begin
    PrintTitle;
    PrintStr('This program requires an 80286 CPU or above' + chCR + chLF);
  end
  else
  begin
    FatalError := '';
    DefScreenCol := apAuto;
    CheckResident;
    VESASupport := True;
    if ParamCount > 0 then
    begin
      CurPath := PString(Ptr(PrefixSeg, $0080))^;
      while (CurPath <> '') and (CurPath[Length(CurPath)] in WhiteSpace) do Dec(CurPath[0]);
      repeat
        while (CurPath <> '') and (CurPath[1] in WhiteSpace) do CurPath := Copy(CurPath, 2, MaxStrLen);
        if (CurPath <> '') and (CurPath[1] in ['-', '/']) then
        begin
          NumOK := 2;
          while (NumOK <= Length(CurPath)) and not (CurPath[NumOK] in WhiteSpace) do Inc(NumOK);
          HomePath := Copy(CurPath, 1, NumOK - 1);
          ListPath := UpperCase(Copy(HomePath, 2, 255));
          CurPath := Copy(CurPath, NumOK + 1, MaxStrLen);
          if ListPath = 'NOVESA' then VESASupport := False else
            if ListPath = 'NOLPT' then CopyDisableLPTPorts := True else
            if ListPath = 'NOXMS' then DisableXMSUsage := True else
            if ListPath = 'NOEMS' then DisableEMSUsage := True else
            if ListPath = 'NOWINCLIP' then DisableWinClipboard := True else
            if ListPath = 'COLOR' then DefScreenCol := apColor else
            if ListPath = 'BW' then DefScreenCol := apBlackWhite else
            if ListPath = 'LAPTOP' then DefScreenCol := apLaptop else
          begin
            TextScreen(nil);
            PrintTitle;
            if ListPath <> '?' then PrintStr('Invalid option: "' + HomePath + '"' + chCR + chLF + chCR + chLF);
            PrintStr('Usage:   SCMAIN [-|/<options...>]' + chCR + chLF + chCR + chLF +
              'Options: ?          - help screen' + chCR + chLF +
              '         nolpt      - disable parallel port access' + chCR + chLF);
            PrintStr('         novesa     - disable VESA BIOS support' + chCR + chLF +
              '         noxms      - disable XMS usage' + chCR + chLF +
              '         noems      - disable EMS usage' + chCR + chLF +
              '         nowinclip  - disable Windows clipboard' + chCR + chLF);
            PrintStr('         color      - force color palette' + chCR + chLF +
              '         bw         - force black & white palette' + chCR + chLF +
              '         laptop     - force laptop palette' + chCR + chLF);
            Exit;
          end;
        end;
      until (CurPath = '') or not (CurPath[1] in ['-', '/']);
    end;
    TextScreen(nil);
    PrintTitle;
    if DOSVersion < $0314 then
    begin
      PrintStr('This program requires DOS version 3.20 or later' + chCR + chLF);
    end
    else
    begin
      if MemAvail < 36000 then
      begin
        PrintStr('There is not enough memory to execute the Commander Setup' + chCR + chLF);
      end
      else
      begin
        LoadConfig;
        if DefScreenCol <> apAuto then ScreenCol := DefScreenCol;
        CmdrSetup.Init;
        CmdrSetup.Run;
        CmdrSetup.Done;
        OpenCBMDriverClose;
        OpenCBMVDDUninit;
        if not Resident then DoneClipboard;
      end;
    end;
  end;
end.
