
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    SCVIEW.PAS                   }
{                                                 }
{            The Star Commander Viewer            }
{*************************************************}

program The_Star_Commander_Viewer;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 0, 655360}

uses
  App, DOS, Dialogs, Drivers, Menus, Objects, Views,
  Base1, Base2, Clipbrd, Common, Config, Constant, ExtFiles, Help, LowLevel;

const
{Commands}
  cmVWrapMode   = 102;
  cmVSelectFile = 103;
  cmVHexaMode   = 104;
  cmVGoto       = 105;
  cmVEOLMode    = 106;
  cmVSearch     = 107;
  cmVViewMode   = 108;
  cmVTabMode    = 109;
  cmVLoadAddr   = 114;
  cmVSetLineLen = 115;
  cmVSetUserEOL = 116;
  cmVContSearch = 117;
  cmVShowSymbol = 119;
  cmVLoadFile   = 140;
  cmVRawView    = 141;
{Commodore colors}
  ccBlack       = 0;
  ccWhite       = 1;
  ccRed         = 2;
  ccCyan        = 3;
  ccPurple      = 4;
  ccGreen       = 5;
  ccBlue        = 6;
  ccYellow      = 7;
  ccOrange      = 8;
  ccBrown       = 9;
  ccPink        = 10;
  ccDarkGrey    = 11;
  ccGrey        = 12;
  ccLightGreen  = 13;
  ccLightBlue   = 14;
  ccLightGrey   = 15;
{PC colors}
  pcBlack       = 0;
  pcBlue        = 1;
  pcGreen       = 2;
  pcCyan        = 3;
  pcRed         = 4;
  pcMagenta     = 5;
  pcBrown       = 6;
  pcWhite       = 7;
  pcGrey        = 8;
  pcBrightBlue  = 9;
  pcBrightGreen = 10;
  pcBrightCyan  = 11;
  pcBrightRed   = 12;
  pcBrightMagenta= 13;
  pcYellow      = 14;
  pcBrightWhite = 15;
{Help contexts}
  hcVSelectFile = 126;
{Warning messages}
  wmCorrupted   = 1;
{Amount of memory needed to allocate the buffers}
  MemNeeded     = 37000;
{Commodore to PC (EGA) color conversion}
  CBMtoPCColor  : array [0..ColorNum - 1] of Byte =
    (pcBlack, pcBrightWhite, pcRed, pcBrightCyan, pcMagenta, pcGreen, pcBlue, pcYellow,
     pcBrightRed, pcBrown, pcBrightMagenta, pcGrey, pcCyan, pcBrightGreen, pcBrightBlue, pcWhite);
{PETSCII control codes for colors}
  PETSCIIColor  : array [0..ColorNum - 1] of Byte =
    ($90, $05, $1C, $9F, $9C, $1E, $1F, $9E, $81, $95, $96, $97, $98, $99, $9A, $9B);
{Commodore color 6-bit RGB values, in the order of PC (EGA) colors:
     BLK, BLU, GRN, LGR, RED, PUR, BRN, GRY, DGR, LBL, LGN, CYN, ORG, PNK, YEL, WHT}
  CBMColRGBVal  : array [0..ColorNum - 1] of Byte =
    ($00, $21, $2A, $18, $20, $15, $30, $07, $38, $31, $17, $23, $14, $1C, $0E, $3F);

type
  TCmdrViewer   = object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure SetCharSet(Mode: Byte; On, Force: Boolean); virtual;
    procedure InitKeyBar; virtual;
    procedure Idle; virtual;
    procedure GetEvent(var Event: TEvent); virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
  end;
  TScreen       = object(TView)
    constructor Init(Bounds: TRect);
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Draw; virtual;
  end;
  PScreen       = ^TScreen;

var
  OutOfMemory,
  FirstSelect,
  FileOpen,
  FileEnd,
  FileOK,
  ImageOn,
  ShowLoadAddr,
  ShowSymbols,
  ReverseMode,
  WrapMode,
  TabMode,
  DirMode,
  CustomPalette,
  SkippingTab,
  SearchInHex,
  SelInRow,
  StrFound,
  EOLFound      : Boolean;
  PanelNewMode,
  EOLMode,
  OrigViewMode,
  TabCount,
  NormAttr,
  SelAttr,
  ArrowAttr,
  DrawAttr,
  VCharSetMode,
  CopyCharSetMode: Byte;
  EOLChar,
  EOLChar2      : Char;
  LoadAddr,
  ConvTable,
  DrawCount,
  Column,
  FixLineLen,
  WrapLen,
  ScrWidth,
  BufferSize,
  SearchSize,
  SearchStartOfs,
  SearchEndOfs,
  NewStartOfs,
  StartOfs,
  EndOfs,
  SelStartOfs,
  SelEndOfs,
  SelStartCol,
  SelEndCol     : Word;
  PanelMax,
  PanelCur,
  PanLen,
  DeltaY        : Integer;
  PrevSize,
  ReadSize,
  ReadOffset,
  ReadStart,
  ReadEnd,
  SearchStart,
  SearchEnd,
  SelectStart,
  SelectEnd,
  WinStart,
  WinEnd,
  NewReadStart,
  NewReadEnd,
  NewWinStart   : Longint;
  WrapStatus,
  HexaStatus,
  TabStatus,
  LoadAddrStatus,
  SymbolStatus  : PStatusItem;
  Title         : PTitle;
  Screen        : PScreen;
  ViewBuffer,
  SearchBuffer  : PSmallBuf;
  TitleName     : string[40];
  SearchStr,
  SearchText,
  SearchHex,
  NextSameChar,
  ImageExt      : string;
  CmdrViewer    : TCmdrViewer;
  Entry         : TDirEntry;
  DrawBuf       : TDrawBuffer;
  Locations     : PLocBuffer;

procedure MakeTitle;
var
  B             : Byte;
  P,
  S             : string;
begin
  Title^.Name[0] := Chr(ScreenWidth - 43);
  Title^.Text^[0] := #43;
  FillChar(Title^.Name[1], ScreenWidth - 43, ' ');
  P := BoxTitle + ': ';
  if DirMode then S := ImageDir else S := FullName;
  P := P + LimitNameLen(S, ScreenWidth - 46 - Length(P));
  Move(P[1], Title^.Name[1], Length(P));
  if DirMode then
  begin
    FillChar(Title^.Text^[1], 43, ' ');
  end
  else
  begin
    P := SepStr(ReadSize) + ' Byte';
    B := Length(P);
    if ReadSize <> 1 then P := P + 's';
    Move(P[1], Title^.Text^[33 - B], Length(P));
  end;
  Title^.DrawView;
end;

procedure ReadFilePart(Start, Size: Longint);
var
  B,
  C,
  D,
  E             : Word;
  F             : PExtFile;
begin
  InOutRes := 0;
  FillChar(SearchBuffer^, Size, 0);
  case PanelMode of
    pmDOS, pmTape, pmFile, pmLynx..pmTAR:
    begin
      if PanelMode = pmDOS then F := @ReadFile else F := @Image;
      ExtSeek(F^, Start + ReadOffset);
      ExtBlockRead(F^, SearchBuffer^, Size);
      if PanelMode = pmTape then
      begin
        case Start of
          0: Move(LoadAddr, SearchBuffer^, 2);
          1: SearchBuffer^[0] := Hi(LoadAddr);
        end;
      end;
    end;
    pmDisk:
    begin
      CurLoc := Start div 254;
      E := Start mod 254;
      C := 0;
      B := Size;
      Track := Locations^[CurLoc].Track;
      Sector:= Locations^[CurLoc].Sector;
      while (B > 0) and (Track > 0) do
      begin
        ReadDiskBlock(Track, Sector, @DataBuffer);
        if B > 254 then D := 254 else D := B;
        if D + E > 254 then D := 254 - E;
        Move(DataBuffer[E + 2], SearchBuffer^[C], D);
        Inc(C, D);
        Dec(B, D);
        E := 0;
        Track := DataBuffer[0];
        Sector := DataBuffer[1];
      end;
    end;
  end;
  if (IOResult <> 0) and (WarningStatus and wmCorrupted = 0) then
  begin
    WarningStatus := WarningStatus or wmCorrupted;
    ErrorWin(stEmpty, 'The file ' + FullName, 'is corrupted.', CurHelpCtx, sbNone);
  end;
end;

function ReadWin: Boolean;
begin
  NewReadEnd := NewReadStart + TSmallBufSize;
  if NewReadEnd > ReadSize then NewReadEnd := ReadSize;
  BufferSize := NewReadEnd - NewReadStart;
  ReadFilePart(NewReadStart, BufferSize);
  Move(SearchBuffer^, ViewBuffer^, BufferSize);
  ReadWin := (IOResult = 0);
end;

procedure LoadOffsets;
begin
  NewReadStart := ReadStart;
  NewReadEnd := ReadEnd;
  NewWinStart := WinStart;
  NewStartOfs := StartOfs;
end;

procedure SaveOffsets;
begin
  ReadStart := NewReadStart;
  ReadEnd := NewReadEnd;
  WinStart := NewWinStart;
  StartOfs := NewStartOfs;
end;

function FindEOL(Fore, Save, Check, SkipEOL, SkipWrap: Boolean): Boolean; forward;

procedure SeekWin(Check, Find: Boolean);
var
  O             : Boolean;
  B             : Byte;
  F,
  W             : Word;
  L             : Longint;
begin
  L := 0;
  if Check then
  begin
    if HexaMode then
    begin
      L := WinSize shl 4;
    end
    else
    begin
      W := NewStartOfs;
      O := False;
      for B := 1 to WinSize - 1 do O := O or FindEOL(True, False, False, True, True);
      if (NewReadEnd >= 0) and (NewReadEnd < ReadSize) then O := O or FindEOL(True, False, False, True, True);
      if O then
      begin
        if (NewReadEnd >= 0) and (NewReadEnd < ReadSize) then
        begin
          L := TSmallBufSize;
        end
        else
        begin
          NewStartOfs := EndOfs;
          FindEOL(False, False, False, False, True);
          for B := 1 to WinSize - 1 do FindEOL(False, False, False, True, True);
          W := NewStartOfs;
          NewWinStart := NewStartOfs + NewReadStart;
        end;
      end;
      NewStartOfs := W;
    end;
  end;
  if (NewWinStart >= 0) and (NewWinStart < NewReadStart) then
  begin
    if Find then L := NewStartOfs + NewReadStart;
    if NewWinStart > TSmallBufSize shr 1 then NewReadStart := NewWinStart - TSmallBufSize shr 1 else NewReadStart := 0;
    ReadWin;
    if Find then
    begin
      NewStartOfs := L - NewReadStart;
      if not HexaMode then FindEOL(False, True, True, True, True);
    end
    else
    begin
      NewStartOfs := NewWinStart - NewReadStart;
    end;
    L := 0;
  end;
  if ((NewWinStart + L < 0) or (NewWinStart + L >= NewReadEnd)) and (NewReadEnd < ReadSize) then
  begin
    if (NewWinStart + TSmallBufSize shr 1 >= 0) and (NewWinStart + TSmallBufSize shr 1 < ReadSize) then
    begin
      if NewWinStart < TSmallBufSize shr 1 then NewReadStart := 0 else NewReadStart := NewWinStart - TSmallBufSize shr 1;
    end
    else
    begin
      if ReadSize > TSmallBufSize then NewReadStart := ReadSize - TSmallBufSize else NewReadStart := 0;
    end;
    ReadWin;
    NewStartOfs := NewWinStart - NewReadStart;
  end;
  SaveOffsets;
end;

function FindEOL(Fore, Save, Check, SkipEOL, SkipWrap: Boolean): Boolean;
var
  B             : Boolean;
  W             : Longint;
begin
  W := NewWinStart;
  asm
    mov B, False;
    mov di, NewStartOfs;
    les bx, ViewBuffer;
    mov cx, WrapLen;
    xor dx, dx;
    mov EOLFound, dl;
    mov SkippingTab, False;
    mov TabCount, 1;
    cmp Fore, False;
    je @1;
    mov ah, EOLChar;
@2: cmp di, EndOfs;
    jae @10;
    mov al, es:[di][bx];
    inc di;
    cmp ViewMode, vmPETANSI;
    jne @22;
    push ax;
    and al, $7F;
    cmp al, $20;
    pop ax;
    jae @22;
    cmp al, chReturn;
    je @6;
    cmp al, chShiftReturn;
    je @6;
    jmp @2;
@22:cmp al, ah;
    jne @21;
    cmp EOLMode, elFixLen;
    jne @6;
@21:cmp al, chTab;
    jne @16;
    cmp TabMode, False;
    je @16;
    cmp ViewMode, vmScreen;
    je @16;
    push ax;
    push dx;
    mov ax, dx;
    xor dx, dx;
    div TabSize;
    mov ax, dx;
    sub ax, TabSize;
    neg ax;
    mov TabCount, al;
    pop dx;
    pop ax;
    jmp @7;
@16:mov TabCount, 1;
@7: inc dx;
    dec cx;
    je @15;
    dec TabCount;
    jne @7;
    jmp @2;
@15:cmp di, EndOfs;
    jae @10;
    mov al, es:[di][bx];
    cmp ViewMode, vmPETANSI;
    jne @23;
    push ax;
    and al, $7F;
    cmp al, $20;
    pop ax;
    jae @23;
    cmp al, chReturn;
    je @14;
    cmp al, chShiftReturn;
    je @14;
    jmp @3;
@23:cmp al, ah;
    jne @3;
    cmp EOLMode, elFixLen;
    je @3;
    cmp EOLMode, elCRLF;
    jne @14;
    cmp byte ptr es:[di][bx][1], chLF;
    jne @3;
    inc di;
@14:inc di;
    inc EOLFound;
    jmp @3;
@6: inc EOLFound;
    cmp EOLMode, elCRLF;
    jne @3;
    dec EOLFound;
    cmp byte ptr es:[di][bx], chLF;
    jne @16;
    inc di;
    inc EOLFound;
    jmp @3;
@1: mov ah, EOLChar2;
    or di, di;
    je @12;
    mov al, es:[di][bx][-1];
    cmp ViewMode, vmPETANSI;
    jne @24;
    push ax;
    and al, $7F;
    cmp al, $20;
    pop ax;
    jae @24;
    cmp al, chReturn;
    je @11;
    cmp al, chShiftReturn;
    je @11;
    jmp @4;
@24:cmp al, ah;
    jne @4;
    cmp EOLMode, elFixLen;
    je @4;
    cmp EOLMode, elCRLF;
    jne @11;
    cmp di, 2;
    jb @4;
    cmp byte ptr es:[di][bx][-2], chCR;
    jne @4;
    dec di;
@11:dec di;
    inc EOLFound;
    cmp SkipEOL, False;
    je @13;
@4: or di, di;
    je @12;
    dec di;
    mov al, es:[di][bx];
    cmp ViewMode, vmPETANSI;
    jne @25;
    push ax;
    and al, $7F;
    cmp al, $20;
    pop ax;
    jae @25;
    cmp al, chReturn;
    je @8;
    cmp al, chShiftReturn;
    je @8;
    jmp @4;
@25:cmp al, ah;
    jne @20;
    cmp EOLMode, elFixLen;
    jne @8;
@20:cmp al, chTab;
    jne @9;
    cmp TabMode, False;
    je @9;
    cmp ViewMode, vmScreen;
    je @9;
    push dx;
    xchg ax, cx;
    xor dx, dx;
    div TabSize;
    mul TabSize;
    xchg ax, cx;
    pop dx;
    je @17;
@19:mov TabCount, 8;
    mov SkippingTab, True;
@9: inc dx;
    dec TabCount;
    dec cx;
    je @17;
    cmp TabCount, 0;
    jne @4;
    inc TabCount;
    cmp SkippingTab, False;
    je @4;
    mov SkippingTab, False;
    push dx;
    xchg ax, cx;
    xor dx, dx;
    div TabSize;
    mul TabSize;
    xchg ax, cx;
    pop dx;
    je @17;
    jmp @4;
@17:cmp TabCount, 1;
    jb @18;
    inc di;
@18:cmp SkipWrap, False;
    je @13;
    cmp ViewMode, vmPETANSI;
    jne @3;
    cmp EOLMode, elFixLen;
    jne @3;
    dec di;
@27:or di, di;
    je @28;
    mov al, es:[di][bx][-1];
    push ax;
    and al, $7F;
    cmp al, $20;
    pop ax;
    jae @28;
    cmp al, chReturn;
    je @28;
    cmp al, chShiftReturn;
    je @28;
    dec di;
    jmp @27;
@28:inc di;
    jmp @3;
@8: inc di;
    inc EOLFound;
    cmp EOLMode, elCRLF;
    jne @3;
    dec EOLFound;
    dec di;
    or di, di;
    je @12;
    cmp byte ptr es:[di][bx][-1], chCR;
    jne @9;
    inc di;
    inc EOLFound;
    jmp @3;
@10:cmp Save, False;
    je @5;
    mov ax, word ptr NewReadEnd[0];
    mov dx, word ptr NewReadEnd[2];
    cmp ax, word ptr ReadSize[0];
    jne @5;
    cmp dx, word ptr ReadSize[2];
    jne @5;
    jmp @3;
@12:mov ax, word ptr NewReadStart[0];
    or ax, word ptr NewReadStart[2];
    je @3;
@5: inc B;
@3: mov NewStartOfs, di;
@13:
  end;
  if Save then
  begin
    if B then
    begin
      if Fore then
      begin
        NewWinStart := NewReadStart + TSmallBufSize;
        SeekWin(True, False);
      end
      else
      begin
        NewStartOfs := W - NewReadStart;
        NewWinStart := NewReadStart - 1;
        SeekWin(True, True);
      end;
    end
    else
    begin
      NewWinStart := NewReadStart + NewStartOfs;
      SeekWin(Check, False);
    end;
    SaveOffsets;
  end;
  FindEOL := B;
end;

procedure SetWrapMode(On, Find: Boolean);
begin
  WrapMode := On;
  if WrapMode then
  begin
    WrapLen := ScreenWidth;
    WrapStatus^.Text^ := 'Unwrap';
  end
  else
  begin
    WrapLen := MaxWrapLen;
    WrapStatus^.Text^ := 'Wrap  ';
  end;
  if EOLMode = elFixLen then WrapLen := FixLineLen;
  if Find and not HexaMode then FindEOL(False, True, True, False, False);
  Screen^.DrawView;
  KeyBar^.DrawView;
end;

procedure SetEOLMode(Mode: Byte; Find: Boolean);
var
  C             : Word;
  M             : PHistory;
  A,
  P             : PHistoryItem;
  R             : TRect;
begin
  if Mode = MaxByte then
  begin
    ChangeHelpCtx(hcOnlyQuit);
    P := NewHistoryItem('F1', 'CR/LF', elCRLF + 1, True, nil);
    A := P;
    P := NewHistoryItem('F2', 'CR', elCR + 1, True, P);
    P := NewHistoryItem('F3', 'LF', elLF + 1, True, P);
    P := NewHistoryItem('F4', 'User: $' + HexaStr(Ord(EOLChars[3]), 2), elUser + 1, True, P);
    P := NewHistoryItem('F5', 'Fixed length: ' + LeadingSpace(FixLineLen, 0), elFixLen + 1, True, P);
    P := NewHistoryItem('F6', '--- Next ---', elNext + 1, True, P);
    R.Assign(4, 2, 15, 8);
    M := New(PHistory, Init(R, A, EOLMode, True));
    MakeWinBounds(R, 23, 6);
    PriorityMenu := New(PDialog, Init(R, 'Select line feed', fxNormal, fyNormal, False));
    PriorityMenu^.Insert(M);
    PriorityMenu^.Palette := wpHistory;
    C := Application^.ExecView(PriorityMenu, True, True);
    Dispose(PriorityMenu, Done);
    PriorityMenu := nil;
    Dec(HistoryItem);
    RestoreHelpCtx;
  end
  else
  begin
    HistoryItem := Mode;
    C := cmOK;
  end;
  if C = cmOK then
  begin
    if HistoryItem = elNext then EOLMode := (EOLMode + 1) and 3 else EOLMode := HistoryItem;
    EOLChar := EOLChars[EOLMode];
    if EOLMode = elCRLF then EOLChar2 := chLF else EOLChar2 := EOLChar;
    SetWrapMode(WrapMode, False);
    if Find and not HexaMode then FindEOL(False, True, True, False, False);
    Screen^.DrawView;
    KeyBar^.DrawView;
  end;
end;

procedure SetViewMode(Mode: Byte);
var
  C             : Word;
  M             : PHistory;
  A,
  P             : PHistoryItem;
  R             : TRect;
begin
  if Mode = MaxByte then
  begin
    ChangeHelpCtx(hcOnlyQuit);
    C := 4;
    P := NewHistoryItem('F1', 'ASCII', vmASCII + 1, True, nil);
    A := P;
    P := NewHistoryItem('F2', 'PETSCII', vmPETSCII + 1, True, P);
    P := NewHistoryItem('F3', 'Screen code', vmScreen + 1, True, P);
    if AppPalette = apColor then
    begin
      Inc(C);
      P := NewHistoryItem('F4', 'PETANSI', vmPETANSI + 1, True, P);
    end;
    P := NewHistoryItem('F8', '--- Next ---', vmNext + 1, True, P);
    R.Assign(4, 2, 13, C + 2);
    M := New(PHistory, Init(R, A, ViewMode, True));
    MakeWinBounds(R, 20, C);
    PriorityMenu := New(PDialog, Init(R, 'Select view mode', fxNormal, fyNormal, False));
    PriorityMenu^.Insert(M);
    PriorityMenu^.Palette := wpHistory;
    C := Application^.ExecView(PriorityMenu, True, True);
    Dispose(PriorityMenu, Done);
    PriorityMenu := nil;
    Dec(HistoryItem);
    RestoreHelpCtx;
  end
  else
  begin
    HistoryItem := Mode;
    C := cmOK;
  end;
  if C = cmOK then
  begin
    if HistoryItem = vmNext then ViewMode := (ViewMode + 1) mod 4 else ViewMode := HistoryItem;
    CharStartMode := VCharSetMode;
    if ViewMode = vmASCII then CharStartMode := CharSetMode and csLowerUpper;
    Application^.SetCharSet(CharStartMode, True, False);
    MakeTitle;
    Screen^.DrawView;
    KeyBar^.DrawView;
  end;
end;

procedure SetLoadAddressMode;
begin
  if ShowLoadAddr then LoadAddrStatus^.Text^ := 'AdrOff' else LoadAddrStatus^.Text^ := 'AdrOn ';
end;

procedure SetSymbolMode;
begin
  if ShowSymbols then SymbolStatus^.Text^ := 'SymOff' else SymbolStatus^.Text^ := 'SymOn ';
end;

procedure OpenFile;
var
  F             : Boolean;
  I,
  X,
  Y,
  Z             : Integer;
  D             : PDialog;
  E,
  S,
  T             : string;
begin
  SysErrorOccurred := False;
  WarningStatus := wmNone;
  PanelNewMode := PanelMode;
  if (PanelMode = pmDisk) and (OpenImage(False) = 0) then ExtClose(Image);
  MakeFullName;
  D := InfoWin(stEmpty, 'Reading the file', FullName, stEmpty, 2);
  if not OutOfMemory then
  begin
    case PanelMode of
      pmDOS:
      begin
        I := LongOpenFile(FullName, ReadFile, fmReadOnly);
        if I = 2 then
        begin
          T := GetPath(FullName, chDirSep);
          E := CutPath(FullName, chDirSep);
          S := CorrectDOSName(E, False);
          if UpperCase(E) <> UpperCase(S) then
          begin
            S := AddToPath(T, S, chDirSep);
            I := LongOpenFile(S, ReadFile, fmReadOnly);
            if I = 0 then
            begin
              ImageName := S;
              FullName := ImageName;
            end;
          end;
        end;
        if I = 0 then
        begin
          ReadOffset := 0;
          ReadSize := ExtFileSize(ReadFile);
          if ImageOn then
          begin
            E := LowerCase(Copy(ImageExt, 2, 3));
            if IsDiskExt(E) and (GetDiskType(ReadSize) <> dtInvalid) then PanelNewMode := pmDisk else
              if (E = 't64') and (ReadSize > 95) then PanelNewMode := pmTape else if (E = 'lnx') and (ReadSize >= 254)
              then PanelNewMode := pmLynx else if (E = 'ark') and (ReadSize >= 254) then PanelNewMode := pmArkive else
              if (E = 'tar') and (ReadSize >= 512) then PanelNewMode := pmTAR else
              if (E[1] in ['p', 'r', 's', 'u']) and (E[2] in ['0'..'9']) and (E[3] in ['0'..'9']) and (ReadSize > 25) then
              PanelNewMode := pmFile;
            if PanelNewMode <> pmDOS then
            begin
              PanelMode := PanelNewMode;
              if OpenImage(False) = 0 then
              begin
                ImageOn := False;
                while not ImageOn and (ReadCBMEntry(Entry)) do ImageOn := (Entry.Attr > 0);
                ExtClose(Image);
              end;
              if not ImageOn then PanelNewMode := pmDOS;
              PanelMode := pmDOS;
            end;
          end;
        end;
      end;
      pmDisk, pmTape, pmLynx, pmArkive, pmTAR:
      begin
        I := OpenImage(False);
        if I = 0 then
        begin
          F := False;
          while not F and not Escape and ReadCBMEntry(Entry) do
            F := ((ReadDirPos < MaxWord) and (DirPos = ReadDirPos)) or ((Entry.Attr > 0) and (Entry.Name = ReadName));
          F := F and (Entry.Attr > 0) and (Entry.Name = ReadName);
          if F then F := (Entry.ExtAttr and xaGEOSVLIR = 0);
          if F then
          begin
            case PanelMode of
              pmDisk:
              begin
                ReadSize := 0;
                LastLoc := 0;
                while (Track > 0) and (Track < MaxTrack) and (Sector < SectorNum(Track)) and
                  (LastLoc < MaxLocations) do
                begin
                  Locations^[LastLoc].Track := Track;
                  Locations^[LastLoc].Sector := Sector;
                  Inc(LastLoc);
                  ReadDiskBlock(Track, Sector, @DataBuffer);
                  Track := DataBuffer[0];
                  Sector := DataBuffer[1];
                  if Track > 0 then Inc(ReadSize, 254);
                end;
                if Track = 0 then
                begin
                  if Sector = 0 then Inc(Sector);
                  Inc(ReadSize, Sector - 1);
                end
                else
                begin
                  ErrorWin(stEmpty, 'The file ' + FullName, 'is corrupted.', CurHelpCtx, sbNone);
                end;
              end;
              pmTape:
              begin
                LoadAddr := Entry.Start;
                ReadOffset := ImagePos - 2;
                ReadCBMEntry(Entry);
                ReadSize := ImagePos - ReadOffset;
              end;
              pmLynx..pmTAR:
              begin
                ReadOffset := ImagePos;
                ReadSize := Entry.Size;
              end;
            end;
          end
          else
          begin
            I := 255;
          end;
        end;
      end;
      pmFile:
      begin
        I := OpenImage(False);
        if I = 0 then
        begin
          ReadOffset := 26;
          ReadSize := ExtFileSize(Image) - 26;
        end;
      end;
    end;
    if I = 0 then
    begin
      Column := 0;
      SelectStart := 0;
      SelectEnd := 0;
      if ViewBuffer = nil then ViewBuffer := New(PSmallBuf);
      if (SearchBuffer = nil) or (SearchBuffer = ViewBuffer) then
      begin
        if ReadSize >= SizeOf(TSmallBuf) then
        begin
          if MemAvail > SizeOf(TSmallBuf) then SearchBuffer := New(PSmallBuf) else OutOfMemory := True;
        end
        else
        begin
          SearchBuffer := ViewBuffer;
        end;
      end;
      if not OutOfMemory then
      begin
        FillChar(ViewBuffer^, TSmallBufSize, 0);
        ReadStart := 0;
        WinStart := 0;
        LoadOffsets;
        FileOK := ReadWin;
        if FileOK then
        begin
          SaveOffsets;
          EndOfs := ReadEnd;
          if (PanelMode <> pmTape) and (EndOfs >= SizeOf(Word)) then LoadAddr := PWord(ViewBuffer)^ - 2;
          if EndOfs > CheckDataLen then EndOfs := CheckDataLen;
          EOLMode := elCRLF;
          TabMode := True;
          asm
            xor di, di;
            mov X, di;
            mov Y, di;
            mov Z, di;
            les bx, ViewBuffer;
            mov cx, BufferSize;
            xor ah, ah;
            cld;
        @5: cmp di, EndOfs;
            jae @2;
            mov al, es:[di][bx];
            inc di;
            or al, al;
            jne @1;
            mov TabMode, False;
            jmp @4;
        @1: cmp al, chLF;
            jne @3;
            inc Z;
            jmp @4;
        @3: cmp al, chCR;
            jne @4;
            cmp di, EndOfs;
            jae @9;
            mov al, es:[di][bx];
            cmp al, chLF;
            je @6;
        @9: inc Y;
            jmp @4;
        @6: inc X;
            inc di;
        @4: loop @5;
        @2: mov al, elCRLF;
            mov bx, X;
            cmp bx, Y;
            jae @7;
            mov bx, Y;
            mov al, elCR;
        @7: cmp bx, Z;
            jae @8;
            mov al, elLF;
        @8: mov EOLMode, al;
          end;
          SetEOLMode(EOLMode, False);
          if (PanelMode <> pmDOS) and (ViewMode = vmASCII) then SetViewMode(vmPETSCII);
        end;
      end;
    end
    else
    begin
      if not SysErrorOccurred then
      begin
        MakeSound := False;
        if Entry.ExtAttr and xaGEOSVLIR = 0 then ErrorWin(stEmpty, 'Can''t open the file', FullName,
          hcOnlyQuit, sbNone) else ErrorWin(stEmpty, FullName, 'is a GEOS VLIR file.', hcOnlyQuit, sbNone);
      end;
    end;
  end;
  if OutOfMemory then
  begin
    ErrorWin(stEmpty, 'Can''t view the file', FullName, hcOnlyQuit, sbNone);
    I := 254;
  end;
  FileOpen := (I = 0);
  Dispose(D, Done);
  ErrorDown := 0;
end;

procedure CloseFile;
begin
  if FileOpen then
  begin
    FileOpen := False;
    case PanelMode of
      pmDOS: ExtClose(ReadFile);
      pmDisk..pmFile, pmLynx..pmTAR: ExtClose(Image);
    end;
  end;
end;

function GetTextOrHex(const Title, TextLabel, HexLabel: string; var DefText, DefHex, Result: string; var InHex: Boolean;
  Help: Word): Boolean;
var
  F,
  O             : Boolean;
  C,
  H             : Word;
  D             : PDialog;
  I1            : PTextInput;
  I2            : PCodeInput;
  S,
  T             : string;
  R             : TRect;
begin
  H := CurHelpCtx;
  O := HelpCtxSet;
  HelpCtxSet := True;
  CurHelpCtx := Help;
  AppHelpCtx := Help;
  LastShiftState := MaxByte;
  T := Title;
  if T = '' then T := BoxTitle;
  MakeWinBounds(R, 66, 4);
  GetMouse(True);
  D := New(PDialog, Init(R, T, fxNormal, fyNormal, True));
  R.Assign(5, 4, CBMStrLen(HexLabel), 1);
  D^.Insert(New(PStaticText, Init(R, HexLabel)));
  R.Assign(5, 5, 64, 1);
  I2 := New(PCodeInput, Init(R, 65, MaxByte));
  I2^.SetData(DefHex);
  D^.Insert(I2);
  R.Assign(5, 2, 64, 2);
  I1 := New(PTextInput, Init(R, 64, MaxByte, TextLabel, drUp));
  I1^.SetData(DefText);
  D^.Insert(I1);
  I1^.ConvertEOL := False;
  I1^.CodeInput := I2;
  I2^.TextInput := I1;
  if InHex then I2^.Select;
  C := Application^.ExecView(D, True, True);
  F := (C = cmOK);
  SetMouse;
  if F then
  begin
    InHex := I2^.GetState(sfSelected);
    I1^.GetData(DefText);
    I2^.GetData(DefHex);
    if InHex then Result := HexToText(DefHex, True) else Result := DefText;
    if Result = '' then F := False;
  end;
  Dispose(D, Done);
  GetTextOrHex := F;
  CurHelpCtx := H;
  AppHelpCtx := H;
  HelpCtxSet := O;
  LastShiftState := MaxByte;
end;

procedure InitConvTable(CharSetMode: Byte);
begin
  ConvTable := 0;
  case CharSetMode + (ViewMode shl 2) of
    csIBMLower + vmPETSCII shl 2, csIBMLower + vmPETANSI shl 2: ConvTable := Ofs(PETtoASCLower);
    csIBMUpper + vmPETSCII shl 2, csIBMUpper + vmPETANSI shl 2: ConvTable := Ofs(PETtoASCUpper);
    csCBMLower + vmPETSCII shl 2, csCBMLower + vmPETANSI shl 2: ConvTable := Ofs(PETtoExtLower);
    csCBMUpper + vmPETSCII shl 2, csCBMUpper + vmPETANSI shl 2: ConvTable := Ofs(PETtoExtUpper);
    csIBMLower + vmScreen shl 2: ConvTable := Ofs(SCRtoASCLower);
    csIBMUpper + vmScreen shl 2: ConvTable := Ofs(SCRtoASCUpper);
    csCBMLower + vmScreen shl 2: ConvTable := Ofs(SCRtoExtLower);
    csCBMUpper + vmScreen shl 2: ConvTable := Ofs(SCRtoExtUpper);
  end;
end;

procedure MakeLine; assembler;
asm
    mov si, Offset(DrawBuf);
    les bx, ViewBuffer;
    xor cx, cx;
    mov SelStartCol, cx;
    mov SelEndCol, cx;
    mov ax, WrapLen;
    mov DrawCount, ax;
    mov dl, EOLChar;
    mov dh, EOLMode;
    push bp;
    xor bp, bp;
@2: cmp di, EndOfs;
    jb @10;
@28:cmp ShowSymbols, False;
    je @29;
    cmp ViewMode, vmScreen;
    je @29;
    mov al, tsEndOfFile;
    mov ah, NormAttr;
    mov [si], ax;
@29:inc di;
    mov al, True;
    jmp @11;
@10:mov al, es:[di][bx];
    cmp di, SelStartOfs;
    jb @20;
    jne @22;
    mov SelStartCol, cx;
    add SelStartCol, bp;
@22:cmp di, SelEndOfs;
    ja @20;
    jne @23;
    mov SelEndCol, cx;
    add SelEndCol, bp;
    jmp @20;
@23:mov ah, SelAttr;
    mov SelInRow, True;
    jmp @21;
@20:mov ah, NormAttr;
@21:inc di;
    cmp al, dl;
    jne @3;
    cmp EOLMode, elFixLen;
    je @3;
    cmp dh, elCRLF;
    jne @26;
    cmp byte ptr es:[di][bx], chLF;
    jne @3;
    inc di;
    jmp @26;
@3: cmp al, ' ';
    jne @24;
    cmp ShowSymbols, False;
    je @24;
    mov al, tsSpace;
    jmp @15;
@24:cmp al, chTab;
    jne @16;
    cmp ViewMode, vmScreen;
    je @16;
    cmp ViewMode, vmPETANSI;
    je @16;
    cmp TabMode, False;
    je @30;
    push ax;
    push dx;
    mov ax, bp;
    add ax, cx;
    xor dx, dx;
    div TabSize;
    mov ax, dx;
    sub ax, TabSize;
    neg ax;
    mov TabCount, al;
    pop dx;
    pop ax;
    mov al, ' ';
    cmp ShowSymbols, False;
    je @14;
    cmp ViewMode, vmScreen;
    je @14;
    mov al, tsTab;
    jmp @14;
@30:cmp ViewMode, vmASCII;
    je @15;
    cmp ShowSymbols, False;
    jne @15;
@16:cmp ViewMode, vmASCII;
    je @15;
    push di;
    push bx;
    push cx;
    cmp ViewMode, vmPETANSI;
    jne @32;
    mov cl, al;
    and cl, $7F;
    cmp cl, $20;
    jae @32;
    cmp al, chReturn;
    je @40;
    cmp al, chShiftReturn;
    je @40;
    cmp al, chReverseOn;
    jne @34;
    mov ReverseMode, True;
    jmp @33;
@34:cmp al, chReverseOff;
    jne @35;
    mov ReverseMode, False;
    jmp @33;
@35:cmp al, chLocaseUpcase;
    jne @37;
    and CopyCharSetMode, (not csLowerUpper);
    jmp @39;
@37:cmp al, chUpcaseGraphics;
    jne @38;
    or CopyCharSetMode, csLowerUpper;
@39:push ax;
    push bx;
    push cx;
    push dx;
    push si;
    push di;
    push bp;
    push es;
    mov al, CopyCharSetMode;
    push ax;
    call InitConvTable;
    pop es;
    pop bp;
    pop di;
    pop si;
    pop dx;
    pop cx;
    pop bx;
    pop ax;
    jmp @33;
@38:push es;
    push ds;
    pop es;
    mov cx, ColorNum;
    mov di, Offset(PETSCIIColor);
    repne scasb;
    pop es;
    jne @33;
    sub cx, ColorNum;
    not cx;
    mov al, cl;
    mov bx, Offset(CBMtoPCColor);
    xlat;
    mov NormAttr, al;
    cmp CharSetMode, csIBMUpper;
    jbe @41;
    ror al, 4;
@41:mov SelAttr, al;
@33:pop cx;
    pop bx;
    pop di;
    jmp @2;
@40:pop cx;
    pop bx;
    pop di;
    jmp @26;
@32:cmp ViewMode, vmScreen;
    jne @18;
    mov bl, al;
    and al, $7F;
    cmp bl, $80;
    jb @17;
@36:cmp CharSetMode, csIBMUpper;
    jbe @17;
    jmp @19;
@18:cmp ViewMode, vmPETSCII;
    jne @31;
    mov cl, al;
    and cl, $7F;
    cmp cl, $20;
    jae @17;
    jmp @36;
@31:cmp ViewMode, vmPETANSI;
    jne @17;
    cmp ReverseMode, False;
    je @17;
    jmp @36;
@19:ror ah, 4;
@17:mov bx, ConvTable;
    xlat;
    pop cx;
    pop bx;
    pop di;
@15:mov TabCount, 1;
@14:cmp cx, Column;
    jae @7;
    inc cx;
    jmp @8;
@7: cmp bp, ScrWidth;
    jae @5;
    mov [si], ax;
    add si, 2;
@5: inc bp;
@8: dec DrawCount;
    je @13;
    cmp ShowSymbols, False;
    je @25;
    cmp ViewMode, vmScreen;
    je @25;
    mov al, ' ';
@25:dec TabCount;
    jne @14;
    jmp @2;
@13:cmp di, EndOfs;
    jb @12;
    jmp @28;
@12:mov al, es:[di][bx];
    cmp al, dl;
    jne @1;
    cmp EOLMode, elFixLen;
    je @1;
    or dh, dh;
    jne @4;
    cmp byte ptr es:[di][bx][1], chLF;
    jne @1;
    inc di;
@4: inc di;
@26:mov ReverseMode, False;
    cmp ShowSymbols, False;
    je @27;
    cmp bp, ScrWidth;
    ja @1;
    mov al, tsEndOfLine;
    mov [si], ax;
    jmp @1;
@27:mov al, ' ';
    or bp, bp;
    jne @1;
    mov [si], ax;
@1: mov al, False;
@11:mov bx, bp;
    pop bp;
    or FileEnd, al;
    mov ah, ArrowAttr;
    cmp bx, ScrWidth;
    jbe @6;
    mov al, byte ptr ArrowChars[2];
    mov bx, ScrWidth;
    dec bx;
    shl bx, 1;
    mov word ptr DrawBuf[bx], ax;
@6: cmp Column, 0;
    je @9;
    mov al, byte ptr ArrowChars[1];
    mov word ptr DrawBuf[0], ax;
@9:
end;

procedure SelectFile;
var
  O             : Boolean;
  A             : Byte;
  Z             : Word;
  W,
  Y             : Integer;
  S,
  T             : string;

procedure InsertEntry;
begin
  W := InsName(Entry.Name);
  if W >= 0 then
  begin
    PanelDir^[Z].Name := W;
    PanelDir^[Z].ExtAttr := Entry.ExtAttr;
    PanelDir^[Z].Attr := Entry.Attr;
    PanelDir^[Z].Time := Entry.Time;
    LongintToLonglongint(PanelDir^[Z].Size, Entry.Size);
    PanelDir^[Z].DirPos := Entry.DirPos;
    PanelDir^[Z].Status := fsNormal;
    Inc(Z);
  end;
end;

begin
  AllErrorSkip := ayNone;
  OrigViewMode := ViewMode;
  if PanelNewMode <> pmDOS then
  begin
    O := True;
    if PanelDir = nil then if MemAvail <= SizeOf(TDirBuffer) then O := False else PanelDir := New(PDirBuffer);
    if PanelNames = nil then if MemAvail <= SizeOf(TNameBuffer) then O := False else PanelNames := New(PNameBuffer);
    if O then
    begin
      CloseFile;
      ChangeHelpCtx(hcVSelectFile);
      PanelMode := PanelNewMode;
      Z := 0;
      PanelMax := 0;
      NameEnd := 0;
      DirMode := True;
      MakeFullName;
      MakeTitle;
      DeltaY := 0;
      T := MakeTypeStr(PanelMode);
      case PanelMode of
        pmDisk..pmFile: T := LowerCase(T) + ' image';
        pmLynx..pmFileZip: T := T + ' archive';
      end;
      Screen^.DrawView;
      if OpenImage(False) = 0 then
      begin
        if (PanelMode in [pmDisk, pmTAR]) and (ImagePath <> '') then
        begin
          PanelDir^[0].ExtAttr := xaDirectory;
          PanelDir^[0].Attr := (faPartition + faClosed);
          LongintToLonglongint(PanelDir^[0].Size, 0);
          PanelDir^[0].Name := InsName(stParentDir);
          Inc(Z);
        end;
        while (ReadCBMEntry(Entry)) and (Z < MaxFiles) do
        begin
          case PanelMode of
            pmTape: if Z > 0 then
              LongintToLonglongint(PanelDir^[Z - 1].Size, ImagePos - LonglongintToLongint(PanelDir^[Z - 1].Size) + 2);
            pmTAR:
            begin
              A := Entry.Attr;
              if Z > 0 then
              begin
                Y := 0;
                while (A > 0) and (Y < Z) do if GetNamePtr(Y)^ = Entry.Name then A := 0 else Inc(Y);
                Entry.Attr := A;
              end;
            end;
          end;
          if PanelMode in [pmLynx, pmArkive, pmTAR] then
          begin
            if StartInfo and (Entry.Size >= 2) then
            begin
              ExtSeek(Image, ImagePos);
              ExtBlockRead(Image, Entry.Start, 2);
            end;
          end;
          if Entry.Attr > 0 then InsertEntry;
        end;
        if PanelMode = pmTape then
          LongintToLonglongint(PanelDir^[Z - 1].Size, ImagePos - LonglongintToLongint(PanelDir^[Z - 1].Size) + 2);
        ExtClose(Image);
        PanelCur := 0;
        if ReadDirPos = MaxWord then while (PanelCur < Z) and (GetNamePtr(PanelCur)^ <> ReadName) do Inc(PanelCur) else
          while (PanelCur < Z) and (PanelDir^[PanelCur].DirPos <> ReadDirPos) do Inc(PanelCur);
        if GetNamePtr(PanelCur)^ <> ReadName then PanelCur := Z;
        if PanelCur < Z then
        begin
          if PanelCur < DeltaY then DeltaY := PanelCur;
          if PanelCur > DeltaY + PanLen - 1 then DeltaY := PanelCur - PanLen + 1;
          if DeltaY + PanLen > Z then if Z > PanLen - 1 then DeltaY := Z - PanLen else DeltaY := 0;
        end
        else
        begin
          PanelCur := 0;
          DeltaY := 0;
        end;
        ViewMode := vmPETSCII;
        CharStartMode := VCharSetMode;
        Application^.SetCharSet(CharStartMode, True, False);
        MakeTitle;
        Screen^.DrawView;
        if Z = 0 then S := 'There are no files in';
      end
      else
      begin
        S := stTheFollowing + T + stIsInvalid + stDot;
      end;
      if Z = 0 then
      begin
        MakeSound := False;
        ErrorWin(stEmpty, S, ImageName, CurHelpCtx, sbNone);
        RestoreHelpCtx;
        ViewMode := OrigViewMode;
        PanelMode := pmDOS;
        ImageOn := False;
        MenuBar^.DisableCommands([cmVSelectFile]);
        MakeFullName;
        OpenFile;
        DirMode := False;
        MakeTitle;
      end;
      PanelMax := Z;
      Screen^.DrawView;
    end
    else
    begin
      ErrorWin(stEmpty, 'Not enough memory to load directory of', ImageName, CurHelpCtx, sbNone);
    end;
  end;
end;

procedure SetHexaMode(On, Find: Boolean);
begin
  HexaMode := On;
  if On then
  begin
    if (WinStart + WinSize shl 4 > ReadSize) and (ReadSize > WinSize shl 4) then
      WinStart := ReadSize - WinSize shl 4;
    HexaStatus^.Text^ := 'Text  ';
    Column := 0;
  end
  else
  begin
    NewStartOfs := NewWinStart - ReadStart;
    if Find then FindEOL(False, True, True, False, False);
    HexaStatus^.Text^ := 'Hex   ';
  end;
  Application^.SetCharSet(CharSetMode, True, False);
  Screen^.DrawView;
  KeyBar^.DrawView;
end;

function ReadSearchWin: Byte;
var
  B             : Byte;
begin
  if Escape then
  begin
    B := 1;
  end
  else
  begin
    Inc(SearchStart, SearchSize);
    if SearchStart >= ReadSize then
    begin
      B := 2;
    end
    else
    begin
      SearchEnd := SearchStart + TSmallBufSize;
      if SearchEnd > ReadSize then SearchEnd := ReadSize;
      SearchSize := SearchEnd - SearchStart;
      ReadFilePart(SearchStart, SearchSize);
      B := 0;
      if IOResult <> 0 then B := 1;
      if B = 0 then
      begin
        SearchStartOfs := 0;
        SearchEndOfs := SearchSize;
      end;
    end;
  end;
  ReadSearchWin := B;
end;

function ReadGotoByte: Byte; assembler;
asm
@3: cmp bp, SearchEndOfs;
    jb @1;
    push es;
    push bp;
    push si;
    push di;
    push bx;
    push cx;
    push dx;
    call ReadSearchWin;
    pop dx;
    pop cx;
    pop bx;
    pop di;
    pop si;
    pop bp;
    pop es;
    mov ah, al;
    or ah, ah;
    jne @2;
    mov bp, SearchStartOfs;
    jmp @3;
@1: mov al, es:[si][bp];
    xor ah, ah;
@2: or ah, ah;
end;

procedure _Goto;
var
  O             : Boolean;
  B             : Byte;
  C             : Word;
  I             : Integer;
  L,
  M             : Longint;
  D             : PDialog;
  I1            : PInputLine;
  S             : string;
  R             : TRect;
begin
  ChangeHelpCtx(hcHelp);
  if HexaMode then
  begin
    S := 'offset';
    if ShowLoadAddr then S := 'address';
    S := 'Goto ' + S + ': $';
  end
  else
  begin
    S := 'Goto line: ';
  end;
  MakeWinBounds(R, Length(S) + 10, 1);
  GetMouse(True);
  D := New(PDialog, Init(R, 'Goto', fxNormal, fyNormal, False));
  R.Assign(5, 2, Length(S) + 8, 1);
  if HexaMode then I1 := New(PHexInput, Init(R, 8, 8, S, drLeftClose)) else
    I1 := New(PNumInput, Init(R, 8, 8, S, drLeftClose));
  D^.Insert(I1);
  C := Application^.ExecView(D, True, True);
  O := (C = cmOK);
  SetMouse;
  if O then
  begin
    I1^.GetData(S);
    if HexaMode then L := HexaEval(S, I) else Val(S, L, I);
  end;
  Dispose(D, Done);
  if O then
  begin
    if L < 0 then L := MaxLongInt;
    LoadOffsets;
    if HexaMode then
    begin
      if ShowLoadAddr then
      begin
        Dec(L, LoadAddr);
        if L < 0 then L := 0;
      end;
      if (ReadSize >= WinSize shl 4) and (L > ReadSize - WinSize shl 4) then L := ReadSize - WinSize shl 4;
      NewWinStart := L;
      SeekWin(True, True);
    end
    else
    begin
      if L > 0 then
      begin
        Dec(L);
        SearchSize := TSmallBufSize;
        if SearchSize > ReadSize then SearchSize := ReadSize;
        SearchStart := 0;
        SearchEnd := SearchSize;
        SearchStartOfs := SearchStart;
        SearchEndOfs := SearchEnd;
        if WinStart > 0 then ReadFilePart(SearchStart, SearchSize);
        asm
          push bp;
          mov B, 0;
          les si, SearchBuffer;
          mov cx, word ptr L[0];
          mov dx, word ptr L[2];
          xor bx, bx;
          xor bp, bp;
      @6: mov ax, cx;
          or cx, dx;
          jne @1;
          xor ah, ah;
          jmp @2;
      @1: call ReadGotoByte;
          jne @2;
          inc bp;
          cmp ViewMode, vmPETANSI;
          jne @7;
          push ax;
          and al, $7F;
          cmp al, $20;
          pop ax;
          jae @7;
          cmp al, chReturn;
          je @4;
          cmp al, chShiftReturn;
          je @4;
          jmp @1;
      @7: cmp al, EOLChar;
          jne @3;
          cmp EOLMode, elFixLen;
          je @3;
          cmp EOLMode, elCRLF;
          jne @4;
          call ReadGotoByte;
          jne @2;
          inc bp;
          cmp al, chLF;
          jne @5;
      @4: sub cx, 1;
          sbb dx, 0;
          xor bx, bx;
          jmp @6;
      @5: inc bx;
      @3: inc bx;
          cmp bx, WrapLen;
          jae @4;
          jmp @1;
      @2: mov NewStartOfs, bp;
          pop bp;
          mov B, ah;
        end;
      end;
      if (B = 0) and (NewStartOfs < BufferSize) then
      begin
        Move(SearchBuffer^, ViewBuffer^, SearchSize);
        C := NewStartOfs;
        FindEOL(True, False, False, False, False);
        NewReadStart := SearchStart;
        NewReadEnd := SearchEnd;
        SelectStart := SearchStart + C;
        SelectEnd := SearchStart + NewStartOfs;
        SelStartOfs := C;
        SelEndOfs := NewStartOfs;
        if (SelectStart < WinStart) or (SelectStart >= WinEnd) then
        begin
          NewStartOfs := C;
          NewWinStart := NewReadStart + NewStartOfs;
        end;
        SeekWin(True, False);
      end;
    end;
    Screen^.DrawView;
  end;
  RestoreHelpCtx;
end;

procedure SetUserEOL(Data: Boolean);
var
  F,
  O             : Boolean;
  C             : Word;
  I             : Integer;
  L             : Longint;
  D             : PDialog;
  I1            : PHexInput;
  V             : PNumValid;
  S             : string[20];
  R             : TRect;
begin
  ChangeHelpCtx(hcHelp);
  if Data then I := 22 else I := 23;
  MakeWinBounds(R, I, 1);
  GetMouse(True);
  if Data then S := 'Feed' else S := 'Length';
  D := New(PDialog, Init(R, 'User Line ' + S, fxNormal, fyNormal, False));
  if Data then S := 'feed: $' else S := 'length: ';
  S := 'Enter line ' + S;
  R.Assign(5, 2, Length(S) + 3, 1);
  I1 := New(PHexInput, Init(R, 2, 2, S, drLeftClose));
  if Data then S := HexaStr(Ord(EOLChars[3]), 2) else S := LeadingSpace(FixLineLen, 0);
  I1^.SetData(S);
  D^.Insert(I1);
  if not Data then
  begin
    V := New(PNumValid, Init(2, ScreenWidth, stEmpty, 'line length', CurHelpCtx));
    I1^.SetValidator(V);
  end;
  ErrorDown := 5;
  C := Application^.ExecView(D, True, True);
  ErrorDown := 0;
  F := (C = cmOK);
  SetMouse;
  if F then
  begin
    I1^.GetData(S);
    if Data then L := HexaEval(S, I) else Val(S, L, I);
  end;
  Dispose(D, Done);
  if F then
  begin
    if Data then
    begin
      EOLChars[3] := Chr(L);
      SetEOLMode(elUser, True);
    end
    else
    begin
      FixLineLen := L;
      SetEOLMode(elFixLen, True);
    end;
  end;
  RestoreHelpCtx;
end;

function ReadSearchByte: Byte; assembler;
asm
@4: cmp bp, SearchEndOfs;
    jb @1;
    push es;
    push bp;
    push si;
    push di;
    push bx;
    push cx;
    push dx;
    call ReadSearchWin;
    pop dx;
    pop cx;
    pop bx;
    pop di;
    pop si;
    pop bp;
    pop es;
    mov ah, al;
    or ah, ah;
    jne @2;
    mov bp, SearchStartOfs;
    jmp @4;
@1: mov al, es:[si][bp];
    cmp SearchInHex, False;
    jne @3;
    push ax;
    call UpCaseFunc;
@3: xor ah, ah;
@2: or ah, ah;
end;

procedure Search(Cont: Boolean);
var
  O             : Boolean;
  C             : Byte;
  W             : Word;
  D             : PDialog;
  S,
  T             : string;
begin
  ChangeHelpCtx(hcHelp);
  O := True;
  if SearchInHex then SearchText := HexToText(SearchHex, False) else SearchHex := TextToHex(SearchText, False, True);
  if not Cont or (SearchStr = '') then
  begin
    SearchInHex := HexaMode;
    O := GetTextOrHex(stEmpty, 'Search for the string', 'or the byte sequence',
    SearchText, SearchHex, SearchStr, SearchInHex, CurHelpCtx);
  end
  else
  begin
    if SearchInHex then
      SearchStr := HexToText(SearchHex, True) else SearchStr := SearchText;
  end;
  if O then
  begin
    LoadOffsets;
    if SearchInHex then
    begin
      S := Copy(SearchHex, 1, Length(SearchHex) - 1);
      T := 'byte sequence';
    end
    else
    begin
      S := SearchText;
      T := 'string';
    end;
    S := '"' + S + '"';
    if not SearchInHex then
    begin
      SetupCaseConversion;
      case ViewMode of
        vmASCII: SearchStr := UpperCase(SearchStr);
        vmPETSCII, vmPETANSI: for C := 1 to Length(SearchStr) do SearchStr[C] := CBMUpCase(Chr(ASCtoPET[Ord(SearchStr[C])]));
        vmScreen: for C := 1 to Length(SearchStr) do SearchStr[C] := SCRUpCase(Chr(ASCtoSCR[Ord(SearchStr[C])]));
      end;
    end;
(* ?ASM? *)
    asm
      push bp;
      mov si, Offset(SearchStr);
      mov di, Offset(NextSameChar);
      lodsb;
      mov cl, al;
      xor ch, ch;
      mov bp, 1;
      xor bx, bx;
      mov [di], ch;
  @4: mov al, ds:[si][bp];
      cmp al, [si][bx];
      jne @1;
      inc bp;
      inc bx;
      mov ds:[di][bp], bl;
      jmp @2;
  @1: or bx, bx;
      jne @3;
      inc bp;
      mov ds:[di][bp], ch;
      jmp @2;
  @3: mov bl, [di][bx];
  @2: loop @4;
      pop bp;
    end;
    if Cont and (SelectEnd > 0) and SelInRow then NewStartOfs := SelStartOfs + 1;
    StrFound := False;
    Move(ViewBuffer^, SearchBuffer^, BufferSize);
    SearchStart := ReadStart;
    SearchEnd := ReadEnd;
    SearchSize := BufferSize;
    SearchStartOfs := NewStartOfs;
    SearchEndOfs := EndOfs;
    D := InfoWin(stEmpty, 'Searching for the ' + T, S, stEmpty, 2);
    repeat
      asm
        push bp;
        mov bp, SearchStartOfs;
        les si, SearchBuffer;
        xor bx, bx;
        mov di, Offset(SearchStr);
        mov cl, [di];
        inc di;
    @3: call ReadSearchByte;
        jne @1;
        cmp al, [di][bx];
        jne @2;
        inc bp;
        inc bx;
        cmp bl, cl;
        jb @3;
        sub bp, cx;
        mov StrFound, True;
        jmp @1;
    @2: or bx, bx;
        jne @4;
        inc bp;
        jmp @3;
    @4: mov bl, [bx][Offset(NextSameChar)];
        jmp @3;
    @1: mov SearchStartOfs, bp;
        pop bp;
        mov C, ah;
      end;
    until StrFound or (C <> 0);
    if StrFound then
    begin
      if SearchStartOfs > TSmallBufSize then
      begin
        Dec(SearchStart, TSmallBufSize shr 1);
        Inc(SearchStartOfs, TSmallBufSize shr 1);
        SearchSize := TSmallBufSize;
        if SearchStart + SearchSize > ReadSize then SearchSize := ReadSize - SearchStart;
        SearchEnd := SearchStart + SearchSize;
        ReadFilePart(SearchStart, SearchSize);
      end;
      SelStartOfs := SearchStartOfs;
      SelEndOfs := SearchStartOfs + Length(SearchStr);
      SelectStart := SearchStart + SelStartOfs;
      SelectEnd := SearchStart + SelEndOfs;
      ReadStart := SearchStart;
      ReadEnd := SearchEnd;
      BufferSize := SearchSize;
      if (SelectStart < WinStart) or (SelectStart >= WinEnd) then
      begin
        WinStart := SelectStart;
        StartOfs := SelStartOfs;
      end;
      EndOfs := SearchEndOfs;
      LoadOffsets;
      Move(SearchBuffer^, ViewBuffer^, SearchSize);
      if HexaMode then
      begin
        if (NewWinStart + WinSize shl 4 > ReadSize) and (ReadSize > WinSize shl 4) then
          NewWinStart := (ReadSize + 15) and $FFFFFFF0 - WinSize shl 4;
        SeekWin(True, False);
      end
      else
      begin
        W := NewStartOfs;
        NewStartOfs := SelStartOfs;
        FindEOL(False, False, False, False, True);
        if EOLFound then
        begin
          asm
            mov di, NewStartOfs;
            call MakeLine;
          end;
          if SelEndCol > ScreenWidth then Inc(SelEndCol);
          if SelStartCol > 0 then Dec(SelStartCol);
          if Column + ScreenWidth < SelEndCol then Column := SelEndCol - ScreenWidth;
          if Column > SelStartCol then Column := SelStartCol;
          NewStartOfs := W;
          FindEOL(False, True, True, False, True);
        end
        else
        begin
          Column := 0;
          WinStart := ReadStart + SelStartOfs;
          if (ReadSize >= TSmallBufSize) or WrapMode then SeekWin(True, False);
        end;
      end;
      Screen^.DrawView;
    end
    else
    begin
      Screen^.DrawView;
      if C = 2 then
      begin
        MakeSound := False;
        ErrorWin(stEmpty, 'Could not find the ' + T, S, CurHelpCtx, sbNone);
      end;
    end;
    Dispose(D, Done);
  end;
  RestoreHelpCtx;
end;

procedure SetTabMode(On, Find: Boolean);
begin
  TabMode := On;
  if On then TabStatus^.Text^ := 'TabOff' else TabStatus^.Text^ := 'TabOn ';
  if not HexaMode and Find then FindEOL(False, True, True, False, False);
  Screen^.DrawView;
  KeyBar^.DrawView;
end;

procedure ToggleLoadAddress;
begin
  ShowLoadAddr := not ShowLoadAddr;
  SetLoadAddressMode;
  MakeTitle;
  Screen^.DrawView;
  KeyBar^.DrawView;
end;

procedure ToggleSymbols;
begin
  ShowSymbols := not ShowSymbols;
  SetSymbolMode;
  Screen^.DrawView;
  KeyBar^.DrawView;
end;

procedure LoadFile(Raw: Boolean);
begin
  RestoreHelpCtx;
  if (PanelDir^[PanelCur].Attr and faTypeMask = faPartition) and ((PanelMode = pmTAR) or
    ((PanelMode = pmDisk) and (DiskType and dtTypeMask = dt1581) and (PanelDir^[PanelCur].ExtAttr and xaDirectory > 0))) then
  begin
    if (ImagePath <> '') and (PanelCur = 0) then
    begin
      ReadName := CutPath(ImagePath, DirSep);
      ImagePath := GetPath(ImagePath, DirSep);
      ReadDirPos := MaxWord;
    end
    else
    begin
      ImagePath := AddToPath(ImagePath, ReadName, DirSep);
      ReadName := '';
    end;
    SelectFile;
  end
  else
  begin
    AllErrorSkip := ayNone;
    if Raw then PanelMode := pmDOS;
    if FirstSelect then
    begin
      FirstSelect := False;
      if (OrigViewMode = vmASCII) and ((PanelMode <> pmDisk) or not GEOSFormat) then OrigViewMode := vmPETSCII;
    end;
    ViewMode := OrigViewMode;
    MakeFullName;
    OpenFile;
    if FileOpen then
    begin
      DirMode := False;
      MakeTitle;
      StartOfs := 0;
      CharStartMode := VCharSetMode;
      if ViewMode = vmASCII then CharStartMode := CharSetMode and csLowerUpper;
      Application^.SetCharSet(CharStartMode, True, False);
      Screen^.DrawView;
    end
    else
    begin
      SelectFile;
    end;
  end;
end;

constructor TScreen.Init(Bounds: TRect);
begin
  TView.Init(Bounds);
  SetState(sfAlwaysIns, False);
  Options := Options or ofSelectable;
  EventMask := EventMask or evBroadcast;
end;

procedure VLeft(Mouse: Boolean);
begin
  if not DirMode then
  begin
    if Mouse then SetDefMouseCursorChar(ArrowChars[1]);
    LoadOffsets;
    if HexaMode or (EOLMode = elFixLen) then
    begin
      if NewWinStart > 0 then Dec(NewWinStart);
      SeekWin(True, False);
    end
    else
    begin
      if Column > 0 then Dec(Column);
    end;
    Screen^.DrawView;
  end;
end;

procedure VRight(Mouse: Boolean);
begin
  if not DirMode then
  begin
    if Mouse then SetDefMouseCursorChar(ArrowChars[2]);
    LoadOffsets;
    if HexaMode then
    begin
      if NewWinStart + WinSize shl 4 < ReadSize then Inc(NewWinStart);
      SeekWin(True, False);
    end
    else
    begin
      if HexaMode or (EOLMode = elFixLen) then
      begin
        if NewWinStart + WinSize * FixLineLen < ReadSize then Inc(NewWinStart);
        SeekWin(True, False);
      end
      else
      begin
        if Column + ScreenWidth < MaxWrapLen then Inc(Column);
      end;
    end;
    Screen^.DrawView;
  end;
end;

procedure VCtrlLeft;
begin
  if not DirMode then
  begin
    if not HexaMode and (EOLMode <> elFixLen) then if Column > ScreenWidth shr 1 then
      Dec(Column, ScreenWidth shr 1) else Column := 0;
    Screen^.DrawView;
  end;
end;

procedure VCtrlRight;
begin
  if not DirMode then
  begin
    if not HexaMode and (EOLMode <> elFixLen) then if Column + ((ScreenWidth * 3) shr 1) < MaxWrapLen then
      Inc(Column, ScreenWidth shr 1) else Column := MaxWrapLen - ScreenWidth;
    Screen^.DrawView;
  end;
end;

procedure VUp(Mouse: Boolean);
begin
  if Mouse then SetDefMouseCursorChar(ArrowChars[4]);
  if DirMode then
  begin
    if PanelCur > 0 then
    begin
      if PanelCur = DeltaY then Dec(DeltaY);
      Dec(PanelCur);
    end;
  end
  else
  begin
    LoadOffsets;
    if HexaMode then
    begin
      if NewWinStart > 16 then Dec(NewWinStart, 16) else NewWinStart := 0;
      SeekWin(False, False);
    end
    else
    begin
      FindEOL(False, True, True, True, True);
    end;
  end;
  Screen^.DrawView;
end;

procedure VDown(Mouse: Boolean);
begin
  if Mouse then SetDefMouseCursorChar(ArrowChars[3]);
  if DirMode then
  begin
    if PanelCur < PanelMax - 1 then
    begin
      if PanelCur = DeltaY + PanLen - 1 then Inc(DeltaY);
      Inc(PanelCur);
    end;
  end
  else
  begin
    LoadOffsets;
    if HexaMode then
    begin
      if (NewWinStart + WinSize shl 4 >= 0) and (NewWinStart + WinSize shl 4 < ReadSize) then Inc(NewWinStart, 16);
      SeekWin(True, False);
    end
    else
    begin
      if not FileEnd then FindEOL(True, True, True, True, True);
    end;
  end;
  Screen^.DrawView;
end;

procedure VPgUp;
var
  B             : Byte;
begin
  if DirMode then
  begin
    if DeltaY = 0 then
    begin
      PanelCur := 0;
    end
    else
    begin
      if PanelCur < PanLen then
      begin
        DeltaY := 0;
      end
      else
      begin
        if DeltaY > PanLen - 1 then Dec(DeltaY, PanLen - 1) else DeltaY := 0;
      end;
    end;
  end
  else
  begin
    LoadOffsets;
    if HexaMode then
    begin
      if NewWinStart > WinSize shl 4 then Dec(NewWinStart, WinSize shl 4) else NewWinStart := 0;
      SeekWin(False, False);
    end
    else
    begin
      if WinStart > 0 then for B := 1 to WinSize - 1 do FindEOL(False, True, False, True, True);
      SeekWin(True, False);
    end;
  end;
  Screen^.DrawView;
end;

procedure VPgDn;
var
  B             : Byte;
begin
  if DirMode then
  begin
    if DeltaY > PanelMax - PanLen - 1 then
    begin
      PanelCur := PanelMax - 1;
    end
    else
    begin
      if PanelCur > PanelMax - PanLen then
      begin
        if PanelMax > PanLen then DeltaY := PanelMax - PanLen else DeltaY := 0;
      end
      else
      begin
        if DeltaY < PanelMax - (PanLen shl 1) + 1 then Inc(DeltaY, PanLen - 1) else
          DeltaY := PanelMax - PanLen;
      end;
    end;
  end
  else
  begin
    LoadOffsets;
    if HexaMode then
    begin
      if (NewWinStart + WinSize shl 5 >= 0) and (NewWinStart + WinSize shl 5 < ReadSize) then
        Inc(NewWinStart, WinSize shl 4) else
        if ReadSize > WinSize shl 4 then NewWinStart := (ReadSize + 15) and $FFFFFFF0 - WinSize shl 4;
      SeekWin(True, False);
    end
    else
    begin
      if not FileEnd then for B := 1 to WinSize - 1 do FindEOL(True, True, False, True, True);
      SeekWin(True, False);
    end;
  end;
  Screen^.DrawView;
end;

procedure VHome;
begin
  if DirMode then
  begin
    DeltaY := 0;
    PanelCur := 0;
  end
  else
  begin
    LoadOffsets;
    NewWinStart := 0;
    NewStartOfs := 0;
    Column := 0;
    SeekWin(False, False);
  end;
  Screen^.DrawView;
end;

procedure VEnd;
var
  B             : Byte;
begin
  if DirMode then
  begin
    if PanelMax > PanLen then DeltaY := PanelMax - PanLen else DeltaY := 0;
    PanelCur := PanelMax - 1;
  end
  else
  begin
    LoadOffsets;
    if not FileEnd then
    begin
      if HexaMode then
      begin
        if ReadSize > WinSize shl 4 then NewWinStart := (ReadSize + 15) and $FFFFFFF0 - WinSize shl 4;
        SeekWin(True, False);
      end
      else
      begin
        NewWinStart := ReadSize;
        Column := 0;
        SeekWin(True, False);
        NewStartOfs := EndOfs;
        FindEOL(False, True, True, True, True);
      end;
    end;
  end;
  Screen^.DrawView;
end;

function TScreen.GetPalette: PPalette;
const
  P: string[Length(CViewEdit)] = CViewEdit;
begin
  GetPalette := @P;
end;

procedure TScreen.HandleEvent(var Event: TEvent);
var
  O             : Boolean;
  P             : TPoint;
begin
  if Event.What and evKeyboard > 0 then
  begin
    case Event.KeyCode of
      kbLeft, kbCtrlS: VLeft(False);
      kbRight, kbCtrlD: VRight(False);
      kbCtrlLeft, kbCtrlA: VCtrlLeft;
      kbCtrlRight, kbCtrlF: VCtrlRight;
      kbUp, kbCtrlE: VUp(False);
      kbDown, kbCtrlX: VDown(False);
      kbPgUp, kbCtrlR: VPgUp;
      kbPgDn, kbCtrlC: VPgDn;
      kbHome, kbCtrlPgUp, kbCtrlHome: VHome;
      kbEnd, kbCtrlPgDn, kbCtrlEnd: VEnd;
    end;
  end;
  if Event.What and evMouse > 0 then
  begin
    if State and sfFocused = 0 then
    begin
      ClearEvent(Event);
    end
    else
    begin
      if DirMode and Event.Double and (Event.Buttons = mbLeftButton) then
      begin
        MakeLocal(Event.Where, P);
        if (P.Y >= 2) and (P.Y <= WinSize - 2) then LoadFile(False);
      end
      else
      begin
        repeat
          if MouseInView(Event.Where) then
          begin
            MakeLocal(Event.Where, P);
          end;
          if DirMode then
          begin
            if P.Y < 2 then VUp(True) else
              if P.Y > WinSize - 2 then VDown(True) else
                begin
                  PanelCur := DeltaY + P.Y - 2;
                  if PanelCur >= PanelMax - 1 then PanelCur := PanelMax - 1;
                  DrawView;
                end;
          end
          else
          begin
            if P.Y < WinCenter shr 1 + 2 then VUp(True) else
              if P.Y > WinSize - WinCenter shr 1 - 3 then VDown(True) else
              if P.X <= ScreenWidth shr 1 then VLeft(True) else
                VRight(True);
          end;
        until not MouseEvent(Event, evMouseMove + evMouseAuto);
        SetDefMouseCursorChar(EmptyMouseCursorChar);
      end;
    end;
  end;
  TView.HandleEvent(Event);
end;

procedure TScreen.Draw;
var
  O             : Boolean;
  A,
  C,
  D,
  H,
  Z             : Byte;
  V,
  W,
  X             : Word;
  I,
  J,
  Y             : Integer;
  L,
  S             : Longint;
  T             : string;

function GetName(L: Integer): string;
var
  I             : Byte;
  P             : PString;
  N             : string;
begin
  if L < PanelMax then
  begin
    FillChar(N[1], 20, ' ');
    if (L = 0) and (ImagePath <> '') then
    begin
      N := stParentDir;
    end
    else
    begin
      if PanelMode = pmTAR then
      begin
        P := GetNamePtr(L);
        if Length(P^) <= CBMNameLen then N := P^ else N := Copy(P^, 1, CBMNameLen) + ArrowChars[2];
        N := '"' + N;
        I := Length(N) + 1;
      end
      else
      begin
        N := '"' + MakeCBMName(GetNamePtr(L)^, GEOSFormat);
        I := LeftPos(chShiftSpace, N);
        if I = 0 then I := Length(N) + 1;
      end;
      N[I] := '"';
    end;
    N[0] := #20;
  end
  else
  begin
    N := '';
  end;
  GetName := N;
end;

procedure CreateName;
var
  N             : TFileExtStr;
begin
  if Y < PanelMax then
  begin
    S := LonglongintToLongint(PanelDir^[Y].Size);
    if PanelMode in [pmTape, pmFile, pmLynx..pmTAR] then S := ByteToBlock(S);
    MoveStr(DrawBuf[W - 17 - Byte(StartInfo) shl 1], LeadingSpace(S, 6), Z);
    MoveCBMStr(@DrawBuf[W - 9 - Byte(StartInfo) * 3], GetName(Y), Z, False);
    A := PanelDir^[Y].Attr;
    if A and faClosed > 0 then T := stSpace else T := stAsterisk;
    H := PanelDir^[Y].ExtAttr and xaTypeMask;
    if H = 0 then
    begin
      N := ShortCBMExt[A and faTypeMask];
      if A and faTypeMask = faPartition then
      begin
        case PanelMode of
          pmDisk: if DiskType and dtTypeMask = dt1581 then if PanelDir^[Y].ExtAttr and xaDirectory = 0 then
            N := 'cbm' else N := 'DIR';
          pmTape: N := 'frz';
          pmTAR, pmLHA: N := 'DIR';
        end;
      end;
    end
    else
    begin
      N := ShortGEOSExt[H];
    end;
    T := T + N;
    if A and faWriteProt > 0 then T := T + '<';
    MoveStr(DrawBuf[W + 11 - Byte(StartInfo) shl 2], T, Z);
    if StartInfo then if PanelMode = pmDisk then MoveStr(DrawBuf[W + 13], LeadingZero(PanelDir^[Y].Track, 2) + ';' +
      LeadingZero(PanelDir^[Y].Sector, 2), Z) else if not (PanelMode in [pmLHA, pmFileZip])
      and (LonglongintToLongint(PanelDir^[Y].Size) >= 2) then
      MoveStr(DrawBuf[W + 13], HexaPrefix + HexaStr(PanelDir^[Y].Start, 4), Z);
  end;
end;

begin
  InitConvTable(CharSetMode);
  if (ViewMode = vmPETANSI) and not HexaMode then
  begin
    NormAttr := (pcBrightWhite or (pcBlack shl 4));
    if CharSetMode <= csIBMUpper then SelAttr := NormAttr else
      SelAttr := ((NormAttr and $0F) shl 4) or ((NormAttr shr 4) and $0F);
    ArrowAttr := GetColor(6) and $0F or (pcBlack shl 4);
    ReverseMode := False;
    CopyCharSetMode := CharSetMode;
    asm
      xor di, di;
  @1: call MakeLine;
      cmp di, StartOfs;
      jb @1;
    end;
  end
  else
  begin
    NormAttr := GetColor(1);
    SelAttr := GetColor(2);
    ArrowAttr := GetColor(6);
  end;
  if DirMode then
  begin
    W := Size.X shr 1;
    if PanelMax > 0 then
    begin
      ReadName := GetNamePtr(PanelCur)^;
      ReadDirPos := PanelDir^[PanelCur].DirPos;
    end;
    if PanelCur < DeltaY then PanelCur := DeltaY;
    if PanelCur > DeltaY + PanLen - 1 then PanelCur := DeltaY + PanLen - 1;
    V := Ord(DoubleFrameChars[5]) + NormAttr shl 8;
    MoveChar(DrawBuf, DoubleFrameChars[2], NormAttr, Size.X);
    DrawBuf[0] := Ord(DoubleFrameChars[1]) + NormAttr shl 8;
    DrawBuf[Size.X - 1] := Ord(DoubleFrameChars[4]) + NormAttr shl 8;
    WriteBuf(0, 0, Size.X, 1, DrawBuf);
    MoveChar(DrawBuf, ' ', ArrowAttr, Size.X);
    if StartInfo then MoveStr(DrawBuf[W - 20], '  Length      Name         Type  Start  ', ArrowAttr) else
      MoveStr(DrawBuf[W - 20], '    Length       Name          Type     ', ArrowAttr);
    DrawBuf[0] := V;
    DrawBuf[Size.X - 1] := V;
    WriteBuf(0, 1, Size.X, 1, DrawBuf);
    for I := 0 to Size.Y - 4 do
    begin
      Y := DeltaY + I;
      if (Y = PanelCur) and (Y < PanelMax) then Z := SelAttr else Z := NormAttr;
      MoveChar(DrawBuf, ' ', Z, Size.X);
      if Y < PanelMax then CreateName;
      DrawBuf[0] := V;
      DrawBuf[Size.X - 1] := V;
      WriteBuf(0, I + 2, Size.X, 1, DrawBuf);
    end;
    MoveChar(DrawBuf, DoubleFrameChars[2], NormAttr, Size.X);
    DrawBuf[0] := Ord(DoubleFrameChars[13]) + NormAttr shl 8;
    DrawBuf[Size.X - 1] := Ord(DoubleFrameChars[16]) + NormAttr shl 8;
    WriteBuf(0, Size.Y - 1, Size.X, 1, DrawBuf);
  end
  else
  begin
    SelInRow := False;
    L := WinStart;
    StartOfs := WinStart - ReadStart;
    EndOfs := ReadEnd - ReadStart;
    if (SelectStart >= ReadStart) and (SelectStart < ReadStart + BufferSize) then
    begin
      SelStartOfs := SelectStart - ReadStart;
      SelEndOfs := SelectEnd - ReadStart;
    end
    else
    begin
      SelStartOfs := MaxWord;
      SelEndOfs := MaxWord;
    end;
    X := StartOfs;
    FileEnd := False;
    for I := 0 to Size.Y - 1 do
    begin
      MoveChar(DrawBuf, ' ', NormAttr, Size.X);
      if X <= EndOfs then
      begin
        if HexaMode then
        begin
          if ShowLoadAddr then MoveStr(DrawBuf, HexaStr(L + LoadAddr, 8), NormAttr) else
            MoveStr(DrawBuf, HexaStr(L, 8), NormAttr);
          for J := 0 to 15 do
          begin
            if X < EndOfs then
            begin
              O := ((X >= SelStartOfs) and (X < SelEndOfs));
              SelInRow := SelInRow or O;
              if O then DrawAttr := SelAttr else DrawAttr := NormAttr;
              Z := (DrawAttr and $0F) shl 4 or (DrawAttr shr 4);
              C := ViewBuffer^[X];
              T := HexaNum[C shr 4 + 1] + HexaNum[C and $0F + 1];
              if O and (X <> SelEndOfs - 1) and (J < 15) then T := T + '  ';
              MoveStr(DrawBuf[HexIndent[J] + 11], T, DrawAttr);
              case CharSetMode + (ViewMode shl 2) of
                csIBMLower + vmASCII shl 2:
                begin
                  D := C;
                  A := DrawAttr;
                end;
                csIBMUpper + vmASCII shl 2:
                begin
                  D := C;
                  A := DrawAttr;
                end;
                csIBMLower + vmPETSCII shl 2, csIBMLower + vmPETANSI shl 2:
                begin
                  D := PETtoASCLower[C];
                  A := DrawAttr;
                end;
                csIBMUpper + vmPETSCII shl 2, csIBMUpper + vmPETANSI shl 2:
                begin
                  D := PETtoASCUpper[C];
                  A := DrawAttr;
                end;
                csCBMLower + vmPETSCII shl 2, csCBMLower + vmPETANSI shl 2:
                begin
                  D := PETtoExtLower[C];
                  if C and $7F < $20 then A := Z else A := DrawAttr;
                end;
                csCBMUpper + vmPETSCII shl 2, csCBMUpper + vmPETANSI shl 2:
                begin
                  D := PETtoExtUpper[C];
                  if C and $7F < $20 then A := Z else A := DrawAttr;
                end;
                csIBMLower + vmScreen shl 2:
                begin
                  D := SCRtoASCLower[C and $7F];
                  A := DrawAttr;
                end;
                csIBMUpper + vmScreen shl 2:
                begin
                  D := SCRtoASCUpper[C and $7F];
                  A := DrawAttr;
                end;
                csCBMLower + vmScreen shl 2:
                begin
                  D := SCRtoExtLower[C and $7F];
                  if C >= $80 then A := Z else A := DrawAttr;
                end;
                csCBMUpper + vmScreen shl 2:
                begin
                  D := SCRtoExtUpper[C and $7F];
                  if C >= $80 then A := Z else A := DrawAttr;
                end;
              end;
              MoveChar(DrawBuf[J + 63], Chr(D), A, 1);
            end
            else
            begin
              FileEnd := True;
            end;
            Inc(X);
          end;
          Inc(L, 16);
          if X >= EndOfs then FileEnd := True;
        end
        else
        begin
          asm
            mov di, X;
            call MakeLine;
            mov X, di;
          end;
        end;
      end;
      WriteBuf(0, I, Size.X, 1, DrawBuf);
    end;
    WinEnd := ReadStart + X;
    FillChar(Title^.Text^[3], 10, ' ');
    T := 'Col ' + SepStr(Column);
    Move(T[1], Title^.Text^[4], Length(T));
    L := (ReadSize + 99) div 100;
    if L = 0 then L := 100 else L := Abs(WinStart div L);
    if FileEnd or (L > 100) then L := 100;
    T := LeadingSpace(L, 3) + '%';
    Move(T[1], Title^.Text^[39], Length(T));
  end;
  Title^.DrawView;
end;

procedure ToggleCharSet(B: Byte);
begin
  if CanChangeChars and (ViewMode <> vmASCII) then
  begin
    VCharSetMode := VCharSetMode xor B;
    CharStartMode := VCharSetMode;
    Application^.SetCharSet(CharStartMode, True, False);
    LastHalfSec := MaxByte;
    RedrawAllViews;
  end;
end;

procedure ClockOffProc; far;
begin
end;

procedure ClockOnProc; far;
begin
end;

procedure GetClockProc(B: Boolean); far;
begin
end;

procedure SetClockProc; far;
begin
end;

constructor TCmdrViewer.Init;
var
  O             : Boolean;
  B             : Byte;
  D             : PDialog;
  P,
  N             : string;
  R             : TRect;
begin
  CanChangeChars := True;
  InitMouse;
  if Standard then
  begin
    MouseInit.X := ShellBuffer^.MouseX;
    MouseInit.Y := ShellBuffer^.MouseY;
    MouseInitMax.X := ShellBuffer^.MouseMaxX;
    MouseInitMax.Y := ShellBuffer^.MouseMaxY;
  end
  else
  begin
    MouseInit.X := -1;
  end;
  CommandOutput := coNormal;
  TApplication.Init;
  HelpNum := 0;
  GoSound := False;
  MakeSound := True;
  SysErrorFunc := SysErrorWin;
  EmergencyExitFunc := EmergencyExit;
  CtrlAltInsActive := True;
  Randomize;
  BoxTitle := 'View';
  AppHelpCtx := hcNormal;
  CurHelpCtx := hcNormal;
  MenuInUse := False;
  HelpInUse := False;
  HelpCtxSet := False;
  MouseRightHeld := False;
  LoadingDirs := True;
  CopyExtDisk := ExtendedDisk;
  PanelCur := 0;
  FirstSelect := True;
  ImageOn := True;
  WrapMode := True;
  HexaMode := False;
  ShowSymbols := False;
  DirMode := False;
  FixLineLen := ScreenWidth;
  ScrWidth := ScreenWidth;
  PanelDir := nil;
  ViewBuffer := nil;
  SearchBuffer := nil;
  InitSaver;
  if MemoryCfgOK then
  begin
    WrapMode := ShellBuffer^.WrapMode;
    HexaMode := ShellBuffer^.HexaMode;
    ShowLoadAddr := ShellBuffer^.ShowLoadAddr;
    ShowSymbols := ShellBuffer^.ShowSymbols;
    EOLChars[3] := Chr(ShellBuffer^.UserLineFeed);
    FixLineLen := ShellBuffer^.FixLineLen;
  end;
  ClockOn := ClockOnProc;
  ClockOff := ClockOffProc;
  GetClock := GetClockProc;
  SetClock := SetClockProc;
  InitScreen;
  InitCountry;
  InitLongNames;
  InitClipboard;
  Buffer := ScreenBuffer;
  R.Assign(0, 0, ScreenWidth, ScreenHeight);
  ChangeBounds(R);
  WinSize := R.B.Y - R.A.Y - 2;
  WinCenter := (WinSize - 6) shr 1;
  PanLen := WinSize - 3;
  Background^.DrawView;
  ImageName := LongParamStr(MaxByte);
  ImagePath := '';
  ReadName := '';
  ReadDirPos := MaxWord;
  if not Standard then Prepare;
  LongFSplit(ImageName, P, N, ImageExt);
  if Resident then
  begin
    ImagePath := ShellBuffer^.ViewImagePath;
    ReadName := ShellBuffer^.ViewFileName;
    ReadDirPos := ShellBuffer^.ViewDirPos;
  end;
  ErrorDown := 4;
  Locations := New(PLocBuffer);
  Title := New(PTitle, Init);
  R.Assign(0, 1, ScreenWidth, WinSize + 1);
  Screen := New(PScreen, Init(R));
  OpenFile;
  if FileOK then
  begin
    if PanelNewMode = pmDOS then MenuBar^.DisableCommands([cmVSelectFile]) else
      MenuBar^.EnableCommands([cmVSelectFile]);
    ErrorDown := 0;
    KeyBar^.Update;
    KeyBar^.Show;
    SetWrapMode(WrapMode, False);
    SetHexaMode(HexaMode, False);
    if (PanelMode = pmDOS) or ((PanelMode = pmDisk) and GEOSFormat) then SetViewMode(vmASCII) else SetViewMode(vmPETSCII);
    OrigViewMode := ViewMode;
    SetTabMode(TabMode, False);
    SetSymbolMode;
    SetLoadAddressMode;
    MakeTitle;
    Insert(Title);
    Insert(Screen);
    WentToCorner := False;
    LastWhere := MouseWhere;
    Title^.MakeFirst;
    Screen^.MakeFirst;
    KeyBar^.MakeFirst;
    LastHalfSec := 2;
    Screen^.DrawView;
  end;
end;

destructor TCmdrViewer.Done;
begin
  CloseFile;
  TApplication.Done;
  asm
    mov ah, 3;
    xor bh, bh;
    call VideoInt;
    mov ah, 2;
    xor bh, bh;
    xor dl, dl;
    dec dh;
    call VideoInt;
  end;
end;

procedure SetCustomPalette(On: Boolean);
begin
  if (ViewMode = vmPETANSI) and not HexaMode then
  begin
    if (On <> CustomPalette) and (AppPalette = apColor) then
    begin
      if On then
      begin
        asm
          mov cx, ColorNum;
          xor bl, bl;
          mov si, Offset(CBMColRGBVal);
          cld;
      @1: lodsb;
          mov bh, al;
          mov ax, $1000;
          call VideoInt;
          inc bl;
          loop @1;
        end;
        CustomPalette := True;
      end
      else
      begin
        SetVideoMode(ScreenMode);
        CustomPalette := False;
      end;
    end;
  end
  else
  begin
    if CustomPalette then
    begin
      SetVideoMode(ScreenMode);
      CustomPalette := False;
    end;
  end;
end;

procedure TCmdrViewer.SetCharSet(Mode: Byte; On, Force: Boolean);
var
  B             : Byte;
  S             : string[16];
begin
  GetMouse(False);
  if On and (Mode >= csCBMLower) then
  begin
    if HiResScreen then
    begin
      if ((ViewMode <> vmPETANSI) or HexaMode) and CustomPalette then
      begin
        Force := True;
        SetCustomPalette(False);
      end;
      if Force or (CharSetMode <= csIBMUpper) then
      begin
        asm
          push ds;
          push bp;
          mov ax, $0040;
          mov es, ax;
          mov dl, es:[$0085];
          cmp dl, 16;
          jne @4;
          mov bp, Offset(AltCharBuffer);
          mov ax, Seg(AltCharBuffer);
          jmp @5;
      @4: xor dh, dh;
          mov cx, dx;
          xor di, di;
      @1: mov ax, di;
          shl ax, 3;
          div dl;
          mov ss:[di][Offset(S)], al;
          inc di;
          loop @1;
          mov si, Offset(CharBuffer);
          push ds;
          pop es;
          mov ax, Seg(CharBuffer);
          mov ds, ax;
          xor ah, ah;
          mov al, dl;
          xor bh, bh;
          xor bp, bp;
          mov cx, $0100;
      @3: xor di, di;
      @2: mov bl, ss:[di][Offset(S)];
          mov dh, [si][bx];
          mov byte ptr es:GCRBuffer[di][bp], dh;
          inc di;
          cmp di, ax;
          jb @2;
          add si, 8;
          add bp, ax;
          loop @3;
          mov bp, Offset(GCRBuffer);
          mov ax, Seg(GCRBuffer);
      @5: mov es, ax;
          mov bh, dl;
          xor bl, bl;
          mov cx, $0100;
          xor dx, dx;
          mov ax, $1100;
          call VideoInt;
          pop bp;
          pop ds;
          cmp EightColFont, False;
          je @6;
          cli;
          mov dx, $03CC;
          in al, dx;
          and al, $F3;
          mov dx, $03C2;
          out dx, al;
          mov dx, $03C4;
          mov al, $01;
          out dx, al;
          inc dx;
          in al, dx;
          mov bh, al;
          or al, $01;
          out dx, al;
          mov dx, $03DA;
          in al, dx;
          mov dx, $03C0;
          mov al, $13;
          out dx, al;
          mov al, $00;
          out dx, al;
          mov al, $20;
          out dx, al;
          sti;
      @6:
        end;
        SetBlinkBright(True);
      end;
      SetCustomPalette(True);
      CharSetMode := Mode;
    end
    else
    begin
      CharStartMode := CharStartMode and csLowerUpper;
    end;
  end
  else
  begin
    B := Ord(GetPalette^[PaletteLen - 1]);
    if CharSetMode > csIBMUpper then
    begin
      if EightColFont or CustomPalette then
      begin
        SetVideoMode(ScreenMode);
        CustomPalette := False;
      end
      else
      begin
        asm
          mov ax, $0040;
          mov es, ax;
          mov dl, es:[$0085];
          mov bh, 2;
          cmp dl, 14;
          je @1;
          mov bh, 3;
          cmp dl, 8;
          je @1;
          mov bh, 6;
          cmp dl, 16;
          jne @2;
      @1: push bp;
          push dx;
          push bx;
          mov ax, $1130;
          int $10;
          pop bx;
          cmp bh, 6;
          jne @3;
          push ds;
          push es;
          pop ds;
          pop es;
          push es;
          mov si, bp;
          mov di, Offset(GCRBuffer);
          mov cx, $1000;
          cld;
          rep movsw;
          pop ds;
      @4: push ds;
          pop es;
          mov bp, Offset(GCRBuffer);
      @3: pop dx;
          mov bh, dl;
          xor bl, bl;
          mov cx, $0100;
          xor dx, dx;
          mov ax, $1100;
          call VideoInt;
          pop bp;
      @2:
        end;
        SetCustomPalette(False);
      end;
    end;
    SetBlinkBright(B > 0);
    if On then CharSetMode := Mode;
  end;
  SetMouse;
  FrameChars := DefFrameChars;
  MenuFrameChars := DefMenuFrameChars;
  if (CharSetMode >= csCBMLower) or (CodePage = CodePageUS) then
  begin
    DoubleFrameChars := DefDoubleFrameChars;
    CheckedChar := DefCheckedChar;
    DotChar := DefDotChar;
  end
  else
  begin
    DoubleFrameChars := AltDefDoubleFrameChars;
    CheckedChar := AltDefCheckedChar;
    DotChar := AltDefDotChar;
  end;
end;

procedure TCmdrViewer.InitKeyBar;
var
  P             : PStatusDef;
  R             : TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  TabStatus := NewStatusKey('      ', kbF9, cmVTabMode,
    NewStatusKey('Quit', kbF10, cmCancel,
    nil));
  HexaStatus := NewStatusKey('      ', kbF4, cmVHexaMode,
    NewStatusKey('Goto', kbF5, cmVGoto,
    NewStatusKey('LnFeed', kbF6, cmVEOLMode,
    NewStatusKey('Search', kbF7, cmVSearch,
    NewStatusKey('View', kbF8, cmVViewMode,
    TabStatus)))));
  WrapStatus := NewStatusKey('      ', kbF2, cmVWrapMode,
    NewStatusKey('Select', kbF3, cmVSelectFile,
    HexaStatus));
  SymbolStatus := NewStatusKey('      ', kbShiftF9, cmVShowSymbol,
    NewEmptyKey(
    nil));
  LoadAddrStatus := NewStatusKey('      ', kbShiftF4, cmVLoadAddr,
    NewStatusKey('LnLen', kbShiftF5, cmVSetLineLen,
    NewStatusKey('UserLF', kbShiftF6, cmVSetUserEOL,
    NewStatusKey('Search', kbShiftF7, cmVContSearch,
    NewEmptyKey(
    SymbolStatus)))));
  KeyBar := New(PKeyBar, Init(R,
    NewStatusDef(hcNoContext, hcNoContext,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
    nil)))))))))),
    NewStatusDef(hcNoContext + 1, hcVSelectFile - 1,
      NewStatusKey('Help', kbF1, cmHelp,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewStatusKey('Quit', kbF10, cmCancel,
    nil)))))))))),
    NewStatusDef(hcVSelectFile, hcVSelectFile,
      NewStatusKey('Help', kbF1, cmHelp,
      NewEmptyKey(
      NewStatusKey('View', kbF3, cmVLoadFile,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewStatusKey('Raw', kbF9, cmVRawView,
      NewStatusKey('Quit', kbF10, cmCancel,
    nil)))))))))),
    NewStatusDef(hcOnlyQuit, hcOnlyQuit,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewStatusKey('Quit', kbF10, cmCancel,
    nil)))))))))),
    NewStatusDef(hcNormal, hcNormal,
      NewStatusKey('Help', kbF1, cmHelp,
    WrapStatus),
    NewStatusDef(hcShift, hcShift,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      LoadAddrStatus))), nil))))))));
  KeyBar^.Hide;
  LastShiftState := MaxByte;
end;

procedure TCmdrViewer.Idle;
var
  O             : Boolean;
  B             : Byte;
  I             : Integer;
  L             : Longint;
begin
  if SaverInUse then
  begin
    ScreenSaver^.Idle;
  end
  else
  begin
    if (SaverTicks > 0) and (GetTicks > SaverCount + SaverTicks) and
      ((MouseWhere.X < ScreenWidth - 2) or (MouseWhere.Y < ScreenHeight - 1)) then SaverOn;
  end;
  if not SaverInUse then
  begin
    if GoSound then
    begin
      if ErrorSound then
      begin
        Beep;
        LastHalfSec := 2;
        TopView^.DrawView;
      end;
      GoSound := False;
    end;
  end;
  B := GetShiftState;
  if B <> LastShiftState then
  begin
    SaverCount := GetTicks;
    if SaverInUse then SaverOff;
    MouseRightHeld := False;
    AltHelpCtx := hcNoContext;
    if HelpCtxSet and not HelpInUse then
    begin
      ShiftHelpCtx := hcNoContext;
      if B = 0 then AppHelpCtx := CurHelpCtx else AppHelpCtx := hcNoContext;
    end
    else
    begin
      if HelpInUse then
      begin
        ShiftHelpCtx := hcNoContext;
      end
      else
      begin
        ShiftHelpCtx := hcShift;
      end;
      if B = 0 then if HelpInUse then AppHelpCtx := hcOnlyQuit else AppHelpCtx := hcNormal;
      if B and (kbRightShift + kbLeftShift) > 0 then if HelpInUse then AppHelpCtx := hcNoContext else AppHelpCtx := hcShift;
      if B and kbCtrlShift > 0 then AppHelpCtx := hcNoContext;
      if B and kbAltShift > 0 then AppHelpCtx := hcNoContext;
    end;
    if B and kbAltShift = 0 then
    begin
      if AltShiftPressed then
      begin
        AltShiftPressed := False;
        ToggleCharSet(csLowerUpper);
      end;
    end
    else
    begin
      if B and (kbRightShift + kbLeftShift) > 0 then
      begin
        AltShiftPressed := True;
      end
      else
      begin
        if AltShiftPressed then
        begin
          AltShiftPressed := False;
          ToggleCharSet(csLowerUpper);
        end;
      end;
    end;
    if (B and (kbRightShift + kbLeftShift) > 0) and (B and kbCtrlShift > 0) then
    begin
      if LastShiftState and (kbRightShift + kbLeftShift + kbCtrlShift) <> (kbRightShift + kbLeftShift + kbCtrlShift) then
        CtrlShiftPressed := True;
    end
    else
    begin
      if CtrlShiftPressed then
      begin
        CtrlShiftPressed := False;
        ToggleCharSet(csIBMCBM);
      end;
    end;
    LastShiftState := B;
  end;
  TApplication.Idle;
end;

procedure TCmdrViewer.GetEvent(var Event: TEvent);
var
  F,
  O             : Boolean;
  S             : string;
  E             : TEvent;
begin
  TApplication.GetEvent(Event);
  if CtrlAltInsHit then EmergencyExit;
  if GoSound or ((MouseButtons > 0) and (Event.What and evKeyboard > 0)) then ClearEvent(Event);
  if Event.What = evNothing then
  begin
    if WentToCorner and (MouseWhere.X >= ScreenWidth - 2) and (MouseWhere.Y = 0) and (GetTicks > SaverCount + QuarterTicks) and
      not SaverInUse and (GetShiftState = 0) then
    begin
      SaverOn;
      WentToCorner := False;
      LastWhere := Event.Where;
      ClearEvent(Event);
    end;
  end
  else
  begin
    CtrlShiftPressed := False;
    AltShiftPressed := False;
    SaverCount := GetTicks;
    if (Event.What and evMouseMove > 0) and (Event.Where.X >= ScreenWidth - 2) and (Event.Where.Y = 0) and
      ((LastWhere.X < ScreenWidth - 2) or (LastWhere.Y > 0)) then
    begin
      WentToCorner := True;
    end
    else
    begin
      if SaverInUse then ScreenSaver^.HandleEvent(Event);
      if Event.What and evMouse > 0 then LastWhere := Event.Where;
    end;
  end;
  if (Event.What and evCommand > 0) then
  begin
    if (Event.Command = cmHelp) and not HelpInUse then
    begin
      MouseRightHeld := False;
      HelpNum := hcKeyView1;
      _Help;
      TopView^.SetState(sfFocused, True);
      ClearEvent(Event);
    end;
  end;
  if (Event.What and evMouseDown > 0) and (HelpCtxSet or HelpInUse) then
  begin
    F := TopView^.MouseInView(Event.Where);
    E.What := evKeyboard;
    E.KeyCode := kbNoKey;
    if Event.Buttons and mbMiddleButton > 0 then
    begin
      F := True;
      E.KeyCode := kbEnter;
    end
    else if (Event.Buttons and mbRightButton > 0) and not F then E.KeyCode := kbEsc else
      if (Event.Buttons and mbLeftButton > 0) and not F then E.KeyCode := kbEsc;
    if E.KeyCode <> kbNoKey then
    begin
      repeat
        O := F or not TopView^.MouseInView(Event.Where);
        if O then
        begin
          if E.KeyCode = kbEnter then SetDefMouseCursorChar(CheckedChar) else SetDefMouseCursorChar(CancelledChar);
        end
        else
        begin
          SetDefMouseCursorChar(EmptyMouseCursorChar);
        end;
      until not MouseEvent(Event, evMouseMove);
      SetDefMouseCursorChar(EmptyMouseCursorChar);
      if O then PutEvent(E);
    end;
  end;
end;

procedure TCmdrViewer.HandleEvent(var Event: TEvent);
begin
  if Event.What and evKeyboard > 0 then
  begin
    case Event.KeyCode of
      kbEnter: if DirMode then LoadFile(False) else SetHexaMode(not HexaMode, True);
      kbEsc:
      begin
        Event.What := evCommand;
        Event.Command := cmCancel;
        Application^.PutEvent(Event);
      end;
    end;
  end;
  if Event.What and evCommand > 0 then
  begin
    case Event.Command of
      cmCancel: Event.Command := cmQuit;
      cmVWrapMode: SetWrapMode(not WrapMode, True);
      cmVSelectFile: SelectFile;
      cmVHexaMode: SetHexaMode(not HexaMode, True);
      cmVGoto: _Goto;
      cmVEOLMode: SetEOLMode(MaxByte, True);
      cmVSearch: Search(False);
      cmVViewMode: SetViewMode(MaxByte);
      cmVTabMode: SetTabMode(not TabMode, True);
      cmVLoadAddr: ToggleLoadAddress;
      cmVSetLineLen: SetUserEOL(False);
      cmVSetUserEOL: SetUserEOL(True);
      cmVContSearch: Search(True);
      cmVShowSymbol: ToggleSymbols;
      cmVLoadFile: LoadFile(False);
      cmVRawView: LoadFile(True);
    end;
  end;
  TApplication.HandleEvent(Event);
end;

procedure PrintTitle;
begin
  if not TitlePrinted then
  begin
    TitlePrinted := True;
    PrintStr(TitleStr + ' Viewer' + VersionStr + chCR + chLF + CopyrightStr + chCR + chLF + chCR + chLF);
  end;
end;

begin
  MainProgram := False;
  if Test8086 = 0 then
  begin
    PrintTitle;
    PrintStr('This program requires an 80286 CPU or above' + chCR + chLF);
  end
  else
  begin
    FatalError := '';
    TextScreen(nil);
    CheckResident;
    SetStandardParams;
    if Resident and (ShellBuffer^.BatchMode <> bmNone) then Standard := False;
    if Resident and not Standard then Resident := False;
    if ParamCount = 0 then
    begin
      if not Standard then
      begin
        PrintTitle;
        PrintStr('Usage: SCVIEW <filename>' + chCR + chLF);
      end;
    end
    else
    begin
      if DOSVersion < $0314 then
      begin
        if not Standard then
        begin
          PrintTitle;
          PrintStr('This program requires DOS version 3.20 or later' + chCR + chLF);
        end;
      end
      else
      begin
        OutOfMemory := (MemAvail < MemNeeded);
        LoadConfig;
        if Resident then
        begin
          CharStartMode := ShellBuffer^.CharSetMode;
          CharSetMode := CharStartMode;
          VCharSetMode := CharStartMode;
        end;
        if Standard then
        begin
          ScreenCol := StdScreenCol;
          MouseReverse := StdMouseReverse;
        end;
        SearchInHex := False;
        SearchStr := '';
        PanelMode := pmDOS;
        if Resident then
        begin
          if Standard then
          begin
            PanelMode := ShellBuffer^.ViewPanelMode;
            if PanelMode = pmInfo then PanelMode := pmDOS;
          end;
          SearchInHex := ShellBuffer^.SearchInHex;
          SearchText := ShellBuffer^.SearchText;
          SearchHex := ShellBuffer^.SearchHex;
          if SearchInHex then SearchStr := SearchHex else SearchStr := SearchText;
          DisableWinClipboard := ShellBuffer^.DisableWinClipboard;
        end;
        if MemAvail < 13000 then
        begin
          if not Standard then PrintStr('There is not enough memory to execute the Commander Viewer' + chCR + chLF);
        end
        else
        begin
          CmdrViewer.Init;
          if FileOK then CmdrViewer.Run;
          if Resident then
          begin
            if (ViewMode = vmPETANSI) and CustomPalette then
            begin
              ViewMode := vmPETSCII;
              Application^.SetCharSet(CharSetMode, True, False);
            end;
          end
          else
          begin
            Application^.SetCharSet(csIBMLower, False, False);
          end;
          CmdrViewer.Done;
          if Resident then
          begin
            ShellBuffer^.WrapMode := WrapMode;
            ShellBuffer^.HexaMode := HexaMode;
            ShellBuffer^.ShowLoadAddr := ShowLoadAddr;
            ShellBuffer^.ShowSymbols := ShowSymbols;
            ShellBuffer^.UserLineFeed := Ord(EOLChars[3]);
            ShellBuffer^.FixLineLen := FixLineLen;
            ShellBuffer^.SearchInHex := SearchInHex;
            ShellBuffer^.SearchText := SearchText;
            ShellBuffer^.SearchHex := SearchHex;
            ShellBuffer^.CharSetMode := CharSetMode;
          end
          else
          begin
            DoneClipboard;
          end;
        end;
      end;
    end;
  end;
end.
