
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   SMALLFN.PAS                   }
{                                                 }
{     The Star Commander small functions unit     }
{*************************************************}

unit SmallFn;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Panel1;

procedure PullMenu(Previous: Boolean);
procedure Tab;
procedure RereadPanel(Panel: PPanel);
procedure Filter(Panel: PPanel);
procedure PanelsOnOff;
procedure TogglePanel(Panel: PPanel);
procedure ToggleInact;
procedure ToggleInfoOrQuick(Panel: PPanel; Info, Change, Force: Boolean);
procedure ToggleLongNames;
procedure SwapPanels;
procedure MenuEdit;
procedure ExtEdit;
procedure ViewerEdit;
procedure EditorEdit;
procedure ToggleAutoMenus;
procedure TogglePathPrompt;
procedure ToggleKeyBar;
procedure ToggleFullScreen;
procedure SetColumn(Panel: PPanel; Mode: Byte);
procedure SetMiniStatus(Panel: PPanel; Help: Word);
procedure ToggleClock;
procedure SortOrder(Panel: PPanel; S: Byte);
procedure ToggleCharSet(B: Byte);

implementation

uses
  App, Dialogs, Drivers, Menus, Objects, Views,
  Base1, Base2, Config, Constant, DOSShell, ExtFiles, LowLevel, MainFn1, MiscFunc, Panel2;

{Pull down the menu bar
  Input : Last: when True, the menu item previously selected, otherwise the
                Left or Right menu is selected, depending on which panel is
                currently active}
procedure PullMenu(Previous: Boolean);
var
  E             : TEvent;
  P             : PMenu;
begin
  if Previous then MenuSelectMode := Byte(MenuBar^.Menu^.Default <> nil) else
    MenuSelectMode := Byte(Right^.Sel and Right^.Vis) * msLast;
  E.What := evCommand;
  E.Command := cmMenu;
  Application^.PutEvent(E);
end;

{Activates the inactive panel}
procedure Tab;
begin
  if Left^.Vis and Right^.Vis then
  begin
    if Left^.Sel then
    begin
      SelectPanel(Right, (Right^.Mode <> pmInfo));
      Right^.DrawPanel;
    end
    else
    begin
      SelectPanel(Left, (Left^.Mode <> pmInfo));
      Left^.DrawPanel;
    end;
  end;
end;

{'Re-read' item in the 'Left' and 'Right' menus: re-read the contents of a
  panel
  Input : Panel: the panel to be re-read}
procedure RereadPanel(Panel: PPanel);
var
  S             : string;
begin
  if not ((Panel^.QuickView <> qvNone) and Panel^.Changing) then
  begin
    S := Panel^.Path;
    if DriveOK(Panel^.Path) then
    begin
      Panel^.Reread;
      Panel^.Vis := True;
      SetVisibility(True, True, True);
      if (Panel^.Other^.Mode = pmInfo) or (Panel^.Other^.QuickView = qvDirCount) then
        Panel^.Other^.Reread;
    end
    else
    begin
      Panel^.Path := S;
    end;
  end;
end;

{'Filter' menu item in the 'Left' and 'Right' menus: filters the files
  displayed in a panel
  Input : Panel: the panel to be filtered}
procedure Filter(Panel: PPanel);
var
  C,
  W             : Word;
  D             : PDialog;
  I1,
  I2            : PCheckBoxes;
  R             : TRect;
begin
  ChangeHelpCtx(hcFilter);
  BoxTitle := 'Filter';
  if (Panel^.OK) and (Panel^.Mode <> pmExt) then
  begin
    MakeWinBounds(R, 27, 9);
    FixWinBoundsToPanel(R, Panel);
    D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, True));
    R.Assign(6, 2, 23, 1);
    D^.Insert(New(PStaticText, Init(R, 'Select files to display')));
    R.Assign(6, 3, 22, 1);
    I1 := New(PCheckBoxes, Init(R,
      NewSItem('Hidden files',
    nil)));
    W := Byte(Panel^.HiddenFiles);
    I1^.SetData(W);
    D^.Insert(I1);
    R.Assign(6, 4, 23, 5);
    I2 := New(PCheckBoxes, Init(R,
      NewSItem('All files',
      NewSItem('PC executable files',
      NewSItem('PC archive files',
      NewSItem('CBM image files',
      NewSItem('CBM archive files',
    nil)))))));
    W := Panel^.FileFilter shl 1 or Byte(Panel^.FileFilter = 0);
    I2^.SetData(W);
    D^.Insert(I2);
    R.Assign(3, 9, 29, 1);
    D^.Insert(New(PSeparator, Init(R)));
    R.Assign(8, 10, 6, 1);
    D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'O'+ColorChar+'K ]', cmOK)));
    R.Assign(17, 10, 10, 1);
    D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'C'+ColorChar+'ancel ]', cmCancel)));
    I1^.Select;
    C := Application^.ExecView(D, True, True);
    if C = cmOK then
    begin
      I1^.GetData(W);
      Panel^.HiddenFiles := (W and 1 > 0);
      I2^.GetData(W);
      if W and 1 > 0 then W := 0;
      W := W shr 1;
      Panel^.FileFilter := W;
      AutomaticSaveSetup;
      Panel^.Read;
    end;
    Dispose(D, Done);
  end;
  RestoreHelpCtx;
end;

{'Panels on/off' in the 'Commands' menu: toggles the panels on/off}
procedure PanelsOnOff;
var
  V,
  W             : Boolean;
begin
  if Left^.Vis or Right^.Vis then
  begin
    LeftOrigVis := Left^.Vis;
    RightOrigVis := Right^.Vis;
    Left^.Vis := False;
    Right^.Vis := False;
  end
  else
  begin
    V := Left^.Vis;
    W := Right^.Vis;
    Left^.Vis := LeftOrigVis;
    Right^.Vis := RightOrigVis;
    LeftOrigVis := V;
    RightOrigVis := W;
  end;
  SetVisibility(True, True, True);
end;

{'On/off' item in the 'Left' and 'Right' menus: toggles a panel on/off
  Input : Panel: the panel to be toggled}
procedure TogglePanel(Panel: PPanel);
begin
  LeftOrigVis := Left^.Vis;
  RightOrigVis := Right^.Vis;
  Panel^.Vis := not Panel^.Vis;
  SetVisibility(True, True, True);
end;

{Toggle the inactive panel on/off}
procedure ToggleInact;
var
  P             : PPanel;
begin
  if Left^.Vis or Right^.Vis then
  begin
    LeftOrigVis := Left^.Vis;
    RightOrigVis := Right^.Vis;
    if Left^.Sel then Right^.Vis := not Right^.Vis else Left^.Vis := not Left^.Vis;
    SetVisibility(True, True, True);
  end;
end;

{Shut down the info or quick view mode of a panel}
function ShutInfoOrQuick(Panel: PPanel): Boolean;
var
  O             : Boolean;
begin
  Panel^.NewMode := Panel^.OrigMode;
  Panel^.Path := Panel^.OrigPath;
  Panel^.RealImagePath := Panel^.OrigImagePath;
  Panel^.ImageName := Panel^.OrigImageName;
  O := (Panel^.QuickView <> qvNone);
  Panel^.QuickView := qvNone;
  SetCurrentPath(Panel);
  ReadPanel(Panel, O);
  Panel^.SetModeMenu;
  Panel^.Vis := True;
end;

{Toggle Info or Quick View mode of a panel
  Input : Panel: the panel to change the mode of
          Info: when True, Info mode is selected; otherwise Quick View mode
          Change: when True and the panel is in the specified mode, it is
                  turned back to its original mode
          Force: when True, the panel is made visible}
procedure ToggleInfoOrQuick(Panel: PPanel; Info, Change, Force: Boolean);
var
  O,
  P,
  Q,
  R,
  T             : Boolean;
  D             : Char;
begin
  O := False;
  R := True;
  if Act^.Vis or Force then
  begin
    if (Panel^.Other^.Mode = pmInfo) or (Panel^.Other^.QuickView <> qvNone) then
    begin
      if Change then
      begin
        ShutInfoOrQuick(Panel^.Other);
        O := True;
      end;
    end
    else
    begin
      with Panel^ do
      begin
        P := (Mode = pmInfo);
        Q := (QuickView <> qvNone);
        if not Info then
        begin
          T := P;
          P := Q;
          Q := T;
        end;
        if P then
        begin
          if Change then
          begin
            NewMode := OrigMode;
            Path := OrigPath;
            RealImagePath := OrigImagePath;
            ImageName := OrigImageName;
            QuickView := qvNone;
            O := True;
            if (Other^.Mode = pmExt) and (NewMode = pmExt) then
            begin
              NewMode := pmDOS;
              D := 'C';
              if not DriveValid('C') then D := 'A';
              Panel^.Path := LongGetDir(Ord(D) - Ord('@'));
              RealImagePath := '';
              ImageName := '';
              QuickView := qvNone;
            end;
          end;
        end
        else
        begin
          if not Q then
          begin
            OrigMode := Mode;
            OrigPath := Path;
            OrigImagePath := RealImagePath;
            OrigImageName := ImageName;
          end;
          if Info then
          begin
            NewMode := pmInfo;
            QuickView := qvNone;
          end
          else
          begin
            Mode := pmDOS;
            OK := False;
            Changing := True;
            QuickView := qvNormal;
            PEnter(Panel^.Other, True, False, False);
            R := False;
          end;
          O := True;
        end;
        if O then
        begin
          ClockOff;
          if Other^.Mode <> pmExt then
          begin
            LoadingDirs := True;
            LongChDir(Other^.Path);
            LoadingDirs := False;
            CurPath := Other^.Path;
            CommandLine^.DrawView;
          end;
          ClockOn;
          SetModeMenu;
          if R then ReadPanel(Panel, not Info);
          Vis := True;
        end;
      end;
    end;
    if O then SetVisibility(True, True, True);
  end;
end;

{Toggle long file names and reread both panels}
procedure ToggleLongNames;
var
  O             : Boolean;

procedure RereadPanel(Panel: PPanel);
begin
  if Panel^.Mode <> pmExt then Panel^.Read;
end;

begin
  O := LongFileNames;
  LongNames := not LongNames;
  InitLongNames;
  if O <> LongFileNames then
  begin
    RereadPanel(Act);
    RereadPanel(Inact);
  end;
end;

{'Swap panels' item in the 'Commands' menu: swaps the left and right panel}
procedure SwapPanels;
begin
  if Left^.Vis or Right^.Vis then
  begin
    TempPanel := Left;
    Left := Right;
    Right := TempPanel;
    SetPanelBounds;
    Background^.DrawView;
    Left^.DrawPanel;
    Right^.DrawPanel;
  end;
end;

procedure EditSpecialFile(const Name: string);
begin
  ShellBuffer^.EditSpecFile := True;
  SourceName := AddToPath(HomePath, Name, chDirSep);
  EditFile(cfAutomatic);
end;

{'Menu file edit' item in the 'Commands' menu: edits the user menu file}
procedure MenuEdit;
begin
  EditSpecialFile(UserMenuFileName);
end;

{'Extension file edit' in the 'Options' menu: edits the extension file}
procedure ExtEdit;
begin
  EditSpecialFile(ExtensionFileName);
end;

{'Viewers' item in the 'Options' menu: edits the viewer extension file}
procedure ViewerEdit;
begin
  EditSpecialFile(ViewerExtFileName);
end;

{'Editors' item in the 'Options' menu: edits the editor extension file}
procedure EditorEdit;
begin
  EditSpecialFile(EditorExtFileName);
end;

{'Auto menus' item in the 'Options' menu: toggles automatic user menus
  on/off}
procedure ToggleAutoMenus;
begin
  AutoMenus := not AutoMenus;
  SetMenu;
  AutomaticSaveSetup;
end;

{'Path prompt' item in the 'Options' menu: toggles command line path prompt
  on/off}
procedure TogglePathPrompt;
begin
  PathPrompt := not PathPrompt;
  SetMenu;
  CommandLine^.DrawView;
  AutomaticSaveSetup;
end;

{'Key bar' item in the 'Options' menu: toggles the function key bar on/off}
procedure ToggleKeyBar;
begin
  ShowKeyBar := not ShowKeyBar;
  if BackCursorY > ScreenHeight - 1 - Byte(ShowKeyBar) then
  begin
    PutCommand(stEmpty, True);
    SingleCommand := False;
    ClearCommand := False;
    PopupMenu := False;
    EnterDOSShell;
  end;
  SetMenu;
  Background^.DrawView;
  if ShowKeyBar then KeyBar^.Show else KeyBar^.Hide;
  KeyBar^.DrawView;
  AutomaticSaveSetup;
end;

{'Full screen' item in the 'Options' menu: toggles full screen mode on/off}
procedure ToggleFullScreen;
begin
  if FullScreen then OrigPanWinSize := OrigHalfPanWinSize else
    OrigPanWinSize := OrigScreenHeight - 2;
  ChangePanels;
  AutomaticSaveSetup;
end;

{'Brief', 'Full', 'Wide' and 'Column mode' item in the 'Left' and 'Right'
  menus: sets Brief/Full/Wide mode for the current or for both DOS and CBM mode
  of a panel
  Input : Panel: the panel whose Brief/Full/Wide mode to set
          Mode: mode to change Brief/Full/Wide to; >128, if the user has to set
                it interactively}
procedure SetColumn(Panel: PPanel; Mode: Byte);
var
  O             : Boolean;
  B             : Byte;
  C,
  W             : Word;
  D             : PDialog;
  I1,
  I2            : PRadioButtons;
  R             : TRect;
begin
  ChangeHelpCtx(hcColumn);
  BoxTitle := 'Column mode';
  B := Panel^.Mode;
  O := ((Panel^.QuickView <> qvNone) or (B = pmInfo));
  if Panel^.OK or O then
  begin
    if O then B := Panel^.OrigMode;
    if Mode < 128 then
    begin
      C := cmOK;
      if B = pmDOS then Mode := Mode or (Panel^.ColumnMode and (cmModeMask shl 2))
        else Mode := (Mode shl 2) or (Panel^.ColumnMode and cmModeMask);
    end
    else
    begin
      MakeWinBounds(R, 25, 7);
      FixWinBoundsToPanel(R, Panel);
      D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, True));
      R.Assign(7, 2, 19, 1);
      D^.Insert(New(PStaticText, Init(R, 'Select column mode')));
      R.Assign(9, 4, 3, 3);
      I1 := New(PRadioButtons, Init(R,
        NewSItem(stEmpty,
        NewSItem(stEmpty,
        NewSItem(stEmpty,
      nil)))));
      W := Panel^.ColumnMode and cmModeMask;
      I1^.SetData(W);
      D^.Insert(I1);
      R.Assign(14, 4, 9, 3);
      I2 := New(PRadioButtons, Init(R,
        NewSItem('Brief',
        NewSItem('Full',
        NewSItem('Wide',
      nil)))));
      W := (Panel^.ColumnMode shr 2) and cmModeMask;
      I2^.SetData(W);
      R.Assign(9, 3, 8, 1);
      D^.Insert(New(PColorText, Init(R, ColorChar+'DOS'+ColorChar+'  '+ColorChar+'CBM')));
      D^.Insert(I2);
      R.Assign(3, 7, 27, 1);
      D^.Insert(New(PSeparator, Init(R)));
      R.Assign(7, 8, 6, 1);
      D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'O'+ColorChar+'K ]', cmOK)));
      R.Assign(16, 8, 10, 1);
      D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'C'+ColorChar+'ancel ]', cmCancel)));
      I1^.Select;
      if B <> pmDOS then I2^.Select;
      C := Application^.ExecView(D, True, True);
      if C = cmOK then
      begin
        I1^.GetData(W);
        Mode := W and 3;
        I2^.GetData(W);
        Mode := Mode or ((W and 3) shl 2);
      end;
      Dispose(D, Done);
    end;
    if C = cmOK then
    begin
      if O then
      begin
        Panel^.NewMode := Panel^.OrigMode;
        Panel^.Mode := Panel^.NewMode;
        Panel^.Path := Panel^.OrigPath;
        Panel^.RealImagePath := Panel^.OrigImagePath;
        Panel^.ImageName := Panel^.OrigImageName;
        Panel^.QuickView := qvNone;
      end;
      Panel^.ColumnMode := Mode;
      Panel^.SetModeMenu;
      Panel^.Vis := True;
      if O then Panel^.Scan;
      Panel^.SearchName;
      Panel^.DrawPanel;
      SetVisibility(True, True, True);
    end;
  end;
  RestoreHelpCtx;
end;

{'Mini status' item in the 'Left' and 'Right' menus: sets mini status mode
  for both DOS and CBM mode of a panel; if Panel is nil, both panels are
  set
  Input : Panel: the panel whose mini status to set
          Help: help context during the execution of the dialog box}
procedure SetMiniStatus(Panel: PPanel; Help: Word);
var
  B             : Byte;
  C,
  W             : Word;
  D             : PDialog;
  I1,
  I2            : PRadioButtons;
  R             : TRect;
begin
  ChangeHelpCtx(Help);
  BoxTitle := 'Mini status';
  if (Panel = nil) or Panel^.OK then
  begin
    MakeWinBounds(R, 25, 7);
    if Panel <> nil then FixWinBoundsToPanel(R, Panel);
    D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, True));
    R.Assign(5, 2, 23, 1);
    D^.Insert(New(PStaticText, Init(R, 'Select mini status mode')));
    R.Assign(9, 4, 3, 3);
    I1 := New(PRadioButtons, Init(R,
      NewSItem(stEmpty,
      NewSItem(stEmpty,
      NewSItem(stEmpty,
    nil)))));
    if Panel = nil then W := Act^.MiniStatus and 3 else W := Panel^.MiniStatus and 3;
    I1^.SetData(W);
    D^.Insert(I1);
    R.Assign(14, 4, 9, 3);
    I2 := New(PRadioButtons, Init(R,
      NewSItem('Off',
      NewSItem('Brief',
      NewSItem('Full',
    nil)))));
    if Panel = nil then W := (Act^.MiniStatus shr 2) and 3 else W := (Panel^.MiniStatus shr 2) and 3;
    I2^.SetData(W);
    D^.Insert(I2);
    R.Assign(9, 3, 8, 1);
    D^.Insert(New(PColorText, Init(R, ColorChar+'DOS'+ColorChar+'  '+ColorChar+'CBM')));
    R.Assign(3, 7, 27, 1);
    D^.Insert(New(PSeparator, Init(R)));
    R.Assign(7, 8, 6, 1);
    D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'O'+ColorChar+'K ]', cmOK)));
    R.Assign(16, 8, 10, 1);
    D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'C'+ColorChar+'ancel ]', cmCancel)));
    I1^.Select;
    if ((Panel = nil) and (Act^.Mode <> pmDOS)) or ((Panel <> nil) and (Panel^.Mode <> pmDOS)) then I2^.Select;
    C := Application^.ExecView(D, True, True);
    if C = cmOK then
    begin
      I1^.GetData(W);
      B := W and 3;
      I2^.GetData(W);
      B := B or ((W and 3) shl 2);
      if Panel = nil then
      begin
        Left^.MiniStatus := B;
        Right^.MiniStatus := B;
      end
      else
      begin
        Panel^.MiniStatus := B;
      end;
      Left^.Read;
      Right^.Read;
      ChangePanels;
      if Panel = nil then if Left^.Mode = pmInfo then Panel := Right else if Right^.Mode = pmInfo then Panel := Left;
      if (Panel <> nil) and (Panel^.Other^.Mode = pmInfo) then
      begin
        Panel^.DrawPanel;
        Panel^.Other^.Loading := False;
        Panel^.Other^.DrawPanel;
      end;
      AutomaticSaveSetup;
    end;
    Dispose(D, Done);
  end;
  RestoreHelpCtx;
end;

{'Clock' item in the 'Options' menu: toggles the clock on/off}
procedure ToggleClock;
begin
  ShowClock := not ShowClock;
  SetMenu;
  LastHalfSec := 2;
  if not ShowMenu then Right^.DrawPanel;
  if ShowClock then Clock^.Show else Clock^.Hide;
  MenuBar^.DrawView;
  Clock^.DrawView;
  AutomaticSaveSetup;
end;

{'Name'-'Unsorted', 'Sort order' and 'Reverse' items in the 'Left' and 'Right'
  menus: sets the sort order of files for the panel
  Input : Panel: the panel whose sort order to set
          S: new sort order; >=128, if the user has to set it interactively}
procedure SortOrder(Panel: PPanel; S: Byte);
var
  O             : Boolean;
  C,
  W             : Word;
  D             : PDialog;
  I1,
  I2            : PRadioButtons;
  I3,
  I4            : PCheckBoxes;
  R             : TRect;
begin
  ChangeHelpCtx(hcSort);
  BoxTitle := 'Sort order';
  C := cmOK;
  if S < 128 then
  begin
    if S >= psReverse then
    begin
      if Panel^.Mode = pmDOS then S := Panel^.SortMode xor 64 else S := Panel^.SortMode xor 128;
    end
    else
    begin
      if Panel^.Mode = pmDOS then S := (Panel^.SortMode and ((psModeMask shl 3) + (psReverse shl 1))) or S else
        if S = psTime then C := cmCancel else S := (Panel^.SortMode and (psModeMask + psReverse)) or (S shl 3);
    end;
  end
  else
  begin
    MakeWinBounds(R, 25, 10);
    FixWinBoundsToPanel(R, Panel);
    D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, True));
    R.Assign(7, 2, 19, 1);
    D^.Insert(New(PStaticText, Init(R, 'Select sort order')));
    R.Assign(9, 3, 8, 1);
    D^.Insert(New(PColorText, Init(R, ColorChar+'DOS'+ColorChar+'  '+ColorChar+'CBM')));
    R.Assign(9, 4, 3, 5);
    I1 := New(PRadioButtons, Init(R,
      NewSItem(stEmpty,
      NewSItem(stEmpty,
      NewSItem(stEmpty,
      NewSItem(stEmpty,
      NewSItem(stEmpty,
    nil)))))));
    W := Panel^.SortMode and psModeMask;
    I1^.SetData(W);
    D^.Insert(I1);
    R.Assign(14, 4, 13, 5);
    I2 := New(PRadioButtons, Init(R,
      NewSItem('Name',
      NewSItem('Extension',
      NewSItem('Time',
      NewSItem('Size',
      NewSItem('Unsorted',
    nil)))))));
    W := (Panel^.SortMode shr 3) and psModeMask;
    I2^.SetData(W);
    D^.Insert(I2);
    R.Assign(9, 9, 3, 1);
    I3 := New(PCheckBoxes, Init(R,
      NewSItem(stEmpty,
    nil)));
    W := (Panel^.SortMode and psReverse) shr 6;
    I3^.SetData(W);
    D^.Insert(I3);
    R.Assign(14, 9, 13, 1);
    I4 := New(PCheckBoxes, Init(R,
      NewSItem('Reverse',
    nil)));
    W := (Panel^.SortMode and (psReverse shl 1)) shr 7;
    I4^.SetData(W);
    D^.Insert(I4);
    R.Assign(3, 10, 27, 1);
    D^.Insert(New(PSeparator, Init(R)));
    R.Assign(16, 11, 10, 1);
    D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'C'+ColorChar+'ancel ]', cmCancel)));
    R.Assign(7, 11, 6, 1);
    D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'O'+ColorChar+'K ]', cmOK)));
    I1^.Select;
    if Panel^.Mode <> pmDOS then I2^.Select;
    C := Application^.ExecView(D, True, True);
    if C = cmOK then
    begin
      I1^.GetData(W);
      S := W and psModeMask;
      I2^.GetData(W);
      if W and psModeMask = psTime then W := (Panel^.SortMode shr 3) and psModeMask;
      S := S or ((W and psModeMask) shl 3);
      I3^.GetData(W);
      S := S or ((W shl 6) and psReverse);
      I4^.GetData(W);
      S := S or ((W shl 7) and (psReverse shl 1));
    end;
    Dispose(D, Done);
  end;
  if C = cmOK then
  begin
    if (Panel^.Mode = pmInfo) and (Panel^.OrigMode <> pmInfo) then
    begin
      Panel^.Mode := Panel^.OrigMode;
      Panel^.NewMode := Panel^.Mode;
    end;
    GetClock(False);
    Panel^.SortMode := S;
    Panel^.SetSortOrder;
    Panel^.Vis := True;
    if not Panel^.OK then Panel^.Scan;
    Panel^.SortDirectory;
    Panel^.SearchName;
    Panel^.DrawPanel;
    SetVisibility(True, True, True);
    SetClock;
  end;
  RestoreHelpCtx;
end;

{Toggle the IBM/C64 character set or the lowercase/uppercase and uppercase/
  graphics subset
  Input : B: determines what to toggle (1 to toggle the subset, 2 to toggle
             the IBM/C64 character set}
procedure ToggleCharSet(B: Byte);
begin
  if CanChangeChars then
  begin
    CharStartMode := CharStartMode xor B;
    Application^.SetCharSet(CharStartMode, True, False);
    LastHalfSec := MaxByte;
    RedrawAllViews;
    MouseScreenMask := DefMouseScreenMask;
    MouseCursorMask := DefMouseCursorMask;
  end;
end;

end.
