	TITLE	SYSINT

	LOCALS	@@

; Double byte record

b0		EQU	(BYTE PTR 0)
b1		EQU	(BYTE PTR 1)

; Double word record

w0		EQU	(WORD PTR 0)
w2		EQU	(WORD PTR 2)

; Keyboard scan codes

scSpaceKey	EQU	39H
scInsKey	EQU	52H
scDelKey	EQU	53H
scBackKey	EQU	0EH

; Keyboard shift flags

kbShiftKey	EQU	03H
kbCtrlKey	EQU	04H
kbAltKey	EQU	08H

; ROM BIOS workspace

KeyFlags	EQU	(BYTE PTR 17H)
InsFlag		EQU	(BYTE PTR 18H)
KeyBufHead	EQU	(WORD PTR 1AH)
KeyBufTail	EQU	(WORD PTR 1CH)
KeyBufOrg	EQU	(WORD PTR 1EH)
KeyBufEnd	EQU	(WORD PTR 3EH)

; DOS function call classes

cNothing	EQU	0	;No check needed
cName		EQU	2	;Check name at DS:DX
cHandle		EQU	4	;Check handle in BX
cDrive		EQU	6	;Check drive in DL

; Data segment

_DATA		SEGMENT WORD PUBLIC 'DATA'

; Externals

	EXTRN	SysErrorFunc:DWORD
	EXTRN	EmergencyExitFunc:DWORD
	EXTRN	CtrlAltInsHit:BYTE
	EXTRN	CtrlAltInsActive:BYTE
	EXTRN	CtrlBreakHit:BYTE
	EXTRN	SaveCtrlBreak:BYTE
	EXTRN	CtrlBreakActive:BYTE
	EXTRN	SysErrActive:BYTE

_DATA		ENDS

; Data group

DGROUP		GROUP	_DATA

; Code segment

SYSINT_TEXT	SEGMENT	BYTE PUBLIC 'CODE'

	ASSUME	CS:SYSINT_TEXT,DS:DGROUP

	PUBLIC	InitCtrlBreak
	PUBLIC	DoneCtrlBreak
	PUBLIC	InitSysError
	PUBLIC	DoneSysError

; CS-based variables

Int13Working	DB	0
OldInt09	DD	0	;Saved INT 09H vector
OldInt13	DD	0	;Saved INT 13H vector
OldInt15	DD	0	;Saved INT 15H vector
OldInt1B	DD	0	;Saved INT 1BH vector
OldInt21	DD	0	;Saved INT 21H vector
OldInt23	DD	0	;Saved INT 23H vector
OldInt24	DD	0	;Saved INT 24H vector

; Keyboard conversion table

KeyConvertTab	LABEL	BYTE

	DB	scSpaceKey,kbAltKey
	DW	0200H
	DB	scInsKey,kbCtrlKey
	DW	0400H
	DB	scInsKey,kbShiftKey
	DW	0500H
	DB	scDelKey,kbCtrlKey
	DW	0600H
	DB	scDelKey,kbShiftKey
	DW	0700H
	DB	scBackKey,kbAltKey
	DW	0800H

KeyConvertCnt	EQU	($-KeyConvertTab)/4

; DOS function call class table

FuncClassTab	LABEL	BYTE

	DB	cDrive		;36H - Get disk free space
	DB	cNothing
	DB	cNothing
	DB	cName		;39H - Make directory
	DB	cName		;3AH - Remove directory
	DB	cName		;3BH - Change directory
	DB	cName		;3CH - Create file
	DB	cName		;3DH - Open file
	DB	cHandle		;3EH - Close file
	DB	cHandle		;3FH - Read file
	DB	cHandle		;40H - Write file
	DB	cName		;41H - Delete file
	DB	cHandle		;42H - Seek file
	DB	cName		;43H - Change file attributes
	DB	cNothing
	DB	cNothing
	DB	cNothing
	DB	cDrive		;47H - Get current directory
	DB	cNothing
	DB	cNothing
	DB	cNothing
	DB	cName		;4BH - Load or execute program
	DB	cNothing
	DB	cNothing
	DB	cName		;4EH - Find first
	DB	cNothing
	DB	cNothing
	DB	cNothing
	DB	cNothing
	DB	cNothing
	DB	cNothing
	DB	cNothing
	DB	cName		;56H - Rename file
	DB	cHandle		;57H - Get/Set file date and time

; Function check routines table

FuncCheckTab	LABEL	WORD

	DW	CheckNothing
	DW	CheckName
	DW	CheckHandle
	DW	CheckDrive

; Install Control-Break and Control-Alt-Insert handlers

InitCtrlBreak:

	MOV	AX,3300H
	INT	21H
	MOV	SaveCtrlBreak,DL
	MOV	AX,3301H
	MOV	DL,0
	INT	21H
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX
	MOV	DI,OFFSET OldInt09
	PUSH	CS
	POP	ES
	CLD
	CLI
	MOV	SI,09H*4
	MOVSW
	MOVSW
	MOV	SI,13H*4
	MOVSW
	MOVSW
	MOV	SI,15H*4
	MOVSW
	MOVSW
	MOV	SI,1BH*4
	MOVSW
	MOVSW
	MOV	SI,21H*4
	MOVSW
	MOVSW
	MOV	SI,23H*4
	MOVSW
	MOVSW
	MOV	WORD PTR DS:[09H*4+0],OFFSET Int09Handler
	MOV	WORD PTR DS:[09H*4+2],CS
	MOV	WORD PTR DS:[13H*4+0],OFFSET Int13Handler
	MOV	WORD PTR DS:[13H*4+2],CS
	MOV	WORD PTR DS:[15H*4+0],OFFSET Int15Handler
	MOV	WORD PTR DS:[15H*4+2],CS
	MOV	WORD PTR DS:[1BH*4+0],OFFSET Int1BHandler
	MOV	WORD PTR DS:[1BH*4+2],CS
	MOV	AX,DS:[410H]
	AND	AX,0C1H
	DEC	AX
	JNE	@@1
	MOV	WORD PTR DS:[21H*4+0],OFFSET Int21Handler
	MOV	WORD PTR DS:[21H*4+2],CS
@@1:	MOV	WORD PTR DS:[23H*4+0],OFFSET Int23Handler
	MOV	WORD PTR DS:[23H*4+2],CS
	STI
	MOV	AX,CS
	XCHG	AX,WORD PTR DS:[10H*4+2]
	PUSH	AX
	MOV	AX,OFFSET CS:Int10Handler
	XCHG	AX,WORD PTR DS:[10H*4+0]
	PUSH	AX
	MOV	AH,0BH
	INT	21H
	POP	DS:WORD PTR [10H*4+0]
	POP	DS:WORD PTR [10H*4+2]
	POP	DS
	MOV	CtrlBreakActive,1
	RETF

; Remove Control-Break and Control-Alt-Insert handlers

DoneCtrlBreak:

	CMP	CtrlBreakActive,0
	JE	@@1
	MOV	CtrlBreakActive,0
	PUSH	DS
	MOV	SI,OFFSET OldInt09
	PUSH	CS
	POP	DS
	XOR	AX,AX
	MOV	ES,AX
	CLD
	CLI
	MOV	DI,09H*4
	MOVSW
	MOVSW
	MOV	DI,13H*4
	MOVSW
	MOVSW
	MOV	DI,15H*4
	MOVSW
	MOVSW
	MOV	DI,1BH*4
	MOVSW
	MOVSW
	MOV	DI,21H*4
	MOVSW
	MOVSW
	MOV	DI,23H*4
	MOVSW
	MOVSW
	STI
	POP	DS
	MOV	AX,3301H
	MOV	DL,SaveCtrlBreak
	INT	21H
@@1:	RETF

; Install system error handler

InitSysError:

	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX
	MOV	DI,OFFSET OldInt24
	PUSH	CS
	POP	ES
	CLD
	CLI
	MOV	SI,24H*4
	MOVSW
	MOVSW
	MOV	WORD PTR DS:[24H*4+0],OFFSET Int24Handler
	MOV	WORD PTR DS:[24H*4+2],CS
	STI
	POP	DS
	MOV	SysErrActive,1
	RETF

; Remove system error handler

DoneSysError:

	CMP	SysErrActive,0
	JE	@@1
	MOV	SysErrActive,0
	PUSH	DS
	MOV	SI,OFFSET OldInt24
	PUSH	CS
	POP	DS
	XOR	AX,AX
	MOV	ES,AX
	CLD
	CLI
	MOV	DI,24H*4
	MOVSW
	MOVSW
	STI
	POP	DS
@@1:	RETF

; INT 09H handler

Int09Handler:

	PUSH	DS
	PUSH	DI
	PUSH	AX
	MOV	AX,40H
	MOV	DS,AX
	MOV	DI,DS:KeyBufTail
	IN	AL,60H
	MOV	AH,DS:KeyFlags
	PUSHF
	CALL	OldInt09
	AND	DS:InsFlag, 7FH
	TEST	AL,80H
	JNE	@@9
	PUSH	SI
	PUSH	CX
	MOV	SI,OFFSET CS:KeyConvertTab
	MOV	CX,KeyConvertCnt
@@1:	CMP	AL,CS:[SI]
	JNE	@@2
	TEST	AH,CS:[SI+1]
	JNE	@@3
@@2:	ADD	SI,4
	LOOP	@@1
	JMP	SHORT @@8
@@3:	CMP	DI,DS:KeyBufTail
	JNE	@@5
	MOV	AX,DI
	INC	AX
	INC	AX
	CMP	AX,OFFSET KeyBufEnd
	JNE	@@4
	MOV	AX,OFFSET KeyBufOrg
@@4:	CMP	AX,DS:KeyBufHead
	JE	@@8
	MOV	DS:KeyBufTail,AX
	MOV	DI,AX
@@5:	MOV	AX,CS:[SI+2]
	MOV	DS:[DI],AX
@@8:	POP	CX
	POP	SI
@@9:	POP	AX
	POP	DI
	POP	DS
	IRET

; INT 13H handler

Int13Handler:

	PUSHF
	MOV	CS:Int13Working,1
	CALL	OldInt13
	MOV	CS:Int13Working,0
	RETF	2

; INT 15H handler

Int15Handler:

	CMP	AH,4FH
	JNE	@@1
	PUSH	DS
	PUSH	AX
	PUSH	BX
	XOR	BX,BX
	MOV	DS,BX
	MOV	BL,BYTE PTR DS:[417H]
	AND	BL,0CH
	CMP	BL,0CH
	JNE	@@2
	CMP	AL,52H
	JNE	@@2
	MOV	AX,SEG DGROUP
	MOV	DS,AX
	CMP	CtrlAltInsActive,0
	JE	@@2
	MOV	CtrlAltInsHit,1
	MOV	AL,CS:Int13Working
	OR	AL,AL
	JNE	@@3
	CALL	EmergencyExitFunc
@@3:	POP	BX
	POP	AX
	POP	DS
	MOV	AL,0
	STC
	IRET
@@2:	POP	BX
	POP	AX
	POP	DS
@@1:	PUSHF
	CALL	OldInt15
	IRET

; INT 1BH handler

Int1BHandler:

	PUSH	DS
	PUSH	AX
	XOR	AX,AX
	MOV	DS,AX
	AND	BYTE PTR DS:[471H],7FH
	MOV	AX,SEG DGROUP
	MOV	DS,AX
	MOV	CtrlBreakHit,1
	POP	AX
	POP	DS
	IRET

; INT 21H handler

Int21Handler:

	PUSHF
	STI
	CMP	AH,36H
	JB	@@1
	CMP	AH,57H
	JA	@@1
	PUSH	DX
	PUSH	BX
	MOV	BL,AH
	XOR	BH,BH
	MOV	BL,CS:FuncClassTab[BX-36H]
	CALL	CS:FuncCheckTab[BX]
	POP	BX
	POP	DX
	JC	@@2
@@1:	POPF
	JMP	OldInt21
@@2:	POPF
	STI
	CMP	AH,36H
	MOV	AX,0FFFFH
	JE	@@3
	MOV	AX,5
@@3:	STC
	RETF	2

; Check file name

CheckName:

	MOV	BX,DX
	MOV	DX,[BX]
	AND	DL,1FH
	DEC	DL
	CMP	DH,':'
	JE	CheckAbsDrive
	JMP	SHORT CheckCurDrive

; Check handle

CheckHandle:

	MOV	BX,SP
	MOV	BX,SS:[BX+2]
	PUSH	AX
	MOV	AX,4400H
	PUSHF
	CALL	OldInt21
	POP	AX
	OR	DL,DL
	JNS	CheckAbsDrive
	JMP	SHORT CheckNothing

; Check drive

CheckDrive:

	DEC	DL
	JNS	CheckAbsDrive

; Check current drive

CheckCurDrive:

	PUSH	AX
	MOV	AH,19H
	PUSHF
	CALL	OldInt21
	MOV	DL,AL
	POP	AX

; Check absolute drive
; In	DL = Drive (0=A, 1=B, etc)
; Out	CF = 1 if drive swap failed

CheckAbsDrive:

	CMP	DL,2
	JAE	CheckNothing
	PUSH	DS
	PUSH	AX
	PUSH	BX
	MOV	BL,DL
	INC	BL
	MOV	AX,440EH
	PUSHF
	CALL	OldInt21
	OR	AL,AL
	CLC
	JE	@@1
	CMP	AL,BL
	CLC
	JE	@@1
	MOV	AX,SEG DGROUP
	MOV	DS,AX
	PUSH	ES
	PUSH	DI
	PUSH	SI
	PUSH	DX
	PUSH	CX
	MOV	AX,23
	PUSH	AX
	PUSH	DX
	XOR	AX,AX
	PUSH	AX
	PUSH	AX
	PUSH	AX
	CALL	SysErrorFunc
	POP	CX
	POP	DX
	POP	SI
	POP	DI
	POP	ES
	CMP	AX,1
	STC
	JNE	@@1
	XOR	AX,AX
	MOV	DS,AX
	MOV	BL,DL
	INC	BL
	MOV	AX,440FH
	PUSHF
	CALL	OldInt21
	CLC
@@1:	POP	BX
	POP	AX
	POP	DS

; No check required

CheckNothing:

	RET

; INT 23H and temporary INT 10H handler

Int10Handler:
Int23Handler:

	IRET

; INT 24H handler

Int24Handler:

	STI
	PUSH	ES
	PUSH	DS
	PUSH	BP
	PUSH	DI
	PUSH	SI
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	DX,SEG DGROUP
	MOV	DS,DX
	XOR	DX,DX
	TEST	AH,20H
	JE	@@1
	INC	DX
@@1:	AND	DI,0FFH
	CMP	DI,21
	JB	@@6
	MOV	DI,21
@@6:	MOV	BX,BP
	MOV	CX,SI
	TEST	AH,80H
	JE	@@4
	MOV	ES,BP
	TEST	BYTE PTR ES:[SI+5],80H
	JNE	@@5
	MOV	DI,22
	JMP	@@4
@@5:	MOV	AL,0FFH
@@4:	PUSH	DI
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	CALL	SysErrorFunc
	CMP	AL,1
	JE	@@2
	PUSH	AX
	XOR	BX,BX
	MOV	AH,59H
	INT	21H
	POP	AX
@@2:	POP	DX
	POP	CX
	POP	BX
	POP	SI
	POP	DI
	POP	BP
	POP	DS
	POP	ES
	IRET

SYSINT_TEXT	ENDS

	END
