
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   TRANSFER.PAS                  }
{                                                 }
{      The Star Commander file transfer unit      }
{*************************************************}

unit Transfer;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

procedure SetDirNameGiven;
procedure CopyFiles(Z: Byte; M, C: Boolean);
procedure DeleteFiles(Z: Byte);

implementation

uses
  App, Dialogs, DOS, Drivers, Views,
  Base1, Base2, Constant, ExtFiles, LowLevel, MiscFunc, Panel1, Panel2, Script, XferLo,
  FCopy, FDelete, FRenMov;

{Determine whether the specified file name is that of a directory}
procedure SetDirNameGiven;
var
  F             : Boolean;
begin
  if (Act^.CopyMode = pmDOS) and (CopyFileMode in [cfWildcard, cfAutomatic]) then
  begin
    F := FileExists(AddToPath(Act^.CopyRealPath, Act^.CopyName, chDirSep), True);
    if F or IncludeSubdirs then DirNameGiven := True;
    if not F then IncludeSubdirs := False;
  end;
end;

{Read the specified panel if its contents have changed during file
  operations
  Input : Panel: the panel to be read if changed}
procedure ReadIfChanged(Panel: PPanel);
begin
  if not (Panel^.Mode in [pmExt, pmInfo]) or ((Panel^.Mode = pmExt) and
    (Panel^.CopyMode = pmExt) and (Panel^.CBMDev = Panel^.CopyCBMDev) and DiskChanged) then Panel^.Read;
end;

{Setup some variables for the Copy, Rename or move and Compress menu items}
procedure SetupCopyRenMovCompress;
begin
  if Compressing then
  begin
    ChangeHelpCtx(hcCompress2);
    BoxTitle := 'Compress';
    CopyTitle := BoxTitle;
    ExtFileName := '[ '+ColorChar+'C'+ColorChar+'ompress ]';
  end
  else
  begin
    if (CopyFileMode in [cfSelected, cfSingle]) and (GetPanelModeAttrib(Act^.Mode, paReadOnly)) then MoveFiles := False;
    if MoveFiles then
    begin
      ChangeHelpCtx(hcRenMovFile);
      BoxTitle := 'Rename';
      CopyTitle := 'Rename or move';
      ExtFileName := '[ '+ColorChar+'M'+ColorChar+'ove ]';
    end
    else
    begin
      ChangeHelpCtx(hcCopyFile);
      BoxTitle := 'Copy';
      CopyTitle := BoxTitle;
      ExtFileName := '[ '+ColorChar+'C'+ColorChar+'opy ]';
    end;
  end;
end;

{Build a string containing the number of selected files and directories
  Output: the resulting string}
function SelectedFiles: string;
var
  I,
  J,
  K             : Integer;
  S             : string;
begin
  S := '';
  J := Act^.SelNum;
  K := 0;
  if Act^.Mode = pmDOS then
  begin
    for I := 0 to Act^.Max - 1 do
    begin
      if (Act^.Dir[I].Status = fsSelected) and (Act^.Dir[I].Attr and Directory > 0) then
      begin
        Dec(J);
        Inc(K);
      end;
    end;
  end;
  if J > 0 then
  begin
    S := LeadingSpace(J, 0) + ' file';
    if J > 1 then S := S + 's';
  end;
  if K > 0 then
  begin
    if J > 0 then S := S + ' and ';
    S := S + LeadingSpace(K, 0) + ' director';
    if K = 1 then S := S + 'y' else S := S + 'ies';
  end;
  SelectedFiles := S;
end;

{Loop for copying, renaming or moving the selected files}
procedure CopyRenMovLoop;
var
  B,
  F,
  O             : Boolean;
  G             : Byte;
  H,
  I,
  L             : Word;
  D             : PDialog;
  A,
  M,
  N,
  S              : string;
begin
  ClockOff;
  if MoveFiles then BoxTitle := 'Move';
  if (Act^.CopyMode = pmExt) and (Inact^.CopyMode = pmExt) and
    ((CurHelpCtx <> hcRenMovFile) or not Inact^.SameAsPanel) then
  begin
    NoTwoDrives;
    ContProcess := False;
  end
  else
  begin
    ExtDrive := False;
    if (Act^.CopyMode = pmExt) or (Inact^.CopyMode = pmExt) then
    begin
      CBMDevNum := Act^.CopyCBMDev;
      if Inact^.CopyMode = pmExt then CBMDevNum := Inact^.CopyCBMDev;
      MouseOff;
      ExtDrive := True;
    end;
    I := 0;
    if not ExtDrive or CheckLPTPorts(True) then
    begin
      if not ExtDrive or CheckDevice then
      begin
        L := 0;
        D := nil;
        while ContDirProcess and ContProcess do
        begin
          F := Act^.FirstFile;
          ContDirProcess := Act^.FindNextFile(False, True, False);
          if ContDirProcess then
          begin
            Inc(I);
            AppendFile := False;
            if (AllErrorSkip = ayAllYes) and (BatchMode = bmNone) then AllErrorSkip := ayNone;
            if (Act^.CopyMode = pmDOS) and (Act^.CopyAttr and Directory > 0) then
            begin
              O := False;
              if Inact^.CopyMode = pmDOS then
              begin
                B := False;
                if MoveFiles then
                begin
                  if (UpperCase(AddToPath(Act^.CopyRealPath, Act^.CopyName, chDirSep)) = UpperCase(Inact^.CopyRealPath)) then
                  begin
                    Inact^.CopyName := CutPath(Inact^.CopyPath, chDirSep);
                    Inact^.CopyPath := GetPath(Inact^.CopyPath, chDirSep);
                    Inact^.NamePattern := Inact^.CopyName;
                    Inact^.SameAsPanel := True;
                    Inact^.MakeFullName;
                    B := True;
                  end
                  else
                  begin
                    B := (Inact^.SameAsPanel and not FileExists(AddToPath(Inact^.CopyRealPath,
                      CloneDOSName(Act^.CopyName, Inact^.NamePattern), chDirSep), True)) and not
                      FileExists(Inact^.CopyRealPath, True);
                  end;
                end;
                if B then
                begin
                  RenMovFile(D, False);
                end
                else
                begin
                  Inact^.CheckPath;
                  B := IncludeSubdirs;
                  G := CopyFileMode;
                  H := Act^.CopyAttr;
                  A := Act^.CopyName;
                  N := Act^.NamePattern;
                  M := Inact^.NamePattern;
                  Inact^.CopyName := CloneDOSName(Act^.CopyName, Inact^.NamePattern);
                  Inact^.NamePattern := stAllFilesDOS;
                  O := CopyDir(D, F, MoveFiles);
                  CopyFileMode := G;
                  Act^.CopyName := A;
                  if MoveFiles and O then
                  begin
                    AppendFile := False;
                    if not RunningShell then O := DeleteDir(Act, D, True, True);
                  end;
                  IncludeSubdirs := B;
                  CopyFileMode := G;
                  Act^.CopyAttr := H;
                  Act^.CopyName := A;
                  Act^.NamePattern := N;
                  Inact^.NamePattern := M;
                  UnselectFile(Act, O);
                end;
              end
              else
              begin
                if Inact^.CopyMode = pmExt then S := 'to Commodore disk' else
                  if GetPanelModeAttrib(Inact^.CopyMode, (paImage + paArchive)) then
                    S := 'into ' + MakeFullTypeStr(Inact^.CopyMode);
                ErrorWin(stEmpty, 'Can''t copy directories', S + 's.', CurHelpCtx, sbNone);
                O := True;
              end;
            end
            else
            begin
              if MoveFiles then RenMovFile(D, F) else CopyFile(D, F, False, False);
              F := False;
            end;
          end;
        end;
        if D <> nil then Dispose(D, Done);
      end
      else
      begin
        if not ReadCBMError(N, True, False, True) then ErrorWin(stError, N, stEmpty, CurHelpCtx, sbSkip);
      end;
    end
    else
    begin
      Act^.Error := True;
    end;
    Inact^.MakeBackupFile(True);
  end;
end;

{Loop for deleting the selected files}
procedure DeleteLoop;
var
  F,
  O             : Boolean;
  G             : Byte;
  H,
  L             : Word;
  D             : PDialog;
  A,
  M,
  N             : string;
begin
  ClockOff;
  Act^.Error := False;
  Act^.CorrectImageName(True);
  O := True;
  if (Act^.CopyMode <> pmExt) or CheckDevice then
  begin
    if (Act^.CopyMode = pmExt) and (CopyCmdExecMode = cxWarp) and (CopyTransferMode <> tmNormal) then
    begin
      D := InfoWin(stEmpty, 'Deleting files on the disk', 'in drive ' + LeadingSpace(Act^.CBMDev, 1) + ':', stEmpty, 2);
      ValidateDisk(False);
      DiskChanged := True;
      FileProcessed := True;
      Dispose(D, Done);
      D := nil;
    end
    else
    begin
      D := nil;
      while ContDirProcess and ContProcess do
      begin
        ContDirProcess := Act^.FindNextFile(False, True, False);
        if ContDirProcess then
        begin
          Act^.MakeFullName;
          if BatchMode = bmNone then AllErrorSkip := ayNone;
          if (Act^.CopyMode = pmDOS) and (Act^.CopyAttr and Directory > 0) then
          begin
            F := IncludeSubdirs;
            G := CopyFileMode;
            H := Act^.CopyAttr;
            A := Act^.CopyName;
            N := Act^.NamePattern;
            M := Inact^.NamePattern;
            Inact^.NamePattern := stAllFilesDOS;
            O := DeleteDir(Act, D, False, True);
            IncludeSubdirs := F;
            CopyFileMode := G;
            Act^.CopyAttr := H;
            Act^.CopyName := A;
            Act^.NamePattern := N;
            Inact^.NamePattern := M;
            if (CopyFileMode = cfSelected) and (Act^.SelNum > 0) and (CopyFileNum < Act^.Max) then
            begin
              if O then
              begin
                Act^.Dir[CopyFileNum].Status := fsDeleted;
                Act^.Draw;
              end
              else
              begin
                Inc(CopyFileNum);
              end;
            end;
          end
          else
          begin
            O := DeleteFile(Act, D, False, False, False, True);
          end;
        end;
      end;
      if D <> nil then Dispose(D, Done);
      O := False;
    end;
  end;
  Act^.MakeBackupFile(True);
end;

{Move the cursor bar upwards in the panel if files above it have been
  deleted}
procedure MoveCur(Panel: PPanel);
var
  I,
  J             : Integer;
begin
  J := Panel^.NewCur;
  if J > 0 then for I := 0 to J - 1 do if (Panel^.Dir[I].Status and fsStatusMask) = fsDeleted then Dec(Panel^.NewCur);
end;

{Delete a temporary file
  Input : Name: name of the file
          FileOpen: when True, the file has been opened; otherwise there's
                      no file to delete}
procedure DeleteTempFile(const Name: string; FileOpen: Boolean);
begin
  if FileOpen then LongErase(AddToPath(GetPanelTempPath, Name, chDirSep));
end;

{Copy, rename, move or delete the selected files}
procedure CopyRenMovDelete;
var
  O,
  F             : Boolean;
  B             : Byte;
  W             : Word;
  I,
  J,
  K             : Integer;
  N,
  S,
  T             : string;
begin
  FileProcessed := False;
  if ExecMode = exNormal then
  begin
    if BatchMode = bmNone then ResetAutoReplies;
    AllConvert := False;
    AllErrorSkip := ayNone;
    TempFileOpen := False;
    ShellBuffer^.TempUncompOpen := False;
    ShellBuffer^.TempInputOpen := False;
    ShellBuffer^.TempOutputOpen := False;
    ShellBuffer^.SourceOK := True;
    ShellBuffer^.DestArchType := pmDOS;
    CopyFileNum := 0;
    if CopyFileMode <> cfAutomatic then
    begin
      CopyIntoFileImages := IntoFileImages;
      CopyExtractFileImages := ExtractFileImages;
    end;
  end
  else
  begin
    FileProcessed := True;
  end;
  TempUncompOpen := ShellBuffer^.TempUncompOpen;
  TempInputOpen := ShellBuffer^.TempInputOpen;
  TempOutputOpen := ShellBuffer^.TempOutputOpen;
  if (CurHelpCtx <> hcCompress2) or Act^.Vis then
  begin
    if CopyFileMode = cfReadKey then
    begin
      case ExecMode of
        exNormal: CopyFileMode := ShiftCode;
        exOpenRead: CopyFileMode := ShellBuffer^.CopyFileMode;
      end;
    end;
    if (CopyFileMode <> cfAutomatic) and
      (not Act^.Vis or (Act^.Mode = pmInfo) or ((Act^.QuickView <> qvNone) and Act^.Changing)) then CopyFileMode := cfWildcard;
    O := True;
    N := '';
    AppendFile := False;
    DirNameGiven := False;
    IncludeSubdirs := False;
    FileSizeWarned := False;
    DiskChanged := False;
    SingleFile := False;
    ShutImage := False;
    EscPressed := False;
    DestArchType := pmDOS;
    ContProcess := True;
    ContDirProcess := True;
    OnlyRename := False;
    case CopyFileMode of
      cfSelected:
      begin
        if (Act^.SelNum > 0) and ((Act^.Mode <> pmFile) or (CurHelpCtx in [hcCopyFile, hcCompress2])) then
          N := SelectedFiles + ' to';
      end;
      cfWildcard: N := 'the file';
    end;
    if CopyFileMode <> cfAutomatic then
    begin
      T := Act^.GetNamePtr(Act^.Cur)^;
      if N = '' then
      begin
        if Act^.Max > 0 then
        begin
          SingleFile := True;
          if Act^.Mode = pmDOS then
          begin
            O := (T <> stParentDir);
          end
          else
          begin
            if GetPanelModeAttrib(Act^.Mode, (paImage + paArchive)) then
            begin
              B := Act^.Dir[Act^.Cur].Attr and faTypeMask;
              O := (Act^.Cur > 0) and (((CurHelpCtx = hcDeleteFile) and
                not GetPanelModeAttrib(Act^.Mode, paDirectories)) or
                ((B in [faDeleted..faRelative]) or ((B = faPartition) and (Act^.Mode = pmDisk)) or
                ((B = faFrozen) and (Act^.Mode = pmTape)))) and
                ((CurHelpCtx <> hcDeleteFile) or not GetPanelModeAttrib(Act^.Mode, paReadOnly));
            end;
          end;
          if (not Inact^.Vis or (Inact^.Mode = pmInfo) or (Inact^.QuickView <> qvNone) or (CopyFileMode = cfSingle)) and
            (CurHelpCtx = hcRenMovFile) or ((Act^.Mode = pmDisk) and (B = faPartition)) then OnlyRename := True;
        end
        else
        begin
          O := False;
        end;
        if O then
        begin
          if GetPanelModeAttrib(Act^.Mode, paASCII) then N := LimitNameLen(T, (MaxNameLen - 6) - Length(CopyTitle)) else
            N := MakeCBMName(T, Act^.GEOSFormat);
          if CurHelpCtx <> hcDeleteFile then N := '"' + N + '" to';
        end;
      end;
    end;
    if O then
    begin
      if CopyFileMode = cfAutomatic then
      begin
        F := Act^.FirstFile;
        Act^.Prepare(SourceName, True, False, False);
        Inact^.Prepare(DestName, False, True, True);
        Act^.FirstFile := F;
        IncludeSubDirs := True;
      end
      else
      begin
        if ExecMode = exNormal then
        begin
          DestName := '';
          if OnlyRename then
          begin
            DestName := T;
            if not GetPanelModeAttrib(Act^.Mode, paASCII) then
              DestName := ConvertCBMName(DestName, Act^.GEOSFormat, False, hxPercent);
          end;
          if Inact^.Vis and (CurHelpCtx <> hcDeleteFile) then
          begin
            if not OnlyRename then
            begin
              DestName := Inact^.Path;
              if Compressing and (Length(DestName) >= 3) and (DestName[Length(DestName)] <> chDirSep) then
                DestName := DestName + chDirSep;
              case Inact^.Mode of
                pmDisk, pmDiskZip, pmTape, pmLynx..pmFileZip:
                begin
                  Inact^.CopyImageProtoName := Inact^.ImageName;
                  Inact^.CorrectImageName(False);
                  DestName := MakeTypeStr(Inact^.Mode) + ':' + AddToPath(DestName, Inact^.CopyImageName, chDirSep);
                  if Inact^.ImagePath <> '' then DestName := AddToPath(DestName,
                    ConvertCBMPath(Inact^.ImagePath, Inact^.GEOSFormat, False, hxPercent, Inact^.DirSep), chDirSep);
                  B := pmDOS;
                  if Compressing then
                  begin
                    B := DetermineTypePrefix(DestName);
                    if not (B in [pmLynx..pmFileZip]) then B := pmDOS;
                  end;
                  ShellBuffer^.DestArchType := B;
                end;
                pmInfo: DestName := '';
              end;
            end;
          end;
        end;
        ErrorDown := 0;
        SourceName := LastName;
        if (CurHelpCtx <> hcDeleteFile) or (CopyFileMode = cfWildcard) then
        begin
          B := aaNone;
          if CurHelpCtx <> hcDeleteFile then if Compressing then B := aaArchive else B := aaNone;
          O := Act^.GetFileName(stEmpty, CopyTitle + stSpace + N, ExtFileName, nil, nil, False, ((CopyFileMode = cfWildcard) or
            (CurHelpCtx = hcDeleteFile)), (CurHelpCtx <> hcDeleteFile), True, False, (CopyFileMode = cfWildcard), eeNone, B);
          IncludeSubdirs := DefIncSubdirs;
          if O then
          begin
            if Compressing and (DestArchType = pmDOS) then
            begin
              Compressing := False;
              SetupCopyRenMovCompress;
            end;
            if Compressing then O := (DestName[Length(DestName)] <> chDirSep);
            if (CurHelpCtx = hcDeleteFile) and not DeleteConfirm then
            begin
              if AllFiles(Act^.CopyName) then
              begin
                if Act^.SameAsPanel then
                begin
                  if Act^.CopyMode <> pmExt then N := 'in the current ';
                  case Act^.CopyMode of
                    pmDOS: N := N + stDirectory;
                    pmExt: N := 'on the disk in drive ' + Copy(Act^.CopyPath, 1, 2);
                  else
                    if GetPanelModeAttrib(Act^.CopyMode, paImage) then N := N + 'image file' else
                      if GetPanelModeAttrib(Act^.CopyMode, paArchive) then N := N + 'archive file';
                  end;
                end
                else
                begin
                  case Act^.CopyMode of
                    pmDOS, pmExt: N := AddToPath(Act^.CopyPath, Act^.CopyName, chDirSep);
                    pmDisk, pmTape, pmLynx..pmFileZip:
                    begin
                      Act^.CopyImageName := MakeFileExt(Act^.CopyImageName, DOSExt[Act^.CopyMode]);
                      N := MakeTypeStr(Act^.CopyMode) + ':' +
                        AddToPath(Act^.CopyPath, Act^.CopyImageName, chDirSep) + chDirSep + Act^.CopyName;
                    end;
                  end;
                end;
                O := (SureConfirm(stEmpty, ColorChar+'WARNING!'+ColorChar, 'Do you want to delete all the files', N + '?',
                  stEmpty, stDelete, stEmpty, stEmpty, stEmpty, stEmpty, nil, CurHelpCtx, ayNone, False, DummyByte) = cmOK);
              end;
            end;
          end;
        end
        else
        begin
          if SingleFile then
          begin
            S := 'Do you wish to delete';
            if Act^.Dir[Act^.Cur].Attr and Directory <> 0 then
            begin
              N := '"' + N + '"';
              S := S + ' the directory';
              IncludeSubdirs := True;
            end;
            O := (Confirm(stEmpty, S, N, stDelete, stEmpty, stEmpty, nil, CurHelpCtx, True, DummyByte) = cmOK);
            if O then Act^.Prepare(Act^.GetNamePtr(Act^.Cur)^, False, False, False);
          end
          else
          begin
            N := SelectedFiles;
            O := (Confirm(stEmpty, 'You have selected', N, stDelete, stEmpty, stEmpty,
              nil, CurHelpCtx, False, DummyByte) = cmOK);
            if O and not DeleteConfirm then
            begin
              case Act^.Mode of
                pmDOS, pmExt: DestName := Act^.Path;
                pmDisk, pmTape: DestName := MakeTypeStr(Act^.Mode) + ':' + AddToPath(Act^.Path, Act^.ImageName, chDirSep);
              end;
              ErrorDown := 5;
              O := (SureConfirm(stEmpty, 'You are '+ColorChar+'DELETING', N + ' from', DestName, stEmpty,
                stDelete, stEmpty, stEmpty, stEmpty, stEmpty, nil, CurHelpCtx, ayAllYes, False, AllDelete) = cmOK);
              ErrorDown := 0;
            end;
            Dispose(TempDialog, Done);
            TempDialog := nil;
            if O then Act^.Prepare(stEmpty, True, False, False);
          end;
        end;
      end;
      LastName := SourceName;
      if O then
      begin
        Act^.Working := True;
        Act^.NewCur := Act^.Cur;
        Inact^.Working := True;
        Inact^.NewCur := Inact^.Cur;
        if Inact^.Mode = pmInfo then Inact^.DrawPanel;
        Archiving := True;
        RunningShell := False;
        SetDirNameGiven;
        if CopyFileMode = cfSelected then SaveSelection;
        case CurHelpCtx of
          hcCopyFile, hcRenMovFile, hcCompress2: CopyRenMovLoop;
          hcDeleteFile: DeleteLoop;
        end;
        if Act^.CopyEntry.HandleUsed then LongFindClose(Act^.CopyEntry);
        if EscPressed then ExecMode := exNormal;
        if not RunningShell then
        begin
          Archiving := False;
          InOutRes := 0;
          FailSysErrors := fsAll;
          DeleteTempFile(TempFileName, TempFileOpen);
          DeleteTempFile(ArcTempUncomp, TempUncompOpen);
          DeleteTempFile(ArcTempInput, TempInputOpen);
          DeleteTempFile(ArcTempOutput, TempOutputOpen);
          FailSysErrors := fsNone;
          InOutRes := 0;
          ShellBuffer^.ViewFileName := '';
        end;
        if ShutImage then Act^.ShutImageMode;
        if not RunningShell then
        begin
          ExecMode := exNormal;
          if FileProcessed then
          begin
            if not ShutImage and (CopyFileMode <> cfWildcard) then
            begin
              UnselectProcessed;
              Act^.Under := Act^.GetNamePtr(Act^.NewCur)^;
              Inact^.Under := Inact^.GetNamePtr(Inact^.NewCur)^;
              MoveCur(Act);
              MoveCur(Inact);
              Act^.Draw;
            end;
            ReadIfChanged(Act);
            ReadIfChanged(Inact);
          end
          else
          begin
            ErrorDown := 0;
            Act^.DrawPanel;
            if (Inact^.Mode = pmInfo) or (Inact^.QuickView <> qvNone) then Inact^.Read;
          end;
        end;
      end;
    end;
    if not RunningShell then ClockOn;
  end;
  RestoreHelpCtx;
  NextBatchCommand;
end;

{'Copy', 'Rename or move' and 'Compress' items in the 'Files' and 'Commands'
  menus: copy, rename, move or compress the selected files
  Input : Z: file selection mode (file under the cursor bar, selected
             files, enter file name in a dialog box)
          M: when True, files are moved rather than copied
          C: when True, files are to be compressed into an archive rather
             than simply copied}
procedure CopyFiles(Z: Byte; M, C: Boolean);
begin
  Compressing := C;
  MoveFiles := M;
  CopyFileMode := Z;
  SetupCopyRenMovCompress;
  CopyRenMovDelete;
end;

{'Delete' item in the 'Files' menu: delete the selected files
  Input : Z: file selection mode (file under the cursor bar, selected
             files, enter file name in a dialog box)}
procedure DeleteFiles(Z: Byte);
begin
  Compressing := False;
  ChangeHelpCtx(hcDeleteFile);
  BoxTitle := 'Delete';
  CopyTitle := 'Delete';
  ExtFileName := '';
  CopyFileMode := Z;
  CopyRenMovDelete;
end;

end.
