
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   TXT2HTML.PAS                  }
{                                                 }
{              Text to HTML Converter             }
{*************************************************}

program Text_to_HTML_Converter;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 0, 655360}

type
  Convert       = record
    Src,
    Dest        : string[20];
  end;

const
  LineLength    = 78;
  ConvertNum    = 44;
  FrameChars0   = 'ͳ';
  FrameChars1   = '-+';
  FrameChars2   = '|';
  Converts      : array [0..ConvertNum - 1] of Convert =
                  ((Src: ''; Dest: '&aacute;'),
                   (Src: ''; Dest: '&eacute;'),
                   (Src: ''; Dest: '&iacute;'),
                   (Src: ''; Dest: '&oacute;'),
                   (Src: ''; Dest: '&uacute;'),
                   (Src: ''; Dest: '&auml;'),
                   (Src: ''; Dest: '&ouml;'),
                   (Src: ''; Dest: '&uuml;'),
                   (Src: ''; Dest: '&aring;'),
                   (Src: ''; Dest: '&Aacute;'),
                   (Src: '(C)'; Dest: '&copy;'),
                   (Src: ' - '; Dest: ' &#150; '),
                   (Src: ',- '; Dest: ',&#150; '),
                   (Src: ' -,'; Dest: ' &#150;,'),
                   (Src: '<'; Dest: '&lt;'),
                   (Src: '>'; Dest: '&gt;'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '-'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '|'),
                   (Src: ''; Dest: '|'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '-'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'),
                   (Src: ''; Dest: '+'));

var
  ParBegin,
  ParEnd,
  EndOfPass,
  Separator,
  Paragraph,
  PrevParagraph,
  PossASCIIArt,
  ASCIIArt,
  PrevASCIIArt,
  Warning,
  PrevWarning,
  Title,
  PrevTitle,
  Header,
  Centered,
  Justified,
  PrevJustified : Boolean;
  EmptyLineNum,
  Pass,
  List,
  ListSwitch    : Byte;
  ConvertIndex,
  Index         : Word;
  Section,
  PrevListNum,
  ListNum,
  ValOK         : Integer;
  NumStr        : string[10];
  PageTitle,
  Line,
  PrevLine,
  ReadName,
  WriteName     : string;
  ReadFile,
  WriteFile     : Text;

function UpperCase(const S: string): string;
var
  I             : Integer;
  T             : string;
begin
  T[0] := Chr(Length(S));
  for I := 1 to Length(S) do T[I] := UpCase(S[I]);
  UpperCase := T;
end;

function CharsInString(const Chars, Str: string): Byte;
var
  B             : Byte;
  W             : Word;
begin
  B := 0;
  for W := 1 to Length(Str) do
    if Pos(Str[W], Chars) > 0 then Inc(B);
  CharsInString := B;
end;

procedure WriteLine(const Line: string);
begin
  if Pass > 1 then
  begin
    WriteLn(WriteFile, PrevLine);
    PrevLine := Line;
  end;
end;

procedure SwitchMode(var Line: string; const Tag: string; On: Boolean);
begin
  if On then Line := '<' + Tag + '>' + Line else Line := Line + '</' + Tag + '>';
end;

procedure SetCentered(var Line: string; On: Boolean);
begin
  if Centered <> On then SwitchMode(Line, 'CENTER', On);
  Centered := On;
end;

procedure SetList(var Line: string; On: Byte);
var
  B             : Byte;
  S             : string[10];
begin
  B := On;
  if On = 0 then B := List;
  if B > 1 then S := 'OL' else S := 'UL';
  if List <> On then
  begin
    SwitchMode(Line, S, (On > 0));
    if On = 0 then WriteLine('');
  end;
  List := On;
end;

procedure ConvertLink(Protocol, Prefix: string; AntiSpam: Boolean);
var
  B,
  C,
  D,
  E             : Byte;
  S             : string;
begin
  B := 1;
  repeat
    C := Pos(Protocol, Copy(Line, B, 255));
    if C > 0 then
    begin
      Inc(C, B - 1);
      E := C;
      while (C > 1) and (Line[C - 1] <> ' ') do Dec(C);
      while (Line[C] in ['.', ',', '!', '?', '"', '(', ')']) do Dec(C);
      D := C;
      while (C < Length(Line)) and (Line[C + 1] <> ' ') do Inc(C);
      while (C <= Length(Line)) and (Line[C] in ['.', ',', '!', '?', '"', '(', ')']) do Dec(C);
      if Pos('.', Copy(Line, E, C - E)) = 0 then
      begin
        Inc(B, D);
      end
      else
      begin
        S := Copy(Line, D, C - D + 1);
        if AntiSpam then
        begin
          E := Pos(Protocol, S);
          S := Copy(S, 1, E - 1) + '.ANTI' + Protocol + 'SPAM.' + Copy(S, E + Length(Protocol), 255);
        end;
        Line := Copy(Line, 1, D - 1) + '<A HREF="' + Prefix + S + '">' + S + '</A>' + Copy(Line, C + 1, 255);
        B := D + (Length(S) * 2) + Length(Prefix) + 15;
      end;
    end;
  until C = 0;
end;

procedure SwitchASCIIArt;
begin
  if PrevASCIIArt <> ASCIIArt then
  begin
    if ASCIIArt then
    begin
      WriteLine('<PRE>');
    end
    else
    begin
      PrevLine := PrevLine + '</PRE>';
    end;
    PrevASCIIArt := ASCIIArt;
  end;
end;

begin
  WriteLn('Text to HTML Converter by Joe Forster/STA');
  WriteLn;
  if ParamCount < 2 then
  begin
    WriteLn('This program converts text documentations into HTML format.');
    WriteLn;
    WriteLn('Usage: TXT2HTML <input-file> <output-file>');
  end
  else
  begin
    ReadName := UpperCase(ParamStr(1));
    WriteName := UpperCase(ParamStr(2));
    Assign(ReadFile, ReadName);
    Reset(ReadFile);
    if IOResult = 0 then
    begin
      Assign(WriteFile, WriteName);
      Rewrite(WriteFile);
      if IOResult = 0 then
      begin
        Pass := 1;
        while Pass <= 2 do
        begin
          EndOfPass := False;
          PrevParagraph := True;
          ParEnd := False;
          Title := True;
          PrevWarning := False;
          Section := -1;
          PrevLine := '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">';
          WriteLine('<HTML LANG="EN">');
          WriteLine('');
          WriteLine('<HEAD>');
          WriteLine('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=ISO-8859-1">');
          WriteLine('<TITLE>' + PageTitle + '</TITLE>');
          WriteLine('</HEAD>');
          WriteLine('');
          WriteLine('<BODY>');
          WriteLine('');
          while not EOF(ReadFile) and not EndOfPass do
          begin
            ParBegin := False;
            PrevListNum := ListNum;
            ReadLn(ReadFile, Line);
            Separator := (Copy(Line, 1, 10) = '----------');
            if Separator then
            begin
              SetCentered(PrevLine, False);
              if List <> 0 then WriteLine('');
              SetList(PrevLine, 0);
              WriteLine('<HR>');
              Warning := not Warning;
              if not Warning then PrevWarning := True;
            end
            else
            begin
              Justified := (Length(Line) = LineLength);
              ListSwitch := 0;
              if Copy(Line, 1, 4) = '  - ' then
              begin
                Line := Copy(Line, 5, 255);
                ListSwitch := 1;
              end
              else
              begin
                if not Header and (Copy(Line, 1, 2) = '  ') and (Line[3] in ['0'..'9']) and
                  (((Line[4] = '.') and (Line[5] = ' ')) or
                  ((Line[4] in ['0'..'9']) and (Line[5] = '.') and (Line[6] = ' '))) then
                begin
                  Index := 4;
                  if Line[Index] <> '.' then Inc(Index);
                  Val(Copy(Line, 3, Index - 3), ListNum, ValOK);
                  if ValOK <> 0 then ListNum := -1;
                  if (ListNum = PrevListNum + 1) then
                  begin
                    Line := Copy(Line, 6, 255);
                    ListSwitch := 2;
                  end;
                end
                else
                begin
                  if (Line <> '') and (Copy(Line, 1, 4) <> '    ') then ListSwitch := 3;
                end;
              end;
              PossASCIIArt := ((CharsInString(FrameChars0, Line) >= 1) or
                (CharsInString(FrameChars1, Line) >= 10) or
                (CharsInString(FrameChars2, Line) >= 3) or
                (Copy(Line, 1, 10) = '          ')) and not Title;
              Line := ' ' + Line + ' ';
              repeat
                Index := Pos('&', Line);
                if Index > 0 then
                begin
                  if Copy(Line, Index, Length('&amp;')) <> '&amp;' then
                  begin
                    Delete(Line, Index, Length('&'));
                    Insert('&amp;', Line, Index);
                  end
                  else
                  begin
                    Index := 0;
                  end;
                end;
              until Index = 0;
              for ConvertIndex := 0 to ConvertNum do
              begin
                repeat
                  Index := Pos(Converts[ConvertIndex].Src, Line);
                  if Index > 0 then
                  begin
                    Delete(Line, Index, Length(Converts[ConvertIndex].Src));
                    Insert(Converts[ConvertIndex].Dest, Line, Index);
                  end;
                until Index = 0;
              end;
              if not PossASCIIArt then
              begin
                repeat
                  Index := Pos('  ', Line);
                  if Index > 0 then Delete(Line, Index, 1);
                until Index = 0;
                while (Line <> '') and (Line[1] = ' ') do Line := Copy(Line, 2, 255);
                while (Line <> '') and (Line[Length(Line)] = ' ') do Dec(Line[0]);
                ConvertLink('http://', '', False);
                ConvertLink('ftp://', '', False);
                ConvertLink('@', 'mailto:', True);
              end;
              case ListSwitch of
                1, 2:
                begin
                  Paragraph := False;
                  if (List <> 0) and not ParEnd then
                  begin
                    PrevLine := PrevLine + '</P>';
                    ParEnd := True;
                  end;
                  if (Section = 0) and (ListNum > 0) then
                  begin
                    Str(ListNum, NumStr);
                    Line := '<A HREF="#section' + NumStr + '">' + Line + '</A>';
                  end;
                  WriteLine('');
                  Line := '<LI><P ALIGN="JUSTIFY">' + Line;
                  ParBegin := True;
                  ParEnd := False;
                  SetList(PrevLine, ListSwitch);
                end;
                3:
                begin
                  if List <> 0 then WriteLine('');
                  SetList(PrevLine, 0);
                end;
              end;
              if Line = '' then
              begin
                Inc(EmptyLineNum);
                if Warning then WriteLine('');
                Warning := False;
                if not Title then
                begin
                  if ASCIIArt then
                  begin
                    if EmptyLineNum >= 2 then
                    begin
                      ASCIIArt := False;
                      SwitchASCIIArt;
                      SetList(PrevLine, 0);
                      Paragraph := True;
                    end
                    else
                    begin
                      WriteLine('');
                    end;
                  end
                  else
                  begin
                    Justified := True;
                    if Paragraph and not PrevTitle then
                    begin
                      Header := True;
                    end
                    else
                    begin
                      if not Paragraph then
                      begin
                        Paragraph := True;
                        if not ParEnd then
                        begin
                          PrevLine := PrevLine + '</P>';
                          ParEnd := True;
                        end;
                        if List = 0 then WriteLine('');
                      end;
                    end;
                  end;
                end;
              end
              else
              begin
                if EmptyLineNum > 0 then ASCIIArt := PossASCIIArt;
                if (List <> 0) and Paragraph then WriteLine('');
                Paragraph := False;
                PrevTitle := False;
                if Warning then
                begin
                  SetCentered(Line, True);
                  WriteLine(Line);
                end
                else
                begin
                  if Title then
                  begin
                    if Pass = 1 then
                    begin
                      PageTitle := Line;
                      EndOfPass := True;
                    end
                    else
                    begin
                      if PrevWarning then WriteLine('');
                      SwitchMode(Line, 'H2', True);
                      SetCentered(Line, True);
                      WriteLine(Line);
                      SwitchMode(PrevLine, 'H2', False);
                      SetCentered(PrevLine, False);
                      Title := False;
                      PrevTitle := True;
                      ParEnd := True;
                    end;
                  end
                  else
                  begin
                    if Header then
                    begin
                      Section := -1;
                      Index := 2;
                      if Line[Index] <> '.' then Inc(Index);
                      Val(Copy(Line, 1, Index - 1), ConvertIndex, ValOK);
                      if ValOK = 0 then Section := ConvertIndex;
                      if Section > 0 then
                      begin
                        Str(Section, NumStr);
                        Line := '<A NAME="section' + NumStr + '">' + Line + '</A>';
                      end;
                      if not Justified then Line := '<H3>' + Line + '</H3>';
                      WriteLine(Line);
                      Header := False;
                    end
                    else
                    begin
                      if not ASCIIArt and not PrevASCIIArt and not PrevJustified and ((ListSwitch = 0) or (List = 0)) then
                        PrevLine := PrevLine + '<BR>';
                      SwitchASCIIArt;
                      if not ASCIIArt and PrevParagraph and not ParBegin then
                      begin
                        Line := '<P ALIGN="JUSTIFY">' + Line;
                        ParEnd := False;
                      end;
                      WriteLine(Line);
                    end;
                  end;
                end;
                EmptyLineNum := 0;
                PrevWarning := False;
              end;
              if not ASCIIArt then PrevParagraph := Paragraph;
              PrevJustified := Justified;
            end;
            if List = 0 then ListNum := 0;
          end;
          Inc(Pass);
          Close(ReadFile);
          Reset(ReadFile);
        end;
        if not ASCIIArt and not ParEnd then PrevLine := PrevLine + '</P>';
        WriteLine('');
        WriteLine('<CENTER><P><FONT SIZE=-1>(This page best viewed with any browser)</FONT></P></CENTER>');
        WriteLine('');
        WriteLine('</BODY>');
        WriteLine('</HTML>');
        WriteLine('');
        Close(WriteFile);
        WriteLn('Successfully converted ', ReadName, ' to ', WriteName);
      end
      else
      begin
        WriteLn('Cannot create ', WriteName);
      end;
      Close(ReadFile);
    end
    else
    begin
      WriteLn(ReadName, ' not found');
    end;
  end;
end.
