
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    USRMNU.PAS                   }
{                                                 }
{        The Star Commander User menu unit        }
{*************************************************}

unit UsrMnu;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

const
{Pre-defined user menu items}
  umValidate    = 1;
  umClean       = 2;
  umSafeClean   = 3;
  umProtectToggle= 4;
  umFormat      = 5;
  umBadSectors  = 6;
  umMinimize    = 7;
  umSelectHead  = 8;
  umUserCommand = 9;
  umProtect     = 10;
  umUnprotect   = 11;

procedure UserMenu(Z: Byte; Command: Integer);

implementation

uses
  App, Dialogs, Drivers, Objects, Views,
  Base1, Base2, Constant, DOSShell, DiskEd, ExtFiles, LowLevel, MiscFunc, Panel1, Panel2, Script;

{Walk through the directory and validate each file}
procedure ValidateDir;
begin
  while Act^.ReadCBMEntry(Entry) do
  begin
    if Entry.Attr and faClosed = 0 then
    begin
      Act^.DirBuffer[Act^.EntryPos + 2] := 0;
      Act^.WriteDiskBlock(Act^.DirTrack, Act^.DirSector, @Act^.DirBuffer);
    end
    else
    begin
      if (Entry.Attr and faTypeMask > 0) then Act^.Validate(alAllocate,
        ((Act^.DiskType and dtTypeMask = dt1581) and (Entry.Attr and faTypeMask = faPartition)),
        (Entry.ExtAttr and xaGEOSVLIR > 0), False, Entry.Size);
    end;
  end;
end;

{'User menu' item in the 'Files' menu: pop up user-defined menu in a DOS
  panel or a pre-defined menu in a CBM panel
  Input : Z: file selection mode (file under the cursor bar, file name
             already given)
          Command: function to be executed; for batch mode only}
procedure UserMenu(Z: Byte; Command: Integer);
var
  B,
  E,
  O,
  Q             : Boolean;
  N,
  S,
  T,
  G             : Byte;
  C,
  J             : Word;
  I,
  X,
  Y             : Integer;
  V,
  W             : Longint;
  D             : PDialog;
  A,
  P             : PHistoryItem;
  U             : PSItem;
  M             : PHistory;
  F,
  L             : string;
  R             : TRect;

{Create a string, representing disk protection status
  Input : Flag: when True, the disk is protected; otherwise not
  Output: string representation}
function ProtectStr(Flag: Boolean): string;
var
  S             : string[10];
begin
  S := 'protect';
  if not Flag then S := 'un' + S;
  ProtectStr := S;
end;

{Check whether the current image file is read-only or not and display an
  error message if it is
  Output: when True, the image file is not read-only}
function CheckReadOnly: Boolean;
begin
  B := False;
  SysErrorOccurred := False;
  if Act^.ImageReadOnly then ErrorWin(stEmpty, 'The following image file is marked read-only.',
    Act^.CopyFullName, CurHelpCtx, sbNone) else B := True;
  CheckReadOnly := B;
end;

{Check whether the image file exists
  Output: when True, the image file exists; otherwise not}
function CheckImage: Boolean;
var
  B             : Boolean;
begin
  B := FileExists(Act^.CopyFullName, False);
  if not B then ErrorWin(stEmpty, 'Can''t open the following image.', Act^.CopyFullName, CurHelpCtx, sbNone);
  CheckImage := B;
end;

begin
  ChangeHelpCtx(hcUserMenu);
  BoxTitle := 'User Menu';
  CopyFileMode := Z;
  Act^.MakeListFile := False;
  Inact^.MakeListFile := False;
  O := False;
  Q := False;
  if (CopyFileMode = cfAutomatic) or (Act^.Mode = pmExt) or Act^.OK or Act^.MustRead then
  begin
    F := UserMenuFileName;
    while not Q do
    begin
      case CopyFileMode of
        cfSelected:
        begin
          case Act^.Mode of
            pmDOS, pmInfo:
            begin
              Q := (ReadUserFile(F, True, True, CurHelpCtx) <> 0);
              if not Q then Q := not ConstructMenu(Y, A, False, True);
              ClockOn;
            end;
            pmFile, pmLynx..pmFileZip, pmGCRDisk..pmSixZip: Q := True;
          else
            P := NewHistoryItem('V', 'Validate', umValidate, True, nil);
            A := P;
            P := NewHistoryItem('F', 'Format', umFormat, True, P);
            Y := 2;
            if Act^.Mode = pmDisk then
            begin
              P := NewHistoryItem('S', 'Safe clean', umSafeClean, True,
                NewHistoryItem('C', 'Clean', umClean, True, P));
              Inc(Y, 2);
              S := Act^.DiskType and dtTypeMask;
              if (S = dt1541) or ((S = dt1541Ext) and (Act^.ExtBAMMode <> xbPrologicDOS)) then
              begin
                P := NewHistoryItem('P', 'Protect/unprotect', umProtectToggle, True, P);
                Inc(Y);
              end;
              P := NewHistoryItem('B', 'Select bad files', umBadSectors, True, P);
              Inc(Y);
            end;
            case Act^.Mode of
              pmTape:
              begin
                if (Act^.ImageSize + 2 - LonglongintToLongint(Act^._Free) > 0) and (LonglongintToLongint(Act^._Free) > 2) then
                begin
                  P := NewHistoryItem('M', 'Minimize', umMinimize, True, P);
                  Inc(Y);
                end;
              end;
              pmExt:
              begin
                if ExternalDrive = xd157xEmu then
                begin
                  P := NewHistoryItem('H', 'Select head', umSelectHead, True, P);
                  Inc(Y);
                end;
                P := NewHistoryItem('U', 'User command', umUserCommand, True, P);
                Inc(Y);
              end;
            end;
          end;
        end;
        cfAutomatic:
        begin
          HistoryItem := Command;
          Act^.Prepare(SourceName, False, True, False);
          CBMDevNum := Act^.CopyCBMDev;
          Q := (Act^.CopyMode in [pmDOS, pmFile, pmLynx..pmFileZip, pmGCRDisk..pmSixZip]);
        end;
      end;
      if not Q then
      begin
        Act^.CopyFullName := AddToPath(Act^.CopyPath, Act^.CopyImageName, chDirSep);
        if CopyFileMode = cfSelected then
        begin
          L := BoxTitle;
          ForceUserTitle(L);
          C := DisplayUserMenu(L, Y, 0, 0, mtMenu, A, nil, True, True);
        end;
        if Act^.CopyMode = pmDOS then
        begin
          if HistoryItem = -1 then
          begin
            Q := True;
          end
          else
          begin
            W := CopiedSize;
            if ParseMenu(L, False) then
            begin
              Q := True;
            end
            else
            begin
              if NonEmptyLine(L) and (LowerCase(FileExt(L)) = MenuFileExt) then
              begin
                F := CutPath(L, chDirSep);
              end
              else
              begin
                CopiedSize := W;
                if Act^.Vis then SourceName := Act^.GetNamePtr(Act^.Cur)^ else SourceName := '';
                PutCommands(True, False, False, False, False);
                SingleCommand := False;
                ClearCommand := True;
                PopupMenu := True;
                EnterDOSShell;
                Q := True;
              end;
            end;
          end;
        end
        else
        begin
          Q := True;
          FileProcessed := False;
          case HistoryItem of
            umValidate:
            begin
              if Act^.CopyMode = pmExt then F := 'disk in drive ' + LeadingSpace(Act^.CBMDev, 1) + ':' else
                F := Act^.CopyFullName;
              if (CopyFileMode = cfAutomatic) or (Confirm(stEmpty, 'Do you wish to validate', F,
                ' '+ColorChar+'V'+ColorChar+'alidate ', stEmpty, stEmpty,
                nil, CurHelpCtx, True, DummyByte) = cmOK) then
              begin
                ClockOff;
                if Act^.CopyMode = pmExt then
                begin
                  D := InfoWin(stEmpty, 'Validating the disk', 'in drive ' +
                    LeadingSpace(Act^.CopyCBMDev, 1) + ':', stEmpty, 2);
                  if Act^.CopyGEOSFormat then
                  begin
                    ErrorWin(stEmpty, 'Can''t validate GEOS disks.', stEmpty, CurHelpCtx, sbNone);
                  end
                  else
                  begin
                    MouseOff;
                    if CheckDevice then
                    begin
                      FileProcessed := True;
                      N := CopyCmdExecMode;
                      if (N = cxWarp) and (CopyTransferMode = tmNormal) then N := cxTurbo;
                      case N of
                        cxNormal: OpenCBMChannel(saCommand, 'V0', True);
                        cxTurbo: if SendDriveProg(deBase, True) and SendDriveProg(deTurboDiskValidate, False) then
                          ExecDriveProg(deTurboDiskValidate, '0:*');
                        cxWarp:
                        begin
                          CopyFileMode := cfWildcard;
                          Act^.NamePattern := stAllFilesUnix;
                          ValidateDisk(True);
                        end;
                      end;
                    end;
                    if not ReadCBMError(F, True, False, True) then ErrorWin(stError, F, stEmpty, CurHelpCtx, sbNone);
                  end;
                  Dispose(D, Done);
                end
                else
                begin
                  D := InfoWin(stEmpty, 'Validating the file', Act^.CopyFullName, stEmpty, 2);
                  if CheckImage and CheckReadOnly then
                  begin
                    B := Act^.CopyBackupFile(True);
                    if B and (Act^.OpenImage(True, False, True, True, True) = 0) then
                    begin
                      FileProcessed := True;
                      case Act^.CopyMode of
                        pmDisk:
                        begin
                          InitBAM(Act, False, True, N, N, N);
                          ValidateDir;
                          Act^.Track := Act^.DirTrack;
                          Act^.Sector := 0;
                          Act^.Validate(alAllocate, False, False, True, 0);
                          if Act^.CopyGEOSFormat then
                          begin
                            T := Act^.BAM[GEOSBorderPos];
                            S := Act^.BAM[GEOSBorderPos + 1];
                            Act^.Track := T;
                            Act^.Sector := S;
                            Act^.AllocBlock(T, S, True);
                            Act^.ReadDiskBlock(T, S, @Act^.DirBuffer, True);
                            Act^.DirSector := S;
                            Act^.Number := MaxByte;
                            ValidateDir;
                            Act^.WriteDiskBlock(T, S, @Act^.DirBuffer);
                          end;
                          Act^.WriteBAM;
                        end;
                        pmTape:
                        begin
                          while Act^.ReadCBMEntry(Entry) do
                          begin
                            C := Act^.DirPos;
                            V := Act^.ImagePos;
                            B := Act^.ReadCBMEntry(Entry);
                            Act^.DirPos := C;
                            V := Act^.ImagePos - V;
                            Act^.ReadTapeBlock(C, @Act^.DirBuffer);
                            Inc(V, BytesToLongint(Act^.DirBuffer[2], Act^.DirBuffer[3], 0, 0));
                            Act^.DirBuffer[4] := Lo(V);
                            Act^.DirBuffer[5] := Hi(V);
                            Act^.WriteTapeBlock(C, @Act^.DirBuffer);
                          end;
                          Act^.ReadTapeBlock(1, @Act^.DirBuffer);
                          Act^.DirBuffer[4] := LonglongintToLongint(Act^._Free) - 2;
                          Act^.WriteTapeBlock(1, @Act^.DirBuffer);
                        end;
                      end;
                    end;
                    Act^.CloseImage(True);
                    B := (IOResult = 0);
                    Act^.MakeBackupFile(B);
                  end;
                  Dispose(D, Done);
                end;
                if FileProcessed then RereadPanels else ClockOn;
                Q := True;
              end;
            end;
            umClean, umSafeClean:
            begin
              O := (HistoryItem = umSafeClean);
              L := '';
              if O then F := ' safe' else F := '';
              if (CopyFileMode = cfAutomatic) or (Confirm(stEmpty, 'Do you wish to' + F + ' clean',
                Act^.CopyFullName, ' '+ColorChar+'C'+ColorChar+'lean ',
                stEmpty, stEmpty, nil, CurHelpCtx, True, DummyByte) = cmOK) then
              begin
                F := '';
                ClockOff;
                case Act^.CopyMode of
                  pmDisk:
                  begin
                    if O then F := 'safe ';
                    F := F + 'cleaning the file';
                    F[1] := UpCase(F[1]);
                    D := InfoWin(stEmpty, F, Act^.CopyFullName, stEmpty, 2);
                    if CheckImage and CheckReadOnly then
                    begin
                      Locations := New(PLocBuffer);
                      Locations2 := New(PLocBuffer);
                      ScanOwners(False);
                      B := Act^.CopyBackupFile(True);
                      if B and (Act^.OpenImage(True, False, True, True, True) = 0) then
                      begin
                        if Act^.IsBAMValid then
                        begin
                          W := 0;
                          G := FirstDirSec(Act^.CopyDiskType);
                          B := False;
                          CurLoc := 0;
                          while not B and (W < G) do
                          begin
                            B := Act^.IsBlockUsed(Act^.DirTrack, W);
                            Inc(W);
                          end;
                          FillFormatPattern(@DataBuffer);
                          Act^.Track := Act^.FirstTrack;
                          W := Act^.DiskPos(Act^.Track, 0) shl 8;
                          ExtSeek(Act^.Image, W);
                          while Act^.Track < Act^.LastTrack do
                          begin
                            if O and (Act^.Track = Act^.DirTrack) then
                            begin
                              Inc(W, Act^.SectorNum(Act^.Track) shl 8);
                              Inc(CurLoc, Act^.SectorNum(Act^.Track) shl 1);
                              ExtSeek(Act^.Image, W);
                            end
                            else
                            begin
                              N := Act^.SectorNum(Act^.Track);
                              S := 0;
                              while S < N do
                              begin
                                if Act^.IsBlockUsed(Act^.Track, S) then
                                begin
                                  ExtBlockRead(Act^.Image, UndoBuffer, 256);
                                  if (Locations^[CurLoc].Track <> MaxByte) and (Locations^[CurLoc].Sector <> MaxByte) then
                                  begin
                                    T := UndoBuffer[1];
                                    if (UndoBuffer[0] = 0) and (T < MaxByte) then
                                    begin
                                      Move(DataBuffer[T + 1], UndoBuffer[T + 1], 255 - T);
                                      ExtSeek(Act^.Image, W);
                                      ExtBlockWrite(Act^.Image, UndoBuffer, 256);
                                    end;
                                  end;
                                end
                                else
                                begin
                                  if ((Act^.Track = Act^.DirTrack) and (S = G)) or ((Act^.CopyGEOSFormat) and
                                    (Act^.Track = Act^.BAM[GEOSBorderPos]) and (S = Act^.BAM[GEOSBorderPos + 1])) then
                                  begin
                                    FillChar(UndoBuffer, 256, 0);
                                    UndoBuffer[1] := MaxByte;
                                    ExtBlockWrite(Act^.Image, UndoBuffer, 256);
                                  end
                                  else
                                  begin
                                    ExtBlockWrite(Act^.Image, DataBuffer, 256);
                                  end;
                                end;
                                Inc(S);
                                Inc(CurLoc, 2);
                                Inc(W, 256);
                              end;
                            end;
                            Inc(Act^.Track);
                          end;
                        end
                        else
                        begin
                          ErrorWin(stEmpty, 'The following image file has an invalid BAM',
                            Act^.CopyFullName, CurHelpCtx, sbNone);
                        end;
                      end;
                      if not B then
                      begin
                        InitBAM(Act, Act^.CopyGEOSFormat, False, T, S, G);
                        Act^.WriteBAM;
                      end;
                      Act^.CloseImage(True);
                      B := (IOResult = 0);
                      Act^.MakeBackupFile(B);
                      Dispose(Locations2);
                      Dispose(Locations);
                    end;
                    Dispose(D, Done);
                  end;
                end;
                if B then RereadPanels;
              end;
            end;
            umProtectToggle, umProtect, umUnprotect:
            begin
              if Act^.OpenImage(False, True, True, True, True) = 0 then Act^.CloseImage(False);
              F := DiskTypeSignature(Act^.CopyDiskType, Act^.ExtBAMMode);
              B := (Act^.BAM[2] <> 0) and (Act^.BAM[2] <> Ord(F[2]));
              case HistoryItem of
                umProtectToggle: E := not B;
                umProtect: E := True;
                umUnprotect: E := False;
              end;
              if (E <> B) and ((CopyFileMode = cfAutomatic) or (SureConfirm(stEmpty,
                'The following disk is ' + ProtectStr(B) + 'ed.', Act^.CopyFullName,
                'Do you wish to ' + ProtectStr(E) + ' it?', stEmpty, stYes, stEmpty, stEmpty, stEmpty, stNo,
                nil, CurHelpCtx, ayNone, False, DummyByte) = cmOK)) and CheckImage and CheckReadOnly then
              begin
                Act^.OpenImage(True, True, True, True, True);
                Act^.BAM[2] := Ord(F[2]) + Byte(E);
                Act^.WriteBAM;
                Act^.CloseImage(True);
              end;
            end;
            umFormat:
            begin
              B := False;
              E := True;
              L := '';
              case CopyFileMode of
                cfSelected: DestName := '';
                cfAutomatic:
                begin
                  E := False;
                  if (Act^.CopyMode = pmDisk) and Act^.CopyGEOSFormat then
                    Act^._Label := DestName else
                    Act^._Label := ReconvertCBMName(DestName, False, True, hxPercent);
                  if Act^.CopyMode = pmDisk then Act^.SetBAMLabel(Act^._Label);
                end;
              end;
              case Act^.CopyMode of
                pmExt: B := (FormatDisk(Act, E, E, E) = 0);
                pmDisk, pmTape:
                begin
                  Act^.NewMode := Act^.CopyMode;
                  Act^.RealImagePath := Act^.CopyImagePath;
                  F := Act^.CopyFullName;
                  if (CopyFileMode = cfAutomatic) or (Confirm(stEmpty, 'Do you wish to format', F,
                    ' '+ColorChar+'F'+ColorChar+'ormat ', stEmpty, stEmpty,
                    nil, CurHelpCtx, True, DummyByte) = cmOK) then
                  begin
                    ClockOff;
                    D := InfoWin(stEmpty, 'Formatting the file', F, stEmpty, 2);
                    if CheckReadOnly then if not FormatFile(True, Act^.CopyGEOSFormat) then
                      ErrorWin(stEmpty, 'Can''t format the image file', F, CurHelpCtx, sbNone);
                    Dispose(D, Done);
                  end;
                end;
              end;
              if B then RereadPanels;
            end;
            umMinimize:
            begin
              if Act^.OpenImage(False, True, True, True, True) = 0 then
              begin
                while Act^.ReadCBMEntry(Entry) do;
                Act^.CloseImage(False);
              end;
              B := False;
              F := Act^.CopyFullName;
              if (CopyFileMode = cfAutomatic) or (Confirm(stEmpty, 'Do you wish to minimize', F,
                ' '+ColorChar+'M'+ColorChar+'inimize ', stEmpty, stEmpty,
                nil, CurHelpCtx, True, DummyByte) = cmOK) then
              begin
                ClockOff;
                D := InfoWin(stEmpty, 'Minimizing the file', F, stEmpty, 2);
                if CheckImage and CheckReadOnly and
                  not ExpandTape(Act, LonglongintToLongint(Act^.CopyFree) - Act^.CopyImageSize - 2, True) then
                  ErrorWin(stEmpty, 'Can''t minimize the image file', F, CurHelpCtx, sbNone);
                Dispose(D, Done);
                if B then RereadPanels;
              end;
            end;
            umBadSectors:
            begin
              if Act^.OpenImage(False, True, False, True, True) = 0 then
              begin
                B := (Act^.CopyDiskType and dtErrorInfo > 0);
                Act^.CopyDiskType := Act^.CopyDiskType and dtTypeMask;
                C := Act^.DiskPos(Act^.MaxTrack, 0);
                ExtSeek(Act^.Image, Longint(C) shl 8);
                ExtBlockRead(Act^.Image, TempBuffer, C);
                for C := 1 to Act^.Max - 1 do
                begin
                  Act^.Track := Act^.Dir[C].Track;
                  Act^.Sector := Act^.Dir[C].Sector;
                  Act^.Dir[C].Status := Byte(B and not Act^.Validate(alBadSectors, ((Act^.DiskType and dtTypeMask = dt1581) and
                    (Entry.Attr and faTypeMask = faPartition)), (Entry.ExtAttr and xaGEOSVLIR > 0), False,
                    Entry.Size)) * fsSelected;
                  Act^.DrawPanel;
                end;
                ExtClose(Act^.Image);
              end;
            end;
            umSelectHead:
            begin
              P := NewHistoryItem('0', 'Head 0', 0, True, nil);
              A := P;
              P := NewHistoryItem('1', 'Head 1', 1, True, P);
              if DisplayUserMenu(stEmpty, 2, 0, 0, mtMenu, A, nil, True, True) = cmOK then
              begin
                OpenCBMChannel(saCommand, 'U0' + Chr(Ord('>') or $80) + 'H' + Chr(HistoryItem + Ord('0')), True);
                RereadPanels;
              end;
            end;
            umUserCommand:
            begin
              if CopyFileMode = cfSelected then
              begin
                DestName := '';
                if not Act^.GetFileName(stEmpty, 'Send command to drive ' + LeadingSpace(Act^.CBMDev, 1) + ':', stEmpty,
                  nil, nil, False, False, True, False, False, False, eeNone, aaNone) then
                  DestName := '';
              end;
              if DestName <> '' then
              begin
                ClockOff;
                MouseOff;
                F := ReconvertCBMName(DestName, False, True, hxPercent);
                D := InfoWin(stEmpty, 'Sending command to', 'drive ' + LeadingSpace(Act^.CopyCBMDev, 1) + ':', stEmpty, 2);
                if CheckDevice then OpenCBMChannel(saCommand, F, True);
                B := ReadCBMError(F, True, False, True);
                if Status and (ssNoDevice + ssTimeout) = 0 then F := MakeCBMName(F, False);
                ErrorWin('Status', F, stEmpty, CurHelpCtx, sbNone);
                Dispose(D, Done);
                MouseOn;
                ClockOn;
                RereadPanels;
              end;
            end;
          end;
        end;
      end;
    end;
  end;
  RestoreHelpCtx;
  NextBatchCommand;
end;

end.
