
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Turbo Vision Unit                               }
{                                                       }
{       Copyright (c) 1992 Borland International        }
{                                                       }
{*******************************************************}

unit Validate;

{$A+,B-,D+,E-,F+,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Objects;

type

{ Abstract TValidator object }

  PValidator = ^TValidator;
  TValidator = object(TObject)
    procedure Error; virtual;
    function IsValidInput(var S: string; SuppressFill: Boolean): Boolean; virtual;
    function IsValid(const S: string): Boolean; virtual;
    function Valid(const S: string): Boolean;
  end;

implementation

{ TValidator }

procedure TValidator.Error;
begin
end;

function TValidator.IsValidInput(var S: string; SuppressFill: Boolean): Boolean;
begin
  IsValidInput := True;
end;

function TValidator.IsValid(const S: string): Boolean;
begin
  IsValid := True;
end;

function TValidator.Valid(const S: string): Boolean;
begin
  Valid := False;
  if not IsValid(S) then
  begin
    Error;
    Exit;
  end;
  Valid := True;
end;

end.
