
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    XFERLO.PAS                   }
{                                                 }
{ The Star Commander file transfer low-level unit }
{*************************************************}

unit XferLo;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Dialogs,
  Panel1;

const
{External program execution modes}
  exNormal      = 0;
  exOpenRead    = 1;
  exCloseWrite  = 2;
{Directory modes for progress indicator box}
  drFile        = 0;
  drDirectory   = 1;
  drSubdir      = 2;

function AllFiles(const Name: string): Boolean;
function CopyInfoWin(const Title: string; Text, File1, File2, IndText: string): PDialog;
procedure TransferProgressWin(var D: PDialog; const Title, Src, Dest: string; Dir: Byte; Ind: Boolean);
procedure ProgressWin(var D: PDialog; const Title, Src, Dest: string; Dir,Ind: Boolean);
function DirEmpty(Panel: PPanel): Boolean;
procedure EnterDir(Panel: PPanel);
procedure LeaveDir(Panel: PPanel);
procedure NoTwoDrives;

implementation

uses
  App, DOS, Drivers, Objects, Views,
  Base1, Base2, Constant, ExtFiles, Panel2;

{Determine if a file name pattern represents all the files
  Output: when True, all the files are to be processed}
function AllFiles(const Name: string): Boolean;
begin
  AllFiles := (((Act^.CopyMode = pmDOS) and AllDOSFiles(Name)) or
    ((Act^.CopyMode <> pmDOS) and (Name = stAllFilesUnix) and (LeftPos('=', Name) = 0)));
end;

{Display a file copy progress information window on the screen
  Input : Title: the title of the dialog box
          Text: the first line of information
          File1: the source file name
          File2: the destination file name
          IndText: the progress indicator (not displayed if empty)
  Output: the dialog box}
function CopyInfoWin(const Title: string; Text, File1, File2, IndText: string): PDialog;
var
  X,
  Y             : Integer;
  D             : PDialog;
  T             : string;
  R             : TRect;
begin
  if IndText <> '' then if IndText = stSpace then Y := 5 else Y := 6 else Y := 4;
  ErrorDown := 6;
  if File2 = '' then
  begin
    Dec(Y, 2);
    Dec(ErrorDown, 2);
  end;
  T := Title;
  if T = '' then T := BoxTitle;
  Text := LimitNameLen(Text, MaxNameLen);
  File1 := LimitNameLen(File1, MaxNameLen);
  File2 := LimitNameLen(File2, MaxNameLen);
  X := Length(T) + 4;
  if X < CStrLen(Text) then X := CStrLen(Text);
  if X < CBMStrLen(File1) then X := CBMStrLen(File1);
  if X < CBMStrLen(File2) then X := CBMStrLen(File2);
  if IndText = stSpace then
  begin
    if X < 24 then X := 24;
  end
  else
  begin
    if X < CStrLen(IndText) then X := CStrLen(IndText);
  end;
  MakeWinBounds(R, X + 2, Y);
  D := New(PDialog, Init(R, T, fxNormal, fyNormal, False));
  R.Assign((X - CStrLen(Text) + Justify) shr 1 + 5, 2, CStrLen(Text), 1);
  D^.Insert(New(PStaticText, Init(R, Text)));
  R.Assign((X - CBMStrLen(File1) + Justify) shr 1 + 5, 3, CBMStrLen(File1), 1);
  D^.Insert(New(PCBMText, Init(R, File1)));
  if File2 <> '' then
  begin
    R.Assign((X - 2 + Justify) shr 1 + 5, 4, 2, 1);
    D^.Insert(New(PCBMText, Init(R, 'to')));
    R.Assign((X - CBMStrLen(File2) + Justify) shr 1 + 5, 5, CBMStrLen(File2), 1);
    D^.Insert(New(PCBMText, Init(R, File2)));
  end;
  CopyInd := nil;
  if IndText <> '' then
  begin
    if IndText = stSpace then
    begin
      IndicatorLen := X;
      FillChar(IndText[1], IndicatorLen, SelectionChars[1]);
      IndText[0] := Chr(IndicatorLen);
      R.Assign(5, Y + 1, CStrLen(IndText), 1);
    end
    else
    begin
      IndicatorLen := 0;
      R.Assign((X - CStrLen(IndText) + Justify) shr 1 + 5, Y + 1, CStrLen(IndText), 1);
    end;
    CopyInd := New(PStaticText, Init(R, IndText));
    D^.Insert(CopyInd);
  end;
  CopyInfoWin := D;
end;

{Display the progress indicator box
  Input : D: the dialog box to create
          Title: title of the dialog box
          Src: the source file name
          Dest: the destination file name
          Dir: when True, a directory is being processed; otherwise a file
          Ind: when True, an indicator is put to the bottom}
procedure ProgressWin(var D: PDialog; const Title, Src, Dest: string; Dir,Ind: Boolean);
var
  E             : PDialog;
  P             : PView;
  I             : string[10];
  N,
  S,
  T             : string;
begin
  I := '';
  if Ind then
  begin
    if ExtDrive then
    begin
      I := 'Block:' + LeadingSpace(CopiedBlock, 4);
    end
    else
    begin
      if not Dir then I := stSpace;
    end;
  end;
  E := D;
  D := CopyInfoWin(stEmpty, Title, Src, Dest, I);
  if Ind then DisplayProgress;
  if E = nil then
  begin
    Application^.Insert(D);
  end
  else
  begin
    D^.Hide;
    Application^.InsertView(D, E);
    Application^.RemoveView(E);
    D^.Show;
    Dispose(E, Done);
  end;
end;

{Display the copy progress indicator box
  Input : D: the dialog box to create
          Title: title of the dialog box
          Src: the source file name
          Dest: the destination file name
          Dir: when 0, a file is being processed; when 1, a directory is
               being processed; when 2, a subdirectory of the current
               directory is being processed
          Ind: when True, an indicator is put to the bottom}
procedure TransferProgressWin(var D: PDialog; const Title, Src, Dest: string; Dir: Byte; Ind: Boolean);
var
  S             : string[20];
  T             : string;
begin
  T := Title;
  if T = '' then T := BoxTitle;
  if UpCase(T[Length(T)]) = 'E' then Dec(T[0]);
  T := T + 'ing the ';
  if Dir = drFile then S := stFile else S := stDirectory;
  if Dir = drSubdir then S := 'sub' + S;
  T := T + S;
  ProgressWin(D, T, Src, Dest, (Dir <> drFile), Ind);
end;

{Determine if the specified directory is empty
  Input : the panel that holds the directory to be deleted
  Output: when True, the directory is empty}
function DirEmpty(Panel: PPanel): Boolean;
var
  E             : ExtSearchRec;
begin
  LongFindFirst(AddToPath(Panel^.CopyPath, stAllFilesDOS, chDirSep), Archive + ReadOnly + SysFile + Hidden + Directory, E);
  while ((E.LongName = stCurrentDir) or (E.LongName = stParentDir)) and (DOSError = 0) do LongFindNext(E);
  LongFindClose(E);
  DirEmpty := (DOSError <> 0);
end;

{Updates variables of a panel upon entering a directory
  Input : Panel: the panel whose variables are to be updated}
procedure EnterDir(Panel: PPanel);
begin
  Panel^.FirstFile := True;
  Panel^.CopyPath := LongName(AddToPath(Panel^.CopyPath, AddToPath(Panel^.CopyName, stEmpty, chDirSep), chDirSep), True);
  if DirNameGiven or (CopyFileMode = cfSelected) then Panel^.NamePattern := stAllFilesDOS;
  IncludeSubdirs := True;
  CopyFileMode := cfWildcard;
end;

{Updates variables of a panel upon leaving a directory
  Input : Panel: the panel whose variables are to be updated}
procedure LeaveDir(Panel: PPanel);
begin
  ContDirProcess := True;
  Panel^.FirstFile := False;
  Panel^.CopyName := CutPath(Panel^.CopyPath, chDirSep);
  Panel^.CopyPath := GetPath(Panel^.CopyPath, chDirSep);
  Panel^.MakeFullName;
end;

{Display an error message about being unable to copy between Commodore drives}
procedure NoTwoDrives;
begin
  if Act^.CopyCBMDev = Inact^.CopyCBMDev then ErrorWin(stEmpty, 'Can''t copy onto the same external drive.', stEmpty,
    CurHelpCtx, sbNone) else ErrorWin(stEmpty, 'Can''t handle two external drives.', stEmpty, CurHelpCtx, sbNone);
end;

end.
