
-- Drop phantom users from a MS-SQL 7.0/2000 database
-- by Joe Forster/STA (2005-06-01)
-- sta@c64.org, http://sta.c64.org
--
-- Description
--
-- This script drops "phantom" users: ones that are not related to logins. If
-- you add users to a database and then restore an older database that does
-- not contain them, the users will be lost and thus the connection between
-- the database and the repective logins will break. As a result of this
-- administrative problem, you will be unable to drop the users in Enterprise
-- Manager - as they are not displayed there anymore - but you won't be able
-- to add the users again either - as they still exist in the database.
--
-- Copyright
--
-- This script has been donated to the public domain. Feel free to do anything
-- you like with it but make sure to give proper credits.

declare @@usrname sysname
declare usrcursor cursor for
  select name
    from sysusers
    where uid > 1
      and uid not between 16382 and 16399
      and issqlrole = 0
      and hasdbaccess <> 0
      and not exists (select * from master..syslogins syslogins
        where sysusers.sid = syslogins.sid)
    order by name
open usrcursor
fetch next from usrcursor into @@usrname
while @@fetch_status <> -1
begin
  print 'Dropping user "' + @@usrname + '"...'
  exec sp_dropuser @@usrname
  fetch next from usrcursor into @@usrname
end
close usrcursor
deallocate usrcursor
GO
