
/* err2out.c
 *
 * Runs a shell command, redirecting its standard error to standard output (as
 * standard error cannot be redirected on the command line of non-NT Windowses
 * with the "command 2> filename" or any other syntax).
 *
 * Joe Forster/STA, sta@c64.org (2004-03-21)
 *
 * Released into the public domain. Do whatever you like to do with it.
 *
 */

#include <io.h>
#include <stdlib.h>
#include <string.h>

#define MaxCommandLineLength 32768

typedef char* string;

int Index;
char CommandLine[MaxCommandLineLength];
string CmdLine;

int main(int argc, string argv[])
{
  dup2(fileno(stdout), fileno(stderr));
  if (stderr != NULL)
  {
    CommandLine[0] = '\0';
    CmdLine = CommandLine;
    for (Index = 1; Index < argc; Index++)
    {
      if (Index > 1)
        CmdLine = strcat(CmdLine, " ");
      CmdLine = strcat(CmdLine, argv[Index]);
    }
    system(CommandLine);
  }
  else
    exit(-1);
  return(errno);
}
