
/* unwrap1.c
 *
 * Reads standard input and copies it to standard the output. If the BOL
 * marker char(1) is missing from the beginning of a line, it is appended to
 * the previous line. If the EOL marker char(1) is missing from the end of a
 * line, that is followed by a line beginning with the BOL marker, a warning
 * "--!TRUNCATED!" is added about that line having been truncated.
 *
 * Joe Forster/STA, sta@c64.org (2004-07-28)
 *
 * Released into the public domain. Do whatever you like to do with it.
 *
 */

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define byte unsigned char
#define bool unsigned char
#define false (0 == 1)
#define true (0 == 0)

#define MaxLineLength 32768

typedef char* string;

bool FirstLine,
  EOLInCurLine,
  EOLInPrevLine;
int LineLen;
char Line[MaxLineLength];

bool ReadLine(FILE* ReadFile, string Line)
{
  char* CurLine = Line;
  int Read = false;
  while (!feof(ReadFile))
  {
    fread(CurLine, sizeof(char), 1, ReadFile);
    if (!feof(ReadFile))
    {
      Read = true;
      if (*CurLine == '\n')
        break;
      else if (*CurLine != '\r')
        CurLine++;
    }
  }
  *CurLine = '\0';
  return(Read);
}

int main(int argc, string argv[])
{
  FirstLine = true;
  EOLInCurLine = true;
  while (!feof(stdin))
  {
    ReadLine(stdin, Line);
    if (!feof(stdin) || Line[0] != '\0')
    {
      EOLInPrevLine = EOLInCurLine;
      EOLInCurLine = ((LineLen = strlen(Line)) > 1 && Line[LineLen - 1] == '\001');
      if (EOLInCurLine)
        Line[LineLen - 1] = '\0';
      if (Line[0] == '\001')
      {
        if (!FirstLine)
          fprintf(stdout, "\n");
        if (!EOLInPrevLine)
          fprintf(stdout, "--!TRUNCATED!\n");
        fprintf(stdout, "%s", &Line[1]);
      }
      else
        fprintf(stdout, " %s", Line);
      FirstLine =  false;
    }
  }
  fprintf(stdout, "\n");
  exit(0);
}
