
/* losort.c
 *
 * Sorts each block in the output of LISTOBJ.SQL - from the same author - into
 * a separate file.
 *
 * Joe Forster/STA, sta@c64.org (2004-07-28)
 *
 * Released into the public domain. Do whatever you like to do with it.
 *
 */

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define bool unsigned char
#define false (0 == 1)
#define true (0 == 0)

#define TypeNum 5
#define MaxLineLength 32768
#define MaxFileNameLength 255
#define DirSep '\\'
#define BlockHeaderPart1 "-- !NeWoBjEcT! Object: "
#define BlockHeaderPart2 "; Type: "
#define CommonExt ".sql"

typedef char* string;

const string TypeNames[TypeNum] = {"role", "user", "table", "view", "procedure"};
const string TypeExts[TypeNum] = {".rol", ".usr", ".tab", ".viw", ".prc"};

bool NoEmptyFiles,
  NoTypeExts,
  NoOwnerNames,
  LineRead,
  FileOpen,
  FileOpenTried;
int Index,
  FileNumber,
  NumberLength;
char NumberPrefix[10];
char Line[MaxLineLength];
char OrigFileName[MaxFileNameLength],
  FileType[MaxFileNameLength],
  OutputDir[MaxFileNameLength];
string CurLine,
  FileName;
FILE* OutputFile;

bool ReadLine(FILE* ReadFile, string Line)
{
  char* CurLine = Line;
  int Read = false;
  while (!feof(ReadFile))
  {
    fread(CurLine, sizeof(char), 1, ReadFile);
    if (!feof(ReadFile))
    {
      Read = true;
      if (*CurLine == '\n')
        break;
      else if (*CurLine != '\r')
        CurLine++;
    }
  }
  *CurLine = '\0';
  return(Read);
}

string ReadQuotedString(string Str, string Line)
{
  char* CurLine = Line;
  int Quoted = false;
  while (*CurLine != '\0' && (Quoted || *CurLine != ' '))
  {
    if (*CurLine == '"')
      Quoted = !Quoted;
    else
    {
      *Str = *CurLine;
      Str++;
    }
    CurLine++;
  }
  *Str = '\0';
  return(CurLine);
}

void AddToPath(string Path, const string Dir, const string Name)
{
  int Len;
  Path[0] = '\0';
  if (Dir != NULL)
    strcpy(Path, Dir);
  if (Name != NULL)
  {
    Len = strlen(Path);
    if (Len > 0 && Path[Len - 1] != DirSep)
    {
      Path[Len] = DirSep;
      Path[Len + 1] = '\0';
    }
    strcat(Path, Name);
  }
}

void OpenFile(void)
{
  FileOpenTried = true;
  if ((OutputFile = fopen(FileName, "wt")) != NULL)
  {
    FileOpen = true;
    printf("%s\n", FileName);
  }
}

int main(int argc, string argv[])
{
  for (Index = 1; Index < argc; Index++)
  {
    if (argv[Index][0] == '-')
    {
      switch (tolower(argv[Index][1]))
      {
        case 'd':
          if (Index < argc - 1)
            strcpy(OutputDir, argv[++Index]);
          break;
        case 'e':
          NoEmptyFiles = true;
          break;
        case 'n':
          if (Index < argc - 1)
            sscanf(argv[++Index], "%d", &NumberLength);
          break;
        case 'o':
          NoOwnerNames = true;
          break;
        case 'x':
          NoTypeExts = true;
          break;
      }
    }
  }
  while (!feof(stdin))
  {
    LineRead = ReadLine(stdin, Line);
    if (strncmp(Line, BlockHeaderPart1, strlen(BlockHeaderPart1)) == 0)
    {
      if (FileOpen)
      {
        fclose(OutputFile);
        FileOpenTried = false;
        FileOpen = false;
      }
      CurLine = ReadQuotedString(OrigFileName, &Line[strlen(BlockHeaderPart1)]);
      FileName = OrigFileName;
      if (NoOwnerNames)
      {
        while (*FileName != '\0' && *FileName != '.')
          FileName++;
        if (*FileName == '\0')
          FileName = OrigFileName;
        else
          FileName++;
      }
      ReadQuotedString(FileType, &CurLine[strlen(BlockHeaderPart2)]);
      for (Index = 0; Index < TypeNum && strcmp(FileType, TypeNames[Index]) != 0; Index++);
      if (Index < TypeNum)
      {
        FileType[0] = '\0';
        if (NumberLength > 0)
        {
          sprintf(NumberPrefix, "%%0%dd_", NumberLength);
          sprintf(FileType, NumberPrefix, ++FileNumber);
        }
        strcat(FileType, FileName);
        if (NoTypeExts)
          strcat(FileType, CommonExt);
        else
          strcat(FileType, TypeExts[Index]);
        AddToPath(FileName, OutputDir, FileType);
        if (!NoEmptyFiles)
          OpenFile();
      }
      else
        FileOpenTried = true;
    }
    else if (LineRead)
    {
      if (!FileOpen && !FileOpenTried)
        OpenFile();
      if (FileOpen)
        fprintf(OutputFile, "%s\n", Line);
    }
  }
  return(errno);
}
