
/* oem2ansi.c
 *
 * Converts the output from the current DOS OEM code page to the current
 * Windows ANSI code page.
 *
 * Joe Forster/STA, sta@c64.org (2004-07-15)
 *
 * Released into the public domain. Do whatever you like to do with it.
 *
 */

#include <stdio.h>
#include <wtypes.h>
#include <winuser.h>

#define byte unsigned char
#define bool unsigned char
#define false (0 == 1)
#define true (0 == 0)

#define MaxLineLength 32768

typedef char* string;

char Line[MaxLineLength];

bool ReadLine(FILE* ReadFile, string Line)
{
  char* CurLine = Line;
  int Read = false;
  while (!feof(ReadFile))
  {
    fread(CurLine, sizeof(char), 1, ReadFile);
    if (!feof(ReadFile))
    {
      Read = true;
      if (*CurLine == '\n')
        break;
      else if (*CurLine != '\r')
        CurLine++;
    }
  }
  *CurLine = '\0';
  return(Read);
}

int main(int argc, string argv[])
{
  while (!feof(stdin))
  {
    ReadLine(stdin, Line);
    if (!feof(stdin) || Line[0] != '\0')
    {
      OemToAnsi(Line, Line);
      fprintf(stdout, "%s\n", Line);
    }
  }
  exit(0);
}
