;Ŀ
;                 Joe Forster/STA                 
;                                                 
;                    LFNDIR.ASM                   
;                                                 
;       VFAT Directory Lister (test module)       
;

		jumps				;Autodetect branch distance

;ForceLongNames	equ	Yes			;Force the display of long
						; file name even if it is a
						; duplicate of short file name
;MakeListFile	equ	Yes			;List only files with long
						; file names and format output
						; to the form of LONGNAME.DAT

;Boolean constants
False		equ	0			;False
True		equ	1			;True

;Special characters
chTab		equ	9			;Tab
chLF		equ	10			;Line feed
chCR		equ	13			;Carriage return

;LFN directory entry flags (for byte at offset 0)
leDeleted	equ	80h			;LFN entry deleted flag
leLast		equ	40h			;Last LFN entry flag
leNumMask	equ	3Fh			;LFN entry number mask

;SFN directory entry values (for byte at offset 0)
seDeleted	equ	0E5h			;SFN entry deleted flag
seReplaceE5h	equ	05h			;SFN replacement for E5h char

;Directory entry attributes
faReadOnly	equ	01h			;Attribute of read-only files
faHidden	equ	02h			;Attribute of hidden files
faSystem	equ	04h			;Attribute of system files
faVolLabel	equ	08h			;Attribute of volume labels
faLFN		equ	0Fh			;Attribute of LFN entries
faDirectory	equ	10h			;Attribute of directories
faArchive	equ	20h			;Attribute of files to archive

;File search allowed attributes
faNormalFile	equ	37h			;Attribute of normal files
faAnyFile	equ	3Fh			;Attribute of any files

;Miscellaneous constants
LFNCharPerEntry	equ	13			;LFN chars per directory entry

;Data structure sizes
SFNNameLen	equ	8			;Short name length
SFNExtLen	equ	3			;Short extension length
EntrySize	equ	32			;Length of directory entry
EntryShift	equ	5			;Shift count for entry length
ShortNameLen	equ	12			;Length of short file names
LongNameLen	equ	255			;Length of long file names
MaxSectorSize	equ	512			;Maximum sector size
ProgramSize	equ	2048 + (MainEnd - DataEnd)

;DOS short file name search record
ShortSearchRec	struc
ssSearchDrive	db	?			;Search drive (bits 0-6)
						;Search file name pattern
ssSearchName	db	SFNNameLen + SFNExtLen dup (?)
ssSearchAttr	db	?			;Search allowed attributes
ssSearchEntry	dw	?			;Current offset into cluster
ssSearchCluster	dw	?			;Current directory cluster
ssReserved	db	4 dup (?)
ssAttr		db	?			;Current file attributes
ssDate		dd	?			;Current file date stamp
ssSize		dd	?			;Current file size
						;Current file name
ssName		db	SFNNameLen + SFNExtLen + 2 dup (?)
ShortSearchRec	ends

;Directory entry on the disk
DirEntry	struc
deName		db	SFNNameLen dup (?)	;File name
deExt		db	SFNExtLen dup (?)	;File extension
deAttr		db	?			;File attributes
deReserved1	db	?
deChecksum	db	?			;LFN checksum for short alias
deReserved2	db	8 dup (?)
deDate		dd	?			;File date stamp
deFirstCluster	dw	?			;First data cluster of file
deSize		dd	?			;File size
DirEntry	ends

;Device parameter block
DeviceParBlock	struc
dbSpecialFunc	db	?
dbDeviceType	db	?
dbDeviceAttr	dw	?
dbCylinderNum	dw	?
dbMediaType	db	?
;BIOS parameter block, part of the device parameter block
bbBIOSParBlock	label
bbBytePerSector	dw	?			;Number of bytes per sector
bbSectorPerClus	db	?			;Number of sectors per cluster
bbResSectorNum	dw	?			;Number of sectors before FAT
bbFATNum	db	?			;Number of FAT copies
bbRootDirLen	dw	?			;Number of root dir entries
bbSectorNum	dw	?			;Total number of sectors
bbMediaID	db	?			;Media descriptor byte
bbSectorPerFAT	db	?			;Number of sectors per FAT
bbSecPerTrack	dw	?			;Number of sectors per track
bbHeadNum	dw	?			;Number of heads
bbHiddenSecNum	dw	?			;Number of hidden sectors
bbExtSectorNum	dd	?			;Total number of sectors
bbReserved	db	6 dup (?)
bbCylinderNum	dw	?			;Number of cylinders
bbDeviceType	db	?			;Device type
bbDeviceAttr	db	?			;Device attributes
DeviceParBlock	ends

;Drive parameter block
DriveParBlock	struc
dpDrive		db	?			;Drive (0 for A: etc.)
dpUnit		db	?			;Unit into drive
dpBytePerSector	dw	?			;Number of bytes per sector
dpSectorPerClus	db	?			;Number of sectors per cluster
dpClusterShift	db	?			;Sectors per cluster shift
dpResSectorNum	dw	?			;Number of sectors before FAT
dpFATNum	db	?			;Number of FAT copies
dpRootDirLen	dw	?			;Number of root dir entries
dpFirstDataSec	dw	?			;First data sector
dpClusterNum	dw	?			;Number of clusters + 1
dpSectorPerFAT	dw	?			;Number of sectors per FAT
dpFirstDirSec	dw	?			;First root dir sector
dpDeviceHeader	dd	?			;Disk device header
dpMediaID	db	?			;Media descriptor byte
dpDiskAccessed	db	?			;Disk accessed flag
dpNextBlock	dd	?			;Next drive parameter block
dpFirstFreeClus	dw	?			;Start of free cluster search
dpFreeClusNum	dw	?			;Number of free clusters
DriveParBlock	ends
DrvParBlockSize	equ	(type DriveParBlock)

;Disk transfer block
DiskXferBlock	struc
dbFirstSector	dd	?			;First sector to transfer
dbSectorNum	dw	?			;Number of sectors to transfer
dbBuffer	dd	?			;Data buffer
DiskXferBlock	ends

;Current directory structure
CurDirStruc	struc
cdPath		db	67 dup (?)		;Real abs path of current dir
cdAttr		dw	?			;Drive attributes
cdDriveParBlock	dd	?			;Drive parameter block
cdCurDirCluster	dw	?			;First cluster of current dir
cdReserved1	db	4 dup (?)
cdRootDirLen	dw	?			;Length of root dir in path
cdDeviceType	db	?			;Device type for remote drives
cdRedirBlock	dd	?			;IFS/network redirector block
cdIFSData	dw	?			;Data area for IFS
CurDirStruc	ends
CurDirStrucSize	equ	(type CurDirStruc)

;Disk sector buffer
SectorBuffer	struc
		db	MaxSectorSize dup (?)
SectorBuffer	ends

CSeg		segment
		assume	cs:CSeg, ds:CSeg, ss:CSeg

;Command line buffer
		org	0080h
CommandLineLen	db	?			;Length of command line
CommandLine	db	127 dup (?)		;Command line data

		org	0080h

Search			ShortSearchRec <?>	;Default DTA

;Entry point
		org	0100h

Main:		mov	bx, (ProgramSize + 15) / 16
		mov	ah, 4Ah			;Shrink allocated area and
		int	21h			; setup stack pointer
		mov	sp, ProgramSize		; accordingly
		xor	ax, ax
		push	ax
		mov	di, Offset DataStart	;Clear data area
		mov	cx, DataEnd - DataStart
		xor	al, al
		cld
		rep	stosb
		push	es
		mov	ah, 52h			;Fetch the number of drives
		int	21h			; and the address of the
		mov	al, es:[bx][21h]	; current directory structures
		les	bx, es:[bx][16h]
		mov	LastDrive, al
		mov	word ptr CurDirStrucs[0], bx
		mov	word ptr CurDirStrucs[2], es
		pop	es
		call	ParseName
		mov	ah, 4Eh			;Get the first cluster of the
		mov	cx, 003Fh		; directory
		mov	dx, Offset SearchName
		int	21h
		jc	@01
		mov	al, Search.ssSearchDrive
		and	al, 7Fh
		dec	al
		mov	Drive, al		;Store drive number
		call	DrivePars
		jc	@01
		xor	ax, ax			;Clear abs FAT sector number
		mov	word ptr FATAbsSector[0], ax
		mov	word ptr FATAbsSector[2], ax
		mov	ax, Search.ssSearchCluster
		call	SaveDirCluster		;Read the first sector of the
		call	ReadDirSector		; directory
		jc	@01
		xor	ax, ax			;Initialize directory-specific
		mov	DirSector, ax		; variables
		sub	ax, EntrySize
		mov	DirOffset, ax
@02:		call	NextFile		;Read next file from the
		jc	@01			; directory and print it if
		call	PrintNames		; available
		jmp	@02
@01:		mov	ax, 4C00h
		int	21h

;Convert a character into uppercase
;  Input : AL: the original character
;  Output: AL: the uppercase character
UpCase:		cmp	al, 'a'			;If the character is between
		jb	@01_UpCase		; lowercase 'a' and 'z' then
		cmp	al, 'z'			; turn it into uppercase
		ja	@01_UpCase
		sub	al, 'a' - 'A'
@01_UpCase:	retn

;Convert a character into lowercase
;  Input : AL: the original character
;  Output: AL: the lowercase character
LoCase:		cmp	al, 'A'			;If the character is between
		jb	@01_LoCase		; uppercase 'a' and 'z' then
		cmp	al, 'Z'			; turn it into lowercase
		ja	@01_LoCase
		add	al, 'a' - 'A'
@01_LoCase:	retn

;Convert a string into uppercase
;  Input : DS:SI: the original string
;  Output: ES:DI: the destination string
UpperCase:	cld
@01_UpperCase:	lodsb				;Fetch a character from source
		call	UpCase			; string, turn into uppercase,
		stosb				; put into destination string,
		or	al, al			; go to next character if the
		jne	@01_UpperCase		; end of source not reached
		retn

;Convert a string into lowercase
;  Input : DS:SI: the original string
;  Output: ES:DI: the destination string
LowerCase:	cld
@01_LowerCase:	lodsb				;Fetch a character from source
		call	LoCase			; string, turn into lowercase,
		stosb				; put into destination string,
		or	al, al			; go to next character if the
		jne	@01_LowerCase		; end of source not reached
		retn

;Copy part of the short file name
;  Input : AH: when not zero, the extension is being copied
;          CX: the maximum length of the file name part
;          DS:SI: the source file name part
;          DS:DI: the destination file name
CopyName:	cld
		cmp	byte ptr [si], ' '	;If the file name part is not
		je	@01_CopyName		; empty and it is the extension
		or	ah, ah			; then prepend a dot
		je	@01_CopyName
		mov	al, '.'
		stosb
@01_CopyName:	lodsb
		cmp	al, ' '
		je	@02_CopyName
		stosb
		loop	@01_CopyName
@02_CopyName:	or	ah, ah			;If the extension was copied
		je	@03_CopyName		; then end the string
		xor	al, al
		stosb
@03_CopyName:	retn

;Determine if a character is a slash or a backslash
;  Input : AL: the character
;  Output: ZF: when not zero, the character is a slash or a backslash
IsSlash:	cmp	al, '\'
		je	@01_IsSlash
		cmp	al, '/'
@01_IsSlash:	retn

;Copy a string into another
;  Input : DS:SI: the source string
;          ES:DI: the destination string
StrCopy:	cld
@01_StrCopy:	lodsb				;Copy a character and go to the
		stosb				; next character if the end of
		or	al, al			; the source string was not
		jne	@01_StrCopy		; reached
		retn

;Append a file name to a path
;  Input : DS:SI: the original path
;          DS:BX: the original file name
;          ES:DI: the destination full file name
AddToPath:	cmp	byte ptr [si], 0
		je	@01_AddToPath
		call	StrCopy			;If path is not empty then copy
		dec	di			; it into destination
		mov	al, [di][-1]		;If the last character of the
		call	IsSlash			; path is no slash, backslash
		je	@01_AddToPath		; or colon then append a
		cmp	al, ':'			; backslash to the path
		je	@01_AddToPath
		mov	al, '\'
		stosb
@01_AddToPath:	mov	si, bx			;Append the original file name
		jmp	StrCopy			; to the path

;Print a string onto the screen
;  Input : DS:DX: the string
;          CF: when not zero, a line feed is also printed
PrintStr:	push	si
		push	bx
		push	cx
		pushf
		mov	si, dx
		mov	bx, 1
		call	StrLen
		or	ax, ax
		je	@01_PrintStr
		mov	cx, ax
		mov	ah, 40h
		int	21h
@01_PrintStr:	popf
		jnc	@02_PrintStr
		mov	dx, Offset LineFeed
		mov	cx, 2
		mov	ah, 40h
		int	21h
@02_PrintStr:	pop	cx
		pop	bx
		pop	si
		retn

;Compute the length of a string
;  Input : DS:DX: the string
;  Output: AX: the length of the string
StrLen:		cld
		push	si
		xor	ah, ah
@02_StrLen:	lodsb
		or	al, al
		je	@01_StrLen
		inc	ah
		or	ah, ah
		jne	@02_StrLen
@01_StrLen:	pop	si
		mov	al, ah
		xor	ah, ah
		retn

;Convert Unicode character to ASCII
;  Input : AX: the Unicode character
;  Output: ZF: when not zero, the end of the string has been reached
;          AL: the ASCII character
Unicode:	or	ah, ah			;If upper byte of Unicode
		je	@01_Unicode		; character is not zero then
		mov	al, '_'			; convert to an underscore
@01_Unicode:	or	al, al			;Determine if end of string
		retn

;Go to the next LFN character in the directory entry
;  Input : CL: the current offset into the directory entry
;          DS:SI: the current character
;  Output: CF: when not zero, the end of the directory entry has been reached
;          CL: the new offset into the directory entry
;          DS:SI: the next character
NextLFNChr:	add	si, 2
		add	cl, 2			;Increase offset into entry
		cmp	cl, 11			;Skip three bytes at the
		jne	@01_NextLFNChr		; offset eleven
		add	si, 3
		add	cl, 3
		jmp	@02_NextLFNChr
@01_NextLFNChr:	cmp	cl, 26			;Skip two bytes at the offset
		jne	@02_NextLFNChr		; twenty six
		add	si, 2
		add	cl, 2
@02_NextLFNChr:	cmp	cl, EntrySize		;Determine if last character
		cmc
		retn

;Print the short and long file name onto the screen
PrintNames:
	ifdef MakeListFile
		cmp	LFNEntriesOK, False	;Skip displaying file names if
		je	@03_PrintNames		; long file name not present
	endif
		mov	si, Offset ShortName
		push	si
		mov	di, si
	ifndef MakeListFile
		test	Attrib, faDirectory	;Convert the name of files
		jne	@04_PrintNames		; into lowercase and that of
		call	LowerCase		; directories into uppercase
		jmp	@05_PrintNames
	endif
@04_PrintNames:	call	UpperCase
@05_PrintNames:	pop	dx
		clc				;Print the short file name
		call	PrintStr
	ifdef MakeListFile
		mov	ah, 2			;Separate the short and long
		mov	dl, ' '			; file names with a space
		int	21h
		cmp	byte ptr LongName[0], ' '
		jne	@06_PrintNames		;Insert a quotation mark if
		mov	ah, 2			; the long file name begins
		mov	dl, '"'			; with a space
		int	21h
	else
		mov	si, dx
	ifndef ForceLongNames
		mov	dx, Offset EmptyStr	;Do not display long file name
		cmp	LFNEntriesOK, False	; if it was duplicated from
		je	@02_PrintNames		; short file name
	endif
		call	StrLen
@01_PrintNames:	push	ax			;Separate the short and long
		mov	ah, 2			; file names with tabs
		mov	dl, 9
		int	21h
		pop	ax
		add	ax, 8
		and	ax, 0F8h
		cmp	ax, 16
		jb	@01_PrintNames
	endif
@06_PrintNames:	mov	dx, Offset LongName
@02_PrintNames:	stc				;Print the long file name and
		jmp	PrintStr		; and end of line
@03_PrintNames:	retn

;Read the next file from the directory
;  Output: CF: when not zero, an error occured or the directory ended
NextFile:	xor	al, al			;Invalidate LFN entries and
		mov	LFNEntriesOK, al	; long file name
		mov	LongName[0], al
@09_NextFile:	call	ReadEntry		;Read next directory entry
		jc	@04_NextFile
		cmp	byte ptr [bx].DirEntry.deAttr, faLFN
		jne	@01_NextFile		;Skip if normal entry
		mov	al, byte ptr [bx].DirEntry.deChecksum
		mov	cl, byte ptr [bx].DirEntry.deName[0]
		test	cl, leDeleted		;Skip LFN entry if highest
		jne	@09_NextFile		; bit is set
		and	cl, not leDeleted
		xor	ch, ch			;Clear last LFN entry flag
		test	cl, leLast		;Skip if not last (physically
		je	@02_NextFile		; first) LFN entry
		and	cl, leNumMask		;Strip off last entry flag
		mov	LFNEntryNum, cl		;Store number of LFN entries
		mov	LFNChecksum, al		;Store checksum
		mov	LFNEntriesOK, True	;Set LFN entries correct flag
		inc	ch
		jmp	@03_NextFile
@02_NextFile:	cmp	LFNEntriesOK, False	;Skip all subsequent LFN
		je	@09_NextFile		; entries if an error occured
		cmp	LFNChecksum, al		;Compare checksum against the
		je	@03_NextFile		; previous one and invalidate
@11_NextFile:	mov	LFNEntriesOK, False	; entries if mismatch
		jmp	@09_NextFile
@03_NextFile:	mov	al, LFNEntryNum		;Fetch number of LFN entries
		or	al, al			;If there should be no more
		je	@11_NextFile		; LFN entries then invalidate
		cmp	al, cl			;If LFN entries in incorrect
		jne	@11_NextFile		; order then invalidate
		dec	LFNEntryNum		;Decrease num of LFN entries
		dec	cl			;Fetch number of LFN part
		mov	al, LFNCharPerEntry	;Convert number of LFN part
		mul	cl			; into offset into long file
		mov	di, Offset LongName	; name
		add	di, ax
		mov	si, bx			;Go to first character
		inc	si
		mov	cl, 1			;Initialize offset into entry
		cld
@06_NextFile:	mov	ax, [si]		;Read Unicode character
		call	Unicode			;Convert character to ASCII
		je	@05_NextFile		;End if end of string
		stosb				;Store ASCII character
		call	NextLFNChr		;Go to the next character
		jnc	@06_NextFile
		or	ch, ch			;If this is the last entry
		je	@09_NextFile		; then end long file name
		jmp	@13_NextFile
@05_NextFile:	or	ch, ch			;If this is not the last entry
		je	@11_NextFile		; then invalidate LFN entries,
@13_NextFile:	xor	al, al			;End long file name and go to
		stosb				; the next entry
		jmp	@09_NextFile
@01_NextFile:	cmp	LFNEntriesOK, False	;Skip if there were no
		je	@07_NextFile		; preceding LFN entries
		mov	si, bx
		mov	cx, SFNNameLen + SFNExtLen
		xor	ah, ah			;Compute checksum for the
		cld				; short file name
@10_NextFile:	ror	ah, 1			;Rotate checksum one bit to
		lodsb				; the right and then add the
		add	ah, al			; current character os the
		loop	@10_NextFile		; short file name
		cmp	ah, LFNChecksum		;Invalidate LFN entries if the
		je	@07_NextFile		; checksum does not match
		mov	LFNEntriesOK, False
@07_NextFile:	mov	cx, SFNNameLen		;Copy the name part of the
		mov	si, bx			; short file name
		mov	di, Offset ShortName
		xor	ah, ah
		call	CopyName
		mov	cx, SFNExtLen		;Copy the extension part of
		lea	si, [bx][8]		; the short file name
		mov	ah, 1
		call	CopyName
		cmp	LFNEntriesOK, False	;If the LFN entries are
		jne	@12_NextFile		; invalid then duplicate the
		mov	si, Offset ShortName	; short file name
		mov	di, Offset LongName
		call	StrCopy
@12_NextFile:	mov	al, byte ptr ShortName[0]
		cmp	al, seDeleted		;Skip deleted entries
		je	NextFile
		cmp	al, seReplaceE5h	;Fix valid entries with a
		jne	@08_NextFile		; first character of E5h
		mov	byte ptr ShortName[0], seDeleted
@08_NextFile:	mov	al, [bx].DirEntry.deAttr
		test	al, faVolLabel		;Skip volume labels
		jne	NextFile
		mov	Attrib, al		;Save the file attribute
		clc
@04_NextFile:	retn

;Parse the path name specified on the command line
ParseName:	mov	di, Offset SearchName	;Fill in search name with path
		push	di			; specified on command line
		mov	cl, byte ptr ds:CommandLineLen
		xor	ch, ch
		stc
		jcxz	@07_ParseName
		mov	si, Offset CommandLine
		cld
@03_ParseName:	lodsb				;Skip leading white spaces
		cmp	al, ' '
		je	@02_ParseName
		cmp	al, chTab
		jne	@04_ParseName
@02_ParseName:	loop	@03_ParseName
		jmp	@07_ParseName
@04_ParseName:	xor	ah, ah			;Clear quote flag
		dec	si			;Go back to previous character
@09_ParseName:	lodsb				;Search until the end of the
		cmp	al, chCR		; command line or the first
		je	@07_ParseName		; white space, ignoring ones
		cmp	al, ' '			; between quotation marks
		je	@05_ParseName
		cmp	al, chTab
		jne	@06_ParseName
@05_ParseName:	or	ah, ah
		je	@07_ParseName
@06_ParseName:	cmp	al, '"'			;Toggle quote flag when
		jne	@08_ParseName		; reading a quotation mark and
		xor	ah, True		; drop the quotation mark
		jmp	@01_ParseName		; itself
@08_ParseName:	stosb
@01_ParseName:	loop	@09_ParseName
@07_ParseName:	mov	byte ptr [di], 0	;End search name
		pop	si			;Add the designator of all
		mov	bx, Offset AllFiles	; files to the search name
		mov	di, Offset SearchName
		jmp	AddToPath

;Get the physical parameters of a drive
;  Input : AL: the drive to scan (0 for A: etc.)
;  Output: CF: if zero, the drive was found
DrivePars:	cmp	al, LastDrive		;Exit if drive is invalid
		stc
		jae	@01_DrivePars
		mov	ah, CurDirStrucSize
		mul	ah
		lds	si, CurDirStrucs	;Go to the current directory
		add	si, ax			; structure of the drive
		lds	si, [si].CurDirStruc.cdDriveParBlock
		mov	di, Offset DriveParams	;Copy drive parameter block
		mov	cx, DrvParBlockSize	; into own data segment
		cld
		rep	movsb
		push	cs			;Reload data segment
		pop	ds
                clc
@01_DrivePars:	retn
;!!! DEBUG !!!
;DrivePars2:	mov	dl, al			;Get drive parameter block
;		inc	dl
;		mov	ah, 32h
;		int	21h
;		mov	si, bx			;Copy drive parameter block
;		mov	di, Offset DriveParams	; into own data segment
;		mov	cx, DrvParBlockSize
;		cld
;		rep	movsb
;		push	cs			;Reload data segment
;		pop	ds
;		clc
;		retn
;DrivePars3:	mov	bl, al
;		inc	bl
;		mov	ax, 440Dh		;Ask the device driver for
;		mov	cx, 0860h		; the device parameter block
;		mov	dx, Offset DeviceParams
;		int	21h
;		jc	@01_DrivePars
;		push	bp
;		mov	si, dx
;		add	si, DeviceParBlock.bbBIOSParBlock
;		mov	bp, Offset DriveParams	;Convert BIOS parameter block
;		mov	ah, 53h			; into drive parameter block
;		int	21h
;		pop	bp
;		clc
;@01_DrivePars:	retn
;!!! DEBUG !!!

;Calculate the absolute sector number of the first sector of a cluster
;  Input : AX: the cluster number
;  Output: DX:AX: the absolute sector number of the first sector
AbsSector:	xor	dx, dx			;Zero high word of number
		cmp	ax, 2			;If cluster number is below
		jae	@01_AbsSector		; two then root directory
		mov	ax, DriveParams.dpFirstDirSec
		jmp	@02_AbsSector		;Fetch first root dir sector
@01_AbsSector:	sub	ax, 2			;Subtract two from cluster
		mov	cl, DriveParams.dpClusterShift
		xor	ch, ch
		jcxz	@03_AbsSector
@04_AbsSector:	shl	ax, 1			;Shift the cluster number to
		rcl	dx, 1			; get number of sectors
		loop	@04_AbsSector
@03_AbsSector:	add	ax, DriveParams.dpFirstDataSec
		adc	dx, 0			;Add first data sector
@02_AbsSector:	retn

;Read a FAT entry from the disk
;  Input : AX: the FAT entry number
;  Output: CF: when not zero, an error occured or the FAT chain ended
;  Output: AX: the FAT entry
ReadFAT:	xor	bl, bl			;Clear 12-bit FAT flag
		xor	dx, dx			;Clear upper word of number
		cmp	DriveParams.dpClusterNum, 0FF6h
		ja	@01_ReadFAT		;Skip if 16-bit FAT
		inc	bl			;Set 12-bit FAT flag
		mov	cx, 3			;Compute offset of 12-bit
		mul	cx			; entry into FAT sector
		xor	bh, bh			;Multiply FAT entry number by
		shr	dx, 1			; three, then divide it by two
		rcr	ax, 1			; set second 12-bit flag
		rcl	bh, 1			; according to remainder
		jmp	@02_ReadFAT
@01_ReadFAT:	xor	dx, dx			;Compute offset of 16-bit
		shl	ax, 1			; entry into FAT sector
		rcl	dx, 1
		xor	bh, bh			;Clear second 12-bit flag
@02_ReadFAT:	div	DriveParams.dpBytePerSector
		push	bx
		push	dx			;Compute absolute sector
		xor	dx, dx			; number of FAT sector
		add	ax, DriveParams.dpResSectorNum
		adc	dx, 0
		mov	word ptr FATAbsSector[0], ax
		mov	word ptr FATAbsSector[2], dx
		call	ReadFATSector
		pop	si
		pop	bx
		jc	@03_ReadFAT
		mov	ax, word ptr FATBuffer[si]
		or	bl, bl			;Skip 12-bit FAT conversion
		je	@04_ReadFAT		; if 16-bit FAT
		or	bh, bh			;If the FAT entry is in the
		jne	@05_ReadFAT		; first 12 bit then strip off
		and	ax, 0FFFh		; the high four bits
		jmp	@06_ReadFAT
@05_ReadFAT:	inc	si			;Go to second half of entry
		cmp	si, DriveParams.dpBytePerSector
		jb	@07_ReadFAT		;If beyond sector boundary
		push	ax			; then read next FAT sector
		inc	word ptr FATAbsSector[0]
		jne	@08_ReadFAT
		inc	word ptr FATAbsSector[2]
@08_ReadFAT:	call	ReadFATSector
		pop	ax
		jc	@03_ReadFAT
		mov	ah, byte ptr FATBuffer[0]
@07_ReadFAT:	shr	ax, 4			;Shift entry into place
@06_ReadFAT:	cmp	ax, 0FF0h		;End if the the FAT chain
		jb	@04_ReadFAT		; ended or a bad cluster was
		or	ax, 0F000h		; encountered
@04_ReadFAT:	or	ax, ax			;Determine if the FAT chain
		stc				; ended or a bad cluster was
		je	@03_ReadFAT		; encountered
		cmp	ax, 0FFF0h
		cmc
@03_ReadFAT:	retn

;Save the cluster number of the directory cluster and compute the absolute
;  sector number of its first sector
;  Input : the cluster number of the directory
SaveDirCluster:	mov	DirCluster, ax
		call	AbsSector
		mov	word ptr DirAbsSector[0], ax
		mov	word ptr DirAbsSector[2], dx
		retn

;Read the next directory entry from the disk
;  Output: CF: when not zero, an error occured or the directory ended
;          DS:BX: the entry
ReadEntry:	mov	ax, DirOffset		;Fetch current offset into
		add	ax, EntrySize		; directory sector and add
		mov	DirOffset, ax		; size of directory entry
		cmp	ax, DriveParams.dpBytePerSector
		jb	@02_ReadEntry		;Skip if still the same sector
@01_ReadEntry:	mov	DirOffset, 0		;Zero out offset into sector
		inc	word ptr DirAbsSector[0]
		jne	@05_ReadEntry		;Increase sector number
		inc	word ptr DirAbsSector[2]
@05_ReadEntry:	mov	ax, DirSector		;Increase number of sectors
		inc	ax			; into cluster
		mov	DirSector, ax
		je	@03_ReadEntry
		cmp	DirCluster, 2		;Check root directory in a
		jae	@07_ReadEntry		; different way
		add	ax, DriveParams.dpFirstDirSec
		cmp	ax, DriveParams.dpFirstDataSec
		jb	@04_ReadEntry
		stc				;End if last root directory
		jmp	@06_ReadEntry		; sector was left
@07_ReadEntry:	cmp	al, DriveParams.dpSectorPerClus
		jbe	@04_ReadEntry		;Read sector if same cluster
@03_ReadEntry:	mov	DirSector, 0		;Zero out sectors into cluster
		mov	ax, DirCluster		;Search for the next cluster
		call	ReadFAT			; of the directory in the FAT
		jc	@06_ReadEntry
		call	SaveDirCluster		;Save directory cluster
@04_ReadEntry:	call	ReadDirSector		;Read the directory sector and
		jc	@06_ReadEntry		; end if an error occured
@02_ReadEntry:	mov	bx, Offset DirBuffer	;Return the offset of the
		add	bx, DirOffset		; directory entry
		cmp	byte ptr [bx], 1	;Determine if last entry
@06_ReadEntry:	retn

;Read a FAT sector from the disk
;  Output: CF: when not zero, an error occured
ReadFATSector:	mov	al, Drive
		mov	bx, word ptr FATAbsSector[0]
		mov	cx, word ptr FATAbsSector[2]
		mov	dx, Offset FATBuffer
		jmp	ReadSector

;Read a directory sector from the disk
;  Output: CF: when not zero, an error occured
ReadDirSector:	mov	al, Drive
		mov	bx, word ptr DirAbsSector[0]
		mov	cx, word ptr DirAbsSector[2]
		mov	dx, Offset DirBuffer
		jmp	ReadSector

;Read a sector from the disk
;  Input : AL: the drive to read from (0 for A:, 1 for B:, 2 for C: etc.)
;          CX:BX: number of sector to read
;          DS:DX: the sector buffer
;  Output: CF: when not zero, an error occured
ReadSector:	call	InitXferBlock		;Initialize transfer block
		int	25h
		add	sp, 2
		retn

;Initialize transfer block
;  Input : CX:BX: number of sector to transfer
;          DS:DX: the sector buffer
;  Output: DS:BX: the initialized transfer block
;          CX: -1 for extended disk transfer
InitXferBlock:	mov	word ptr TransferBlock.dbFirstSector[0], bx
		mov	word ptr TransferBlock.dbFirstSector[2], cx
		mov	TransferBlock.dbSectorNum, 1
		mov	word ptr TransferBlock.dbBuffer[0], dx
		mov	word ptr TransferBlock.dbBuffer[2], cs
		mov	cx, -1
		mov	bx, Offset TransferBlock
		retn

AllFiles	db	'*.*', 0
SpaceStr	db	' ', 0
EmptyStr	db	0
LineFeed	db	13, 10

DataStart:

LFNEntryNum	db	?			;Number of LFN entries
LFNEntriesOK	db	?			;Previous LFN entries OK flag
Drive		db	?			;Current drive number
LFNCheckSum	db	?			;Checksum of short file name
Attrib		db	?			;File attribute
LastDrive	db	?			;Number of drives
DirCluster	dw	?			;Directory cluster number
DirSector	dw	?			;Sectors into dir cluster
DirOffset	dw	?			;Offset into directory sector
DirAbsSector	dd	?			;Absolute dir sector number
FATAbsSector	dd	?			;Absolute FAT sector number
CurDirStrucs	dd	?			;Current directory structures

DataEnd:

DeviceParams		DeviceParBlock <?>
DriveParams		DriveParBlock <?>
TransferBlock		DiskXferBlock <?>
FATBuffer		SectorBuffer <?>
DirBuffer		SectorBuffer <?>
SearchName	db	LongNameLen + 1 dup (?)
LongName	db	LongNameLen + 1 dup (?)
ShortName	db	ShortNameLen + 1 dup (?)

MainEnd:

CSeg		ends

		end	Main
