;Ŀ
;                 Joe Forster/STA                 
;                                                 
;                  STARNITE.ASM                   
;                                                 
;            Starry Night screen saver            
;

SaverStarMax	equ	32		;Number of stars to be displayed
BlankChar	equ	' ' + 07h shl 8	;Blank character used to clear screen
MaxScreenSize	equ	80 * 50 * 2	;Maximum size of screen data in bytes

		jumps

CSeg		segment
		assume	cs:CSeg, ds:CSeg, ss:CSeg
		org	0100h

Main:		jmp	Start

NewInt09:	push	es		;New INT09 handler (keyboard)
		push	bx
		push	ax
		mov	bx, 0040h	;Set ES to BIOS data area
		mov	es, bx
		in	al, 60h		;Read keyboard data (scan code)
		mov	ah, es:[0017h]	;Read keyboard flags (shift status)
		test	al, 80h
		jne	@01_NewInt09
		and	ah, 0Fh
		cmp	cs:SaverOn, 0	;Don't activate screen saver if it is
		jne	@01_NewInt09	; already active
		cmp	al, 0Eh		;If BackSpace was pressed and Control
		jne	@01_NewInt09	; and Alt is being held then activate
		cmp	ah, 0Ch		; screen saver by setting delay timer
		jne	@01_NewInt09	; to 1
		mov	cs:SaverCount, 1
		pushf			;Call original INT09 handler and
		call	cs:OldInt09	; return
		jmp	@02_NewInt09
@01_NewInt09:	mov	bx, es:[001Ch]	;Remember keyboard buffer tail
		pushf			;Call original INT09 handler
		call	cs:OldInt09
		cmp	es:[001Ch], bx	;If a new scan code was put into the
		jne	@03_NewInt09	; buffer then deactivate screen saver
		cmp	es:[0017h], ah	;If a shift key was pressed then
		jbe	@02_NewInt09	; deactivate screen saver
@03_NewInt09:	call	SwitchOff
		jnc	@02_NewInt09	;If screen saver was deactivated then
		mov	es:[001Ch], bx	; clear the last scan code
@02_NewInt09:	pop	ax
		pop	bx
		pop	es
		iret

NewInt08:	pushf			;New INT08 handler (timer)
		cmp	cs:SaverOn, 0	;If screen saver is already active
		jne	@03_NewInt08	; then skip the whole interrupt
		cmp	cs:InWindows, 0	;When running under Windows, the
		jne	@03_NewInt08	; screen saver must not activate
		push	ds
		push	es
		push	bp
		push	si
		push	di
		push	ax
		push	bx
		push	cx
		push	dx
		push	cs		;Set DS to program segment
		pop	ds
		dec	SaverCount	;Decrease timer
		cmp	SaverCount, 0	;If timer reaches zero then the
		jne	@02_NewInt08	; screen saver must be activated
		call	SetCRTData	;Set up screen-related variables
		call	ScreenSize	;Abort if the screen is too big
		cmp	cx, MaxScreenSize / 2
		ja	@02_NewInt08
		mov	SaverOn, 1	;Screen saver is now active
		mov	SaverOff, 0	;Clear "request deactivation" flag
		mov	ax, 2		;Hide mouse cursor
		int	33h
		mov	ah, 1		;Hide text cursor
		mov	cx, 2000h
		int	10h
		mov	ah, 2
		xor	bh, bh
		mov	dl, byte ptr ScreenWidth[0]
		mov	dh, byte ptr ScreenHeight[0]
		int	10h
		call	SaveScreen	;Save screen into buffer
		call	ClearScreen	;Clear the whole screen
		xor	bx, bx		;Initialize star-related variables
		mov	cx, SaverStarMax
		mov	ax, 0500h
@04_NewInt08:	mov	StarsPhase[bx], ah
		mov	StarsCount[bx], al
		mov	StarsX[bx], al
		mov	StarsY[bx], al
		inc	bl
		loop	@04_NewInt08
		mov	SaverStarVis, 0	;No stars are currently displayed
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		pop	di
		pop	si
		pop	bp
		pop	es
		pop	ds
		popf
		pushf			;Insert the main screen saver
		push	cs		; program into the execution order
		push	Offset @01_NewInt08
		jmp	cs:OldInt08	;Call original INT08 handler
@02_NewInt08:	pop	dx
		pop	cx
		pop	bx
		pop	ax
		pop	di
		pop	si
		pop	bp
		pop	es
		pop	ds
@03_NewInt08:	popf
		jmp	cs:OldInt08	;Call original INT08 handler
@01_NewInt08:	push	ds		;Main screen saver program
		push	es
		push	bp
		push	si
		push	di
		push	ax
		push	bx
		push	cx
		push	dx
		push	cs
		pop	ds
		mov	ax, ScreenSeg	;Set ES to screen segment
		mov	es, ax
		sti
		mov	ax, 168Bh	;Set focus to this Windows virtual
		xor	bx, bx		; machine
		int	2Fh
@18_NewInt08:	call	GetTicks	;Remember current value of timer
		mov	bx, ax
@05_NewInt08:	int	28h		;Release current time slice
		mov	ax, 1680h
		int	2Fh
		call	GetTicks	;Wait for next timer tick
		cmp	bx, ax
		je	@05_NewInt08
		xor	bx, bx		;Start working with the first star
@15_NewInt08:	cmp	StarsCount[bx], 0
		je	@06_NewInt08	;If the star timer has reached zero
		jmp	@07_NewInt08	; then its phase must be changed
@06_NewInt08:	mov	al, StarsPhase[bx]
		inc	al		;Change phase of the current star
		cmp	al, 6		;Wrap to zero if more than 5
		jne	@08_NewInt08
		mov	al, 0
@08_NewInt08:	mov	StarsPhase[bx], al
		cmp	al, 2		;If phase of current star is 2 then
		jne	@09_NewInt08	; a random number must decide whether
		push	bx		; the star blows up or disappears
		mov	ax, 10
		push	ax
		call	Random
		pop	bx
		cmp	ax, 8		;8 stars out of 10 disappear
		jae	@09_NewInt08
		mov	al, 5		;Clear star if it has to disappear
		mov	StarsPhase[bx], al
@09_NewInt08:	mov	al, StarsPhase[bx]
		cmp	al, 0
		jne	@10_NewInt08	;If a new star is born then delete it
		mov	ax, BlankChar	; from its previous coordinates
		call	DrawStar
		push	bx
		push	ScreenWidth
		call	Random		;Generate new X coordinate
		pop	bx
		mov	StarsX[bx], al
		push	bx
		push	ScreenHeight
		call	Random		;Generate new Y coordinate
		pop	bx
		mov	StarsY[bx], al
		push	bx
		mov	ax, 182		;Generate new lifetime: 1-182 ticks,
		push	ax		; that is 0-10 seconds
		call	Random
		pop	bx
		inc	al		;Store lifetime to the star timer
		mov	StarsCount[bx], al
		jmp	@11_NewInt08
@10_NewInt08:	mov	al, 3		;Set star timer to phase change delay
		mov	StarsCount[bx], al
@11_NewInt08:	mov	ah, StarColor	;Load default color of star
		mov	al, StarsPhase[bx]
		or	al, al		;If star is blowing up then set its
		je	@12_NewInt08	; color to white
		mov	ah, 0Fh
@12_NewInt08:	push	bx
		mov	bl, al		;Load the character representing the
		xor	bh, bh		; current phase of the star
		mov	al, StarChars[bx]
		pop	bx
		call	DrawStar	;Display star on the screen
@07_NewInt08:	mov	al, SaverStarVis
		cmp	al, SaverStarMax - 1
		jne	@13_NewInt08	;Decrease star timer if all stars are
		dec	StarsCount[bx]	; displayed on the screen
@13_NewInt08:	cmp	bl, SaverStarVis
		jae	@14_NewInt08	;If not all stars were handled then
		inc	bl		; get working on the next star
		jmp	@15_NewInt08
@14_NewInt08:	mov	al, SaverStarVis
		cmp	al, SaverStarMax - 1
		jae	@16_NewInt08	;If not all stars are on the screen
		inc	SaverStarVis	; then increase their number
@16_NewInt08:	cmp	SaverOff, 0	;If the "request deactivation" flag
		jne	@17_NewInt08	; is on then the screen saver must be
		jmp	@18_NewInt08	; deactivated
@17_NewInt08:	cli
		mov	SaverOn, 0	;Clear flags
		mov	SaverOff, 0
		mov	ax, SaverDelay	;Initialize timer
		mov	SaverCount, ax
		call	LoadScreen	;Load original screen from buffer
		mov	ah, 1		;Show text cursor
		mov	cx, CursorLines
		int	10h
		mov	ah, 2
		xor	bh, bh
		mov	dx, CursorPos
		int	10h
		mov	ax, 1		;Show mouse cursor
		int	33h
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		pop	di
		pop	si
		pop	bp
		pop	es
		pop	ds
		iret

NewInt2F:	cmp	ax, 0		;New INT2F handler (multiplex)
		jne	@01_NewInt2F	;If AX=0, BX:CX='NITE' then return
		cmp	bx, 'NI'	; AL=FFh, BX=program segment, CX='OK'
		jne	@01_NewInt2F
		cmp	cx, 'TE'
		jne	@01_NewInt2F
		mov	al, 0FFh
		mov	bx, cs
		mov	cx, 'OK'
		iret
@01_NewInt2F:	cmp	ah, 16h		;Catch when Windows starts and ends
		jne	@02_NewInt2F
		cmp	al, 5		;Screen saver must not activate after
		je	@03_NewInt2F	; Windows has started
		cmp	al, 6		;Screen saver is back to normal after
		jne	@02_NewInt2F	; Windows has ended
@03_NewInt2F:	push	ax
		sub	al, 5
		xor	al, 1
		mov	cs:InWindows, al
		pop	ax
@02_NewInt2F:	jmp	cs:OldInt2F	;Call original INT2F handler

NewInt33:	pushf			;New INT33 handler (mouse)
		mov	cs:MouseFunc, ax
		cmp	ax, 0Ch		;If functions AX=0Ch or AX=14h were
		je	@01_NewInt33	; called, store the address and mask
		cmp	ax, 14h		; of user-defined mouse subroutine
		jne	@02_NewInt33
@01_NewInt33:	mov	cs:OldMouseMask, cx
		mov	word ptr cs:OldMouseProg[0], dx
		mov	word ptr cs:OldMouseProg[2], es
		popf
		push	ax
		jmp	@03_NewInt33
@02_NewInt33:	call	cs:OldInt33	;Call original INT33 handler
		push	ax
		mov	ax, cs:MouseFunc;If function AX=3 was called and
		cmp	ax, 3		; the mouse status has changed then
		jne	@03_NewInt33	; request deactivation
		cmp	bx, cs:OldMouseButton
		jne	@04_NewInt33
		cmp	cx, cs:OldMouseX
		jne	@04_NewInt33
		cmp	dx, cs:OldMouseY
		je	@03_NewInt33
@04_NewInt33:	call	SwitchOff
		mov	cs:OldMouseButton, bx
		mov	cs:OldMouseX, cx	;Store current mouse status
		mov	cs:OldMouseY, dx
		jmp	@01_NewInt33
@03_NewInt33:	cmp	ax, 0		;If functions AX=0, AX=0Ch, AX=14h or
		je	@05_NewInt33	; AX=21h were called then restore the
		cmp	ax, 0Ch		; user-defined mouse subroutine to
		je	@05_NewInt33	; the screen saver
		cmp	ax, 14h
		je	@05_NewInt33
		cmp	ax, 21h
		jne	@06_NewInt33
@05_NewInt33:	push	es
		push	cx
		push	dx
		mov	cx, 0FFFFh
		push	cs
		pop	es
		mov	dx, Offset NewMouse
		mov	ax, 0Ch
		pushf
		call	cs:OldInt33
		pop	dx
		pop	cx
		pop	es
@06_NewInt33:	pop	ax
		iret

NewMouse:	call	Switchoff	;New user-defined mouse subroutine
		test	ax, cs:OldMouseMask	;Request deactivation
		je	@01_NewMouse	;Call original user-defined mouse
		push	ax		; subroutine if available and needed
		mov	ax, word ptr OldMouseProg[0]
		or	ax, word ptr OldMouseProg[2]
		pop	ax
		je	@01_NewMouse
		call	cs:OldMouseProg
@01_NewMouse:	retf

ScreenSize:	mov	al, byte ptr cs:ScreenHeight[0]
		mov	ah, byte ptr cs:ScreenWidth[0]
		mul	ah		;Compute size of screen
		mov	cx, ax
		cld
		retn


SaveScreen:	push	es		;Save screen into buffer
		push	ds
		pop	es
		push	es
		mov	ax, ScreenSeg
		mov	ds, ax
		xor	si, si
		mov	di, Offset ScreenBuffer
		call	ScreenSize
		rep	movsw
		pop	ds
		pop	es
		retn

LoadScreen:	push	es		;Load screen from buffer
		mov	si, Offset ScreenBuffer
		mov	ax, ScreenSeg
		mov	es, ax
		xor	di, di
		call	ScreenSize
		rep	movsw
		pop	es
		retn

ClearScreen:	push	es		;Clear screen
		mov	ax, ScreenSeg
		mov	es, ax
		xor	di, di
		call	ScreenSize
		mov	ax, BlankChar
		rep	stosw
		pop	es
		retn

DrawStar:	push	ax		;Draw star on the screen
		mov	al, StarsY[bx]
		xor	ah, ah		;Compute offset in screen segment
		mov	dl, byte ptr ScreenWidth[0]
		xor	dh, dh
		shl	dx, 1
		mul	dx
		mov	di, ax
		mov	al, StarsX[bx]
		xor	ah, ah
		shl	ax, 1
		add	di, ax
		pop	ax
		mov	es:[di], ax	;Write star char into screen segment
		retn

SwitchOff:	push	ax		;Request deactivation of screen saver
		clc
		cmp	cs:SaverOn, 0
		je	@01_SwitchOff
		cmp	cs:SaverOff, 0
		jne	@01_SwitchOff	;If screen saver is active then set
		mov	cs:SaverOff, 1	; "request deactivation" flag
		stc
@01_SwitchOff:	mov	ax, cs:SaverDelay
		mov	cs:SaverCount, ax
		pop	ax		;Initialize delay timer
		retn

GetTicks:	push	es		;Read current value of timer
		mov	ax, 0040h	;Set ES to BIOS data area
		mov	es, ax
		mov	ax, es:[006Ch]
		pop	es
		retn

Random:		call	NextRand	;Generate a random integer
		mov	bx, sp
		mov	cx, dx
		mul	word ptr ss:[bx][2]
		mov	ax, cx
		mov	cx, dx
		mul	word ptr ss:[bx][2]
		add	ax, cx
		adc	dx, 0
		mov	ax, dx
		retn	2

NextRand:	mov	ax, word ptr RandSeed[0];Subroutine for "Random"
		mov	bx, word ptr RandSeed[2]
		mov	cx, ax
		mul	Factor
		shl	cx, 1
		shl	cx, 1
		shl	cx, 1
		add	ch, cl
		add	dx, cx
		add	dx, bx
		shl	bx, 1
		shl	bx, 1
		add	dx, bx
		add	dh, bl
		mov	cl, 5
		shl	bx, cl
		add	dh, bl
		add	ax, 1
		adc	dx, 0
		mov	word ptr RandSeed[0], ax
		mov	word ptr RandSeed[2], dx
		retn

GetCRTMode:	mov	ah, 0Fh		;Read current video mode
		int	10h
		push	ax
		mov	ax, 1130h
		mov	bh, 0
		mov	dl, 0
		int	10h
		pop	ax
		mov	dh, ah
		cmp	dl, 25
		sbb	ah, ah
		inc	ah
		retn

SetCRTData:	call	GetCRTMode	;Set screen-related variables
		or	dl, dl		;Read video mode
		jne	@01_SetCRTData
		mov	dl, 24
@01_SetCRTData:	inc	dl		;Store current video mode, number of
		mov	ScreenMode, ax	; columns and number of rows
		push	dx
		xor	dh, dh
		mov	ScreenHeight, dx
		pop	dx
		mov	dl, dh
		xor	dh, dh
		mov	ScreenWidth, dx
		mov	cl, 0
		mov	ch, 0Bh
		mov	bx, 0B800h
		cmp	al, 7
		jne	@02_SetCRTData
		mov	cl, 1
		mov	ch, 07h
		mov	bx, 0B000h
@02_SetCRTData:	mov	Monochrome, cl	;Set "monochrome" flag, store default
		mov	StarColor, ch	; color of stars and screen segment
		mov	ScreenSeg, bx
		mov	ah, 3		;Read and store cursor scan lines
		mov	bh, 0
		int	10h
		mov	CursorLines, cx
		mov	CursorPos, dx
		retn

StarChars	db	'', '', '', '', '', ' '	;Chars for star phases
InWindows	db	0		;Saver must be inactive under Windows
Factor		dw	8405h		;Multiplication factor for "Random"
SaverDelay	dw	0		;Default value for timer
SaverCount	dw	0		;Screen saver delay timer
RandSeed	dd	0		;Seed number for "Random"
OldInt09	dd	0		;Address of original INT09 handler
OldInt08	dd	0		;Address of original INT08 handler
OldInt2F	dd	0		;Address of original INT2F handler
OldInt33	dd	0		;Address of original INT33 handler

DataStart:				;Start of variable area

OldMouseProg	dd	?		;Address and
OldMouseMask	dw	?		; mask of original mouse subroutine
OldMouseX	dw	?		;Previous X coordinate,
OldMouseY	dw	?		; Y coordinate and
OldMouseButton	dw	?		; button status of mouse
MouseFunc	dw	?		;INT33 function number
SaverOn		db	?		;"Screen saver active" flag
SaverOff	db	?		;"Request deactivation" flag
ScreenMode	dw	?		;Current video mode
ScreenSeg	dw	?		;Current screen segment
ScreenHeight	dw	?		;Number of rows and
ScreenWidth	dw	?		; columns on the screen
Monochrome	db	?		;"Monochrome video mode" flag
CursorPos	dw	?		;Previous coordinate of cursor
CursorLines	dw	?		;Original value of cursor scan lines
SaverStarVis	db	?		;Number of stars on the screen
StarColor	db	?		;Default color of stars
StarsX		db	SaverStarMax dup (?)	;X coordinates,
StarsY		db	SaverStarMax dup (?)	; Y coordinates,
StarsPhase	db	SaverStarMax dup (?)	; phases and
StarsCount	db	SaverStarMax dup (?)	; timers of the stars

DataEnd:				;End of variable area

ScreenBuffer	db	MaxScreenSize dup (?)	;Buffer for original screen

ResidentEnd:				;End of resident part

		org	DataStart	;The variables of the resident part
					; overlay the installer program

Start:		mov	dx, Offset Hello	;Main program
		mov	ah, 9		;Print program title
		int	21h
		mov	si, 81h		;Start working on the parameters
		xor	ax, ax
		xor	dx, dx
		xor	bh, bh
@01:		mov	bl, [si]	;Skip leading spaces and tabs
		inc	si
		cmp	bl, ' '
		je	@01
		cmp	bl, 13		;If CR was found then no parameter
		je	@02		; was given, print usage
@05:		cmp	bl, 13
		je	@03
		cmp	bl, '0'		;Check whether a digit was read,
		jl	@04		; otherwise print error message
		cmp	bl, '9'
		jg	@04
		sub	bl, '0'
		mov	cx, 10		;Shift digit into current delay value
		mul	cx
		add	ax, bx
		adc	dx, 0
		or	dx, dx
		jne	@04
		mov	bl, [si]
		inc	si
		jmp	@05
@02:		mov	dx, Offset Usage
		mov	ah, 9		;No parameter was given, print usage
		int	21h
		jmp	@06
@04:		mov	dx, Offset BadParameters	;Print error message
@11:		call	WriteSentence
@06:		mov	al, 1		;Exit program with error status
@15:		mov	ah, 4Ch
		int	21h
@03:		or	ax, ax		;If delay is 0 then try to uninstall
		je	@07
		cmp	ax, 1		;If delay is not between 1 and 3600
		jl	@04		; then print error message
		cmp	ax, 3600
		jg	@04
@07:		mov	DelayRate, ax	;Store delay value
		xor	ax, ax		;Check whether the screen saver is
		mov	es, ax		; already installed
		mov	bx, 'NI'
		mov	cx, 'TE'
		int	2Fh
		push	cs
		pop	ds
		cmp	cx, 'OK'
		je	@08
		jmp	@09
@08:		mov	es, bx		;Screen saver already installed,
		mov	ax, DelayRate	; change delay value in the resident
		or	ax, ax		; part
		je	@10
		call	SetDelay
		mov	dx, Offset Reconfigured
		jmp	@11		;Print reconfiguration message
@10:		mov	al, 09h		;Check whether INT09, INT08, INT2F
		call	CheckInt	; and INT33 are pointing to the
		jne	@12		; segment of the resident part
		mov	al, 08h
		call	CheckInt
		jne	@12
		mov	al, 2Fh
		call	CheckInt
		jne	@12
		mov	al, 33h
		call	CheckInt
		je	@13
@12:		mov	dx, Offset CannotUninstall
		call	WriteSentence	;Other programs hooked on the same
		jmp	@06		; interrupts, cannot uninstall
@13:		mov	dx, word ptr es:OldInt09[0]
		mov	ds, word ptr es:OldInt09[2]
		mov	ax, 2509h	;Restore original handlers of INT09,
		int	21h		; INT08, INT2F and INT33
		mov	dx, word ptr es:OldInt08[0]
		mov	ds, word ptr es:OldInt08[2]
		mov	ax, 2508h
		int	21h
		mov	dx, word ptr es:OldInt2F[0]
		mov	ds, word ptr es:OldInt2F[2]
		mov	ax, 252Fh
		int	21h
		mov	dx, word ptr es:OldInt33[0]
		mov	ds, word ptr es:OldInt33[2]
		mov	ax, 2533h
		int	21h
		mov	ah, 49h		;Deallocate memory used by the
		int	21h		; resident part
		push	cs
		pop	ds
		mov	dx, Offset Uninstalled
		call	WriteSentence	;Print uninstallation message
		xor	al, al
		jmp	@15
@09:		mov	ax, DelayRate	;If the program is not yet installed
		or	ax, ax		; but uninstallation is requested
		jne	@14		; then print error message
		mov	dx, Offset NotYetInstalled
		jmp	@11
@14:		mov	ah, 2Ch		;Fill up seed number for "Random"
		int	21h		; with a value read from the timer
		mov	word ptr RandSeed[0], cx
		mov	word ptr RandSeed[2], dx
		push	cs
		pop	es
		call	SetDelay	;Initialize default value of delay
		mov	ax, SaverDelay	; timer, clear flags
		mov	SaverCount, ax
		mov	SaverOff, 0
		mov	SaverOn, 0
		mov	es, word ptr cs:[002Ch]
		mov	ah, 49h		;Deallocate the PSP of the program
		int	21h
		push	cs
		pop	ds
		mov	ax, 3509h	;Read and store original handlers of
		int	21h		; INT09, INT08, INT2F and INT33
		mov	word ptr OldInt09[0], bx
		mov	word ptr OldInt09[2], es
		mov	ax, 3508h
		int	21h
		mov	word ptr OldInt08[0], bx
		mov	word ptr OldInt08[2], es
		mov	ax, 352Fh
		int	21h
		mov	word ptr OldInt2F[0], bx
		mov	word ptr OldInt2F[2], es
		mov	ax, 3533h
		int	21h
		mov	word ptr OldInt33[0], bx
		mov	word ptr OldInt33[2], es
		mov	dx, Offset NewInt09
		mov	ax, 2509h	;Install new handlers for INT09,
		int	21h		; INT08, INT2F and INT33
		mov	dx, Offset NewInt08
		mov	ax, 2508h
		int	21h
		mov	dx, Offset NewInt2F
		mov	ax, 252Fh
		int	21h
		mov	dx, Offset NewInt33
		mov	ax, 2533h
		int	21h
		mov	cx, 0FFFFh	;Install new user-defined mouse
		push	cs		; subroutine
		pop	es
		mov	dx, Offset NewMouse
		mov	ax, 0Ch
		int	33h
		mov	dx, Offset Installed
		call	WriteSentence	;Print installation message
		mov	di, Offset DataStart	;Initialize the variable area
		mov	cx, DataEnd - DataStart	; of the resident part
		xor	al, al
		cld
		rep	stosb
		mov	dx, Offset ResidentEnd[1]
		int	27h		;Leave resident part in memory

WriteSentence:	push	dx		;Print the two halves of sentence
		mov	dx, Offset BeginSentence
		mov	ah, 9
		int	21h		;Print 'Starry Night ' and the other
		pop	dx		; part of the sentence
		mov	ah, 9
		int	21h
		retn

SetDelay:	mov	ax, DelayRate	;Set default value of delay timer
		mov	cx, 1091	;Multiply delay value with 1091
		mul	cx		; (ticks in a minute) and then divide
		mov	cx, 60		; it by 60 (seconds in a minute) and
		div	cx		; store result in the resident part
		mov	es:SaverDelay, ax
		mov	es:SaverCount, ax
		retn

CheckInt:	push	es		;Check segment of interrupt address
		mov	ah, 35h
		int	21h		;Read current address of interrupt
		mov	bx, es		; handler and check whether it points
		pop	es		; to the segment of the resident part
		mov	dx, es
		cmp	dx, bx
		retn

DelayRate	dw	0		;Temporary storage for delay value
Hello		db	'Starry Night screen saver by Joe Forster/STA', 13, 10, '$'
BeginSentence	db	13, 10, 'Starry Night $'
BadParameters	db	'is unchanged due to bad command line parameters.', 13, 10, '$'
NotYetInstalled	db	'is not yet installed.', 13, 10, '$'
CannotUninstall	db	'cannot be uninstalled - you''ve installed some programs after it.', 13, 10, '$'
Installed	db	'is installed.', 13, 10, '$'
Uninstalled	db	'is uninstalled.', 13, 10, '$'
Reconfigured	db	'is reconfigured.', 13, 10, '$'
Usage		db	13, 10, 'This program is a screen saver that shows you the same starry night that is  in', 13, 10
		db	'The Norton Commander. The delay should be given in seconds, between 1 and 3600.', 13, 10
		db	'Enter 0 for the delay to uninstall the screen saver.', 13, 10, 13, 10
		db	'Usage: STARNITE <delay>', 13, 10, '$'

CSeg		ends

		end	Main
