{
Ŀ
                 Joe Forster/STA                 
                                                 
                   STARARC.PAS                   
                                                 
                     Star ARC                    

}

program Star_ARC;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 0, 655360}

uses
  DOS, StarBase;

const
{LZ stack size}
  LZStackMax    = 512;

type
  LZEntry       = record
    Prefix      : Word;
    Ext         : Byte;
  end;

var
  Comment,
  ARCEnd,
  DecompError,
  DecompEnd    : Boolean;
  HeadLen,
  BitPos,
  RLECtrl,
  RLEByte,
  LZState,
  Kay,
  FinChar,
  ARCData,
  Data,
  CodeLen,
  Column,
  CRCXOR        : Byte;
  ReadSize,
  HuffCount,
  DiskCount,
  LZStackPtr,
  RLECount,
  Code,
  CodeNum,
  OldCode,
  InCode,
  Omega,
  CodeMax,
  CodeMaxTemp,
  CRC           : Word;
  ARCSize,
  ARCStart,
  Mask,
  Header,
  HeaderEnd     : Longint;
  TitleConvTable: PConvTable;
  ARCEntry      : TARCEntry;
  NumStr        : array [0..9] of Char;
  LZStack       : array [0..LZStackMax - 1] of Byte;
  LZTable       : array [0..4095] of LZEntry;
  HuffLen,
  HuffVal       : array [0..255] of Byte;
  HuffCode      : array [0..255] of Longint;
  DiskBuffer    : TDiskBuffer;

{Read a directory entry from the ARC archive}
function ReadARCEntry: Boolean;
var
  F             : Boolean;
  Z             : Word;
begin
  ExtSeek(ArcFile, Header);
  ExtBlockRead2(ArcFile, DiskBuffer, 11, Z);
  RLECtrl := 254;
  F := (Z = 11);
  if F then
  begin
    HeadLen := 11;
    Move(DiskBuffer[7], DiskBuffer[8], 4);
    DiskBuffer[7] := 0;
    Move(DiskBuffer, ARCEntry, 12);
    ExtBlockRead(ArcFile, ARCEntry.Name[1], Length(ARCEntry.Name));
    Inc(HeadLen, Length(ARCEntry.Name));
    case ARCEntry.Version of
      2:
      begin
        ExtBlockRead(ArcFile, ARCEntry.RecordLen, 3);
        Inc(HeadLen, 3);
        if ARCEntry.Method = 1 then ExtBlockRead(ArcFile, RLECtrl, 1);
      end;
      1:
    else
      F := False;
    end;
    if F then
    begin
      FileName := ARCEntry.Name;
      asm
        mov Error, False;
        mov ah, ARCEntry.FileType;
        xor al, al;
        cmp ah, 'D';
        je @2;
        inc al;
        cmp ah, 'S';
        je @2;
        inc al;
        cmp ah, 'P';
        je @2;
        inc al;
        cmp ah, 'U';
        jne @1;
    @2: or al, $80;
        mov Attr, al;
        jmp @3;
    @1: mov Error, True;
    @3:
      end;
      Error := Error or (IOResult <> 0) or not ((Length(ARCEntry.Name) <= 16) and (((ARCEntry.Version = 1) and
        (ARCEntry.Method <= 2)) or ((ARCEntry.Version = 2) and (ARCEntry.Method <= 5))) and
        (ARCEntry.Blocks <= 4133));
      if ARCEntry.Method = 5 then ARCEntry.OrigSize := -1;
      CopySize := ARCEntry.OrigSize;
      MakeASCIIName;
    end;
  end;
  ReadARCEntry := not Error and F;
end;

{Search for the start of the ARC archive}
function SearchARCStart: Boolean;
var
  O             : Boolean;
  W             : Word;
begin
  Header := 0;
  O := True;
  Header := 0;
  ExtBlockRead(ArcFile, DiskBuffer, 1);
  if DiskBuffer[0] <> 2 then
  begin
    O := (DiskBuffer[0] = 1);
    if O then
    begin
      ExtBlockRead(ArcFile, DiskBuffer, 6);
      if DiskBuffer[5] = $9E then
      begin
        ExtBlockRead(ArcFile, DiskBuffer, 2);
        W := BytesToLongint(DiskBuffer[3], DiskBuffer[4], 0, 0);
        Header := (W - 6) * 254;
        if (W = 15) and (DiskBuffer[1] = Ord('7')) then Dec(Header);
      end;
    end;
  end;
  O := O and (IOResult = 0);
  SearchARCStart := O;
end;

{Read a block of data from the ARC archive}
procedure ReadARCBlock;
begin
  if ARCSize > DiskBufferSize then DiskSize := DiskBufferSize else DiskSize := ARCSize;
  Dec(ARCSize, DiskSize);
  ExtBlockRead(ArcFile, DiskBuffer, DiskSize);
end;

{Read a byte from the ARC archive}
function ReadARCByte: Byte; assembler;
asm
    push si;
    push ax;
    mov si, DiskCount;
    cmp si, DiskSize;
    jb @1;
    mov ax, word ptr ARCSize[0];
    or ax, word ptr ARCSize[2];
    jne @2;
    inc ARCEnd;
    jmp @1;
@2: push es;
    push di;
    push bx;
    push cx;
    push dx;
    call ReadARCBlock;
    pop dx;
    pop cx;
    pop bx;
    pop di;
    pop es;
    xor si, si;
    mov DiskCount, si;
@1: pop ax;
    mov al, byte ptr DiskBuffer[si];
    pop si;
    inc DiskCount;
    mov ARCData, al;
    cmp ARCEnd, False;
end;

{Read a bit from the archive file
  Output : the bit}
function GetBit: Byte; assembler;
asm
    cmp BitPos, 0;
    jne @1;
    call ReadARCByte;
@1: mov al, ARCData;
    and al, 1;
    shr ARCData, 1;
    inc BitPos;
    cmp BitPos, 8;
    jb @2;
    mov BitPos, 0;
@2:
end;

{Sort the Huffman codes in the reverse order of length}
procedure SortHuffCodes;
var
  O             : Boolean;
  L,
  V             : Byte;
  H,
  I,
  J,
  K,
  S             : Integer;
  C             : Longint;
begin
  S := (256 shr 1);
  while S > 0 do
  begin
    K := 256 - S;
    J := 1;
    repeat
      I := J;
      repeat
        H := I + S;
        if ((HuffLen[I - 1] < HuffLen[H - 1]) or ((HuffLen[I - 1] = HuffLen[H - 1]) and
          (HuffVal[I - 1] < HuffVal[H - 1]))) then
        begin
          C := HuffCode[I - 1];
          L := HuffLen[I - 1];
          V := HuffVal[I - 1];
          HuffCode[I - 1] := HuffCode[H - 1];
          HuffLen[I - 1] := HuffLen[H - 1];
          HuffVal[I - 1] := HuffVal[H - 1];
          HuffCode[H - 1] := C;
          HuffLen[H - 1] := L;
          HuffVal[H - 1] := V;
          Dec(I, S);
        end
        else
        begin
          Break;
        end;
      until I < 1;
      Inc(J);
    until J > K;
    S := S shr 1;
  end;
end;

{Initialize variables needed for decompression and read in Huffman table, if
  needed}
procedure InitDecomp;
var
  B,
  C             : Byte;
begin
  DecompError := False;
  DecompEnd := False;
  BitPos := 0;
  CRC := 0;
  CRCXOR := 0;
  LZState := 0;
  RLECount := 1;
  ARCSize := (ARCEntry.Blocks * 254) - HeadLen;
  DiskSize := 0;
  DiskCount := 0;
  ARCEnd := False;
  if ARCEntry.Method in [2, 4] then
  begin
    HuffCount := 255;
    for B := 0 to 255 do
    begin
      HuffVal[B] := B;
      HuffLen[B] := 0;
      Mask := 1;
      for C := 1 to 5 do
      begin
        if GetBit > 0 then HuffLen[B] := HuffLen[B] or Mask;
        Mask := Mask shl 1;
      end;
      if HuffLen[B] > 24 then
      begin
        DecompError := True;
      end
      else
      begin
        HuffCode[B] := 0;
        C := HuffLen[B];
        if C > 0 then
        begin
          Mask := 1;
          while C > 0 do
          begin
            if GetBit > 0 then HuffCode[B] := HuffCode[B] or Mask;
            Mask := Mask shl 1;
            Dec(C);
          end;
        end
        else
        begin
          Dec(HuffCount);
        end;
      end;
    end;
    SortHuffCodes;
  end;
end;

{Get Huffman code and convert it to binary data}
function GetHuffCode: Byte; assembler;
asm
    xor ax, ax;
    xor dx, dx;
    mov cx, 1;
    mov word ptr Mask[0], cx;
    mov word ptr Mask[2], dx;
    mov bx, HuffCount;
    mov si, bx;
    shl si, 2;
@6: push si;
    push ax;
    push bx;
    push cx;
    push dx;
    call GetBit;
    or al, al;
    pop dx;
    pop cx;
    pop bx;
    pop ax;
    pop si;
    je @1;
    or ax, word ptr Mask[0];
    or dx, word ptr Mask[2];
@1: cmp byte ptr HuffLen[bx], cl;
    jne @2;
    cmp word ptr HuffCode[si], ax;
    jne @3;
    cmp word ptr HuffCode[si][2], dx;
    jne @3;
    mov al, byte ptr HuffVal[bx];
    jmp @4;
@3: or bx, bx;
    je @5;
    dec bx;
    sub si, 4;
    jmp @1;
@2: inc cl;
    shl word ptr Mask[0], 1;
    rol word ptr Mask[2], 1;
    cmp cl, 24;
    jb @6;
@5: mov DecompError, True;
@4:
end;

{Read LZ code from the archive file
  Output: the LZ code}
function GetLZCode: Word;
var
  B             : Byte;
begin
  Code := 0;
  B := CodeLen;
  while B > 0 do
  begin
    Code := (Code shl 1) or GetBit;
    Dec(B);
  end;
  if (Code = 256) and (ARCEntry.Method = 5) then
  begin
    B := 16;
    while B > 0 do
    begin
      ARCEntry.CheckSum := (ARCEntry.CheckSum shl 1) or GetBit;
      Dec(B);
    end;
    B := 24;
    while B > 0 do
    begin
      ARCEntry.OrigSize := (ARCEntry.OrigSize shl 1) or GetBit;
      Dec(B);
    end;
  end;
  if (CodeLen < 12) then
  begin
    Dec(CodeMaxTemp);
    if CodeMaxTemp = 0 then
    begin
      Inc(CodeLen);
      CodeMax := CodeMax shl 1;
      CodeMaxTemp := CodeMax;
    end;
  end;
  GetLZCode := Code;
end;

{Push a byte into the LZ stack
  Input : B: the byte to push}
procedure LZPush(B: Byte);
begin
  if LZStackPtr >= LZStackMax then
  begin
    DecompError := True;
  end
  else
  begin
    LZStack[LZStackPtr] := B;
    Inc(LZStackPtr);
  end;
end;

{Pop a byte from the LZ stack
  Output: the byte popped}
function LZPop: Byte;
begin
  if LZStackPtr = 0 then
  begin
    DecompError := True;
  end
  else
  begin
    Dec(LZStackPtr);
    LZPop := LZStack[LZStackPtr];
  end;
end;

{Uncrunch a byte
  Output: the uncrunched byte}
function UnCrunch: Byte;
begin
  case LZState of
    0:
    begin
      LZStackPtr := 0;
      CodeNum := 258;
      CodeMax := 256;
      CodeMaxTemp := 254;
      CodeLen := 9;
      OldCode := GetLZCode;
      if OldCode = 256 then
      begin
        DecompEnd := True;
      end
      else
      begin
        Kay := OldCode;
        FinChar := Kay;
        LZState := 1;
        UnCrunch := Kay;
      end;
    end;
    1:
    begin
      InCode := GetLZCode;
      if InCode = 256 then
      begin
        LZState := 0;
        DecompEnd := True;
      end
      else
      begin
        if InCode >= CodeNum then
        begin
          Kay := FinChar;
          LZPush(Kay);
          Code := OldCode;
          Omega := OldCode;
          InCode := CodeNum;
        end;
        while Code > 255 do
        begin
          LZPush(LZTable[Code].Ext);
          Code := LZTable[Code].Prefix;
        end;
        Kay := Code;
        FinChar := Code;
        LZState := 2;
        UnCrunch := Kay;
      end;
    end;
    2:
    begin
      if LZStackPtr = 0 then
      begin
        Omega := OldCode;
        if CodeNum < 4096 then
        begin
          LZTable[CodeNum].Prefix := Omega;
          LZTable[CodeNum].Ext := Kay;
          Inc(CodeNum);
        end;
        OldCode := InCode;
        LZState := 1;
        UnCrunch := UnCrunch;
      end
      else
      begin
        UnCrunch := LZPop;
      end;
    end;
  end;
end;

{Get an Huffman- and LZ-uncompressed byte from the archive file
  Output: the uncompressed byte}
function GetUncompByte: Byte;
begin
  case ARCEntry.Method of
    0, 1: GetUncompByte := ReadARCByte;
    2, 4: GetUncompByte := GetHuffCode;
    3, 5: GetUncompByte := UnCrunch;
  end;
end;

{Get a completely uncompressed byte from the archive file
  Output: the uncompressed byte}
function UnPack: Byte;
var
  B             : Byte;
begin
  Dec(RLECount);
  if RLECount = 0 then
  begin
    RLECount := 1;
    B := GetUncompByte;
    UnPack := B;
    if not (ARCEntry.Method in [0, 2]) then
    begin
      if B = RLECtrl then
      begin
        RLECount := GetUncompByte;
        RLEByte := GetUncompByte;
        if RLECount = 0 then
        begin
          RLECount := 256;
          if ARCEntry.Version = 1 then Dec(RLECount);
        end;
        B := RLEByte;
      end;
    end;
  end
  else
  begin
    B := RLEByte;
  end;
  DecompEnd := DecompEnd or DecompError;
  if ARCEntry.Version = 1 then
  begin
    Inc(CRC, B);
  end
  else
  begin
    Inc(CRCXOR);
    Inc(CRC, B xor CRCXOR);
  end;
  UnPack := B;
end;

{Get a block of uncompressed data from the archive file}
procedure GetBlock;
begin
  ReadSize := 0;
  while (ReadSize < 254) and (CopySize > 0) and not DecompEnd do
  begin
    Buffer^[ReadSize] := UnPack;
    if not DecompError then
    begin
      Inc(ReadSize);
      Dec(CopySize);
    end;
  end;
end;

begin
  WriteLn('Star ARC' + VersionStr + CopyrightStr);
  WriteLn;
  if Test8086 = 0 then
  begin
    WriteLn('This program requires an 80286 CPU or above');
  end
  else
  begin
    if ParamCount < 2 then
    begin
      WriteLn('This program lists and extracts Commodore ARC archives.');
      WriteLn;
      WriteLn('List   : STARARC [-]L <arcname>');
      WriteLn('Extract: STARARC [-]X <arcname> [-|/4|7|8|C|D|X[D|P|S]|Y] [<diskname>]');
    end
    else
    begin
      CommonInit;
      case Command of
        'L', 'X':
        begin
          if List then ParseCmdLine(NoOptions) else ParseCmdLine(ExtractOptions);
          if not Error then
          begin
            DiskName := UpperCase(LongParamStr(Number));
            ArcName := UpperCase(LongParamStr(2));
            SplitName(DiskName, Dir1, Name1, Ext1);
            SplitName(ArcName, Dir2, Name2, Ext2);
            if Ext2 = '.*' then Ext2 := '.arc';
            SearchPar := Dir2 + Name2 + Ext2;
            LongFindFirst(SearchPar, Archive + ReadOnly, Entry);
            if DOSError <> 0 then
            begin
              WriteLn(SearchPar, ' not found');
            end
            else
            begin
              repeat
                SplitName(Entry.LongName, Dir, Name2, Ext2);
                DiskName := Dir1 + CloneName(Name2, Name1) + GetDiskExt(DiskType);
                ArcName := Dir2 + Name2 + Ext2;
                Error := False;
                Comment := False;
                if LongOpenFile(ArcName, ArcFile, fmReadOnly) = 0 then
                begin
                  ExtGetFTime(ArcFile, FileDate);
                  if not SearchARCStart then
                  begin
                    if LineFeed then WriteLn;
                    WriteLn(ArcName, ' is not a valid ARC archive');
                  end
                  else
                  begin
                    Over := True;
                    ARCStart := Header;
                    FileCount := 0;
                    AllSize := 0;
                    AllBlocks := 0;
                    if LineFeed then WriteLn;
                    if List then Write('Listing') else Write('Extracting');
                    Write(' archive: ', ArcName);
                    if ReadARCEntry and (FileName = 'TITLE') then Comment := True;
                    if List then
                    begin
                      WriteLn;
                      WriteLn('Length  Blocks         Name          Type');
                      WriteLn('------  ------  ------------------  -----');
                    end
                    else
                    begin
                      WriteLn(' into ', DiskName);
                      Over := True;
                      if LongOpenFile(DiskName, Image, fmReadOnly) = 0 then
                      begin
                        ExtClose(Image);
                      end
                      else
                      begin
                        if CreateDisk <> 0 then
                        begin
                          WriteLn('Cannot create ', DiskName);
                          Over := False;
                        end;
                      end;
                    end;
                    if Over then
                    begin
                      FileCount := 0;
                      FileNum := 65535;
                      while not EscPressed and not Error and (FileCount < FileNum) do
                      begin
                        if ReadARCEntry then
                        begin
                          if Error then
                          begin
                            WriteLn(ArcName, ' has an invalid entry');
                          end
                          else
                          begin
                            if not List and Comment and (FileName = 'TITLE') then
                            begin
                              InitDecomp;
                              Escape;
                              Column := 0;
                              TitleConvTable := ConvTable;
                              while not EscPressed and not DecompEnd and not DecompError do
                              begin
                                Data := UnPack;
                                case Data of
                                  $0D:
                                  begin
                                    Data := 0;
                                    Column := 0;
                                    WriteLn;
                                  end;
                                  $0E:
                                  begin
                                    Data := 0;
                                    TitleConvTable := @PETToASCLower;
                                  end;
                                  $8E:
                                  begin
                                    Data := 0;
                                    TitleConvTable := @PETToASCUpper;
                                  end;
                                  $00..$1F, $80..$9F: Data := 0;
                                  $20..$7F, $A0..$FF: Data := TitleConvTable^[Data];
                                end;
                                if Data <> 0 then
                                begin
                                  Write(Chr(Data));
                                  Inc(Column);
                                  if Column = 40 then
                                  begin
                                    Column := 0;
                                    WriteLn;
                                  end;
                                end;
                                Escape;
                              end;
                            end
                            else
                            begin
                              asm
                                mov ax, word ptr CopySize[0];
                                mov dx, word ptr CopySize[2];
                                mov cx, 254;
                                div cx;
                                or dx, dx;
                                je @1;
                                inc ax;
                            @1: mov BlockNum, ax;
                              end;
                              Inc(AllSize, CopySize);
                              Inc(AllBlocks, BlockNum);
                              if Attr and $40 = 0 then Protected := ' ' else Protected := '<';
                              if Attr and $80 = 0 then Closed := '*' else Closed := ' ';
                              if List then
                              begin
                                PCName := '"' + ASCIIName + '"';
                                while Length(PCName) < 18 do PCName := PCName + ' ';
                                WriteLn(CopySize:6, '  ', BlockNum:6, '  ', PCName, '  ',
                                  Closed, ShortCBMExt[Attr and 7], Protected);
                              end
                              else
                              begin
                                Escape;
                                if not EscPressed then
                                begin
                                  MakeName;
                                  Over := Question('Extract ' + PCName, 'Always', 'nEver', '', Confirm);
                                  if Over then
                                  begin
                                    repeat
                                      if OpenWrite(FileName, Attr, CopySize, False) = 254 then
                                      begin
                                        Error := False;
                                        Over := Question(PCName + ' exists. Extract anyway', 'Always',
                                          'nEver', 'Rename', Overwrite);
                                        if Over then Over := (OpenWrite(FileName, Attr, CopySize, True) = 0);
                                      end;
                                    until Over or (Overwrite <> aaRename);
                                  end;
                                  if not Over then WriteLn('  Skipping:   ', PCName);
                                  if Over and not Error then
                                  begin
                                    Buffer := New(PBuffer);
                                    FillChar(Buffer^, BufferSize, 0);
                                    WriteLn('  Extracting: ', PCName);
                                    InitDecomp;
                                    while not EscPressed and (CopySize > 0) and not DecompEnd and not Error do
                                    begin
                                      GetBlock;
                                      WritePart(Buffer, ReadSize, (DecompEnd or (CopySize = 0)));
                                      Escape;
                                    end;
                                    Error := Error or (CRC <> ARCEntry.CheckSum);
                                    if (IOResult <> 0) or Error then WriteLn('Cannot extract ', PCName, ' correctly');
                                    CloseWrite;
                                    Dispose(Buffer);
                                  end;
                                end;
                              end;
                            end;
                            Inc(Header, ARCEntry.Blocks * 254);
                          end;
                        end
                        else
                        begin
                          FileNum := FileCount;
                        end;
                        Inc(FileCount);
                      end;
                      if List then
                      begin
                        WriteLn('------  ------  ------------------  -----');
                        Write(AllSize:6, '  ', AllBlocks:6, '  ');
                        Count := 12;
                        if FileNum = 1 then Inc(Count);
                        Write(FileNum:Count, ' file');
                        if FileNum > 1 then Write('s');
                        WriteLn;
                      end;
                    end;
                    ExtClose(ArcFile);
                    if not List and not Error and Question('Delete ' + ArcName, 'Always', 'nEver', '', Delete) then
                      LongErase(ArcFile.LongName);
                    LineFeed := True;
                  end;
                end
                else
                begin
                  WriteLn;
                  WriteLn('Cannot open ', ArcName);
                end;
                LongFindNext(Entry);
              until (DOSError <> 0) or EscPressed;
              LongFindClose(Entry);
            end;
          end;
        end;
      else
        WriteLn('Unknown command');
      end;
    end;
  end;
end.
