{
Ŀ
                 Joe Forster/STA                 
                                                 
                   STARLHA.PAS                   
                                                 
                    Star LHA                     

}

program Star_LHA;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 65536, 65536}

uses
  DOS, StarBase;

var
  Comment,
  SelfExtract,
  LHAEnd        : Boolean;
  HeaderLen,
  Column        : Byte;
  CRCSum,
  DiskCount,
  TempSize      : Word;
  TempStart,
  Header        : Longint;
  ConvTable     : PConvTable;
  Creator,
  ArcName2,
  TempName      : string;
  LHAEntry      : TLHAEntry;
  DiskBuffer    : TDiskBuffer;

{LHA self-extractor program}
procedure LHAExtractor; external;
{$L LHASFX.OBJ}

{Read a directory entry from the LHA archive}
function ReadLHAEntry(var F: ExtFile): Boolean;
var
  B,
  O             : Boolean;
  P,
  Q             : Byte;
  E             : string[4];
  S             : string[80];
begin
  repeat
    B := False;
    ExtSeek(F, Header);
    O := not ExtEOF(F);
    if O then
    begin
      ExtBlockRead(F, HeaderLen, 1);
      O := (HeaderLen > 0);
      Error := Error or (IOResult <> 0) or (HeaderLen > 80);
      if O and not Error then
      begin
        ExtBlockRead(F, LHAEntry, HeaderLen + 1);
        Error := Error or (IOResult <> 0);
        if not Error then
        begin
          asm
            mov si, Offset(LHAEntry[1]);
            mov cl, HeaderLen;
            xor ch, ch;
            xor ah, ah;
            cld;
        @7: lodsb;
            add ah, al;
            loop @7;
            mov al, LHAEntry.CheckSum;
            cmp ah, LHAEntry.CheckSum;
            jne @5;
            sub si, 2;
            lodsw;
            mov CRCSum, ax;
            push ds;
            pop es;
            mov di, Offset(LHAEntry.Name);
            mov bx, di;
            mov cl, [di];
            xor ch, ch;
            xor al, al;
            jcxz @1;
            inc di;
            cld;
            repne scasb;
            jne @1;
            mov ax, di;
            sub ax, bx;
            sub ax, 2;
            mov [bx], al;
            mov al, [di];
        @1: or al, al;
            jne @8;
            mov al, 'P';
        @8: mov FileType, al;
            mov ax, word ptr LHAEntry.OrigSize[0];
            mov dx, word ptr LHAEntry.OrigSize[2];
            mov word ptr CopySize[0], ax;
            mov word ptr CopySize[2], dx;
            mov cx, 254;
            div cx;
            or dx, dx;
            je @2;
            inc ax;
            jmp @3;
        @2: mov dx, 254;
        @3: mov ByteNum, dx;
            mov BlockNum, ax;
            mov ah, FileType;
            xor al, al;
            cmp ah, 'D';
            je @4;
            inc al;
            cmp ah, 'S';
            je @4;
            inc al;
            cmp ah, 'P';
            je @4;
            inc al;
            cmp ah, 'U';
            je @4;
            mov al, 2;
        @4: mov Attr, al;
            jmp @6;
        @5: mov Error, True;
        @6:
          end;
          Inc(Header, HeaderLen + LHAEntry.PackSize + 2);
          LHAEntry.Name := ShrinkName(LHAEntry.Name, '\');
          if LHAEntry.Name <> '' then
          begin
            ASCIIName := LHAEntry.Name;
            ConvertCBMName(ASCIIName, FileName);
            B := True;
          end;
        end;
      end;
      O := O and not Error;
      if not O then FileNum := FileCount;
    end;
  until not O or B;
  ReadLHAEntry := O;
end;

{Read a block of data from the LHA archive}
procedure ReadLHABlock;
begin
  if CopySize > DiskBufferSize then DiskSize := DiskBufferSize else DiskSize := CopySize;
  Dec(CopySize, DiskSize);
  ExtBlockRead(ArcFile, DiskBuffer, DiskSize);
end;

{Read a byte from the LHA archive}
function ReadLHAByte: Byte; assembler;
asm
    push si;
    push ax;
    mov si, DiskCount;
    cmp si, DiskSize;
    jb @1;
    mov ax, word ptr CopySize[0];
    or ax, word ptr CopySize[2];
    jne @2;
    inc LHAEnd;
    jmp @1;
@2: push es;
    push di;
    push bx;
    push cx;
    push dx;
    call ReadLHABlock;
    pop dx;
    pop cx;
    pop bx;
    pop di;
    pop es;
    xor si, si;
    mov DiskCount, si;
@1: pop ax;
    mov al, byte ptr DiskBuffer[si];
    pop si;
    inc DiskCount;
    inc word ptr Header[0];
    jne @3;
    inc word ptr Header[2];
@3: cmp LHAEnd, False;
end;

{Search for the start of the LHA archive}
function SearchLHAStart: Boolean;
var
  O             : Boolean;
begin
  Header := 0;
  O := False;
  CopySize := ExtFileSize(ArcFile);
  asm
    xor ax, ax;
    mov DiskCount, ax;
    mov DiskSize, ax;
    mov LHAEnd, al;
    call ReadLHAByte;
    jne @1;
    call ReadLHAByte;
    jne @1;
@2: call ReadLHAByte;
    jne @1;
@3: cmp al, '-';
    jne @2;
    call ReadLHAByte;
    jne @1;
    cmp al, 'l';
    jne @3;
    call ReadLHAByte;
    jne @1;
    cmp al, 'h';
    jne @3;
    mov O, True;
    mov ax, word ptr Header[0];
    mov dx, word ptr Header[2];
    sub ax, 5;
    sbb dx, 0;
    mov word ptr Header[0], ax;
    mov word ptr Header[2], dx;
@1:
  end;
  O := O and (IOResult = 0);
  SearchLHAStart := O;
end;

{Create a temporary name}
function GetTempName(N: Byte): string;
begin
  Str(N, TempName);
  while Length(TempName) < 3 do TempName := '0' + TempName;
  TempName := TempBaseName + '.' + TempName;
end;

{LHA 'Add' option processor}
procedure LHAAddOptions(const Option: string); far;
begin
  if Option[1] = 'S' then SelfExtract := True else AddOptions(Option);
end;

begin
  WriteLn('Star LHA' + VersionStr + CopyrightStr);
  WriteLn;
  if Test8086 = 0 then
  begin
    WriteLn('This program requires an 80286 CPU or above');
  end
  else
  begin
    if ParamCount < 2 then
    begin
      WriteLn('This program creates, lists and extracts Commodore  LHA  archives.  Note:  Put');
      WriteLn('LHA for DOS 2.14 or above into your path to create and extract archives!');
      WriteLn;
      WriteLn('Create       : STARLHA [-]A <diskname> [-|/C|S|Y] [<lhaname>]');
      WriteLn('List         : STARLHA [-]L <lhaname>');
      WriteLn('Add/strip SFX: STARLHA [-]S[+|-] <lhaname>');
      WriteLn('Extract      : STARLHA [-]X <lhaname> [-|/C|X[D|P|S]|Y] [<diskname>]');
    end
    else
    begin
      CommonInit;
      SelfExtract := False;
      case Command of
        'A':
        begin
          ParseCmdLine(LHAAddOptions);
          if not Error then
          begin
            DiskName := UpperCase(LongParamStr(2));
            ArcName := UpperCase(LongParamStr(Number));
            SplitName(DiskName, Dir1, Name1, Ext1);
            SplitName(ArcName, Dir2, Name2, Ext2);
            FixDiskExt(Ext1);
            if Ext2 = '.*' then if SelfExtract then Ext2 := '.sfx' else Ext2 := '.lzh';
            SearchPar := Dir1 + Name1 + Ext1;
            LongFindFirst(SearchPar, Archive + ReadOnly, Entry);
            if DOSError <> 0 then
            begin
              WriteLn(SearchPar, ' not found');
            end
            else
            begin
              repeat
                FileNum := 0;
                TempSize := 0;
                SplitName(Entry.LongName, Dir, Name1, Ext1);
                DiskName := Dir1 + Entry.LongName;
                ArcName := Dir2 + CloneName(Name1, Name2) + Ext2;
                if LineFeed then WriteLn;
                Write('Creating ');
                if SelfExtract then Write ('SFX ');
                WriteLn('archive: ', ArcName, ' out of ', DiskName);
                Over := True;
                Error := False;
                IOError := 0;
                if LongOpenFile(ArcName, ArcFile, fmReadOnly) = 0 then
                begin
                  ExtClose(ArcFile);
                  Over := Question(ArcName + ' exists. Overwrite', 'Always', 'nEver', '', Overwrite);
                end;
                if Over then
                begin
                  if LongOpenFile(ArcFile.LongName, ArcFile, fmWriteOnly) = 0 then
                  begin
                    if OpenImage(False) = 0 then
                    begin
                      FileCount := 1;
                      FileNum := 0;
                      while not EscPressed and not Error and ReadCBMEntry(CBMEntry) do
                      begin
                        if CBMEntry.Attr > 0 then
                        begin
                          Escape;
                          Attr := CBMEntry.Attr and 7;
                          if not EscPressed and (Attr in [0..3]) then
                          begin
                            FileName := CBMEntry.Name;
                            MakeName;
                            OpenRead;
                            AllSize := 0;
                            Buffer := New(PBuffer);
                            WriteLn('  Adding: ', PCName);
                            GetTempName(FileCount);
                            Error := Error or (LongOpenFile(TempName, TempFile, fmWriteOnly) <> 0);
                            if not Error then
                            begin
                              if (Track > 0) and ((Track <> DirTrack) or (Sector > FirstDirSector)) then
                              begin
                                while not Error and not _End do
                                begin
                                  ReadPart(Buffer, TempSize);
                                  Inc(AllSize, TempSize);
                                  ExtBlockWrite(TempFile, Buffer^, TempSize);
                                end;
                              end;
                              Dispose(Buffer);
                              if (IOResult <> 0) or Error then WriteLn('Cannot add ', PCName, ' correctly');
                              Inc(FileNum);
                              Inc(FileCount);
                              ExtSetFTime(TempFile, FileDate);
                              ExtClose(TempFile);
                              Write('Compressing temporary archive, please wait...', #13);
                              SwapVectors;
                              Exec(GetEnv('COMSPEC'), '/C LHA A -M2 -N2 -O -T1 -W ' + TempBaseName + Ext2 + ' ' + TempName);
                              SwapVectors;
                              LongErase(TempFile.LongName);
                              IOError := LongOpenFile(TempBaseName + Ext2, TempFile, fmReadOnly);
                              if IOError = 0 then ExtClose(TempFile);
                              Error := (DOSError <> 0) or (IOError <> 0);
                              if Error then
                              begin
                                WriteLn;
                                WriteLn('Cannot compress temporary archive correctly');
                              end;
                              ClrLine;
                            end;
                          end;
                        end;
                      end;
                      CloseImage;
                    end
                    else
                    begin
                      WriteLn(DiskName, ' is not a valid disk image');
                    end;
                    if not Error and (FileNum > 0) then
                    begin
                      if LongOpenFile(TempBaseName + Ext2, TempFile, fmReadOnly) = 0 then
                      begin
                        if OpenImage(False) = 0 then
                        begin
                          Write('Converting temporary archive', #13);
                          Header := 0;
                          if SelfExtract then ExtBlockWrite(ArcFile, @LHAExtractor^, LHAExtractLen);
                          while not Error and ReadCBMEntry(CBMEntry) and ReadLHAEntry(TempFile) do
                          begin
                            FileName := CBMEntry.Name;
                            MakeASCIIName;
                            LHAEntry.Name := ASCIIName;
                            FileType := UpCase(ShortCBMExt[CBMEntry.Attr and 7][1]);
                            asm
                              mov si, Offset(LHAEntry[1]);
                              mov cl, byte ptr LHAEntry.Name[0];
                              xor ch, ch;
                              mov di, cx;
                              add cl, 22;
                              add di, Offset(LHAEntry.Name[1]);
                              push ds;
                              pop es;
                              cld;
                              mov ah, FileType;
                              cmp ah, 'P';
                              je @2;
                              xor al, al;
                              stosw;
                              add cl, 2;
                              add byte ptr LHAEntry.Name[0], 2;
                          @2: mov ax, CRCSum;
                              stosw;
                              mov HeaderLen, cl;
                              xor ah, ah;
                          @1: lodsb;
                              add ah, al;
                              loop @1;
                              mov LHAEntry.CheckSum, ah;
                            end;
                            ExtBlockWrite(ArcFile, HeaderLen, 1);
                            ExtBlockWrite(ArcFile, LHAEntry, HeaderLen + 1);
                            Buffer := New(PBuffer);
                            CopySize := LHAEntry.PackSize;
                            while (CopySize > 0) and not Error do
                            begin
                              if CopySize > BufferSize then TempSize := BufferSize else TempSize := CopySize;
                              Dec(CopySize, TempSize);
                              ExtBlockRead(TempFile, Buffer^, TempSize);
                              ExtBlockWrite(ArcFile, Buffer^, TempSize);
                              Error := (IOResult <> 0);
                            end;
                            Dispose(Buffer);
                          end;
                          CloseImage;
                        end;
                        ExtClose(TempFile);
                        LongErase(TempFile.LongName);
                      end;
                      HeaderLen := 0;
                      ExtBlockWrite(ArcFile, HeaderLen, 1);
                      ExtSetFTime(ArcFile, FileDate);
                      ClrLine;
                    end;
                    ExtClose(ArcFile);
                    if FileNum = 0 then
                    begin
                      WriteLn(DiskName, ' is empty');
                    end;
                    if Error or (FileNum = 0) then LongErase(ArcFile.LongName);
                    if not Error and Question('Delete ' + DiskName, 'Always', 'nEver', '', Delete) then
                      LongErase(Image.LongName);
                    LineFeed := True;
                  end
                  else
                  begin
                    WriteLn('Cannot create ', ArcName);
                  end;
                end;
                LongFindNext(Entry);
              until (DOSError <> 0) or EscPressed;
              LongFindClose(Entry);
            end;
          end;
        end;
        'L', 'X':
        begin
          if List then ParseCmdLine(NoOptions) else ParseCmdLine(ExtractOptions);
          if not Error then
          begin
            DiskName := UpperCase(LongParamStr(Number));
            ArcName := UpperCase(LongParamStr(2));
            SplitName(DiskName, Dir1, Name1, Ext1);
            SplitName(ArcName, Dir2, Name2, Ext2);
            if Ext2 = '.*' then Ext2 := '.lzh';
            SearchPar := Dir2 + Name2 + Ext2;
            LongFindFirst(SearchPar, Archive + ReadOnly, Entry);
            if DOSError <> 0 then
            begin
              WriteLn(SearchPar, ' not found');
            end
            else
            begin
              repeat
                SplitName(Entry.LongName, Dir, Name2, Ext2);
                DiskName := Dir1 + CloneName(Name2, Name1) + GetDiskExt(DiskType);
                ArcName := Dir2 + Name2 + Ext2;
                Error := False;
                Comment := False;
                if LongOpenFile(ArcName, ArcFile, fmReadOnly) = 0 then
                begin
                  ExtGetFTime(ArcFile, FileDate);
                  if not SearchLHAStart then
                  begin
                    if LineFeed then WriteLn;
                    WriteLn(ArcName, ' is not a valid LHA archive');
                  end
                  else
                  begin
                    if not List then
                    begin
                      if LineFeed then
                      begin
                        LineFeed := False;
                        WriteLn;
                      end;
                      Write('Decompressing archive ', ArcName, ', please wait...', #13);
                      GetTempName(0);
                      SwapVectors;
                      Exec(GetEnv('COMSPEC'), '/C LHA P -M2 -N2 ' + ShortName(ArcName, True) + ' > ' + TempName);
                      SwapVectors;
                      Error := (DOSError <> 0);
                      IOError := LongOpenFile(TempName, TempFile, fmReadOnly);
                      Error := Error or (IOError <> 0);
                      if IOError = 0 then ExtClose(TempFile);
                    end;
                    if Error then
                    begin
                      WriteLn;
                      WriteLn('Cannot decompress ', ArcName, ' correctly');
                    end
                    else
                    begin
                      ClrLine;
                      Over := True;
                      TempStart := 0;
                      AllSize := 0;
                      AllBlocks := 0;
                      if LineFeed then WriteLn;
                      if List then Write('Listing') else Write('Extracting');
                      Write(' archive: ', ArcName);
                      if List then WriteLn else WriteLn(' into ', DiskName);
                      AllSize := Header;
                      if ReadLHAEntry(ArcFile) and (ASCIIName = 'title') then Comment := True;
                      Header := AllSize;
                      if List then
                      begin
                        WriteLn('Length  Blocks         Name        Type');
                        WriteLn('------  ------  ------------------  ---');
                      end
                      else
                      begin
                        Over := True;
                        if LongOpenFile(DiskName, Image, fmReadOnly) = 0 then
                        begin
                          ExtClose(Image);
                        end
                        else
                        begin
                          if CreateDisk <> 0 then
                          begin
                            WriteLn('Cannot create ', DiskName);
                            Over := False;
                          end;
                        end;
                      end;
                      if Over then
                      begin
                        FileNum := 65535;
                        if not List then LongOpenFile(TempFile.LongName, TempFile, fmReadOnly);
                        while not EscPressed and not Error and (FileCount < FileNum) do
                        begin
                          if ReadLHAEntry(ArcFile) then
                          begin
                            if Error then
                            begin
                              WriteLn(ArcName, ' has an invalid entry');
                            end
                            else
                            begin
                              if not List and Comment and (ASCIIName = 'title') then
                              begin
                                ExtSeek(TempFile, TempStart);
                                CopySize := 0;
                                Escape;
                                Column := 0;
                                ConvTable := @PETToASCUpper;
                                while not EscPressed and (CopySize < LHAEntry.OrigSize) do
                                begin
                                  ExtBlockRead(TempFile, Data, 1);
                                  case Data of
                                    $0D:
                                    begin
                                      Data := 0;
                                      Column := 0;
                                      WriteLn;
                                    end;
                                    $0E:
                                    begin
                                      Data := 0;
                                      ConvTable := @PETToASCLower;
                                    end;
                                    $8E:
                                    begin
                                      Data := 0;
                                      ConvTable := @PETToASCUpper;
                                    end;
                                    $00..$1F, $80..$9F: Data := 0;
                                    $20..$7F, $A0..$FF: Data := ConvTable^[Data];
                                  end;
                                  if Data <> 0 then
                                  begin
                                    Write(Chr(Data));
                                    Inc(Column);
                                    if Column = 40 then
                                    begin
                                      Column := 0;
                                      WriteLn;
                                    end;
                                  end;
                                  Inc(CopySize);
                                  Escape;
                                end;
                              end
                              else
                              begin
                                Inc(AllSize, CopySize);
                                Inc(AllBlocks, BlockNum);
                                if List then
                                begin
                                  PCName := '"' + ASCIIName + '"';
                                  while Length(PCName) < 18 do PCName := PCName + ' ';
                                  WriteLn(CopySize:6, '  ', BlockNum:6, '  ', PCName, '  ', ShortCBMExt[Attr]);
                                end
                                else
                                begin
                                  Escape;
                                  if not EscPressed then
                                  begin
                                    MakeName;
                                    Over := Question('Extract ' + PCName, 'Always', 'nEver', '', Confirm);
                                    if Over then
                                    begin
                                      repeat
                                        if OpenWrite(FileName, Attr, CopySize, False) = 254 then
                                        begin
                                          Error := False;
                                          Over := Question(PCName + ' exists. Extract anyway', 'Always',
                                            'nEver', 'Rename', Overwrite);
                                          if Over then Over := (OpenWrite(FileName, Attr, CopySize, True) = 0);
                                        end;
                                      until Over or (Overwrite <> aaRename);
                                    end;
                                    if not Over then WriteLn('  Skipping:   ', PCName);
                                    if Over and not Error then
                                    begin
                                      Buffer := New(PBuffer);
                                      FillChar(Buffer^, BufferSize, 0);
                                      WriteLn('  Extracting: ', PCName);
                                      ExtSeek(TempFile, TempStart);
                                      while not EscPressed and (CopySize > 0) and not _End and not Error do
                                      begin
                                        if CopySize > BufferSize then TempSize := BufferSize else TempSize := CopySize;
                                        Dec(CopySize, TempSize);
                                        ExtBlockRead(TempFile, Buffer^, TempSize);
                                        WritePart(Buffer, TempSize, (CopySize = 0));
                                        Escape;
                                      end;
                                      if (IOResult <> 0) or Error then WriteLn('Cannot extract ', PCName, ' correctly');
                                      CloseWrite;
                                      Dispose(Buffer);
                                    end;
                                  end;
                                end;
                                Inc(FileCount);
                              end;
                              Inc(TempStart, LHAEntry.OrigSize);
                            end;
                          end
                          else
                          begin
                            FileNum := FileCount;
                          end;
                        end;
                      end;
                      if List then
                      begin
                        WriteLn('------  ------  ------------------  ---');
                        Write(AllSize:6, '  ', AllBlocks:6, '  ');
                        Count := 12;
                        if (FileNum = 1) or (FileNum = 65535) then Inc(Count);
                        Write(FileNum:Count, ' file');
                        if FileNum > 1 then Write('s');
                        WriteLn;
                      end
                      else
                      begin
                        ExtClose(TempFile);
                        LongErase(TempFile.LongName);
                      end;
                    end;
                  end;
                  ExtClose(ArcFile);
                  if not List and not Error and Question('Delete ' + ArcName, 'Always', 'nEver', '', Delete) then
                    LongErase(ArcFile.LongName);
                  LineFeed := True;
                end
                else
                begin
                  WriteLn;
                  WriteLn('Cannot open ', ArcName);
                end;
                LongFindNext(Entry);
              until (DOSError <> 0) or EscPressed;
              LongFindClose(Entry);
            end;
          end;
        end;
        'S':
        begin
          ParseCmdLine(AddOptions);
          if not Error then
          begin
            if Length(SearchPar) < 2 then
            begin
              SelfExtract := True;
            end
            else
            begin
              case SearchPar[2] of
                '+': SelfExtract := True;
                '-': SelfExtract := False;
              else
                Error := True;
              end;
            end;
          end;
          if not Error then
          begin
            ArcName := UpperCase(LongParamStr(2));
            SplitName(ArcName, Dir1, Name1, Ext1);
            if Ext1 = '.*' then Ext1 := '.lzh';
            if not SelfExtract then Ext1 := '.sfx';
            SearchPar := Dir1 + Name1 + Ext1;
            LongFindFirst(SearchPar, Archive + ReadOnly, Entry);
            if DOSError <> 0 then
            begin
              WriteLn(SearchPar, ' not found');
            end
            else
            begin
              repeat
                SplitName(Entry.LongName, Dir, Name2, Ext2);
                if SelfExtract then
                begin
                  Ext2 := '.sfx';
                end
                else
                begin
                  Ext1 := '.sfx';
                  Ext2 := '.lzh';
                end;
                ArcName := Dir1 + CloneName(Name2, Name1);
                ArcName2 := ArcName + Ext2;
                ArcName := ArcName + Ext1;
                if LineFeed then WriteLn;
                if SelfExtract then Write('Adding ') else Write('Stripping ');
                Write('SFX header');
                if SelfExtract then Write(' to ') else Write(' off ');
                WriteLn('archive: ', ArcName);
                Over := True;
                Error := False;
                IOError := 0;
                if LongOpenFile(ArcName2, TempFile, fmReadOnly) = 0 then
                begin
                  ExtClose(TempFile);
                  Over := Question(ArcName2 + ' exists. Overwrite', 'Always', 'nEver', '', Overwrite);
                end;
                if Over then
                begin
                  if LongOpenFile(TempFile.LongName, TempFile, fmWriteOnly) = 0 then
                  begin
                    if LongOpenFile(ArcName, ArcFile, fmReadOnly) = 0 then
                    begin
                      if not SearchLHAStart then
                      begin
                        if LineFeed then WriteLn;
                        WriteLn(ArcName, ' is not a valid LHA archive');
                        ExtClose(ArcFile);
                        ExtClose(TempFile);
                        LongErase(TempFile.LongName);
                      end
                      else
                      begin
                        CopySize := ExtFileSize(ArcFile) - Header;
                        if SelfExtract then ExtBlockWrite(TempFile, @LHAExtractor^, LHAExtractLen);
                        ExtSeek(ArcFile, Header);
                        while CopySize > 0 do
                        begin
                          if CopySize > DiskBufferSize then DiskSize := DiskBufferSize else DiskSize := CopySize;
                          ExtBlockRead(ArcFile, DiskBuffer, DiskSize);
                          ExtBlockWrite(TempFile, DiskBuffer, DiskSize);
                          Dec(CopySize, DiskSize);
                        end;
                        ExtGetFTime(ArcFile, FileDate);
                        ExtSetFTime(TempFile, FileDate);
                        ExtClose(ArcFile);
                        ExtClose(TempFile);
                      end;
                    end;
                  end;
                end;
                LongFindNext(Entry);
              until (DOSError <> 0) or EscPressed;
              LongFindClose(Entry);
            end;
          end;
        end;
      else
        WriteLn('Unknown command');
      end;
    end;
  end;
end.
