{
Ŀ
                 Joe Forster/STA                 
                                                 
                   STARLIST.PAS                  
                                                 
                    Star List                    

}

program Star_List;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 0, 655360}

uses
  DOS, StarBase;

const
  MaxByte       = 255;
  MaxWord       = 65535;
  MaxStrLen     = 254;
{Maximum width of fields}
  MaxWidth      = MaxByte;
{Format flags}
  ffNone        = $00;
  ffUpperCase   = $01;
  ffQuoted      = $02;
  ffHexaConvert = $04;
  ffGEOS        = $08;
  ffSum         = $10;
  ffNoDir       = $00;
  ffRightDir    = $40;
  ffLeftDir     = $80;
  ffDirection   = $C0;
{Condition flags}
  cfNormal      = $00;
  cfFirstFile   = $01;
  cfLastFile    = $02;
  cfHeader      = $04;
  cfFooter      = $08;
  cfCondEnd     = $80;
{Signature for file image header}
  PC64Sign      : string[8] = 'C64File' + #0;
{Hexadecimal digits}
  HexaNum       : string[16] = '0123456789ABCDEF';
{Number of days in the months}
  DayNum        : array [1..12] of Word = (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
{GEOS extensions}
  ShortGEOSExt  : array [1..14] of string[3] = ('BAS', 'ASM', 'DAT', 'SYS', 'ACC', 'APP', 'DOC', 'FNT', 'PRN',
                  'INP', 'DSK', 'BOT', 'TMP', 'AUT');
{End-of-line}
  EOL           : string[2] = #13#10;

type
{Format specifier record}
  TFormatSpec    = record
    Padding     : Byte;
    PaddingDir  : Byte;
    MaxWidth    : Byte;
    MaxWidthDir : Byte;
    Flags       : Byte;
    FieldType   : Char;
  end;
  PFormatSpec   = ^TFormatSpec;
{Condition specifier record}
  TCondSpec     = record
    CondType    : Byte;
  end;
  PCondSpec     = ^TCondSpec;

var
  Found,
  Paging,
  Formatted,
  FormatOK,
  LoadAddrOK,
  NextLoadAddrOK,
  Subdirs,
  FirstImage,
  FirstFile,
  LastFile,
  ContProcess,
  ArcEnd        : Boolean;
  FirstTrack,
  LastTrack,
  PanelMode,
  ScreenHeight,
  LineCount     : Byte;
  Free,
  LongFree,
  ArcBufPos,
  ArcBufSize,
  FormatSize,
  OutputSize,
  NextLoadAddr,
  DirPos,
  DirLength,
  LoadAddr      : Word;
  ImageNum,
  ArcPos,
  ArcSize,
  HeaderPos,
  PrevSize,
  LongSize,
  LongAllSize,
  ImagePos,
  PrevImagePos,
  ImageSize     : Longint;
  FormatBuffer  : PDiskBuffer;
  OutputBuffer  : PBuffer;
  Ext,
  GEOSExt       : string[3];
  DiskID        : string[5];
  DiskLabel     : string[16];
  TypeStr       : string[20];
  _Label        : string[24];
  ListStr       : string[80];
  Name0,
  Ext0,
  ImageName,
  ListName,
  FormatName    : string;
  ListFile      : ExtFile;
  LHAEntry      : TLHAEntry;
  ARCEntry      : TARCEntry;
  NextEntry     : TDirEntry;
  TempBuffer    : array [0..511] of Byte;

{Read a number from an archive file
  Input : SI: offset of current character in the buffer
          CX: base number
  Output: AX:DX: longint read from the buffer
          BL: the character following the number
          CF: if 1 then an invalid character was found}
function ReadNum: Longint; assembler;
asm
@6: cmp byte ptr TempBuffer[si], ' ';
    jne @5;
    inc si;
    jmp @6;
@5: xor ax, ax;
    xor bx, bx;
@2: mov dl, byte ptr TempBuffer[si];
    cmp dl, 'a';
    jb @8;
    cmp dl, 'z';
    ja @8;
    sub dl, 'a' - 'A';
@8: sub dl, '0';
    cmp dl, 9;
    jbe @9;
    sub dl, 'A' - '0' - 10;
@9: cmp dl, cl;
    ja @1;
    xor dh, dh;
    mov di, dx;
    xor dx, dx;
    xchg ax, bx;
    mul cx;
    or dx, dx;
    jne @3;
    xchg ax, bx;
    mul cx;
    add bx, dx;
    jc @3;
    add ax, di;
    adc bx, 0;
    jc @3;
    inc si;
    jmp @2;
@1: cmp byte ptr TempBuffer[si], ' ';
    jne @7;
    inc si;
    jmp @1;
@7: mov dx, bx;
    mov bl, byte ptr TempBuffer[si];
    clc;
    jmp @4;
@3: stc;
@4:
end;

{Convert a long integer into a hexadecimal string
  Input : D: the long integer
          L: number of digits to put into the string
  Output: the hexadecimal string}
function HexaStr(D: Longint; L: Byte): string;
var
  I             : Byte;
  S             : string;
begin
  S := '';
  for I := L - 1 downto 0 do S := S + HexaNum[(D shr (I * 4) and $0F) + 1];
  HexaStr := S;
end;

{Convert a hexadecimal string into a long integer
  Input : S: the hexadecimal string
          Code: when not 0, an error occured
  Output: the converted long integer}
function HexaEval(const S: string; var Code: Integer): Longint;
var
  I,
  X             : Byte;
  V             : Longint;
begin
  V := 0;
  I := 1;
  Code := 0;
  while (Code = 0) and (I <= Length(S)) do
  begin
    X := LeftPos(UpCase(S[I]), HexaNum);
    if X = 0 then Code := I else V := V shl 4 + X - 1;
    Inc(I);
  end;
  HexaEval := V;
end;

{Read a block of data from the archive}
procedure ReadArcBlock;
begin
  if ArcSize > 256 then ArcBufSize := 256 else ArcBufSize := ArcSize;
  Dec(ArcSize, ArcBufSize);
  ExtBlockRead(Image, DirBuffer, ArcBufSize);
end;

{Read a byte from the archive
  Output: AL: the current byte}
function ReadArcByte: Byte; assembler;
asm
    push si;
    push ax;
    mov si, ArcBufPos;
    cmp si, ArcBufSize;
    jb @1;
    mov ax, word ptr ArcSize[0];
    or ax, word ptr ArcSize[2];
    jne @2;
    inc ArcEnd;
    jmp @1;
@2: push es;
    push di;
    push bx;
    push cx;
    push dx;
    call ReadArcBlock;
    pop dx;
    pop cx;
    pop bx;
    pop di;
    pop es;
    xor si, si;
    mov ArcBufPos, si;
@1: pop ax;
    mov al, byte ptr DirBuffer[si];
    pop si;
    inc ArcBufPos;
    inc word ptr ArcPos[0];
    jne @3;
    inc word ptr ArcPos[2];
@3: cmp ArcEnd, False;
end;

{Read the specified block from the tape image into the given buffer
  Input : S: number of the block
          Buffer: buffer to read the block into}
procedure ReadTapeBlock(S: Word; Buffer: PBlock);
begin
  ExtSeek(Image, S shl 5);
  ExtBlockRead(Image, Buffer^, 48);
end;

{Read a directory entry from the image file or archive file
  Input : Entry: entry record to contain the directory entry
  Output: when False, an empty directory entry was read}
function ReadCBMEntry(var Entry: TDirEntry): Boolean;
var
  B,
  F,
  O             : Boolean;
  M,
  P,
  Q             : Byte;
  W,
  X,
  Y,
  Z             : Word;
  I             : Integer;
  L,
  T             : Longint;
  E             : string[4];
  S             : string[80];
begin
  B := True;
  O := True;
  NextLoadAddr := 0;
  NextLoadAddrOK := False;
  case PanelMode of
    pmDisk:
    begin
      Inc(Number);
      Inc(DirPos);
      if Number = 8 then
      begin
        Number := 0;
        if (DirBuffer[0] = 0) then
        begin
          B := False;
        end
        else
        begin
          DirSector := DirBuffer[1];
          if (DirBuffer[0] = DirTrack) and ValidPos(DirTrack, DirSector) then
          begin
            ReadDiskBlock(DirTrack, DirSector, @DirBuffer);
          end
          else
          begin
            DirBuffer[0] := 0;
            B := False;
          end;
        end;
      end;
      if B then
      begin
        EntryPos := Number shl 5;
        Entry.Attr := DirBuffer[EntryPos + 2];
        Entry.ExtAttr := DirBuffer[EntryPos + 24];
        if not (Entry.ExtAttr in [1..14]) then Entry.ExtAttr := 0;
        if (Entry.ExtAttr > 0) and (DirBuffer[EntryPos + 23] > 0) then Entry.ExtAttr := Entry.ExtAttr or $80;
        Track := DirBuffer[EntryPos + 3];
        Sector := DirBuffer[EntryPos + 4];
        SideTrack := DirBuffer[EntryPos + 21];
        SideSector := DirBuffer[EntryPos + 22];
        Entry.Track := Track;
        Entry.Sector := Sector;
        Entry.SideTrack := SideTrack;
        Entry.SideSector := SideSector;
        Entry.Name := '';
        for P := 0 to 15 do Entry.Name := Entry.Name + Chr(DirBuffer[EntryPos + P + 5]);
        Entry.Name := CutChar(Entry.Name, #160);
        Entry.Size := BytesToLongint(DirBuffer[EntryPos + 30], DirBuffer[EntryPos + 31], 0, 0);
      end;
    end;
    pmTape:
    begin
      Inc(DirPos);
      if DirPos = ImageSize + 2 then
      begin
        B := False;
        ImagePos := ExtFileSize(Image);
      end
      else
      begin
        ReadTapeBlock(DirPos, @DirBuffer);
        Entry.Attr := DirBuffer[0];
        if (Entry.Attr in [1, 3]) then
        begin
          if Entry.Attr = 1 then Entry.Attr := DirBuffer[1] else Entry.Attr := $87;
          if (Entry.Attr < $80) or ((Entry.Attr > $84) and (Entry.Attr <> $87)) then Entry.Attr := $82;
          ImagePos := BytesToLongint(DirBuffer[8], DirBuffer[9], DirBuffer[10], DirBuffer[11]);
          if DirPos = ImageSize + 1 then
          begin
            L := ExtFileSize(Image);
          end
          else
          begin
            ReadTapeBlock(DirPos + 1, @DirBuffer[32]);
            if DirBuffer[32] in [1, 3] then L := BytesToLongint(DirBuffer[40], DirBuffer[41], DirBuffer[42], DirBuffer[43])
              else L := ExtFileSize(Image);
          end;
          Entry.Name := '';
          for P := 0 to 15 do Entry.Name := Entry.Name + Chr(DirBuffer[P + 16]);
          Entry.Name := CutChar(Entry.Name, ' ');
          NextLoadAddr := BytesToLongint(DirBuffer[2], DirBuffer[3], 0, 0);
          NextLoadAddrOK := True;
        end
        else
        begin
          B := False;
          ImagePos := ExtFileSize(Image);
          L := ImagePos;
        end;
        Entry.Size := L - ImagePos;
      end;
    end;
    pmFile:
    begin
      if DirPos = 0 then
      begin
        Inc(DirPos);
        S := FileExt(ImageName);
        Entry.Attr := 0;
        for P := 1 to 4 do if S[1] = LoCase(ShortCBMExt[P][1]) then Entry.Attr := P or $80;
        Entry.Name := _Label;
        Entry.Name := CutChar(Entry.Name, #0);
        NextLoadAddr := BytesToLongint(DirBuffer[26], DirBuffer[27], 0, 0);
        NextLoadAddrOK := True;
        Entry.Size := ImagePos - 26;
      end
      else
      begin
        B := False;
      end;
    end;
    pmLynx..pmLibrary:
    begin
      if DirPos = ImageSize then
      begin
        B := False;
        ImagePos := ExtFileSize(Image);
      end
      else
      begin
        ExtSeek(Image, HeaderPos);
        ExtBlockRead(Image, TempBuffer, 32);
        B := (IOResult = 0);
        if B then
        begin
          M := PanelMode;
          asm
            cmp M, pmArkive;
            je @7;
            xor si, si;
        @2: mov al, byte ptr TempBuffer[si];
            cmp al, 13;
            je @3;
            mov byte ptr S[si][1], al;
            inc si;
            cmp si, 17;
            jb @2;
            xor si, si;
        @3: mov ax, si;
            mov byte ptr S[0], al;
            or si, si;
            je @1;
            inc si;
            cmp M, pmLibrary;
            je @9;
            mov cx, 10;
            call ReadNum;
            jc @1;
            or dx, dx;
            jne @1;
            cmp bl, 13;
            jne @1;
            mov X, ax;
            inc si;
        @9: mov ah, byte ptr TempBuffer[si];
            xor al, al;
            cmp ah, 'D';
            je @5;
            inc al;
            cmp ah, 'S';
            je @5;
            inc al;
            cmp ah, 'P';
            je @5;
            inc al;
            cmp ah, 'U';
            jne @1;
        @5: mov Q, al;
            inc si;
            mov al, byte ptr TempBuffer[si];
            cmp al, 13;
            jne @1;
            inc si;
            mov cx, 10;
            call ReadNum;
            jc @1;
            or dx, dx;
            jne @1;
            cmp bl, 13;
            jne @1;
            cmp M, pmLibrary;
            jne @10;
            inc si;
            jmp @6;
        @10:or dx, dx;
            jne @1;
            mov Y, ax;
            inc si;
        @8: mov ax, Y;
            xor dx, dx;
            or ax, ax;
            je @6;
            mov ax, X;
            mov cx, 254;
            mul cx;
            sub ax, 255;
            sbb dx, 0;
            add ax, Y;
            adc dx, 0;
        @6: mov W, si;
            mov word ptr L[0], ax;
            mov word ptr L[2], dx;
            jmp @4;
        @7: mov si, Offset(TempBuffer);
            cld;
            lodsb;
            mov Q, al;
            lodsb;
            xor ah, ah;
            mov Y, ax;
            push ss;
            pop es;
            lea di, S;
            mov al, 16;
            stosb;
            mov cl, al;
            xor ch, ch;
            rep movsb;
            add si, 9;
            lodsw;
            mov X, ax;
            mov si, 29;
            jmp @8;
        @1: mov B, False;
        @4:
          end;
        end;
        Error := not B;
        if B then
        begin
          Inc(DirPos);
          Inc(HeaderPos, W);
          Inc(ImagePos, PrevSize);
          Entry.Name := CutChar(S, #160);
          Entry.Attr := Q or $80;
          Entry.Size := L;
          if M = pmLibrary then PrevSize := L else PrevSize := Longint(X) * 254;
        end;
      end;
    end;
    pmTAR:
    begin
      repeat
        ExtSeek(Image, HeaderPos);
        ExtBlockRead(Image, TempBuffer, 512);
        B := (IOResult = 0);
        if B then B := (TempBuffer[0] <> 0);
        if B then
        begin
          asm
            mov bx, $0100;
            xor dx, dx;
            xor ah, ah;
            mov si, Offset(TempBuffer);
            mov cx, $0094;
            cld;
        @1: lodsb;
            add bx, ax;
            adc dx, 0;
            loop @1;
            add si, 8;
            mov cx, $0164;
        @2: lodsb;
            add bx, ax;
            adc dx, 0;
            loop @2;
            push bx;
            push dx;
            mov si, $0094;
            mov cx, 8;
            call ReadNum;
            pop cx;
            pop bx;
            jc @3;
            cmp ax, bx;
            jne @3;
            cmp dx, cx;
            jne @3;
            mov si, Offset(TempBuffer);
            push ss;
            pop es;
            lea di, S[1];
            cld;
            xor cl, cl;
        @6: lodsb;
            or al, al;
            je @5;
            stosb;
            inc cl;
            jmp @6;
        @5: mov byte ptr S[0], cl;
            mov si, $0080;
            mov cx, 8;
            call ReadNum;
            jc @3;
            mov word ptr L[0], ax;
            mov word ptr L[2], dx;
            mov si, $0088;
            mov cx, 8;
            call ReadNum;
            jc @3;
            mov word ptr T[0], ax;
            mov word ptr T[2], dx;
            jmp @4;
        @3: mov B, False;
        @4:
          end;
          Error := not B;
          if B then
          begin
            PrevSize := L and $FFFFFE00;
            if L and $000001FF > 0 then Inc(PrevSize, 512);
            ImagePos := HeaderPos + 512;
            HeaderPos := ImagePos + PrevSize;
            Entry.Attr := $82;
            Entry.Size := L;
            Entry.Time := T;
            if S <> '' then
            begin
              if (Length(S) > 4) and (S[Length(S) - 3] = '.') then
              begin
                E := LowerCase(Copy(S, Length(S) - 2, 3));
                F := False;
                M := 0;
                while not F and (M < 8) do
                begin
                  F := (E = ShortCBMExt[M]);
                  if not F then Inc(M);
                end;
                if F then
                begin
                  Dec(S[0], 4);
                  Entry.Attr := M or $80;
                end;
              end;
              FileName := ShrinkName(S, '/');
              if FileName <> '' then
              begin
                Entry.Name := FileName;
                Inc(DirPos);
                Inc(ImageSize);
                O := True;
              end;
            end;
          end;
        end;
      until not B or O;
    end;
    pmLHA, pmLHASFX:
    begin
      repeat
        O := False;
        ExtSeek(Image, HeaderPos);
        ExtBlockRead(Image, M, 1);
        B := (M in [0..79]) and (IOResult = 0);
        if B then
        begin
          ExtBlockRead(Image, LHAEntry, M + 1);
          B := B and (IOResult = 0);
          if B then
          begin
            asm
              mov si, Offset(LHAEntry[1]);
              mov cl, M;
              xor ch, ch;
              xor ah, ah;
              cld;
          @5: lodsb;
              add ah, al;
              loop @5;
              mov al, LHAEntry.CheckSum;
              cmp ah, LHAEntry.CheckSum;
              jne @3;
              sub si, 2;
              lodsw;
              push ds;
              pop es;
              mov di, Offset(LHAEntry.Name);
              mov bx, di;
              mov cl, [di];
              xor ch, ch;
              xor al, al;
              jcxz @1;
              inc di;
              cld;
              repne scasb;
              jne @1;
              mov ax, di;
              sub ax, bx;
              sub ax, 2;
              mov [bx], al;
              mov al, [di];
          @1: or al, al;
              jne @6;
              mov al, 'P';
          @6: mov P, al;
              mov ax, word ptr LHAEntry.OrigSize[0];
              mov dx, word ptr LHAEntry.OrigSize[2];
              mov word ptr L[0], ax;
              mov word ptr L[2], dx;
              mov ah, P;
              xor al, al;
              cmp ah, 'D';
              je @2;
              inc al;
              cmp ah, 'S';
              je @2;
              inc al;
              or ah, ah;
              je @2;
              cmp ah, 'P';
              je @2;
              inc al;
              cmp ah, 'U';
              jne @3;
          @2: mov Q, al;
              jmp @4;
          @3: mov B, False;
          @4:
            end;
            Error := not B;
            if B then
            begin
              Inc(DirPos);
              Inc(HeaderPos, M + LHAEntry.PackSize + 2);
              Inc(ImagePos, PrevSize);
              Entry.Attr := Q or $80;
              Entry.Size := L;
              PrevSize := LHAEntry.OrigSize;
              FileName := ShrinkName(LHAEntry.Name, '\');
              Entry.Name := FileName;
              if Entry.Name <> '' then
              begin
                Inc(DirPos);
                Inc(ImageSize);
                O := True;
              end;
            end;
          end;
        end;
      until not B or O;
    end;
    pmARC, pmARCSDA:
    begin
      ExtSeek(Image, HeaderPos);
      ExtBlockRead2(Image, TempBuffer, 11, Z);
      if Z = 11 then
      begin
        Move(TempBuffer[7], TempBuffer[8], 4);
        TempBuffer[7] := 0;
        Move(TempBuffer, ARCEntry, 12);
        ExtBlockRead(Image, ARCEntry.Name[1], Length(ARCEntry.Name));
        if ARCEntry.Version = 2 then ExtBlockRead(Image, ARCEntry.RecordLen, 3);
        FileName := ARCEntry.Name;
        asm
          mov Error, False;
          mov ah, ARCEntry.FileType;
          xor al, al;
          cmp ah, 'D';
          je @2;
          inc al;
          cmp ah, 'S';
          je @2;
          inc al;
          cmp ah, 'P';
          je @2;
          inc al;
          cmp ah, 'U';
          jne @1;
      @2: or al, $80;
          mov CBMEntry.Attr, al;
          jmp @3;
      @1: mov Error, True;
      @3:
        end;
        Error := Error or (IOResult <> 0) or not ((Length(ARCEntry.Name) <= 16) and (((ARCEntry.Version = 1) and
          (ARCEntry.Method <= 2)) or ((ARCEntry.Version = 2) and (ARCEntry.Method <= 5))) and
          (ARCEntry.Blocks <= 4133));
        if not Error then
        begin
          if ARCEntry.Method = 5 then ARCEntry.OrigSize := 0;
          Entry.Name := ARCEntry.Name;
          Entry.Size := ByteToBlock(ARCEntry.OrigSize);
          Inc(HeaderPos, ARCEntry.Blocks * 254);
        end;
      end;
      B := not Error and (Z = 11);
    end;
    pmFileZip:
    begin
      if DirPos = ImageSize then
      begin
        B := False;
        ImagePos := ExtFileSize(Image);
      end
      else
      begin
        ExtSeek(Image, HeaderPos);
        ExtBlockRead(Image, DirBuffer, 21);
        B := (IOResult = 0);
        if B then
        begin
          asm
            mov si, Offset(DirBuffer);
            push ss;
            pop es;
            lea di, S;
            mov cx, 16;
            cld;
            mov al, cl;
            stosb;
            rep movsb;
            lodsb;
            mov P, al;
            lodsw;
            mov X, ax;
            mov ah, P;
            and ah, $7F;
            xor al, al;
            cmp ah, 'D';
            je @2;
            inc al;
            cmp ah, 'S';
            je @2;
            inc al;
            cmp ah, 'P';
            je @2;
            inc al;
            cmp ah, 'U';
            jne @3;
        @2: mov Q, al;
            jmp @4;
        @3: mov B, False;
        @4:
          end;
        end;
        Error := not B;
        if B then
        begin
          Inc(DirPos);
          Inc(HeaderPos, 21);
          Inc(ImagePos, PrevSize);
          Entry.Name := CutChar(S, #160);
          Entry.Attr := Q or $80;
          Entry.Size := Longint(X);
          PrevSize := Longint(X);
        end;
      end;
    end;
  end;
  ReadCBMEntry := B;
end;

{Open the image file or archive file
  Output: when not 0, an error occured}
function OpenImage: Integer;
var
  B             : Boolean;
  P,
  Q             : Byte;
  W,
  X             : Word;
  I             : Integer;
  H,
  L             : Longint;
  S             : string[80];
  E             : TDirEntry;
begin
  I := IOResult;
  _Label := '';
  DiskID := '';
  PrevSize := 0;
  DirPos := 0;
  ImagePos := 0;
  I := LongOpenFile(ImageName, Image, fmReadOnly);
  DirLength := MaxWord;
  Free := 0;
  LongFree := 0;
  GEOSFormat := False;
  if I = 0 then
  begin
    case PanelMode of
      pmDisk:
      begin
        DiskType := GetDiskType(ExtFileSize(Image));
        B := (DiskType <> MaxByte);
        if B then
        begin
          CheckDiskType;
          FirstTrack := 1;
          LastTrack := MaxTrack;
          DirSector := 0;
          ReadDiskBlock(DirTrack, 0, @BAM);
          ImageSize := 0;
          for P := 0 to 15 do _Label := _Label + Chr(BAM[P + $90]);
          DiskLabel := CutChar(_Label, #160);
          DiskID := '';
          for P := 0 to 4 do DiskID := DiskID + Chr(BAM[P + $A2]);
          _Label := _Label + ',' + DiskID;
          for P := FirstTrack to LastTrack - 1 do
          begin
            Q := BAM[GetBAMOffset(P, False)];
            Inc(LongFree, Q);
            if (P <> DirTrack) and (P <> DirTrack2) then Inc(Free, Q);
          end;
          if DiskType and $7F = dt1581 then DirSector := 3 else Inc(DirSector);
          ReadDiskBlock(DirTrack, DirSector, @DirBuffer);
          Number := MaxByte;
          if DiskType and $7F = dt1581 then DirLength := 296 else DirLength := 144;
          CheckGEOSFormat(@BAM);
        end
        else
        begin
          I := 255;
        end;
      end;
      pmTape:
      begin
        if ExtFileSize(Image) > 95 then
        begin
          DirPos := 0;
          ReadTapeBlock(DirPos, @DirBuffer);
          DirPos := 1;
          ReadTapeBlock(DirPos, @DirBuffer);
          ImageSize := BytesToLongint(DirBuffer[2], DirBuffer[3], 0, 0);
          for P := 0 to 23 do _Label := _Label + Chr(DirBuffer[P + 8]);
          _Label := CutChar(_Label, ' ');
        end
        else
        begin
          I := 255;
        end;
      end;
      pmFile:
      begin
        if ExtFileSize(Image) > 25 then
        begin
          ExtBlockRead(Image, DirBuffer, 28);
          for P := 0 to 7 do _Label := _Label + Chr(DirBuffer[P]);
        end;
        if _Label = PC64Sign then
        begin
          DirPos := 0;
          ImagePos := ExtFileSize(Image);
          _Label := '';
          for P := 0 to 15 do _Label := _Label + Chr(DirBuffer[P + 8]);
          _Label := CutChar(_Label, #0);
        end
        else
        begin
          I := 255;
        end;
      end;
      pmLynx:
      begin
        if ExtFileSize(Image) >= 254 then
        begin
          ExtBlockRead(Image, DirBuffer, 128);
          asm
            xor si, si;
        @3: cmp word ptr DirBuffer[si], 0;
            jne @1;
            cmp word ptr DirBuffer[si][2], $0D00;
            jne @1;
            add si, 4;
            jmp @2;
        @1: inc si;
            cmp si, 92;
            jb @3;
            xor si, si;
        @2: mov word ptr L[0], si;
            mov word ptr L[2], 0;
          end;
          ExtSeek(Image, L);
          ExtBlockRead(Image, TempBuffer, 128);
          asm
            xor si, si;
            mov cx, 10;
            call ReadNum;
            jc @1;
            or dx, dx;
            jne @1;
            or ax, ax;
            je @1;
            mov W, ax;
            mov dx, si;
            xor bl, bl;
        @5: cmp byte ptr TempBuffer[si], 13;
            je @2;
            cmp word ptr TempBuffer[si], 'YL';
            jne @6;
            cmp word ptr TempBuffer[si][2], 'XN';
            jne @6;
            inc bl;
        @6: inc si;
            cmp si, 30;
            jb @5;
            jmp @1;
        @2: or bl, bl;
            je @1;
            inc si;
            xchg si, dx;
            mov cx, dx;
            sub cx, si;
            add si, Offset(TempBuffer);
            lea di, S;
            push ss;
            pop es;
            cld;
            mov al, cl;
            stosb;
            rep movsb;
            mov si, dx;
            mov cx, 10;
            call ReadNum;
            jc @1;
            or dx, dx;
            jne @1;
            or ax, ax;
            je @1;
            cmp bl, 13;
            jne @1;
            mov X, ax;
            inc si;
            add word ptr L[0], si;
            jmp @3;
        @1: mov I, 255;
        @3:
          end;
          if I = 0 then
          begin
            ImageSize := X;
            ImagePos := W * 254;
            HeaderPos := L;
            _Label := S;
          end;
        end
        else
        begin
          I := 255;
        end;
      end;
      pmArkive:
      begin
        if ExtFileSize(Image) >= 254 then
        begin
          ExtBlockRead(Image, P, 1);
          asm
            mov al, P;
            xor ah, ah;
            mov X, ax;
            mov cl, 29;
            mul cl;
            inc ax;
            mov cl, 254;
            div cl;
            or ah, ah;
            je @1;
            inc al;
        @1: xor ah, ah;
            mov W, ax;
          end;
          ImageSize := X;
          ImagePos := W * 254;
          HeaderPos := 1;
        end
        else
        begin
          I := 255;
        end;
      end;
      pmLibrary:
      begin
        if ExtFileSize(Image) >= 10 then
        begin
          ExtBlockRead(Image, TempBuffer, 10);
          asm
            cmp word ptr TempBuffer[0], 'WD';
            jne @1;
            cmp byte ptr TempBuffer[2], 'B';
            jne @1;
            mov si, 3;
            mov cx, 10;
            call ReadNum;
            jc @1;
            or dx, dx;
            jne @1;
            or ax, ax;
            je @1;
            cmp bl, 13;
            jne @1;
            mov X, ax;
            inc si;
            mov word ptr L[0], si;
            mov word ptr L[2], 0;
            jmp @2;
        @1: mov I, 255;
        @2:
          end;
          if I = 0 then
          begin
            ImageSize := X;
            HeaderPos := L;
            for X := 1 to ImageSize do ReadCBMEntry(E);
            DirPos := 0;
            PrevSize := 0;
            ImagePos := HeaderPos;
            HeaderPos := L;
          end;
        end
        else
        begin
          I := 255;
        end;
      end;
      pmTAR:
      begin
        if ExtFileSize(Image) >= 512 then
        begin
          ImageSize := 0;
          HeaderPos := 0;
          ImagePos := 0;
          PrevSize := 0;
        end
        else
        begin
          I := 255;
        end;
      end;
      pmLHA, pmLHASFX:
      begin
        ArcPos := 0;
        ArcSize := ExtFileSize(Image);
        asm
          xor ax, ax;
          mov ArcBufPos, ax;
          mov ArcBufSize, ax;
          mov ArcEnd, al;
          call ReadArcByte;
          jne @1;
          call ReadArcByte;
          jne @1;
      @2: call ReadArcByte;
          jne @1;
      @3: cmp al, '-';
          jne @2;
          call ReadArcByte;
          jne @1;
          cmp al, 'l';
          jne @3;
          call ReadArcByte;
          jne @1;
          cmp al, 'h';
          jne @3;
          jmp @4;
      @1: mov I, 255;
      @4:
        end;
        if I = 0 then HeaderPos := ArcPos - 5;
      end;
      pmARC, pmARCSDA:
      begin
        HeaderPos := 0;
        ExtBlockRead(Image, P, 1);
        if P <> 2 then
        begin
          if P = 1 then
          begin
            ExtBlockRead(Image, TempBuffer, 6);
            if TempBuffer[5] = $9E then
            begin
              ExtBlockRead(Image, TempBuffer, 2);
              W := BytesToLongint(TempBuffer[3], TempBuffer[4], 0, 0);
              HeaderPos := (W - 6) * 254;
              if (W = 15) and (TempBuffer[1] = Ord('7')) then Dec(HeaderPos);
            end;
          end
          else
          begin
            I := 255;
          end;
        end;
      end;
      pmFileZip:
      begin
        if ExtFileSize(Image) > 512 then
        begin
          ExtSeek(Image, 512);
          ExtBlockRead(Image, P, 1);
          ImageSize := P;
          HeaderPos := 513;
        end;
      end;
    end;
  end;
  if I = 5 then I := 0;
  if PanelMode <> pmDisk then DiskLabel := _Label;
  OpenImage := I;
end;

{Print a line feed onto the screen and pause if a screenful of text has been
  output}
procedure NextLine;
begin
  if Paging then
  begin
    Inc(LineCount);
    if LineCount >= ScreenHeight then
    begin
      LineCount := 0;
      ClrLine;
      Write('Press any key to continue...');
      asm
        xor ah, ah;
        int $16;
      end;
      ClrLine;
    end;
  end;
end;

{Write a line onto the screen or into the list file}
procedure WriteLine(Line: string; LineFeed: Boolean);
begin
  if ListName = '' then
  begin
    Write(Line);
    if LineFeed then WriteLn;
  end
  else
  begin
    ExtBlockWrite(ListFile, Line[1], Length(Line));
    if LineFeed then ExtBlockWrite(ListFile, EOL[1], Length(EOL));
  end;
end;

{Print the header line}
procedure HeaderLine;
begin
  WriteLine('------  ------------------  -----', False);
  if Verbose and (PanelMode in [pmDisk..pmFile, pmLynx..pmLibrary]) then WriteLine('  -----', True) else
    WriteLine('', True);
  NextLine;
end;

{Read the load address from the image or archive file}
procedure GetLoadAddr;
begin
  case PanelMode of
    pmDisk:
    begin
      ReadDiskBlock(CBMEntry.Track, CBMEntry.Sector, @DataBuffer);
      if (DataBuffer[0] > 0) or (DataBuffer[1] > 3) then
      begin
        LoadAddr := BytesToLongint(DataBuffer[2], DataBuffer[3], 0, 0);
        LoadAddrOK := True;
      end;
    end;
    pmLynx..pmTAR:
    begin
      if CBMEntry.Size > 0 then
      begin
        ExtSeek(Image, PrevImagePos);
        ExtBlockRead(Image, LoadAddr, SizeOf(Word));
        LoadAddrOK := True;
      end;
    end;
  end;
end;

{Format the output, based on the specification
  Input : CondType: the type of the conditional block; when 0, the complete
                    format specification is processed, otherwise only
                    blocks inside conditional blocks of the specified type
          DispNormal: when True, the main part of the specification is
                      output; otherwise only conditional parts}
procedure FormatOutput(CondType: Byte; DispNormal: Boolean);
var
  F,
  G,
  O             : Boolean;
  B,
  D,
  X,
  Z             : Byte;
  C             : Char;
  I             : Word;
  S             : string;
  T             : PFormatSpec;
  U             : PCondSpec;

{Process an indicator character and output the character or a '1' if the
  character is not a space; otherwise, output an empty string or a '0'
  Input : Ch: the character to process}
procedure ProcessChar(Ch: Char);
begin
  if O then
  begin
    S[0] := #1;
    S[1] := Chr(Ord('0') + Byte(Ch <> ' '));
  end
  else
  begin
    S := Ch;
    if Ch = ' ' then S := '';
  end;
end;

{Take the width byte apart into direction and length
  Width: the width byte
  WidthDir: the width direction byte}
procedure ProcessWidth(Width, WidthDir: Byte);
begin
  F := (WidthDir and ffLeftDir = 0);
  G := (WidthDir and ffRightDir = 0);
  D := Width;
end;

{Convert a PETSCII string into ASCII form, taking several format flags into
  account
  Input : Name: the PETSCII string to convert
  Output: the converted string}
function ConvertCBMName(const Name: string): string;
var
  C             : Char;
  I             : Word;
  B             : PBlock;
  S             : string;

{Put a hexadecimal code into the output string, if an invalid PETSCII
  character was encountered}
procedure PutHexaCode;
begin
  S := S + '%' + HexaStr(Ord(C), 2);
end;

begin
  if PanelMode in [pmTAR, pmLHA, pmLHASFX] then
  begin
    ConvertCBMName := Name;
  end
  else
  begin
    S := '';
    if X and ffUpperCase > 0 then B := @PETtoASCUpper else B := @PETtoASCLower;
    for I := 1 to Length(Name) do
    begin
      C := Name[I];
      if GEOSFormat and (X and ffGEOS > 0) then
      begin
        C := Chr(Ord(C) and $7F);
        if (X and ffHexaConvert = 0) or (C in [' '..#$7E]) then S := S + C else PutHexaCode;
      end
      else
      begin
        if (X and ffHexaConvert = 0) or (C in [' '..'!', '#'..'$', '&'..')', '+'..'.', '0'..':', '=', '@'..'Z', '[', ']'])
          or ((X and ffUpperCase = 0) and (C in [#$C1..#$DA])) then S := S + Chr(B^[Ord(C)]) else PutHexaCode;
      end;
    end;
    ConvertCBMName := S;
  end;
end;

{Put a string constant into the output buffer}
procedure PutString(Str: PString);
var
  I             : Word;
begin
  I := BufferSize - OutputSize - 1;
  if B < I then I := B;
  if I > 0 then
  begin
    Move(Str^, OutputBuffer^[OutputSize], I);
    Inc(OutputSize, I);
  end;
end;

begin
  I := 0;
  Z := 0;
  if (CondType = 0) and DispNormal then Inc(Z);
  OutputSize := 0;
  while I < FormatSize do
  begin
    B := FormatBuffer^[I];
    Inc(I);
    case B of
      0:
      begin
        if Z > 0 then
        begin
          T := PFormatSpec(@FormatBuffer^[I]);
          S := '';
          C := UpCase(T^.FieldType);
          X := T^.Flags;
          O := (T^.FieldType = C);
          case C of
            'A':
            begin
              S := '';
              if O then
              begin
                if PanelMode = pmDisk then S := LeadingZero(CBMEntry.Track, 2) + ';' + LeadingZero(CBMEntry.Sector, 2);
              end
              else
              begin
                GetLoadAddr;
                if LoadAddrOK and (PanelMode in [pmDisk..pmFile, pmLynx..pmTAR]) then S := '$' + HexaStr(LoadAddr, 4);
              end;
            end;
            'B': if O then S := LeadingZero(LongFree, 0) else S := LeadingZero(Free, 0);
            'C': ProcessChar(Closed);
            'D': S := Copy(Dir1, 1, 2);
            'E': if O then S := Ext1 else S := Ext2;
            'F': if X and ffSum > 0 then S := LeadingZero(ImageNum, 0) else if O then S := Name1 else S := Name2;
            'I': if O then S := ConvertCBMName(DiskID) else S := ConvertCBMName(Copy(DiskID, 1, 2));
            'L': if O then S := ConvertCBMName(_Label) else S := ConvertCBMName(DiskLabel);
            'N': if X and ffSum > 0 then S := LeadingZero(FileNum, 0) else S := ConvertCBMName(CBMEntry.Name);
            'P', 'R':
            begin
              if O then S := Copy(Dir1, 3, MaxStrLen) else S := Copy(Dir2, 3, MaxStrLen);
              if (C = 'R') and (Length(S) > 1) then S := Copy(S, 2, Length(S) - 2);
            end;
            'S': if X and ffSum > 0 then if O then S := LeadingZero(LongAllSize, 0) else S := LeadingZero(AllSize, 0)
               else if O then S := LeadingZero(LongSize, 0) else S := LeadingZero(CBMEntry.Size, 0);
            'T':
            begin
              if X and ffGEOS > 0 then S := GEOSExt else S := Ext;
              if X and ffUpperCase > 0 then S := UpperCase(S);
            end;
            'W': ProcessChar(Protected);
          end;
          if X and ffQuoted > 0 then S := '"' + S + '"';
          ProcessWidth(T^.MaxWidth, T^.MaxWidthDir);
          if Length(S) > D then if F then if G then S[0] := Chr(D) else S := Copy(S, D, MaxStrLen)
            else S := Copy(S, Length(S) - D + 1, MaxStrLen);
          ProcessWidth(T^.Padding, T^.PaddingDir);
          while Length(S) < D do if F then S := ' ' + S else S := S + ' ';
          B := Length(S);
          PutString(PString(@S[1]));
        end;
        Inc(I, SizeOf(TFormatSpec));
      end;
      MaxByte:
      begin
        U := PCondSpec(@FormatBuffer^[I]);
        Inc(I, SizeOf(TCondSpec));
        O := True;
        D := U^.CondType;
        if CondType > 0 then
        begin
          if D = CondType then
          begin
            O := False;
            Inc(Z);
          end
          else
          begin
            if D = cfCondEnd then
            begin
              O := False;
              if Z > 0 then Dec(Z);
            end;
          end;
        end;
        if O or (CondType = 0) then
        begin
          O := False;
          case D of
            cfFirstFile: O := FirstFile;
            cfLastFile: O := LastFile;
            cfCondEnd: O := True;
          end;
          if O then
          begin
            if (CondType = 0) and not DispNormal then
            begin
              if D = cfCondEnd then
              begin
                Dec(Z);
              end
              else
              begin
                Inc(Z);
              end;
            end;
          end
          else
          begin
            D := 1;
            while not O and (I < FormatSize) do
            begin
              B := FormatBuffer^[I];
              Inc(I);
              case B of
                0: Inc(I, SizeOf(TFormatSpec));
                MaxByte:
                begin
                  if PCondSpec(@FormatBuffer^[I])^.CondType and cfCondEnd = 0 then Inc(D) else Dec(D);
                  O := (D = 0);
                  Inc(I, SizeOf(TCondSpec));
                end;
              else
                Inc(I, B);
              end;
            end;
          end;
        end;
      end;
    else
      if Z > 0 then PutString(PString(@FormatBuffer^[I]));
      Inc(I, B);
    end;
  end;
  ExtBlockWrite(ListFile, OutputBuffer^, OutputSize);
end;

{List all image and archive files in a directory
  Input : Dir: the path of the directory to be processed}
procedure ListDir(Dir: string);
var
  I             : Integer;
  Entry         : ExtSearchRec;
begin
  SearchPar := Dir + Name0 + Ext0;
  Error := False;
  LongFindFirst(SearchPar, Archive + ReadOnly, Entry);
  if DOSError = 0 then
  begin
    if FirstImage then
    begin
      FirstImage := False;
      I := 0;
      if ListName <> '' then
      begin
        I := LongOpenFile(ListName, ListFile, fmReadWrite);
        if I = 0 then ExtSeek(ListFile, ExtFileSize(ListFile));
      end;
      if I = 0 then
      begin
        if ListName <> '' then LineFeed := True;
      end
      else
      begin
        I := 0;
        if ListName <> '' then I := LongOpenFile(ListName, ListFile, fmWriteOnly);
      end;
      if I <> 0 then
      begin
        Error := True;
        WriteLn('Cannot create ', ListName);
      end;
    end;
    if not Error then
    begin
      repeat
        Ext := UpperCase(FileExt(Entry.LongName));
        PanelMode := 0;
        if (Length(Entry.LongName) > 2) and (Entry.LongName[1] = 'X') and (Entry.LongName[2] = '!') then
        begin
          PanelMode := pmFileZip;
        end
        else
        begin
          if (Ext = 'D64') or (Ext = 'D71') or (Ext = 'D81') then PanelMode := pmDisk else
            if Ext = 'T64' then PanelMode := pmTape else
            if Ext = 'LNX' then PanelMode := pmLynx else
            if Ext = 'ARK' then PanelMode := pmArkive else
            if Ext = 'LBR' then PanelMode := pmLibrary else
            if Ext = 'TAR' then PanelMode := pmTAR else
            if (Ext = 'LHA') or (Ext = 'LZH') then PanelMode := pmLHA else
            if Ext = 'SFX' then PanelMode := pmLHASFX else
            if Ext = 'ARC' then PanelMode := pmARC else
            if Ext = 'SDA' then PanelMode := pmARCSDA else
            if (Ext[1] in ['P', 'S', 'U']) and (Ext[2] in ['0'..'9']) and (Ext[3] in ['0'..'9']) then PanelMode := pmFile;
        end;
        if PanelMode > 0 then
        begin
          Found := True;
          FileNum := 0;
          FileCount := 0;
          AllSize := 0;
          LongAllSize := 0;
          ImageName := Dir + Entry.LongName;
          if not Formatted and LineFeed then
          begin
            WriteLine('', True);
            NextLine;
          end;
          case PanelMode of
            pmDisk: TypeStr := 'disk';
            pmTape: TypeStr := 'tape';
            pmFile: TypeStr := 'file';
            pmLynx: TypeStr := 'Lynx';
            pmArkive: TypeStr := 'Arkive';
            pmLibrary: TypeStr := 'Library';
            pmTAR: TypeStr := 'TAR';
            pmLHA: TypeStr := 'LHA';
            pmLHASFX: TypeStr := 'LHA SFX';
            pmARC: TypeStr := 'LHA';
            pmARCSDA: TypeStr := 'ARC SDA';
            pmFileZip: TypeStr := 'ZipCode';
          end;
          case PanelMode of
            pmDisk..pmFile: TypeStr := TypeStr + ' image';
            pmLynx..pmFileZip: TypeStr := TypeStr + ' archive';
          end;
          ListStr := 'Listing ' + TypeStr + ': ' + ImageName;
          if ListName <> '' then WriteLn(ListStr);
          if not Formatted then WriteLine(ListStr, True);
          if OpenImage = 0 then
          begin
            Inc(ImageNum);
            if Formatted then
            begin
              ASCIIName := LongFExpand(ImageName);
              LongFSplit(ASCIIName, Dir1, Name1, Ext1);
              ASCIIName := ShortName(ASCIIName, True);
              LongFSplit(ASCIIName, Dir2, Name2, Ext2);
              if ImageNum = 1 then FormatOutput(cfHeader, False);
            end
            else
            begin
              if Verbose and (PanelMode in [pmDisk, pmTape, pmLynx]) then
              begin
                FileName := _Label;
                MakeASCIIName;
                WriteLine(' ("' + ASCIIName + '")', True);
              end
              else
              begin
                WriteLine('', True);
              end;
              NextLine;
              WriteLine('Blocks         Name          Type', False);
              if Verbose and (PanelMode in [pmDisk..pmFile, pmLynx..pmLibrary]) then WriteLine('  Start', True) else
                WriteLine('', True);
              NextLine;
              HeaderLine;
            end;
            Escape;
            FirstFile := True;
            LastFile := not ReadCBMEntry(CBMEntry);
            ContProcess := not LastFile;
            while not EscPressed and ContProcess and (DirPos <= DirLength) do
            begin
              LoadAddr := 0;
              LoadAddrOK := False;
              if Verbose and (CBMEntry.Attr > 0) then
              begin
                if PanelMode in [pmLynx..pmTAR] then
                begin
                  if CBMEntry.Size > 0 then GetLoadAddr;
                end
                else
                begin
                  LoadAddr := NextLoadAddr;
                  LoadAddrOK := NextLoadAddrOK;
                end;
              end;
              PrevImagePos := ImagePos;
              LastFile := not ReadCBMEntry(NextEntry) or (DirPos > DirLength);
              if CBMEntry.Attr > 0 then
              begin
                while not LastFile and (NextEntry.Attr = 0) do LastFile := not ReadCBMEntry(NextEntry);
                if PanelMode in [pmTape, pmFile, pmLynx..pmLHASFX] then
                begin
                  LongSize := CBMEntry.Size;
                  CBMEntry.Size := ByteToBlock(CBMEntry.Size);
                end
                else
                begin
                  LongSize := CBMEntry.Size * 254;
                end;
                Inc(FileCount);
                Inc(FileNum);
                Inc(AllSize, CBMEntry.Size);
                Inc(LongAllSize, LongSize);
                Ext := ShortCBMExt[CBMEntry.Attr and 7];
                if GEOSFormat then GEOSExt := LowerCase(ShortGEOSExt[CBMEntry.ExtAttr and $7F]) else GEOSExt := Ext;
                if CBMEntry.Attr and $40 = 0 then Protected := ' ' else Protected := '<';
                if CBMEntry.Attr and $80 = 0 then Closed := '*' else Closed := ' ';
                if Formatted then
                begin
                  FormatOutput(cfNormal, True);
                end
                else
                begin
                  if PanelMode in [pmTAR, pmLHA, pmLHASFX] then
                  begin
                    ASCIIName := CBMEntry.Name;
                  end
                  else
                  begin
                    if GEOSFormat then
                    begin
                      asm
                        mov si, Offset(CBMEntry.Name);
                        mov di, Offset(ASCIIName);
                        push ds;
                        pop es;
                        cld;
                        lodsb;
                        mov cl, al;
                        xor ch, ch;
                        stosb;
                        jcxz @1;
                    @2: lodsb;
                        and al, $7F;
                        cmp al, $7F;
                        je @3;
                        cmp al, ' ';
                        jae @4;
                    @3: mov al, '*';
                    @4: stosb;
                        loop @2;
                    @1:
                      end;
                    end
                    else
                    begin
                      FileName := CBMEntry.Name;
                      MakeASCIIName;
                    end;
                  end;
                  ASCIIName := '"' + ASCIIName + '"';
                  while Length(ASCIIName) < 20 do ASCIIName := ASCIIName + ' ';
                  FileName := Closed + GEOSExt + Protected;
                  WriteLine(LeadingSpace(CBMEntry.Size, 6) + '  ' + ASCIIName + FileName, False);
                  if Verbose then
                  begin
                    if PanelMode in [pmDisk..pmFile, pmLynx..pmTAR] then WriteLine('  $' + HexaStr(CBMEntry.Start, 4), True)
                      else WriteLine('', True);
                  end
                  else
                  begin
                    WriteLine('', True);
                  end;
                  NextLine;
                end;
                FirstFile := False;
              end;
              Escape;
              ContProcess := not LastFile;
              CBMEntry := NextEntry;
            end;
            ExtClose(Image);
            if not Formatted then
            begin
              HeaderLine;
              ASCIIName := ' file';
              if FileNum <> 1 then ASCIIName := ASCIIName + 's';
              WriteLine(LeadingSpace(AllSize, 6) + LeadingSpace(FileNum, 20 - Length(ASCIIName)) + ASCIIName, True);
              NextLine;
            end;
            LineFeed := True;
          end
          else
          begin
            ExtClose(Image);
            WriteLn;
            NextLine;
            WriteLn('  ', ImageName, ' is not a valid ', TypeStr);
            NextLine;
          end;
        end;
        LongFindNext(Entry);
        if not EscPressed then Escape;
      until (DOSError <> 0) or EscPressed;
      LongFindClose(Entry);
    end;
  end;
  if Subdirs then
  begin
    LongFindFirst(Dir + '*.*', Directory + Archive + ReadOnly, Entry);
    if DOSError = 0 then
    begin
      repeat
        if (Entry.Orig.Attr and Directory > 0) and (Entry.LongName <> '.') and (Entry.LongName <> '..') then
          ListDir(Dir + Entry.LongName + '\');
        LongFindNext(Entry);
        Escape;
      until (DOSError <> 0) or EscPressed;
      LongFindClose(Entry);
    end;
  end;
end;

procedure ListOptions(const Option: string); far;
begin
  case Option[1] of
    'P': Paging := True;
    'S': Subdirs := True;
    'V': Verbose := True;
  else
    CharSetOptions(Option);
  end;
end;

{Compress the format specification, tokenizing field specifiers and conditional
  block entries and exits}
procedure TokenizeFormat;
var
  F,
  O,
  Q,
  W             : Boolean;
  C,
  D             : Byte;
  E,
  I,
  J             : Word;
  X             : Integer;
  S             : string;
  T             : TFormatSpec;
  U             : TCondSpec;

{Get a further byte from the format specification
  Input : Dist: distance from the current offset
  Output: the byte read}
function NextByte(Dist: Word): Byte;
var
  J             : Word;
begin
  NextByte := 0;
  J := I + Dist;
  if J < FormatSize then NextByte := OutputBuffer^[J];
end;

{Read a decimal number from the format specification}
function GetNumber: Byte;
var
  F,
  Q             : Boolean;
  B             : Byte;
  J,
  N             : Word;
begin
  N := 0;
  Q := False;
  F := False;
  repeat
    B := NextByte(E);
    case B of
      10, 13: Inc(E);
      Ord('0')..Ord('9'):
      begin
        F := True;
        N := N * 10 + (B - Ord('0'));
        if N > MaxWidth then N := MaxWidth;
        Inc(E);
      end;
    else
      Q := True;
    end;
  until Q;
  if F then Dec(E);
  GetNumber := N;
end;

{Put a string constant into the format buffer}
procedure PutString;
var
  I             : Word;
begin
  I := DiskBufferSize - J - 1;
  if Length(S) > I then S[0] := Chr(I);
  if Length(S) > 0 then
  begin
    I := Length(S) + 1;
    Move(S, FormatBuffer^[J], I);
    Inc(J, I);
    S := '';
  end;
end;

{Put a conditional blocks entry or exit token into the format buffer
  Input : CondType: the type of the condition token}
procedure PutCondition(CondType: Byte);
begin
  PutString;
  U.CondType := CondType;
  FormatBuffer^[J] := MaxByte;
  Move(U, FormatBuffer^[J + 1], SizeOf(TCondSpec));
  Inc(J, (SizeOf(TCondSpec) + 1));
  Inc(I, 3);
  O := False;
end;

begin
  F := False;
  I := 0;
  J := 0;
  S := '';
  while I < FormatSize do
  begin
    C := OutputBuffer^[I];
    O := True;
    case Chr(C) of
      #10, #13:
      begin
        O := False;
        Inc(I);
      end;
      '%':
      begin
        case UpCase(Chr(NextByte(1))) of
          '%': Inc(I);
          '?':
          begin
            case UpCase(Chr(NextByte(2))) of
              '^': PutCondition(cfFirstFile);
              '$': PutCondition(cfLastFile);
              'H': PutCondition(cfHeader);
              'F': PutCondition(cfFooter);
              '!': PutCondition(cfCondEnd);
            end;
          end;
        else
          T.Padding := 0;
          T.PaddingDir := ffNoDir;
          T.MaxWidth := MaxWidth;
          T.MaxWidthDir := ffNoDir;
          T.Flags := ffNone;
          T.FieldType := ' ';
          E := 1;
          Q := False;
          W := False;
          repeat
            D := NextByte(E);
            case UpCase(Chr(D)) of
              '0'..'9': if W then T.MaxWidth := GetNumber else T.Padding := GetNumber;
              '-': if W then T.MaxWidthDir := T.MaxWidthDir or ffLeftDir else T.PaddingDir := T.PaddingDir or ffLeftDir;
              '+': if W then T.MaxWidthDir := T.MaxWidthDir or ffRightDir else T.PaddingDir := T.PaddingDir or ffRightDir;
              '*': T.Flags := T.Flags or ffSum;
              '/': W := not W;
              'G': T.Flags := T.Flags or ffGEOS;
              'H': T.Flags := T.Flags or ffHexaConvert;
              'Q': T.Flags := T.Flags or ffQuoted;
              'U': T.Flags := T.Flags or ffUpperCase;
              #0, 'A'..'F', 'I', 'L', 'N', 'P', 'R'..'T', 'W':
              begin
                T.FieldType := Chr(D);
                Q := True;
                O := False;
              end;
            end;
            Inc(E);
          until Q;
          if T.FieldType = #0 then O := True;
          if not O then
          begin
            PutString;
            if J < DiskBufferSize - (SizeOf(TFormatSpec) + 1) then
            begin
              FormatBuffer^[J] := 0;
              Move(T, FormatBuffer^[J + 1], SizeOf(TFormatSpec));
              Inc(J, (SizeOf(TFormatSpec) + 1));
            end;
            Inc(I, E);
          end;
        end;
      end;
      '\':
      begin
        Q := True;
        case UpCase(Chr(NextByte(1))) of
          '$':
          begin
            D := HexaEval(Chr(NextByte(2)) + Chr(NextByte(3)), X);
            if X = 0 then
            begin
              C := D;
              Inc(I, 2);
            end
            else
            begin
              Q := False;
            end;
          end;
          'B': C := 8;
          'N': C := 10;
          'R': C := 13;
          'S': C := Ord(' ');
          'T': C := 9;
          '\':
        else
          Q := False;
        end;
        if Q then Inc(I);
      end;
    end;
    if O then
    begin
      if Length(S) = 254 then PutString;
      S := S + Chr(C);
      Inc(I);
    end;
  end;
  PutString;
  FormatSize := J;
end;

begin
  WriteLn('Star List' + VersionStr + CopyrightStr);
  WriteLn;
  if Test8086 = 0 then
  begin
    WriteLn('This program requires an 80286 CPU or above');
  end
  else
  begin
    if ParamCount < 1 then
    begin
      WriteLn('This program lists the contents of Commodore image and archive files onto  the');
      WriteLn('screen or into a text file.');
      WriteLn;
      WriteLn('Usage: STARLIST <filename> [-|/P|S|V] [<listname> [<formatname>]]');
    end
    else
    begin
      CommonInit;
      Paging := False;
      Subdirs := False;
      FirstImage := True;
      Number := 2;
      ParseCmdLine(ListOptions);
      if not Error then
      begin
        ImageName := UpperCase(LongParamStr(1));
        ListName := UpperCase(LongParamStr(Number));
        if ListName = '-' then ListName := '';
        FormatName := UpperCase(LongParamStr(Number + 1));
        asm
          mov ax, $1130;
          xor bh, bh;
          int $10;
          dec dl;
          mov ScreenHeight, dl;
        end;
        LineCount := 1;
        if ListName <> '' then Paging := False;
        FormatOK := True;
        if FormatName <> '' then
        begin
          FormatOK := False;
          if LongOpenFile(FormatName, TempFile, fmReadOnly) = 0 then
          begin
            OutputBuffer := New(PBuffer);
            FormatBuffer := New(PDiskBuffer);
            ExtBlockRead2(TempFile, OutputBuffer^, BufferSize, FormatSize);
            ExtClose(TempFile);
            if IOResult = 0 then
            begin
              FormatOK := True;
              Formatted := True;
              TokenizeFormat;
            end;
          end;
        end;
        if FormatOK then
        begin
          ImageNum := 0;
          SplitName(ImageName, Dir, Name0, Ext0);
          ListDir(Dir);
          NextLine;
          if not FirstImage then
          begin
            if ListName <> '' then
            begin
              if Formatted then FormatOutput(cfFooter, False);
              ExtClose(ListFile);
            end;
          end;
          if not Found then WriteLn('No known file formats found');
        end
        else
        begin
          WriteLn('Error reading format description file');
        end;
        if FormatBuffer <> nil then Dispose(FormatBuffer);
        if OutputBuffer <> nil then Dispose(OutputBuffer);
      end;
    end;
  end;
end.
