{
Ŀ
                 Joe Forster/STA                 
                                                 
                   STARTAPE.PAS                  
                                                 
                    Star Tape                    

}

program Star_Tape;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 0, 655360}

uses
  DOS, StarBase;

const
{Length of tape image header}
  TapeHeaderLen = 64;
{Length of tape image buffer}
  TapeBufferMax = 49152;
{Signature for file image header}
  PC64Sign      : string[8] = 'C64File'#0;

var
  First         : Boolean;
  Dummy         : Byte;
  StartAddr,
  BufSize,
  TapeSize      : Word;
  ArchiveStart  : Longint;
  Sign          : string[8];
  SearchPar,
  ListName,
  TapeName      : string;
  ListFile      : Text;
  TapeBuffer    : array [0..TapeBufferMax - 1] of Byte;

{The tape image header}
procedure TapeHeader; external;
{$L TAPEHDR.OBJ}

{Determine whether a file extension is valid for a file image
  Output: when True, the file extension is valid}
function PC64ExtOK: Boolean;
begin
  PC64ExtOK := ((Length(Ext1) = 4) and (UpCase(Ext1[2]) in ['P', 'S', 'U']) and (Ext1[3] in ['0'..'9']) and
    (Ext1[4] in ['0'..'9']));
end;

{Proceed to the next file image}
procedure NextFile;
var
  Q             : Boolean;
begin
  if List then
  begin
    Q := False;
    while not Q do
    begin
      if EOF(ListFile) then
      begin
        Close(ListFile);
        IOError := 18;
        Q := True;
      end
      else
      begin
        ReadLn(ListFile, SearchPar);
        if SearchPar <> '' then
        begin
          LongFindFirst(SearchPar, Archive + ReadOnly, Entry);
          IOError := DOSError;
          Q := True;
        end;
      end;
    end;
  end
  else
  begin
    LongFindNext(Entry);
    IOError := DOSError;
  end;
end;

{Start processing the file images}
procedure FirstFile;
begin
  if List then
  begin
    Assign(ListFile, ListName);
    Reset(ListFile);
    IOError := IOResult;
    if IOError = 0 then NextFile;
  end
  else
  begin
    LongFindFirst(SearchPar, Archive + ReadOnly, Entry);
    IOError := DOSError;
  end;
end;

begin
  WriteLn('Star Tape' + VersionStr + CopyrightStr);
  WriteLn;
  if Test8086 = 0 then
  begin
    WriteLn('This program requires an 80286 CPU or above');
  end
  else
  begin
    if ParamCount < 2 then
    begin
      WriteLn('This program collects PC64 file images into tape images.');
      WriteLn;
      WriteLn('Usage: STARTAPE <filename>|@<listname> <tapename>');
    end
    else
    begin
      Error := False;
      First := True;
      SearchPar := UpperCase(LongParamStr(1));
      List := (SearchPar[1] = '@');
      if List then
      begin
        SearchPar := Copy(SearchPar, 2, 255);
        ListName := SearchPar;
      end;
      TapeName := UpperCase(LongParamStr(2));
      LongFSplit(TapeName, Dir1, Name1, Ext1);
      TapeName := Dir1 + Name1 + '.t64';
      LongFSplit(SearchPar, Dir1, Name1, Ext1);
      FileMode := fmReadOnly;
      FirstFile;
      if IOError <> 0 then
      begin
         WriteLn(SearchPar, ' not found');
      end
      else
      begin
        FileNum := 0;
        FileDate := 0;
        repeat
          LongFSplit(Entry.LongName, Dir, Name1, Ext1);
          if PC64ExtOK and (Entry.Orig.Size >= 26) then
          begin
            if FileDate < Entry.Orig.Time then FileDate := Entry.Orig.Time;
            Inc(FileNum);
          end;
          NextFile;
          Escape;
        until (IOError <> 0) or EscPressed;
        if FileNum > 0 then
        begin
          if FileNum < 500 then
          begin
            ArchiveStart := FileNum * 32 + 64;
            FillChar(TapeBuffer, ArchiveStart, 0);
            asm
              xor bx, bx;
              mov si, Offset(TapeHeader);
              mov cx, TapeHeaderLen;
              cld;
          @1: mov al, byte ptr cs:si;
              mov byte ptr TapeBuffer[bx], al;
              inc si;
              inc bx;
              loop @1;
              mov ax, FileNum;
              mov word ptr TapeBuffer[34], ax;
              mov word ptr TapeBuffer[36], ax;
              mov TapeSize, bx;
            end;
            WriteLn('Creating ', TapeName);
            Over := True;
            IOError := 0;
            if LongOpenFile(TapeName, Image, fmReadOnly) = 0 then
            begin
              ExtClose(Image);
              Over := Question(TapeName + ' exists. Overwrite', '', '', '', Dummy);
            end;
            if Over then
            begin
              if LongOpenFile(Image.LongName, Image, fmWriteOnly) = 0 then
              begin
                Buffer := New(PBuffer);
                ExtBlockWrite(Image, TapeBuffer, ArchiveStart);
                FirstFile;
                FileCount := 0;
                repeat
                  LongFSplit(SearchPar, Dir1, Name1, Ext1);
                  LongFSplit(Entry.LongName, Dir, Name1, Ext1);
                  ASCIIName := Dir1 + Name1 + Ext1;
                  if PC64ExtOK then
                  begin
                    if LongOpenFile(ASCIIName, TempFile, fmReadOnly) = 0 then
                    begin
                      Sign[0] := #8;
                      ExtBlockRead(TempFile, Sign[1], 8);
                      FileName[0] := #16;
                      ExtBlockRead(TempFile, FileName[1], 16);
                      FileName := CutChar(FileName, #0);
                      ExtBlockRead(TempFile, StartAddr, 2);
                      ExtBlockRead(TempFile, StartAddr, 2);
                      CopySize := ExtFileSize(TempFile) - 28;
                      if Sign = PC64Sign then
                      begin
                        asm
                          mov bx, TapeSize;
                          mov byte ptr TapeBuffer[bx], 1;
                          inc bx;
                          mov ah, byte ptr Ext1[2];
                          mov al, 1;
                          cmp ah, 'S';
                          je @1;
                          inc al;
                          cmp ah, 'P';
                          je @1;
                          inc al;
                      @1: or al, $80;
                          mov byte ptr TapeBuffer[bx], al;
                          inc bx;
                          mov ax, StartAddr;
                          mov word ptr TapeBuffer[bx], ax;
                          add bx, 2;
                          add ax, word ptr CopySize[0];
                          mov word ptr TapeBuffer[bx], ax;
                          add bx, 4;
                          mov ax, word ptr ArchiveStart[0];
                          mov word ptr TapeBuffer[bx], ax;
                          mov ax, word ptr ArchiveStart[2];
                          mov word ptr TapeBuffer[bx][2], ax;
                          add bx, 8;
                          mov di, Offset(TapeBuffer);
                          add di, bx;
                          mov si, Offset(FileName);
                          cld;
                          lodsb;
                          mov cl, al;
                          xor ch, ch;
                          push cx;
                          rep movsb;
                          pop cx;
                          mov al, ' ';
                      @2: cmp cx, 16;
                          jae @3;
                          stosb;
                          inc cx;
                          jmp @2;
                      @3: mov bx, di;
                          sub bx, Offset(TapeBuffer);
                          mov TapeSize, bx;
                        end;
                        MakeASCIIName;
                        WriteLn('  Adding: "', ASCIIName, '"');
                        Inc(ArchiveStart, CopySize);
                        while CopySize > 0 do
                        begin
                          if CopySize > BufferSize then BufSize := BufferSize else BufSize := CopySize;
                          Dec(CopySize, BufSize);
                          ExtBlockRead(TempFile, Buffer^, BufSize);
                          ExtBlockWrite(Image, Buffer^, BufSize);
                        end;
                        ExtClose(TempFile);
                      end
                      else
                      begin
                        WriteLn(ASCIIName, ' has an invalid header');
                      end;
                    end;
                  end;
                  NextFile;
                  Inc(FileCount);
                  Escape;
                until (IOError <> 0) or EscPressed;
                if not List then LongFindClose(Entry);
                ExtSeek(Image, 0);
                ExtBlockWrite(Image, TapeBuffer, TapeSize);
                ExtSetFTime(Image, FileDate);
                ExtClose(Image);
                Dispose(Buffer);
              end;
            end;
          end
          else
          begin
            WriteLn('Too many file images');
          end;
        end
        else
        begin
          WriteLn('No file images found');
        end;
      end;
    end;
  end;
end.
