;Ŀ
;                 Joe Forster/STA                 
;                                                 
;                     TAB.ASM                     
;                                                 
;                 Kill & Make Tab                 
;

CSeg		segment
		assume	cs:CSeg, ds:CSeg, ss:CSeg
		org	0100h

BufferSize	equ	64512
ProgramSize	equ	4096
TabLength	equ	8

Main:		mov	ax, ds:[0006h]
		cmp	ax, ProgramSize
		jbe	@14
		mov	bx, ProgramSize / 16
		mov	ah, 4Ah
		int	21h
		mov	sp, ProgramSize
		xor	ax, ax
		push	ax
@14:		mov	di, Offset DataStart
		mov	cx, DataEnd - DataStart
		xor	al, al
		cld
		rep	stosb
		mov	dx, Offset Hello
		mov	ah, 9
		int	21h
		mov	si, 0081h
		mov	bl, 2
		mov	di, Offset SearchPar
		mov	cx, 79
		call	ParamStr
		cmp	bh, 2
		jae	@01
		mov	dx, Offset Usage
		mov	ah, 9
		int	21h
		xor	al, al
		jmp	@03
@01:		mov	bl, 1
		xor	di, di
		call	ParamStr
		call	UpCase
		cmp	al, 'S'
		je	@15
		cmp	al, 'T'
		je	@15
		mov	dx, Offset InvalidCommand
		jmp	@11
@15:		mov	Command, al
		mov	si, Offset SearchPar
		mov	di, Offset ReadPath
		xor	bx, bx
		xor	bp, bp
		call	FSplit
		mov	si, Offset SearchPar
		mov	di, Offset ReadName
		mov	cx, 79
		stc
		call	StrCopy
		mov	dx, Offset SearchPar
		mov	cx, 21h
		mov	ah, 4Eh
		int	21h
		jnc	@06
		mov	dx, Offset SearchPar
		clc
		call	PrintStr
		mov	dx, Offset NotFound
		jmp	@11
@06:		mov	si, Offset ReadPath
		mov	di, Offset ReadName
		mov	cx, 79
		clc
		call	StrCopy
		mov	si, 009Eh
		stc
		call	StrCopy
		mov	si, Offset ReadPath
		mov	di, Offset WriteName
		mov	cx, 79
		clc
		call	StrCopy
		mov	si, Offset TempName
		stc
		call	StrCopy
		mov	dx, Offset ReadName
		mov	ax, 3D00h
		int	21h
		jnc	@07
		jmp	@04
@07:		mov	si, ax
		mov	bx, si
		mov	ax, 5700h
		int	21h
		mov	Time, cx
		mov	Date, dx
		mov	dx, Offset WriteName
		mov	cx, 0022h
		mov	ah, 3Ch
		int	21h
		jnc	@08
		jmp	@09
@08:		mov	di, ax
		mov	bx, BufferSize / 16
		mov	ah, 48h
		int	21h
		jnc	@10
@02:		mov	dx, Offset NoMemory
		jmp	@11
@10:		mov	Buffer1, ax
		mov	bx, BufferSize / 16
		mov	ah, 48h
		int	21h
		jc	@02
		mov	Buffer2, ax
		mov	dx, Offset Converting
		mov	ah, 9
		int	21h
		mov	dx, Offset ReadName
		stc
		call	PrintStr
		xor	ax, ax
		mov	EndOfFile, al
		mov	SpaceCount, ax
		mov	Column, ax
		mov	BufferLength1, ax
		mov	BufferPoint1, ax
		mov	BufferLength2, ax
@13:		call	ReadByte
		cmp	EndOfFile, 0
		jne	@19
		cmp	Command, 'S'
		jne	@05
		cmp	al, 9
		jne	@17
@18:		mov	al, ' '
		call	WriteByte
		inc	Column
		call	IsTabReached
		jne	@18
		jmp	@13
@05:		cmp	al, 9
		jne	@22
		push	ax
		mov	ax, Column
		xor	dx, dx
		mov	bx, TabLength
		div	bx
		mul	bx
		dec	ax
		mov	Column, ax
		pop	ax
@22:		cmp	al, ' '
		jne	@20
		inc	SpaceCount
		inc	Column
		call	IsTabReached
		jne	@13
		mov	al, 9
		call	WriteByte
		mov	SpaceCount, 0
		jmp	@13
@20:		mov	cx, SpaceCount
		jcxz	@17
		push	ax
		mov	al, ' '
@21:		call	WriteByte
		loop	@21
		mov	SpaceCount, cx
		pop	ax
@17:		call	WriteByte
		inc	Column
		cmp	al, 10
		je	@12
		cmp	al, 13
		jne	@13
@12:		xor	ax, ax
		mov	Column, ax
		mov	SpaceCount, ax
		jmp	@13
@19:		call	BlockWrite
		push	es
		mov	es, Buffer1
		mov	ah, 49h
		int	21h
		mov	es, Buffer2
		mov	ah, 49h
		int	21h
		pop	es
		mov	bx, di
		mov	ax, 5701h
		mov	cx, Time  
		mov	dx, Date
		int	21h
		mov	ah, 3Eh
		int	21h
@09:		pushf
		mov	bx, si
		mov	ah, 3Eh
		int	21h
		popf
		jc	@04
		call	RenameTemp
@04:		mov	ah, 4Fh
		int	21h
		jc	@23
		jmp	@06
@11:		mov	ah, 9
		int	21h
		mov	al, 1
		jmp	@16
@23:		call	NormalAttr
@03:		xor	al, al
@16:		mov	ah, 4Ch
		int	21h

RenameTemp:	mov	dx, Offset ReadName
		mov	ah, 41h
		int	21h
		jc	@01_RenameTemp
		mov	dx, Offset WriteName
		mov	di, Offset ReadName
		mov	ah, 56h
		int	21h
@01_RenameTemp:	retn

NormalAttr:	mov	dx, Offset SearchPar
		mov	cx, 23h
		mov	ah, 4Eh
		int	21h
		jc	@01_NormalAttr
@02_NormalAttr:	mov	cl, byte ptr ds:[0095h]
		test	cl, 2
		je	@03_NormalAttr
		and	cl, 0FDh
		xor	ch, ch
		push	cx
		mov	si, Offset ReadPath
		mov	di, Offset WriteName
		push	di
		mov	cx, 79
		clc
		call	StrCopy
		mov	si, 009Eh
		stc
		call	StrCopy
		pop	dx
		pop	cx
		mov	ax, 4301h
		int	21h
@03_NormalAttr:	mov	ah, 4Fh
		int	21h
		jnc	@02_NormalAttr
@01_NormalAttr:	retn

IsTabReached:	mov	ax, Column
		xor	dx, dx
		mov	bx, TabLength
		div	bx
		or	dx, dx
		retn

FSplit:		mov	dx, si
		call	StrLen
		add	si, ax
		dec	si
		xor	cx, cx
		std
@04_FSplit:	cmp	si, dx
		jb	@01_FSplit
		lodsb
		cmp	al, '.'
		jne	@02_FSplit
		or	cx, cx
		jne	@02_FSplit
		mov	cx, si
		inc	cx
@02_FSplit:	cmp	al, '\'
		je	@03_FSplit
		cmp	al, ':'
		jne	@04_FSplit
@03_FSplit:	inc	si
@01_FSplit:	inc	si
		or	cx, cx
		jne	@05_FSplit
		mov	cx, dx
		xchg	si, dx
		call	StrLen
		xchg	si, dx
		add	cx, ax
@05_FSplit:	xchg	si, dx
		sub	cx, dx
		sub	dx, si
		push	cx
		mov	cx, 67
		stc
		call	StrPartCopy
		mov	di, bx
		pop	dx
		mov	cx, 8
		stc
		call	StrPartCopy
		mov	di, bp
		mov	cx, 4
		stc
		call	StrCopy
		retn

StrCopy:	mov	dx, cx
StrPartCopy:	cld
		pushf
		or	di, di
		jne	@04_StrCopy
		popf
		retn
@04_StrCopy:	or	cx, cx
		je	@01_StrCopy
@02_StrCopy:	or	dx, dx
		je	@01_StrCopy
		lodsb
		or	al, al
		je	@01_StrCopy
		stosb
		dec	dx
		loop	@02_StrCopy
@01_StrCopy:	xor	al, al
		popf
		jnc	@03_StrCopy
		stosb
@03_StrCopy:	retn

StrLen:		cld
		push	si
		xor	ah, ah
@02_StrLen:	lodsb
		or	al, al
		je	@01_StrLen
		inc	ah
		or	ah, ah
		jne	@02_StrLen
@01_StrLen:	pop	si
		mov	al, ah
		xor	ah, ah
		retn

PrintStr:	push	si
		push	bx
		push	cx
		pushf
		mov	si, dx
		mov	bx, 1
		call	StrLen
		or	ax, ax
		je	@01_PrintStr
		mov	cx, ax
		mov	ah, 40h
		int	21h
@01_PrintStr:	popf
		jnc	@02_PrintStr
		mov	dx, Offset LineFeed
		mov	cx, 2
		mov	ah, 40h
		int	21h
@02_PrintStr:	pop	cx
		pop	bx
		pop	si
		retn

ReadByte:	push	es
		push	bx
		push	cx
		push	dx
		mov	al, 26
		mov	ah, EndOfFile
		or	ah, ah
		jne	@02_ReadByte
		mov	es, Buffer1
		mov	ax, BufferPoint1
		cmp	ax, BufferLength1
		jne	@01_ReadByte
		mov	bx, si
		mov	cx, BufferSize
		xor	dx, dx
		push	ds
		mov	ds, cs:Buffer1
		mov	ah, 3Fh
		int	21h
		pop	ds
		mov	BufferPoint1, 0
		mov	BufferLength1, ax
		or	ax, ax
		jne	@01_ReadByte
		mov	EndOfFile, 1
		xor	al, al
		jmp	@02_ReadByte
@01_ReadByte:	mov	bx, BufferPoint1
		mov	al, es:[bx]
		inc	BufferPoint1
@02_ReadByte:	pop	dx
		pop	cx
		pop	bx
		pop	es
		retn

WriteByte:	push	es
		push	bx
		mov	es, Buffer2
		mov	bx, BufferLength2
		mov	es:[bx], al
		inc	bx
		mov	BufferLength2, bx
		cmp	bx, BufferSize
		jb	@01_WriteByte
		call	BlockWrite
		mov	BufferLength2, 0
@01_WriteByte:	pop	bx
		pop	es
		retn

BlockWrite:	push	cx
		push	dx
		mov	cx, BufferLength2
		or	cx, cx
		je	@01_BlockWrite
		mov	bx, di
		xor	dx, dx
		push	ds
		mov	ds, cs:Buffer2
		mov	ah, 40h
		int	21h
		pop	ds
@01_BlockWrite:	pop	dx
		pop	cx
		retn

ParamStr:	mov	si, 0081h
		xor	bh, bh
@01_ParamStr:	lodsb
		cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
		inc	bh
		cmp	bl, bh
		je	@03_ParamStr
@04_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
		lodsb
		jmp	@04_ParamStr
@03_ParamStr:	or	di, di
		je	@05_ParamStr
@06_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@02_ParamStr
		cmp	al, 9
		je	@02_ParamStr
		call	UpCase
		stosb
		lodsb
		loop	@06_ParamStr
@02_ParamStr:	xor	al, al
		stosb
@05_ParamStr:	retn

UpCase:		cmp	al, 'a'
		jb	@01_UpCase
		cmp	al, 'z'
		ja	@01_UpCase
		sub	al, 'a' - 'A'
@01_UpCase:	retn

Hello		db	'Kill & Make Tab by Joe Forster/STA', 13, 10, 13, 10, '$'
Usage		db	'This program converts Tab''s to spaces and vice versa.', 13, 10, 13, 10
		db	'Tab''s to spaces :  TAB S <filename>', 13, 10
		db	'Spaces to Tab''s :  TAB T <filename>', 13, 10, '$'
InvalidCommand	db	'Invalid command', 13, 10, '$'
NotFound	db	' not found', 13, 10, '$'
NoMemory	db	'Out of memory', 13, 10, '$'
Converting	db	'Converting $'
TempName	db	'$$TEMP$$.TMP', 0
LineFeed	db	13, 10

DataStart:

Time		dw	?
Date		dw	?
Command		db	?
EndOfFile	db	?
SpaceCount	dw	?
Column		dw	?
BufferLength1	dw	?
BufferPoint1	dw	?
BufferLength2	dw	?
Buffer1		dw	?
Buffer2		dw	?
SearchPar	db	79 + 1 dup (?)
ReadName	db	79 + 1 dup (?)
WriteName	db	79 + 1 dup (?)
ReadPath	db	79 + 1 dup (?)

DataEnd:

CSeg		ends

		end	Main
