
#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "common.h"

/**@brief Removes leading space from a string.
 * @param[in] src  string to trim
 * @return src incremented to the first non-whitespace character
 */
char* trim(char* src) {
  while (isspace(*src)) src++;
  return src;
}

char* findNamePos(char* path) {
  if (path == NULL) return NULL;
  char* namepos = strrchr(path, '\\');
  if (namepos == NULL) namepos = strrchr(path, '/');
  if (namepos == NULL) namepos = path; else namepos++;
  return namepos;
}

unsigned long getDefaultToolFlags(const char* toolname, const char* ownpath) {
  assert(toolname != NULL);
  assert(ownpath != NULL);
  unsigned long flags = 0;

  /* if we replaced the original program then append "-real" to get the name of the original default linker;
     if our name starts with the x64 prefix then prepend that to get the name of the original default linker */
  char* ownname;
  ownname = strrchr(ownpath, '\\');
  if (ownname == NULL) {
    ownname = strrchr(ownpath, '/');
  }
  if (ownname == NULL) {
    ownname = (char*)ownpath;
  } else {
    ownname++;
  }
  if (strnicmp(ownname, SO_X64_TOOL_PREFIX, sizeof(SO_X64_TOOL_PREFIX) - 1) == 0) {
    flags |= SO_TOOL_X86TOX64;
    ownname += sizeof(SO_X64_TOOL_PREFIX) - 1;
  }
  char* ownnamedot = strrchr(ownname, '.');
  if (ownnamedot != NULL) {
    *ownnamedot = 0;
  }
  if (stricmp(ownname, toolname) == 0) {
    flags |= SO_TOOL_REPLACED;
  }
  return flags;
}

void getDefaultToolName(char* dest, const char* toolname, unsigned long flags) {
  assert(dest != NULL);
  assert(toolname != NULL);
  sprintf(dest, "%s%s%s", (flags & SO_TOOL_X86TOX64) ? SO_X64_TOOL_PREFIX : "", toolname, (flags & SO_TOOL_REPLACED) ? SO_REAL_SUFFIX : "");
}
