
#ifndef COMMON_H_INCLUDED
#define COMMON_H_INCLUDED

/* modify those, if you're migrating onto a new system */
#define SO_X64_TOOL_PREFIX "x86_64-pc-mingw32-" /**<@brief Prefix for 32-bit programs whose target is 64-bit. */
#define SO_REAL_SUFFIX     "-real"              /**<@brief Suffix of the original linker when DeadStrip becomes the default linker. */
#define SO_DFILE           ".-"                 /**<@brief Temporary file for the dumper. */

#define SO_LINE_MAX        256                  /**<@brief Maximum length for strings. */

#define SO_TOOL_REPLACED   1
#define SO_TOOL_X86TOX64   2

/* SC == StreamCopy, ~StarCraft */
#define SO_SC(tar, txt) \
{\
  const char* data = txt;\
  while ((*tar = *data++))\
    ++tar;\
}

char* trim(char* src);
char* findNamePos(char* path);
unsigned long getDefaultToolFlags(const char* toolname, const char* ownpath);
void getDefaultToolName(char* dest, const char* toolname, unsigned long flags);

#endif
