
/* ldirx.c 0.20 beta
 *
 * Wrapper for LTOOLS' ldirdos or ldirnt, to traverse through the directory
 * structure of a complete ext2 partition. The LTOOLS homepage is available
 * at http://www.fht-esslingen.de/~zimmerma/software/ltools.htm.
 *
 * Joe Forster/STA, sta@c64.org (2004-10-10)
 *
 */

#include <io.h>
#include <limits.h>
#include <stdio.h>
#include <wtypes.h>
#include <winuser.h>

#define bool              int
#define false             (0 == 1)
#define true              (0 == 0)
typedef char* string;

#define chDirSepDOS       '\\'
#define chDirSepUnix      '/'
#define chEmptyFlag       '-'
#define chDirFlagUnix     'd'
#define chWriteFlagUnix   'w'
#define chReadOnlyFlagDOS 'r'
#define CurDir            "."
#define ParentDir         ".."
#define LDIRNameDOS       "ldirdos.exe"
#define LDIRNameNT        "ldirnt.exe"
#define TempFName         "ldirxtmp."
#define EndOfDirStr       "Disk space:"
#define CantFindStr       "Can't find"
#define ReadFlag          "-READ"
#define DeviceDirUnix     "dev"

#define MaxLineLen        300

bool Read;
string LDIRName;

bool ReadLine(FILE* ReadFile, string Line) {
  char* CurLine = Line;
  bool Read = false;
  while (!feof(ReadFile)) {
    fread(CurLine, sizeof(char), 1, ReadFile);
    if (!feof(ReadFile)) {
      Read = true;
      if (*CurLine == '\n') {
        break;
      } else if (*CurLine != '\r') {
        CurLine++;
      }
    }
  }
  *CurLine = '\0';
  return(Read);
}

void ListDir(string Path, int DirLevel) {
  int Index,
    FileSizeLen;
  char SubDirName[PATH_MAX],
    OEMPath[PATH_MAX],
    Command[MaxLineLen],
    FileName[PATH_MAX],
    PartName[PATH_MAX],
    FileSize[PATH_MAX],
    TempName[PATH_MAX],
    TempDir[PATH_MAX],
    FileDate[PATH_MAX],
    FileAttr[PATH_MAX],
    Line[MaxLineLen];
  FILE* TempFile;
  sprintf(TempName, "%s%c%s%03d", TempDir, chDirSepDOS, TempFName, DirLevel);
  strcpy(OEMPath, Path);
  sprintf(Command, "%s -s/" DeviceDirUnix "/%s \"%s\" > %s", LDIRName, PartName, OEMPath, TempName);
  system(Command);
  if ((TempFile = fopen(TempName, "rt")) != NULL) {
    bool Quit;
    Quit = feof(TempFile);
    while (!Quit) {
      ReadLine(TempFile, Line);
      if (strncmp(Line, EndOfDirStr, strlen(EndOfDirStr)) == 0 ||
          strncmp(Line, CantFindStr, strlen(CantFindStr)) == 0) {
        Quit = true;
      }
      else {
        strncpy(FileAttr, Line, 10);
        FileAttr[10] = '\0';
        if (FileAttr[0] != chDirFlagUnix) {
          FileAttr[0] = chEmptyFlag;
        }
        if (FileAttr[2] == chWriteFlagUnix) {
          FileAttr[1] = chEmptyFlag;
        } else {
          FileAttr[1] = chReadOnlyFlagDOS;
        }
        memset(&FileAttr[2], chEmptyFlag, 8);
        strncpy(FileSize, &Line[21], 9);
        FileSize[9] = '\0';
        Index = 30;
        FileSizeLen = strlen(FileSize);
        while (Line[Index] != ' ') {
          FileSize[FileSizeLen] = Line[Index];
          FileSize[++FileSizeLen] = '\0';
          Index++;
        }
        memmove(&FileSize[13 - FileSizeLen], FileSize, FileSizeLen);
        memset(FileSize, ' ', 13 - FileSizeLen);
        FileSize[13] = '\0';
        Index++;
        strncpy(FileDate, &Line[Index + 4], 20);
        FileDate[20] = '\0';
        Index += 25;
        strncpy(FileName, &Line[Index], PATH_MAX);
        FileName[PATH_MAX - 1] = '\0';
        if (strcmp(FileName, CurDir) != 0 && strcmp(FileName, ParentDir) != 0) {
          sprintf(OEMPath, "%s%s", &Path[1], FileName);
          AnsiToOem(OEMPath, OEMPath);
          printf("%s %s %s %s\n", FileAttr, FileSize, FileDate, OEMPath);
          fflush(stdout);
          if (FileAttr[0] == chDirFlagUnix && !(Path[0] == '\0' && strcmp(FileName, DeviceDirUnix) == 0)) {
            sprintf(SubDirName, "%s%s%c", Path, FileName, chDirSepUnix);
            ListDir(SubDirName, DirLevel + 1);
          }
        }
        Quit = feof(TempFile);
      }
    }
    fclose(TempFile);
    unlink(TempName);
  }
}

int main(int argc, string argv[]) {
  char Command[MaxLineLen],
    FileName[PATH_MAX],
    PartName[PATH_MAX],
    FileSize[PATH_MAX],
    TempName[PATH_MAX],
    TempDir[PATH_MAX];
  LDIRName = (GetVersion() < 0x80000000) ? (string)LDIRNameNT : (string)LDIRNameDOS;
  if (!(GetEnvironmentVariable("TEMP", TempDir, PATH_MAX) > 0 && TempDir[0] != '\0')) {
    GetEnvironmentVariable("TMP", TempDir, PATH_MAX);
  }
  if (argc >= 2) {
    strcpy(PartName, argv[1]);
  }
  if (strcmp(PartName, ReadFlag) == 0 && argc >= 3) {
    Read = true;
    strcpy(PartName, argv[2]);
  }
  _splitpath(PartName, NULL, NULL, PartName, NULL);
  strlwr(PartName);
  if (PartName[0] != '\0') {
    if (Read && argc >= 4) {
      strcpy(FileName, argv[3]);
      _splitpath(FileName, NULL, NULL, TempName, FileSize);
      strcat(TempName, FileSize);
      sprintf(Command, "%s %s -s/" DeviceDirUnix "/%s \"%s\" \"%s\"", LDIRName, ReadFlag, PartName, FileName, TempName);
      system(Command);
    } else {
      ListDir((string)"/", 0);
    }
  }
  return 0;
}
