/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DirFilePane
extends JComponent
implements DropTargetListener,
DragGestureListener,
DragSourceListener {
    static boolean DEBUG = false;
    private boolean isLinux = false;
    static final int BUFSIZE = 32768;
    static final int startColumnLinuxFileName = 56;
    private static String currentDirectory;
    private static final String rootNodeText = "Computer";
    public static final ImageIcon ICON_COMPUTER;
    public static final ImageIcon ICON_DRIVE_FIXED;
    public static final ImageIcon ICON_DRIVE_CDROM;
    public static final ImageIcon ICON_DRIVE_NOROOTDIR;
    public static final ImageIcon ICON_DRIVE_RAMDISK;
    public static final ImageIcon ICON_DRIVE_REMOTE;
    public static final ImageIcon ICON_DRIVE_REMOVEABLE;
    public static final ImageIcon ICON_DRIVE_UNKNOWN;
    public static final ImageIcon ICON_FOLDER;
    public static final ImageIcon ICON_EXPANDEDFOLDER;
    private DefaultMutableTreeNode root;
    private JScrollPane jScrollPaneTree;
    private JTree jTree;
    private DefaultTreeModel treeModel;
    private JScrollPane jScrollPaneTable;
    private JTable jTable;
    private LToolGuiTableModel tableModel;
    private JTableHeader jTableHeader;
    private boolean sortOrder = true;
    private BorderLayout borderLayoutCenter;
    private JPanel jPanelDirectory;
    private BorderLayout borderLayoutPaneDir;
    private ContextMenuTable contextMenuTable;
    private ContextMenuTree contextMenuTree;
    DragSource dragSource;
    DropTarget dropTargetTree;
    DropTarget dropTargetTable;
    Vector dosDrives;
    JPanel JPanelDirectory = new JPanel();
    JLabel jLabelDirectory = new JLabel();
    JSplitPane jSplitPaneExplorer = new JSplitPane();

    public DirFilePane() {
        this.setLayout(new BorderLayout(0, 0));
        Insets insets = this.getInsets();
        this.setSize(430, 270);
        this.JPanelDirectory.setLayout(new GridLayout(1, 1, 0, 0));
        this.add("North", this.JPanelDirectory);
        this.JPanelDirectory.setBounds(0, 0, 430, 15);
        this.jLabelDirectory.setText("Directory:");
        this.JPanelDirectory.add(this.jLabelDirectory);
        this.jLabelDirectory.setBounds(0, 0, 430, 15);
        this.jSplitPaneExplorer.setContinuousLayout(true);
        this.jSplitPaneExplorer.setLastDividerLocation(100);
        this.add("Center", this.jSplitPaneExplorer);
        this.jSplitPaneExplorer.setBounds(0, 15, 430, 255);
    }

    public DirFilePane(boolean bl) {
        this();
        this.isLinux = bl;
        this.jScrollPaneTree = new JScrollPane();
        this.jTree = new JTree();
        this.jScrollPaneTable = new JScrollPane();
        this.jTable = new JTable();
        this.jScrollPaneTree.setBounds(0, 0, 0, 0);
        this.jScrollPaneTree.getViewport().add(this.jTree);
        this.jScrollPaneTable.setBounds(0, 0, 0, 0);
        this.jScrollPaneTable.getViewport().add(this.jTable);
        this.jSplitPaneExplorer.add((Component)this.jScrollPaneTree, "left");
        this.jSplitPaneExplorer.add((Component)this.jScrollPaneTable, "right");
        DirFilePane.debugOutput("DirFilePane - NEW Version isLinuxPanel: " + bl);
        this.root = new DefaultMutableTreeNode();
        this.jScrollPaneTree = new JScrollPane();
        this.treeModel = new DefaultTreeModel(this.root);
        this.jTree = new JTree(this.treeModel);
        this.contextMenuTree = new ContextMenuTree(this);
        this.jTree.setScrollsOnExpand(true);
        this.jTree.addTreeSelectionListener(new LToolGuiTreeSelectionListener(this));
        this.jTree.addTreeWillExpandListener(new LToolGuiTreeWillExpandListener(this));
        this.jTree.addMouseListener(new LToolGuiTreeMouseListener(this));
        this.jTree.setRootVisible(false);
        this.contextMenuTable = new ContextMenuTable(this);
        this.jScrollPaneTable = new JScrollPane();
        this.tableModel = new LToolGuiTableModel(this.isLinux);
        this.jTable = new JTable();
        this.jTable.setShowGrid(false);
        this.jTable.setAutoCreateColumnsFromModel(false);
        this.jTable.setModel(this.tableModel);
        for (int i = 0; i < LToolGuiTableModel.columns.length; ++i) {
            LToolGuiTableCellRenderer lToolGuiTableCellRenderer = new LToolGuiTableCellRenderer();
            LToolGuiTableColumnData lToolGuiTableColumnData = LToolGuiTableModel.columns[i];
            lToolGuiTableCellRenderer.setHorizontalAlignment(lToolGuiTableColumnData.getAlignment());
            TableColumn tableColumn = new TableColumn(i, lToolGuiTableColumnData.getWidth(), lToolGuiTableCellRenderer, null);
            this.jTable.addColumn(tableColumn);
        }
        this.jTable.addMouseListener(new LToolGuiTableMouseListener(this));
        this.jTable.addKeyListener(new LToolGuiTableKeyListener(this));
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this.jTable, 3, this);
        this.dropTargetTree = new DropTarget(this.jTree, this);
        this.dropTargetTree = new DropTarget(this.jTable, this);
        this.jTable.setSelectionMode(2);
        this.jTableHeader = this.jTable.getTableHeader();
        this.jTableHeader.addMouseListener(new LToolGuiTableHeaderMouseListener(this));
        this.borderLayoutCenter = new BorderLayout();
        this.jPanelDirectory = new JPanel();
        this.jLabelDirectory = new JLabel();
        this.borderLayoutPaneDir = new BorderLayout();
        this.setLayout(this.borderLayoutCenter);
        this.jSplitPaneExplorer.setMaximumSize(new Dimension(200, 100));
        this.jSplitPaneExplorer.setMinimumSize(new Dimension(200, 100));
        this.jSplitPaneExplorer.setPreferredSize(new Dimension(200, 100));
        this.jSplitPaneExplorer.setTopComponent(null);
        this.jLabelDirectory.setHorizontalAlignment(2);
        this.jLabelDirectory.setHorizontalTextPosition(2);
        this.jLabelDirectory.setText("Directory:");
        this.jPanelDirectory.setLayout(this.borderLayoutPaneDir);
        this.add((Component)this.jSplitPaneExplorer, "Center");
        this.jSplitPaneExplorer.add((Component)this.jScrollPaneTree, "left");
        this.jScrollPaneTree.getViewport().add((Component)this.jTree, null);
        this.jSplitPaneExplorer.add((Component)this.jScrollPaneTable, "right");
        this.jScrollPaneTable.getViewport().add((Component)this.jTable, null);
        this.add((Component)this.jPanelDirectory, "North");
        this.jPanelDirectory.add((Component)this.jLabelDirectory, "Center");
        this.jSplitPaneExplorer.setDividerLocation(200);
        try {
            DEBUG = LTOOLSgui.getDebug();
            if (this.isLinux) {
                this.fillLinuxDirectoryTree();
            } else {
                this.fillDosDirectoryTree();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DefaultMutableTreeNode getTreeNode(TreePath treePath) {
        return (DefaultMutableTreeNode)treePath.getLastPathComponent();
    }

    public void deleteDosFile(ListItemFile listItemFile) {
        Object object;
        String string = "LTOOLS";
        String string2 = listItemFile.getFullFilePath();
        DirFilePane.debugOutput("deleteDosFile - " + string2);
        if (LTOOLSgui.confirmDelete && JOptionPane.showConfirmDialog(LTOOLSgui.myProg, object = "Do you really want to delete \"" + listItemFile.getFullFilePath() + "\" ?", string, 0, 3) == 1) {
            return;
        }
        object = new File(string2);
        if (!((File)object).delete()) {
            LTOOLSgui.beepSound();
            String string3 = "Could not delete file or directory \"" + listItemFile.getFullFilePath() + "\".";
            JOptionPane.showMessageDialog(LTOOLSgui.myProg, string3, string, 0);
            return;
        }
    }

    public void deleteLinuxFile(ListItemFile listItemFile) {
        String string;
        String string2 = "LTOOLS";
        String string3 = this.getLinuxDrive(listItemFile.getFullFilePath());
        String string4 = this.getLinuxPath(listItemFile.getFullFilePath());
        DirFilePane.debugOutput("deleteLinuxFile \"" + string3 + " " + string4 + "\"");
        if (listItemFile.isLink()) {
            string4 = this.getLinuxPath(this.getLinkName(listItemFile.getFullFilePath()));
        }
        if (LTOOLSgui.isLinuxReadOnly) {
            LTOOLSgui.beepSound();
            String string5 = "Your Linux filesystem is set to read only - change in menu 'File - Linux read only' first.";
            JOptionPane.showMessageDialog(LTOOLSgui.myProg, string5, string2, 0);
            return;
        }
        if (LTOOLSgui.confirmDelete && JOptionPane.showConfirmDialog(LTOOLSgui.myProg, string = "Do you really want to delete file \"" + listItemFile.getFullFilePath() + "\" ?", string2, 0, 3) == 1) {
            return;
        }
        string = "ldir -WRITE -x -del -s" + string3 + " \"" + string4 + "\"";
        if ((string = this.execOperatingSystemCommand(string, false)).length() > 0) {
            LTOOLSgui.beepSound();
            JOptionPane.showMessageDialog(LTOOLSgui.myProg, string.trim(), string2, 0);
            return;
        }
    }

    public void modifyDosFile(ListItemFile listItemFile) {
        DirFilePane.debugOutput("modifyDosFile ");
        File file = new File(listItemFile.getFullFilePath());
        String string = new Date(file.lastModified()).toString();
        String string2 = new Long(file.length()).toString();
        ModifyDosDialog modifyDosDialog = new ModifyDosDialog(LTOOLSgui.myProg, false, listItemFile.getFileName(), string, string2, file.isDirectory(), !file.canWrite());
        modifyDosDialog.setVisible(true);
        if (modifyDosDialog.getStatus() != 1) {
            return;
        }
        if (!modifyDosDialog.getFileName().equals(listItemFile.getFileName())) {
            file.renameTo(new File(file.getParent() + File.separator + modifyDosDialog.getFileName()));
            if (listItemFile.isDirectory()) {
                this.refreshTreeNode();
            }
        }
    }

    public void modifyLinuxFile(ListItemFile listItemFile) {
        DirFilePane.debugOutput("modifyLinuxFile");
        String string = listItemFile.isLink() ? this.getLinkName(listItemFile.getFileName()) : listItemFile.getFileName();
        ModifyLinuxDialog modifyLinuxDialog = new ModifyLinuxDialog(LTOOLSgui.myProg, false, string, listItemFile.getFileLastModified(), listItemFile.getFileSize(), listItemFile.getUserID(), listItemFile.getGroupID(), listItemFile.getAccess());
        modifyLinuxDialog.setVisible(true);
        if (modifyLinuxDialog.getStatus() != 1) {
            return;
        }
        if (LTOOLSgui.isLinuxReadOnly) {
            LTOOLSgui.beepSound();
            String string2 = "Your Linux filesystem is set to read only - change in menu 'File - Linux read only' first";
            JOptionPane.showMessageDialog(LTOOLSgui.myProg, string2, "LTOOLS", 0);
            return;
        }
        String string3 = "ldir -WRITE ";
        if (!modifyLinuxDialog.getFileName().equals(listItemFile.getFileName())) {
            string3 = string3 + "-ren ";
        }
        string3 = string3 + "-x -s" + this.getLinuxDrive(listItemFile.getFullFilePath()) + " -f" + modifyLinuxDialog.getAccess() + " ";
        if (!modifyLinuxDialog.getGid().trim().equals(listItemFile.getGroupID().trim())) {
            string3 = string3 + "-g" + modifyLinuxDialog.getGid().trim() + " ";
        }
        if (!modifyLinuxDialog.getUid().trim().equals(listItemFile.getUserID().trim())) {
            string3 = string3 + "-u" + modifyLinuxDialog.getUid().trim() + " ";
        }
        string3 = string3 + "\"" + this.getLinuxPath(listItemFile.getFullFilePath()) + "\" ";
        if (!modifyLinuxDialog.getFileName().equals(listItemFile.getFileName())) {
            string3 = string3 + "\"" + modifyLinuxDialog.getFileName() + "\"";
        }
        if ((string3 = this.execOperatingSystemCommand(string3, false)).length() > 0) {
            LTOOLSgui.beepSound();
            JOptionPane.showMessageDialog(LTOOLSgui.myProg, string3.trim(), "LTOOLS", 0);
            return;
        }
        if (listItemFile.isDirectory()) {
            this.refreshTreeNode();
        }
    }

    public void pasteToDos(boolean bl) {
        DirFilePane.debugOutput("pasteToDos()");
        String string = "LTOOLS";
        boolean bl2 = false;
        TreePath treePath = LTOOLSgui.getCopyToDirectory() == null ? this.jTree.getSelectionPath() : LTOOLSgui.getCopyToDirectory();
        for (int i = 0; i < LTOOLSgui.copyListItemFiles.size(); ++i) {
            Object object;
            File file;
            ListItemFile listItemFile = (ListItemFile)LTOOLSgui.copyListItemFiles.elementAt(i);
            String string2 = listItemFile.getFullFilePath();
            String string3 = this.getName(treePath, false);
            if (!string3.endsWith(File.separator)) {
                string3 = string3 + File.separator;
            }
            DirFilePane.debugOutput("pasteToDos: " + string2 + " --> " + string3 + " as " + listItemFile.getFileName());
            String string4 = string3 + listItemFile.getFileName();
            if (LTOOLSgui.copyFileIsLinux) {
                file = new File(string4);
                if (file.exists()) {
                    DirFilePane.debugOutput("File exists: sourcePath: " + string2 + " --- targetFileFullPathname: " + string4);
                    object = "Overwrite existing file \"" + string4 + "\"" + "\nwith \"" + string2 + "\"";
                    int n = JOptionPane.showConfirmDialog(LTOOLSgui.myProg, object, "LTOOLS", 0, 3);
                    if (n == 1) continue;
                }
                object = !LTOOLSgui.isConnected() ? "ldir -READ -x -s" + this.getLinuxDrive(string2) + " \"" + this.getLinuxPath(string2) + "\" \"" + string4 + "\"" : "ldir -READ -x -s" + this.getLinuxDrive(string2) + " \"" + this.getLinuxPath(string2) + "\" " + "zzz.xxx";
                if (((String)(object = this.execOperatingSystemCommand((String)object, false))).length() > 0) {
                    if (!bl) break;
                    LTOOLSgui.beepSound();
                    JOptionPane.showMessageDialog(this, ((String)object).trim(), "LTOOLS", 0);
                    break;
                }
                if (LTOOLSgui.isConnected()) {
                    this.getFileFromHost(string4);
                }
                bl2 = true;
                DirFilePane.debugOutput("File \"" + string4 + "\" copied.");
                continue;
            }
            try {
                int n;
                file = new File(string4);
                if (file.exists()) {
                    DirFilePane.debugOutput("File exists: sourcePath: " + string2 + " --- targetFileFullPathname: " + string4);
                    object = "Overwrite existing file \"" + string4 + "\"" + "\nwith \"" + string2 + "\"";
                    int n2 = JOptionPane.showConfirmDialog(LTOOLSgui.myProg, object, "LTOOLS", 0, 3);
                    if (n2 == 1) continue;
                }
                object = new FileInputStream(string2);
                FileOutputStream fileOutputStream = new FileOutputStream(string4);
                byte[] byArray = new byte[32768];
                while ((n = ((FileInputStream)object).read(byArray, 0, 32768)) >= 0) {
                    fileOutputStream.write(byArray, 0, n);
                    if (n > 0) continue;
                }
                ((FileInputStream)object).close();
                fileOutputStream.close();
                bl2 = true;
                DirFilePane.debugOutput("File \"" + string4 + "\" copied.");
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!bl) break;
                LTOOLSgui.beepSound();
                object = "Sorry, could not open file \"" + string2 + "\"";
                JOptionPane.showMessageDialog(LTOOLSgui.myProg, object, string, 0);
                break;
            }
            catch (IOException iOException) {
                if (!bl) break;
                LTOOLSgui.beepSound();
                object = "Sorry, could not write to \"" + string4 + "\"";
                JOptionPane.showMessageDialog(LTOOLSgui.myProg, object, string, 0);
                break;
            }
        }
        if (bl2) {
            this.updateDOSJTable(this.getTreeNode(treePath));
        }
    }

    public void pasteToLinux(boolean bl) {
        DirFilePane.debugOutput("pasteToLinux()");
        String string = "LTOOLS";
        boolean bl2 = false;
        if (LTOOLSgui.isLinuxReadOnly) {
            LTOOLSgui.beepSound();
            String string2 = "Your Linux filesystem is set to read only - change in menu 'File - Linux read only' first.";
            JOptionPane.showMessageDialog(LTOOLSgui.myProg, string2, string, 0);
            return;
        }
        TreePath treePath = LTOOLSgui.getCopyToDirectory() == null ? this.jTree.getSelectionPath() : LTOOLSgui.getCopyToDirectory();
        for (int i = 0; i < LTOOLSgui.copyListItemFiles.size(); ++i) {
            String string3;
            ListItemFile listItemFile = (ListItemFile)LTOOLSgui.copyListItemFiles.elementAt(i);
            String string4 = LTOOLSgui.copyFileIsLinux ? this.getLinuxPath(listItemFile.getFullFilePath()) : listItemFile.getFullFilePath();
            String string5 = this.getLinuxDrive(this.getLdirPath(treePath));
            String string6 = this.getLinuxPath(this.getLdirPath(treePath));
            if (!string6.endsWith("/")) {
                string6 = string6 + "/";
            }
            String string7 = listItemFile.getFileName();
            DirFilePane.debugOutput("pasteToLinux " + string4 + " --> " + string6 + " as " + string7);
            if (LTOOLSgui.copyFileIsLinux) {
                string3 = "ldir -READ -x -s" + this.getLinuxDrive(listItemFile.getFullFilePath());
                string3 = string3 + " \"" + this.getLinuxPath(listItemFile.getFullFilePath()) + "\" " + "zzz.tmp";
                if ((string3 = this.execOperatingSystemCommand(string3, false)).length() > 0) {
                    if (!bl) break;
                    LTOOLSgui.beepSound();
                    JOptionPane.showMessageDialog(LTOOLSgui.myProg, string3.trim(), string, 0);
                    break;
                }
                string3 = "ldir -WRITE -x -s" + string5 + " -copy " + "zzz.tmp" + " \"" + string6 + string7 + "\"";
                if ((string3 = this.execOperatingSystemCommand(string3, false)).length() > 0) {
                    if (!bl) break;
                    LTOOLSgui.beepSound();
                    JOptionPane.showMessageDialog(LTOOLSgui.myProg, string3.trim(), string, 0);
                    break;
                }
                bl2 = true;
                DirFilePane.debugOutput("File \"" + string6 + string7 + "\" copied.");
                continue;
            }
            if (!LTOOLSgui.isConnected()) {
                string3 = "ldir -WRITE -x -s" + string5 + " -copy \"" + string4 + "\" \"" + string6 + string7 + "\"";
            } else {
                this.putFileToHost(string4);
                string3 = "ldir -WRITE -x -s" + string5 + " -copy " + "zzz.xxx" + " \"" + string6 + string7 + "\"";
            }
            string3 = this.execOperatingSystemCommand(string3, false);
            if (string3.length() > 0) {
                if (!bl) break;
                LTOOLSgui.beepSound();
                JOptionPane.showMessageDialog(LTOOLSgui.myProg, string3.trim(), string, 0);
                break;
            }
            bl2 = true;
            DirFilePane.debugOutput("File \"" + string6 + string7 + "\" copied.");
        }
        if (bl2) {
            this.updateLinuxJTable(this.getTreeNode(treePath));
        }
    }

    public String showPartitions() {
        DirFilePane.debugOutput("showPartitions()");
        String string = this.execOperatingSystemCommand("ldir -x -part", !LTOOLSgui.isConnected());
        String string2 = "*** Partition table info from LTOOLS: ***\n";
        String string3 = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((n = string.indexOf("#", n)) >= 0) {
            n2 = string.indexOf("\n", n);
            n3 = string.substring(n, n2).indexOf("Disk ");
            if (n3 > 0) {
                string3 = string.substring(n, n2).substring(n3 + 11, n3 + 19);
                string2 = string2 + "------------------------------------------------\n";
            } else {
                n3 = string.substring(n, n2).indexOf("Type:");
                if (n3 > 0) {
                    String string4 = string.substring(n, n2).substring(1, 4);
                    String string5 = string.substring(n, n2).substring(n3 + 5, n3 + 25);
                    string2 = string2 + " " + string3 + string4 + " :   " + string5 + "\n";
                } else {
                    n3 = string.substring(n, n2).indexOf("RFSTOOL infos");
                    if (n3 > 0) {
                        string2 = string2 + "\n*** Partition table info from RFSTOOL: ***\n";
                    }
                }
            }
            n = n2;
        }
        return string2;
    }

    void getFileFromHost(String string) {
        DirFilePane.debugOutput("getFileFromHost(\"" + string + "\")");
        String string2 = "";
        int n = 0;
        byte[] byArray = new byte[32768];
        try {
            int n2;
            string2 = "SENDFILE\n";
            LTOOLSgui.qSend.write(string2, 0, string2.length());
            LTOOLSgui.qSend.flush();
            int n3 = LTOOLSgui.bReceive.read(byArray, 0, 32768);
            string2 = new String(byArray, 0, 32);
            int n4 = Integer.parseInt(string2.substring(0, string2.indexOf(10)));
            for (n2 = 0; n2 < n3; ++n2) {
                if (byArray[n2] == 13) {
                    if (byArray[n2] == 10) {
                        n2 += 2;
                        break;
                    }
                    ++n2;
                    break;
                }
                if (byArray[n2] != 10) continue;
                if (byArray[n2] == 13) {
                    n2 += 2;
                    break;
                }
                ++n2;
                break;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray, n2, n);
            for (n = n3 - n2; n < n4; n += n3) {
                n3 = LTOOLSgui.bReceive.read(byArray, 0, 32768);
                fileOutputStream.write(byArray, 0, n3);
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Failed I/O " + iOException);
            return;
        }
    }

    public static String getLdirField(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (n2 == 9) {
                string2 = string.substring(string.indexOf(string2));
            }
            if (n2 == n) {
                return string2;
            }
            ++n2;
        }
        return "";
    }

    String getName(TreePath treePath, boolean bl) {
        String string;
        if (bl) {
            String string2 = "/";
            String string3 = this.getLinuxDrive(treePath.getPathComponent(1).toString()) + " ";
            if (treePath.getPathCount() >= 3) {
                string = string3 + string2 + treePath.getPathComponent(2).toString();
            } else if (treePath.getPathCount() > 1) {
                string = string3 + string2;
            } else {
                return "";
            }
            for (int i = 3; i < treePath.getPathCount(); ++i) {
                string = string + string2 + treePath.getPathComponent(i);
            }
        } else {
            String string4 = File.separator;
            if (treePath.getPathCount() >= 3) {
                string = treePath.getPathComponent(1).toString() + treePath.getPathComponent(2).toString();
            } else if (treePath.getPathCount() > 1) {
                string = treePath.getPathComponent(1).toString();
            } else {
                return "";
            }
            for (int i = 3; i < treePath.getPathCount(); ++i) {
                string = string + string4 + treePath.getPathComponent(i);
            }
        }
        return string;
    }

    void newDosDirectory(TreePath treePath) {
        String string = this.getName(treePath, false);
        if (string.equals("")) {
            return;
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        DirFilePane.debugOutput("newDosDirectory in directory: " + string);
        ModifyDosDialog modifyDosDialog = new ModifyDosDialog(LTOOLSgui.myProg, true, "", "", "", true, false);
        modifyDosDialog.setVisible(true);
        if (modifyDosDialog.getStatus() != 1) {
            return;
        }
        if (!modifyDosDialog.getFileName().equals("")) {
            String string2 = string + modifyDosDialog.getFileName();
            File file = new File(string2);
            if (!file.mkdir()) {
                LTOOLSgui.beepSound();
                String string3 = "Could not create directory \"" + string2 + "\".";
                JOptionPane.showMessageDialog(LTOOLSgui.myProg, string3, "LTOOLS", 0);
            }
            this.updateTreeNode(treePath);
        }
    }

    void newLinuxDirectory(TreePath treePath) {
        DirFilePane.debugOutput("newLinuxDirectory");
        String string = "Your Linux filesystem is set to read only - change in menu 'File - Linux read only' first";
        String string2 = "LTOOLS";
        String string3 = this.getName(treePath, true);
        if (string3.equals("")) {
            return;
        }
        String string4 = this.getLinuxPath(string3);
        if (LTOOLSgui.isLinuxReadOnly) {
            LTOOLSgui.beepSound();
            JOptionPane.showMessageDialog(LTOOLSgui.myProg, string, string2, 0);
            return;
        }
        ModifyLinuxDialog modifyLinuxDialog = new ModifyLinuxDialog(LTOOLSgui.myProg, true, "", "", "", "0", "0", "-rwxr-xr-x");
        modifyLinuxDialog.setVisible(true);
        if (modifyLinuxDialog.getStatus() != 1) {
            return;
        }
        if (LTOOLSgui.isConnected()) {
            this.putFileToHost("ldirtmpl");
        }
        String string5 = "ldir -WRITE ";
        string5 = modifyLinuxDialog.isLink() ? string5 + "-link " : string5 + "-mkdir ";
        string5 = string5 + "-x -s" + this.getLinuxDrive(string3) + " -f" + modifyLinuxDialog.getAccess();
        string5 = string5 + " -g" + modifyLinuxDialog.getGid().trim() + " -u" + modifyLinuxDialog.getUid().trim() + " ";
        string5 = modifyLinuxDialog.isLink() ? string5 + modifyLinuxDialog.getTargetName() + " " : (LTOOLSgui.isConnected() ? string5 + "zzz.xxx  " : string5 + "ldirtmpl ");
        string5 = string4.equals("/") ? string5 + "\"" + string4 + modifyLinuxDialog.getFileName() + "\"" : string5 + "\"" + string4 + "/" + modifyLinuxDialog.getFileName() + "\"";
        if (modifyLinuxDialog.getFileName().equals("") || modifyLinuxDialog.getFileName().indexOf("/") >= 0) {
            LTOOLSgui.beepSound();
            String string6 = "Invalid filename.";
            JOptionPane.showMessageDialog(LTOOLSgui.myProg, string6, string2, 0);
        } else {
            if ((string5 = this.execOperatingSystemCommand(string5, false)).length() > 0) {
                LTOOLSgui.beepSound();
                JOptionPane.showMessageDialog(LTOOLSgui.myProg, string5.trim(), string2, 0);
                return;
            }
            this.updateTreeNode(treePath);
        }
    }

    void updateTreeNode(TreePath treePath) {
        DirFilePane.debugOutput("updateTreeNode(TreePath path): " + treePath.toString());
        this.jTree.collapsePath(treePath);
        DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNode(treePath);
        defaultMutableTreeNode.removeAllChildren();
        if (this.isLinux) {
            this.addLinuxDirectories((DirectoryMutableTreeNode)defaultMutableTreeNode, this.getLdirPath(treePath), true);
            this.addLinuxSubDirectories((DirectoryMutableTreeNode)defaultMutableTreeNode, this.getLdirPath(treePath));
            this.treeModel.reload(defaultMutableTreeNode);
            this.jTree.expandPath(treePath);
            this.updateLinuxJTable(defaultMutableTreeNode);
        } else {
            this.setCurrentDirectory(this.jTree.getSelectionPath());
            this.addDOSDirectories((DirectoryMutableTreeNode)defaultMutableTreeNode, currentDirectory);
            this.addDOSSubDirectories((DirectoryMutableTreeNode)defaultMutableTreeNode, currentDirectory);
            this.treeModel.reload(defaultMutableTreeNode);
            this.jTree.expandPath(treePath);
            this.updateDOSJTable(defaultMutableTreeNode);
        }
    }

    void putFileToHost(String string) {
        String string2 = "";
        int n = 0;
        byte[] byArray = new byte[32768];
        try {
            int n2;
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(string);
            string2 = "RECEIVEFILE\n" + file.length() + "\n";
            LTOOLSgui.qSend.write(string2, 0, string2.length());
            LTOOLSgui.qSend.flush();
            while ((n2 = fileInputStream.read(byArray, 0, 32768)) >= 0) {
                LTOOLSgui.bSend.write(byArray, 0, n2);
                n += n2;
                if (n2 > 0) continue;
            }
            LTOOLSgui.bSend.flush();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Failed I/O " + iOException);
            return;
        }
    }

    String execOperatingSystemCommand(String string, boolean bl) {
        String string2 = "";
        Runtime runtime = Runtime.getRuntime();
        Cursor cursor = Cursor.getDefaultCursor();
        Cursor cursor2 = Cursor.getPredefinedCursor(3);
        if (!File.separator.equals("\\")) {
            string = "./" + string;
        }
        int n = 0;
        byte[] byArray = new byte[32768];
        if (LTOOLSgui.isConnected() && !bl) {
            return this.remoteOperatingSystemCommand(string);
        }
        if (LTOOLSgui.myProg != null) {
            cursor = LTOOLSgui.myProg.getCursor();
            LTOOLSgui.myProg.setCursor(cursor2);
        }
        DirFilePane.debugOutput(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        DirFilePane.debugOutput("Executing operating system command:\n   --" + string + "--");
        if (File.separatorChar == '/') {
            string = string.replace('\"', ' ');
        }
        try {
            Process process = runtime.exec(string);
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Failed Process waitFor " + interruptedException);
            }
            FileInputStream fileInputStream = new FileInputStream("zzz.zwz");
            while ((n = fileInputStream.read(byArray, 0, 32768)) >= 0) {
                string2 = string2 + new String(byArray, 0, n);
                if (n > 0) continue;
                break;
            }
        }
        catch (IOException iOException) {
            System.err.println("Failed I/O " + iOException);
            LTOOLSgui.beepSound();
            JOptionPane.showMessageDialog(LTOOLSgui.myProg, iOException.getMessage(), "LTOOLS", 0);
            if (LTOOLSgui.myProg != null) {
                LTOOLSgui.myProg.setCursor(cursor);
            }
            return "Executing operating system command failed:\n   " + string;
        }
        if (LTOOLSgui.myProg != null) {
            LTOOLSgui.myProg.setCursor(cursor);
        }
        return string2;
    }

    String remoteOperatingSystemCommand(String string) {
        DirFilePane.debugOutput("Executing command on remote server: \n   " + string);
        String string2 = "";
        char[] cArray = new char[32768];
        Cursor cursor = Cursor.getDefaultCursor();
        Cursor cursor2 = Cursor.getPredefinedCursor(3);
        if (LTOOLSgui.myProg != null) {
            cursor = LTOOLSgui.myProg.getCursor();
            LTOOLSgui.myProg.setCursor(cursor2);
        }
        try {
            int n;
            String string3 = "EXECUTE\n" + string + "\n";
            LTOOLSgui.qSend.write(string3, 0, string3.length());
            LTOOLSgui.qSend.flush();
            string3 = LTOOLSgui.qReceive.readLine();
            int n2 = Integer.parseInt(string3);
            for (int i = 0; i < n2; i += n) {
                n = LTOOLSgui.qReceive.read(cArray, 0, 32768);
                string3 = new String(cArray, 0, n);
                string2 = string2 + string3;
            }
        }
        catch (IOException iOException) {
            System.err.println("Failed I/O to " + iOException);
            LTOOLSgui.beepSound();
            JOptionPane.showMessageDialog(LTOOLSgui.myProg, iOException.getMessage(), "LTOOLS", 0);
        }
        if (LTOOLSgui.myProg != null) {
            LTOOLSgui.myProg.setCursor(cursor);
        }
        return string2;
    }

    void startDosApplication(ListItemFile listItemFile, boolean bl) {
        DirFilePane.debugOutput("startDosApplication");
        if (bl && !File.separator.equals("\\")) {
            LTOOLSgui.beepSound();
            JOptionPane.showMessageDialog(this, "Sorry, starting applications only supported under Dos", "LTOOLS", 0);
            return;
        }
        String string = bl ? "runit.bat \"" + listItemFile.getFullFilePath() + "\"" : "edit.bat \"" + listItemFile.getFullFilePath() + "\"";
        string = this.execOperatingSystemCommand(string, true);
    }

    public void doubleClickDOSTable() {
        int n = this.jTable.getSelectedRow();
        ListItemFile listItemFile = this.tableModel.getListItemFile(n);
        if (listItemFile.isError()) {
            return;
        }
        if (listItemFile.isDirectory()) {
            DirFilePane.debugOutput("jTree.getSelectionPath(): " + this.jTree.getSelectionPath().toString());
            if (listItemFile.getFileName().equals("..")) {
                this.jTree.setSelectionPath(this.jTree.getSelectionPath().getParentPath());
                return;
            }
            TreePath treePath = this.jTree.getSelectionPath();
            if (!this.jTree.isExpanded(treePath)) {
                this.jTree.expandPath(treePath);
            }
            TreePath treePath2 = this.jTree.getSelectionPath().pathByAddingChild(listItemFile.getFileName());
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNode(treePath);
                int n2 = this.jTree.getSelectionRows()[0];
                int n3 = 0;
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    int n4 = n2 + i + 1;
                    if (this.jTree.isExpanded(n4)) {
                        this.jTree.collapseRow(n4);
                    }
                    if (!defaultMutableTreeNode.getChildAt(i).toString().equals((String)treePath2.getLastPathComponent())) continue;
                    n3 = i + 1;
                }
                this.jTree.setSelectionRow(n2 + n3);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else {
            this.startDosApplication(listItemFile, true);
        }
    }

    void startLinuxApplication(ListItemFile listItemFile, boolean bl) {
        String string;
        String string2;
        DirFilePane.debugOutput("startLinuxApplication");
        if (bl && !File.separator.equals("\\")) {
            LTOOLSgui.beepSound();
            String string3 = "Sorry, starting applications only supported under Dos";
            JOptionPane.showMessageDialog(LTOOLSgui.myProg, string3, "LTOOLS", 0);
            return;
        }
        String string4 = listItemFile.getFullFilePath();
        String string5 = listItemFile.getFileName();
        if (listItemFile.isLink()) {
            string2 = this.getLinuxDrive(currentDirectory);
            string5 = this.getFileNameFromLink(listItemFile.getFullFilePath());
            string = this.getFilePathFromLink(listItemFile.getFullFilePath());
        } else {
            string2 = this.getLinuxDrive(currentDirectory);
            string = this.getLinuxPath(string4);
        }
        String string6 = LTOOLSgui.isConnected() ? "ldir -READ -x -s" + string2 + " \"" + string + "\" " + "zzz.xxx" : "ldir -READ -x -s" + string2 + " \"" + string + "\" \"" + LTOOLSgui.tempPathLinuxFiles + string5 + "\"";
        string6 = this.execOperatingSystemCommand(string6, false);
        if (string6.length() > 0) {
            LTOOLSgui.beepSound();
            JOptionPane.showMessageDialog(this, string6.trim(), "LTOOLS", 0);
            return;
        }
        if (LTOOLSgui.isConnected()) {
            this.getFileFromHost(LTOOLSgui.tempPathLinuxFiles + string5);
        }
        string6 = bl ? "runit.bat \"" + LTOOLSgui.tempPathLinuxFiles + string5 + "\"" : "edit.bat \"" + LTOOLSgui.tempPathLinuxFiles + string5 + "\"";
        this.execOperatingSystemCommand(string6, true);
    }

    public void doubleClickLinuxTable() {
        int n = this.jTable.getSelectedRow();
        ListItemFile listItemFile = this.tableModel.getListItemFile(n);
        TreePath treePath = this.jTree.getSelectionPath();
        DirFilePane.debugOutput("doubleClickLinuxTable(): \"" + listItemFile.getFullFilePath() + "\" --- path: " + treePath.toString());
        if (listItemFile.isError()) {
            return;
        }
        if (listItemFile.isDirectory()) {
            if (listItemFile.getFileName().equals("..")) {
                this.jTree.setSelectionPath(this.jTree.getSelectionPath().getParentPath());
                return;
            }
            if (!this.jTree.isExpanded(treePath)) {
                this.jTree.expandPath(treePath);
            }
            TreePath treePath2 = this.jTree.getSelectionPath().pathByAddingChild(listItemFile.getFileName());
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNode(treePath);
                int n2 = this.jTree.getSelectionRows()[0];
                int n3 = 0;
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    int n4 = n2 + i + 1;
                    if (this.jTree.isExpanded(n4)) {
                        this.jTree.collapseRow(n4);
                    }
                    if (!defaultMutableTreeNode.getChildAt(i).toString().equals((String)treePath2.getLastPathComponent())) continue;
                    n3 = i + 1;
                }
                this.jTree.setSelectionRow(n2 + n3);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else {
            this.startLinuxApplication(listItemFile, true);
        }
    }

    private String getFileNameFromLink(String string) {
        int n = string.indexOf("->", 0) + 3;
        String string2 = string.substring(n);
        String string3 = string2.startsWith("/") ? string2.substring(string2.lastIndexOf("/") + 1) : string2;
        return string3;
    }

    public String getFilePathFromLink(String string) {
        String string2;
        int n = string.indexOf("->", 0) + 3;
        String string3 = string.substring(n);
        if (string3.startsWith("/")) {
            string2 = string3;
        } else {
            String string4 = this.getLinuxPath(string);
            string2 = string4.substring(0, string4.lastIndexOf("/") + 1) + string3;
        }
        return string2;
    }

    private String getLinkName(String string) {
        int n = string.indexOf("->", 0) - 1;
        String string2 = string.substring(0, n);
        return string2;
    }

    public void fillDosDirectoryTree() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DirFilePane.debugOutput("fillDosDirectoryTree");
        this.dosDrives = new Vector();
        this.getDOSDriveTypes();
        this.root = defaultMutableTreeNode = new DefaultMutableTreeNode(new LToolGuiTreeIconData(ICON_COMPUTER, null, rootNodeText));
        for (int i = 0; i < this.dosDrives.size(); ++i) {
            DriveType driveType = (DriveType)this.dosDrives.elementAt(i);
            DirectoryMutableTreeNode directoryMutableTreeNode = new DirectoryMutableTreeNode(this, new LToolGuiTreeIconData(DirFilePane.getDriveIcon(driveType), null, driveType.getDrive()), "\\", driveType.getDrive());
            if (driveType.getType() == DriveType.DriveRemoveable || driveType.getType() == DriveType.DriveCDRom) {
                directoryMutableTreeNode.setIsRemovableDrive(true);
            }
            defaultMutableTreeNode.add(directoryMutableTreeNode);
            currentDirectory = driveType.getDrive();
            if (directoryMutableTreeNode.isRemovableDrive()) continue;
            this.addDOSDirectories(directoryMutableTreeNode, currentDirectory);
        }
        this.treeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.jTree.setModel(this.treeModel);
        this.jTree.getSelectionModel().setSelectionMode(1);
        this.jTree.putClientProperty("JTree.lineStyle", "Angled");
        LToolGuiTreeIconCellRenderer lToolGuiTreeIconCellRenderer = new LToolGuiTreeIconCellRenderer();
        this.jTree.setCellRenderer(lToolGuiTreeIconCellRenderer);
        this.jTree.setShowsRootHandles(true);
        this.jTree.setEditable(false);
        if (File.separator.equals("\\")) {
            this.selectDriveC();
        } else {
            this.selectDriveFirst();
        }
    }

    public void selectDriveC() {
        boolean bl = false;
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            if (!this.root.getChildAt(i).toString().equals("C:\\")) continue;
            bl = true;
            int n = 0;
            if (this.jTree.isRootVisible()) {
                n = 1;
            }
            this.jTree.setSelectionRow(i + n);
            break;
        }
        if (!bl) {
            this.jTree.setSelectionRow(1);
        }
    }

    public void addDOSDirectories(DirectoryMutableTreeNode directoryMutableTreeNode, String string) {
        DirFilePane.debugOutput("addDOSDirectories-path: " + string);
        try {
            int n;
            File file = new File(string);
            Vector<DirectoryMutableTreeNode> vector = new Vector<DirectoryMutableTreeNode>();
            File[] fileArray = file.listFiles();
            for (n = 0; n < fileArray.length; ++n) {
                if (!fileArray[n].isDirectory()) continue;
                DirectoryMutableTreeNode directoryMutableTreeNode2 = new DirectoryMutableTreeNode(this, new LToolGuiTreeIconData(ICON_FOLDER, ICON_EXPANDEDFOLDER, fileArray[n].getName()), fileArray[n].getName(), directoryMutableTreeNode.getDrive());
                vector.add(directoryMutableTreeNode2);
            }
            Collections.sort(vector);
            for (n = 0; n < vector.size(); ++n) {
                directoryMutableTreeNode.add((DirectoryMutableTreeNode)vector.get(n));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addDOSSubDirectories(DirectoryMutableTreeNode directoryMutableTreeNode, String string) {
        DirFilePane.debugOutput("addDOSSubDirectories");
        try {
            for (int i = 0; i < directoryMutableTreeNode.getChildCount(); ++i) {
                String string2;
                DirectoryMutableTreeNode directoryMutableTreeNode2 = (DirectoryMutableTreeNode)directoryMutableTreeNode.getChildAt(i);
                if (!string.endsWith(File.separator)) {
                    string = string + File.separator;
                }
                if (!(string2 = string + directoryMutableTreeNode2.toString()).endsWith(File.separator)) {
                    string2 = string2 + File.separator;
                }
                this.addDOSDirectories(directoryMutableTreeNode2, string2);
            }
            directoryMutableTreeNode.setSubDirectoriesAdded(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateDOSJTable(DefaultMutableTreeNode defaultMutableTreeNode) {
        Vector<ListItemFile> vector = new Vector<ListItemFile>();
        Vector<ListItemFile> vector2 = new Vector<ListItemFile>();
        DirFilePane.debugOutput("updateDOSJTable");
        try {
            ListItemFile listItemFile;
            String string;
            String string2;
            File file;
            int n;
            if (defaultMutableTreeNode.toString().equals(rootNodeText)) {
                this.showDrives();
                return;
            }
            this.tableModel.removeAllRows();
            if (this.jTree.getSelectionPath() != null) {
                this.setCurrentDirectory(this.jTree.getSelectionPath());
            }
            DirFilePane.debugOutput("updateDOSJTable() - DOS: \"" + currentDirectory + "\"");
            this.jLabelDirectory.setText("Directory: " + currentDirectory);
            String string3 = this.getCurrentDirectory();
            File file2 = new File(string3);
            String[] stringArray = file2.list(new DOSFileFilter(LTOOLSgui.getDosFilePattern()));
            if (defaultMutableTreeNode.getLevel() > 1) {
                ListItemFile listItemFile2 = new ListItemFile("..", true, "", "", "", "", "", ListItemFile.ICON_FOLDERUP);
                this.tableModel.addListItemFile(listItemFile2);
            }
            for (n = 0; n < stringArray.length; ++n) {
                file = new File(string3 + File.separator + stringArray[n]);
                if (!file.isDirectory()) continue;
                string2 = new Long(file.length()).toString();
                string = new Date(file.lastModified()).toString();
                listItemFile = new ListItemFile(file.getName(), file.isDirectory(), file.getPath(), file.getPath(), string2, string, "", ListItemFile.ICON_FOLDER);
                vector.add(listItemFile);
            }
            for (n = 0; n < stringArray.length; ++n) {
                file = new File(string3 + File.separator + stringArray[n]);
                if (file.isDirectory()) continue;
                string2 = new Long(file.length()).toString();
                string = new Date(file.lastModified()).toString();
                listItemFile = new ListItemFile(file.getName(), file.isDirectory(), file.getPath(), file.getPath(), string2, string, "", ListItemFile.ICON_FILE);
                vector2.add(listItemFile);
            }
            this.insertListItemFilesInJTable(vector, vector2);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            vector.removeAllElements();
            vector2.removeAllElements();
            String string = "";
            string = nullPointerException.getMessage() != null ? nullPointerException.getMessage() : "Drive not ready";
            ListItemFile listItemFile = new ListItemFile(string);
            vector.add(listItemFile);
            this.insertListItemFilesInJTable(vector, vector2);
        }
    }

    public void fillLinuxDirectoryTree() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DirFilePane.debugOutput("fillLinuxDirectoryTree");
        if (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeAllRows();
            this.tableModel.fireTableDataChanged();
        }
        this.root = defaultMutableTreeNode = new DefaultMutableTreeNode(new LToolGuiTreeIconData(ICON_COMPUTER, null, rootNodeText));
        Vector vector = this.getLinuxDrives();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            String string2 = string.substring(0, string.indexOf(" "));
            String string3 = string.substring(string.indexOf(" ") + 1);
            DirectoryMutableTreeNode directoryMutableTreeNode = new DirectoryMutableTreeNode(this, new LToolGuiTreeIconData(ICON_DRIVE_FIXED, null, vector.elementAt(i)), string3, string2);
            defaultMutableTreeNode.add(directoryMutableTreeNode);
            currentDirectory = (String)vector.elementAt(i);
            if (this.addLinuxDirectories(directoryMutableTreeNode, currentDirectory, false)) continue;
            defaultMutableTreeNode.remove(directoryMutableTreeNode);
        }
        this.treeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.jTree.setModel(this.treeModel);
        this.jTree.getSelectionModel().setSelectionMode(1);
        this.jTree.putClientProperty("JTree.lineStyle", "Angled");
        LToolGuiTreeIconCellRenderer lToolGuiTreeIconCellRenderer = new LToolGuiTreeIconCellRenderer();
        this.jTree.setCellRenderer(lToolGuiTreeIconCellRenderer);
        this.jTree.setShowsRootHandles(true);
        this.jTree.setEditable(false);
        this.selectDriveFirst();
    }

    public void selectDriveFirst() {
        if (this.root.getChildCount() >= 1) {
            int n = 0;
            if (this.jTree.isRootVisible()) {
                n = 1;
            }
            this.jTree.setSelectionRow(0 + n);
        }
    }

    public boolean addLinuxDirectories(DirectoryMutableTreeNode directoryMutableTreeNode, String string, boolean bl) {
        DirFilePane.debugOutput("addLinuxDirectories-path: " + string);
        try {
            String string2 = this.getLinuxPath(string);
            String string3 = "ldir -x -s" + directoryMutableTreeNode.getDrive() + " \"" + string2 + "\"";
            String string4 = this.execOperatingSystemCommand(string3, !LTOOLSgui.isConnected());
            if (!string4.startsWith("d") || !("" + string4.charAt(56)).equals(".")) {
                if (bl) {
                    JOptionPane.showMessageDialog(LTOOLSgui.myProg, "ERROR: " + string4, "LTOOLSgui", 0);
                }
                return false;
            }
            Vector<DirectoryMutableTreeNode> vector = new Vector<DirectoryMutableTreeNode>();
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                String string5;
                String string6;
                String string7 = stringTokenizer.nextToken();
                if (string7.length() <= 56 || (string6 = DirFilePane.getLdirField(string7, 0)).charAt(0) != 'd' || (string5 = DirFilePane.getLdirField(string7, 9)).equals(".") || string5.equals("..")) continue;
                DirectoryMutableTreeNode directoryMutableTreeNode2 = new DirectoryMutableTreeNode(this, new LToolGuiTreeIconData(ICON_FOLDER, ICON_EXPANDEDFOLDER, string5), string5, directoryMutableTreeNode.getDrive());
                vector.add(directoryMutableTreeNode2);
            }
            Collections.sort(vector);
            for (int i = 0; i < vector.size(); ++i) {
                directoryMutableTreeNode.add((DirectoryMutableTreeNode)vector.get(i));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public void addLinuxSubDirectories(DirectoryMutableTreeNode directoryMutableTreeNode, String string) {
        DirFilePane.debugOutput("addLinuxSubDirectories()");
        try {
            for (int i = 0; i < directoryMutableTreeNode.getChildCount(); ++i) {
                String string2;
                DirectoryMutableTreeNode directoryMutableTreeNode2 = (DirectoryMutableTreeNode)directoryMutableTreeNode.getChildAt(i);
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
                if (!(string2 = string + directoryMutableTreeNode2.toString()).endsWith("/")) {
                    string2 = string2 + "/";
                }
                this.addLinuxDirectories(directoryMutableTreeNode2, string2, true);
            }
            directoryMutableTreeNode.setSubDirectoriesAdded(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getLinuxDrive(String string) {
        String string2 = string.substring(0, string.indexOf(" "));
        return string2;
    }

    private String getLinuxPath(String string) {
        String string2 = string.substring(string.indexOf(" ") + 1);
        return string2;
    }

    public void updateLinuxJTable(DefaultMutableTreeNode defaultMutableTreeNode) {
        DirFilePane.debugOutput("updateLinuxJTable");
        try {
            if (defaultMutableTreeNode.toString().equals(rootNodeText)) {
                this.showDrives();
                return;
            }
        }
        catch (Exception exception) {
            LTOOLSgui.beepSound();
            JOptionPane.showMessageDialog(LTOOLSgui.myProg, "error: " + exception.getMessage());
        }
        try {
            Object object;
            Object object2;
            String string;
            Object object3;
            Object object4;
            String string2;
            Object object5;
            Vector<Object> vector = new Vector<Object>();
            Vector<ListItemFile> vector2 = new Vector<ListItemFile>();
            this.tableModel.removeAllRows();
            if (this.jTree.getSelectionPath() != null) {
                this.setCurrentDirectory(this.jTree.getSelectionPath());
            }
            DirFilePane.debugOutput("updateLinuxJTable() - LINUX: \"" + currentDirectory + "\"");
            this.jLabelDirectory.setText("Directory: " + currentDirectory);
            if (defaultMutableTreeNode.getLevel() > 1) {
                object5 = new ListItemFile("..", true, "", "", "", "", "", ListItemFile.ICON_FOLDERUP);
                this.tableModel.addListItemFile((ListItemFile)object5);
            }
            object5 = currentDirectory;
            String string3 = "-x -s" + this.getLinuxDrive(currentDirectory) + " \"" + this.getLinuxPath(currentDirectory) + "\"";
            String string4 = "ldir " + string3;
            String string5 = this.execOperatingSystemCommand(string4, !LTOOLSgui.isConnected());
            if (!string5.startsWith("d") || !("" + string5.charAt(56)).equals(".")) {
                JOptionPane.showMessageDialog(LTOOLSgui.myProg, "ERROR: " + string5, "LTOOLSgui", 0);
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string5, "\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                String string6;
                string2 = stringTokenizer.nextToken();
                if (string2.length() < 56) {
                    vector.removeAllElements();
                    vector2.removeAllElements();
                    object4 = string2;
                    object3 = new ListItemFile((String)object4);
                    vector.add(object3);
                    while (stringTokenizer.hasMoreTokens()) {
                        object4 = stringTokenizer.nextToken();
                        object3 = new ListItemFile((String)object4);
                        vector.add(object3);
                    }
                    this.insertListItemFilesInJTable(vector, vector2);
                    return;
                }
                object4 = DirFilePane.getLdirField(string2, 9);
                object3 = DirFilePane.getLdirField(string2, 0);
                char c = ((String)object3).charAt(0);
                if (c == 'd') {
                    if (((String)object4).equals(".") || ((String)object4).equals("..")) continue;
                    string = DirFilePane.getLdirField(string2, 3);
                    object2 = DirFilePane.getLdirField(string2, 4) + " " + DirFilePane.getLdirField(string2, 5) + " " + DirFilePane.getLdirField(string2, 6) + " " + DirFilePane.getLdirField(string2, 7) + " " + DirFilePane.getLdirField(string2, 8);
                    string6 = currentDirectory.endsWith("/") ? currentDirectory + (String)object4 : currentDirectory + "/" + (String)object4;
                    object = new ListItemFile((String)object4, true, currentDirectory, string6, string, (String)object2, string2, ListItemFile.ICON_FOLDER);
                    vector.addElement(object);
                    continue;
                }
                if (!LTOOLSgui.getLinuxFilePattern().equals("*")) continue;
                string = DirFilePane.getLdirField(string2, 3);
                object2 = DirFilePane.getLdirField(string2, 4) + " " + DirFilePane.getLdirField(string2, 5) + " " + DirFilePane.getLdirField(string2, 6) + " " + DirFilePane.getLdirField(string2, 7) + " " + DirFilePane.getLdirField(string2, 8);
                string6 = currentDirectory.endsWith("/") ? currentDirectory + (String)object4 : currentDirectory + "/" + (String)object4;
                object = new ListItemFile((String)object4, false, currentDirectory, string6, string, (String)object2, string2, ListItemFile.ICON_FILE);
                vector2.addElement((ListItemFile)object);
            }
            if (!LTOOLSgui.getLinuxFilePattern().equals("*")) {
                string2 = "ldir -x -s" + this.getLinuxDrive(currentDirectory) + " \"" + this.getLinuxPath(currentDirectory) + LTOOLSgui.getLinuxFilePattern() + "\"";
                string5 = this.execOperatingSystemCommand(string2, !LTOOLSgui.isConnected());
                if (!string5.startsWith("d") || !("" + string5.charAt(56)).equals(".")) {
                    JOptionPane.showMessageDialog(LTOOLSgui.myProg, "ERROR: " + string5, "LTOOLSgui", 0);
                    return;
                }
                object4 = new StringTokenizer(string5, "\n\r");
                object3 = "Can't find '" + LTOOLSgui.getLinuxFilePattern() + "'.Linux Path Invalid";
                while (((StringTokenizer)object4).hasMoreTokens()) {
                    Object object6;
                    String string7 = ((StringTokenizer)object4).nextToken();
                    if (string7.length() < 56) {
                        string = "";
                        object2 = new Vector();
                        String string8 = string7;
                        ((Vector)object2).add(string7);
                        while (((StringTokenizer)object4).hasMoreTokens()) {
                            object = ((StringTokenizer)object4).nextToken();
                            ((Vector)object2).add(object);
                            string8 = string8 + (String)object;
                        }
                        if (string8.equals(object3)) continue;
                        vector.removeAllElements();
                        vector2.removeAllElements();
                        for (int i = 0; i < ((Vector)object2).size(); ++i) {
                            object6 = new ListItemFile((String)((Vector)object2).elementAt(i));
                            vector.add(object6);
                        }
                        this.insertListItemFilesInJTable(vector, vector2);
                        return;
                    }
                    string = DirFilePane.getLdirField(string7, 9);
                    object2 = DirFilePane.getLdirField(string7, 0);
                    char c = ((String)object2).charAt(0);
                    if (c == 'd') continue;
                    object = DirFilePane.getLdirField(string7, 3);
                    object6 = DirFilePane.getLdirField(string7, 4) + " " + DirFilePane.getLdirField(string7, 5) + " " + DirFilePane.getLdirField(string7, 6) + " " + DirFilePane.getLdirField(string7, 7) + " " + DirFilePane.getLdirField(string7, 8);
                    String string9 = currentDirectory.endsWith("/") ? currentDirectory + string : currentDirectory + "/" + string;
                    ListItemFile listItemFile = new ListItemFile(string, false, currentDirectory, string9, (String)object, (String)object6, string7, ListItemFile.ICON_FILE);
                    vector2.addElement(listItemFile);
                }
            }
            this.insertListItemFilesInJTable(vector, vector2);
        }
        catch (Exception exception) {
            DirFilePane.debugOutput("updateLinuxJTable(): " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void insertListItemFilesInJTable(Vector vector, Vector vector2) {
        int n;
        Collections.sort(vector);
        Collections.sort(vector2);
        for (n = 0; n < vector.size(); ++n) {
            this.tableModel.addListItemFile((ListItemFile)vector.elementAt(n));
        }
        for (n = 0; n < vector2.size(); ++n) {
            this.tableModel.addListItemFile((ListItemFile)vector2.elementAt(n));
        }
        this.tableModel.fireTableDataChanged();
        if (!this.sortOrder) {
            this.changeSortOrderInJTable();
        }
    }

    public void changeSortOrderInJTable() {
        int n;
        Vector<ListItemFile> vector = new Vector<ListItemFile>();
        for (n = 0; n < this.tableModel.getRowCount(); ++n) {
            vector.add(this.tableModel.getListItemFile(n));
        }
        this.tableModel.removeAllRows();
        for (n = vector.size() - 1; n >= 0; --n) {
            this.tableModel.addListItemFile((ListItemFile)vector.elementAt(n));
        }
        this.tableModel.fireTableDataChanged();
    }

    public void changeSortOrder() {
        this.sortOrder = !this.sortOrder;
    }

    private Vector getLinuxDrives() {
        String string;
        Object object;
        DirFilePane.debugOutput("getLinuxDrives()");
        Vector<String> vector = new Vector<String>();
        try {
            String string2 = this.showPartitions();
            object = new StringTokenizer(string2, "\n\r");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                if (!DirFilePane.getLdirField(string3, 3).toLowerCase().equals("linux") || DirFilePane.getLdirField(string3, 4).toLowerCase().equals("swap")) continue;
                string = DirFilePane.getLdirField(string3, 0) + DirFilePane.getLdirField(string3, 1) + " " + "/";
                vector.add(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            vector.removeAllElements();
        }
        block3: for (int i = 0; i < vector.size(); ++i) {
            object = ("" + vector.elementAt(i)).substring(6, 10);
            for (int j = i + 1; j < vector.size(); ++j) {
                string = ("" + vector.elementAt(j)).substring(6, 10);
                if (!((String)object).equals(string)) continue;
                DirFilePane.debugOutput("i=" + i + "---" + (String)object + "---   " + "j=" + j + "---" + string + "---   ");
                vector.removeElementAt(i);
                continue block3;
            }
        }
        return vector;
    }

    public void setCurrentDirectory(TreePath treePath) {
        currentDirectory = this.getDOSLinuxPath(treePath);
    }

    public void setCurrentDirectory(String string) {
        currentDirectory = string;
    }

    public String getCurrentDirectory() {
        return currentDirectory;
    }

    public String getDOSLinuxPath(TreePath treePath) {
        String string = "";
        if (this.isLinux()) {
            for (int i = 1; i < treePath.getPathCount(); ++i) {
                if ((string = string + treePath.getPathComponent(i)).endsWith("/")) continue;
                string = string + "/";
            }
            if (!string.endsWith("/")) {
                string = string + "/";
            }
        } else {
            for (int i = 1; i < treePath.getPathCount(); ++i) {
                if ((string = string + treePath.getPathComponent(i)).endsWith(File.separator)) continue;
                string = string + File.separator;
            }
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
        }
        return string;
    }

    public String getLdirPath(TreePath treePath) {
        String string = "";
        for (int i = 1; i < treePath.getPathCount(); ++i) {
            if ((string = string + treePath.getPathComponent(i)).endsWith("/")) continue;
            string = string + "/";
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    public TreePath getTreeSelectionPath() {
        return this.jTree.getSelectionPath();
    }

    public Vector getSelectedListItemFile() {
        Vector<ListItemFile> vector = new Vector<ListItemFile>();
        int[] nArray = this.jTable.getSelectedRows();
        for (int i = 0; i < this.jTable.getSelectedRowCount(); ++i) {
            ListItemFile listItemFile = this.tableModel.getListItemFile(nArray[i]);
            vector.add(listItemFile);
        }
        return vector;
    }

    public int getTableSelectionCount() {
        return this.jTable.getSelectedRowCount();
    }

    private void showDrives() {
        System.out.println("showDrives()");
        this.tableModel.removeAllRows();
        this.tableModel.fireTableDataChanged();
    }

    public void refreshTreeNode() {
        DirFilePane.debugOutput("refreshTreeNode(): " + this.jTree.getSelectionPath().toString());
        if (this.jTree.getSelectionCount() == 1) {
            int n = this.jTree.getSelectionRows()[0];
            if (this.jTree.isExpanded(n)) {
                this.jTree.collapseRow(n);
            }
            if (this.isLinux()) {
                DirectoryMutableTreeNode directoryMutableTreeNode = (DirectoryMutableTreeNode)this.getTreeNode(this.jTree.getSelectionPath());
                directoryMutableTreeNode.removeAllChildren();
                this.addLinuxDirectories(directoryMutableTreeNode, this.getLdirPath(this.jTree.getSelectionPath()), true);
                this.addLinuxSubDirectories(directoryMutableTreeNode, this.getLdirPath(this.jTree.getSelectionPath()));
                this.treeModel.reload(directoryMutableTreeNode);
                this.jTree.expandRow(n);
            } else {
                DirectoryMutableTreeNode directoryMutableTreeNode = (DirectoryMutableTreeNode)this.getTreeNode(this.jTree.getSelectionPath());
                directoryMutableTreeNode.removeAllChildren();
                this.setCurrentDirectory(this.jTree.getSelectionPath());
                this.addDOSDirectories(directoryMutableTreeNode, currentDirectory);
                this.addDOSSubDirectories(directoryMutableTreeNode, currentDirectory);
                this.treeModel.reload(directoryMutableTreeNode);
                this.jTree.expandRow(n);
            }
        }
    }

    public void removeDrive() {
        if (this.jTree.getSelectionCount() == 1) {
            if (this.jTree.getSelectionPath().getPathCount() >= 2) {
                int n = this.jTree.getSelectionRows()[0];
                TreePath treePath = this.jTree.getSelectionPath();
                while (treePath.getPathCount() > 2) {
                    treePath = treePath.getParentPath();
                }
                DirFilePane.debugOutput("remove: " + treePath.toString());
                DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeRoot();
                DirFilePane.debugOutput("getTreeNode(path): " + this.getTreeNode(treePath));
                DirFilePane.debugOutput("root: " + defaultMutableTreeNode.toString());
                defaultMutableTreeNode.remove(this.getTreeNode(treePath));
                this.treeModel.reload();
                if (this.isLinux()) {
                    this.selectDriveFirst();
                } else {
                    this.selectDriveC();
                }
            } else {
                DirFilePane.debugOutput("cannot remove " + this.jTree.getSelectionPath().toString());
                return;
            }
        }
    }

    public void addDrive() {
        AddDriveDialog addDriveDialog = new AddDriveDialog((Frame)LTOOLSgui.myProg, true, this.isLinux());
        addDriveDialog.show();
        if (addDriveDialog.getStatus()) {
            DirFilePane.debugOutput("add a drive --- device: \"" + addDriveDialog.getDevice() + "\" " + "directory: \"" + addDriveDialog.getDirectory() + "\"");
            DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeRoot();
            if (this.isLinux()) {
                DirFilePane.debugOutput("top.toString(): " + defaultMutableTreeNode.toString());
                String string = addDriveDialog.getDirectory();
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
                String string2 = addDriveDialog.getDevice();
                String string3 = string2 + " " + string;
                DirectoryMutableTreeNode directoryMutableTreeNode = new DirectoryMutableTreeNode(this, new LToolGuiTreeIconData(ICON_DRIVE_FIXED, null, string3), string, string2);
                defaultMutableTreeNode.add(directoryMutableTreeNode);
                this.addLinuxDirectories(directoryMutableTreeNode, string3, true);
                this.getTreeModel().reload();
                this.selectDriveFirst();
            } else {
                DirFilePane.debugOutput("top.toString(): " + defaultMutableTreeNode.toString());
                String string = addDriveDialog.getDevice() + addDriveDialog.getDirectory();
                if (!string.endsWith(File.separator)) {
                    string = string + File.separator;
                }
                this.setCurrentDirectory(string);
                DirectoryMutableTreeNode directoryMutableTreeNode = new DirectoryMutableTreeNode(this, new LToolGuiTreeIconData(ICON_DRIVE_FIXED, null, string), "\\", string);
                this.addDOSDirectories(directoryMutableTreeNode, currentDirectory);
                defaultMutableTreeNode.add(directoryMutableTreeNode);
                this.getTreeModel().reload();
                this.selectDriveC();
            }
        }
    }

    public JTable getJTable() {
        return this.jTable;
    }

    public LToolGuiTableModel getTableModel() {
        return this.tableModel;
    }

    public JTableHeader getJTableHeader() {
        return this.jTableHeader;
    }

    public ContextMenuTable getContextMenuTable() {
        return this.contextMenuTable;
    }

    public ContextMenuTree getContextMenuTree() {
        return this.contextMenuTree;
    }

    public JTree getJTree() {
        return this.jTree;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public boolean isLinux() {
        return this.isLinux;
    }

    public String getRootNodeText() {
        return rootNodeText;
    }

    public DefaultMutableTreeNode getTreeRoot() {
        return this.root;
    }

    public void getDOSDriveTypes() {
        DirFilePane.debugOutput("getDOSDriveTypes");
        try {
            this.dosDrives.removeAllElements();
            this.dosDrives = DriveType.getDOSDriveTypesOnMachine();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static ImageIcon getDriveIcon(DriveType driveType) {
        switch (driveType.getType()) {
            case 0: {
                return ICON_DRIVE_UNKNOWN;
            }
            case 1: {
                return ICON_DRIVE_NOROOTDIR;
            }
            case 2: {
                return ICON_DRIVE_REMOVEABLE;
            }
            case 3: {
                return ICON_DRIVE_FIXED;
            }
            case 4: {
                return ICON_DRIVE_REMOTE;
            }
            case 5: {
                return ICON_DRIVE_CDROM;
            }
            case 6: {
                return ICON_DRIVE_RAMDISK;
            }
        }
        return ICON_DRIVE_FIXED;
    }

    public void setBackgroundTreeTable(Color color) {
        this.jTree.setBackground(color);
        this.jTable.setBackground(color);
    }

    static void debugOutput(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        DirFilePane.debugOutput(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        DirFilePane.debugOutput("public void dragGestureRecognized(DragGestureEvent dge) ");
        DirFilePane.debugOutput(dragGestureEvent.toString());
        DirFilePane.debugOutput("-----------------------------------------------------------------------------\n");
        Vector vector = this.getSelectedListItemFile();
        if (vector.size() > 1) {
            return;
        }
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            string = string + ((ListItemFile)vector.elementAt(i)).getFullFilePath() + "\n";
        }
        dragGestureEvent.startDrag(DragSource.DefaultCopyDrop, new StringSelection(string), this);
        LTOOLSgui.myProg.copyListItemFiles();
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
        if (dropTargetContext.getComponent() == this.jTree) {
            int n;
            int n2 = (int)dropTargetDragEvent.getLocation().getX();
            if (this.jTree.getRowForLocation(n2, n = (int)dropTargetDragEvent.getLocation().getY()) != -1) {
                int n3 = this.jTree.getRowForLocation(n2, n);
                TreePath treePath = this.jTree.getPathForRow(n3);
                if (this.isLinux()) {
                    String string = this.getLdirPath(treePath);
                } else {
                    String string = this.getDOSLinuxPath(treePath);
                }
                if (!treePath.equals(LTOOLSgui.getCopyToDirectory())) {
                    LTOOLSgui.setCopyToDirectory(treePath);
                    DirFilePane.debugOutput("DragOver - LTOOLSgui.getCopyToDirectory(): " + LTOOLSgui.getCopyToDirectory());
                }
            }
        } else if (dropTargetContext.getComponent() == this.jTable) {
            LTOOLSgui.setCopyToDirectory(null);
        }
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    /*
     * Unable to fully structure code
     */
    public void drop(DropTargetDropEvent var1_1) {
        DirFilePane.debugOutput(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        DirFilePane.debugOutput("public void drop(DropTargetDropEvent dtde):");
        DirFilePane.debugOutput(var1_1.toString());
        try {
            var2_2 = DataFlavor.stringFlavor;
            var3_6 = var1_1.getTransferable();
            if (!this.isLinux()) ** GOTO lbl-1000
            if (LTOOLSgui.isLinuxReadOnly) {
                DirFilePane.debugOutput("linux is readonly - reject drop");
                var1_1.rejectDrop();
                var4_7 = "Your Linux filesystem is set to read only - change in menu 'File - Linux read only' first.";
                JOptionPane.showMessageDialog(LTOOLSgui.myProg, var4_7, "LTOOLS", 0);
            } else if (this.fileExists(LTOOLSgui.getCopyToDirectory())) {
                DirFilePane.debugOutput("file exists - reject drop");
                var1_1.rejectDrop();
                var4_8 = "A file with that name already exists in the target directory - delete or rename it first.";
                JOptionPane.showMessageDialog(LTOOLSgui.myProg, var4_8, "LTOOLS", 0);
            } else if (var1_1.isDataFlavorSupported(var2_2)) {
                DirFilePane.debugOutput((String)var3_6.getTransferData(var2_2));
                var1_1.acceptDrop(3);
                var4_9 = var1_1.getDropTargetContext();
                if (var4_9.getComponent() == this.jTree) {
                    DirFilePane.debugOutput("JTREE");
                    DirFilePane.debugOutput("dtde.getLocation(): " + var1_1.getLocation());
                    var5_10 = (int)var1_1.getLocation().getX();
                    var6_11 = (int)var1_1.getLocation().getY();
                    var7_12 = this.jTree.getRowForLocation(var5_10, var6_11);
                    if (var7_12 != -1) {
                        var8_13 = this.jTree.getPathForRow(var7_12);
                        if (this.isLinux()) {
                            var9_14 = this.getLdirPath(var8_13);
                            DirFilePane.debugOutput("PASTE TO LINUX");
                            LTOOLSgui.setActiveDirFilePane(LTOOLSgui.myProg.getLinuxFilePane());
                        } else {
                            var9_15 = this.getDOSLinuxPath(var8_13);
                            DirFilePane.debugOutput("PASTE TO DOS");
                            LTOOLSgui.setActiveDirFilePane(LTOOLSgui.myProg.getDOSFilePane());
                        }
                        LTOOLSgui.setCopyToDirectory(var8_13);
                        DirFilePane.debugOutput("copy file(s) to directory: \"" + LTOOLSgui.getCopyToDirectory() + "\"");
                        var1_1.dropComplete(true);
                        LTOOLSgui.myProg.pasteListItemFiles();
                    }
                } else if (var4_9.getComponent() == this.jTable) {
                    DirFilePane.debugOutput("JTABLE");
                    if (this.isLinux()) {
                        DirFilePane.debugOutput("PASTE TO LINUX");
                        LTOOLSgui.setActiveDirFilePane(LTOOLSgui.myProg.getLinuxFilePane());
                    } else {
                        DirFilePane.debugOutput("PASTE TO DOS");
                        LTOOLSgui.setActiveDirFilePane(LTOOLSgui.myProg.getDOSFilePane());
                    }
                    var1_1.dropComplete(true);
                    LTOOLSgui.myProg.pasteListItemFiles();
                } else {
                    DirFilePane.debugOutput("?????");
                }
                var1_1.dropComplete(true);
            } else {
                var1_1.rejectDrop();
            }
            LTOOLSgui.copyFileIsValid = false;
            LTOOLSgui.copyListItemFiles.removeAllElements();
        }
        catch (IOException var2_3) {
            var2_3.printStackTrace();
        }
        catch (UnsupportedFlavorException var2_4) {
            var2_4.printStackTrace();
        }
        catch (Exception var2_5) {
            var2_5.printStackTrace();
        }
        LTOOLSgui.setCopyToDirectory(null);
        DirFilePane.debugOutput("-----------------------------------------------------------------------------\n");
    }

    public boolean fileExists(TreePath treePath) {
        boolean bl = false;
        ListItemFile listItemFile = (ListItemFile)LTOOLSgui.copyListItemFiles.elementAt(0);
        if (treePath == null) {
            DirFilePane.debugOutput("path = null");
            treePath = this.getTreeSelectionPath();
            DirFilePane.debugOutput("path: " + treePath.toString());
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                ListItemFile listItemFile2 = this.tableModel.getListItemFile(i);
                if (!listItemFile.getFileName().equals(listItemFile2.getFileName())) continue;
                bl = true;
                break;
            }
        } else if (this.isLinux()) {
            String string = this.getDOSLinuxPath(treePath);
            String string2 = "ldir -x -s" + this.getLinuxDrive(string) + " \"" + this.getLinuxPath(string) + "\"";
            String string3 = this.execOperatingSystemCommand(string2, !LTOOLSgui.isConnected());
            if (!string3.startsWith("d") || !("" + string3.charAt(56)).equals(".")) {
                JOptionPane.showMessageDialog(LTOOLSgui.myProg, "ERROR: " + string3, "LTOOLSgui", 0);
                return false;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.length() <= 56) continue;
                String string5 = DirFilePane.getLdirField(string4, 9);
                if (!listItemFile.getFileName().equals(string5)) continue;
                bl = true;
                break;
            }
        } else {
            String string = this.getDOSLinuxPath(treePath);
            File file = new File(string);
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!listItemFile.getFileName().equals(stringArray[i])) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    static {
        ICON_COMPUTER = new ImageIcon(LTOOLSgui.class.getResource("images/computer.gif"));
        ICON_DRIVE_FIXED = new ImageIcon(LTOOLSgui.class.getResource("images/FIXED16x16.gif"));
        ICON_DRIVE_CDROM = new ImageIcon(LTOOLSgui.class.getResource("images/CDROM16x16.gif"));
        ICON_DRIVE_NOROOTDIR = new ImageIcon(LTOOLSgui.class.getResource("images/NOROOTDIR16x16.gif"));
        ICON_DRIVE_RAMDISK = new ImageIcon(LTOOLSgui.class.getResource("images/RAMDISK16x16.gif"));
        ICON_DRIVE_REMOTE = new ImageIcon(LTOOLSgui.class.getResource("images/REMOTE16x16.gif"));
        ICON_DRIVE_REMOVEABLE = new ImageIcon(LTOOLSgui.class.getResource("images/REMOVEABLE16x16.gif"));
        ICON_DRIVE_UNKNOWN = new ImageIcon(LTOOLSgui.class.getResource("images/UNKNOWN16x16.gif"));
        ICON_FOLDER = new ImageIcon(LTOOLSgui.class.getResource("images/FOLDER16x16.gif"));
        ICON_EXPANDEDFOLDER = new ImageIcon(LTOOLSgui.class.getResource("images/FOLDEROPENED16x16.gif"));
    }
}

