/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;

public class LTOOLSgui
extends JFrame {
    static final String VERSION = "V3.4";
    static boolean DEBUG = false;
    static boolean isApplet = false;
    static LTOOLSgui myProg;
    static String codeBase;
    static String lreadguiDirectory;
    static String tempPathLinuxFiles;
    static Vector copyListItemFiles;
    static boolean copyFileIsLinux;
    static boolean copyFileIsValid;
    static TreePath copyToDirectory;
    static Socket qSocket;
    static BufferedInputStream bReceive;
    static BufferedOutputStream bSend;
    static BufferedReader qReceive;
    static BufferedWriter qSend;
    static String hostname;
    static int port;
    static boolean connected;
    static boolean isLinuxReadOnly;
    static boolean confirmDelete;
    private static String dosFilePattern;
    private static String linuxFilePattern;
    private static DirFilePane activePane;
    private HelpBox helpBox = null;
    ImageIcon confirmIcon;
    ImageIcon confirmNotIcon;
    ImageIcon readOnlyIcon;
    ImageIcon readWriteIcon;
    ImageIcon connectIcon;
    ImageIcon disconnectIcon;
    boolean fComponentsAdjusted = false;
    JPanel toolbarJPanel = new JPanel();
    JToolBar mainJToolBar = new JToolBar();
    JButton newJButton = new JButton();
    JButton modifyJButton = new JButton();
    JButton deleteJButton = new JButton();
    JButton copyJButton = new JButton();
    JButton pasteJButton = new JButton();
    JButton partitionsJButton = new JButton();
    JButton helpJButton = new JButton();
    JButton aboutJButton = new JButton();
    JPanel centerJPanel = new JPanel();
    JSplitPane explorerJSplitPane = new JSplitPane();
    JPanel statusJPanel = new JPanel();
    JPanel JPanel1 = new JPanel();
    JButton remoteJButton = new JButton();
    JToggleButton readOnlyJToggleButton = new JToggleButton();
    JToggleButton confirmDeleteJToggleButton = new JToggleButton();
    JButton exitJButton = new JButton();
    JMenuBar mainJMenuBar = new JMenuBar();
    JMenu fileJMenu = new JMenu();
    JMenuItem remoteJMenuItem = new JMenuItem();
    JSeparator JSeparator1 = new JSeparator();
    JCheckBoxMenuItem linuxReadOnlyJCheckBoxMenuItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem confirmDeleteJCheckBoxMenuItem = new JCheckBoxMenuItem();
    JSeparator JSeparator2 = new JSeparator();
    JMenuItem dosPatternJMenuItem = new JMenuItem();
    JMenuItem linuxPatternJMenuItem = new JMenuItem();
    JSeparator JSeparator3 = new JSeparator();
    JMenuItem addDOSDriveJMenuItem = new JMenuItem();
    JMenuItem addLinuxDriveJMenuItem = new JMenuItem();
    JSeparator JSeparator4 = new JSeparator();
    JMenuItem exitJMenuItem = new JMenuItem();
    JMenu editJMenu = new JMenu();
    JMenuItem newJMenuItem = new JMenuItem();
    JMenuItem modifyJMenuItem = new JMenuItem();
    JMenuItem deleteJMenuItem = new JMenuItem();
    JMenuItem copyJMenuItem = new JMenuItem();
    JMenuItem pasteJMenuItem = new JMenuItem();
    JMenuItem viewJMenuItem = new JMenuItem();
    JMenu helpJMenu = new JMenu();
    JMenuItem partitionsJMenuItem = new JMenuItem();
    JSeparator JSeparator5 = new JSeparator();
    JMenuItem helpJMenuItem = new JMenuItem();
    JSeparator JSeparator6 = new JSeparator();
    JMenuItem aboutJMenuItem = new JMenuItem();
    DirFilePane dosPane;
    DirFilePane linuxPane;

    public LTOOLSgui() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(800, 600);
        this.setVisible(false);
        this.toolbarJPanel.setLayout(new GridLayout(1, 1, 0, 0));
        this.getContentPane().add("North", this.toolbarJPanel);
        this.toolbarJPanel.setBounds(0, 0, 800, 29);
        this.toolbarJPanel.add(this.mainJToolBar);
        this.mainJToolBar.setBounds(0, 0, 800, 29);
        this.newJButton.setDefaultCapable(false);
        this.newJButton.setToolTipText("Create a new directory");
        this.newJButton.setText("New");
        this.newJButton.setActionCommand("New");
        this.mainJToolBar.add(this.newJButton);
        this.newJButton.setBounds(16, 2, 59, 25);
        this.modifyJButton.setDefaultCapable(false);
        this.modifyJButton.setToolTipText("Change filenames and attributes");
        this.modifyJButton.setText("Modify");
        this.modifyJButton.setActionCommand("Modify");
        this.mainJToolBar.add(this.modifyJButton);
        this.modifyJButton.setBounds(75, 2, 71, 25);
        this.deleteJButton.setDefaultCapable(false);
        this.deleteJButton.setToolTipText("Delete a file or directory");
        this.deleteJButton.setText("Delete");
        this.deleteJButton.setActionCommand("Delete");
        this.mainJToolBar.add(this.deleteJButton);
        this.deleteJButton.setBounds(146, 2, 71, 25);
        this.copyJButton.setDefaultCapable(false);
        this.copyJButton.setToolTipText("Copy a file");
        this.copyJButton.setText("Copy");
        this.copyJButton.setActionCommand("Copy");
        this.mainJToolBar.add(this.copyJButton);
        this.copyJButton.setBounds(217, 2, 63, 25);
        this.pasteJButton.setDefaultCapable(false);
        this.pasteJButton.setToolTipText("Insert a file");
        this.pasteJButton.setText("Paste");
        this.pasteJButton.setActionCommand("Paste");
        this.mainJToolBar.add(this.pasteJButton);
        this.pasteJButton.setBounds(280, 2, 67, 25);
        this.partitionsJButton.setDefaultCapable(false);
        this.partitionsJButton.setToolTipText("Show Harddisk Partitions");
        this.partitionsJButton.setText("Partitions");
        this.partitionsJButton.setActionCommand("Partitions");
        this.mainJToolBar.add(this.partitionsJButton);
        this.partitionsJButton.setBounds(347, 2, 89, 25);
        this.helpJButton.setDefaultCapable(false);
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setText("Help");
        this.helpJButton.setActionCommand("Help");
        this.mainJToolBar.add(this.helpJButton);
        this.helpJButton.setBounds(436, 2, 59, 25);
        this.aboutJButton.setDefaultCapable(false);
        this.aboutJButton.setToolTipText("About");
        this.aboutJButton.setText("About");
        this.aboutJButton.setActionCommand("About");
        this.mainJToolBar.add(this.aboutJButton);
        this.aboutJButton.setBounds(495, 2, 67, 25);
        this.centerJPanel.setLayout(new BorderLayout(0, 0));
        this.getContentPane().add("Center", this.centerJPanel);
        this.centerJPanel.setBounds(0, 29, 800, 546);
        this.explorerJSplitPane.setOrientation(0);
        this.centerJPanel.add("Center", this.explorerJSplitPane);
        this.explorerJSplitPane.setBounds(0, 0, 800, 546);
        this.statusJPanel.setLayout(new BorderLayout(0, 0));
        this.getContentPane().add("South", this.statusJPanel);
        this.statusJPanel.setBounds(0, 575, 800, 25);
        this.JPanel1.setLayout(new GridLayout(1, 4, 0, 0));
        this.statusJPanel.add("Center", this.JPanel1);
        this.JPanel1.setBounds(0, 0, 800, 25);
        this.remoteJButton.setToolTipText("Connect to a remote host (host must be running LREADjav)");
        this.remoteJButton.setText("Connect");
        this.remoteJButton.setActionCommand("Connect");
        this.JPanel1.add(this.remoteJButton);
        this.remoteJButton.setBounds(0, 0, 200, 25);
        this.readOnlyJToggleButton.setToolTipText("Sets the Linux-partitions to \"read only\" or \"writeable\"");
        this.readOnlyJToggleButton.setText("Read Only");
        this.readOnlyJToggleButton.setActionCommand("Read Only");
        this.JPanel1.add(this.readOnlyJToggleButton);
        this.readOnlyJToggleButton.setBounds(200, 0, 200, 25);
        this.confirmDeleteJToggleButton.setToolTipText("Show a confirm-dialog or not");
        this.confirmDeleteJToggleButton.setText("Confirm Delete");
        this.confirmDeleteJToggleButton.setActionCommand("Confirm Delete");
        this.JPanel1.add(this.confirmDeleteJToggleButton);
        this.confirmDeleteJToggleButton.setBounds(400, 0, 200, 25);
        this.exitJButton.setToolTipText("Press to close LTOOLSgui");
        this.exitJButton.setText("Exit");
        this.exitJButton.setActionCommand("Exit");
        this.JPanel1.add(this.exitJButton);
        this.exitJButton.setBounds(600, 0, 200, 25);
        this.fileJMenu.setText("File");
        this.fileJMenu.setActionCommand("File");
        this.mainJMenuBar.add(this.fileJMenu);
        this.remoteJMenuItem.setText("Remote Connect");
        this.remoteJMenuItem.setActionCommand("Remote Connect");
        this.fileJMenu.add(this.remoteJMenuItem);
        this.fileJMenu.add(this.JSeparator1);
        this.linuxReadOnlyJCheckBoxMenuItem.setSelected(true);
        this.linuxReadOnlyJCheckBoxMenuItem.setText("Linux Read Only");
        this.linuxReadOnlyJCheckBoxMenuItem.setActionCommand("Linux Read Only");
        this.fileJMenu.add(this.linuxReadOnlyJCheckBoxMenuItem);
        this.confirmDeleteJCheckBoxMenuItem.setSelected(true);
        this.confirmDeleteJCheckBoxMenuItem.setText("Confirm Delete");
        this.confirmDeleteJCheckBoxMenuItem.setActionCommand("Confirm Delete");
        this.fileJMenu.add(this.confirmDeleteJCheckBoxMenuItem);
        this.fileJMenu.add(this.JSeparator2);
        this.dosPatternJMenuItem.setText("DOS Pattern ...");
        this.dosPatternJMenuItem.setActionCommand("DOS Pattern ...");
        this.fileJMenu.add(this.dosPatternJMenuItem);
        this.linuxPatternJMenuItem.setText("Linux Pattern ...");
        this.linuxPatternJMenuItem.setActionCommand("Linux Pattern ...");
        this.fileJMenu.add(this.linuxPatternJMenuItem);
        this.fileJMenu.add(this.JSeparator3);
        this.addDOSDriveJMenuItem.setText("Add DOS Drive ...");
        this.addDOSDriveJMenuItem.setActionCommand("Add DOS Drive ...");
        this.fileJMenu.add(this.addDOSDriveJMenuItem);
        this.addLinuxDriveJMenuItem.setText("Add Linux Drive ...");
        this.addLinuxDriveJMenuItem.setActionCommand("Add Linux Drive ...");
        this.fileJMenu.add(this.addLinuxDriveJMenuItem);
        this.fileJMenu.add(this.JSeparator4);
        this.exitJMenuItem.setText("Exit");
        this.exitJMenuItem.setActionCommand("Exit");
        this.fileJMenu.add(this.exitJMenuItem);
        this.editJMenu.setText("Edit");
        this.editJMenu.setActionCommand("Edit");
        this.mainJMenuBar.add(this.editJMenu);
        this.newJMenuItem.setText("New");
        this.newJMenuItem.setActionCommand("New");
        this.editJMenu.add(this.newJMenuItem);
        this.modifyJMenuItem.setText("Modify");
        this.modifyJMenuItem.setActionCommand("Modify");
        this.editJMenu.add(this.modifyJMenuItem);
        this.deleteJMenuItem.setText("Delete");
        this.deleteJMenuItem.setActionCommand("Delete");
        this.editJMenu.add(this.deleteJMenuItem);
        this.copyJMenuItem.setText("Copy");
        this.copyJMenuItem.setActionCommand("Copy");
        this.editJMenu.add(this.copyJMenuItem);
        this.pasteJMenuItem.setText("Paste");
        this.pasteJMenuItem.setActionCommand("Paste");
        this.editJMenu.add(this.pasteJMenuItem);
        this.viewJMenuItem.setText("View");
        this.viewJMenuItem.setActionCommand("View");
        this.editJMenu.add(this.viewJMenuItem);
        this.helpJMenu.setText("Help");
        this.helpJMenu.setActionCommand("Help");
        this.mainJMenuBar.add(this.helpJMenu);
        this.partitionsJMenuItem.setText("Show Harddisk Partitions");
        this.partitionsJMenuItem.setActionCommand("Show Harddisk Partitions");
        this.helpJMenu.add(this.partitionsJMenuItem);
        this.helpJMenu.add(this.JSeparator5);
        this.helpJMenuItem.setText("Help ...");
        this.helpJMenuItem.setActionCommand("Help ...");
        this.helpJMenu.add(this.helpJMenuItem);
        this.helpJMenu.add(this.JSeparator6);
        this.aboutJMenuItem.setText("About");
        this.aboutJMenuItem.setActionCommand("About");
        this.helpJMenu.add(this.aboutJMenuItem);
        this.setTitle("A Simple Frame");
        this.setJMenuBar(this.mainJMenuBar);
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        SymAction symAction = new SymAction();
        this.newJButton.addActionListener(symAction);
        this.modifyJButton.addActionListener(symAction);
        this.deleteJButton.addActionListener(symAction);
        this.copyJButton.addActionListener(symAction);
        this.pasteJButton.addActionListener(symAction);
        this.partitionsJButton.addActionListener(symAction);
        this.helpJButton.addActionListener(symAction);
        this.aboutJButton.addActionListener(symAction);
        this.remoteJMenuItem.addActionListener(symAction);
        this.linuxReadOnlyJCheckBoxMenuItem.addActionListener(symAction);
        this.confirmDeleteJCheckBoxMenuItem.addActionListener(symAction);
        this.dosPatternJMenuItem.addActionListener(symAction);
        this.linuxPatternJMenuItem.addActionListener(symAction);
        this.addDOSDriveJMenuItem.addActionListener(symAction);
        this.addLinuxDriveJMenuItem.addActionListener(symAction);
        this.exitJMenuItem.addActionListener(symAction);
        this.newJMenuItem.addActionListener(symAction);
        this.modifyJMenuItem.addActionListener(symAction);
        this.deleteJMenuItem.addActionListener(symAction);
        this.copyJMenuItem.addActionListener(symAction);
        this.pasteJMenuItem.addActionListener(symAction);
        this.viewJMenuItem.addActionListener(symAction);
        this.partitionsJMenuItem.addActionListener(symAction);
        this.helpJMenuItem.addActionListener(symAction);
        this.aboutJMenuItem.addActionListener(symAction);
        this.remoteJButton.addActionListener(symAction);
        this.readOnlyJToggleButton.addActionListener(symAction);
        this.confirmDeleteJToggleButton.addActionListener(symAction);
        this.exitJButton.addActionListener(symAction);
        this.mainJToolBar.setLayout(new GridLayout(1, 8, 0, 0));
        this.setTitle("LTOOLSgui " + VERSION + " Werner.Zimmermann@fht-esslingen.de");
        this.newJButton.setIcon(new ImageIcon("images/new.gif"));
        this.modifyJButton.setIcon(new ImageIcon("images/modify.gif"));
        this.deleteJButton.setIcon(new ImageIcon("images/cut.gif"));
        this.copyJButton.setIcon(new ImageIcon("images/copy.gif"));
        this.pasteJButton.setIcon(new ImageIcon("images/paste.gif"));
        this.helpJButton.setIcon(new ImageIcon("images/help16x16.gif"));
        this.partitionsJButton.setIcon(new ImageIcon("images/partitions16x16.gif"));
        this.aboutJButton.setIcon(new ImageIcon("images/info16x16.gif"));
        this.dosPane = new DirFilePane(false);
        this.linuxPane = new DirFilePane(true);
        this.explorerJSplitPane.setTopComponent(this.dosPane);
        this.explorerJSplitPane.setBottomComponent(this.linuxPane);
        this.explorerJSplitPane.setDividerLocation(0.5);
        isLinuxReadOnly = this.linuxReadOnlyJCheckBoxMenuItem.isSelected();
        confirmDelete = this.confirmDeleteJCheckBoxMenuItem.isSelected();
        if (isApplet) {
            this.exitJButton.setEnabled(false);
            this.exitJMenuItem.setEnabled(false);
        }
        this.setIconImage(this.getToolkit().getImage("./images/app.gif"));
        this.readOnlyJToggleButton.setSelected(isLinuxReadOnly);
        this.confirmIcon = new ImageIcon("images/confirm16x16.gif");
        this.confirmNotIcon = new ImageIcon("images/confirmnot16x16.gif");
        this.setConfirmDeleteView();
        this.readOnlyIcon = new ImageIcon("images/readonly16x16.gif");
        this.readWriteIcon = new ImageIcon("images/readwrite16x16.gif");
        this.setReadOnlyView();
        this.connectIcon = new ImageIcon("images/connect16x16.gif");
        this.disconnectIcon = new ImageIcon("images/disconnect16x16.gif");
        this.remoteJButton.setIcon(this.connectIcon);
        this.exitJButton.setIcon(new ImageIcon("images/exit16x16.gif"));
    }

    public LTOOLSgui(String string) {
        this();
        this.setTitle(string);
    }

    public static void main(String[] stringArray) {
        LTOOLSgui.showSplash(2000);
        boolean bl = false;
        try {
            File file;
            if (stringArray.length > 0) {
                if (stringArray[0].startsWith("-h") || stringArray[0].startsWith("-?")) {
                    System.out.println("LTOOLS Graphical User Interface " + VERSION + "\n(C) 1999-2006 Werner.Zimmermann@fht-esslingen.de\n\n" + "Usage:  LTOOLSgui [-d] [Linux_drive [DOS_drive]]\n" + "Note:   Java 1.2 or newer needed\n" + "        set DOS_drive to \"\" if running LTOOLSgui on a UNIX host\n\n");
                    System.exit(0);
                }
                if (stringArray[0].startsWith("-d")) {
                    DEBUG = true;
                    bl = true;
                }
            }
            if (!(file = new File(tempPathLinuxFiles = (lreadguiDirectory = isApplet ? LTOOLSapplet.ltoolappletCodeBase : System.getProperty("user.dir") + File.separator) + "temp" + File.separator)).exists()) {
                file.mkdir();
            }
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                System.out.println("Using " + UIManager.getSystemLookAndFeelClassName() + "\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("LTOOLSgui V3.4 (C) 1999-2006 Werner.Zimmermann@fht-esslingen.de\nOperating System: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version") + "\n" + "Java VM         : " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + "\n");
            LTOOLSgui.debugOutput("\n--------------------------------------------------------------------------------------------");
            LTOOLSgui.debugOutput("tempPathLinuxFiles: " + tempPathLinuxFiles);
            LTOOLSgui.debugOutput("\n--------------------------------------------------------------------------------------------");
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            myProg = new LTOOLSgui();
            int n = myProg.getWidth();
            int n2 = myProg.getHeight();
            int n3 = (dimension.width - n) / 2;
            int n4 = (dimension.height - n2) / 2;
            myProg.setBounds(n3, n4, n, n2);
            myProg.setVisible(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getContentPane().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    void LTOOLSGui_WindowClosing(WindowEvent windowEvent) {
        this.exitApplication();
    }

    void newJButton_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("newButtonAction");
        this.newJMenuItem_actionPerformed(actionEvent);
    }

    void modifyJButton_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("ModifyButtonAction");
        this.modifyJMenuItem_actionPerformed(actionEvent);
    }

    void deleteJButton_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("delButtonAction");
        this.deleteJMenuItem_actionPerformed(actionEvent);
    }

    void copyJButton_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("copyButtonAction");
        this.copyJMenuItem_actionPerformed(actionEvent);
    }

    void pasteJButton_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("pasteButtonAction");
        this.pasteJMenuItem_actionPerformed(actionEvent);
    }

    void partitionsJButton_actionPerformed(ActionEvent actionEvent) {
        this.partitionsJMenuItem_actionPerformed(actionEvent);
    }

    void helpJButton_actionPerformed(ActionEvent actionEvent) {
        this.helpJMenuItem_actionPerformed(actionEvent);
    }

    void remoteJButton_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("RemoteButton_Action");
        this.remoteJMenuItem_actionPerformed(actionEvent);
    }

    void aboutJButton_actionPerformed(ActionEvent actionEvent) {
        this.aboutJMenuItem_actionPerformed(actionEvent);
    }

    void remoteJMenuItem_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("RemoteMenuItem_Action");
        if (LTOOLSgui.isConnected()) {
            LTOOLSgui.connectionClose();
            if (!LTOOLSgui.isConnected()) {
                this.remoteJMenuItem.setText("Remote connect");
                this.remoteJButton.setIcon(this.connectIcon);
                this.remoteJButton.setText("Connect");
                this.linuxPane.fillLinuxDirectoryTree();
                this.linuxPane.setBackgroundTreeTable(this.dosPane.getJTable().getBackground());
            }
        } else {
            RemoteBoxDialog remoteBoxDialog = new RemoteBoxDialog((Frame)this, hostname, "" + port);
            remoteBoxDialog.setVisible(true);
            if (remoteBoxDialog.getStatus() == 0) {
                return;
            }
            hostname = remoteBoxDialog.getHostName();
            port = remoteBoxDialog.getPortNumber();
            LTOOLSgui.connectionOpen();
            if (LTOOLSgui.isConnected()) {
                this.remoteJMenuItem.setText("Remote disconnect");
                this.remoteJButton.setIcon(this.disconnectIcon);
                this.remoteJButton.setText("Disconnect");
                this.linuxPane.fillLinuxDirectoryTree();
                this.linuxPane.setBackgroundTreeTable(new Color(240, 248, 255));
            }
        }
    }

    void linuxReadOnlyJCheckBoxMenuItem_actionPerformed(ActionEvent actionEvent) {
        isLinuxReadOnly = this.linuxReadOnlyJCheckBoxMenuItem.isSelected();
        this.setReadOnlyView();
    }

    void confirmDeleteJCheckBoxMenuItem_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("confirmDelete - MenuItem");
        confirmDelete = this.confirmDeleteJCheckBoxMenuItem.isSelected();
        this.setConfirmDeleteView();
    }

    void dosPatternJMenuItem_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("DOS Pattern MenuItem");
        FilePatternDialog filePatternDialog = new FilePatternDialog((Frame)this, true, dosFilePattern, false);
        filePatternDialog.show();
        LTOOLSgui.debugOutput("Status: " + filePatternDialog.getStatus() + "\nPattern: " + filePatternDialog.getFilePattern());
        if (filePatternDialog.getStatus()) {
            dosFilePattern = filePatternDialog.getFilePattern();
            this.dosPane.updateDOSJTable(this.dosPane.getTreeNode(this.dosPane.getTreeSelectionPath()));
        }
    }

    void linuxPatternJMenuItem_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("Linux Pattern MenuItem");
        FilePatternDialog filePatternDialog = new FilePatternDialog((Frame)this, true, linuxFilePattern, true);
        filePatternDialog.show();
        LTOOLSgui.debugOutput("Status: " + filePatternDialog.getStatus() + "\nPattern: " + filePatternDialog.getFilePattern());
        if (filePatternDialog.getStatus()) {
            linuxFilePattern = filePatternDialog.getFilePattern();
            this.linuxPane.updateLinuxJTable(this.linuxPane.getTreeNode(this.linuxPane.getTreeSelectionPath()));
        }
    }

    void addDOSDriveJMenuItem_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("add DOS Drive");
        this.dosPane.addDrive();
    }

    void addLinuxDriveJMenuItem_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("add Linux Drive");
        this.linuxPane.addDrive();
    }

    void exitJMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.exitApplication();
    }

    void newJMenuItem_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("newItemAction");
        String string = "LTOOLS";
        String string2 = "Select directory where to add the new item.";
        if (activePane == this.dosPane) {
            if (this.dosPane.getTreeSelectionPath() != null) {
                this.dosPane.newDosDirectory(this.dosPane.getTreeSelectionPath());
            } else {
                LTOOLSgui.beepSound();
                JOptionPane.showMessageDialog(this, string2, string, 0);
            }
        } else if (activePane == this.linuxPane) {
            if (this.linuxPane.getTreeSelectionPath() != null) {
                this.linuxPane.newLinuxDirectory(this.linuxPane.getTreeSelectionPath());
            } else {
                LTOOLSgui.beepSound();
                JOptionPane.showMessageDialog(this, string2, string, 0);
            }
        } else {
            LTOOLSgui.beepSound();
            JOptionPane.showMessageDialog(this, string2, string, 0);
        }
    }

    void modifyJMenuItem_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("modifyItemAction");
        this.modifyListItemFiles();
    }

    public void modifyListItemFiles() {
        String string = "LTOOLS";
        if (LTOOLSgui.getActiveDirFilePane() == this.dosPane) {
            Vector vector = this.dosPane.getSelectedListItemFile();
            for (int i = 0; i < vector.size(); ++i) {
                ListItemFile listItemFile = (ListItemFile)vector.elementAt(i);
                if (listItemFile.getFileName().equals("..")) continue;
                this.dosPane.modifyDosFile(listItemFile);
            }
            this.dosPane.updateDOSJTable(this.dosPane.getTreeNode(this.dosPane.getJTree().getSelectionPath()));
        } else if (LTOOLSgui.getActiveDirFilePane() == this.linuxPane) {
            Vector vector = this.linuxPane.getSelectedListItemFile();
            for (int i = 0; i < vector.size(); ++i) {
                ListItemFile listItemFile = (ListItemFile)vector.elementAt(i);
                if (listItemFile.getFileName().equals("..")) continue;
                this.linuxPane.modifyLinuxFile(listItemFile);
            }
            this.linuxPane.updateLinuxJTable(this.linuxPane.getTreeNode(this.linuxPane.getJTree().getSelectionPath()));
        } else {
            LTOOLSgui.beepSound();
            String string2 = "Select directory or file to modify.";
            JOptionPane.showMessageDialog(this, string2, string, 0);
        }
    }

    public void viewListItemFiles() {
        String string = "LTOOLS";
        if (LTOOLSgui.getActiveDirFilePane() == this.dosPane) {
            Vector vector = this.dosPane.getSelectedListItemFile();
            for (int i = 0; i < vector.size(); ++i) {
                ListItemFile listItemFile = (ListItemFile)vector.elementAt(i);
                if (listItemFile.getFileName().equals("..")) continue;
                this.dosPane.startDosApplication(listItemFile, false);
            }
        } else if (LTOOLSgui.getActiveDirFilePane() == this.linuxPane) {
            Vector vector = this.linuxPane.getSelectedListItemFile();
            for (int i = 0; i < vector.size(); ++i) {
                ListItemFile listItemFile = (ListItemFile)vector.elementAt(i);
                if (listItemFile.getFileName().equals("..")) continue;
                this.linuxPane.startLinuxApplication(listItemFile, false);
            }
        } else {
            LTOOLSgui.beepSound();
            String string2 = "Select directory or file to modify.";
            JOptionPane.showMessageDialog(this, string2, string, 0);
        }
    }

    void deleteJMenuItem_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("delItemAction");
        this.deleteListItemFiles();
    }

    void copyJMenuItem_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("copyItemAction");
        this.copyListItemFiles();
    }

    void pasteJMenuItem_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("pasteItemAction");
        this.pasteListItemFiles();
    }

    void viewJMenuItem_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("pasteItemAction");
        this.viewListItemFiles();
    }

    void partitionsJMenuItem_actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2 = this.linuxPane.showPartitions();
        if (LTOOLSgui.isConnected()) {
            string = "LTOOLS Partitions - " + hostname;
        } else {
            try {
                if (!File.separator.equals("\\")) {
                    string2 = string2 + "\n\n\nSorry, 'ldir -part' only works under DOS/Windows - use 'fdisk' instead";
                }
                string = "LTOOLS Partitions - " + InetAddress.getLocalHost();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string = "LTOOLS Partitions";
            }
        }
        PartitionsFrame partitionsFrame = new PartitionsFrame((Frame)this, true, string2, string);
        partitionsFrame.show();
    }

    void helpJMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (this.helpBox == null) {
            this.helpBox = new HelpBox((Frame)this, false, "file:" + lreadguiDirectory);
            this.helpBox.setVisible(true);
        } else {
            this.helpBox.setVisible(true);
        }
    }

    void aboutJMenuItem_actionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, "LTOOLSgui  " + VERSION + " 1999-2006 Werner.Zimmermann@fht-esslingen.de\nOperating System: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version") + "\n" + "Java VM: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + "\n\n" + "Using\n" + this.linuxPane.execOperatingSystemCommand("ldir -x -v", false).replace('\r', ' ').substring(2), "LTOOLS", 1);
    }

    void readOnlyJToggleButton_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("ReadOnly ToggleButton");
        isLinuxReadOnly = this.readOnlyJToggleButton.isSelected();
        this.setReadOnlyView();
    }

    void confirmDeleteJToggleButton_actionPerformed(ActionEvent actionEvent) {
        LTOOLSgui.debugOutput("ConfirmDelete ToggleButton");
        confirmDelete = !confirmDelete;
        this.setConfirmDeleteView();
    }

    void exitJButton_actionPerformed(ActionEvent actionEvent) {
        this.exitApplication();
    }

    void exitApplication() {
        try {
            LTOOLSgui.beepSound();
            int n = JOptionPane.showConfirmDialog(this, "Do you really want to exit?", "LTOOLSgui - Exit", 0, 3);
            if (n == 0) {
                File file;
                File file2 = new File("ZZZ.ZWZ");
                if (file2.exists()) {
                    file2.delete();
                }
                File file3 = new File("zzz.tmp");
                if (file2.exists()) {
                    file3.delete();
                }
                if ((file = new File(tempPathLinuxFiles)).exists()) {
                    File[] fileArray = file.listFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        if (fileArray[i].delete()) {
                            LTOOLSgui.debugOutput("File \"" + fileArray[i].toString() + "\" deleted.");
                            continue;
                        }
                        LTOOLSgui.debugOutput("ERROR deleting File \"" + fileArray[i].toString() + "\".");
                    }
                }
                if (LTOOLSgui.isConnected()) {
                    LTOOLSgui.connectionClose();
                }
                this.setVisible(false);
                this.dispose();
                System.exit(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void debugOutput(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public static boolean getDebug() {
        return DEBUG;
    }

    static void connectionOpen() {
        LTOOLSgui.debugOutput("Started openConnection()");
        try {
            qSocket = new Socket(hostname, port);
            qReceive = new BufferedReader(new InputStreamReader(qSocket.getInputStream()));
            bReceive = new BufferedInputStream(qSocket.getInputStream());
            qSend = new BufferedWriter(new OutputStreamWriter(qSocket.getOutputStream()));
            bSend = new BufferedOutputStream(qSocket.getOutputStream());
            if (qSocket != null && qReceive != null && qSend != null) {
                connected = true;
                LTOOLSgui.debugOutput("Client connected to server");
            } else {
                LTOOLSgui.debugOutput("Client connect to server failed");
                connected = false;
                LTOOLSgui.beepSound();
                JOptionPane.showMessageDialog(myProg, "Client connect to server failed", "LTOOLS", 0);
            }
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Unknown host " + unknownHostException);
            LTOOLSgui.beepSound();
            JOptionPane.showMessageDialog(myProg, "Unknown hostname \"" + hostname, "LTOOLS", 0);
        }
        catch (IOException iOException) {
            System.err.println("Failed I/O to " + iOException);
            LTOOLSgui.beepSound();
            JOptionPane.showMessageDialog(myProg, "Client connect to server failed: " + iOException, "LTOOLS", 0);
        }
    }

    static void connectionClose() {
        LTOOLSgui.debugOutput("Started closeConnection()");
        if (!LTOOLSgui.isConnected()) {
            return;
        }
        try {
            if (qSend != null) {
                qSend.write("ESC", 0, 3);
                qSend.close();
                bSend.close();
                qSend = null;
            }
            if (qReceive != null) {
                qReceive.close();
                bReceive.close();
                qReceive = null;
            }
            if (qSocket != null) {
                qSocket.close();
                qSocket = null;
            }
            connected = false;
            LTOOLSgui.debugOutput("Connection closed");
        }
        catch (IOException iOException) {
            System.err.println("Failed I/O to " + iOException);
            connected = false;
        }
    }

    public static boolean isConnected() {
        return connected;
    }

    public static void showSplash(int n) {
        JWindow jWindow = new JWindow();
        JPanel jPanel = (JPanel)jWindow.getContentPane();
        int n2 = 320;
        int n3 = 240;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n4 = (dimension.width - n2) / 2;
        int n5 = (dimension.height - n3) / 2;
        jWindow.setBounds(n4, n5, n2, n3);
        JLabel jLabel = new JLabel(new ImageIcon("images/SplashScreen.gif"));
        JLabel jLabel2 = new JLabel("LTOOLSgui V3.4 (C) 1999-2006", 0);
        jLabel2.setFont(new Font("Sans-Serif", 1, 12));
        jPanel.add((Component)jLabel, "Center");
        jPanel.add((Component)jLabel2, "South");
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        jWindow.setVisible(true);
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        jWindow.setVisible(false);
    }

    public static String getDosFilePattern() {
        return dosFilePattern;
    }

    public static void setDosFilePattern(String string) {
        dosFilePattern = string;
    }

    public static String getLinuxFilePattern() {
        return linuxFilePattern;
    }

    public static void setLinuxFilePattern(String string) {
        linuxFilePattern = string;
    }

    public static void setActiveDirFilePane(DirFilePane dirFilePane) {
        activePane = dirFilePane;
    }

    public static DirFilePane getActiveDirFilePane() {
        return activePane;
    }

    public DirFilePane getDOSFilePane() {
        return this.dosPane;
    }

    public DirFilePane getLinuxFilePane() {
        return this.linuxPane;
    }

    public void deleteListItemFiles() {
        String string = "LTOOLS";
        if (LTOOLSgui.getActiveDirFilePane() == this.dosPane) {
            Vector vector = this.dosPane.getSelectedListItemFile();
            for (int i = 0; i < vector.size(); ++i) {
                ListItemFile listItemFile = (ListItemFile)vector.elementAt(i);
                if (listItemFile.getFileName().equals("..")) continue;
                this.dosPane.deleteDosFile(listItemFile);
            }
            this.dosPane.updateDOSJTable(this.dosPane.getTreeNode(this.dosPane.getJTree().getSelectionPath()));
            this.dosPane.updateTreeNode(this.dosPane.getJTree().getSelectionPath());
        } else if (LTOOLSgui.getActiveDirFilePane() == this.linuxPane) {
            if (isLinuxReadOnly) {
                LTOOLSgui.beepSound();
                String string2 = "Your Linux filesystem is set to read only - change in menu 'File - Linux read only' first.";
                JOptionPane.showMessageDialog(myProg, string2, "LTOOLS", 0);
                return;
            }
            Vector vector = this.linuxPane.getSelectedListItemFile();
            for (int i = 0; i < vector.size(); ++i) {
                ListItemFile listItemFile = (ListItemFile)vector.elementAt(i);
                if (listItemFile.getFileName().equals("..")) continue;
                this.linuxPane.deleteLinuxFile(listItemFile);
            }
            this.linuxPane.updateLinuxJTable(this.linuxPane.getTreeNode(this.linuxPane.getJTree().getSelectionPath()));
            this.linuxPane.updateTreeNode(this.linuxPane.getJTree().getSelectionPath());
        } else {
            LTOOLSgui.beepSound();
            String string3 = "Select directory or file to delete.";
            JOptionPane.showMessageDialog(this, string3, string, 0);
        }
        confirmDelete = true;
        this.setConfirmDeleteView();
    }

    public static void setCopyToDirectory(TreePath treePath) {
        copyToDirectory = treePath;
    }

    public static TreePath getCopyToDirectory() {
        return copyToDirectory;
    }

    public void copyListItemFiles() {
        String string = "LTOOLS";
        LTOOLSgui.setCopyToDirectory(null);
        if (LTOOLSgui.getActiveDirFilePane() == this.dosPane) {
            copyListItemFiles.removeAllElements();
            copyListItemFiles = this.dosPane.getSelectedListItemFile();
            copyFileIsLinux = false;
            copyFileIsValid = true;
            for (int i = 0; i < copyListItemFiles.size(); ++i) {
                String string2;
                if (((ListItemFile)copyListItemFiles.elementAt(i)).isDirectory()) {
                    LTOOLSgui.beepSound();
                    copyFileIsValid = false;
                    string2 = "Sorry, directories cannot be copied.";
                    JOptionPane.showMessageDialog(myProg, string2, string, 0);
                } else if (((ListItemFile)copyListItemFiles.elementAt(i)).isError()) {
                    LTOOLSgui.beepSound();
                    copyFileIsValid = false;
                    string2 = "Sorry, errormessages cannot be copied.";
                    JOptionPane.showMessageDialog(myProg, string2, string, 0);
                }
                LTOOLSgui.debugOutput("item to copy: " + ((ListItemFile)copyListItemFiles.elementAt(i)).getFullFilePath());
                if (copyFileIsValid) continue;
                copyListItemFiles.removeAllElements();
                return;
            }
        } else if (LTOOLSgui.getActiveDirFilePane() == this.linuxPane) {
            copyListItemFiles.removeAllElements();
            copyListItemFiles = this.linuxPane.getSelectedListItemFile();
            copyFileIsLinux = true;
            copyFileIsValid = true;
            for (int i = 0; i < copyListItemFiles.size(); ++i) {
                String string3;
                if (((ListItemFile)copyListItemFiles.elementAt(i)).isDirectory()) {
                    LTOOLSgui.beepSound();
                    copyFileIsValid = false;
                    string3 = "Sorry, directories cannot be copied";
                    JOptionPane.showMessageDialog(myProg, string3, string, 0);
                } else if (((ListItemFile)copyListItemFiles.elementAt(i)).isError()) {
                    LTOOLSgui.beepSound();
                    copyFileIsValid = false;
                    string3 = "Sorry, errormessages cannot be copied";
                    JOptionPane.showMessageDialog(myProg, string3, string, 0);
                } else if (((ListItemFile)copyListItemFiles.elementAt(i)).isLink()) {
                    LTOOLSgui.beepSound();
                    copyFileIsValid = false;
                    string3 = "Sorry, links cannot be copied.";
                    JOptionPane.showMessageDialog(myProg, string3, string, 0);
                }
                LTOOLSgui.debugOutput("item to copy: " + ((ListItemFile)copyListItemFiles.elementAt(i)).getFullFilePath());
                if (copyFileIsValid) continue;
                copyListItemFiles.removeAllElements();
                return;
            }
        } else {
            LTOOLSgui.beepSound();
            JOptionPane.showMessageDialog(this, "Select file to copy.", string, 0);
        }
    }

    public void pasteListItemFiles() {
        LTOOLSgui.debugOutput("pasteListItemFiles()");
        String string = "LTOOLS";
        if (!copyFileIsValid) {
            LTOOLSgui.beepSound();
            String string2 = "You must copy a file before you can paste it.";
            JOptionPane.showMessageDialog(this, string2, string, 0);
            return;
        }
        if (LTOOLSgui.getActiveDirFilePane() == this.dosPane) {
            LTOOLSgui.debugOutput("paste files to dos.");
            this.dosPane.pasteToDos(true);
        } else if (LTOOLSgui.getActiveDirFilePane() == this.linuxPane) {
            LTOOLSgui.debugOutput("paste files to linux.");
            this.linuxPane.pasteToLinux(true);
        } else {
            LTOOLSgui.beepSound();
            String string3 = "Select directory to paste in.";
            JOptionPane.showMessageDialog(this, string3, string, 0);
        }
        LTOOLSgui.setCopyToDirectory(null);
    }

    private void setConfirmDeleteView() {
        if (confirmDelete) {
            this.confirmDeleteJToggleButton.setIcon(this.confirmIcon);
            this.confirmDeleteJToggleButton.setText("Confirm");
        } else {
            this.confirmDeleteJToggleButton.setIcon(this.confirmNotIcon);
            this.confirmDeleteJToggleButton.setText("No Confirm");
        }
        this.confirmDeleteJToggleButton.setSelected(confirmDelete);
        this.confirmDeleteJCheckBoxMenuItem.setSelected(confirmDelete);
    }

    private void setReadOnlyView() {
        if (isLinuxReadOnly) {
            this.readOnlyJToggleButton.setIcon(this.readOnlyIcon);
            this.readOnlyJToggleButton.setText("Linux Read Only");
        } else {
            this.readOnlyJToggleButton.setIcon(this.readWriteIcon);
            this.readOnlyJToggleButton.setText("ReadWrite");
        }
        this.linuxReadOnlyJCheckBoxMenuItem.setSelected(isLinuxReadOnly);
        this.readOnlyJToggleButton.setSelected(isLinuxReadOnly);
    }

    public static void beepSound() {
        Toolkit.getDefaultToolkit().beep();
    }

    static {
        codeBase = "";
        copyListItemFiles = new Vector();
        copyFileIsLinux = false;
        copyFileIsValid = false;
        copyToDirectory = null;
        qSocket = null;
        bReceive = null;
        bSend = null;
        qReceive = null;
        qSend = null;
        hostname = "localhost";
        port = 1605;
        connected = false;
        dosFilePattern = "*";
        linuxFilePattern = "*";
        activePane = null;
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == LTOOLSgui.this.newJButton) {
                LTOOLSgui.this.newJButton_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.modifyJButton) {
                LTOOLSgui.this.modifyJButton_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.deleteJButton) {
                LTOOLSgui.this.deleteJButton_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.copyJButton) {
                LTOOLSgui.this.copyJButton_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.pasteJButton) {
                LTOOLSgui.this.pasteJButton_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.partitionsJButton) {
                LTOOLSgui.this.partitionsJButton_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.helpJButton) {
                LTOOLSgui.this.helpJButton_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.aboutJButton) {
                LTOOLSgui.this.aboutJButton_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.remoteJMenuItem) {
                LTOOLSgui.this.remoteJMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.linuxReadOnlyJCheckBoxMenuItem) {
                LTOOLSgui.this.linuxReadOnlyJCheckBoxMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.confirmDeleteJCheckBoxMenuItem) {
                LTOOLSgui.this.confirmDeleteJCheckBoxMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.dosPatternJMenuItem) {
                LTOOLSgui.this.dosPatternJMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.linuxPatternJMenuItem) {
                LTOOLSgui.this.linuxPatternJMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.addDOSDriveJMenuItem) {
                LTOOLSgui.this.addDOSDriveJMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.addLinuxDriveJMenuItem) {
                LTOOLSgui.this.addLinuxDriveJMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.exitJMenuItem) {
                LTOOLSgui.this.exitJMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.newJMenuItem) {
                LTOOLSgui.this.newJMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.modifyJMenuItem) {
                LTOOLSgui.this.modifyJMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.deleteJMenuItem) {
                LTOOLSgui.this.deleteJMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.copyJMenuItem) {
                LTOOLSgui.this.copyJMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.pasteJMenuItem) {
                LTOOLSgui.this.pasteJMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.viewJMenuItem) {
                LTOOLSgui.this.viewJMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.partitionsJMenuItem) {
                LTOOLSgui.this.partitionsJMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.helpJMenuItem) {
                LTOOLSgui.this.helpJMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.aboutJMenuItem) {
                LTOOLSgui.this.aboutJMenuItem_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.remoteJButton) {
                LTOOLSgui.this.remoteJButton_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.readOnlyJToggleButton) {
                LTOOLSgui.this.readOnlyJToggleButton_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.confirmDeleteJToggleButton) {
                LTOOLSgui.this.confirmDeleteJToggleButton_actionPerformed(actionEvent);
            } else if (object == LTOOLSgui.this.exitJButton) {
                LTOOLSgui.this.exitJButton_actionPerformed(actionEvent);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == LTOOLSgui.this) {
                LTOOLSgui.this.LTOOLSGui_WindowClosing(windowEvent);
            }
        }
    }
}

