/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ContextMenuTree
extends JPopupMenu
implements PopupMenuListener,
ActionListener {
    DirFilePane parent;
    JTree jTree;
    private String expandNodeLabel = "Expand Node";
    private String collapseNodeLabel = "Collapse Node";
    private String collapseAllLabel = "Collapse All";
    private String addDriveLabel = "Add Drive";
    private String removeDriveLabel = "Remove Drive";
    private String refreshNodeLabel = "Refresh Node";
    private String refreshLabel = "Refresh";
    JMenuItem expandNodeItem;
    JMenuItem collapseNodeItem;
    JMenuItem collapseAllItem;
    JMenuItem addDriveItem;
    JMenuItem removeDriveItem;
    JMenuItem refreshNodeItem;
    JMenuItem refreshItem;

    public ContextMenuTree(DirFilePane dirFilePane) {
        this.parent = dirFilePane;
        this.jTree = dirFilePane.getJTree();
        this.expandNodeItem = new JMenuItem(this.expandNodeLabel);
        this.collapseNodeItem = new JMenuItem(this.collapseNodeLabel);
        this.collapseAllItem = new JMenuItem(this.collapseAllLabel);
        this.addDriveItem = new JMenuItem(this.addDriveLabel);
        this.removeDriveItem = new JMenuItem(this.removeDriveLabel);
        this.refreshNodeItem = new JMenuItem(this.refreshNodeLabel);
        this.refreshItem = new JMenuItem(this.refreshLabel);
        this.add(this.expandNodeItem);
        this.expandNodeItem.addActionListener(this);
        this.add(this.collapseNodeItem);
        this.collapseNodeItem.addActionListener(this);
        this.add(this.collapseAllItem);
        this.collapseAllItem.addActionListener(this);
        this.addSeparator();
        this.add(this.addDriveItem);
        this.addDriveItem.addActionListener(this);
        this.add(this.removeDriveItem);
        this.removeDriveItem.addActionListener(this);
        this.addSeparator();
        this.add(this.refreshNodeItem);
        this.refreshNodeItem.addActionListener(this);
        this.add(this.refreshItem);
        this.refreshItem.addActionListener(this);
        this.setBorder(new BevelBorder(0));
        this.addPopupMenuListener(this);
    }

    public void enableAllMenuItemsForNode() {
        this.expandNodeItem.setEnabled(true);
        this.collapseNodeItem.setEnabled(true);
        this.collapseAllItem.setEnabled(false);
        this.addDriveItem.setEnabled(false);
        this.removeDriveItem.setEnabled(true);
        this.refreshNodeItem.setEnabled(true);
        this.refreshItem.setEnabled(false);
    }

    public void enableAllMenuItemsForTree() {
        this.expandNodeItem.setEnabled(false);
        this.collapseNodeItem.setEnabled(false);
        this.collapseAllItem.setEnabled(true);
        this.addDriveItem.setEnabled(true);
        this.removeDriveItem.setEnabled(false);
        this.refreshNodeItem.setEnabled(false);
        this.refreshItem.setEnabled(true);
    }

    public void enableAllMenuItems() {
        this.expandNodeItem.setEnabled(true);
        this.collapseNodeItem.setEnabled(true);
        this.collapseAllItem.setEnabled(true);
        this.addDriveItem.setEnabled(true);
        this.removeDriveItem.setEnabled(true);
        this.refreshNodeItem.setEnabled(true);
        this.refreshItem.setEnabled(true);
    }

    public void disableAllMenuItems() {
        this.expandNodeItem.setEnabled(false);
        this.collapseNodeItem.setEnabled(false);
        this.collapseAllItem.setEnabled(false);
        this.addDriveItem.setEnabled(false);
        this.removeDriveItem.setEnabled(false);
        this.refreshNodeItem.setEnabled(false);
        this.refreshItem.setEnabled(false);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DirFilePane.debugOutput("Popup menu item [" + actionEvent.getActionCommand() + "] was pressed.");
        if (actionEvent.getActionCommand().equals(this.expandNodeLabel)) {
            int n;
            if (this.jTree.getSelectionCount() == 1 && !this.jTree.isExpanded(n = this.jTree.getSelectionRows()[0])) {
                this.jTree.expandRow(n);
            }
        } else if (actionEvent.getActionCommand().equals(this.collapseNodeLabel)) {
            int n;
            if (this.jTree.getSelectionCount() == 1 && this.jTree.isExpanded(n = this.jTree.getSelectionRows()[0])) {
                this.jTree.collapseRow(n);
            }
        } else if (actionEvent.getActionCommand().equals(this.collapseAllLabel)) {
            for (int i = this.jTree.getRowCount(); i > 0; --i) {
                if (!this.jTree.isExpanded(i)) continue;
                this.jTree.collapseRow(i);
            }
        } else if (actionEvent.getActionCommand().equals(this.addDriveLabel)) {
            this.parent.addDrive();
        } else if (actionEvent.getActionCommand().equals(this.removeDriveLabel)) {
            this.parent.removeDrive();
        } else if (actionEvent.getActionCommand().equals(this.refreshNodeLabel)) {
            this.parent.refreshTreeNode();
        } else if (actionEvent.getActionCommand().equals(this.refreshLabel)) {
            if (this.parent.isLinux()) {
                this.parent.fillLinuxDirectoryTree();
            } else {
                this.parent.fillDosDirectoryTree();
            }
        }
    }
}

