/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.ImageIcon;

public class ListItemFile
implements Comparable {
    public static ImageIcon[] icons = new ImageIcon[]{new ImageIcon("images/FOLDER16x16.gif"), new ImageIcon("images/FILE16x16.gif"), new ImageIcon("images/FOLDERUP16x16.gif"), new ImageIcon("images/Word16x16.gif"), new ImageIcon("images/Access16x16.gif"), new ImageIcon("images/Excel16x16.gif"), new ImageIcon("images/Powerpoint16x16.gif"), new ImageIcon("images/ExeCom16x16.gif"), new ImageIcon("images/java16x16.gif"), new ImageIcon("images/winzip16x16.gif"), new ImageIcon("images/error16x16.gif"), new ImageIcon("images/html16x16.gif"), new ImageIcon("images/Link16x16.gif"), new ImageIcon("images/mp316x16.gif"), new ImageIcon("images/pdf16x16.gif"), new ImageIcon("images/avi16x16.gif"), new ImageIcon("images/Bitmap16x16.gif")};
    public static int ICON_FOLDER = 0;
    public static int ICON_FILE = 1;
    public static int ICON_FOLDERUP = 2;
    public static int ICON_WORD = 3;
    public static int ICON_ACCESS = 4;
    public static int ICON_EXCEL = 5;
    public static int ICON_POWERPOINT = 6;
    public static int ICON_EXE = 7;
    public static int ICON_JAVA = 8;
    public static int ICON_ZIP = 9;
    public static int ICON_ERROR = 10;
    public static int ICON_HTML = 11;
    public static int ICON_LINK = 12;
    public static int ICON_MP3 = 13;
    public static int ICON_PDF = 14;
    public static int ICON_AVI = 15;
    public static int ICON_BITMAP = 16;
    private String fileName;
    private LToolGuiTableIconData tableIconData;
    private boolean isDirectory;
    private boolean isLink;
    private boolean isError;
    private String directory;
    private String fullFilePath;
    private String fileSize;
    private String fileLastModified;
    private int fileIconIndex;
    private String linuxFileInfoString;

    public ListItemFile(String string) {
        this.fileName = string;
        if (this.fileName == null) {
            this.fileName = "ERROR";
        }
        this.isDirectory = false;
        this.isError = true;
        this.directory = "";
        this.fullFilePath = "";
        this.fileSize = "";
        this.fileLastModified = "";
        this.linuxFileInfoString = "";
        this.fileIconIndex = ICON_ERROR;
        this.tableIconData = new LToolGuiTableIconData(icons[this.fileIconIndex], this.fileName);
    }

    public ListItemFile(String string, boolean bl, String string2, String string3, String string4, String string5, String string6, int n) {
        this.fileName = string;
        this.isDirectory = bl;
        this.isError = false;
        this.directory = string2;
        this.fullFilePath = string3;
        this.fileSize = string4;
        this.fileLastModified = string5;
        this.linuxFileInfoString = string6;
        this.isLink = false;
        if (string6 != "" && string6.charAt(0) == 'l') {
            this.isLink = true;
        }
        this.fileIconIndex = n;
        if (bl) {
            if (!this.fileName.equals("..")) {
                this.fileIconIndex = ICON_FOLDER;
            }
        } else {
            this.fileIconIndex = this.isLink() ? ICON_LINK : (this.fileName.toLowerCase().endsWith(".doc") ? ICON_WORD : (this.fileName.toLowerCase().endsWith(".mdb") ? ICON_ACCESS : (this.fileName.toLowerCase().endsWith(".xls") ? ICON_EXCEL : (this.fileName.toLowerCase().endsWith(".ppt") ? ICON_POWERPOINT : (this.fileName.toLowerCase().endsWith(".exe") || this.fileName.toLowerCase().endsWith(".com") ? ICON_EXE : (this.fileName.toLowerCase().endsWith(".java") ? ICON_JAVA : (this.fileName.toLowerCase().endsWith(".zip") ? ICON_ZIP : (this.fileName.toLowerCase().endsWith(".html") || this.fileName.toLowerCase().endsWith(".htm") ? ICON_HTML : (this.fileName.toLowerCase().endsWith(".mp3") || this.fileName.toLowerCase().endsWith(".wav") ? ICON_MP3 : (this.fileName.toLowerCase().endsWith(".pdf") ? ICON_PDF : (this.fileName.toLowerCase().endsWith(".avi") || this.fileName.toLowerCase().endsWith(".mpg") ? ICON_AVI : (this.fileName.toLowerCase().endsWith(".bmp") || this.fileName.toLowerCase().endsWith(".jpg") || this.fileName.toLowerCase().endsWith(".gif") || this.fileName.toLowerCase().endsWith(".png") ? ICON_BITMAP : ICON_FILE))))))))))));
        }
        this.tableIconData = new LToolGuiTableIconData(icons[this.fileIconIndex], this.fileName);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getFileIconIndex() {
        return this.fileIconIndex;
    }

    public ImageIcon getImage(int n) {
        return icons[n];
    }

    public LToolGuiTableIconData getTableIconData() {
        return this.tableIconData;
    }

    public String getFullFilePath() {
        return this.fullFilePath;
    }

    public String getFileSize() {
        return this.fileSize;
    }

    public String getFileLastModified() {
        return this.fileLastModified;
    }

    public String getAccess() {
        if (this.linuxFileInfoString.equals("")) {
            return "";
        }
        return DirFilePane.getLdirField(this.linuxFileInfoString, 0);
    }

    public String getUserID() {
        if (this.linuxFileInfoString.equals("")) {
            return "";
        }
        return DirFilePane.getLdirField(this.linuxFileInfoString, 1);
    }

    public String getGroupID() {
        if (this.linuxFileInfoString.equals("")) {
            return "";
        }
        return DirFilePane.getLdirField(this.linuxFileInfoString, 2);
    }

    public String getFileTyp() {
        if (!this.isDirectory()) {
            String string = "";
            if (this.getFileName().lastIndexOf(".") > -1) {
                string = this.getFileName().substring(this.getFileName().lastIndexOf("."));
            }
            return string;
        }
        return "";
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isLink() {
        return this.isLink;
    }

    public boolean isError() {
        return this.isError;
    }

    public void setFullFilePath(String string) {
        this.fullFilePath = string;
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        if (object.getClass() != this.getClass()) {
            throw new ClassCastException();
        }
        ListItemFile listItemFile = (ListItemFile)object;
        if (this.linuxFileInfoString.equals("")) {
            return this.getFileName().toLowerCase().compareTo(listItemFile.getFileName().toLowerCase());
        }
        return this.getFileName().compareTo(listItemFile.getFileName());
    }

    public void printItem() {
        System.out.println("############################################################################");
        System.out.println("linuxFileInfoString : " + this.linuxFileInfoString);
        System.out.println("FileName            : " + this.getFileName());
        System.out.println("FullFilePath        : " + this.getFullFilePath());
        System.out.println("FileSize            : " + this.getFileSize());
        System.out.println("FileTyp             : " + this.getFileTyp());
        System.out.println("isDirectory         : " + this.isDirectory());
        System.out.println("isLink              : " + this.isLink());
        System.out.println("Access              : " + this.getAccess());
        System.out.println("FileIconIndex       : " + this.getFileIconIndex());
        System.out.println("FileLastModified    : " + this.getFileLastModified());
        System.out.println("GroupID             : " + this.getGroupID());
        System.out.println("UserID              : " + this.getUserID());
        System.out.println("############################################################################");
    }
}

