using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;

namespace FHTE.LTOOLS.GUI
{
	/// <summary>
	/// Form to add a drive to a Directorytree.
	/// </summary>
	public class AddDriveDialog : System.Windows.Forms.Form
	{
		#region Fields
        // ############################################################################################################
        // FIELDS
        // ############################################################################################################
		private System.Windows.Forms.Button buttonOK;
		private System.Windows.Forms.Button buttonCancel;
		private System.Windows.Forms.Label labelDevice;
		private System.Windows.Forms.Label labelDirectory;
		private System.Windows.Forms.TextBox textBoxDevice;
		private System.Windows.Forms.TextBox textBoxDirectory;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		#endregion

		#region Properties
        // ############################################################################################################
        // PROPERTIES
        // ############################################################################################################
		/// <summary>
		/// returns the value in the device-textbox
		/// </summary>
        public string Device
		{
			get { return textBoxDevice.Text ; }
		}
        /// <summary>
        /// returns the value in the directory-textbox
        /// </summary>
        public string Directory
		{
			get { return textBoxDirectory.Text ; }
		}
		#endregion

		#region Constructors
        // ############################################################################################################
        // CONSTRUCTORS
        // ############################################################################################################
		/// <summary>
		/// shows a dialog with standard-values for a device and a directory.
		/// </summary>
		/// <param name="isLinux">bool-value to set standard-values for Linux or DOS</param>
        public AddDriveDialog(bool isLinux)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			if (isLinux)
			{
				textBoxDevice.Text = "/dev/fd0" ;
				textBoxDirectory.Text = "/" ;
			}
			else
			{
				textBoxDevice.Text = "C:" ;
				textBoxDirectory.Text = Path.DirectorySeparatorChar.ToString() ;
			}
		}
		#endregion

		#region Methods
        // ############################################################################################################
        // METHODS
        // ############################################################################################################
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
		    System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(AddDriveDialog));
		    this.buttonOK = new System.Windows.Forms.Button();
		    this.buttonCancel = new System.Windows.Forms.Button();
		    this.labelDevice = new System.Windows.Forms.Label();
		    this.labelDirectory = new System.Windows.Forms.Label();
		    this.textBoxDevice = new System.Windows.Forms.TextBox();
		    this.textBoxDirectory = new System.Windows.Forms.TextBox();
		    this.SuspendLayout();
		    // 
		    // buttonOK
		    // 
		    this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
		    this.buttonOK.Location = new System.Drawing.Point(33, 109);
		    this.buttonOK.Name = "buttonOK";
		    this.buttonOK.Size = new System.Drawing.Size(128, 29);
		    this.buttonOK.TabIndex = 0;
		    this.buttonOK.Text = "OK";
		    // 
		    // buttonCancel
		    // 
		    this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
		    this.buttonCancel.Location = new System.Drawing.Point(207, 109);
		    this.buttonCancel.Name = "buttonCancel";
		    this.buttonCancel.Size = new System.Drawing.Size(128, 29);
		    this.buttonCancel.TabIndex = 1;
		    this.buttonCancel.Text = "Cancel";
		    // 
		    // labelDevice
		    // 
		    this.labelDevice.Location = new System.Drawing.Point(10, 20);
		    this.labelDevice.Name = "labelDevice";
		    this.labelDevice.Size = new System.Drawing.Size(82, 19);
		    this.labelDevice.TabIndex = 2;
		    this.labelDevice.Text = "Device:";
		    // 
		    // labelDirectory
		    // 
		    this.labelDirectory.Location = new System.Drawing.Point(10, 59);
		    this.labelDirectory.Name = "labelDirectory";
		    this.labelDirectory.Size = new System.Drawing.Size(72, 20);
		    this.labelDirectory.TabIndex = 3;
		    this.labelDirectory.Text = "Directory:";
		    // 
		    // textBoxDevice
		    // 
		    this.textBoxDevice.Location = new System.Drawing.Point(92, 20);
		    this.textBoxDevice.Name = "textBoxDevice";
		    this.textBoxDevice.Size = new System.Drawing.Size(246, 22);
		    this.textBoxDevice.TabIndex = 4;
		    this.textBoxDevice.Text = "/dev/fd0";
		    // 
		    // textBoxDirectory
		    // 
		    this.textBoxDirectory.Location = new System.Drawing.Point(92, 59);
		    this.textBoxDirectory.Name = "textBoxDirectory";
		    this.textBoxDirectory.Size = new System.Drawing.Size(246, 22);
		    this.textBoxDirectory.TabIndex = 5;
		    this.textBoxDirectory.Text = "/";
		    // 
		    // AddDriveDialog
		    // 
		    this.AcceptButton = this.buttonOK;
		    this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
		    this.CancelButton = this.buttonCancel;
		    this.ClientSize = new System.Drawing.Size(384, 160);
		    this.Controls.AddRange(new System.Windows.Forms.Control[] {
										  this.textBoxDirectory,
										  this.textBoxDevice,
										  this.labelDirectory,
										  this.labelDevice,
										  this.buttonCancel,
										  this.buttonOK});
		    this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
		    this.MaximumSize = new System.Drawing.Size(400, 300);
		    this.MinimumSize = new System.Drawing.Size(296, 152);
		    this.Name = "AddDriveDialog";
		    this.ShowInTaskbar = false;
		    this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
		    this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
		    this.Text = "LTOOLS Add Drive";
		    this.ResumeLayout(false);

		}
		#endregion

		#endregion
	}
}
